/*
 * Decompiled with CFR 0.152.
 */
package android.media.browse;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ParceledListSlice;
import android.media.MediaDescription;
import android.media.browse.MediaBrowserUtils;
import android.media.session.MediaSession;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.service.media.IMediaBrowserService;
import android.service.media.IMediaBrowserServiceCallbacks;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MediaBrowser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaBrowser";
    private static boolean DBG = false;
    public static String EXTRA_PAGE = "android.media.browse.extra.PAGE";
    public static String EXTRA_PAGE_SIZE = "android.media.browse.extra.PAGE_SIZE";
    private static int CONNECT_STATE_DISCONNECTING = 0;
    private static int CONNECT_STATE_DISCONNECTED = 1;
    private static int CONNECT_STATE_CONNECTING = 2;
    private static int CONNECT_STATE_CONNECTED = 3;
    private static int CONNECT_STATE_SUSPENDED = 4;
    private Context mContext;
    private ComponentName mServiceComponent;
    private ConnectionCallback mCallback;
    private Bundle mRootHints;
    private Handler mHandler;
    private ArrayMap<String, Subscription> mSubscriptions;
    private volatile int mState;
    private volatile String mRootId;
    private volatile MediaSession.Token mMediaSessionToken;
    private volatile Bundle mExtras;
    private MediaServiceConnection mServiceConnection;
    private IMediaBrowserService mServiceBinder;
    private IMediaBrowserServiceCallbacks mServiceCallbacks;

    private void $$robo$$android_media_browse_MediaBrowser$__constructor__(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
        this.mHandler = new Handler();
        this.mSubscriptions = new ArrayMap();
        this.mState = 1;
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (serviceComponent == null) {
            throw new IllegalArgumentException("service component must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("connection callback must not be null");
        }
        this.mContext = context;
        this.mServiceComponent = serviceComponent;
        this.mCallback = callback;
        this.mRootHints = rootHints == null ? null : new Bundle(rootHints);
    }

    private final void $$robo$$android_media_browse_MediaBrowser$connect() {
        if (this.mState != 0 && this.mState != 1) {
            throw new IllegalStateException("connect() called while neither disconnecting nor disconnected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        this.mState = 2;
        this.mHandler.post(new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_1$__constructor__(MediaBrowser this$0) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_1$run() {
                if (this.this$0.mState == 0) {
                    return;
                }
                this.this$0.mState = 2;
                if (this.this$0.mServiceBinder != null) {
                    throw new RuntimeException("mServiceBinder should be null. Instead it is " + this.this$0.mServiceBinder);
                }
                if (this.this$0.mServiceCallbacks != null) {
                    throw new RuntimeException("mServiceCallbacks should be null. Instead it is " + this.this$0.mServiceCallbacks);
                }
                Intent intent = new Intent("android.media.browse.MediaBrowserService");
                intent.setComponent(this.this$0.mServiceComponent);
                this.this$0.mServiceConnection = new MediaServiceConnection(this.this$0);
                boolean bound = false;
                try {
                    bound = this.this$0.mContext.bindService(intent, this.this$0.mServiceConnection, 1);
                }
                catch (Exception ex) {
                    Log.e("MediaBrowser", "Failed binding to service " + this.this$0.mServiceComponent);
                }
                if (!bound) {
                    this.this$0.forceCloseConnection();
                    this.this$0.mCallback.onConnectionFailed();
                }
            }

            private void __constructor__(MediaBrowser mediaBrowser) {
                this.$$robo$$android_media_browse_MediaBrowser_1$__constructor__(mediaBrowser);
            }
            {
                this.this$0 = mediaBrowser;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_1$__constructor__(android.media.browse.MediaBrowser ), 0, this, mediaBrowser);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_browse_MediaBrowser$disconnect() {
        this.mState = 0;
        this.mHandler.post(new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_2$__constructor__(MediaBrowser this$0) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_2$run() {
                if (this.this$0.mServiceCallbacks != null) {
                    try {
                        this.this$0.mServiceBinder.disconnect(this.this$0.mServiceCallbacks);
                    }
                    catch (RemoteException ex) {
                        Log.w("MediaBrowser", "RemoteException during connect for " + this.this$0.mServiceComponent);
                    }
                }
                int state = this.this$0.mState;
                this.this$0.forceCloseConnection();
                if (state != 0) {
                    this.this$0.mState = state;
                }
            }

            private void __constructor__(MediaBrowser mediaBrowser) {
                this.$$robo$$android_media_browse_MediaBrowser_2$__constructor__(mediaBrowser);
            }
            {
                this.this$0 = mediaBrowser;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_2$__constructor__(android.media.browse.MediaBrowser ), 0, this, mediaBrowser);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_browse_MediaBrowser$forceCloseConnection() {
        if (this.mServiceConnection != null) {
            try {
                this.mContext.unbindService(this.mServiceConnection);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.mState = 1;
        this.mServiceConnection = null;
        this.mServiceBinder = null;
        this.mServiceCallbacks = null;
        this.mRootId = null;
        this.mMediaSessionToken = null;
    }

    private final boolean $$robo$$android_media_browse_MediaBrowser$isConnected() {
        return this.mState == 3;
    }

    private final ComponentName $$robo$$android_media_browse_MediaBrowser$getServiceComponent() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getServiceComponent() called while not connected (state=" + this.mState + ")");
        }
        return this.mServiceComponent;
    }

    private final String $$robo$$android_media_browse_MediaBrowser$getRoot() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getRoot() called while not connected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        return this.mRootId;
    }

    private final Bundle $$robo$$android_media_browse_MediaBrowser$getExtras() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getExtras() called while not connected (state=" + MediaBrowser.getStateLabel(this.mState) + ")");
        }
        return this.mExtras;
    }

    private final MediaSession.Token $$robo$$android_media_browse_MediaBrowser$getSessionToken() {
        if (!this.isConnected()) {
            throw new IllegalStateException("getSessionToken() called while not connected (state=" + this.mState + ")");
        }
        return this.mMediaSessionToken;
    }

    private final void $$robo$$android_media_browse_MediaBrowser$subscribe(String parentId, SubscriptionCallback callback) {
        this.subscribeInternal(parentId, null, callback);
    }

    private final void $$robo$$android_media_browse_MediaBrowser$subscribe(String parentId, Bundle options, SubscriptionCallback callback) {
        if (options == null) {
            throw new IllegalArgumentException("options cannot be null");
        }
        this.subscribeInternal(parentId, new Bundle(options), callback);
    }

    private final void $$robo$$android_media_browse_MediaBrowser$unsubscribe(String parentId) {
        this.unsubscribeInternal(parentId, null);
    }

    private final void $$robo$$android_media_browse_MediaBrowser$unsubscribe(String parentId, SubscriptionCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.unsubscribeInternal(parentId, callback);
    }

    private final void $$robo$$android_media_browse_MediaBrowser$getItem(String mediaId, ItemCallback cb) {
        if (TextUtils.isEmpty(mediaId)) {
            throw new IllegalArgumentException("mediaId cannot be empty.");
        }
        if (cb == null) {
            throw new IllegalArgumentException("cb cannot be null.");
        }
        if (this.mState != 3) {
            Log.i("MediaBrowser", "Not connected, unable to retrieve the MediaItem.");
            this.mHandler.post(new Runnable(this, cb, mediaId){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ItemCallback val$cb;
                /* synthetic */ String val$mediaId;
                /* synthetic */ MediaBrowser this$0;

                private void $$robo$$android_media_browse_MediaBrowser_3$__constructor__(MediaBrowser this$0, ItemCallback itemCallback, String string2) {
                }

                private final void $$robo$$android_media_browse_MediaBrowser_3$run() {
                    this.val$cb.onError(this.val$mediaId);
                }

                private void __constructor__(MediaBrowser mediaBrowser, ItemCallback itemCallback, String string2) {
                    this.$$robo$$android_media_browse_MediaBrowser_3$__constructor__(mediaBrowser, itemCallback, string2);
                }
                {
                    this.this$0 = mediaBrowser;
                    this.val$cb = itemCallback;
                    this.val$mediaId = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_3$__constructor__(android.media.browse.MediaBrowser android.media.browse.MediaBrowser$ItemCallback java.lang.String ), 0, this, mediaBrowser, itemCallback, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            return;
        }
        ShadowedObject receiver = new ShadowedObject(this, this.mHandler, cb, mediaId){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ItemCallback val$cb;
            /* synthetic */ String val$mediaId;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_4$__constructor__(MediaBrowser this$0, Handler x0, ItemCallback itemCallback, String string2) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_4$onReceiveResult(int resultCode, Bundle resultData) {
                if (!this.this$0.isConnected()) {
                    return;
                }
                if (resultCode != 0 || resultData == null || !resultData.containsKey("media_item")) {
                    this.val$cb.onError(this.val$mediaId);
                    return;
                }
                Object item = resultData.getParcelable("media_item");
                if (item != null && !(item instanceof MediaItem)) {
                    this.val$cb.onError(this.val$mediaId);
                    return;
                }
                this.val$cb.onItemLoaded((MediaItem)item);
            }

            private void __constructor__(MediaBrowser mediaBrowser, Handler handler, ItemCallback itemCallback, String string2) {
                this.$$robo$$android_media_browse_MediaBrowser_4$__constructor__(mediaBrowser, handler, itemCallback, string2);
            }
            {
                this.this$0 = mediaBrowser;
                this.val$cb = itemCallback;
                this.val$mediaId = string2;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_4$__constructor__(android.media.browse.MediaBrowser android.os.Handler android.media.browse.MediaBrowser$ItemCallback java.lang.String ), 0, this, mediaBrowser, handler, itemCallback, string2);
            }

            @Override
            protected void onReceiveResult(int n, Bundle bundle) {
                InvokeDynamicSupport.bootstrap("onReceiveResult", $$robo$$android_media_browse_MediaBrowser_4$onReceiveResult(int android.os.Bundle ), 0, this, n, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            this.mServiceBinder.getMediaItem(mediaId, (ResultReceiver)receiver, this.mServiceCallbacks);
        }
        catch (RemoteException e) {
            Log.i("MediaBrowser", "Remote error getting media item.");
            this.mHandler.post(new Runnable(this, cb, mediaId){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ItemCallback val$cb;
                /* synthetic */ String val$mediaId;
                /* synthetic */ MediaBrowser this$0;

                private void $$robo$$android_media_browse_MediaBrowser_5$__constructor__(MediaBrowser this$0, ItemCallback itemCallback, String string2) {
                }

                private final void $$robo$$android_media_browse_MediaBrowser_5$run() {
                    this.val$cb.onError(this.val$mediaId);
                }

                private void __constructor__(MediaBrowser mediaBrowser, ItemCallback itemCallback, String string2) {
                    this.$$robo$$android_media_browse_MediaBrowser_5$__constructor__(mediaBrowser, itemCallback, string2);
                }
                {
                    this.this$0 = mediaBrowser;
                    this.val$cb = itemCallback;
                    this.val$mediaId = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_5$__constructor__(android.media.browse.MediaBrowser android.media.browse.MediaBrowser$ItemCallback java.lang.String ), 0, this, mediaBrowser, itemCallback, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_5$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_media_browse_MediaBrowser$subscribeInternal(String parentId, Bundle options, SubscriptionCallback callback) {
        if (TextUtils.isEmpty(parentId)) {
            throw new IllegalArgumentException("parentId cannot be empty.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Subscription sub = this.mSubscriptions.get(parentId);
        if (sub == null) {
            sub = new Subscription();
            this.mSubscriptions.put(parentId, sub);
        }
        sub.putCallback(this.mContext, options, callback);
        if (this.isConnected()) {
            try {
                if (options == null) {
                    this.mServiceBinder.addSubscriptionDeprecated(parentId, this.mServiceCallbacks);
                }
                this.mServiceBinder.addSubscription(parentId, callback.mToken, options, this.mServiceCallbacks);
            }
            catch (RemoteException ex) {
                Log.d("MediaBrowser", "addSubscription failed with RemoteException parentId=" + parentId);
            }
        }
    }

    private final void $$robo$$android_media_browse_MediaBrowser$unsubscribeInternal(String parentId, SubscriptionCallback callback) {
        if (TextUtils.isEmpty(parentId)) {
            throw new IllegalArgumentException("parentId cannot be empty.");
        }
        Subscription sub = this.mSubscriptions.get(parentId);
        if (sub == null) {
            return;
        }
        try {
            if (callback == null) {
                if (this.isConnected()) {
                    this.mServiceBinder.removeSubscriptionDeprecated(parentId, this.mServiceCallbacks);
                    this.mServiceBinder.removeSubscription(parentId, null, this.mServiceCallbacks);
                }
            } else {
                List<SubscriptionCallback> callbacks = sub.getCallbacks();
                List<Bundle> optionsList = sub.getOptionsList();
                for (int i = callbacks.size() - 1; i >= 0; --i) {
                    if (callbacks.get(i) != callback) continue;
                    if (this.isConnected()) {
                        this.mServiceBinder.removeSubscription(parentId, callback.mToken, this.mServiceCallbacks);
                    }
                    callbacks.remove(i);
                    optionsList.remove(i);
                }
            }
        }
        catch (RemoteException ex) {
            Log.d("MediaBrowser", "removeSubscription failed with RemoteException parentId=" + parentId);
        }
        if (sub.isEmpty() || callback == null) {
            this.mSubscriptions.remove(parentId);
        }
    }

    private static final String $$robo$$android_media_browse_MediaBrowser$getStateLabel(int state) {
        switch (state) {
            case 0: {
                return "CONNECT_STATE_DISCONNECTING";
            }
            case 1: {
                return "CONNECT_STATE_DISCONNECTED";
            }
            case 2: {
                return "CONNECT_STATE_CONNECTING";
            }
            case 3: {
                return "CONNECT_STATE_CONNECTED";
            }
            case 4: {
                return "CONNECT_STATE_SUSPENDED";
            }
        }
        return "UNKNOWN/" + state;
    }

    private final void $$robo$$android_media_browse_MediaBrowser$onServiceConnected(IMediaBrowserServiceCallbacks callback, String root, MediaSession.Token session, Bundle extra) {
        this.mHandler.post(new Runnable(this, callback, root, session, extra){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IMediaBrowserServiceCallbacks val$callback;
            /* synthetic */ String val$root;
            /* synthetic */ MediaSession.Token val$session;
            /* synthetic */ Bundle val$extra;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_6$__constructor__(MediaBrowser this$0, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, MediaSession.Token token, Bundle bundle) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_6$run() {
                if (!this.this$0.isCurrent(this.val$callback, "onConnect")) {
                    return;
                }
                if (this.this$0.mState != 2) {
                    Log.w("MediaBrowser", "onConnect from service while mState=" + MediaBrowser.getStateLabel(this.this$0.mState) + "... ignoring");
                    return;
                }
                this.this$0.mRootId = this.val$root;
                this.this$0.mMediaSessionToken = this.val$session;
                this.this$0.mExtras = this.val$extra;
                this.this$0.mState = 3;
                this.this$0.mCallback.onConnected();
                for (Map.Entry subscriptionEntry : this.this$0.mSubscriptions.entrySet()) {
                    String id2 = (String)subscriptionEntry.getKey();
                    Subscription sub = (Subscription)subscriptionEntry.getValue();
                    List<SubscriptionCallback> callbackList = sub.getCallbacks();
                    List<Bundle> optionsList = sub.getOptionsList();
                    for (int i = 0; i < callbackList.size(); ++i) {
                        try {
                            this.this$0.mServiceBinder.addSubscription(id2, callbackList.get((int)i).mToken, optionsList.get(i), this.this$0.mServiceCallbacks);
                            continue;
                        }
                        catch (RemoteException ex) {
                            Log.d("MediaBrowser", "addSubscription failed with RemoteException parentId=" + id2);
                        }
                    }
                }
            }

            private void __constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, MediaSession.Token token, Bundle bundle) {
                this.$$robo$$android_media_browse_MediaBrowser_6$__constructor__(mediaBrowser, iMediaBrowserServiceCallbacks, string2, token, bundle);
            }
            {
                this.this$0 = mediaBrowser;
                this.val$callback = iMediaBrowserServiceCallbacks;
                this.val$root = string2;
                this.val$session = token;
                this.val$extra = bundle;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_6$__constructor__(android.media.browse.MediaBrowser android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.media.session.MediaSession$Token android.os.Bundle ), 0, this, mediaBrowser, iMediaBrowserServiceCallbacks, string2, token, bundle);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_6$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_browse_MediaBrowser$onConnectionFailed(IMediaBrowserServiceCallbacks callback) {
        this.mHandler.post(new Runnable(this, callback){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IMediaBrowserServiceCallbacks val$callback;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_7$__constructor__(MediaBrowser this$0, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_7$run() {
                Log.e("MediaBrowser", "onConnectFailed for " + this.this$0.mServiceComponent);
                if (!this.this$0.isCurrent(this.val$callback, "onConnectFailed")) {
                    return;
                }
                if (this.this$0.mState != 2) {
                    Log.w("MediaBrowser", "onConnect from service while mState=" + MediaBrowser.getStateLabel(this.this$0.mState) + "... ignoring");
                    return;
                }
                this.this$0.forceCloseConnection();
                this.this$0.mCallback.onConnectionFailed();
            }

            private void __constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
                this.$$robo$$android_media_browse_MediaBrowser_7$__constructor__(mediaBrowser, iMediaBrowserServiceCallbacks);
            }
            {
                this.this$0 = mediaBrowser;
                this.val$callback = iMediaBrowserServiceCallbacks;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_7$__constructor__(android.media.browse.MediaBrowser android.service.media.IMediaBrowserServiceCallbacks ), 0, this, mediaBrowser, iMediaBrowserServiceCallbacks);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_7$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_media_browse_MediaBrowser$onLoadChildren(IMediaBrowserServiceCallbacks callback, String parentId, ParceledListSlice list, Bundle options) {
        this.mHandler.post(new Runnable(this, callback, parentId, options, list){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IMediaBrowserServiceCallbacks val$callback;
            /* synthetic */ String val$parentId;
            /* synthetic */ Bundle val$options;
            /* synthetic */ ParceledListSlice val$list;
            /* synthetic */ MediaBrowser this$0;

            private void $$robo$$android_media_browse_MediaBrowser_8$__constructor__(MediaBrowser this$0, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, Bundle bundle, ParceledListSlice parceledListSlice) {
            }

            private final void $$robo$$android_media_browse_MediaBrowser_8$run() {
                SubscriptionCallback subscriptionCallback;
                if (!this.this$0.isCurrent(this.val$callback, "onLoadChildren")) {
                    return;
                }
                Subscription subscription = (Subscription)this.this$0.mSubscriptions.get(this.val$parentId);
                if (subscription != null && (subscriptionCallback = subscription.getCallback(this.this$0.mContext, this.val$options)) != null) {
                    List data;
                    List list = data = this.val$list == null ? null : this.val$list.getList();
                    if (this.val$options == null) {
                        if (data == null) {
                            subscriptionCallback.onError(this.val$parentId);
                        } else {
                            subscriptionCallback.onChildrenLoaded(this.val$parentId, data);
                        }
                    } else if (data == null) {
                        subscriptionCallback.onError(this.val$parentId, this.val$options);
                    } else {
                        subscriptionCallback.onChildrenLoaded(this.val$parentId, data, this.val$options);
                    }
                    return;
                }
            }

            private void __constructor__(MediaBrowser mediaBrowser, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, Bundle bundle, ParceledListSlice parceledListSlice) {
                this.$$robo$$android_media_browse_MediaBrowser_8$__constructor__(mediaBrowser, iMediaBrowserServiceCallbacks, string2, bundle, parceledListSlice);
            }
            {
                this.this$0 = mediaBrowser;
                this.val$callback = iMediaBrowserServiceCallbacks;
                this.val$parentId = string2;
                this.val$options = bundle;
                this.val$list = parceledListSlice;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_8$__constructor__(android.media.browse.MediaBrowser android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.os.Bundle android.content.pm.ParceledListSlice ), 0, this, mediaBrowser, iMediaBrowserServiceCallbacks, string2, bundle, parceledListSlice);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_8$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final boolean $$robo$$android_media_browse_MediaBrowser$isCurrent(IMediaBrowserServiceCallbacks callback, String funcName) {
        if (this.mServiceCallbacks != callback || this.mState == 0 || this.mState == 1) {
            if (this.mState != 0 && this.mState != 1) {
                Log.i("MediaBrowser", funcName + " for " + this.mServiceComponent + " with mServiceConnection=" + this.mServiceCallbacks + " this=" + this);
            }
            return false;
        }
        return true;
    }

    private final ServiceCallbacks $$robo$$android_media_browse_MediaBrowser$getNewServiceCallbacks() {
        return new ServiceCallbacks(this);
    }

    private final void $$robo$$android_media_browse_MediaBrowser$dump() {
        Log.d("MediaBrowser", "MediaBrowser...");
        Log.d("MediaBrowser", "  mServiceComponent=" + this.mServiceComponent);
        Log.d("MediaBrowser", "  mCallback=" + this.mCallback);
        Log.d("MediaBrowser", "  mRootHints=" + this.mRootHints);
        Log.d("MediaBrowser", "  mState=" + MediaBrowser.getStateLabel(this.mState));
        Log.d("MediaBrowser", "  mServiceConnection=" + this.mServiceConnection);
        Log.d("MediaBrowser", "  mServiceBinder=" + this.mServiceBinder);
        Log.d("MediaBrowser", "  mServiceCallbacks=" + this.mServiceCallbacks);
        Log.d("MediaBrowser", "  mRootId=" + this.mRootId);
        Log.d("MediaBrowser", "  mMediaSessionToken=" + this.mMediaSessionToken);
    }

    private void __constructor__(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
        this.$$robo$$android_media_browse_MediaBrowser$__constructor__(context, componentName, connectionCallback, bundle);
    }

    public MediaBrowser(Context context, ComponentName componentName, ConnectionCallback connectionCallback, Bundle bundle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser$__constructor__(android.content.Context android.content.ComponentName android.media.browse.MediaBrowser$ConnectionCallback android.os.Bundle ), 0, this, context, componentName, connectionCallback, bundle);
    }

    public void connect() {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_media_browse_MediaBrowser$connect(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_media_browse_MediaBrowser$disconnect(), 0, this);
    }

    private void forceCloseConnection() {
        InvokeDynamicSupport.bootstrap("forceCloseConnection", $$robo$$android_media_browse_MediaBrowser$forceCloseConnection(), 0, this);
    }

    public boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_media_browse_MediaBrowser$isConnected(), 0, this);
    }

    public ComponentName getServiceComponent() {
        return InvokeDynamicSupport.bootstrap("getServiceComponent", $$robo$$android_media_browse_MediaBrowser$getServiceComponent(), 0, this);
    }

    public String getRoot() {
        return InvokeDynamicSupport.bootstrap("getRoot", $$robo$$android_media_browse_MediaBrowser$getRoot(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_media_browse_MediaBrowser$getExtras(), 0, this);
    }

    public MediaSession.Token getSessionToken() {
        return InvokeDynamicSupport.bootstrap("getSessionToken", $$robo$$android_media_browse_MediaBrowser$getSessionToken(), 0, this);
    }

    public void subscribe(String string2, SubscriptionCallback subscriptionCallback) {
        InvokeDynamicSupport.bootstrap("subscribe", $$robo$$android_media_browse_MediaBrowser$subscribe(java.lang.String android.media.browse.MediaBrowser$SubscriptionCallback ), 0, this, string2, subscriptionCallback);
    }

    public void subscribe(String string2, Bundle bundle, SubscriptionCallback subscriptionCallback) {
        InvokeDynamicSupport.bootstrap("subscribe", $$robo$$android_media_browse_MediaBrowser$subscribe(java.lang.String android.os.Bundle android.media.browse.MediaBrowser$SubscriptionCallback ), 0, this, string2, bundle, subscriptionCallback);
    }

    public void unsubscribe(String string2) {
        InvokeDynamicSupport.bootstrap("unsubscribe", $$robo$$android_media_browse_MediaBrowser$unsubscribe(java.lang.String ), 0, this, string2);
    }

    public void unsubscribe(String string2, SubscriptionCallback subscriptionCallback) {
        InvokeDynamicSupport.bootstrap("unsubscribe", $$robo$$android_media_browse_MediaBrowser$unsubscribe(java.lang.String android.media.browse.MediaBrowser$SubscriptionCallback ), 0, this, string2, subscriptionCallback);
    }

    public void getItem(String string2, ItemCallback itemCallback) {
        InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_media_browse_MediaBrowser$getItem(java.lang.String android.media.browse.MediaBrowser$ItemCallback ), 0, this, string2, itemCallback);
    }

    private void subscribeInternal(String string2, Bundle bundle, SubscriptionCallback subscriptionCallback) {
        InvokeDynamicSupport.bootstrap("subscribeInternal", $$robo$$android_media_browse_MediaBrowser$subscribeInternal(java.lang.String android.os.Bundle android.media.browse.MediaBrowser$SubscriptionCallback ), 0, this, string2, bundle, subscriptionCallback);
    }

    private void unsubscribeInternal(String string2, SubscriptionCallback subscriptionCallback) {
        InvokeDynamicSupport.bootstrap("unsubscribeInternal", $$robo$$android_media_browse_MediaBrowser$unsubscribeInternal(java.lang.String android.media.browse.MediaBrowser$SubscriptionCallback ), 0, this, string2, subscriptionCallback);
    }

    private static String getStateLabel(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getStateLabel", $$robo$$android_media_browse_MediaBrowser$getStateLabel(int ), 0, (int)n);
    }

    private void onServiceConnected(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, MediaSession.Token token, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_media_browse_MediaBrowser$onServiceConnected(android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.media.session.MediaSession$Token android.os.Bundle ), 0, this, iMediaBrowserServiceCallbacks, string2, token, bundle);
    }

    private void onConnectionFailed(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
        InvokeDynamicSupport.bootstrap("onConnectionFailed", $$robo$$android_media_browse_MediaBrowser$onConnectionFailed(android.service.media.IMediaBrowserServiceCallbacks ), 0, this, iMediaBrowserServiceCallbacks);
    }

    private void onLoadChildren(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, ParceledListSlice parceledListSlice, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onLoadChildren", $$robo$$android_media_browse_MediaBrowser$onLoadChildren(android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.content.pm.ParceledListSlice android.os.Bundle ), 0, this, iMediaBrowserServiceCallbacks, string2, parceledListSlice, bundle);
    }

    private boolean isCurrent(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCurrent", $$robo$$android_media_browse_MediaBrowser$isCurrent(android.service.media.IMediaBrowserServiceCallbacks java.lang.String ), 0, this, iMediaBrowserServiceCallbacks, string2);
    }

    private ServiceCallbacks getNewServiceCallbacks() {
        return InvokeDynamicSupport.bootstrap("getNewServiceCallbacks", $$robo$$android_media_browse_MediaBrowser$getNewServiceCallbacks(), 0, this);
    }

    void dump() {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_media_browse_MediaBrowser$dump(), 0, this);
    }

    public /* synthetic */ MediaBrowser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaBrowser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Subscription
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private List<SubscriptionCallback> mCallbacks;
        private List<Bundle> mOptionsList;

        private void $$robo$$android_media_browse_MediaBrowser_Subscription$__constructor__() {
            this.mCallbacks = new ArrayList<SubscriptionCallback>();
            this.mOptionsList = new ArrayList<Bundle>();
        }

        private final boolean $$robo$$android_media_browse_MediaBrowser_Subscription$isEmpty() {
            return this.mCallbacks.isEmpty();
        }

        private final List<Bundle> $$robo$$android_media_browse_MediaBrowser_Subscription$getOptionsList() {
            return this.mOptionsList;
        }

        private final List<SubscriptionCallback> $$robo$$android_media_browse_MediaBrowser_Subscription$getCallbacks() {
            return this.mCallbacks;
        }

        private final SubscriptionCallback $$robo$$android_media_browse_MediaBrowser_Subscription$getCallback(Context context, Bundle options) {
            if (options != null) {
                options.setClassLoader(context.getClassLoader());
            }
            for (int i = 0; i < this.mOptionsList.size(); ++i) {
                if (!MediaBrowserUtils.areSameOptions(this.mOptionsList.get(i), options)) continue;
                return this.mCallbacks.get(i);
            }
            return null;
        }

        private final void $$robo$$android_media_browse_MediaBrowser_Subscription$putCallback(Context context, Bundle options, SubscriptionCallback callback) {
            if (options != null) {
                options.setClassLoader(context.getClassLoader());
            }
            for (int i = 0; i < this.mOptionsList.size(); ++i) {
                if (!MediaBrowserUtils.areSameOptions(this.mOptionsList.get(i), options)) continue;
                this.mCallbacks.set(i, callback);
                return;
            }
            this.mCallbacks.add(callback);
            this.mOptionsList.add(options);
        }

        private void __constructor__() {
            this.$$robo$$android_media_browse_MediaBrowser_Subscription$__constructor__();
        }

        public Subscription() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_Subscription$__constructor__(), 0, this);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_media_browse_MediaBrowser_Subscription$isEmpty(), 0, this);
        }

        public List<Bundle> getOptionsList() {
            return InvokeDynamicSupport.bootstrap("getOptionsList", $$robo$$android_media_browse_MediaBrowser_Subscription$getOptionsList(), 0, this);
        }

        public List<SubscriptionCallback> getCallbacks() {
            return InvokeDynamicSupport.bootstrap("getCallbacks", $$robo$$android_media_browse_MediaBrowser_Subscription$getCallbacks(), 0, this);
        }

        public SubscriptionCallback getCallback(Context context, Bundle bundle) {
            return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_media_browse_MediaBrowser_Subscription$getCallback(android.content.Context android.os.Bundle ), 0, this, context, bundle);
        }

        public void putCallback(Context context, Bundle bundle, SubscriptionCallback subscriptionCallback) {
            InvokeDynamicSupport.bootstrap("putCallback", $$robo$$android_media_browse_MediaBrowser_Subscription$putCallback(android.content.Context android.os.Bundle android.media.browse.MediaBrowser$SubscriptionCallback ), 0, this, context, bundle, subscriptionCallback);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Subscription)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ServiceCallbacks
    extends IMediaBrowserServiceCallbacks.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<MediaBrowser> mMediaBrowser;

        private void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$__constructor__(MediaBrowser mediaBrowser) {
            this.mMediaBrowser = new WeakReference<MediaBrowser>(mediaBrowser);
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onConnect(String root, MediaSession.Token session, Bundle extras) {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onServiceConnected(this, root, session, extras);
            }
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onConnectFailed() {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onConnectionFailed(this);
            }
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onLoadChildren(String parentId, ParceledListSlice list) {
            this.onLoadChildrenWithOptions(parentId, list, null);
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onLoadChildrenWithOptions(String parentId, ParceledListSlice list, Bundle options) {
            MediaBrowser mediaBrowser = (MediaBrowser)this.mMediaBrowser.get();
            if (mediaBrowser != null) {
                mediaBrowser.onLoadChildren(this, parentId, list, options);
            }
        }

        private void __constructor__(MediaBrowser mediaBrowser) {
            this.$$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$__constructor__(mediaBrowser);
        }

        public ServiceCallbacks(MediaBrowser mediaBrowser) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$__constructor__(android.media.browse.MediaBrowser ), 0, this, mediaBrowser);
        }

        @Override
        public void onConnect(String string2, MediaSession.Token token, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onConnect", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onConnect(java.lang.String android.media.session.MediaSession$Token android.os.Bundle ), 0, this, string2, token, bundle);
        }

        @Override
        public void onConnectFailed() {
            InvokeDynamicSupport.bootstrap("onConnectFailed", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onConnectFailed(), 0, this);
        }

        @Override
        public void onLoadChildren(String string2, ParceledListSlice parceledListSlice) {
            InvokeDynamicSupport.bootstrap("onLoadChildren", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onLoadChildren(java.lang.String android.content.pm.ParceledListSlice ), 0, this, string2, parceledListSlice);
        }

        @Override
        public void onLoadChildrenWithOptions(String string2, ParceledListSlice parceledListSlice, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onLoadChildrenWithOptions", $$robo$$android_media_browse_MediaBrowser_ServiceCallbacks$onLoadChildrenWithOptions(java.lang.String android.content.pm.ParceledListSlice android.os.Bundle ), 0, this, string2, parceledListSlice, bundle);
        }

        public /* synthetic */ ServiceCallbacks() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceCallbacks)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MediaServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaBrowser this$0;

        private void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(MediaBrowser mediaBrowser) {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$onServiceConnected(ComponentName name, IBinder binder) {
            this.postOrRun(new Runnable(this, name, binder){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ComponentName val$name;
                /* synthetic */ IBinder val$binder;
                /* synthetic */ MediaServiceConnection this$1;

                private void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_1$__constructor__(MediaServiceConnection this$1, ComponentName componentName, IBinder iBinder) {
                }

                private final void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_1$run() {
                    if (!this.this$1.isCurrent("onServiceConnected")) {
                        return;
                    }
                    this.this$1.this$0.mServiceBinder = IMediaBrowserService.Stub.asInterface(this.val$binder);
                    this.this$1.this$0.mServiceCallbacks = this.this$1.this$0.getNewServiceCallbacks();
                    this.this$1.this$0.mState = 2;
                    try {
                        this.this$1.this$0.mServiceBinder.connect(this.this$1.this$0.mContext.getPackageName(), this.this$1.this$0.mRootHints, this.this$1.this$0.mServiceCallbacks);
                    }
                    catch (RemoteException ex) {
                        Log.w("MediaBrowser", "RemoteException during connect for " + this.this$1.this$0.mServiceComponent);
                    }
                }

                private void __constructor__(MediaServiceConnection mediaServiceConnection, ComponentName componentName, IBinder iBinder) {
                    this.$$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_1$__constructor__(mediaServiceConnection, componentName, iBinder);
                }
                {
                    this.this$1 = mediaServiceConnection;
                    this.val$name = componentName;
                    this.val$binder = iBinder;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_1$__constructor__(android.media.browse.MediaBrowser$MediaServiceConnection android.content.ComponentName android.os.IBinder ), 0, this, mediaServiceConnection, componentName, iBinder);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$onServiceDisconnected(ComponentName name) {
            this.postOrRun(new Runnable(this, name){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ComponentName val$name;
                /* synthetic */ MediaServiceConnection this$1;

                private void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_2$__constructor__(MediaServiceConnection this$1, ComponentName componentName) {
                }

                private final void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_2$run() {
                    if (!this.this$1.isCurrent("onServiceDisconnected")) {
                        return;
                    }
                    this.this$1.this$0.mServiceBinder = null;
                    this.this$1.this$0.mServiceCallbacks = null;
                    this.this$1.this$0.mState = 4;
                    this.this$1.this$0.mCallback.onConnectionSuspended();
                }

                private void __constructor__(MediaServiceConnection mediaServiceConnection, ComponentName componentName) {
                    this.$$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_2$__constructor__(mediaServiceConnection, componentName);
                }
                {
                    this.this$1 = mediaServiceConnection;
                    this.val$name = componentName;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_2$__constructor__(android.media.browse.MediaBrowser$MediaServiceConnection android.content.ComponentName ), 0, this, mediaServiceConnection, componentName);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$postOrRun(Runnable r) {
            if (Thread.currentThread() == this.this$0.mHandler.getLooper().getThread()) {
                r.run();
            } else {
                this.this$0.mHandler.post(r);
            }
        }

        private final boolean $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$isCurrent(String funcName) {
            if (this.this$0.mServiceConnection != this || this.this$0.mState == 0 || this.this$0.mState == 1) {
                if (this.this$0.mState != 0 && this.this$0.mState != 1) {
                    Log.i("MediaBrowser", funcName + " for " + this.this$0.mServiceComponent + " with mServiceConnection=" + this.this$0.mServiceConnection + " this=" + this);
                }
                return false;
            }
            return true;
        }

        private /* synthetic */ void $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(MediaBrowser x0, 1 x1) {
        }

        private void __constructor__(MediaBrowser mediaBrowser) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(mediaBrowser);
        }

        private MediaServiceConnection(MediaBrowser mediaBrowser) {
            this.this$0 = mediaBrowser;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(android.media.browse.MediaBrowser ), 0, this, mediaBrowser);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        private void postOrRun(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("postOrRun", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$postOrRun(java.lang.Runnable ), 0, this, runnable);
        }

        private boolean isCurrent(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isCurrent", $$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$isCurrent(java.lang.String ), 0, this, string2);
        }

        private /* synthetic */ void __constructor__(MediaBrowser mediaBrowser, 1 var2_2) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaServiceConnection$__constructor__(mediaBrowser, var2_2);
        }

        public /* synthetic */ MediaServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ItemCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_browse_MediaBrowser_ItemCallback$__constructor__() {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ItemCallback$onItemLoaded(MediaItem item) {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ItemCallback$onError(String mediaId) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_browse_MediaBrowser_ItemCallback$__constructor__();
        }

        public ItemCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_ItemCallback$__constructor__(), 0, this);
        }

        public void onItemLoaded(MediaItem mediaItem) {
            InvokeDynamicSupport.bootstrap("onItemLoaded", $$robo$$android_media_browse_MediaBrowser_ItemCallback$onItemLoaded(android.media.browse.MediaBrowser$MediaItem ), 0, this, mediaItem);
        }

        public void onError(String string2) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_browse_MediaBrowser_ItemCallback$onError(java.lang.String ), 0, this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class SubscriptionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Binder mToken;

        private void $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$__constructor__() {
            this.mToken = new Binder();
        }

        private final void $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onChildrenLoaded(String parentId, List<MediaItem> children) {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onChildrenLoaded(String parentId, List<MediaItem> children, Bundle options) {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onError(String parentId) {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onError(String parentId, Bundle options) {
        }

        private void __constructor__() {
            this.$$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$__constructor__();
        }

        public SubscriptionCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$__constructor__(), 0, this);
        }

        public void onChildrenLoaded(String string2, List<MediaItem> list) {
            InvokeDynamicSupport.bootstrap("onChildrenLoaded", $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onChildrenLoaded(java.lang.String java.util.List<android.media.browse.MediaBrowser$MediaItem> ), 0, this, string2, list);
        }

        public void onChildrenLoaded(String string2, List<MediaItem> list, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onChildrenLoaded", $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onChildrenLoaded(java.lang.String java.util.List<android.media.browse.MediaBrowser$MediaItem> android.os.Bundle ), 0, this, string2, list, bundle);
        }

        public void onError(String string2) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onError(java.lang.String ), 0, this, string2);
        }

        public void onError(String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_browse_MediaBrowser_SubscriptionCallback$onError(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ConnectionCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$__constructor__() {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnected() {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnectionSuspended() {
        }

        private final void $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnectionFailed() {
        }

        private void __constructor__() {
            this.$$robo$$android_media_browse_MediaBrowser_ConnectionCallback$__constructor__();
        }

        public ConnectionCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$__constructor__(), 0, this);
        }

        public void onConnected() {
            InvokeDynamicSupport.bootstrap("onConnected", $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnected(), 0, this);
        }

        public void onConnectionSuspended() {
            InvokeDynamicSupport.bootstrap("onConnectionSuspended", $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnectionSuspended(), 0, this);
        }

        public void onConnectionFailed() {
            InvokeDynamicSupport.bootstrap("onConnectionFailed", $$robo$$android_media_browse_MediaBrowser_ConnectionCallback$onConnectionFailed(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MediaItem
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mFlags;
        private MediaDescription mDescription;
        public static int FLAG_BROWSABLE = 1;
        public static int FLAG_PLAYABLE = 2;
        public static Parcelable.Creator<MediaItem> CREATOR;

        private void $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(MediaDescription description, int flags) {
            if (description == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            if (TextUtils.isEmpty(description.getMediaId())) {
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            this.mFlags = flags;
            this.mDescription = description;
        }

        private void $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(Parcel in) {
            this.mFlags = in.readInt();
            this.mDescription = MediaDescription.CREATOR.createFromParcel(in);
        }

        private final int $$robo$$android_media_browse_MediaBrowser_MediaItem$describeContents() {
            return 0;
        }

        private final void $$robo$$android_media_browse_MediaBrowser_MediaItem$writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mFlags);
            this.mDescription.writeToParcel(out, flags);
        }

        private final String $$robo$$android_media_browse_MediaBrowser_MediaItem$toString() {
            StringBuilder sb = new StringBuilder("MediaItem{");
            sb.append("mFlags=").append(this.mFlags);
            sb.append(", mDescription=").append(this.mDescription);
            sb.append('}');
            return sb.toString();
        }

        private final int $$robo$$android_media_browse_MediaBrowser_MediaItem$getFlags() {
            return this.mFlags;
        }

        private final boolean $$robo$$android_media_browse_MediaBrowser_MediaItem$isBrowsable() {
            return (this.mFlags & 1) != 0;
        }

        private final boolean $$robo$$android_media_browse_MediaBrowser_MediaItem$isPlayable() {
            return (this.mFlags & 2) != 0;
        }

        private final MediaDescription $$robo$$android_media_browse_MediaBrowser_MediaItem$getDescription() {
            return this.mDescription;
        }

        private final String $$robo$$android_media_browse_MediaBrowser_MediaItem$getMediaId() {
            return this.mDescription.getMediaId();
        }

        private /* synthetic */ void $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<MediaItem>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_media_browse_MediaBrowser_MediaItem_1$__constructor__() {
                }

                private final MediaItem $$robo$$android_media_browse_MediaBrowser_MediaItem_1$createFromParcel(Parcel in) {
                    return new MediaItem(in);
                }

                private final MediaItem[] $$robo$$android_media_browse_MediaBrowser_MediaItem_1$newArray(int size) {
                    return new MediaItem[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_media_browse_MediaBrowser_MediaItem_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaItem_1$__constructor__(), 0, this);
                }

                @Override
                public MediaItem createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_media_browse_MediaBrowser_MediaItem_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public MediaItem[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_media_browse_MediaBrowser_MediaItem_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(MediaDescription mediaDescription, int n) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(mediaDescription, n);
        }

        public MediaItem(MediaDescription mediaDescription, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(android.media.MediaDescription int ), 0, this, mediaDescription, n);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(parcel);
        }

        private MediaItem(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_media_browse_MediaBrowser_MediaItem$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_media_browse_MediaBrowser_MediaItem$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_media_browse_MediaBrowser_MediaItem$toString(), 0, this);
        }

        public int getFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_media_browse_MediaBrowser_MediaItem$getFlags(), 0, this);
        }

        public boolean isBrowsable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isBrowsable", $$robo$$android_media_browse_MediaBrowser_MediaItem$isBrowsable(), 0, this);
        }

        public boolean isPlayable() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPlayable", $$robo$$android_media_browse_MediaBrowser_MediaItem$isPlayable(), 0, this);
        }

        public MediaDescription getDescription() {
            return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_media_browse_MediaBrowser_MediaItem$getDescription(), 0, this);
        }

        public String getMediaId() {
            return InvokeDynamicSupport.bootstrap("getMediaId", $$robo$$android_media_browse_MediaBrowser_MediaItem$getMediaId(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_media_browse_MediaBrowser_MediaItem$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(MediaItem.class);
        }

        public /* synthetic */ MediaItem() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaItem)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flags {
        }
    }
}

