/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.MidiPortImpl;
import android.media.midi.MidiReceiver;
import android.media.midi.MidiSender;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.midi.MidiDispatcher;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MidiOutputPort
extends MidiSender
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MidiOutputPort";
    private IMidiDeviceServer mDeviceServer;
    private IBinder mToken;
    private int mPortNumber;
    private FileInputStream mInputStream;
    private MidiDispatcher mDispatcher;
    private CloseGuard mGuard;
    private boolean mIsClosed;
    private Thread mThread;

    private void $$robo$$android_media_midi_MidiOutputPort$__constructor__(IMidiDeviceServer server, IBinder token, FileDescriptor fd, int portNumber) {
        this.mDispatcher = new MidiDispatcher();
        this.mGuard = CloseGuard.get();
        this.mThread = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MidiOutputPort this$0;

            private void $$robo$$android_media_midi_MidiOutputPort_1$__constructor__(MidiOutputPort this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private final void $$robo$$android_media_midi_MidiOutputPort_1$run() {
                byte[] buffer = new byte[1024];
                try {
                    block9: while (true) {
                        int count;
                        if ((count = this.this$0.mInputStream.read(buffer)) < 0) {
                            return;
                        }
                        int packetType = MidiPortImpl.getPacketType(buffer, count);
                        switch (packetType) {
                            case 1: {
                                int offset = MidiPortImpl.getDataOffset(buffer, count);
                                int size = MidiPortImpl.getDataSize(buffer, count);
                                long timestamp = MidiPortImpl.getPacketTimestamp(buffer, count);
                                this.this$0.mDispatcher.send(buffer, offset, size, timestamp);
                                continue block9;
                            }
                            case 2: {
                                this.this$0.mDispatcher.flush();
                                continue block9;
                            }
                        }
                        Log.e("MidiOutputPort", "Unknown packet type " + packetType);
                    }
                }
                catch (IOException e) {
                    Log.e("MidiOutputPort", "read failed", e);
                    return;
                }
                finally {
                    IoUtils.closeQuietly(this.this$0.mInputStream);
                }
            }

            private void __constructor__(MidiOutputPort midiOutputPort) {
                this.$$robo$$android_media_midi_MidiOutputPort_1$__constructor__(midiOutputPort);
            }
            {
                this.this$0 = midiOutputPort;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiOutputPort_1$__constructor__(android.media.midi.MidiOutputPort ), 0, this, midiOutputPort);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_media_midi_MidiOutputPort_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDeviceServer = server;
        this.mToken = token;
        this.mPortNumber = portNumber;
        this.mInputStream = new ParcelFileDescriptor.AutoCloseInputStream(new ParcelFileDescriptor(fd));
        this.mThread.start();
        this.mGuard.open("close");
    }

    private void $$robo$$android_media_midi_MidiOutputPort$__constructor__(FileDescriptor fd, int portNumber) {
    }

    private final int $$robo$$android_media_midi_MidiOutputPort$getPortNumber() {
        return this.mPortNumber;
    }

    private final void $$robo$$android_media_midi_MidiOutputPort$onConnect(MidiReceiver receiver) {
        this.mDispatcher.getSender().connect(receiver);
    }

    private final void $$robo$$android_media_midi_MidiOutputPort$onDisconnect(MidiReceiver receiver) {
        this.mDispatcher.getSender().disconnect(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_midi_MidiOutputPort$close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (this.mIsClosed) {
                return;
            }
            this.mGuard.close();
            this.mInputStream.close();
            if (this.mDeviceServer != null) {
                try {
                    this.mDeviceServer.closePort(this.mToken);
                }
                catch (RemoteException e) {
                    Log.e("MidiOutputPort", "RemoteException in MidiOutputPort.close()");
                }
            }
            this.mIsClosed = true;
        }
    }

    private final void $$robo$$android_media_midi_MidiOutputPort$finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            this.mDeviceServer = null;
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void __constructor__(IMidiDeviceServer iMidiDeviceServer, IBinder iBinder, FileDescriptor fileDescriptor, int n) {
        this.$$robo$$android_media_midi_MidiOutputPort$__constructor__(iMidiDeviceServer, iBinder, fileDescriptor, n);
    }

    MidiOutputPort(IMidiDeviceServer iMidiDeviceServer, IBinder iBinder, FileDescriptor fileDescriptor, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiOutputPort$__constructor__(android.media.midi.IMidiDeviceServer android.os.IBinder java.io.FileDescriptor int ), 0, this, iMidiDeviceServer, iBinder, fileDescriptor, n);
    }

    private void __constructor__(FileDescriptor fileDescriptor, int n) {
        this.$$robo$$android_media_midi_MidiOutputPort$__constructor__(fileDescriptor, n);
    }

    MidiOutputPort(FileDescriptor fileDescriptor, int n) {
        this(null, null, fileDescriptor, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_midi_MidiOutputPort$__constructor__(java.io.FileDescriptor int ), 0, this, fileDescriptor, n);
    }

    public int getPortNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getPortNumber", $$robo$$android_media_midi_MidiOutputPort$getPortNumber(), 0, this);
    }

    @Override
    public void onConnect(MidiReceiver midiReceiver) {
        InvokeDynamicSupport.bootstrap("onConnect", $$robo$$android_media_midi_MidiOutputPort$onConnect(android.media.midi.MidiReceiver ), 0, this, midiReceiver);
    }

    @Override
    public void onDisconnect(MidiReceiver midiReceiver) {
        InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$android_media_midi_MidiOutputPort$onDisconnect(android.media.midi.MidiReceiver ), 0, this, midiReceiver);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_media_midi_MidiOutputPort$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_media_midi_MidiOutputPort$finalize(), 0, this);
    }

    public /* synthetic */ MidiOutputPort() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MidiOutputPort)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

