/*
 * Decompiled with CFR 0.152.
 */
package android.media.soundtrigger;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.soundtrigger.ISoundTriggerDetectionServiceClient;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public abstract class SoundTriggerDetectionService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    private static boolean DEBUG = false;
    private Object mLock;
    @GuardedBy(value="mLock")
    private ArrayMap<UUID, ISoundTriggerDetectionServiceClient> mClients;
    private Handler mHandler;

    private void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$__constructor__() {
        this.mLock = new Object();
        this.mClients = new ArrayMap();
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new Handler(base.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$setClient(UUID uuid, Bundle params, ISoundTriggerDetectionServiceClient client) {
        Object object = this.mLock;
        synchronized (object) {
            this.mClients.put(uuid, client);
        }
        this.onConnected(uuid, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$removeClient(UUID uuid, Bundle params) {
        Object object = this.mLock;
        synchronized (object) {
            this.mClients.remove(uuid);
        }
        this.onDisconnected(uuid, params);
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onConnected(UUID uuid, Bundle params) {
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onDisconnected(UUID uuid, Bundle params) {
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onGenericRecognitionEvent(UUID uuid, Bundle params, int opId, SoundTrigger.RecognitionEvent event) {
        this.operationFinished(uuid, opId);
    }

    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onError(UUID uuid, Bundle params, int opId, int status) {
        this.operationFinished(uuid, opId);
    }

    public abstract void onStopOperation(UUID var1, Bundle var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$operationFinished(UUID uuid, int opId) {
        try {
            ISoundTriggerDetectionServiceClient client;
            Object object = this.mLock;
            synchronized (object) {
                client = this.mClients.get(uuid);
                if (client == null) {
                    Log.w(LOG_TAG, "operationFinished called, but no client for " + uuid + ". Was this called after onDisconnected?");
                    return;
                }
            }
            client.onOpFinished(opId);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "operationFinished, remote exception for client " + uuid, e);
        }
    }

    private final IBinder $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onBind(Intent intent) {
        return new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            private Object mBinderLock;
            @GuardedBy(value="mBinderLock")
            public ArrayMap<UUID, Bundle> mParams;
            /* synthetic */ SoundTriggerDetectionService this$0;

            private void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$__constructor__(SoundTriggerDetectionService this$0) {
                this.mBinderLock = new Object();
                this.mParams = new ArrayMap();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$setClient(ParcelUuid puuid, Bundle params, ISoundTriggerDetectionServiceClient client) {
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    this.mParams.put(uuid, params);
                }
                this.this$0.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2) -> ((SoundTriggerDetectionService)rec$).setClient(x$0, x$1, x$2), this.this$0, uuid, params, client));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$removeClient(ParcelUuid puuid) {
                Bundle params;
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    params = this.mParams.remove(uuid);
                }
                this.this$0.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1) -> ((SoundTriggerDetectionService)rec$).removeClient(x$0, x$1), this.this$0, uuid, params));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$onGenericRecognitionEvent(ParcelUuid puuid, int opId, SoundTrigger.GenericRecognitionEvent event) {
                Bundle params;
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    params = this.mParams.get(uuid);
                }
                this.this$0.mHandler.sendMessage(PooledLambda.obtainMessage(SoundTriggerDetectionService::onGenericRecognitionEvent, this.this$0, uuid, params, opId, event));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$onError(ParcelUuid puuid, int opId, int status) {
                Bundle params;
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    params = this.mParams.get(uuid);
                }
                this.this$0.mHandler.sendMessage(PooledLambda.obtainMessage(SoundTriggerDetectionService::onError, this.this$0, uuid, params, opId, status));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$onStopOperation(ParcelUuid puuid, int opId) {
                Bundle params;
                UUID uuid = puuid.getUuid();
                Object object = this.mBinderLock;
                synchronized (object) {
                    params = this.mParams.get(uuid);
                }
                this.this$0.mHandler.sendMessage(PooledLambda.obtainMessage(SoundTriggerDetectionService::onStopOperation, this.this$0, uuid, params, opId));
            }

            private void __constructor__(SoundTriggerDetectionService soundTriggerDetectionService) {
                this.$$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$__constructor__(soundTriggerDetectionService);
            }
            {
                this.this$0 = soundTriggerDetectionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$__constructor__(android.media.soundtrigger.SoundTriggerDetectionService ), 0, this, soundTriggerDetectionService);
            }

            @Override
            public void setClient(ParcelUuid parcelUuid, Bundle bundle, ISoundTriggerDetectionServiceClient iSoundTriggerDetectionServiceClient) {
                InvokeDynamicSupport.bootstrap("setClient", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$setClient(android.os.ParcelUuid android.os.Bundle android.media.soundtrigger.ISoundTriggerDetectionServiceClient ), 0, this, parcelUuid, bundle, iSoundTriggerDetectionServiceClient);
            }

            @Override
            public void removeClient(ParcelUuid parcelUuid) {
                InvokeDynamicSupport.bootstrap("removeClient", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$removeClient(android.os.ParcelUuid ), 0, this, parcelUuid);
            }

            @Override
            public void onGenericRecognitionEvent(ParcelUuid parcelUuid, int n, SoundTrigger.GenericRecognitionEvent genericRecognitionEvent) {
                InvokeDynamicSupport.bootstrap("onGenericRecognitionEvent", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$onGenericRecognitionEvent(android.os.ParcelUuid int android.hardware.soundtrigger.SoundTrigger$GenericRecognitionEvent ), 0, this, parcelUuid, n, genericRecognitionEvent);
            }

            @Override
            public void onError(ParcelUuid parcelUuid, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$onError(android.os.ParcelUuid int int ), 0, this, parcelUuid, n, n2);
            }

            @Override
            public void onStopOperation(ParcelUuid parcelUuid, int n) {
                InvokeDynamicSupport.bootstrap("onStopOperation", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService_1$onStopOperation(android.os.ParcelUuid int ), 0, this, parcelUuid, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final boolean $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onUnbind(Intent intent) {
        this.mClients.clear();
        return false;
    }

    static void __staticInitializer__() {
        LOG_TAG = SoundTriggerDetectionService.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_media_soundtrigger_SoundTriggerDetectionService$__constructor__();
    }

    public SoundTriggerDetectionService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$__constructor__(), 0, this);
    }

    @Override
    protected void attachBaseContext(Context context) {
        InvokeDynamicSupport.bootstrap("attachBaseContext", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$attachBaseContext(android.content.Context ), 0, this, context);
    }

    private void setClient(UUID uUID, Bundle bundle, ISoundTriggerDetectionServiceClient iSoundTriggerDetectionServiceClient) {
        InvokeDynamicSupport.bootstrap("setClient", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$setClient(java.util.UUID android.os.Bundle android.media.soundtrigger.ISoundTriggerDetectionServiceClient ), 0, this, uUID, bundle, iSoundTriggerDetectionServiceClient);
    }

    private void removeClient(UUID uUID, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("removeClient", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$removeClient(java.util.UUID android.os.Bundle ), 0, this, uUID, bundle);
    }

    public void onConnected(UUID uUID, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onConnected", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onConnected(java.util.UUID android.os.Bundle ), 0, this, uUID, bundle);
    }

    public void onDisconnected(UUID uUID, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onDisconnected(java.util.UUID android.os.Bundle ), 0, this, uUID, bundle);
    }

    public void onGenericRecognitionEvent(UUID uUID, Bundle bundle, int n, SoundTrigger.RecognitionEvent recognitionEvent) {
        InvokeDynamicSupport.bootstrap("onGenericRecognitionEvent", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onGenericRecognitionEvent(java.util.UUID android.os.Bundle int android.hardware.soundtrigger.SoundTrigger$RecognitionEvent ), 0, this, uUID, bundle, n, recognitionEvent);
    }

    public void onError(UUID uUID, Bundle bundle, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onError", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onError(java.util.UUID android.os.Bundle int int ), 0, this, uUID, bundle, n, n2);
    }

    public void operationFinished(UUID uUID, int n) {
        InvokeDynamicSupport.bootstrap("operationFinished", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$operationFinished(java.util.UUID int ), 0, this, uUID, n);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public boolean onUnbind(Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onUnbind", $$robo$$android_media_soundtrigger_SoundTriggerDetectionService$onUnbind(android.content.Intent ), 0, this, intent);
    }

    static {
        RobolectricInternals.classInitializing(SoundTriggerDetectionService.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoundTriggerDetectionService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

