/*
 * Decompiled with CFR 0.152.
 */
package android.metrics;

import android.annotation.SystemApi;
import android.metrics.LogMaker;
import android.util.EventLog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class MetricsReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Queue<LogMaker> mPendingQueue;
    private Queue<LogMaker> mSeenQueue;
    private int[] LOGTAGS;
    private LogReader mReader;
    private int mCheckpointTag;

    private void $$robo$$android_metrics_MetricsReader$__constructor__() {
        this.mPendingQueue = new LinkedList<LogMaker>();
        this.mSeenQueue = new LinkedList<LogMaker>();
        this.LOGTAGS = new int[]{524292};
        this.mReader = new LogReader();
        this.mCheckpointTag = -1;
    }

    @VisibleForTesting
    private final void $$robo$$android_metrics_MetricsReader$setLogReader(LogReader reader) {
        this.mReader = reader;
    }

    private final void $$robo$$android_metrics_MetricsReader$read(long horizonMs) {
        ArrayList<Event> nativeEvents = new ArrayList<Event>();
        try {
            this.mReader.readEvents(this.LOGTAGS, horizonMs, nativeEvents);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mPendingQueue.clear();
        this.mSeenQueue.clear();
        for (Event event : nativeEvents) {
            long eventTimestampMs = event.getTimeMillis();
            Object data = event.getData();
            Object[] objects = data instanceof Object[] ? (Object[])data : new Object[]{data};
            LogMaker log = new LogMaker(objects).setTimestamp(eventTimestampMs).setUid(event.getUid()).setProcessId(event.getProcessId());
            if (log.getCategory() == 920) {
                if (log.getSubtype() != this.mCheckpointTag) continue;
                this.mPendingQueue.clear();
                continue;
            }
            this.mPendingQueue.offer(log);
        }
    }

    private final void $$robo$$android_metrics_MetricsReader$checkpoint() {
        this.mCheckpointTag = (int)(InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") % Integer.MAX_VALUE);
        this.mReader.writeCheckpoint(this.mCheckpointTag);
        this.mPendingQueue.clear();
        this.mSeenQueue.clear();
    }

    private final void $$robo$$android_metrics_MetricsReader$reset() {
        this.mSeenQueue.addAll(this.mPendingQueue);
        this.mPendingQueue.clear();
        this.mCheckpointTag = -1;
        Queue<LogMaker> tmp = this.mPendingQueue;
        this.mPendingQueue = this.mSeenQueue;
        this.mSeenQueue = tmp;
    }

    private final boolean $$robo$$android_metrics_MetricsReader$hasNext() {
        return !this.mPendingQueue.isEmpty();
    }

    private final LogMaker $$robo$$android_metrics_MetricsReader$next() {
        LogMaker next = this.mPendingQueue.poll();
        if (next != null) {
            this.mSeenQueue.offer(next);
        }
        return next;
    }

    private void __constructor__() {
        this.$$robo$$android_metrics_MetricsReader$__constructor__();
    }

    public MetricsReader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_metrics_MetricsReader$__constructor__(), 0, this);
    }

    public void setLogReader(LogReader logReader) {
        InvokeDynamicSupport.bootstrap("setLogReader", $$robo$$android_metrics_MetricsReader$setLogReader(android.metrics.MetricsReader$LogReader ), 0, this, logReader);
    }

    public void read(long l) {
        InvokeDynamicSupport.bootstrap("read", $$robo$$android_metrics_MetricsReader$read(long ), 0, this, l);
    }

    public void checkpoint() {
        InvokeDynamicSupport.bootstrap("checkpoint", $$robo$$android_metrics_MetricsReader$checkpoint(), 0, this);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_metrics_MetricsReader$reset(), 0, this);
    }

    public boolean hasNext() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_metrics_MetricsReader$hasNext(), 0, this);
    }

    public LogMaker next() {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_metrics_MetricsReader$next(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MetricsReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @VisibleForTesting
    public static class LogReader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_metrics_MetricsReader_LogReader$__constructor__() {
        }

        private final void $$robo$$android_metrics_MetricsReader_LogReader$readEvents(int[] tags, long horizonMs, Collection<Event> events) throws IOException {
            ArrayList<EventLog.Event> nativeEvents = new ArrayList<EventLog.Event>();
            long horizonNs = TimeUnit.NANOSECONDS.convert(horizonMs, TimeUnit.MILLISECONDS);
            EventLog.readEventsOnWrapping(tags, horizonNs, nativeEvents);
            for (EventLog.Event nativeEvent : nativeEvents) {
                Event event = new Event(nativeEvent);
                events.add(event);
            }
        }

        private final void $$robo$$android_metrics_MetricsReader_LogReader$writeCheckpoint(int tag) {
            MetricsLogger logger = new MetricsLogger();
            logger.action(920, tag);
        }

        private void __constructor__() {
            this.$$robo$$android_metrics_MetricsReader_LogReader$__constructor__();
        }

        public LogReader() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_metrics_MetricsReader_LogReader$__constructor__(), 0, this);
        }

        public void readEvents(int[] nArray, long l, Collection<Event> collection) throws IOException {
            InvokeDynamicSupport.bootstrap("readEvents", $$robo$$android_metrics_MetricsReader_LogReader$readEvents(int[] long java.util.Collection<android.metrics.MetricsReader$Event> ), 0, this, nArray, l, collection);
        }

        public void writeCheckpoint(int n) {
            InvokeDynamicSupport.bootstrap("writeCheckpoint", $$robo$$android_metrics_MetricsReader_LogReader$writeCheckpoint(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogReader)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting
    public static class Event
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long mTimeMillis;
        int mPid;
        int mUid;
        Object mData;

        private void $$robo$$android_metrics_MetricsReader_Event$__constructor__(long timeMillis, int pid, int uid, Object data) {
            this.mTimeMillis = timeMillis;
            this.mPid = pid;
            this.mUid = uid;
            this.mData = data;
        }

        private void $$robo$$android_metrics_MetricsReader_Event$__constructor__(EventLog.Event nativeEvent) {
            this.mTimeMillis = TimeUnit.MILLISECONDS.convert(nativeEvent.getTimeNanos(), TimeUnit.NANOSECONDS);
            this.mPid = nativeEvent.getProcessId();
            this.mUid = nativeEvent.getUid();
            this.mData = nativeEvent.getData();
        }

        private final long $$robo$$android_metrics_MetricsReader_Event$getTimeMillis() {
            return this.mTimeMillis;
        }

        private final int $$robo$$android_metrics_MetricsReader_Event$getProcessId() {
            return this.mPid;
        }

        private final int $$robo$$android_metrics_MetricsReader_Event$getUid() {
            return this.mUid;
        }

        private final Object $$robo$$android_metrics_MetricsReader_Event$getData() {
            return this.mData;
        }

        private final void $$robo$$android_metrics_MetricsReader_Event$setData(Object data) {
            this.mData = data;
        }

        private void __constructor__(long l, int n, int n2, Object object) {
            this.$$robo$$android_metrics_MetricsReader_Event$__constructor__(l, n, n2, object);
        }

        public Event(long l, int n, int n2, Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_metrics_MetricsReader_Event$__constructor__(long int int java.lang.Object ), 0, this, l, n, n2, object);
        }

        private void __constructor__(EventLog.Event event) {
            this.$$robo$$android_metrics_MetricsReader_Event$__constructor__(event);
        }

        Event(EventLog.Event event) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_metrics_MetricsReader_Event$__constructor__(android.util.EventLog$Event ), 0, this, event);
        }

        public long getTimeMillis() {
            return (long)InvokeDynamicSupport.bootstrap("getTimeMillis", $$robo$$android_metrics_MetricsReader_Event$getTimeMillis(), 0, this);
        }

        public int getProcessId() {
            return (int)InvokeDynamicSupport.bootstrap("getProcessId", $$robo$$android_metrics_MetricsReader_Event$getProcessId(), 0, this);
        }

        public int getUid() {
            return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_metrics_MetricsReader_Event$getUid(), 0, this);
        }

        public Object getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_metrics_MetricsReader_Event$getData(), 0, this);
        }

        public void setData(Object object) {
            InvokeDynamicSupport.bootstrap("setData", $$robo$$android_metrics_MetricsReader_Event$setData(java.lang.Object ), 0, this, object);
        }

        public /* synthetic */ Event() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Event)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

