/*
 * Decompiled with CFR 0.152.
 */
package android.mtp;

import android.media.MediaFile;
import android.mtp.MtpStorage;
import android.os.FileObserver;
import android.os.storage.StorageVolume;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MtpStorageManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static boolean sDebug;
    private static int IN_ONLYDIR = 0x1000000;
    private static int IN_Q_OVERFLOW = 16384;
    private static int IN_IGNORED = 32768;
    private static int IN_ISDIR = 0x40000000;
    private MtpNotifier mMtpNotifier;
    private HashMap<Integer, MtpObject> mObjects;
    private HashMap<Integer, MtpObject> mRoots;
    private int mNextObjectId;
    private int mNextStorageId;
    private Set<String> mSubdirectories;
    private volatile boolean mCheckConsistency;
    private Thread mConsistencyThread;

    private void $$robo$$android_mtp_MtpStorageManager$__constructor__(MtpNotifier notifier, Set<String> subdirectories) {
        this.mMtpNotifier = notifier;
        this.mSubdirectories = subdirectories;
        this.mObjects = new HashMap();
        this.mRoots = new HashMap();
        this.mNextObjectId = 1;
        this.mNextStorageId = 1;
        this.mCheckConsistency = false;
        this.mConsistencyThread = new Thread(() -> {
            while (this.mCheckConsistency) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (this.checkConsistency()) {
                    Log.v(TAG, "Cache is consistent");
                    continue;
                }
                Log.w(TAG, "Cache is not consistent");
            }
        });
        if (this.mCheckConsistency) {
            this.mConsistencyThread.start();
        }
    }

    private final synchronized void $$robo$$android_mtp_MtpStorageManager$close() {
        Stream<MtpObject> objs = Stream.concat(this.mRoots.values().stream(), this.mObjects.values().stream());
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            MtpObject obj = (MtpObject)iter.next();
            if (obj.getObserver() == null) continue;
            obj.getObserver().stopWatching();
            obj.setObserver(null);
        }
        if (this.mCheckConsistency) {
            this.mCheckConsistency = false;
            this.mConsistencyThread.interrupt();
            try {
                this.mConsistencyThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private final synchronized void $$robo$$android_mtp_MtpStorageManager$setSubdirectories(Set<String> subDirs) {
        this.mSubdirectories = subDirs;
    }

    private final synchronized MtpStorage $$robo$$android_mtp_MtpStorageManager$addMtpStorage(StorageVolume volume) {
        int storageId = ((this.getNextStorageId() & 0xFFFF) << 16) + 1;
        MtpStorage storage = new MtpStorage(volume, storageId);
        MtpObject root = new MtpObject(storage.getPath(), storageId, null, true);
        this.mRoots.put(storageId, root);
        return storage;
    }

    private final synchronized void $$robo$$android_mtp_MtpStorageManager$removeMtpStorage(MtpStorage storage) {
        this.removeObjectFromCache(this.getStorageRoot(storage.getStorageId()), true, true);
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$isSpecialSubDir(MtpObject obj) {
        return obj.getParent().isRoot() && this.mSubdirectories != null && !this.mSubdirectories.contains(obj.getName());
    }

    private final synchronized MtpObject $$robo$$android_mtp_MtpStorageManager$getByPath(String path) {
        MtpObject obj = null;
        for (MtpObject root : this.mRoots.values()) {
            if (!path.startsWith(root.getName())) continue;
            obj = root;
            path = path.substring(root.getName().length());
        }
        for (String name : path.split("/")) {
            if (obj == null || !obj.isDir()) {
                return null;
            }
            if ("".equals(name)) continue;
            if (!obj.isVisited()) {
                this.getChildren(obj);
            }
            obj = obj.getChild(name);
        }
        return obj;
    }

    private final synchronized MtpObject $$robo$$android_mtp_MtpStorageManager$getObject(int id2) {
        if (id2 == 0 || id2 == -1) {
            Log.w(TAG, "Can't get root storages with getObject()");
            return null;
        }
        if (!this.mObjects.containsKey(id2)) {
            Log.w(TAG, "Id " + id2 + " doesn't exist");
            return null;
        }
        return this.mObjects.get(id2);
    }

    private final MtpObject $$robo$$android_mtp_MtpStorageManager$getStorageRoot(int id2) {
        if (!this.mRoots.containsKey(id2)) {
            Log.w(TAG, "StorageId " + id2 + " doesn't exist");
            return null;
        }
        return this.mRoots.get(id2);
    }

    private final int $$robo$$android_mtp_MtpStorageManager$getNextObjectId() {
        int ret = this.mNextObjectId;
        this.mNextObjectId = (int)((long)this.mNextObjectId + 1L);
        return ret;
    }

    private final int $$robo$$android_mtp_MtpStorageManager$getNextStorageId() {
        return this.mNextStorageId++;
    }

    private final synchronized Stream<MtpObject> $$robo$$android_mtp_MtpStorageManager$getObjects(int parent, int format, int storageId) {
        MtpObject obj;
        boolean recursive;
        boolean bl = recursive = parent == 0;
        if (parent == -1) {
            parent = 0;
        }
        if (storageId == -1 && parent == 0) {
            ArrayList<Stream<MtpObject>> streamList = new ArrayList<Stream<MtpObject>>();
            for (MtpObject root : this.mRoots.values()) {
                streamList.add(this.getObjects(root, format, recursive));
            }
            return Stream.of(streamList).flatMap(Collection::stream).reduce(Stream::concat).orElseGet(Stream::empty);
        }
        MtpObject mtpObject = obj = parent == 0 ? this.getStorageRoot(storageId) : this.getObject(parent);
        if (obj == null) {
            return null;
        }
        return this.getObjects(obj, format, recursive);
    }

    private final synchronized Stream<MtpObject> $$robo$$android_mtp_MtpStorageManager$getObjects(MtpObject parent, int format, boolean rec) {
        Collection<MtpObject> children = this.getChildren(parent);
        if (children == null) {
            return null;
        }
        Stream ret = Stream.of(children).flatMap(Collection::stream);
        if (format != 0) {
            ret = ret.filter(o -> o.getFormat() == format);
        }
        if (rec) {
            ArrayList<Stream<MtpObject>> streamList = new ArrayList<Stream<MtpObject>>();
            streamList.add(ret);
            for (MtpObject o2 : children) {
                if (!o2.isDir()) continue;
                streamList.add(this.getObjects(o2, format, true));
            }
            ret = Stream.of(streamList).filter(Objects::nonNull).flatMap(Collection::stream).reduce(Stream::concat).orElseGet(Stream::empty);
        }
        return ret;
    }

    private final synchronized Collection<MtpObject> $$robo$$android_mtp_MtpStorageManager$getChildren(MtpObject object) {
        if (object == null || !object.isDir()) {
            Log.w(TAG, "Can't find children of " + (object == null ? "null" : Integer.valueOf(object.getId())));
            return null;
        }
        if (!object.isVisited()) {
            Path dir = object.getPath();
            if (object.getObserver() != null) {
                Log.e(TAG, "Observer is not null!");
            }
            object.setObserver(new MtpObjectObserver(this, object));
            object.getObserver().startWatching();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                for (Path file : stream) {
                    this.addObjectToCache(object, file.getFileName().toString(), file.toFile().isDirectory());
                }
            }
            catch (IOException | DirectoryIteratorException e) {
                Log.e(TAG, e.toString());
                object.getObserver().stopWatching();
                object.setObserver(null);
                return null;
            }
            object.setVisited(true);
        }
        return object.getChildren();
    }

    private final synchronized MtpObject $$robo$$android_mtp_MtpStorageManager$addObjectToCache(MtpObject parent, String newName, boolean isDir) {
        if (!parent.isRoot() && this.getObject(parent.getId()) != parent) {
            return null;
        }
        if (parent.getChild(newName) != null) {
            return null;
        }
        if (this.mSubdirectories != null && parent.isRoot() && !this.mSubdirectories.contains(newName)) {
            return null;
        }
        MtpObject obj = new MtpObject(newName, this.getNextObjectId(), parent, isDir);
        this.mObjects.put(obj.getId(), obj);
        parent.addChild(obj);
        return obj;
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$removeObjectFromCache(MtpObject removed, boolean removeGlobal, boolean recursive) {
        boolean ret;
        boolean bl = ret = removed.isRoot() || removed.getParent().mChildren.remove(removed.getName(), removed);
        if (!ret && sDebug) {
            Log.w(TAG, "Failed to remove from parent " + removed.getPath());
        }
        if (removed.isRoot()) {
            ret = this.mRoots.remove(removed.getId(), removed) && ret;
        } else if (removeGlobal) {
            boolean bl2 = ret = this.mObjects.remove(removed.getId(), removed) && ret;
        }
        if (!ret && sDebug) {
            Log.w(TAG, "Failed to remove from global cache " + removed.getPath());
        }
        if (removed.getObserver() != null) {
            removed.getObserver().stopWatching();
            removed.setObserver(null);
        }
        if (removed.isDir() && recursive) {
            ArrayList children = new ArrayList(removed.getChildren());
            for (MtpObject child : children) {
                ret = this.removeObjectFromCache(child, removeGlobal, true) && ret;
            }
        }
        return ret;
    }

    private final synchronized void $$robo$$android_mtp_MtpStorageManager$handleAddedObject(MtpObject parent, String path, boolean isDir) {
        MtpOperation op = MtpOperation.NONE;
        MtpObject obj = parent.getChild(path);
        if (obj != null) {
            MtpObjectState state = obj.getState();
            op = obj.getOperation();
            if (obj.isDir() != isDir && state != MtpObjectState.FROZEN_REMOVED) {
                Log.d(TAG, "Inconsistent directory info! " + obj.getPath());
            }
            obj.setDir(isDir);
            switch (1.$SwitchMap$android$mtp$MtpStorageManager$MtpObjectState[state.ordinal()]) {
                case 1: 
                case 2: {
                    obj.setState(MtpObjectState.FROZEN_ADDED);
                    break;
                }
                case 3: {
                    obj.setState(MtpObjectState.NORMAL);
                    break;
                }
                case 4: 
                case 5: {
                    return;
                }
                default: {
                    Log.w(TAG, "Unexpected state in add " + path + " " + (Object)((Object)state));
                }
            }
            if (sDebug) {
                Log.i(TAG, (Object)((Object)state) + " transitioned to " + (Object)((Object)obj.getState()) + " in op " + (Object)((Object)op));
            }
        } else {
            obj = this.addObjectToCache(parent, path, isDir);
            if (obj != null) {
                this.mMtpNotifier.sendObjectAdded(obj.getId());
            } else {
                if (sDebug) {
                    Log.w(TAG, "object " + path + " already exists");
                }
                return;
            }
        }
        if (isDir) {
            if (op == MtpOperation.RENAME) {
                return;
            }
            if (op == MtpOperation.COPY && !obj.isVisited()) {
                return;
            }
            if (obj.getObserver() != null) {
                Log.e(TAG, "Observer is not null!");
                return;
            }
            obj.setObserver(new MtpObjectObserver(this, obj));
            obj.getObserver().startWatching();
            obj.setVisited(true);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(obj.getPath());){
                for (Path file : stream) {
                    if (sDebug) {
                        Log.i(TAG, "Manually handling event for " + file.getFileName().toString());
                    }
                    this.handleAddedObject(obj, file.getFileName().toString(), file.toFile().isDirectory());
                }
            }
            catch (IOException | DirectoryIteratorException e) {
                Log.e(TAG, e.toString());
                obj.getObserver().stopWatching();
                obj.setObserver(null);
            }
        }
    }

    private final synchronized void $$robo$$android_mtp_MtpStorageManager$handleRemovedObject(MtpObject obj) {
        MtpObjectState state = obj.getState();
        MtpOperation op = obj.getOperation();
        switch (1.$SwitchMap$android$mtp$MtpStorageManager$MtpObjectState[state.ordinal()]) {
            case 5: {
                obj.setState(MtpObjectState.FROZEN_REMOVED);
                break;
            }
            case 6: {
                this.removeObjectFromCache(obj, op != MtpOperation.RENAME, false);
                break;
            }
            case 1: {
                obj.setState(MtpObjectState.FROZEN_REMOVED);
                break;
            }
            case 4: {
                if (!this.removeObjectFromCache(obj, true, true)) break;
                this.mMtpNotifier.sendObjectRemoved(obj.getId());
                break;
            }
            default: {
                Log.e(TAG, "Got unexpected object remove for " + obj.getName());
            }
        }
        if (sDebug) {
            Log.i(TAG, (Object)((Object)state) + " transitioned to " + (Object)((Object)obj.getState()) + " in op " + (Object)((Object)op));
        }
    }

    private final void $$robo$$android_mtp_MtpStorageManager$flushEvents() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final synchronized void $$robo$$android_mtp_MtpStorageManager$dump() {
        for (int key : this.mObjects.keySet()) {
            MtpObject obj = this.mObjects.get(key);
            Log.i(TAG, key + " | " + (obj.getParent() == null ? Integer.valueOf(obj.getParent().getId()) : "null") + " | " + obj.getName() + " | " + (obj.isDir() ? "dir" : "obj") + " | " + (obj.isVisited() ? "v" : "nv") + " | " + (Object)((Object)obj.getState()));
        }
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$checkConsistency() {
        Stream<MtpObject> objs = Stream.concat(this.mRoots.values().stream(), this.mObjects.values().stream());
        Iterator iter = objs.iterator();
        boolean ret = true;
        while (iter.hasNext()) {
            MtpObject obj = (MtpObject)iter.next();
            if (!obj.exists()) {
                Log.w(TAG, "Object doesn't exist " + obj.getPath() + " " + obj.getId());
                ret = false;
            }
            if (obj.getState() != MtpObjectState.NORMAL) {
                Log.w(TAG, "Object " + obj.getPath() + " in state " + (Object)((Object)obj.getState()));
                ret = false;
            }
            if (obj.getOperation() != MtpOperation.NONE) {
                Log.w(TAG, "Object " + obj.getPath() + " in operation " + (Object)((Object)obj.getOperation()));
                ret = false;
            }
            if (!obj.isRoot() && this.mObjects.get(obj.getId()) != obj) {
                Log.w(TAG, "Object " + obj.getPath() + " is not in map correctly");
                ret = false;
            }
            if (obj.getParent() != null) {
                if (obj.getParent().isRoot() && obj.getParent() != this.mRoots.get(obj.getParent().getId())) {
                    Log.w(TAG, "Root parent is not in root mapping " + obj.getPath());
                    ret = false;
                }
                if (!obj.getParent().isRoot() && obj.getParent() != this.mObjects.get(obj.getParent().getId())) {
                    Log.w(TAG, "Parent is not in object mapping " + obj.getPath());
                    ret = false;
                }
                if (obj.getParent().getChild(obj.getName()) != obj) {
                    Log.w(TAG, "Child does not exist in parent " + obj.getPath());
                    ret = false;
                }
            }
            if (!obj.isDir()) continue;
            if (obj.isVisited() == (obj.getObserver() == null)) {
                Log.w(TAG, obj.getPath() + " is " + (obj.isVisited() ? "" : "not ") + " visited but observer is " + obj.getObserver());
                ret = false;
            }
            if (!obj.isVisited() && obj.getChildren().size() > 0) {
                Log.w(TAG, obj.getPath() + " is not visited but has children");
                ret = false;
            }
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(obj.getPath());
                Throwable throwable = null;
                try {
                    HashSet<String> files = new HashSet<String>();
                    for (Path file : stream) {
                        if (obj.isVisited() && obj.getChild(file.getFileName().toString()) == null && (this.mSubdirectories == null || !obj.isRoot() || this.mSubdirectories.contains(file.getFileName().toString()))) {
                            Log.w(TAG, "File exists in fs but not in children " + file);
                            ret = false;
                        }
                        files.add(file.toString());
                    }
                    for (MtpObject child : obj.getChildren()) {
                        if (!files.contains(child.getPath().toString())) {
                            Log.w(TAG, "File in children doesn't exist in fs " + child.getPath());
                            ret = false;
                        }
                        if (child == this.mObjects.get(child.getId())) continue;
                        Log.w(TAG, "Child is not in object map " + child.getPath());
                        ret = false;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    MtpStorageManager.$closeResource(throwable, stream);
                }
            }
            catch (IOException | DirectoryIteratorException e) {
                Log.w(TAG, e.toString());
                ret = false;
            }
        }
        return ret;
    }

    private final synchronized int $$robo$$android_mtp_MtpStorageManager$beginSendObject(MtpObject parent, String name, int format) {
        if (sDebug) {
            Log.v(TAG, "beginSendObject " + name);
        }
        if (!parent.isDir()) {
            return -1;
        }
        if (parent.isRoot() && this.mSubdirectories != null && !this.mSubdirectories.contains(name)) {
            return -1;
        }
        this.getChildren(parent);
        MtpObject obj = this.addObjectToCache(parent, name, format == 12289);
        if (obj == null) {
            return -1;
        }
        obj.setState(MtpObjectState.FROZEN);
        obj.setOperation(MtpOperation.ADD);
        return obj.getId();
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$endSendObject(MtpObject obj, boolean succeeded) {
        if (sDebug) {
            Log.v(TAG, "endSendObject " + succeeded);
        }
        return this.generalEndAddObject(obj, succeeded, true);
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$beginRenameObject(MtpObject obj, String newName) {
        if (sDebug) {
            Log.v(TAG, "beginRenameObject " + obj.getName() + " " + newName);
        }
        if (obj.isRoot()) {
            return false;
        }
        if (this.isSpecialSubDir(obj)) {
            return false;
        }
        if (obj.getParent().getChild(newName) != null) {
            return false;
        }
        MtpObject oldObj = obj.copy(false);
        obj.setName(newName);
        obj.getParent().addChild(obj);
        oldObj.getParent().addChild(oldObj);
        return this.generalBeginRenameObject(oldObj, obj);
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$endRenameObject(MtpObject obj, String oldName, boolean success) {
        if (sDebug) {
            Log.v(TAG, "endRenameObject " + success);
        }
        MtpObject parent = obj.getParent();
        MtpObject oldObj = parent.getChild(oldName);
        if (!success) {
            MtpObject temp = oldObj;
            MtpObjectState oldState = oldObj.getState();
            temp.setName(obj.getName());
            temp.setState(obj.getState());
            oldObj = obj;
            oldObj.setName(oldName);
            oldObj.setState(oldState);
            obj = temp;
            parent.addChild(obj);
            parent.addChild(oldObj);
        }
        return this.generalEndRenameObject(oldObj, obj, success);
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$beginRemoveObject(MtpObject obj) {
        if (sDebug) {
            Log.v(TAG, "beginRemoveObject " + obj.getName());
        }
        return !obj.isRoot() && !this.isSpecialSubDir(obj) && this.generalBeginRemoveObject(obj, MtpOperation.DELETE);
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$endRemoveObject(MtpObject obj, boolean success) {
        if (sDebug) {
            Log.v(TAG, "endRemoveObject " + success);
        }
        boolean ret = true;
        if (obj.isDir()) {
            for (MtpObject child : new ArrayList(obj.getChildren())) {
                if (child.getOperation() != MtpOperation.DELETE) continue;
                ret = this.endRemoveObject(child, success) && ret;
            }
        }
        return this.generalEndRemoveObject(obj, success, true) && ret;
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$beginMoveObject(MtpObject obj, MtpObject newParent) {
        if (sDebug) {
            Log.v(TAG, "beginMoveObject " + newParent.getPath());
        }
        if (obj.isRoot()) {
            return false;
        }
        if (this.isSpecialSubDir(obj)) {
            return false;
        }
        this.getChildren(newParent);
        if (newParent.getChild(obj.getName()) != null) {
            return false;
        }
        if (obj.getStorageId() != newParent.getStorageId()) {
            MtpObject newObj = obj.copy(true);
            newObj.setParent(newParent);
            newParent.addChild(newObj);
            return this.generalBeginRemoveObject(obj, MtpOperation.RENAME) && this.generalBeginCopyObject(newObj, false);
        }
        MtpObject oldObj = obj.copy(false);
        obj.setParent(newParent);
        oldObj.getParent().addChild(oldObj);
        obj.getParent().addChild(obj);
        return this.generalBeginRenameObject(oldObj, obj);
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$endMoveObject(MtpObject oldParent, MtpObject newParent, String name, boolean success) {
        if (sDebug) {
            Log.v(TAG, "endMoveObject " + success);
        }
        MtpObject oldObj = oldParent.getChild(name);
        MtpObject newObj = newParent.getChild(name);
        if (oldObj == null || newObj == null) {
            return false;
        }
        if (oldParent.getStorageId() != newObj.getStorageId()) {
            boolean ret = this.endRemoveObject(oldObj, success);
            return this.generalEndCopyObject(newObj, success, true) && ret;
        }
        if (!success) {
            MtpObject temp = oldObj;
            MtpObjectState oldState = oldObj.getState();
            temp.setParent(newObj.getParent());
            temp.setState(newObj.getState());
            oldObj = newObj;
            oldObj.setParent(oldParent);
            oldObj.setState(oldState);
            newObj = temp;
            newObj.getParent().addChild(newObj);
            oldParent.addChild(oldObj);
        }
        return this.generalEndRenameObject(oldObj, newObj, success);
    }

    private final synchronized int $$robo$$android_mtp_MtpStorageManager$beginCopyObject(MtpObject object, MtpObject newParent) {
        if (sDebug) {
            Log.v(TAG, "beginCopyObject " + object.getName() + " to " + newParent.getPath());
        }
        String name = object.getName();
        if (!newParent.isDir()) {
            return -1;
        }
        if (newParent.isRoot() && this.mSubdirectories != null && !this.mSubdirectories.contains(name)) {
            return -1;
        }
        this.getChildren(newParent);
        if (newParent.getChild(name) != null) {
            return -1;
        }
        MtpObject newObj = object.copy(object.isDir());
        newParent.addChild(newObj);
        newObj.setParent(newParent);
        if (!this.generalBeginCopyObject(newObj, true)) {
            return -1;
        }
        return newObj.getId();
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$endCopyObject(MtpObject object, boolean success) {
        if (sDebug) {
            Log.v(TAG, "endCopyObject " + object.getName() + " " + success);
        }
        return this.generalEndCopyObject(object, success, false);
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$generalEndAddObject(MtpObject obj, boolean succeeded, boolean removeGlobal) {
        switch (1.$SwitchMap$android$mtp$MtpStorageManager$MtpObjectState[obj.getState().ordinal()]) {
            case 1: {
                if (succeeded) {
                    obj.setState(MtpObjectState.FROZEN_ONESHOT_ADD);
                    break;
                }
                if (this.removeObjectFromCache(obj, removeGlobal, false)) break;
                return false;
            }
            case 5: {
                obj.setState(MtpObjectState.NORMAL);
                if (succeeded) break;
                MtpObject parent = obj.getParent();
                if (!this.removeObjectFromCache(obj, removeGlobal, false)) {
                    return false;
                }
                this.handleAddedObject(parent, obj.getName(), obj.isDir());
                break;
            }
            case 2: {
                if (!this.removeObjectFromCache(obj, removeGlobal, false)) {
                    return false;
                }
                if (!succeeded) break;
                this.mMtpNotifier.sendObjectRemoved(obj.getId());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$generalEndRemoveObject(MtpObject obj, boolean success, boolean removeGlobal) {
        switch (1.$SwitchMap$android$mtp$MtpStorageManager$MtpObjectState[obj.getState().ordinal()]) {
            case 1: {
                if (success) {
                    obj.setState(MtpObjectState.FROZEN_ONESHOT_DEL);
                    break;
                }
                obj.setState(MtpObjectState.NORMAL);
                break;
            }
            case 5: {
                obj.setState(MtpObjectState.NORMAL);
                if (!success) break;
                MtpObject parent = obj.getParent();
                if (!this.removeObjectFromCache(obj, removeGlobal, false)) {
                    return false;
                }
                this.handleAddedObject(parent, obj.getName(), obj.isDir());
                break;
            }
            case 2: {
                if (!this.removeObjectFromCache(obj, removeGlobal, false)) {
                    return false;
                }
                if (success) break;
                this.mMtpNotifier.sendObjectRemoved(obj.getId());
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$generalBeginRenameObject(MtpObject fromObj, MtpObject toObj) {
        fromObj.setState(MtpObjectState.FROZEN);
        toObj.setState(MtpObjectState.FROZEN);
        fromObj.setOperation(MtpOperation.RENAME);
        toObj.setOperation(MtpOperation.RENAME);
        return true;
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$generalEndRenameObject(MtpObject fromObj, MtpObject toObj, boolean success) {
        boolean ret = this.generalEndRemoveObject(fromObj, success, !success);
        return this.generalEndAddObject(toObj, success, success) && ret;
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$generalBeginRemoveObject(MtpObject obj, MtpOperation op) {
        obj.setState(MtpObjectState.FROZEN);
        obj.setOperation(op);
        if (obj.isDir()) {
            for (MtpObject child : obj.getChildren()) {
                this.generalBeginRemoveObject(child, op);
            }
        }
        return true;
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$generalBeginCopyObject(MtpObject obj, boolean newId) {
        obj.setState(MtpObjectState.FROZEN);
        obj.setOperation(MtpOperation.COPY);
        if (newId) {
            obj.setId(this.getNextObjectId());
            this.mObjects.put(obj.getId(), obj);
        }
        if (obj.isDir()) {
            for (MtpObject child : obj.getChildren()) {
                if (this.generalBeginCopyObject(child, newId)) continue;
                return false;
            }
        }
        return true;
    }

    private final synchronized boolean $$robo$$android_mtp_MtpStorageManager$generalEndCopyObject(MtpObject obj, boolean success, boolean addGlobal) {
        if (success && addGlobal) {
            this.mObjects.put(obj.getId(), obj);
        }
        boolean ret = true;
        if (obj.isDir()) {
            for (MtpObject child : new ArrayList(obj.getChildren())) {
                if (child.getOperation() != MtpOperation.COPY) continue;
                ret = this.generalEndCopyObject(child, success, addGlobal) && ret;
            }
        }
        ret = this.generalEndAddObject(obj, success, success || !addGlobal) && ret;
        return ret;
    }

    static void __staticInitializer__() {
        TAG = MtpStorageManager.class.getSimpleName();
        sDebug = false;
    }

    private void __constructor__(MtpNotifier mtpNotifier, Set<String> set) {
        this.$$robo$$android_mtp_MtpStorageManager$__constructor__(mtpNotifier, set);
    }

    public MtpStorageManager(MtpNotifier mtpNotifier, Set<String> set) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpStorageManager$__constructor__(android.mtp.MtpStorageManager$MtpNotifier java.util.Set<java.lang.String> ), 0, this, mtpNotifier, set);
    }

    public synchronized void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_mtp_MtpStorageManager$close(), 0, this);
    }

    public synchronized void setSubdirectories(Set<String> set) {
        InvokeDynamicSupport.bootstrap("setSubdirectories", $$robo$$android_mtp_MtpStorageManager$setSubdirectories(java.util.Set<java.lang.String> ), 0, this, set);
    }

    public synchronized MtpStorage addMtpStorage(StorageVolume storageVolume) {
        return InvokeDynamicSupport.bootstrap("addMtpStorage", $$robo$$android_mtp_MtpStorageManager$addMtpStorage(android.os.storage.StorageVolume ), 0, this, storageVolume);
    }

    public synchronized void removeMtpStorage(MtpStorage mtpStorage) {
        InvokeDynamicSupport.bootstrap("removeMtpStorage", $$robo$$android_mtp_MtpStorageManager$removeMtpStorage(android.mtp.MtpStorage ), 0, this, mtpStorage);
    }

    private synchronized boolean isSpecialSubDir(MtpObject mtpObject) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSpecialSubDir", $$robo$$android_mtp_MtpStorageManager$isSpecialSubDir(android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject);
    }

    public synchronized MtpObject getByPath(String string2) {
        return InvokeDynamicSupport.bootstrap("getByPath", $$robo$$android_mtp_MtpStorageManager$getByPath(java.lang.String ), 0, this, string2);
    }

    public synchronized MtpObject getObject(int n) {
        return InvokeDynamicSupport.bootstrap("getObject", $$robo$$android_mtp_MtpStorageManager$getObject(int ), 0, this, n);
    }

    public MtpObject getStorageRoot(int n) {
        return InvokeDynamicSupport.bootstrap("getStorageRoot", $$robo$$android_mtp_MtpStorageManager$getStorageRoot(int ), 0, this, n);
    }

    private int getNextObjectId() {
        return (int)InvokeDynamicSupport.bootstrap("getNextObjectId", $$robo$$android_mtp_MtpStorageManager$getNextObjectId(), 0, this);
    }

    private int getNextStorageId() {
        return (int)InvokeDynamicSupport.bootstrap("getNextStorageId", $$robo$$android_mtp_MtpStorageManager$getNextStorageId(), 0, this);
    }

    public synchronized Stream<MtpObject> getObjects(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("getObjects", $$robo$$android_mtp_MtpStorageManager$getObjects(int int int ), 0, this, n, n2, n3);
    }

    private synchronized Stream<MtpObject> getObjects(MtpObject mtpObject, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getObjects", $$robo$$android_mtp_MtpStorageManager$getObjects(android.mtp.MtpStorageManager$MtpObject int boolean ), 0, this, mtpObject, n, bl);
    }

    private synchronized Collection<MtpObject> getChildren(MtpObject mtpObject) {
        return InvokeDynamicSupport.bootstrap("getChildren", $$robo$$android_mtp_MtpStorageManager$getChildren(android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject);
    }

    private synchronized MtpObject addObjectToCache(MtpObject mtpObject, String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("addObjectToCache", $$robo$$android_mtp_MtpStorageManager$addObjectToCache(android.mtp.MtpStorageManager$MtpObject java.lang.String boolean ), 0, this, mtpObject, string2, bl);
    }

    private synchronized boolean removeObjectFromCache(MtpObject mtpObject, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeObjectFromCache", $$robo$$android_mtp_MtpStorageManager$removeObjectFromCache(android.mtp.MtpStorageManager$MtpObject boolean boolean ), 0, this, mtpObject, bl, bl2);
    }

    private synchronized void handleAddedObject(MtpObject mtpObject, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("handleAddedObject", $$robo$$android_mtp_MtpStorageManager$handleAddedObject(android.mtp.MtpStorageManager$MtpObject java.lang.String boolean ), 0, this, mtpObject, string2, bl);
    }

    private synchronized void handleRemovedObject(MtpObject mtpObject) {
        InvokeDynamicSupport.bootstrap("handleRemovedObject", $$robo$$android_mtp_MtpStorageManager$handleRemovedObject(android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject);
    }

    public void flushEvents() {
        InvokeDynamicSupport.bootstrap("flushEvents", $$robo$$android_mtp_MtpStorageManager$flushEvents(), 0, this);
    }

    public synchronized void dump() {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_mtp_MtpStorageManager$dump(), 0, this);
    }

    public synchronized boolean checkConsistency() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkConsistency", $$robo$$android_mtp_MtpStorageManager$checkConsistency(), 0, this);
    }

    public synchronized int beginSendObject(MtpObject mtpObject, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("beginSendObject", $$robo$$android_mtp_MtpStorageManager$beginSendObject(android.mtp.MtpStorageManager$MtpObject java.lang.String int ), 0, this, mtpObject, string2, n);
    }

    public synchronized boolean endSendObject(MtpObject mtpObject, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("endSendObject", $$robo$$android_mtp_MtpStorageManager$endSendObject(android.mtp.MtpStorageManager$MtpObject boolean ), 0, this, mtpObject, bl);
    }

    public synchronized boolean beginRenameObject(MtpObject mtpObject, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("beginRenameObject", $$robo$$android_mtp_MtpStorageManager$beginRenameObject(android.mtp.MtpStorageManager$MtpObject java.lang.String ), 0, this, mtpObject, string2);
    }

    public synchronized boolean endRenameObject(MtpObject mtpObject, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("endRenameObject", $$robo$$android_mtp_MtpStorageManager$endRenameObject(android.mtp.MtpStorageManager$MtpObject java.lang.String boolean ), 0, this, mtpObject, string2, bl);
    }

    public synchronized boolean beginRemoveObject(MtpObject mtpObject) {
        return (boolean)InvokeDynamicSupport.bootstrap("beginRemoveObject", $$robo$$android_mtp_MtpStorageManager$beginRemoveObject(android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject);
    }

    public synchronized boolean endRemoveObject(MtpObject mtpObject, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("endRemoveObject", $$robo$$android_mtp_MtpStorageManager$endRemoveObject(android.mtp.MtpStorageManager$MtpObject boolean ), 0, this, mtpObject, bl);
    }

    public synchronized boolean beginMoveObject(MtpObject mtpObject, MtpObject mtpObject2) {
        return (boolean)InvokeDynamicSupport.bootstrap("beginMoveObject", $$robo$$android_mtp_MtpStorageManager$beginMoveObject(android.mtp.MtpStorageManager$MtpObject android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject, mtpObject2);
    }

    public synchronized boolean endMoveObject(MtpObject mtpObject, MtpObject mtpObject2, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("endMoveObject", $$robo$$android_mtp_MtpStorageManager$endMoveObject(android.mtp.MtpStorageManager$MtpObject android.mtp.MtpStorageManager$MtpObject java.lang.String boolean ), 0, this, mtpObject, mtpObject2, string2, bl);
    }

    public synchronized int beginCopyObject(MtpObject mtpObject, MtpObject mtpObject2) {
        return (int)InvokeDynamicSupport.bootstrap("beginCopyObject", $$robo$$android_mtp_MtpStorageManager$beginCopyObject(android.mtp.MtpStorageManager$MtpObject android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject, mtpObject2);
    }

    public synchronized boolean endCopyObject(MtpObject mtpObject, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("endCopyObject", $$robo$$android_mtp_MtpStorageManager$endCopyObject(android.mtp.MtpStorageManager$MtpObject boolean ), 0, this, mtpObject, bl);
    }

    private synchronized boolean generalEndAddObject(MtpObject mtpObject, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("generalEndAddObject", $$robo$$android_mtp_MtpStorageManager$generalEndAddObject(android.mtp.MtpStorageManager$MtpObject boolean boolean ), 0, this, mtpObject, bl, bl2);
    }

    private synchronized boolean generalEndRemoveObject(MtpObject mtpObject, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("generalEndRemoveObject", $$robo$$android_mtp_MtpStorageManager$generalEndRemoveObject(android.mtp.MtpStorageManager$MtpObject boolean boolean ), 0, this, mtpObject, bl, bl2);
    }

    private synchronized boolean generalBeginRenameObject(MtpObject mtpObject, MtpObject mtpObject2) {
        return (boolean)InvokeDynamicSupport.bootstrap("generalBeginRenameObject", $$robo$$android_mtp_MtpStorageManager$generalBeginRenameObject(android.mtp.MtpStorageManager$MtpObject android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject, mtpObject2);
    }

    private synchronized boolean generalEndRenameObject(MtpObject mtpObject, MtpObject mtpObject2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("generalEndRenameObject", $$robo$$android_mtp_MtpStorageManager$generalEndRenameObject(android.mtp.MtpStorageManager$MtpObject android.mtp.MtpStorageManager$MtpObject boolean ), 0, this, mtpObject, mtpObject2, bl);
    }

    private synchronized boolean generalBeginRemoveObject(MtpObject mtpObject, MtpOperation mtpOperation) {
        return (boolean)InvokeDynamicSupport.bootstrap("generalBeginRemoveObject", $$robo$$android_mtp_MtpStorageManager$generalBeginRemoveObject(android.mtp.MtpStorageManager$MtpObject android.mtp.MtpStorageManager$MtpOperation ), 0, this, mtpObject, mtpOperation);
    }

    private synchronized boolean generalBeginCopyObject(MtpObject mtpObject, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("generalBeginCopyObject", $$robo$$android_mtp_MtpStorageManager$generalBeginCopyObject(android.mtp.MtpStorageManager$MtpObject boolean ), 0, this, mtpObject, bl);
    }

    private synchronized boolean generalEndCopyObject(MtpObject mtpObject, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("generalEndCopyObject", $$robo$$android_mtp_MtpStorageManager$generalEndCopyObject(android.mtp.MtpStorageManager$MtpObject boolean boolean ), 0, this, mtpObject, bl, bl2);
    }

    static {
        RobolectricInternals.classInitializing(MtpStorageManager.class);
    }

    public /* synthetic */ MtpStorageManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MtpStorageManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class MtpNotifier
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_mtp_MtpStorageManager_MtpNotifier$__constructor__() {
        }

        public abstract void sendObjectAdded(int var1);

        public abstract void sendObjectRemoved(int var1);

        private void __constructor__() {
            this.$$robo$$android_mtp_MtpStorageManager_MtpNotifier$__constructor__();
        }

        public MtpNotifier() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpStorageManager_MtpNotifier$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MtpNotifier)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MtpObject
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private MtpObject mParent;
        private String mName;
        private int mId;
        private MtpObjectState mState;
        private MtpOperation mOp;
        private boolean mVisited;
        private boolean mIsDir;
        private HashMap<String, MtpObject> mChildren;
        private FileObserver mObserver;

        private void $$robo$$android_mtp_MtpStorageManager_MtpObject$__constructor__(String name, int id2, MtpObject parent, boolean isDir) {
            this.mId = id2;
            this.mName = name;
            this.mParent = parent;
            this.mObserver = null;
            this.mVisited = false;
            this.mState = MtpObjectState.NORMAL;
            this.mIsDir = isDir;
            this.mOp = MtpOperation.NONE;
            this.mChildren = this.mIsDir ? new HashMap() : null;
        }

        private final String $$robo$$android_mtp_MtpStorageManager_MtpObject$getName() {
            return this.mName;
        }

        private final int $$robo$$android_mtp_MtpStorageManager_MtpObject$getId() {
            return this.mId;
        }

        private final boolean $$robo$$android_mtp_MtpStorageManager_MtpObject$isDir() {
            return this.mIsDir;
        }

        private final int $$robo$$android_mtp_MtpStorageManager_MtpObject$getFormat() {
            return this.mIsDir ? 12289 : MediaFile.getFormatCode(this.mName, null);
        }

        private final int $$robo$$android_mtp_MtpStorageManager_MtpObject$getStorageId() {
            return this.getRoot().getId();
        }

        private final long $$robo$$android_mtp_MtpStorageManager_MtpObject$getModifiedTime() {
            return this.getPath().toFile().lastModified() / 1000L;
        }

        private final MtpObject $$robo$$android_mtp_MtpStorageManager_MtpObject$getParent() {
            return this.mParent;
        }

        private final MtpObject $$robo$$android_mtp_MtpStorageManager_MtpObject$getRoot() {
            return this.isRoot() ? this : this.mParent.getRoot();
        }

        private final long $$robo$$android_mtp_MtpStorageManager_MtpObject$getSize() {
            return this.mIsDir ? 0L : this.getPath().toFile().length();
        }

        private final Path $$robo$$android_mtp_MtpStorageManager_MtpObject$getPath() {
            return this.isRoot() ? Paths.get(this.mName, new String[0]) : this.mParent.getPath().resolve(this.mName);
        }

        private final boolean $$robo$$android_mtp_MtpStorageManager_MtpObject$isRoot() {
            return this.mParent == null;
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$setName(String name) {
            this.mName = name;
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$setId(int id2) {
            this.mId = id2;
        }

        private final boolean $$robo$$android_mtp_MtpStorageManager_MtpObject$isVisited() {
            return this.mVisited;
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$setParent(MtpObject parent) {
            this.mParent = parent;
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$setDir(boolean dir) {
            if (dir != this.mIsDir) {
                this.mIsDir = dir;
                this.mChildren = this.mIsDir ? new HashMap() : null;
            }
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$setVisited(boolean visited) {
            this.mVisited = visited;
        }

        private final MtpObjectState $$robo$$android_mtp_MtpStorageManager_MtpObject$getState() {
            return this.mState;
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$setState(MtpObjectState state) {
            this.mState = state;
            if (this.mState == MtpObjectState.NORMAL) {
                this.mOp = MtpOperation.NONE;
            }
        }

        private final MtpOperation $$robo$$android_mtp_MtpStorageManager_MtpObject$getOperation() {
            return this.mOp;
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$setOperation(MtpOperation op) {
            this.mOp = op;
        }

        private final FileObserver $$robo$$android_mtp_MtpStorageManager_MtpObject$getObserver() {
            return this.mObserver;
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$setObserver(FileObserver observer) {
            this.mObserver = observer;
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObject$addChild(MtpObject child) {
            this.mChildren.put(child.getName(), child);
        }

        private final MtpObject $$robo$$android_mtp_MtpStorageManager_MtpObject$getChild(String name) {
            return this.mChildren.get(name);
        }

        private final Collection<MtpObject> $$robo$$android_mtp_MtpStorageManager_MtpObject$getChildren() {
            return this.mChildren.values();
        }

        private final boolean $$robo$$android_mtp_MtpStorageManager_MtpObject$exists() {
            return this.getPath().toFile().exists();
        }

        private final MtpObject $$robo$$android_mtp_MtpStorageManager_MtpObject$copy(boolean recursive) {
            MtpObject copy = new MtpObject(this.mName, this.mId, this.mParent, this.mIsDir);
            copy.mIsDir = this.mIsDir;
            copy.mVisited = this.mVisited;
            copy.mState = this.mState;
            HashMap hashMap = copy.mChildren = this.mIsDir ? new HashMap() : null;
            if (recursive && this.mIsDir) {
                for (MtpObject child : this.mChildren.values()) {
                    MtpObject childCopy = child.copy(true);
                    childCopy.setParent(copy);
                    copy.addChild(childCopy);
                }
            }
            return copy;
        }

        private void __constructor__(String string2, int n, MtpObject mtpObject, boolean bl) {
            this.$$robo$$android_mtp_MtpStorageManager_MtpObject$__constructor__(string2, n, mtpObject, bl);
        }

        MtpObject(String string2, int n, MtpObject mtpObject, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpStorageManager_MtpObject$__constructor__(java.lang.String int android.mtp.MtpStorageManager$MtpObject boolean ), 0, this, string2, n, mtpObject, bl);
        }

        public String getName() {
            return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_mtp_MtpStorageManager_MtpObject$getName(), 0, this);
        }

        public int getId() {
            return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_mtp_MtpStorageManager_MtpObject$getId(), 0, this);
        }

        public boolean isDir() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDir", $$robo$$android_mtp_MtpStorageManager_MtpObject$isDir(), 0, this);
        }

        public int getFormat() {
            return (int)InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_mtp_MtpStorageManager_MtpObject$getFormat(), 0, this);
        }

        public int getStorageId() {
            return (int)InvokeDynamicSupport.bootstrap("getStorageId", $$robo$$android_mtp_MtpStorageManager_MtpObject$getStorageId(), 0, this);
        }

        public long getModifiedTime() {
            return (long)InvokeDynamicSupport.bootstrap("getModifiedTime", $$robo$$android_mtp_MtpStorageManager_MtpObject$getModifiedTime(), 0, this);
        }

        public MtpObject getParent() {
            return InvokeDynamicSupport.bootstrap("getParent", $$robo$$android_mtp_MtpStorageManager_MtpObject$getParent(), 0, this);
        }

        public MtpObject getRoot() {
            return InvokeDynamicSupport.bootstrap("getRoot", $$robo$$android_mtp_MtpStorageManager_MtpObject$getRoot(), 0, this);
        }

        public long getSize() {
            return (long)InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_mtp_MtpStorageManager_MtpObject$getSize(), 0, this);
        }

        public Path getPath() {
            return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_mtp_MtpStorageManager_MtpObject$getPath(), 0, this);
        }

        public boolean isRoot() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRoot", $$robo$$android_mtp_MtpStorageManager_MtpObject$isRoot(), 0, this);
        }

        private void setName(String string2) {
            InvokeDynamicSupport.bootstrap("setName", $$robo$$android_mtp_MtpStorageManager_MtpObject$setName(java.lang.String ), 0, this, string2);
        }

        private void setId(int n) {
            InvokeDynamicSupport.bootstrap("setId", $$robo$$android_mtp_MtpStorageManager_MtpObject$setId(int ), 0, this, n);
        }

        private boolean isVisited() {
            return (boolean)InvokeDynamicSupport.bootstrap("isVisited", $$robo$$android_mtp_MtpStorageManager_MtpObject$isVisited(), 0, this);
        }

        private void setParent(MtpObject mtpObject) {
            InvokeDynamicSupport.bootstrap("setParent", $$robo$$android_mtp_MtpStorageManager_MtpObject$setParent(android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject);
        }

        private void setDir(boolean bl) {
            InvokeDynamicSupport.bootstrap("setDir", $$robo$$android_mtp_MtpStorageManager_MtpObject$setDir(boolean ), 0, this, bl);
        }

        private void setVisited(boolean bl) {
            InvokeDynamicSupport.bootstrap("setVisited", $$robo$$android_mtp_MtpStorageManager_MtpObject$setVisited(boolean ), 0, this, bl);
        }

        private MtpObjectState getState() {
            return InvokeDynamicSupport.bootstrap("getState", $$robo$$android_mtp_MtpStorageManager_MtpObject$getState(), 0, this);
        }

        private void setState(MtpObjectState mtpObjectState) {
            InvokeDynamicSupport.bootstrap("setState", $$robo$$android_mtp_MtpStorageManager_MtpObject$setState(android.mtp.MtpStorageManager$MtpObjectState ), 0, this, mtpObjectState);
        }

        private MtpOperation getOperation() {
            return InvokeDynamicSupport.bootstrap("getOperation", $$robo$$android_mtp_MtpStorageManager_MtpObject$getOperation(), 0, this);
        }

        private void setOperation(MtpOperation mtpOperation) {
            InvokeDynamicSupport.bootstrap("setOperation", $$robo$$android_mtp_MtpStorageManager_MtpObject$setOperation(android.mtp.MtpStorageManager$MtpOperation ), 0, this, mtpOperation);
        }

        private FileObserver getObserver() {
            return InvokeDynamicSupport.bootstrap("getObserver", $$robo$$android_mtp_MtpStorageManager_MtpObject$getObserver(), 0, this);
        }

        private void setObserver(FileObserver fileObserver) {
            InvokeDynamicSupport.bootstrap("setObserver", $$robo$$android_mtp_MtpStorageManager_MtpObject$setObserver(android.os.FileObserver ), 0, this, fileObserver);
        }

        private void addChild(MtpObject mtpObject) {
            InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_mtp_MtpStorageManager_MtpObject$addChild(android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpObject);
        }

        private MtpObject getChild(String string2) {
            return InvokeDynamicSupport.bootstrap("getChild", $$robo$$android_mtp_MtpStorageManager_MtpObject$getChild(java.lang.String ), 0, this, string2);
        }

        private Collection<MtpObject> getChildren() {
            return InvokeDynamicSupport.bootstrap("getChildren", $$robo$$android_mtp_MtpStorageManager_MtpObject$getChildren(), 0, this);
        }

        private boolean exists() {
            return (boolean)InvokeDynamicSupport.bootstrap("exists", $$robo$$android_mtp_MtpStorageManager_MtpObject$exists(), 0, this);
        }

        private MtpObject copy(boolean bl) {
            return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_mtp_MtpStorageManager_MtpObject$copy(boolean ), 0, this, bl);
        }

        public /* synthetic */ MtpObject() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MtpObject)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class MtpOperation
    extends Enum<MtpOperation> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ MtpOperation NONE;
        public static /* enum */ MtpOperation ADD;
        public static /* enum */ MtpOperation RENAME;
        public static /* enum */ MtpOperation COPY;
        public static /* enum */ MtpOperation DELETE;
        private static /* synthetic */ MtpOperation[] $VALUES;

        private static final MtpOperation[] $$robo$$android_mtp_MtpStorageManager_MtpOperation$values() {
            return (MtpOperation[])$VALUES.clone();
        }

        private static final MtpOperation $$robo$$android_mtp_MtpStorageManager_MtpOperation$valueOf(String name) {
            return Enum.valueOf(MtpOperation.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_mtp_MtpStorageManager_MtpOperation$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NONE = new MtpOperation();
            ADD = new MtpOperation();
            RENAME = new MtpOperation();
            COPY = new MtpOperation();
            DELETE = new MtpOperation();
            $VALUES = new MtpOperation[]{NONE, ADD, RENAME, COPY, DELETE};
        }

        public static MtpOperation[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_mtp_MtpStorageManager_MtpOperation$values(), 0);
        }

        public static MtpOperation valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_mtp_MtpStorageManager_MtpOperation$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_mtp_MtpStorageManager_MtpOperation$__constructor__(string2, n);
        }

        private MtpOperation() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpStorageManager_MtpOperation$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(MtpOperation.class);
        }

        public /* synthetic */ MtpOperation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MtpOperation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class MtpObjectState
    extends Enum<MtpObjectState> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ MtpObjectState NORMAL;
        public static /* enum */ MtpObjectState FROZEN;
        public static /* enum */ MtpObjectState FROZEN_ADDED;
        public static /* enum */ MtpObjectState FROZEN_REMOVED;
        public static /* enum */ MtpObjectState FROZEN_ONESHOT_ADD;
        public static /* enum */ MtpObjectState FROZEN_ONESHOT_DEL;
        private static /* synthetic */ MtpObjectState[] $VALUES;

        private static final MtpObjectState[] $$robo$$android_mtp_MtpStorageManager_MtpObjectState$values() {
            return (MtpObjectState[])$VALUES.clone();
        }

        private static final MtpObjectState $$robo$$android_mtp_MtpStorageManager_MtpObjectState$valueOf(String name) {
            return Enum.valueOf(MtpObjectState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_mtp_MtpStorageManager_MtpObjectState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NORMAL = new MtpObjectState();
            FROZEN = new MtpObjectState();
            FROZEN_ADDED = new MtpObjectState();
            FROZEN_REMOVED = new MtpObjectState();
            FROZEN_ONESHOT_ADD = new MtpObjectState();
            FROZEN_ONESHOT_DEL = new MtpObjectState();
            $VALUES = new MtpObjectState[]{NORMAL, FROZEN, FROZEN_ADDED, FROZEN_REMOVED, FROZEN_ONESHOT_ADD, FROZEN_ONESHOT_DEL};
        }

        public static MtpObjectState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_mtp_MtpStorageManager_MtpObjectState$values(), 0);
        }

        public static MtpObjectState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_mtp_MtpStorageManager_MtpObjectState$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_mtp_MtpStorageManager_MtpObjectState$__constructor__(string2, n);
        }

        private MtpObjectState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpStorageManager_MtpObjectState$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(MtpObjectState.class);
        }

        public /* synthetic */ MtpObjectState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MtpObjectState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MtpObjectObserver
    extends FileObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        MtpObject mObject;
        /* synthetic */ MtpStorageManager this$0;

        private void $$robo$$android_mtp_MtpStorageManager_MtpObjectObserver$__constructor__(MtpStorageManager mtpStorageManager, MtpObject object) {
            this.mObject = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_mtp_MtpStorageManager_MtpObjectObserver$onEvent(int event, String path) {
            MtpStorageManager mtpStorageManager = this.this$0;
            synchronized (mtpStorageManager) {
                if ((event & 0x4000) != 0) {
                    Log.e(TAG, "Received Inotify overflow event!");
                }
                MtpObject obj = this.mObject.getChild(path);
                if ((event & 0x80) != 0 || (event & 0x100) != 0) {
                    if (sDebug) {
                        Log.i(TAG, "Got inotify added event for " + path + " " + event);
                    }
                    this.this$0.handleAddedObject(this.mObject, path, (event & 0x40000000) != 0);
                } else if ((event & 0x40) != 0 || (event & 0x200) != 0) {
                    if (obj == null) {
                        Log.w(TAG, "Object was null in event " + path);
                        return;
                    }
                    if (sDebug) {
                        Log.i(TAG, "Got inotify removed event for " + path + " " + event);
                    }
                    this.this$0.handleRemovedObject(obj);
                } else if ((event & 0x8000) != 0) {
                    if (sDebug) {
                        Log.i(TAG, "inotify for " + this.mObject.getPath() + " deleted");
                    }
                    if (this.mObject.mObserver != null) {
                        this.mObject.mObserver.stopWatching();
                    }
                    this.mObject.mObserver = null;
                } else {
                    Log.w(TAG, "Got unrecognized event " + path + " " + event);
                }
            }
        }

        private final void $$robo$$android_mtp_MtpStorageManager_MtpObjectObserver$finalize() {
        }

        private void __constructor__(MtpStorageManager mtpStorageManager, MtpObject mtpObject) {
            this.$$robo$$android_mtp_MtpStorageManager_MtpObjectObserver$__constructor__(mtpStorageManager, mtpObject);
        }

        MtpObjectObserver(MtpStorageManager mtpStorageManager, MtpObject mtpObject) {
            this.this$0 = mtpStorageManager;
            super(mtpObject.getPath().toString(), 16778176);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_mtp_MtpStorageManager_MtpObjectObserver$__constructor__(android.mtp.MtpStorageManager android.mtp.MtpStorageManager$MtpObject ), 0, this, mtpStorageManager, mtpObject);
        }

        @Override
        public void onEvent(int n, String string2) {
            InvokeDynamicSupport.bootstrap("onEvent", $$robo$$android_mtp_MtpStorageManager_MtpObjectObserver$onEvent(int java.lang.String ), 0, this, n, string2);
        }

        @Override
        public void finalize() {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_mtp_MtpStorageManager_MtpObjectObserver$finalize(), 0, this);
        }

        public /* synthetic */ MtpObjectObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MtpObjectObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

