/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.IIpSecService;
import android.net.IpSecAlgorithm;
import android.net.IpSecConfig;
import android.net.IpSecManager;
import android.net.IpSecTransformResponse;
import android.net.NetworkUtils;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.CloseGuard;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.InetAddress;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class IpSecTransform
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "IpSecTransform";
    public static int MODE_TRANSPORT = 0;
    public static int MODE_TUNNEL = 1;
    public static int ENCAP_NONE = 0;
    public static int ENCAP_ESPINUDP_NON_IKE = 1;
    public static int ENCAP_ESPINUDP = 2;
    private IpSecConfig mConfig;
    private int mResourceId;
    private Context mContext;
    private CloseGuard mCloseGuard;
    private ConnectivityManager.PacketKeepalive mKeepalive;
    private Handler mCallbackHandler;
    private ConnectivityManager.PacketKeepaliveCallback mKeepaliveCallback;
    private NattKeepaliveCallback mUserKeepaliveCallback;

    @VisibleForTesting
    private void $$robo$$android_net_IpSecTransform$__constructor__(Context context, IpSecConfig config) {
        this.mCloseGuard = CloseGuard.get();
        this.mKeepaliveCallback = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IpSecTransform this$0;

            private void $$robo$$android_net_IpSecTransform_1$__constructor__(IpSecTransform this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_IpSecTransform_1$onStarted() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.this$0.mCallbackHandler.post(() -> this.this$0.mUserKeepaliveCallback.onStarted());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_IpSecTransform_1$onStopped() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.this$0.mKeepalive = null;
                    this.this$0.mCallbackHandler.post(() -> this.this$0.mUserKeepaliveCallback.onStopped());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_IpSecTransform_1$onError(int error) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.this$0.mKeepalive = null;
                    this.this$0.mCallbackHandler.post(() -> this.this$0.mUserKeepaliveCallback.onError(error));
                }
            }

            private void __constructor__(IpSecTransform ipSecTransform) {
                this.$$robo$$android_net_IpSecTransform_1$__constructor__(ipSecTransform);
            }
            {
                this.this$0 = ipSecTransform;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecTransform_1$__constructor__(android.net.IpSecTransform ), 0, this, ipSecTransform);
            }

            @Override
            public void onStarted() {
                InvokeDynamicSupport.bootstrap("onStarted", $$robo$$android_net_IpSecTransform_1$onStarted(), 0, this);
            }

            @Override
            public void onStopped() {
                InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_net_IpSecTransform_1$onStopped(), 0, this);
            }

            @Override
            public void onError(int n) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_net_IpSecTransform_1$onError(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mConfig = new IpSecConfig(config);
        this.mResourceId = -1;
    }

    private final IIpSecService $$robo$$android_net_IpSecTransform$getIpSecService() {
        IBinder b = ServiceManager.getService("ipsec");
        if (b == null) {
            throw new RemoteException("Failed to connect to IpSecService").rethrowAsRuntimeException();
        }
        return IIpSecService.Stub.asInterface(b);
    }

    private final void $$robo$$android_net_IpSecTransform$checkResultStatus(int status) throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        switch (status) {
            case 0: {
                return;
            }
            case 1: {
                throw new IpSecManager.ResourceUnavailableException("Failed to allocate a new IpSecTransform");
            }
            case 2: {
                Log.wtf("IpSecTransform", "Attempting to use an SPI that was somehow not reserved");
            }
        }
        throw new IllegalStateException("Failed to Create a Transform with status code " + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IpSecTransform $$robo$$android_net_IpSecTransform$activate() throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        IpSecTransform ipSecTransform = this;
        synchronized (ipSecTransform) {
            try {
                IIpSecService svc = this.getIpSecService();
                IpSecTransformResponse result = svc.createTransform(this.mConfig, new Binder(), this.mContext.getOpPackageName());
                int status = result.status;
                this.checkResultStatus(status);
                this.mResourceId = result.resourceId;
                Log.d("IpSecTransform", "Added Transform with Id " + this.mResourceId);
                this.mCloseGuard.open("build");
            }
            catch (ServiceSpecificException e) {
                throw IpSecManager.rethrowUncheckedExceptionFromServiceSpecificException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
        return this;
    }

    @VisibleForTesting
    private static final boolean $$robo$$android_net_IpSecTransform$equals(IpSecTransform lhs, IpSecTransform rhs) {
        if (lhs == null || rhs == null) {
            return lhs == rhs;
        }
        return IpSecConfig.equals(lhs.getConfig(), rhs.getConfig()) && lhs.mResourceId == rhs.mResourceId;
    }

    private final void $$robo$$android_net_IpSecTransform$close() {
        Log.d("IpSecTransform", "Removing Transform with Id " + this.mResourceId);
        if (this.mResourceId == -1) {
            this.mCloseGuard.close();
            return;
        }
        try {
            IIpSecService svc = this.getIpSecService();
            svc.deleteTransform(this.mResourceId);
            this.stopNattKeepalive();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        catch (Exception e) {
            Log.e("IpSecTransform", "Failed to close " + this + ", Exception=" + e);
        }
        finally {
            this.mResourceId = -1;
            this.mCloseGuard.close();
        }
    }

    private final void $$robo$$android_net_IpSecTransform$finalize() throws Throwable {
        if (this.mCloseGuard != null) {
            this.mCloseGuard.warnIfOpen();
        }
        this.close();
    }

    private final IpSecConfig $$robo$$android_net_IpSecTransform$getConfig() {
        return this.mConfig;
    }

    @VisibleForTesting
    private final int $$robo$$android_net_IpSecTransform$getResourceId() {
        return this.mResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_IpSecTransform$startNattKeepalive(NattKeepaliveCallback userCallback, int intervalSeconds, Handler handler) throws IOException {
        Preconditions.checkNotNull(userCallback);
        if (intervalSeconds < 20 || intervalSeconds > 3600) {
            throw new IllegalArgumentException("Invalid NAT-T keepalive interval");
        }
        Preconditions.checkNotNull(handler);
        if (this.mResourceId == -1) {
            throw new IllegalStateException("Packet keepalive cannot be started for an inactive transform");
        }
        ConnectivityManager.PacketKeepaliveCallback packetKeepaliveCallback = this.mKeepaliveCallback;
        synchronized (packetKeepaliveCallback) {
            if (this.mKeepaliveCallback != null) {
                throw new IllegalStateException("Keepalive already active");
            }
            this.mUserKeepaliveCallback = userCallback;
            ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            this.mKeepalive = cm.startNattKeepalive(this.mConfig.getNetwork(), intervalSeconds, this.mKeepaliveCallback, NetworkUtils.numericToInetAddress(this.mConfig.getSourceAddress()), 4500, NetworkUtils.numericToInetAddress(this.mConfig.getDestinationAddress()));
            this.mCallbackHandler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_IpSecTransform$stopNattKeepalive() {
        ConnectivityManager.PacketKeepaliveCallback packetKeepaliveCallback = this.mKeepaliveCallback;
        synchronized (packetKeepaliveCallback) {
            if (this.mKeepalive == null) {
                Log.e("IpSecTransform", "No active keepalive to stop");
                return;
            }
            this.mKeepalive.stop();
        }
    }

    private final String $$robo$$android_net_IpSecTransform$toString() {
        return "IpSecTransform{resourceId=" + this.mResourceId + "}";
    }

    private void __constructor__(Context context, IpSecConfig ipSecConfig) {
        this.$$robo$$android_net_IpSecTransform$__constructor__(context, ipSecConfig);
    }

    public IpSecTransform(Context context, IpSecConfig ipSecConfig) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecTransform$__constructor__(android.content.Context android.net.IpSecConfig ), 0, this, context, ipSecConfig);
    }

    private IIpSecService getIpSecService() {
        return InvokeDynamicSupport.bootstrap("getIpSecService", $$robo$$android_net_IpSecTransform$getIpSecService(), 0, this);
    }

    private void checkResultStatus(int n) throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        InvokeDynamicSupport.bootstrap("checkResultStatus", $$robo$$android_net_IpSecTransform$checkResultStatus(int ), 0, this, n);
    }

    private IpSecTransform activate() throws IOException, IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException {
        return InvokeDynamicSupport.bootstrap("activate", $$robo$$android_net_IpSecTransform$activate(), 0, this);
    }

    public static boolean equals(IpSecTransform ipSecTransform, IpSecTransform ipSecTransform2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equals", $$robo$$android_net_IpSecTransform$equals(android.net.IpSecTransform android.net.IpSecTransform ), 0, (IpSecTransform)ipSecTransform, (IpSecTransform)ipSecTransform2);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_IpSecTransform$close(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_IpSecTransform$finalize(), 0, this);
    }

    IpSecConfig getConfig() {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_net_IpSecTransform$getConfig(), 0, this);
    }

    public int getResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$android_net_IpSecTransform$getResourceId(), 0, this);
    }

    public void startNattKeepalive(NattKeepaliveCallback nattKeepaliveCallback, int n, Handler handler) throws IOException {
        InvokeDynamicSupport.bootstrap("startNattKeepalive", $$robo$$android_net_IpSecTransform$startNattKeepalive(android.net.IpSecTransform$NattKeepaliveCallback int android.os.Handler ), 0, this, nattKeepaliveCallback, n, handler);
    }

    public void stopNattKeepalive() {
        InvokeDynamicSupport.bootstrap("stopNattKeepalive", $$robo$$android_net_IpSecTransform$stopNattKeepalive(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_IpSecTransform$toString(), 0, this);
    }

    public /* synthetic */ IpSecTransform() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpSecTransform)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private IpSecConfig mConfig;

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setEncryption(IpSecAlgorithm algo) {
            Preconditions.checkNotNull(algo);
            this.mConfig.setEncryption(algo);
            return this;
        }

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setAuthentication(IpSecAlgorithm algo) {
            Preconditions.checkNotNull(algo);
            this.mConfig.setAuthentication(algo);
            return this;
        }

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setAuthenticatedEncryption(IpSecAlgorithm algo) {
            Preconditions.checkNotNull(algo);
            this.mConfig.setAuthenticatedEncryption(algo);
            return this;
        }

        private final Builder $$robo$$android_net_IpSecTransform_Builder$setIpv4Encapsulation(IpSecManager.UdpEncapsulationSocket localSocket, int remotePort) {
            Preconditions.checkNotNull(localSocket);
            this.mConfig.setEncapType(2);
            if (localSocket.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid UdpEncapsulationSocket");
            }
            this.mConfig.setEncapSocketResourceId(localSocket.getResourceId());
            this.mConfig.setEncapRemotePort(remotePort);
            return this;
        }

        private final IpSecTransform $$robo$$android_net_IpSecTransform_Builder$buildTransportModeTransform(InetAddress sourceAddress, IpSecManager.SecurityParameterIndex spi) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            Preconditions.checkNotNull(sourceAddress);
            Preconditions.checkNotNull(spi);
            if (spi.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid SecurityParameterIndex");
            }
            this.mConfig.setMode(0);
            this.mConfig.setSourceAddress(sourceAddress.getHostAddress());
            this.mConfig.setSpiResourceId(spi.getResourceId());
            return new IpSecTransform(this.mContext, this.mConfig).activate();
        }

        private final IpSecTransform $$robo$$android_net_IpSecTransform_Builder$buildTunnelModeTransform(InetAddress sourceAddress, IpSecManager.SecurityParameterIndex spi) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            Preconditions.checkNotNull(sourceAddress);
            Preconditions.checkNotNull(spi);
            if (spi.getResourceId() == -1) {
                throw new IllegalArgumentException("Invalid SecurityParameterIndex");
            }
            this.mConfig.setMode(1);
            this.mConfig.setSourceAddress(sourceAddress.getHostAddress());
            this.mConfig.setSpiResourceId(spi.getResourceId());
            return new IpSecTransform(this.mContext, this.mConfig).activate();
        }

        private void $$robo$$android_net_IpSecTransform_Builder$__constructor__(Context context) {
            Preconditions.checkNotNull(context);
            this.mContext = context;
            this.mConfig = new IpSecConfig();
        }

        public Builder setEncryption(IpSecAlgorithm ipSecAlgorithm) {
            return InvokeDynamicSupport.bootstrap("setEncryption", $$robo$$android_net_IpSecTransform_Builder$setEncryption(android.net.IpSecAlgorithm ), 0, this, ipSecAlgorithm);
        }

        public Builder setAuthentication(IpSecAlgorithm ipSecAlgorithm) {
            return InvokeDynamicSupport.bootstrap("setAuthentication", $$robo$$android_net_IpSecTransform_Builder$setAuthentication(android.net.IpSecAlgorithm ), 0, this, ipSecAlgorithm);
        }

        public Builder setAuthenticatedEncryption(IpSecAlgorithm ipSecAlgorithm) {
            return InvokeDynamicSupport.bootstrap("setAuthenticatedEncryption", $$robo$$android_net_IpSecTransform_Builder$setAuthenticatedEncryption(android.net.IpSecAlgorithm ), 0, this, ipSecAlgorithm);
        }

        public Builder setIpv4Encapsulation(IpSecManager.UdpEncapsulationSocket udpEncapsulationSocket, int n) {
            return InvokeDynamicSupport.bootstrap("setIpv4Encapsulation", $$robo$$android_net_IpSecTransform_Builder$setIpv4Encapsulation(android.net.IpSecManager$UdpEncapsulationSocket int ), 0, this, udpEncapsulationSocket, n);
        }

        public IpSecTransform buildTransportModeTransform(InetAddress inetAddress, IpSecManager.SecurityParameterIndex securityParameterIndex) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            return InvokeDynamicSupport.bootstrap("buildTransportModeTransform", $$robo$$android_net_IpSecTransform_Builder$buildTransportModeTransform(java.net.InetAddress android.net.IpSecManager$SecurityParameterIndex ), 0, this, inetAddress, securityParameterIndex);
        }

        public IpSecTransform buildTunnelModeTransform(InetAddress inetAddress, IpSecManager.SecurityParameterIndex securityParameterIndex) throws IpSecManager.ResourceUnavailableException, IpSecManager.SpiUnavailableException, IOException {
            return InvokeDynamicSupport.bootstrap("buildTunnelModeTransform", $$robo$$android_net_IpSecTransform_Builder$buildTunnelModeTransform(java.net.InetAddress android.net.IpSecManager$SecurityParameterIndex ), 0, this, inetAddress, securityParameterIndex);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_net_IpSecTransform_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecTransform_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NattKeepaliveCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int ERROR_INVALID_NETWORK = 1;
        public static int ERROR_HARDWARE_UNSUPPORTED = 2;
        public static int ERROR_HARDWARE_ERROR = 3;

        private void $$robo$$android_net_IpSecTransform_NattKeepaliveCallback$__constructor__() {
        }

        private final void $$robo$$android_net_IpSecTransform_NattKeepaliveCallback$onStarted() {
        }

        private final void $$robo$$android_net_IpSecTransform_NattKeepaliveCallback$onStopped() {
        }

        private final void $$robo$$android_net_IpSecTransform_NattKeepaliveCallback$onError(int error) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_IpSecTransform_NattKeepaliveCallback$__constructor__();
        }

        public NattKeepaliveCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_IpSecTransform_NattKeepaliveCallback$__constructor__(), 0, this);
        }

        public void onStarted() {
            InvokeDynamicSupport.bootstrap("onStarted", $$robo$$android_net_IpSecTransform_NattKeepaliveCallback$onStarted(), 0, this);
        }

        public void onStopped() {
            InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_net_IpSecTransform_NattKeepaliveCallback$onStopped(), 0, this);
        }

        public void onError(int n) {
            InvokeDynamicSupport.bootstrap("onError", $$robo$$android_net_IpSecTransform_NattKeepaliveCallback$onError(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NattKeepaliveCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncapType {
    }
}

