/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MacAddress
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int ETHER_ADDR_LEN = 6;
    private static byte[] ETHER_ADDR_BROADCAST;
    public static MacAddress BROADCAST_ADDRESS;
    public static MacAddress ALL_ZEROS_ADDRESS;
    public static int TYPE_UNKNOWN = 0;
    public static int TYPE_UNICAST = 1;
    public static int TYPE_MULTICAST = 2;
    public static int TYPE_BROADCAST = 3;
    private static long VALID_LONG_MASK = 0xFFFFFFFFFFFFL;
    private static long LOCALLY_ASSIGNED_MASK;
    private static long MULTICAST_MASK;
    private static long OUI_MASK;
    private static long NIC_MASK;
    private static MacAddress BASE_GOOGLE_MAC;
    private long mAddr;
    public static Parcelable.Creator<MacAddress> CREATOR;

    private void $$robo$$android_net_MacAddress$__constructor__(long addr) {
        this.mAddr = 0xFFFFFFFFFFFFL & addr;
    }

    private final int $$robo$$android_net_MacAddress$getAddressType() {
        if (this.equals(BROADCAST_ADDRESS)) {
            return 3;
        }
        if (this.isMulticastAddress()) {
            return 2;
        }
        return 1;
    }

    private final boolean $$robo$$android_net_MacAddress$isMulticastAddress() {
        return (this.mAddr & MULTICAST_MASK) != 0L;
    }

    private final boolean $$robo$$android_net_MacAddress$isLocallyAssigned() {
        return (this.mAddr & LOCALLY_ASSIGNED_MASK) != 0L;
    }

    private final byte[] $$robo$$android_net_MacAddress$toByteArray() {
        return MacAddress.byteAddrFromLongAddr(this.mAddr);
    }

    private final String $$robo$$android_net_MacAddress$toString() {
        return MacAddress.stringAddrFromLongAddr(this.mAddr);
    }

    private final String $$robo$$android_net_MacAddress$toOuiString() {
        return String.format("%02x:%02x:%02x", this.mAddr >> 40 & 0xFFL, this.mAddr >> 32 & 0xFFL, this.mAddr >> 24 & 0xFFL);
    }

    private final int $$robo$$android_net_MacAddress$hashCode() {
        return (int)(this.mAddr >> 32 ^ this.mAddr);
    }

    private final boolean $$robo$$android_net_MacAddress$equals(Object o) {
        return o instanceof MacAddress && ((MacAddress)o).mAddr == this.mAddr;
    }

    private final void $$robo$$android_net_MacAddress$writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mAddr);
    }

    private final int $$robo$$android_net_MacAddress$describeContents() {
        return 0;
    }

    private static final boolean $$robo$$android_net_MacAddress$isMacAddress(byte[] addr) {
        return addr != null && addr.length == 6;
    }

    private static final int $$robo$$android_net_MacAddress$macAddressType(byte[] addr) {
        if (!MacAddress.isMacAddress(addr)) {
            return 0;
        }
        return MacAddress.fromBytes(addr).getAddressType();
    }

    private static final byte[] $$robo$$android_net_MacAddress$byteAddrFromStringAddr(String addr) {
        Preconditions.checkNotNull(addr);
        String[] parts = addr.split(":");
        if (parts.length != 6) {
            throw new IllegalArgumentException(addr + " was not a valid MAC address");
        }
        byte[] bytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            int x = Integer.valueOf(parts[i], 16);
            if (x < 0 || 255 < x) {
                throw new IllegalArgumentException(addr + "was not a valid MAC address");
            }
            bytes[i] = (byte)x;
        }
        return bytes;
    }

    private static final String $$robo$$android_net_MacAddress$stringAddrFromByteAddr(byte[] addr) {
        if (!MacAddress.isMacAddress(addr)) {
            return null;
        }
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);
    }

    private static final byte[] $$robo$$android_net_MacAddress$byteAddrFromLongAddr(long addr) {
        byte[] bytes = new byte[6];
        int index = 6;
        while (index-- > 0) {
            bytes[index] = (byte)addr;
            addr >>= 8;
        }
        return bytes;
    }

    private static final long $$robo$$android_net_MacAddress$longAddrFromByteAddr(byte[] addr) {
        Preconditions.checkNotNull(addr);
        if (!MacAddress.isMacAddress(addr)) {
            throw new IllegalArgumentException(Arrays.toString(addr) + " was not a valid MAC address");
        }
        long longAddr = 0L;
        for (byte b : addr) {
            longAddr = (longAddr << 8) + (long)BitUtils.uint8(b);
        }
        return longAddr;
    }

    private static final long $$robo$$android_net_MacAddress$longAddrFromStringAddr(String addr) {
        Preconditions.checkNotNull(addr);
        String[] parts = addr.split(":");
        if (parts.length != 6) {
            throw new IllegalArgumentException(addr + " was not a valid MAC address");
        }
        long longAddr = 0L;
        for (int i = 0; i < parts.length; ++i) {
            int x = Integer.valueOf(parts[i], 16);
            if (x < 0 || 255 < x) {
                throw new IllegalArgumentException(addr + "was not a valid MAC address");
            }
            longAddr = (long)x + (longAddr << 8);
        }
        return longAddr;
    }

    private static final String $$robo$$android_net_MacAddress$stringAddrFromLongAddr(long addr) {
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", addr >> 40 & 0xFFL, addr >> 32 & 0xFFL, addr >> 24 & 0xFFL, addr >> 16 & 0xFFL, addr >> 8 & 0xFFL, addr & 0xFFL);
    }

    private static final MacAddress $$robo$$android_net_MacAddress$fromString(String addr) {
        return new MacAddress(MacAddress.longAddrFromStringAddr(addr));
    }

    private static final MacAddress $$robo$$android_net_MacAddress$fromBytes(byte[] addr) {
        return new MacAddress(MacAddress.longAddrFromByteAddr(addr));
    }

    private static final MacAddress $$robo$$android_net_MacAddress$createRandomUnicastAddressWithGoogleBase() {
        return MacAddress.createRandomUnicastAddress(BASE_GOOGLE_MAC, new SecureRandom());
    }

    private static final MacAddress $$robo$$android_net_MacAddress$createRandomUnicastAddress() {
        SecureRandom r = new SecureRandom();
        long addr = r.nextLong() & 0xFFFFFFFFFFFFL;
        addr |= LOCALLY_ASSIGNED_MASK;
        return new MacAddress(addr &= MULTICAST_MASK ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static final MacAddress $$robo$$android_net_MacAddress$createRandomUnicastAddress(MacAddress base, Random r) {
        long addr = base.mAddr & OUI_MASK | NIC_MASK & r.nextLong();
        addr |= LOCALLY_ASSIGNED_MASK;
        return new MacAddress(addr &= MULTICAST_MASK ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static final byte[] $$robo$$android_net_MacAddress$addr(int ... in) {
        if (in.length != 6) {
            throw new IllegalArgumentException(Arrays.toString(in) + " was not an array with length equal to " + 6);
        }
        byte[] out = new byte[6];
        for (int i = 0; i < 6; ++i) {
            out[i] = (byte)in[i];
        }
        return out;
    }

    private /* synthetic */ void $$robo$$android_net_MacAddress$__constructor__(long x0, 1 x1) {
    }

    static void __staticInitializer__() {
        ETHER_ADDR_BROADCAST = MacAddress.addr(255, 255, 255, 255, 255, 255);
        BROADCAST_ADDRESS = MacAddress.fromBytes(ETHER_ADDR_BROADCAST);
        ALL_ZEROS_ADDRESS = new MacAddress(0L);
        LOCALLY_ASSIGNED_MASK = MacAddress.fromString((String)"2:0:0:0:0:0").mAddr;
        MULTICAST_MASK = MacAddress.fromString((String)"1:0:0:0:0:0").mAddr;
        OUI_MASK = MacAddress.fromString((String)"ff:ff:ff:0:0:0").mAddr;
        NIC_MASK = MacAddress.fromString((String)"0:0:0:ff:ff:ff").mAddr;
        BASE_GOOGLE_MAC = MacAddress.fromString("da:a1:19:0:0:0");
        CREATOR = new Parcelable.Creator<MacAddress>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_MacAddress_1$__constructor__() {
            }

            private final MacAddress $$robo$$android_net_MacAddress_1$createFromParcel(Parcel in) {
                return new MacAddress(in.readLong());
            }

            private final MacAddress[] $$robo$$android_net_MacAddress_1$newArray(int size) {
                return new MacAddress[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_MacAddress_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_MacAddress_1$__constructor__(), 0, this);
            }

            @Override
            public MacAddress createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_MacAddress_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public MacAddress[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_MacAddress_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(long l) {
        this.$$robo$$android_net_MacAddress$__constructor__(l);
    }

    private MacAddress(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_MacAddress$__constructor__(long ), 0, this, l);
    }

    public int getAddressType() {
        return (int)InvokeDynamicSupport.bootstrap("getAddressType", $$robo$$android_net_MacAddress$getAddressType(), 0, this);
    }

    public boolean isMulticastAddress() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMulticastAddress", $$robo$$android_net_MacAddress$isMulticastAddress(), 0, this);
    }

    public boolean isLocallyAssigned() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLocallyAssigned", $$robo$$android_net_MacAddress$isLocallyAssigned(), 0, this);
    }

    public byte[] toByteArray() {
        return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_net_MacAddress$toByteArray(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_MacAddress$toString(), 0, this);
    }

    public String toOuiString() {
        return InvokeDynamicSupport.bootstrap("toOuiString", $$robo$$android_net_MacAddress$toOuiString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_MacAddress$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_MacAddress$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_MacAddress$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_MacAddress$describeContents(), 0, this);
    }

    public static boolean isMacAddress(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMacAddress", $$robo$$android_net_MacAddress$isMacAddress(byte[] ), 0, (byte[])byArray);
    }

    public static int macAddressType(byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("macAddressType", $$robo$$android_net_MacAddress$macAddressType(byte[] ), 0, (byte[])byArray);
    }

    public static byte[] byteAddrFromStringAddr(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("byteAddrFromStringAddr", $$robo$$android_net_MacAddress$byteAddrFromStringAddr(java.lang.String ), 0, (String)string2);
    }

    public static String stringAddrFromByteAddr(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("stringAddrFromByteAddr", $$robo$$android_net_MacAddress$stringAddrFromByteAddr(byte[] ), 0, (byte[])byArray);
    }

    private static byte[] byteAddrFromLongAddr(long l) {
        return InvokeDynamicSupport.bootstrapStatic("byteAddrFromLongAddr", $$robo$$android_net_MacAddress$byteAddrFromLongAddr(long ), 0, (long)l);
    }

    private static long longAddrFromByteAddr(byte[] byArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("longAddrFromByteAddr", $$robo$$android_net_MacAddress$longAddrFromByteAddr(byte[] ), 0, (byte[])byArray);
    }

    private static long longAddrFromStringAddr(String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("longAddrFromStringAddr", $$robo$$android_net_MacAddress$longAddrFromStringAddr(java.lang.String ), 0, (String)string2);
    }

    private static String stringAddrFromLongAddr(long l) {
        return InvokeDynamicSupport.bootstrapStatic("stringAddrFromLongAddr", $$robo$$android_net_MacAddress$stringAddrFromLongAddr(long ), 0, (long)l);
    }

    public static MacAddress fromString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fromString", $$robo$$android_net_MacAddress$fromString(java.lang.String ), 0, (String)string2);
    }

    public static MacAddress fromBytes(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("fromBytes", $$robo$$android_net_MacAddress$fromBytes(byte[] ), 0, (byte[])byArray);
    }

    public static MacAddress createRandomUnicastAddressWithGoogleBase() {
        return InvokeDynamicSupport.bootstrapStatic("createRandomUnicastAddressWithGoogleBase", $$robo$$android_net_MacAddress$createRandomUnicastAddressWithGoogleBase(), 0);
    }

    public static MacAddress createRandomUnicastAddress() {
        return InvokeDynamicSupport.bootstrapStatic("createRandomUnicastAddress", $$robo$$android_net_MacAddress$createRandomUnicastAddress(), 0);
    }

    public static MacAddress createRandomUnicastAddress(MacAddress macAddress, Random random) {
        return InvokeDynamicSupport.bootstrapStatic("createRandomUnicastAddress", $$robo$$android_net_MacAddress$createRandomUnicastAddress(android.net.MacAddress java.util.Random ), 0, (MacAddress)macAddress, (Random)random);
    }

    private static byte[] addr(int ... nArray) {
        return InvokeDynamicSupport.bootstrapStatic("addr", $$robo$$android_net_MacAddress$addr(int[] ), 0, (int[])nArray);
    }

    private /* synthetic */ void __constructor__(long l, 1 var3_2) {
        this.$$robo$$android_net_MacAddress$__constructor__(l, var3_2);
    }

    static {
        RobolectricInternals.classInitializing(MacAddress.class);
    }

    public /* synthetic */ MacAddress() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MacAddress)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MacAddressType {
    }
}

