/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Intent;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import libcore.net.UriCodec;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Uri
implements Parcelable,
Comparable<Uri> {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG;
    private static String NOT_CACHED;
    public static Uri EMPTY;
    private static int NOT_FOUND = -1;
    private static int NOT_CALCULATED = -2;
    private static String NOT_HIERARCHICAL = "This isn't a hierarchical URI.";
    private static String DEFAULT_ENCODING = "UTF-8";
    private static int NULL_TYPE_ID = 0;
    public static Parcelable.Creator<Uri> CREATOR;
    private static char[] HEX_DIGITS;

    private void $$robo$$android_net_Uri$__constructor__() {
    }

    public abstract boolean isHierarchical();

    private final boolean $$robo$$android_net_Uri$isOpaque() {
        return !this.isHierarchical();
    }

    public abstract boolean isRelative();

    private final boolean $$robo$$android_net_Uri$isAbsolute() {
        return !this.isRelative();
    }

    public abstract String getScheme();

    public abstract String getSchemeSpecificPart();

    public abstract String getEncodedSchemeSpecificPart();

    public abstract String getAuthority();

    public abstract String getEncodedAuthority();

    public abstract String getUserInfo();

    public abstract String getEncodedUserInfo();

    public abstract String getHost();

    public abstract int getPort();

    public abstract String getPath();

    public abstract String getEncodedPath();

    public abstract String getQuery();

    public abstract String getEncodedQuery();

    public abstract String getFragment();

    public abstract String getEncodedFragment();

    public abstract List<String> getPathSegments();

    public abstract String getLastPathSegment();

    private final boolean $$robo$$android_net_Uri$equals(Object o) {
        if (!(o instanceof Uri)) {
            return false;
        }
        Uri other = (Uri)o;
        return this.toString().equals(other.toString());
    }

    private final int $$robo$$android_net_Uri$hashCode() {
        return this.toString().hashCode();
    }

    private final int $$robo$$android_net_Uri$compareTo(Uri other) {
        return this.toString().compareTo(other.toString());
    }

    public abstract String toString();

    private final String $$robo$$android_net_Uri$toSafeString() {
        String scheme = this.getScheme();
        String ssp = this.getSchemeSpecificPart();
        if (scheme != null) {
            if (scheme.equalsIgnoreCase("tel") || scheme.equalsIgnoreCase("sip") || scheme.equalsIgnoreCase("sms") || scheme.equalsIgnoreCase("smsto") || scheme.equalsIgnoreCase("mailto") || scheme.equalsIgnoreCase("nfc")) {
                StringBuilder builder = new StringBuilder(64);
                builder.append(scheme);
                builder.append(':');
                if (ssp != null) {
                    for (int i = 0; i < ssp.length(); ++i) {
                        char c = ssp.charAt(i);
                        if (c == '-' || c == '@' || c == '.') {
                            builder.append(c);
                            continue;
                        }
                        builder.append('x');
                    }
                }
                return builder.toString();
            }
            if (scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("ftp")) {
                ssp = "//" + (this.getHost() != null ? this.getHost() : "") + (this.getPort() != -1 ? ":" + this.getPort() : "") + "/...";
            }
        }
        StringBuilder builder = new StringBuilder(64);
        if (scheme != null) {
            builder.append(scheme);
            builder.append(':');
        }
        if (ssp != null) {
            builder.append(ssp);
        }
        return builder.toString();
    }

    public abstract Builder buildUpon();

    private static final Uri $$robo$$android_net_Uri$parse(String uriString) {
        return new StringUri(uriString);
    }

    private static final Uri $$robo$$android_net_Uri$fromFile(File file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        PathPart path = PathPart.fromDecoded(file.getAbsolutePath());
        return new HierarchicalUri("file", Part.EMPTY, path, Part.NULL, Part.NULL);
    }

    private static final Uri $$robo$$android_net_Uri$fromParts(String scheme, String ssp, String fragment) {
        if (scheme == null) {
            throw new NullPointerException("scheme");
        }
        if (ssp == null) {
            throw new NullPointerException("ssp");
        }
        return new OpaqueUri(scheme, Part.fromDecoded(ssp), Part.fromDecoded(fragment));
    }

    private final Set<String> $$robo$$android_net_Uri$getQueryParameterNames() {
        int end;
        if (this.isOpaque()) {
            throw new UnsupportedOperationException("This isn't a hierarchical URI.");
        }
        String query = this.getEncodedQuery();
        if (query == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        int start = 0;
        do {
            int next;
            end = (next = query.indexOf(38, start)) == -1 ? query.length() : next;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            String name = query.substring(start, separator);
            names.add(Uri.decode(name));
        } while ((start = end + 1) < query.length());
        return Collections.unmodifiableSet(names);
    }

    private final List<String> $$robo$$android_net_Uri$getQueryParameters(String key) {
        String encodedKey;
        if (this.isOpaque()) {
            throw new UnsupportedOperationException("This isn't a hierarchical URI.");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        String query = this.getEncodedQuery();
        if (query == null) {
            return Collections.emptyList();
        }
        try {
            encodedKey = URLEncoder.encode(key, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        ArrayList<String> values = new ArrayList<String>();
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = query.indexOf(38, start)) != -1 ? nextAmpersand : query.length();
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (separator - start == encodedKey.length() && query.regionMatches(start, encodedKey, 0, encodedKey.length())) {
                if (separator == end) {
                    values.add("");
                } else {
                    values.add(Uri.decode(query.substring(separator + 1, end)));
                }
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return Collections.unmodifiableList(values);
    }

    private final String $$robo$$android_net_Uri$getQueryParameter(String key) {
        if (this.isOpaque()) {
            throw new UnsupportedOperationException("This isn't a hierarchical URI.");
        }
        if (key == null) {
            throw new NullPointerException("key");
        }
        String query = this.getEncodedQuery();
        if (query == null) {
            return null;
        }
        String encodedKey = Uri.encode(key, null);
        int length = query.length();
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = query.indexOf(38, start)) != -1 ? nextAmpersand : length;
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) {
                separator = end;
            }
            if (separator - start == encodedKey.length() && query.regionMatches(start, encodedKey, 0, encodedKey.length())) {
                if (separator == end) {
                    return "";
                }
                String encodedValue = query.substring(separator + 1, end);
                return UriCodec.decode(encodedValue, true, StandardCharsets.UTF_8, false);
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
        return null;
    }

    private final boolean $$robo$$android_net_Uri$getBooleanQueryParameter(String key, boolean defaultValue) {
        String flag = this.getQueryParameter(key);
        if (flag == null) {
            return defaultValue;
        }
        return !"false".equals(flag = flag.toLowerCase(Locale.ROOT)) && !"0".equals(flag);
    }

    private final Uri $$robo$$android_net_Uri$normalizeScheme() {
        String scheme = this.getScheme();
        if (scheme == null) {
            return this;
        }
        String lowerScheme = scheme.toLowerCase(Locale.ROOT);
        if (scheme.equals(lowerScheme)) {
            return this;
        }
        return this.buildUpon().scheme(lowerScheme).build();
    }

    private static final void $$robo$$android_net_Uri$writeToParcel(Parcel out, Uri uri) {
        if (uri == null) {
            out.writeInt(0);
        } else {
            uri.writeToParcel(out, 0);
        }
    }

    private static final String $$robo$$android_net_Uri$encode(String s) {
        return Uri.encode(s, null);
    }

    private static final String $$robo$$android_net_Uri$encode(String s, String allow) {
        if (s == null) {
            return null;
        }
        StringBuilder encoded = null;
        int oldLength = s.length();
        int current = 0;
        while (current < oldLength) {
            int nextAllowed;
            int nextToEncode;
            for (nextToEncode = current; nextToEncode < oldLength && Uri.isAllowed(s.charAt(nextToEncode), allow); ++nextToEncode) {
            }
            if (nextToEncode == oldLength) {
                if (current == 0) {
                    return s;
                }
                encoded.append(s, current, oldLength);
                return encoded.toString();
            }
            if (encoded == null) {
                encoded = new StringBuilder();
            }
            if (nextToEncode > current) {
                encoded.append(s, current, nextToEncode);
            }
            current = nextToEncode;
            for (nextAllowed = current + 1; nextAllowed < oldLength && !Uri.isAllowed(s.charAt(nextAllowed), allow); ++nextAllowed) {
            }
            String toEncode = s.substring(current, nextAllowed);
            try {
                byte[] bytes = toEncode.getBytes("UTF-8");
                int bytesLength = bytes.length;
                for (int i = 0; i < bytesLength; ++i) {
                    encoded.append('%');
                    encoded.append(HEX_DIGITS[(bytes[i] & 0xF0) >> 4]);
                    encoded.append(HEX_DIGITS[bytes[i] & 0xF]);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
            current = nextAllowed;
        }
        return encoded == null ? s : encoded.toString();
    }

    private static final boolean $$robo$$android_net_Uri$isAllowed(char c, String allow) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || "_-!.~'()*".indexOf(c) != -1 || allow != null && allow.indexOf(c) != -1;
    }

    private static final String $$robo$$android_net_Uri$decode(String s) {
        if (s == null) {
            return null;
        }
        return UriCodec.decode(s, false, StandardCharsets.UTF_8, false);
    }

    private static final Uri $$robo$$android_net_Uri$withAppendedPath(Uri baseUri, String pathSegment) {
        Builder builder = baseUri.buildUpon();
        builder = builder.appendEncodedPath(pathSegment);
        return builder.build();
    }

    private final Uri $$robo$$android_net_Uri$getCanonicalUri() {
        if ("file".equals(this.getScheme())) {
            String legacyPath;
            String canonicalPath;
            try {
                canonicalPath = new File(this.getPath()).getCanonicalPath();
            }
            catch (IOException e) {
                return this;
            }
            if (Environment.isExternalStorageEmulated() && canonicalPath.startsWith(legacyPath = Environment.getLegacyExternalStorageDirectory().toString())) {
                return Uri.fromFile(new File(Environment.getExternalStorageDirectory().toString(), canonicalPath.substring(legacyPath.length() + 1)));
            }
            return Uri.fromFile(new File(canonicalPath));
        }
        return this;
    }

    private final void $$robo$$android_net_Uri$checkFileUriExposed(String location) {
        if ("file".equals(this.getScheme()) && this.getPath() != null && !this.getPath().startsWith("/system/")) {
            StrictMode.onFileUriExposed(this, location);
        }
    }

    private final void $$robo$$android_net_Uri$checkContentUriWithoutPermission(String location, int flags) {
        if ("content".equals(this.getScheme()) && !Intent.isAccessUriMode(flags)) {
            StrictMode.onContentUriWithoutPermission(this, location);
        }
    }

    private final boolean $$robo$$android_net_Uri$isPathPrefixMatch(Uri prefix) {
        if (!Objects.equals(this.getScheme(), prefix.getScheme())) {
            return false;
        }
        if (!Objects.equals(this.getAuthority(), prefix.getAuthority())) {
            return false;
        }
        List<String> seg = this.getPathSegments();
        List<String> prefixSeg = prefix.getPathSegments();
        int prefixSize = prefixSeg.size();
        if (seg.size() < prefixSize) {
            return false;
        }
        for (int i = 0; i < prefixSize; ++i) {
            if (Objects.equals(seg.get(i), prefixSeg.get(i))) continue;
            return false;
        }
        return true;
    }

    private /* synthetic */ void $$robo$$android_net_Uri$__constructor__(1 x0) {
    }

    static void __staticInitializer__() {
        LOG = Uri.class.getSimpleName();
        NOT_CACHED = new String("NOT CACHED");
        EMPTY = new HierarchicalUri(null, Part.NULL, PathPart.EMPTY, Part.NULL, Part.NULL);
        CREATOR = new Parcelable.Creator<Uri>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_Uri_1$__constructor__() {
            }

            private final Uri $$robo$$android_net_Uri_1$createFromParcel(Parcel in) {
                int type = in.readInt();
                switch (type) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return StringUri.readFrom(in);
                    }
                    case 2: {
                        return OpaqueUri.readFrom(in);
                    }
                    case 3: {
                        return HierarchicalUri.readFrom(in);
                    }
                }
                throw new IllegalArgumentException("Unknown URI type: " + type);
            }

            private final Uri[] $$robo$$android_net_Uri_1$newArray(int size) {
                return new Uri[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_Uri_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_1$__constructor__(), 0, this);
            }

            @Override
            public Uri createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_Uri_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public Uri[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_Uri_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    }

    private void __constructor__() {
        this.$$robo$$android_net_Uri$__constructor__();
    }

    private Uri() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri$__constructor__(), 0, this);
    }

    public boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_net_Uri$isOpaque(), 0, this);
    }

    public boolean isAbsolute() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAbsolute", $$robo$$android_net_Uri$isAbsolute(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_Uri$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_Uri$hashCode(), 0, this);
    }

    @Override
    public int compareTo(Uri uri) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_net_Uri$compareTo(android.net.Uri ), 0, this, uri);
    }

    public String toSafeString() {
        return InvokeDynamicSupport.bootstrap("toSafeString", $$robo$$android_net_Uri$toSafeString(), 0, this);
    }

    public static Uri parse(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_net_Uri$parse(java.lang.String ), 0, (String)string2);
    }

    public static Uri fromFile(File file) {
        return InvokeDynamicSupport.bootstrapStatic("fromFile", $$robo$$android_net_Uri$fromFile(java.io.File ), 0, (File)file);
    }

    public static Uri fromParts(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("fromParts", $$robo$$android_net_Uri$fromParts(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public Set<String> getQueryParameterNames() {
        return InvokeDynamicSupport.bootstrap("getQueryParameterNames", $$robo$$android_net_Uri$getQueryParameterNames(), 0, this);
    }

    public List<String> getQueryParameters(String string2) {
        return InvokeDynamicSupport.bootstrap("getQueryParameters", $$robo$$android_net_Uri$getQueryParameters(java.lang.String ), 0, this, string2);
    }

    public String getQueryParameter(String string2) {
        return InvokeDynamicSupport.bootstrap("getQueryParameter", $$robo$$android_net_Uri$getQueryParameter(java.lang.String ), 0, this, string2);
    }

    public boolean getBooleanQueryParameter(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBooleanQueryParameter", $$robo$$android_net_Uri$getBooleanQueryParameter(java.lang.String boolean ), 0, this, string2, bl);
    }

    public Uri normalizeScheme() {
        return InvokeDynamicSupport.bootstrap("normalizeScheme", $$robo$$android_net_Uri$normalizeScheme(), 0, this);
    }

    public static void writeToParcel(Parcel parcel, Uri uri) {
        InvokeDynamicSupport.bootstrapStatic("writeToParcel", $$robo$$android_net_Uri$writeToParcel(android.os.Parcel android.net.Uri ), 0, (Parcel)parcel, (Uri)uri);
    }

    public static String encode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$android_net_Uri$encode(java.lang.String ), 0, (String)string2);
    }

    public static String encode(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("encode", $$robo$$android_net_Uri$encode(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static boolean isAllowed(char c, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAllowed", $$robo$$android_net_Uri$isAllowed(char java.lang.String ), 0, (char)c, (String)string2);
    }

    public static String decode(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("decode", $$robo$$android_net_Uri$decode(java.lang.String ), 0, (String)string2);
    }

    public static Uri withAppendedPath(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("withAppendedPath", $$robo$$android_net_Uri$withAppendedPath(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public Uri getCanonicalUri() {
        return InvokeDynamicSupport.bootstrap("getCanonicalUri", $$robo$$android_net_Uri$getCanonicalUri(), 0, this);
    }

    public void checkFileUriExposed(String string2) {
        InvokeDynamicSupport.bootstrap("checkFileUriExposed", $$robo$$android_net_Uri$checkFileUriExposed(java.lang.String ), 0, this, string2);
    }

    public void checkContentUriWithoutPermission(String string2, int n) {
        InvokeDynamicSupport.bootstrap("checkContentUriWithoutPermission", $$robo$$android_net_Uri$checkContentUriWithoutPermission(java.lang.String int ), 0, this, string2, n);
    }

    public boolean isPathPrefixMatch(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPathPrefixMatch", $$robo$$android_net_Uri$isPathPrefixMatch(android.net.Uri ), 0, this, uri);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_net_Uri$__constructor__(var1_1);
    }

    static {
        RobolectricInternals.classInitializing(Uri.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Uri)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class PathPart
    extends AbstractPart
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static PathPart NULL;
        static PathPart EMPTY;
        private PathSegments pathSegments;

        private void $$robo$$android_net_Uri_PathPart$__constructor__(String encoded, String decoded) {
        }

        private final String $$robo$$android_net_Uri_PathPart$getEncoded() {
            boolean hasEncoded = this.encoded != NOT_CACHED;
            return hasEncoded ? this.encoded : (this.encoded = Uri.encode(this.decoded, "/"));
        }

        private final PathSegments $$robo$$android_net_Uri_PathPart$getPathSegments() {
            int current;
            if (this.pathSegments != null) {
                return this.pathSegments;
            }
            String path = this.getEncoded();
            if (path == null) {
                this.pathSegments = PathSegments.EMPTY;
                return this.pathSegments;
            }
            PathSegmentsBuilder segmentBuilder = new PathSegmentsBuilder();
            int previous = 0;
            while ((current = path.indexOf(47, previous)) > -1) {
                if (previous < current) {
                    String decodedSegment = Uri.decode(path.substring(previous, current));
                    segmentBuilder.add(decodedSegment);
                }
                previous = current + 1;
            }
            if (previous < path.length()) {
                segmentBuilder.add(Uri.decode(path.substring(previous)));
            }
            this.pathSegments = segmentBuilder.build();
            return this.pathSegments;
        }

        private static final PathPart $$robo$$android_net_Uri_PathPart$appendEncodedSegment(PathPart oldPart, String newSegment) {
            int oldPathLength;
            if (oldPart == null) {
                return PathPart.fromEncoded("/" + newSegment);
            }
            String oldPath = oldPart.getEncoded();
            if (oldPath == null) {
                oldPath = "";
            }
            String newPath = (oldPathLength = oldPath.length()) == 0 ? "/" + newSegment : (oldPath.charAt(oldPathLength - 1) == '/' ? oldPath + newSegment : oldPath + "/" + newSegment);
            return PathPart.fromEncoded(newPath);
        }

        private static final PathPart $$robo$$android_net_Uri_PathPart$appendDecodedSegment(PathPart oldPart, String decoded) {
            String encoded = Uri.encode(decoded);
            return PathPart.appendEncodedSegment(oldPart, encoded);
        }

        private static final PathPart $$robo$$android_net_Uri_PathPart$readFrom(Parcel parcel) {
            int representation = parcel.readInt();
            switch (representation) {
                case 0: {
                    return PathPart.from(parcel.readString(), parcel.readString());
                }
                case 1: {
                    return PathPart.fromEncoded(parcel.readString());
                }
                case 2: {
                    return PathPart.fromDecoded(parcel.readString());
                }
            }
            throw new IllegalArgumentException("Bad representation: " + representation);
        }

        private static final PathPart $$robo$$android_net_Uri_PathPart$fromEncoded(String encoded) {
            return PathPart.from(encoded, NOT_CACHED);
        }

        private static final PathPart $$robo$$android_net_Uri_PathPart$fromDecoded(String decoded) {
            return PathPart.from(NOT_CACHED, decoded);
        }

        private static final PathPart $$robo$$android_net_Uri_PathPart$from(String encoded, String decoded) {
            if (encoded == null) {
                return NULL;
            }
            if (encoded.length() == 0) {
                return EMPTY;
            }
            return new PathPart(encoded, decoded);
        }

        private static final PathPart $$robo$$android_net_Uri_PathPart$makeAbsolute(PathPart oldPart) {
            String oldPath;
            boolean encodedCached = oldPart.encoded != NOT_CACHED;
            String string2 = oldPath = encodedCached ? oldPart.encoded : oldPart.decoded;
            if (oldPath == null || oldPath.length() == 0 || oldPath.startsWith("/")) {
                return oldPart;
            }
            String newEncoded = encodedCached ? "/" + oldPart.encoded : NOT_CACHED;
            boolean decodedCached = oldPart.decoded != NOT_CACHED;
            String newDecoded = decodedCached ? "/" + oldPart.decoded : NOT_CACHED;
            return new PathPart(newEncoded, newDecoded);
        }

        static void __staticInitializer__() {
            NULL = new PathPart(null, null);
            EMPTY = new PathPart("", "");
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_net_Uri_PathPart$__constructor__(string2, string3);
        }

        private PathPart(String string2, String string3) {
            super(string2, string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_PathPart$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        @Override
        String getEncoded() {
            return InvokeDynamicSupport.bootstrap("getEncoded", $$robo$$android_net_Uri_PathPart$getEncoded(), 0, this);
        }

        PathSegments getPathSegments() {
            return InvokeDynamicSupport.bootstrap("getPathSegments", $$robo$$android_net_Uri_PathPart$getPathSegments(), 0, this);
        }

        static PathPart appendEncodedSegment(PathPart pathPart, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("appendEncodedSegment", $$robo$$android_net_Uri_PathPart$appendEncodedSegment(android.net.Uri$PathPart java.lang.String ), 0, (PathPart)pathPart, (String)string2);
        }

        static PathPart appendDecodedSegment(PathPart pathPart, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("appendDecodedSegment", $$robo$$android_net_Uri_PathPart$appendDecodedSegment(android.net.Uri$PathPart java.lang.String ), 0, (PathPart)pathPart, (String)string2);
        }

        static PathPart readFrom(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("readFrom", $$robo$$android_net_Uri_PathPart$readFrom(android.os.Parcel ), 0, (Parcel)parcel);
        }

        static PathPart fromEncoded(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("fromEncoded", $$robo$$android_net_Uri_PathPart$fromEncoded(java.lang.String ), 0, (String)string2);
        }

        static PathPart fromDecoded(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("fromDecoded", $$robo$$android_net_Uri_PathPart$fromDecoded(java.lang.String ), 0, (String)string2);
        }

        static PathPart from(String string2, String string3) {
            return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_net_Uri_PathPart$from(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
        }

        static PathPart makeAbsolute(PathPart pathPart) {
            return InvokeDynamicSupport.bootstrapStatic("makeAbsolute", $$robo$$android_net_Uri_PathPart$makeAbsolute(android.net.Uri$PathPart ), 0, (PathPart)pathPart);
        }

        static {
            RobolectricInternals.classInitializing(PathPart.class);
        }

        public /* synthetic */ PathPart() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PathPart)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Part
    extends AbstractPart
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static Part NULL;
        static Part EMPTY;

        private void $$robo$$android_net_Uri_Part$__constructor__(String encoded, String decoded) {
        }

        private final boolean $$robo$$android_net_Uri_Part$isEmpty() {
            return false;
        }

        private final String $$robo$$android_net_Uri_Part$getEncoded() {
            boolean hasEncoded = this.encoded != NOT_CACHED;
            return hasEncoded ? this.encoded : (this.encoded = Uri.encode(this.decoded));
        }

        private static final Part $$robo$$android_net_Uri_Part$readFrom(Parcel parcel) {
            int representation = parcel.readInt();
            switch (representation) {
                case 0: {
                    return Part.from(parcel.readString(), parcel.readString());
                }
                case 1: {
                    return Part.fromEncoded(parcel.readString());
                }
                case 2: {
                    return Part.fromDecoded(parcel.readString());
                }
            }
            throw new IllegalArgumentException("Unknown representation: " + representation);
        }

        private static final Part $$robo$$android_net_Uri_Part$nonNull(Part part) {
            return part == null ? NULL : part;
        }

        private static final Part $$robo$$android_net_Uri_Part$fromEncoded(String encoded) {
            return Part.from(encoded, NOT_CACHED);
        }

        private static final Part $$robo$$android_net_Uri_Part$fromDecoded(String decoded) {
            return Part.from(NOT_CACHED, decoded);
        }

        private static final Part $$robo$$android_net_Uri_Part$from(String encoded, String decoded) {
            if (encoded == null) {
                return NULL;
            }
            if (encoded.length() == 0) {
                return EMPTY;
            }
            if (decoded == null) {
                return NULL;
            }
            if (decoded.length() == 0) {
                return EMPTY;
            }
            return new Part(encoded, decoded);
        }

        private /* synthetic */ void $$robo$$android_net_Uri_Part$__constructor__(String x0, String x1, 1 x2) {
        }

        static void __staticInitializer__() {
            NULL = new EmptyPart(null);
            EMPTY = new EmptyPart("");
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_net_Uri_Part$__constructor__(string2, string3);
        }

        private Part(String string2, String string3) {
            super(string2, string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_Part$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_net_Uri_Part$isEmpty(), 0, this);
        }

        @Override
        String getEncoded() {
            return InvokeDynamicSupport.bootstrap("getEncoded", $$robo$$android_net_Uri_Part$getEncoded(), 0, this);
        }

        static Part readFrom(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("readFrom", $$robo$$android_net_Uri_Part$readFrom(android.os.Parcel ), 0, (Parcel)parcel);
        }

        static Part nonNull(Part part) {
            return InvokeDynamicSupport.bootstrapStatic("nonNull", $$robo$$android_net_Uri_Part$nonNull(android.net.Uri$Part ), 0, (Part)part);
        }

        static Part fromEncoded(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("fromEncoded", $$robo$$android_net_Uri_Part$fromEncoded(java.lang.String ), 0, (String)string2);
        }

        static Part fromDecoded(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("fromDecoded", $$robo$$android_net_Uri_Part$fromDecoded(java.lang.String ), 0, (String)string2);
        }

        static Part from(String string2, String string3) {
            return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_net_Uri_Part$from(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
        }

        private /* synthetic */ void __constructor__(String string2, String string3, 1 var3_3) {
            this.$$robo$$android_net_Uri_Part$__constructor__(string2, string3, var3_3);
        }

        static {
            RobolectricInternals.classInitializing(Part.class);
        }

        public /* synthetic */ Part() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Part)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class EmptyPart
        extends Part
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_Uri_Part_EmptyPart$__constructor__(String value) {
            }

            private final boolean $$robo$$android_net_Uri_Part_EmptyPart$isEmpty() {
                return true;
            }

            private void __constructor__(String string2) {
                this.$$robo$$android_net_Uri_Part_EmptyPart$__constructor__(string2);
            }

            public EmptyPart(String string2) {
                super(string2, string2);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_Part_EmptyPart$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            boolean isEmpty() {
                return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_net_Uri_Part_EmptyPart$isEmpty(), 0, this);
            }

            public /* synthetic */ EmptyPart() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EmptyPart)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class AbstractPart
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        volatile String encoded;
        volatile String decoded;

        private void $$robo$$android_net_Uri_AbstractPart$__constructor__(String encoded, String decoded) {
            this.encoded = encoded;
            this.decoded = decoded;
        }

        abstract String getEncoded();

        private final String $$robo$$android_net_Uri_AbstractPart$getDecoded() {
            boolean hasDecoded = this.decoded != NOT_CACHED;
            return hasDecoded ? this.decoded : (this.decoded = Uri.decode(this.encoded));
        }

        private final void $$robo$$android_net_Uri_AbstractPart$writeTo(Parcel parcel) {
            boolean hasDecoded;
            boolean hasEncoded = this.encoded != NOT_CACHED;
            boolean bl = hasDecoded = this.decoded != NOT_CACHED;
            if (hasEncoded && hasDecoded) {
                parcel.writeInt(0);
                parcel.writeString(this.encoded);
                parcel.writeString(this.decoded);
            } else if (hasEncoded) {
                parcel.writeInt(1);
                parcel.writeString(this.encoded);
            } else if (hasDecoded) {
                parcel.writeInt(2);
                parcel.writeString(this.decoded);
            } else {
                throw new IllegalArgumentException("Neither encoded nor decoded");
            }
        }

        private void __constructor__(String string2, String string3) {
            this.$$robo$$android_net_Uri_AbstractPart$__constructor__(string2, string3);
        }

        AbstractPart(String string2, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_AbstractPart$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        String getDecoded() {
            return InvokeDynamicSupport.bootstrap("getDecoded", $$robo$$android_net_Uri_AbstractPart$getDecoded(), 0, this);
        }

        void writeTo(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeTo", $$robo$$android_net_Uri_AbstractPart$writeTo(android.os.Parcel ), 0, this, parcel);
        }

        public /* synthetic */ AbstractPart() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractPart)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Representation
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            static int BOTH = 0;
            static int ENCODED = 1;
            static int DECODED = 2;

            private void $$robo$$android_net_Uri_AbstractPart_Representation$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_net_Uri_AbstractPart_Representation$__constructor__();
            }

            Representation() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_AbstractPart_Representation$__constructor__(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Representation)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String scheme;
        private Part opaquePart;
        private Part authority;
        private PathPart path;
        private Part query;
        private Part fragment;

        private void $$robo$$android_net_Uri_Builder$__constructor__() {
        }

        private final Builder $$robo$$android_net_Uri_Builder$scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        private final Builder $$robo$$android_net_Uri_Builder$opaquePart(Part opaquePart) {
            this.opaquePart = opaquePart;
            return this;
        }

        private final Builder $$robo$$android_net_Uri_Builder$opaquePart(String opaquePart) {
            return this.opaquePart(Part.fromDecoded(opaquePart));
        }

        private final Builder $$robo$$android_net_Uri_Builder$encodedOpaquePart(String opaquePart) {
            return this.opaquePart(Part.fromEncoded(opaquePart));
        }

        private final Builder $$robo$$android_net_Uri_Builder$authority(Part authority) {
            this.opaquePart = null;
            this.authority = authority;
            return this;
        }

        private final Builder $$robo$$android_net_Uri_Builder$authority(String authority) {
            return this.authority(Part.fromDecoded(authority));
        }

        private final Builder $$robo$$android_net_Uri_Builder$encodedAuthority(String authority) {
            return this.authority(Part.fromEncoded(authority));
        }

        private final Builder $$robo$$android_net_Uri_Builder$path(PathPart path) {
            this.opaquePart = null;
            this.path = path;
            return this;
        }

        private final Builder $$robo$$android_net_Uri_Builder$path(String path) {
            return this.path(PathPart.fromDecoded(path));
        }

        private final Builder $$robo$$android_net_Uri_Builder$encodedPath(String path) {
            return this.path(PathPart.fromEncoded(path));
        }

        private final Builder $$robo$$android_net_Uri_Builder$appendPath(String newSegment) {
            return this.path(PathPart.appendDecodedSegment(this.path, newSegment));
        }

        private final Builder $$robo$$android_net_Uri_Builder$appendEncodedPath(String newSegment) {
            return this.path(PathPart.appendEncodedSegment(this.path, newSegment));
        }

        private final Builder $$robo$$android_net_Uri_Builder$query(Part query) {
            this.opaquePart = null;
            this.query = query;
            return this;
        }

        private final Builder $$robo$$android_net_Uri_Builder$query(String query) {
            return this.query(Part.fromDecoded(query));
        }

        private final Builder $$robo$$android_net_Uri_Builder$encodedQuery(String query) {
            return this.query(Part.fromEncoded(query));
        }

        private final Builder $$robo$$android_net_Uri_Builder$fragment(Part fragment) {
            this.fragment = fragment;
            return this;
        }

        private final Builder $$robo$$android_net_Uri_Builder$fragment(String fragment) {
            return this.fragment(Part.fromDecoded(fragment));
        }

        private final Builder $$robo$$android_net_Uri_Builder$encodedFragment(String fragment) {
            return this.fragment(Part.fromEncoded(fragment));
        }

        private final Builder $$robo$$android_net_Uri_Builder$appendQueryParameter(String key, String value) {
            this.opaquePart = null;
            String encodedParameter = Uri.encode(key, null) + "=" + Uri.encode(value, null);
            if (this.query == null) {
                this.query = Part.fromEncoded(encodedParameter);
                return this;
            }
            String oldQuery = this.query.getEncoded();
            this.query = oldQuery == null || oldQuery.length() == 0 ? Part.fromEncoded(encodedParameter) : Part.fromEncoded(oldQuery + "&" + encodedParameter);
            return this;
        }

        private final Builder $$robo$$android_net_Uri_Builder$clearQuery() {
            return this.query((Part)null);
        }

        private final Uri $$robo$$android_net_Uri_Builder$build() {
            if (this.opaquePart != null) {
                if (this.scheme == null) {
                    throw new UnsupportedOperationException("An opaque URI must have a scheme.");
                }
                return new OpaqueUri(this.scheme, this.opaquePart, this.fragment);
            }
            PathPart path = this.path;
            if (path == null || path == PathPart.NULL) {
                path = PathPart.EMPTY;
            } else if (this.hasSchemeOrAuthority()) {
                path = PathPart.makeAbsolute(path);
            }
            return new HierarchicalUri(this.scheme, this.authority, path, this.query, this.fragment);
        }

        private final boolean $$robo$$android_net_Uri_Builder$hasSchemeOrAuthority() {
            return this.scheme != null || this.authority != null && this.authority != Part.NULL;
        }

        private final String $$robo$$android_net_Uri_Builder$toString() {
            return this.build().toString();
        }

        private void __constructor__() {
            this.$$robo$$android_net_Uri_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_Builder$__constructor__(), 0, this);
        }

        public Builder scheme(String string2) {
            return InvokeDynamicSupport.bootstrap("scheme", $$robo$$android_net_Uri_Builder$scheme(java.lang.String ), 0, this, string2);
        }

        Builder opaquePart(Part part) {
            return InvokeDynamicSupport.bootstrap("opaquePart", $$robo$$android_net_Uri_Builder$opaquePart(android.net.Uri$Part ), 0, this, part);
        }

        public Builder opaquePart(String string2) {
            return InvokeDynamicSupport.bootstrap("opaquePart", $$robo$$android_net_Uri_Builder$opaquePart(java.lang.String ), 0, this, string2);
        }

        public Builder encodedOpaquePart(String string2) {
            return InvokeDynamicSupport.bootstrap("encodedOpaquePart", $$robo$$android_net_Uri_Builder$encodedOpaquePart(java.lang.String ), 0, this, string2);
        }

        Builder authority(Part part) {
            return InvokeDynamicSupport.bootstrap("authority", $$robo$$android_net_Uri_Builder$authority(android.net.Uri$Part ), 0, this, part);
        }

        public Builder authority(String string2) {
            return InvokeDynamicSupport.bootstrap("authority", $$robo$$android_net_Uri_Builder$authority(java.lang.String ), 0, this, string2);
        }

        public Builder encodedAuthority(String string2) {
            return InvokeDynamicSupport.bootstrap("encodedAuthority", $$robo$$android_net_Uri_Builder$encodedAuthority(java.lang.String ), 0, this, string2);
        }

        Builder path(PathPart pathPart) {
            return InvokeDynamicSupport.bootstrap("path", $$robo$$android_net_Uri_Builder$path(android.net.Uri$PathPart ), 0, this, pathPart);
        }

        public Builder path(String string2) {
            return InvokeDynamicSupport.bootstrap("path", $$robo$$android_net_Uri_Builder$path(java.lang.String ), 0, this, string2);
        }

        public Builder encodedPath(String string2) {
            return InvokeDynamicSupport.bootstrap("encodedPath", $$robo$$android_net_Uri_Builder$encodedPath(java.lang.String ), 0, this, string2);
        }

        public Builder appendPath(String string2) {
            return InvokeDynamicSupport.bootstrap("appendPath", $$robo$$android_net_Uri_Builder$appendPath(java.lang.String ), 0, this, string2);
        }

        public Builder appendEncodedPath(String string2) {
            return InvokeDynamicSupport.bootstrap("appendEncodedPath", $$robo$$android_net_Uri_Builder$appendEncodedPath(java.lang.String ), 0, this, string2);
        }

        Builder query(Part part) {
            return InvokeDynamicSupport.bootstrap("query", $$robo$$android_net_Uri_Builder$query(android.net.Uri$Part ), 0, this, part);
        }

        public Builder query(String string2) {
            return InvokeDynamicSupport.bootstrap("query", $$robo$$android_net_Uri_Builder$query(java.lang.String ), 0, this, string2);
        }

        public Builder encodedQuery(String string2) {
            return InvokeDynamicSupport.bootstrap("encodedQuery", $$robo$$android_net_Uri_Builder$encodedQuery(java.lang.String ), 0, this, string2);
        }

        Builder fragment(Part part) {
            return InvokeDynamicSupport.bootstrap("fragment", $$robo$$android_net_Uri_Builder$fragment(android.net.Uri$Part ), 0, this, part);
        }

        public Builder fragment(String string2) {
            return InvokeDynamicSupport.bootstrap("fragment", $$robo$$android_net_Uri_Builder$fragment(java.lang.String ), 0, this, string2);
        }

        public Builder encodedFragment(String string2) {
            return InvokeDynamicSupport.bootstrap("encodedFragment", $$robo$$android_net_Uri_Builder$encodedFragment(java.lang.String ), 0, this, string2);
        }

        public Builder appendQueryParameter(String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("appendQueryParameter", $$robo$$android_net_Uri_Builder$appendQueryParameter(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public Builder clearQuery() {
            return InvokeDynamicSupport.bootstrap("clearQuery", $$robo$$android_net_Uri_Builder$clearQuery(), 0, this);
        }

        public Uri build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_net_Uri_Builder$build(), 0, this);
        }

        private boolean hasSchemeOrAuthority() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSchemeOrAuthority", $$robo$$android_net_Uri_Builder$hasSchemeOrAuthority(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_Uri_Builder$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class HierarchicalUri
    extends AbstractHierarchicalUri
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int TYPE_ID = 3;
        private String scheme;
        private Part authority;
        private PathPart path;
        private Part query;
        private Part fragment;
        private Part ssp;
        private volatile String uriString;

        private void $$robo$$android_net_Uri_HierarchicalUri$__constructor__(String scheme, Part authority, PathPart path, Part query, Part fragment) {
            this.uriString = NOT_CACHED;
            this.scheme = scheme;
            this.authority = Part.nonNull(authority);
            this.path = path == null ? PathPart.NULL : path;
            this.query = Part.nonNull(query);
            this.fragment = Part.nonNull(fragment);
        }

        private static final Uri $$robo$$android_net_Uri_HierarchicalUri$readFrom(Parcel parcel) {
            return new HierarchicalUri(parcel.readString(), Part.readFrom(parcel), PathPart.readFrom(parcel), Part.readFrom(parcel), Part.readFrom(parcel));
        }

        private final int $$robo$$android_net_Uri_HierarchicalUri$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_Uri_HierarchicalUri$writeToParcel(Parcel parcel, int flags) {
            parcel.writeInt(3);
            parcel.writeString(this.scheme);
            this.authority.writeTo(parcel);
            this.path.writeTo(parcel);
            this.query.writeTo(parcel);
            this.fragment.writeTo(parcel);
        }

        private final boolean $$robo$$android_net_Uri_HierarchicalUri$isHierarchical() {
            return true;
        }

        private final boolean $$robo$$android_net_Uri_HierarchicalUri$isRelative() {
            return this.scheme == null;
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getScheme() {
            return this.scheme;
        }

        private final Part $$robo$$android_net_Uri_HierarchicalUri$getSsp() {
            return this.ssp == null ? (this.ssp = Part.fromEncoded(this.makeSchemeSpecificPart())) : this.ssp;
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getEncodedSchemeSpecificPart() {
            return this.getSsp().getEncoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getSchemeSpecificPart() {
            return this.getSsp().getDecoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$makeSchemeSpecificPart() {
            StringBuilder builder = new StringBuilder();
            this.appendSspTo(builder);
            return builder.toString();
        }

        private final void $$robo$$android_net_Uri_HierarchicalUri$appendSspTo(StringBuilder builder) {
            String encodedPath;
            String encodedAuthority = this.authority.getEncoded();
            if (encodedAuthority != null) {
                builder.append("//").append(encodedAuthority);
            }
            if ((encodedPath = this.path.getEncoded()) != null) {
                builder.append(encodedPath);
            }
            if (!this.query.isEmpty()) {
                builder.append('?').append(this.query.getEncoded());
            }
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getAuthority() {
            return this.authority.getDecoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getEncodedAuthority() {
            return this.authority.getEncoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getEncodedPath() {
            return this.path.getEncoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getPath() {
            return this.path.getDecoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getQuery() {
            return this.query.getDecoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getEncodedQuery() {
            return this.query.getEncoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getFragment() {
            return this.fragment.getDecoded();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$getEncodedFragment() {
            return this.fragment.getEncoded();
        }

        private final List<String> $$robo$$android_net_Uri_HierarchicalUri$getPathSegments() {
            return this.path.getPathSegments();
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$toString() {
            boolean cached = this.uriString != NOT_CACHED;
            return cached ? this.uriString : (this.uriString = this.makeUriString());
        }

        private final String $$robo$$android_net_Uri_HierarchicalUri$makeUriString() {
            StringBuilder builder = new StringBuilder();
            if (this.scheme != null) {
                builder.append(this.scheme).append(':');
            }
            this.appendSspTo(builder);
            if (!this.fragment.isEmpty()) {
                builder.append('#').append(this.fragment.getEncoded());
            }
            return builder.toString();
        }

        private final Builder $$robo$$android_net_Uri_HierarchicalUri$buildUpon() {
            return new Builder().scheme(this.scheme).authority(this.authority).path(this.path).query(this.query).fragment(this.fragment);
        }

        private /* synthetic */ void $$robo$$android_net_Uri_HierarchicalUri$__constructor__(String x0, Part x1, PathPart x2, Part x3, Part x4, 1 x5) {
        }

        private void __constructor__(String string2, Part part, PathPart pathPart, Part part2, Part part3) {
            this.$$robo$$android_net_Uri_HierarchicalUri$__constructor__(string2, part, pathPart, part2, part3);
        }

        private HierarchicalUri(String string2, Part part, PathPart pathPart, Part part2, Part part3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_HierarchicalUri$__constructor__(java.lang.String android.net.Uri$Part android.net.Uri$PathPart android.net.Uri$Part android.net.Uri$Part ), 0, this, string2, part, pathPart, part2, part3);
        }

        static Uri readFrom(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("readFrom", $$robo$$android_net_Uri_HierarchicalUri$readFrom(android.os.Parcel ), 0, (Parcel)parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_Uri_HierarchicalUri$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_Uri_HierarchicalUri$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public boolean isHierarchical() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHierarchical", $$robo$$android_net_Uri_HierarchicalUri$isHierarchical(), 0, this);
        }

        @Override
        public boolean isRelative() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRelative", $$robo$$android_net_Uri_HierarchicalUri$isRelative(), 0, this);
        }

        @Override
        public String getScheme() {
            return InvokeDynamicSupport.bootstrap("getScheme", $$robo$$android_net_Uri_HierarchicalUri$getScheme(), 0, this);
        }

        private Part getSsp() {
            return InvokeDynamicSupport.bootstrap("getSsp", $$robo$$android_net_Uri_HierarchicalUri$getSsp(), 0, this);
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return InvokeDynamicSupport.bootstrap("getEncodedSchemeSpecificPart", $$robo$$android_net_Uri_HierarchicalUri$getEncodedSchemeSpecificPart(), 0, this);
        }

        @Override
        public String getSchemeSpecificPart() {
            return InvokeDynamicSupport.bootstrap("getSchemeSpecificPart", $$robo$$android_net_Uri_HierarchicalUri$getSchemeSpecificPart(), 0, this);
        }

        private String makeSchemeSpecificPart() {
            return InvokeDynamicSupport.bootstrap("makeSchemeSpecificPart", $$robo$$android_net_Uri_HierarchicalUri$makeSchemeSpecificPart(), 0, this);
        }

        private void appendSspTo(StringBuilder stringBuilder) {
            InvokeDynamicSupport.bootstrap("appendSspTo", $$robo$$android_net_Uri_HierarchicalUri$appendSspTo(java.lang.StringBuilder ), 0, this, stringBuilder);
        }

        @Override
        public String getAuthority() {
            return InvokeDynamicSupport.bootstrap("getAuthority", $$robo$$android_net_Uri_HierarchicalUri$getAuthority(), 0, this);
        }

        @Override
        public String getEncodedAuthority() {
            return InvokeDynamicSupport.bootstrap("getEncodedAuthority", $$robo$$android_net_Uri_HierarchicalUri$getEncodedAuthority(), 0, this);
        }

        @Override
        public String getEncodedPath() {
            return InvokeDynamicSupport.bootstrap("getEncodedPath", $$robo$$android_net_Uri_HierarchicalUri$getEncodedPath(), 0, this);
        }

        @Override
        public String getPath() {
            return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_net_Uri_HierarchicalUri$getPath(), 0, this);
        }

        @Override
        public String getQuery() {
            return InvokeDynamicSupport.bootstrap("getQuery", $$robo$$android_net_Uri_HierarchicalUri$getQuery(), 0, this);
        }

        @Override
        public String getEncodedQuery() {
            return InvokeDynamicSupport.bootstrap("getEncodedQuery", $$robo$$android_net_Uri_HierarchicalUri$getEncodedQuery(), 0, this);
        }

        @Override
        public String getFragment() {
            return InvokeDynamicSupport.bootstrap("getFragment", $$robo$$android_net_Uri_HierarchicalUri$getFragment(), 0, this);
        }

        @Override
        public String getEncodedFragment() {
            return InvokeDynamicSupport.bootstrap("getEncodedFragment", $$robo$$android_net_Uri_HierarchicalUri$getEncodedFragment(), 0, this);
        }

        @Override
        public List<String> getPathSegments() {
            return InvokeDynamicSupport.bootstrap("getPathSegments", $$robo$$android_net_Uri_HierarchicalUri$getPathSegments(), 0, this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_Uri_HierarchicalUri$toString(), 0, this);
        }

        private String makeUriString() {
            return InvokeDynamicSupport.bootstrap("makeUriString", $$robo$$android_net_Uri_HierarchicalUri$makeUriString(), 0, this);
        }

        @Override
        public Builder buildUpon() {
            return InvokeDynamicSupport.bootstrap("buildUpon", $$robo$$android_net_Uri_HierarchicalUri$buildUpon(), 0, this);
        }

        private /* synthetic */ void __constructor__(String string2, Part part, PathPart pathPart, Part part2, Part part3, 1 var6_6) {
            this.$$robo$$android_net_Uri_HierarchicalUri$__constructor__(string2, part, pathPart, part2, part3, var6_6);
        }

        public /* synthetic */ HierarchicalUri() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HierarchicalUri)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class AbstractHierarchicalUri
    extends Uri
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Part userInfo;
        private volatile String host;
        private volatile int port;

        private void $$robo$$android_net_Uri_AbstractHierarchicalUri$__constructor__() {
            this.host = NOT_CACHED;
            this.port = -2;
        }

        private final String $$robo$$android_net_Uri_AbstractHierarchicalUri$getLastPathSegment() {
            List<String> segments = this.getPathSegments();
            int size = segments.size();
            if (size == 0) {
                return null;
            }
            return segments.get(size - 1);
        }

        private final Part $$robo$$android_net_Uri_AbstractHierarchicalUri$getUserInfoPart() {
            return this.userInfo == null ? (this.userInfo = Part.fromEncoded(this.parseUserInfo())) : this.userInfo;
        }

        private final String $$robo$$android_net_Uri_AbstractHierarchicalUri$getEncodedUserInfo() {
            return this.getUserInfoPart().getEncoded();
        }

        private final String $$robo$$android_net_Uri_AbstractHierarchicalUri$parseUserInfo() {
            String authority = this.getEncodedAuthority();
            if (authority == null) {
                return null;
            }
            int end = authority.lastIndexOf(64);
            return end == -1 ? null : authority.substring(0, end);
        }

        private final String $$robo$$android_net_Uri_AbstractHierarchicalUri$getUserInfo() {
            return this.getUserInfoPart().getDecoded();
        }

        private final String $$robo$$android_net_Uri_AbstractHierarchicalUri$getHost() {
            boolean cached = this.host != NOT_CACHED;
            return cached ? this.host : (this.host = this.parseHost());
        }

        private final String $$robo$$android_net_Uri_AbstractHierarchicalUri$parseHost() {
            String authority = this.getEncodedAuthority();
            if (authority == null) {
                return null;
            }
            int userInfoSeparator = authority.lastIndexOf(64);
            int portSeparator = authority.indexOf(58, userInfoSeparator);
            String encodedHost = portSeparator == -1 ? authority.substring(userInfoSeparator + 1) : authority.substring(userInfoSeparator + 1, portSeparator);
            return AbstractHierarchicalUri.decode(encodedHost);
        }

        private final int $$robo$$android_net_Uri_AbstractHierarchicalUri$getPort() {
            return this.port == -2 ? (this.port = this.parsePort()) : this.port;
        }

        private final int $$robo$$android_net_Uri_AbstractHierarchicalUri$parsePort() {
            String authority = this.getEncodedAuthority();
            if (authority == null) {
                return -1;
            }
            int userInfoSeparator = authority.lastIndexOf(64);
            int portSeparator = authority.indexOf(58, userInfoSeparator);
            if (portSeparator == -1) {
                return -1;
            }
            String portString = AbstractHierarchicalUri.decode(authority.substring(portSeparator + 1));
            try {
                return Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                Log.w(LOG, "Error parsing port string.", e);
                return -1;
            }
        }

        private /* synthetic */ void $$robo$$android_net_Uri_AbstractHierarchicalUri$__constructor__(1 x0) {
        }

        @Override
        private void __constructor__() {
            this.$$robo$$android_net_Uri_AbstractHierarchicalUri$__constructor__();
        }

        private AbstractHierarchicalUri() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_AbstractHierarchicalUri$__constructor__(), 0, this);
        }

        @Override
        public String getLastPathSegment() {
            return InvokeDynamicSupport.bootstrap("getLastPathSegment", $$robo$$android_net_Uri_AbstractHierarchicalUri$getLastPathSegment(), 0, this);
        }

        private Part getUserInfoPart() {
            return InvokeDynamicSupport.bootstrap("getUserInfoPart", $$robo$$android_net_Uri_AbstractHierarchicalUri$getUserInfoPart(), 0, this);
        }

        @Override
        public String getEncodedUserInfo() {
            return InvokeDynamicSupport.bootstrap("getEncodedUserInfo", $$robo$$android_net_Uri_AbstractHierarchicalUri$getEncodedUserInfo(), 0, this);
        }

        private String parseUserInfo() {
            return InvokeDynamicSupport.bootstrap("parseUserInfo", $$robo$$android_net_Uri_AbstractHierarchicalUri$parseUserInfo(), 0, this);
        }

        @Override
        public String getUserInfo() {
            return InvokeDynamicSupport.bootstrap("getUserInfo", $$robo$$android_net_Uri_AbstractHierarchicalUri$getUserInfo(), 0, this);
        }

        @Override
        public String getHost() {
            return InvokeDynamicSupport.bootstrap("getHost", $$robo$$android_net_Uri_AbstractHierarchicalUri$getHost(), 0, this);
        }

        private String parseHost() {
            return InvokeDynamicSupport.bootstrap("parseHost", $$robo$$android_net_Uri_AbstractHierarchicalUri$parseHost(), 0, this);
        }

        @Override
        public int getPort() {
            return (int)InvokeDynamicSupport.bootstrap("getPort", $$robo$$android_net_Uri_AbstractHierarchicalUri$getPort(), 0, this);
        }

        private int parsePort() {
            return (int)InvokeDynamicSupport.bootstrap("parsePort", $$robo$$android_net_Uri_AbstractHierarchicalUri$parsePort(), 0, this);
        }

        @Override
        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_net_Uri_AbstractHierarchicalUri$__constructor__(var1_1);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractHierarchicalUri)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PathSegmentsBuilder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String[] segments;
        int size;

        private void $$robo$$android_net_Uri_PathSegmentsBuilder$__constructor__() {
            this.size = 0;
        }

        private final void $$robo$$android_net_Uri_PathSegmentsBuilder$add(String segment) {
            if (this.segments == null) {
                this.segments = new String[4];
            } else if (this.size + 1 == this.segments.length) {
                String[] expanded = new String[this.segments.length * 2];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.segments, (int)0, (Object)expanded, (int)0, (int)this.segments.length);
                this.segments = expanded;
            }
            this.segments[this.size++] = segment;
        }

        private final PathSegments $$robo$$android_net_Uri_PathSegmentsBuilder$build() {
            if (this.segments == null) {
                return PathSegments.EMPTY;
            }
            try {
                PathSegments pathSegments = new PathSegments(this.segments, this.size);
                return pathSegments;
            }
            finally {
                this.segments = null;
            }
        }

        private void __constructor__() {
            this.$$robo$$android_net_Uri_PathSegmentsBuilder$__constructor__();
        }

        PathSegmentsBuilder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_PathSegmentsBuilder$__constructor__(), 0, this);
        }

        void add(String string2) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$android_net_Uri_PathSegmentsBuilder$add(java.lang.String ), 0, this, string2);
        }

        PathSegments build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_net_Uri_PathSegmentsBuilder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PathSegmentsBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PathSegments
    extends AbstractList<String>
    implements RandomAccess {
        public transient /* synthetic */ Object __robo_data__;
        static PathSegments EMPTY;
        String[] segments;
        int size;

        private void $$robo$$android_net_Uri_PathSegments$__constructor__(String[] segments, int size) {
            this.segments = segments;
            this.size = size;
        }

        private final String $$robo$$android_net_Uri_PathSegments$get(int index) {
            if (index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.segments[index];
        }

        private final int $$robo$$android_net_Uri_PathSegments$size() {
            return this.size;
        }

        static void __staticInitializer__() {
            EMPTY = new PathSegments(null, 0);
        }

        private void __constructor__(String[] stringArray, int n) {
            this.$$robo$$android_net_Uri_PathSegments$__constructor__(stringArray, n);
        }

        PathSegments(String[] stringArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_PathSegments$__constructor__(java.lang.String[] int ), 0, this, stringArray, n);
        }

        @Override
        public String get(int n) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_net_Uri_PathSegments$get(int ), 0, this, n);
        }

        @Override
        public int size() {
            return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_net_Uri_PathSegments$size(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(PathSegments.class);
        }

        public /* synthetic */ PathSegments() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PathSegments)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class OpaqueUri
    extends Uri
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int TYPE_ID = 2;
        private String scheme;
        private Part ssp;
        private Part fragment;
        private volatile String cachedString;

        private void $$robo$$android_net_Uri_OpaqueUri$__constructor__(String scheme, Part ssp, Part fragment) {
            this.cachedString = NOT_CACHED;
            this.scheme = scheme;
            this.ssp = ssp;
            this.fragment = fragment == null ? Part.NULL : fragment;
        }

        private static final Uri $$robo$$android_net_Uri_OpaqueUri$readFrom(Parcel parcel) {
            return new OpaqueUri(parcel.readString(), Part.readFrom(parcel), Part.readFrom(parcel));
        }

        private final int $$robo$$android_net_Uri_OpaqueUri$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_Uri_OpaqueUri$writeToParcel(Parcel parcel, int flags) {
            parcel.writeInt(2);
            parcel.writeString(this.scheme);
            this.ssp.writeTo(parcel);
            this.fragment.writeTo(parcel);
        }

        private final boolean $$robo$$android_net_Uri_OpaqueUri$isHierarchical() {
            return false;
        }

        private final boolean $$robo$$android_net_Uri_OpaqueUri$isRelative() {
            return this.scheme == null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getScheme() {
            return this.scheme;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getEncodedSchemeSpecificPart() {
            return this.ssp.getEncoded();
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getSchemeSpecificPart() {
            return this.ssp.getDecoded();
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getAuthority() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getEncodedAuthority() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getPath() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getEncodedPath() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getQuery() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getEncodedQuery() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getFragment() {
            return this.fragment.getDecoded();
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getEncodedFragment() {
            return this.fragment.getEncoded();
        }

        private final List<String> $$robo$$android_net_Uri_OpaqueUri$getPathSegments() {
            return Collections.emptyList();
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getLastPathSegment() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getUserInfo() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getEncodedUserInfo() {
            return null;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$getHost() {
            return null;
        }

        private final int $$robo$$android_net_Uri_OpaqueUri$getPort() {
            return -1;
        }

        private final String $$robo$$android_net_Uri_OpaqueUri$toString() {
            boolean cached;
            boolean bl = cached = this.cachedString != NOT_CACHED;
            if (cached) {
                return this.cachedString;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.scheme).append(':');
            sb.append(this.getEncodedSchemeSpecificPart());
            if (!this.fragment.isEmpty()) {
                sb.append('#').append(this.fragment.getEncoded());
            }
            this.cachedString = sb.toString();
            return this.cachedString;
        }

        private final Builder $$robo$$android_net_Uri_OpaqueUri$buildUpon() {
            return new Builder().scheme(this.scheme).opaquePart(this.ssp).fragment(this.fragment);
        }

        private /* synthetic */ void $$robo$$android_net_Uri_OpaqueUri$__constructor__(String x0, Part x1, Part x2, 1 x3) {
        }

        private void __constructor__(String string2, Part part, Part part2) {
            this.$$robo$$android_net_Uri_OpaqueUri$__constructor__(string2, part, part2);
        }

        private OpaqueUri(String string2, Part part, Part part2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_OpaqueUri$__constructor__(java.lang.String android.net.Uri$Part android.net.Uri$Part ), 0, this, string2, part, part2);
        }

        static Uri readFrom(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("readFrom", $$robo$$android_net_Uri_OpaqueUri$readFrom(android.os.Parcel ), 0, (Parcel)parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_Uri_OpaqueUri$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_Uri_OpaqueUri$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public boolean isHierarchical() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHierarchical", $$robo$$android_net_Uri_OpaqueUri$isHierarchical(), 0, this);
        }

        @Override
        public boolean isRelative() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRelative", $$robo$$android_net_Uri_OpaqueUri$isRelative(), 0, this);
        }

        @Override
        public String getScheme() {
            return InvokeDynamicSupport.bootstrap("getScheme", $$robo$$android_net_Uri_OpaqueUri$getScheme(), 0, this);
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return InvokeDynamicSupport.bootstrap("getEncodedSchemeSpecificPart", $$robo$$android_net_Uri_OpaqueUri$getEncodedSchemeSpecificPart(), 0, this);
        }

        @Override
        public String getSchemeSpecificPart() {
            return InvokeDynamicSupport.bootstrap("getSchemeSpecificPart", $$robo$$android_net_Uri_OpaqueUri$getSchemeSpecificPart(), 0, this);
        }

        @Override
        public String getAuthority() {
            return InvokeDynamicSupport.bootstrap("getAuthority", $$robo$$android_net_Uri_OpaqueUri$getAuthority(), 0, this);
        }

        @Override
        public String getEncodedAuthority() {
            return InvokeDynamicSupport.bootstrap("getEncodedAuthority", $$robo$$android_net_Uri_OpaqueUri$getEncodedAuthority(), 0, this);
        }

        @Override
        public String getPath() {
            return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_net_Uri_OpaqueUri$getPath(), 0, this);
        }

        @Override
        public String getEncodedPath() {
            return InvokeDynamicSupport.bootstrap("getEncodedPath", $$robo$$android_net_Uri_OpaqueUri$getEncodedPath(), 0, this);
        }

        @Override
        public String getQuery() {
            return InvokeDynamicSupport.bootstrap("getQuery", $$robo$$android_net_Uri_OpaqueUri$getQuery(), 0, this);
        }

        @Override
        public String getEncodedQuery() {
            return InvokeDynamicSupport.bootstrap("getEncodedQuery", $$robo$$android_net_Uri_OpaqueUri$getEncodedQuery(), 0, this);
        }

        @Override
        public String getFragment() {
            return InvokeDynamicSupport.bootstrap("getFragment", $$robo$$android_net_Uri_OpaqueUri$getFragment(), 0, this);
        }

        @Override
        public String getEncodedFragment() {
            return InvokeDynamicSupport.bootstrap("getEncodedFragment", $$robo$$android_net_Uri_OpaqueUri$getEncodedFragment(), 0, this);
        }

        @Override
        public List<String> getPathSegments() {
            return InvokeDynamicSupport.bootstrap("getPathSegments", $$robo$$android_net_Uri_OpaqueUri$getPathSegments(), 0, this);
        }

        @Override
        public String getLastPathSegment() {
            return InvokeDynamicSupport.bootstrap("getLastPathSegment", $$robo$$android_net_Uri_OpaqueUri$getLastPathSegment(), 0, this);
        }

        @Override
        public String getUserInfo() {
            return InvokeDynamicSupport.bootstrap("getUserInfo", $$robo$$android_net_Uri_OpaqueUri$getUserInfo(), 0, this);
        }

        @Override
        public String getEncodedUserInfo() {
            return InvokeDynamicSupport.bootstrap("getEncodedUserInfo", $$robo$$android_net_Uri_OpaqueUri$getEncodedUserInfo(), 0, this);
        }

        @Override
        public String getHost() {
            return InvokeDynamicSupport.bootstrap("getHost", $$robo$$android_net_Uri_OpaqueUri$getHost(), 0, this);
        }

        @Override
        public int getPort() {
            return (int)InvokeDynamicSupport.bootstrap("getPort", $$robo$$android_net_Uri_OpaqueUri$getPort(), 0, this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_Uri_OpaqueUri$toString(), 0, this);
        }

        @Override
        public Builder buildUpon() {
            return InvokeDynamicSupport.bootstrap("buildUpon", $$robo$$android_net_Uri_OpaqueUri$buildUpon(), 0, this);
        }

        private /* synthetic */ void __constructor__(String string2, Part part, Part part2, 1 var4_4) {
            this.$$robo$$android_net_Uri_OpaqueUri$__constructor__(string2, part, part2, var4_4);
        }

        public /* synthetic */ OpaqueUri() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OpaqueUri)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class StringUri
    extends AbstractHierarchicalUri
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int TYPE_ID = 1;
        private String uriString;
        private volatile int cachedSsi;
        private volatile int cachedFsi;
        private volatile String scheme;
        private Part ssp;
        private Part authority;
        private PathPart path;
        private Part query;
        private Part fragment;

        private void $$robo$$android_net_Uri_StringUri$__constructor__(String uriString) {
            this.cachedSsi = -2;
            this.cachedFsi = -2;
            this.scheme = NOT_CACHED;
            if (uriString == null) {
                throw new NullPointerException("uriString");
            }
            this.uriString = uriString;
        }

        private static final Uri $$robo$$android_net_Uri_StringUri$readFrom(Parcel parcel) {
            return new StringUri(parcel.readString());
        }

        private final int $$robo$$android_net_Uri_StringUri$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_Uri_StringUri$writeToParcel(Parcel parcel, int flags) {
            parcel.writeInt(1);
            parcel.writeString(this.uriString);
        }

        private final int $$robo$$android_net_Uri_StringUri$findSchemeSeparator() {
            return this.cachedSsi == -2 ? (this.cachedSsi = this.uriString.indexOf(58)) : this.cachedSsi;
        }

        private final int $$robo$$android_net_Uri_StringUri$findFragmentSeparator() {
            return this.cachedFsi == -2 ? (this.cachedFsi = this.uriString.indexOf(35, this.findSchemeSeparator())) : this.cachedFsi;
        }

        private final boolean $$robo$$android_net_Uri_StringUri$isHierarchical() {
            int ssi = this.findSchemeSeparator();
            if (ssi == -1) {
                return true;
            }
            if (this.uriString.length() == ssi + 1) {
                return false;
            }
            return this.uriString.charAt(ssi + 1) == '/';
        }

        private final boolean $$robo$$android_net_Uri_StringUri$isRelative() {
            return this.findSchemeSeparator() == -1;
        }

        private final String $$robo$$android_net_Uri_StringUri$getScheme() {
            boolean cached = this.scheme != NOT_CACHED;
            return cached ? this.scheme : (this.scheme = this.parseScheme());
        }

        private final String $$robo$$android_net_Uri_StringUri$parseScheme() {
            int ssi = this.findSchemeSeparator();
            return ssi == -1 ? null : this.uriString.substring(0, ssi);
        }

        private final Part $$robo$$android_net_Uri_StringUri$getSsp() {
            return this.ssp == null ? (this.ssp = Part.fromEncoded(this.parseSsp())) : this.ssp;
        }

        private final String $$robo$$android_net_Uri_StringUri$getEncodedSchemeSpecificPart() {
            return this.getSsp().getEncoded();
        }

        private final String $$robo$$android_net_Uri_StringUri$getSchemeSpecificPart() {
            return this.getSsp().getDecoded();
        }

        private final String $$robo$$android_net_Uri_StringUri$parseSsp() {
            int ssi = this.findSchemeSeparator();
            int fsi = this.findFragmentSeparator();
            return fsi == -1 ? this.uriString.substring(ssi + 1) : this.uriString.substring(ssi + 1, fsi);
        }

        private final Part $$robo$$android_net_Uri_StringUri$getAuthorityPart() {
            if (this.authority == null) {
                String encodedAuthority = StringUri.parseAuthority(this.uriString, this.findSchemeSeparator());
                this.authority = Part.fromEncoded(encodedAuthority);
                return this.authority;
            }
            return this.authority;
        }

        private final String $$robo$$android_net_Uri_StringUri$getEncodedAuthority() {
            return this.getAuthorityPart().getEncoded();
        }

        private final String $$robo$$android_net_Uri_StringUri$getAuthority() {
            return this.getAuthorityPart().getDecoded();
        }

        private final PathPart $$robo$$android_net_Uri_StringUri$getPathPart() {
            return this.path == null ? (this.path = PathPart.fromEncoded(this.parsePath())) : this.path;
        }

        private final String $$robo$$android_net_Uri_StringUri$getPath() {
            return this.getPathPart().getDecoded();
        }

        private final String $$robo$$android_net_Uri_StringUri$getEncodedPath() {
            return this.getPathPart().getEncoded();
        }

        private final List<String> $$robo$$android_net_Uri_StringUri$getPathSegments() {
            return this.getPathPart().getPathSegments();
        }

        private final String $$robo$$android_net_Uri_StringUri$parsePath() {
            String uriString = this.uriString;
            int ssi = this.findSchemeSeparator();
            if (ssi > -1) {
                boolean schemeOnly;
                boolean bl = schemeOnly = ssi + 1 == uriString.length();
                if (schemeOnly) {
                    return null;
                }
                if (uriString.charAt(ssi + 1) != '/') {
                    return null;
                }
            }
            return StringUri.parsePath(uriString, ssi);
        }

        private final Part $$robo$$android_net_Uri_StringUri$getQueryPart() {
            return this.query == null ? (this.query = Part.fromEncoded(this.parseQuery())) : this.query;
        }

        private final String $$robo$$android_net_Uri_StringUri$getEncodedQuery() {
            return this.getQueryPart().getEncoded();
        }

        private final String $$robo$$android_net_Uri_StringUri$parseQuery() {
            int qsi = this.uriString.indexOf(63, this.findSchemeSeparator());
            if (qsi == -1) {
                return null;
            }
            int fsi = this.findFragmentSeparator();
            if (fsi == -1) {
                return this.uriString.substring(qsi + 1);
            }
            if (fsi < qsi) {
                return null;
            }
            return this.uriString.substring(qsi + 1, fsi);
        }

        private final String $$robo$$android_net_Uri_StringUri$getQuery() {
            return this.getQueryPart().getDecoded();
        }

        private final Part $$robo$$android_net_Uri_StringUri$getFragmentPart() {
            return this.fragment == null ? (this.fragment = Part.fromEncoded(this.parseFragment())) : this.fragment;
        }

        private final String $$robo$$android_net_Uri_StringUri$getEncodedFragment() {
            return this.getFragmentPart().getEncoded();
        }

        private final String $$robo$$android_net_Uri_StringUri$parseFragment() {
            int fsi = this.findFragmentSeparator();
            return fsi == -1 ? null : this.uriString.substring(fsi + 1);
        }

        private final String $$robo$$android_net_Uri_StringUri$getFragment() {
            return this.getFragmentPart().getDecoded();
        }

        private final String $$robo$$android_net_Uri_StringUri$toString() {
            return this.uriString;
        }

        private static final String $$robo$$android_net_Uri_StringUri$parseAuthority(String uriString, int ssi) {
            int length = uriString.length();
            if (length > ssi + 2 && uriString.charAt(ssi + 1) == '/' && uriString.charAt(ssi + 2) == '/') {
                int end;
                block3: for (end = ssi + 3; end < length; ++end) {
                    switch (uriString.charAt(end)) {
                        case '#': 
                        case '/': 
                        case '?': 
                        case '\\': {
                            break block3;
                        }
                        default: {
                            continue block3;
                        }
                    }
                }
                return uriString.substring(ssi + 3, end);
            }
            return null;
        }

        private static final String $$robo$$android_net_Uri_StringUri$parsePath(String uriString, int ssi) {
            int pathEnd;
            int pathStart;
            int length;
            block11: {
                length = uriString.length();
                if (length > ssi + 2 && uriString.charAt(ssi + 1) == '/' && uriString.charAt(ssi + 2) == '/') {
                    pathStart = ssi + 3;
                    while (pathStart < length) {
                        switch (uriString.charAt(pathStart)) {
                            case '#': 
                            case '?': {
                                return "";
                            }
                            case '/': 
                            case '\\': {
                                break block11;
                            }
                            default: {
                                ++pathStart;
                                break;
                            }
                        }
                    }
                } else {
                    pathStart = ssi + 1;
                }
            }
            block8: for (pathEnd = pathStart; pathEnd < length; ++pathEnd) {
                switch (uriString.charAt(pathEnd)) {
                    case '#': 
                    case '?': {
                        break block8;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            return uriString.substring(pathStart, pathEnd);
        }

        private final Builder $$robo$$android_net_Uri_StringUri$buildUpon() {
            if (this.isHierarchical()) {
                return new Builder().scheme(this.getScheme()).authority(this.getAuthorityPart()).path(this.getPathPart()).query(this.getQueryPart()).fragment(this.getFragmentPart());
            }
            return new Builder().scheme(this.getScheme()).opaquePart(this.getSsp()).fragment(this.getFragmentPart());
        }

        private /* synthetic */ void $$robo$$android_net_Uri_StringUri$__constructor__(String x0, 1 x1) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_net_Uri_StringUri$__constructor__(string2);
        }

        private StringUri(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_Uri_StringUri$__constructor__(java.lang.String ), 0, this, string2);
        }

        static Uri readFrom(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("readFrom", $$robo$$android_net_Uri_StringUri$readFrom(android.os.Parcel ), 0, (Parcel)parcel);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_Uri_StringUri$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_Uri_StringUri$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private int findSchemeSeparator() {
            return (int)InvokeDynamicSupport.bootstrap("findSchemeSeparator", $$robo$$android_net_Uri_StringUri$findSchemeSeparator(), 0, this);
        }

        private int findFragmentSeparator() {
            return (int)InvokeDynamicSupport.bootstrap("findFragmentSeparator", $$robo$$android_net_Uri_StringUri$findFragmentSeparator(), 0, this);
        }

        @Override
        public boolean isHierarchical() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHierarchical", $$robo$$android_net_Uri_StringUri$isHierarchical(), 0, this);
        }

        @Override
        public boolean isRelative() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRelative", $$robo$$android_net_Uri_StringUri$isRelative(), 0, this);
        }

        @Override
        public String getScheme() {
            return InvokeDynamicSupport.bootstrap("getScheme", $$robo$$android_net_Uri_StringUri$getScheme(), 0, this);
        }

        private String parseScheme() {
            return InvokeDynamicSupport.bootstrap("parseScheme", $$robo$$android_net_Uri_StringUri$parseScheme(), 0, this);
        }

        private Part getSsp() {
            return InvokeDynamicSupport.bootstrap("getSsp", $$robo$$android_net_Uri_StringUri$getSsp(), 0, this);
        }

        @Override
        public String getEncodedSchemeSpecificPart() {
            return InvokeDynamicSupport.bootstrap("getEncodedSchemeSpecificPart", $$robo$$android_net_Uri_StringUri$getEncodedSchemeSpecificPart(), 0, this);
        }

        @Override
        public String getSchemeSpecificPart() {
            return InvokeDynamicSupport.bootstrap("getSchemeSpecificPart", $$robo$$android_net_Uri_StringUri$getSchemeSpecificPart(), 0, this);
        }

        private String parseSsp() {
            return InvokeDynamicSupport.bootstrap("parseSsp", $$robo$$android_net_Uri_StringUri$parseSsp(), 0, this);
        }

        private Part getAuthorityPart() {
            return InvokeDynamicSupport.bootstrap("getAuthorityPart", $$robo$$android_net_Uri_StringUri$getAuthorityPart(), 0, this);
        }

        @Override
        public String getEncodedAuthority() {
            return InvokeDynamicSupport.bootstrap("getEncodedAuthority", $$robo$$android_net_Uri_StringUri$getEncodedAuthority(), 0, this);
        }

        @Override
        public String getAuthority() {
            return InvokeDynamicSupport.bootstrap("getAuthority", $$robo$$android_net_Uri_StringUri$getAuthority(), 0, this);
        }

        private PathPart getPathPart() {
            return InvokeDynamicSupport.bootstrap("getPathPart", $$robo$$android_net_Uri_StringUri$getPathPart(), 0, this);
        }

        @Override
        public String getPath() {
            return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_net_Uri_StringUri$getPath(), 0, this);
        }

        @Override
        public String getEncodedPath() {
            return InvokeDynamicSupport.bootstrap("getEncodedPath", $$robo$$android_net_Uri_StringUri$getEncodedPath(), 0, this);
        }

        @Override
        public List<String> getPathSegments() {
            return InvokeDynamicSupport.bootstrap("getPathSegments", $$robo$$android_net_Uri_StringUri$getPathSegments(), 0, this);
        }

        private String parsePath() {
            return InvokeDynamicSupport.bootstrap("parsePath", $$robo$$android_net_Uri_StringUri$parsePath(), 0, this);
        }

        private Part getQueryPart() {
            return InvokeDynamicSupport.bootstrap("getQueryPart", $$robo$$android_net_Uri_StringUri$getQueryPart(), 0, this);
        }

        @Override
        public String getEncodedQuery() {
            return InvokeDynamicSupport.bootstrap("getEncodedQuery", $$robo$$android_net_Uri_StringUri$getEncodedQuery(), 0, this);
        }

        private String parseQuery() {
            return InvokeDynamicSupport.bootstrap("parseQuery", $$robo$$android_net_Uri_StringUri$parseQuery(), 0, this);
        }

        @Override
        public String getQuery() {
            return InvokeDynamicSupport.bootstrap("getQuery", $$robo$$android_net_Uri_StringUri$getQuery(), 0, this);
        }

        private Part getFragmentPart() {
            return InvokeDynamicSupport.bootstrap("getFragmentPart", $$robo$$android_net_Uri_StringUri$getFragmentPart(), 0, this);
        }

        @Override
        public String getEncodedFragment() {
            return InvokeDynamicSupport.bootstrap("getEncodedFragment", $$robo$$android_net_Uri_StringUri$getEncodedFragment(), 0, this);
        }

        private String parseFragment() {
            return InvokeDynamicSupport.bootstrap("parseFragment", $$robo$$android_net_Uri_StringUri$parseFragment(), 0, this);
        }

        @Override
        public String getFragment() {
            return InvokeDynamicSupport.bootstrap("getFragment", $$robo$$android_net_Uri_StringUri$getFragment(), 0, this);
        }

        @Override
        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_Uri_StringUri$toString(), 0, this);
        }

        static String parseAuthority(String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("parseAuthority", $$robo$$android_net_Uri_StringUri$parseAuthority(java.lang.String int ), 0, (String)string2, (int)n);
        }

        static String parsePath(String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("parsePath", $$robo$$android_net_Uri_StringUri$parsePath(java.lang.String int ), 0, (String)string2, (int)n);
        }

        @Override
        public Builder buildUpon() {
            return InvokeDynamicSupport.bootstrap("buildUpon", $$robo$$android_net_Uri_StringUri$buildUpon(), 0, this);
        }

        private /* synthetic */ void __constructor__(String string2, 1 var2_2) {
            this.$$robo$$android_net_Uri_StringUri$__constructor__(string2, var2_2);
        }

        public /* synthetic */ StringUri() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StringUri)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

