/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.net.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class WebAddress
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mScheme;
    private String mHost;
    private int mPort;
    private String mPath;
    private String mAuthInfo;
    static int MATCH_GROUP_SCHEME = 1;
    static int MATCH_GROUP_AUTHORITY = 2;
    static int MATCH_GROUP_HOST = 3;
    static int MATCH_GROUP_PORT = 4;
    static int MATCH_GROUP_PATH = 5;
    static Pattern sAddressPattern;

    private void $$robo$$android_net_WebAddress$__constructor__(String address) throws ParseException {
        if (address == null) {
            throw new NullPointerException();
        }
        this.mScheme = "";
        this.mHost = "";
        this.mPort = -1;
        this.mPath = "/";
        this.mAuthInfo = "";
        Matcher m = sAddressPattern.matcher(address);
        if (m.matches()) {
            String t = m.group(1);
            if (t != null) {
                this.mScheme = t.toLowerCase(Locale.ROOT);
            }
            if ((t = m.group(2)) != null) {
                this.mAuthInfo = t;
            }
            if ((t = m.group(3)) != null) {
                this.mHost = t;
            }
            if ((t = m.group(4)) != null && t.length() > 0) {
                try {
                    this.mPort = Integer.parseInt(t);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Bad port");
                }
            }
            if ((t = m.group(5)) != null && t.length() > 0) {
                this.mPath = t.charAt(0) == '/' ? t : "/" + t;
            }
        } else {
            throw new ParseException("Bad address");
        }
        if (this.mPort == 443 && this.mScheme.equals("")) {
            this.mScheme = "https";
        } else if (this.mPort == -1) {
            this.mPort = this.mScheme.equals("https") ? 443 : 80;
        }
        if (this.mScheme.equals("")) {
            this.mScheme = "http";
        }
    }

    private final String $$robo$$android_net_WebAddress$toString() {
        String port = "";
        if (this.mPort != 443 && this.mScheme.equals("https") || this.mPort != 80 && this.mScheme.equals("http")) {
            port = ":" + Integer.toString(this.mPort);
        }
        String authInfo = "";
        if (this.mAuthInfo.length() > 0) {
            authInfo = this.mAuthInfo + "@";
        }
        return this.mScheme + "://" + authInfo + this.mHost + port + this.mPath;
    }

    private final void $$robo$$android_net_WebAddress$setScheme(String scheme) {
        this.mScheme = scheme;
    }

    private final String $$robo$$android_net_WebAddress$getScheme() {
        return this.mScheme;
    }

    private final void $$robo$$android_net_WebAddress$setHost(String host) {
        this.mHost = host;
    }

    private final String $$robo$$android_net_WebAddress$getHost() {
        return this.mHost;
    }

    private final void $$robo$$android_net_WebAddress$setPort(int port) {
        this.mPort = port;
    }

    private final int $$robo$$android_net_WebAddress$getPort() {
        return this.mPort;
    }

    private final void $$robo$$android_net_WebAddress$setPath(String path) {
        this.mPath = path;
    }

    private final String $$robo$$android_net_WebAddress$getPath() {
        return this.mPath;
    }

    private final void $$robo$$android_net_WebAddress$setAuthInfo(String authInfo) {
        this.mAuthInfo = authInfo;
    }

    private final String $$robo$$android_net_WebAddress$getAuthInfo() {
        return this.mAuthInfo;
    }

    static void __staticInitializer__() {
        sAddressPattern = Pattern.compile("(?:(http|https|file)\\:\\/\\/)?(?:([-A-Za-z0-9$_.+!*'(),;?&=]+(?:\\:[-A-Za-z0-9$_.+!*'(),;?&=]+)?)@)?([a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef%_-][a-zA-Z0-9\u00a0-\ud7ff\uf900-\ufdcf\ufdf0-\uffef%_\\.-]*|\\[[0-9a-fA-F:\\.]+\\])?(?:\\:([0-9]*))?(\\/?[^#]*)?.*", 2);
    }

    private void __constructor__(String string2) throws ParseException {
        this.$$robo$$android_net_WebAddress$__constructor__(string2);
    }

    public WebAddress(String string2) throws ParseException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_WebAddress$__constructor__(java.lang.String ), 0, this, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_WebAddress$toString(), 0, this);
    }

    public void setScheme(String string2) {
        InvokeDynamicSupport.bootstrap("setScheme", $$robo$$android_net_WebAddress$setScheme(java.lang.String ), 0, this, string2);
    }

    public String getScheme() {
        return InvokeDynamicSupport.bootstrap("getScheme", $$robo$$android_net_WebAddress$getScheme(), 0, this);
    }

    public void setHost(String string2) {
        InvokeDynamicSupport.bootstrap("setHost", $$robo$$android_net_WebAddress$setHost(java.lang.String ), 0, this, string2);
    }

    public String getHost() {
        return InvokeDynamicSupport.bootstrap("getHost", $$robo$$android_net_WebAddress$getHost(), 0, this);
    }

    public void setPort(int n) {
        InvokeDynamicSupport.bootstrap("setPort", $$robo$$android_net_WebAddress$setPort(int ), 0, this, n);
    }

    public int getPort() {
        return (int)InvokeDynamicSupport.bootstrap("getPort", $$robo$$android_net_WebAddress$getPort(), 0, this);
    }

    public void setPath(String string2) {
        InvokeDynamicSupport.bootstrap("setPath", $$robo$$android_net_WebAddress$setPath(java.lang.String ), 0, this, string2);
    }

    public String getPath() {
        return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_net_WebAddress$getPath(), 0, this);
    }

    public void setAuthInfo(String string2) {
        InvokeDynamicSupport.bootstrap("setAuthInfo", $$robo$$android_net_WebAddress$setAuthInfo(java.lang.String ), 0, this, string2);
    }

    public String getAuthInfo() {
        return InvokeDynamicSupport.bootstrap("getAuthInfo", $$robo$$android_net_WebAddress$getAuthInfo(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(WebAddress.class);
    }

    public /* synthetic */ WebAddress() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WebAddress)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

