/*
 * Decompiled with CFR 0.152.
 */
package android.net.apf;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.apf.ApfCapabilities;
import android.net.apf.ApfGenerator;
import android.net.ip.IpClient;
import android.net.metrics.ApfProgramEvent;
import android.net.metrics.ApfStats;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.RaEvent;
import android.net.util.InterfaceParams;
import android.os.PowerManager;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.BitUtils;
import com.android.internal.util.HexDump;
import com.android.internal.util.IndentingPrintWriter;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.io.IoBridge;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ApfFilter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mCountAndPassLabel;
    private String mCountAndDropLabel;
    private static String TAG = "ApfFilter";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int ETH_HEADER_LEN = 14;
    private static int ETH_DEST_ADDR_OFFSET = 0;
    private static int ETH_ETHERTYPE_OFFSET = 12;
    private static int ETH_TYPE_MIN = 1536;
    private static int ETH_TYPE_MAX = 65535;
    private static byte[] ETH_BROADCAST_MAC_ADDRESS;
    private static int IPV4_FRAGMENT_OFFSET_OFFSET = 20;
    private static int IPV4_FRAGMENT_OFFSET_MASK = 8191;
    private static int IPV4_PROTOCOL_OFFSET = 23;
    private static int IPV4_DEST_ADDR_OFFSET = 30;
    private static int IPV4_ANY_HOST_ADDRESS = 0;
    private static int IPV4_BROADCAST_ADDRESS = -1;
    private static int IPV6_FLOW_LABEL_OFFSET = 15;
    private static int IPV6_FLOW_LABEL_LEN = 3;
    private static int IPV6_NEXT_HEADER_OFFSET = 20;
    private static int IPV6_SRC_ADDR_OFFSET = 22;
    private static int IPV6_DEST_ADDR_OFFSET = 38;
    private static int IPV6_HEADER_LEN = 40;
    private static byte[] IPV6_ALL_NODES_ADDRESS;
    private static int ICMP6_TYPE_OFFSET = 54;
    private static int UDP_DESTINATION_PORT_OFFSET = 16;
    private static int UDP_HEADER_LEN = 8;
    private static int DHCP_CLIENT_PORT = 68;
    private static int DHCP_CLIENT_MAC_OFFSET = 50;
    private static int ARP_HEADER_OFFSET = 14;
    private static int ARP_OPCODE_OFFSET = 20;
    private static short ARP_OPCODE_REQUEST = 1;
    private static short ARP_OPCODE_REPLY = 2;
    private static byte[] ARP_IPV4_HEADER;
    private static int ARP_TARGET_IP_ADDRESS_OFFSET = 38;
    private static int APF_PROGRAM_EVENT_LIFETIME_THRESHOLD = 2;
    private static int APF_MAX_ETH_TYPE_BLACK_LIST_LEN = 20;
    private ApfCapabilities mApfCapabilities;
    private IpClient.Callback mIpClientCallback;
    private InterfaceParams mInterfaceParams;
    private IpConnectivityLog mMetricsLog;
    @VisibleForTesting
    byte[] mHardwareAddress;
    @VisibleForTesting
    ReceiveThread mReceiveThread;
    @GuardedBy(value="this")
    private long mUniqueCounter;
    @GuardedBy(value="this")
    private boolean mMulticastFilter;
    @GuardedBy(value="this")
    private boolean mInDozeMode;
    private boolean mDrop802_3Frames;
    private int[] mEthTypeBlackList;
    private BroadcastReceiver mDeviceIdleReceiver;
    private Context mContext;
    @GuardedBy(value="this")
    private byte[] mIPv4Address;
    @GuardedBy(value="this")
    private int mIPv4PrefixLength;
    private static int MAX_RAS = 10;
    @GuardedBy(value="this")
    private ArrayList<Ra> mRas;
    private static long MAX_PROGRAM_LIFETIME_WORTH_REFRESHING = 30L;
    private static int FRACTION_OF_LIFETIME_TO_FILTER = 6;
    @GuardedBy(value="this")
    private long mLastTimeInstalledProgram;
    @GuardedBy(value="this")
    private long mLastInstalledProgramMinLifetime;
    @GuardedBy(value="this")
    private ApfProgramEvent mLastInstallEvent;
    @GuardedBy(value="this")
    private byte[] mLastInstalledProgram;
    @GuardedBy(value="this")
    private byte[] mDataSnapshot;
    @GuardedBy(value="this")
    private int mNumProgramUpdates;
    @GuardedBy(value="this")
    private int mNumProgramUpdatesAllowingMulticast;

    private final void $$robo$$android_net_apf_ApfFilter$maybeSetCounter(ApfGenerator gen, Counter c) {
        if (this.mApfCapabilities.hasDataAccess()) {
            gen.addLoadImmediate(ApfGenerator.Register.R1, c.offset());
        }
    }

    @VisibleForTesting
    private void $$robo$$android_net_apf_ApfFilter$__constructor__(Context context, ApfConfiguration config, InterfaceParams ifParams, IpClient.Callback ipClientCallback, IpConnectivityLog log) {
        this.mDeviceIdleReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ApfFilter this$0;

            private void $$robo$$android_net_apf_ApfFilter_1$__constructor__(ApfFilter this$0) {
            }

            private final void $$robo$$android_net_apf_ApfFilter_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.os.action.DEVICE_IDLE_MODE_CHANGED")) {
                    PowerManager powerManager = (PowerManager)context.getSystemService("power");
                    boolean deviceIdle = powerManager.isDeviceIdleMode();
                    this.this$0.setDozeMode(deviceIdle);
                }
            }

            private void __constructor__(ApfFilter apfFilter) {
                this.$$robo$$android_net_apf_ApfFilter_1$__constructor__(apfFilter);
            }
            {
                this.this$0 = apfFilter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_1$__constructor__(android.net.apf.ApfFilter ), 0, this, apfFilter);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_net_apf_ApfFilter_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRas = new ArrayList();
        this.mNumProgramUpdates = 0;
        this.mNumProgramUpdatesAllowingMulticast = 0;
        this.mApfCapabilities = config.apfCapabilities;
        this.mIpClientCallback = ipClientCallback;
        this.mInterfaceParams = ifParams;
        this.mMulticastFilter = config.multicastFilter;
        this.mDrop802_3Frames = config.ieee802_3Filter;
        this.mContext = context;
        if (this.mApfCapabilities.hasDataAccess()) {
            this.mCountAndPassLabel = "countAndPass";
            this.mCountAndDropLabel = "countAndDrop";
        } else {
            this.mCountAndPassLabel = "__PASS__";
            this.mCountAndDropLabel = "__DROP__";
        }
        this.mEthTypeBlackList = ApfFilter.filterEthTypeBlackList(config.ethTypeBlackList);
        this.mMetricsLog = log;
        this.maybeStartFilter();
        this.mContext.registerReceiver(this.mDeviceIdleReceiver, new IntentFilter("android.os.action.DEVICE_IDLE_MODE_CHANGED"));
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$setDataSnapshot(byte[] data) {
        this.mDataSnapshot = data;
    }

    private final void $$robo$$android_net_apf_ApfFilter$log(String s) {
        Log.d("ApfFilter", "(" + this.mInterfaceParams.name + "): " + s);
    }

    @GuardedBy(value="this")
    private final long $$robo$$android_net_apf_ApfFilter$getUniqueNumberLocked() {
        return this.mUniqueCounter++;
    }

    @GuardedBy(value="this")
    private static final int[] $$robo$$android_net_apf_ApfFilter$filterEthTypeBlackList(int[] ethTypeBlackList) {
        ArrayList<Integer> bl = new ArrayList<Integer>();
        for (int p : ethTypeBlackList) {
            if (p < 1536 || p > 65535 || bl.contains(p)) continue;
            if (bl.size() == 20) {
                Log.w("ApfFilter", "Passed EthType Black List size too large (" + bl.size() + ") using top " + 20 + " protocols");
                break;
            }
            bl.add(p);
        }
        return bl.stream().mapToInt(Integer::intValue).toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void $$robo$$android_net_apf_ApfFilter$maybeStartFilter() {
        FileDescriptor socket;
        try {
            this.mHardwareAddress = this.mInterfaceParams.macAddr.toByteArray();
            ApfFilter apfFilter = this;
            synchronized (apfFilter) {
                if (this.mApfCapabilities.hasDataAccess()) {
                    byte[] zeroes = new byte[this.mApfCapabilities.maximumApfProgramSize];
                    this.mIpClientCallback.installPacketFilter(zeroes);
                }
                this.installNewProgramLocked();
            }
            socket = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, OsConstants.ETH_P_IPV6);
            PacketSocketAddress addr = new PacketSocketAddress((short)OsConstants.ETH_P_IPV6, this.mInterfaceParams.index);
            Os.bind(socket, addr);
            NetworkUtils.attachRaFilter(socket, this.mApfCapabilities.apfPacketFormat);
        }
        catch (ErrnoException | SocketException e) {
            Log.e("ApfFilter", "Error starting filter", e);
            return;
        }
        this.mReceiveThread = new ReceiveThread(this, socket);
        this.mReceiveThread.start();
    }

    @VisibleForTesting
    private final long $$robo$$android_net_apf_ApfFilter$currentTimeSeconds() {
        return SystemClock.elapsedRealtime() / 1000L;
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$generateArpFilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        String checkTargetIPv4 = "checkTargetIPv4";
        gen.addLoadImmediate(ApfGenerator.Register.R0, 14);
        this.maybeSetCounter(gen, Counter.PASSED_ARP_NON_IPV4);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ARP_IPV4_HEADER, this.mCountAndPassLabel);
        gen.addLoad16(ApfGenerator.Register.R0, 20);
        gen.addJumpIfR0Equals(1, "checkTargetIPv4");
        this.maybeSetCounter(gen, Counter.PASSED_ARP_UNKNOWN);
        gen.addJumpIfR0NotEquals(2, this.mCountAndPassLabel);
        gen.addLoadImmediate(ApfGenerator.Register.R0, 0);
        this.maybeSetCounter(gen, Counter.PASSED_ARP_UNICAST_REPLY);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ETH_BROADCAST_MAC_ADDRESS, this.mCountAndPassLabel);
        gen.defineLabel("checkTargetIPv4");
        if (this.mIPv4Address == null) {
            gen.addLoad32(ApfGenerator.Register.R0, 38);
            this.maybeSetCounter(gen, Counter.DROPPED_GARP_REPLY);
            gen.addJumpIfR0Equals(0, this.mCountAndDropLabel);
        } else {
            gen.addLoadImmediate(ApfGenerator.Register.R0, 38);
            this.maybeSetCounter(gen, Counter.DROPPED_ARP_OTHER_HOST);
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, this.mIPv4Address, this.mCountAndDropLabel);
        }
        this.maybeSetCounter(gen, Counter.PASSED_ARP);
        gen.addJump(this.mCountAndPassLabel);
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$generateIPv4FilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        if (this.mMulticastFilter) {
            String skipDhcpv4Filter = "skip_dhcp_v4_filter";
            gen.addLoad8(ApfGenerator.Register.R0, 23);
            gen.addJumpIfR0NotEquals(OsConstants.IPPROTO_UDP, "skip_dhcp_v4_filter");
            gen.addLoad16(ApfGenerator.Register.R0, 20);
            gen.addJumpIfR0AnyBitsSet(8191, "skip_dhcp_v4_filter");
            gen.addLoadFromMemory(ApfGenerator.Register.R1, 13);
            gen.addLoad16Indexed(ApfGenerator.Register.R0, 16);
            gen.addJumpIfR0NotEquals(68, "skip_dhcp_v4_filter");
            gen.addLoadImmediate(ApfGenerator.Register.R0, 50);
            gen.addAddR1();
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, this.mHardwareAddress, "skip_dhcp_v4_filter");
            this.maybeSetCounter(gen, Counter.PASSED_DHCP);
            gen.addJump(this.mCountAndPassLabel);
            gen.defineLabel("skip_dhcp_v4_filter");
            gen.addLoad8(ApfGenerator.Register.R0, 30);
            gen.addAnd(240);
            this.maybeSetCounter(gen, Counter.DROPPED_IPV4_MULTICAST);
            gen.addJumpIfR0Equals(224, this.mCountAndDropLabel);
            this.maybeSetCounter(gen, Counter.DROPPED_IPV4_BROADCAST_ADDR);
            gen.addLoad32(ApfGenerator.Register.R0, 30);
            gen.addJumpIfR0Equals(-1, this.mCountAndDropLabel);
            if (this.mIPv4Address != null && this.mIPv4PrefixLength < 31) {
                this.maybeSetCounter(gen, Counter.DROPPED_IPV4_BROADCAST_NET);
                int broadcastAddr = ApfFilter.ipv4BroadcastAddress(this.mIPv4Address, this.mIPv4PrefixLength);
                gen.addJumpIfR0Equals(broadcastAddr, this.mCountAndDropLabel);
            }
            this.maybeSetCounter(gen, Counter.PASSED_IPV4_UNICAST);
            gen.addLoadImmediate(ApfGenerator.Register.R0, 0);
            gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ETH_BROADCAST_MAC_ADDRESS, this.mCountAndPassLabel);
            this.maybeSetCounter(gen, Counter.DROPPED_IPV4_L2_BROADCAST);
            gen.addJump(this.mCountAndDropLabel);
        }
        this.maybeSetCounter(gen, Counter.PASSED_IPV4);
        gen.addJump(this.mCountAndPassLabel);
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$generateIPv6FilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        gen.addLoad8(ApfGenerator.Register.R0, 20);
        if (this.mMulticastFilter) {
            String skipIPv6MulticastFilterLabel = "skipIPv6MulticastFilter";
            String dropAllIPv6MulticastsLabel = "dropAllIPv6Multicast";
            if (this.mInDozeMode) {
                gen.addJumpIfR0NotEquals(OsConstants.IPPROTO_ICMPV6, "dropAllIPv6Multicast");
                gen.addLoad8(ApfGenerator.Register.R0, 54);
                gen.addJumpIfR0NotEquals(128, "skipIPv6MulticastFilter");
            } else {
                gen.addJumpIfR0Equals(OsConstants.IPPROTO_ICMPV6, "skipIPv6MulticastFilter");
            }
            gen.defineLabel("dropAllIPv6Multicast");
            this.maybeSetCounter(gen, Counter.DROPPED_IPV6_NON_ICMP_MULTICAST);
            gen.addLoad8(ApfGenerator.Register.R0, 38);
            gen.addJumpIfR0Equals(255, this.mCountAndDropLabel);
            this.maybeSetCounter(gen, Counter.PASSED_IPV6_UNICAST_NON_ICMP);
            gen.addJump(this.mCountAndPassLabel);
            gen.defineLabel("skipIPv6MulticastFilter");
        } else {
            this.maybeSetCounter(gen, Counter.PASSED_IPV6_NON_ICMP);
            gen.addJumpIfR0NotEquals(OsConstants.IPPROTO_ICMPV6, this.mCountAndPassLabel);
        }
        String skipUnsolicitedMulticastNALabel = "skipUnsolicitedMulticastNA";
        gen.addLoad8(ApfGenerator.Register.R0, 54);
        this.maybeSetCounter(gen, Counter.DROPPED_IPV6_ROUTER_SOLICITATION);
        gen.addJumpIfR0Equals(133, this.mCountAndDropLabel);
        gen.addJumpIfR0NotEquals(136, skipUnsolicitedMulticastNALabel);
        gen.addLoadImmediate(ApfGenerator.Register.R0, 38);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, IPV6_ALL_NODES_ADDRESS, skipUnsolicitedMulticastNALabel);
        this.maybeSetCounter(gen, Counter.DROPPED_IPV6_MULTICAST_NA);
        gen.addJump(this.mCountAndDropLabel);
        gen.defineLabel(skipUnsolicitedMulticastNALabel);
    }

    @GuardedBy(value="this")
    private final ApfGenerator $$robo$$android_net_apf_ApfFilter$emitPrologueLocked() throws ApfGenerator.IllegalInstructionException {
        ApfGenerator gen = new ApfGenerator(this.mApfCapabilities.apfVersionSupported);
        if (this.mApfCapabilities.hasDataAccess()) {
            this.maybeSetCounter(gen, Counter.TOTAL_PACKETS);
            gen.addLoadData(ApfGenerator.Register.R0, 0);
            gen.addAdd(1);
            gen.addStoreData(ApfGenerator.Register.R0, 0);
        }
        gen.addLoad16(ApfGenerator.Register.R0, 12);
        if (this.mDrop802_3Frames) {
            this.maybeSetCounter(gen, Counter.DROPPED_802_3_FRAME);
            gen.addJumpIfR0LessThan(1536, this.mCountAndDropLabel);
        }
        this.maybeSetCounter(gen, Counter.DROPPED_ETHERTYPE_BLACKLISTED);
        for (int p : this.mEthTypeBlackList) {
            gen.addJumpIfR0Equals(p, this.mCountAndDropLabel);
        }
        String skipArpFiltersLabel = "skipArpFilters";
        gen.addJumpIfR0NotEquals(OsConstants.ETH_P_ARP, skipArpFiltersLabel);
        this.generateArpFilterLocked(gen);
        gen.defineLabel(skipArpFiltersLabel);
        String skipIPv4FiltersLabel = "skipIPv4Filters";
        gen.addJumpIfR0NotEquals(OsConstants.ETH_P_IP, skipIPv4FiltersLabel);
        this.generateIPv4FilterLocked(gen);
        gen.defineLabel(skipIPv4FiltersLabel);
        String ipv6FilterLabel = "IPv6Filters";
        gen.addJumpIfR0Equals(OsConstants.ETH_P_IPV6, ipv6FilterLabel);
        gen.addLoadImmediate(ApfGenerator.Register.R0, 0);
        this.maybeSetCounter(gen, Counter.PASSED_NON_IP_UNICAST);
        gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, ETH_BROADCAST_MAC_ADDRESS, this.mCountAndPassLabel);
        this.maybeSetCounter(gen, Counter.DROPPED_ETH_BROADCAST);
        gen.addJump(this.mCountAndDropLabel);
        gen.defineLabel(ipv6FilterLabel);
        this.generateIPv6FilterLocked(gen);
        return gen;
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$emitEpilogue(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
        if (!this.mApfCapabilities.hasDataAccess()) {
            return;
        }
        this.maybeSetCounter(gen, Counter.PASSED_IPV6_ICMP);
        gen.defineLabel(this.mCountAndPassLabel);
        gen.addLoadData(ApfGenerator.Register.R0, 0);
        gen.addAdd(1);
        gen.addStoreData(ApfGenerator.Register.R0, 0);
        gen.addJump("__PASS__");
        gen.defineLabel(this.mCountAndDropLabel);
        gen.addLoadData(ApfGenerator.Register.R0, 0);
        gen.addAdd(1);
        gen.addStoreData(ApfGenerator.Register.R0, 0);
        gen.addJump("__DROP__");
    }

    @GuardedBy(value="this")
    @VisibleForTesting
    private final void $$robo$$android_net_apf_ApfFilter$installNewProgramLocked() {
        long now;
        byte[] program;
        this.purgeExpiredRasLocked();
        ArrayList<Ra> rasToFilter = new ArrayList<Ra>();
        long programMinLifetime = Long.MAX_VALUE;
        long maximumApfProgramSize = this.mApfCapabilities.maximumApfProgramSize;
        if (this.mApfCapabilities.hasDataAccess()) {
            maximumApfProgramSize -= (long)Counter.totalSize();
        }
        try {
            ApfGenerator gen = this.emitPrologueLocked();
            this.emitEpilogue(gen);
            if ((long)gen.programLengthOverEstimate() > maximumApfProgramSize) {
                Log.e("ApfFilter", "Program exceeds maximum size " + maximumApfProgramSize);
                return;
            }
            for (Ra ra : this.mRas) {
                ra.generateFilterLocked(gen);
                if ((long)gen.programLengthOverEstimate() > maximumApfProgramSize) break;
                rasToFilter.add(ra);
            }
            gen = this.emitPrologueLocked();
            for (Ra ra : rasToFilter) {
                programMinLifetime = Math.min(programMinLifetime, ra.generateFilterLocked(gen));
            }
            this.emitEpilogue(gen);
            program = gen.generate();
        }
        catch (ApfGenerator.IllegalInstructionException | IllegalStateException e) {
            Log.e("ApfFilter", "Failed to generate APF program.", e);
            return;
        }
        this.mLastTimeInstalledProgram = now = this.currentTimeSeconds();
        this.mLastInstalledProgramMinLifetime = programMinLifetime;
        this.mLastInstalledProgram = program;
        ++this.mNumProgramUpdates;
        this.mIpClientCallback.installPacketFilter(program);
        this.logApfProgramEventLocked(now);
        this.mLastInstallEvent = new ApfProgramEvent();
        this.mLastInstallEvent.lifetime = programMinLifetime;
        this.mLastInstallEvent.filteredRas = rasToFilter.size();
        this.mLastInstallEvent.currentRas = this.mRas.size();
        this.mLastInstallEvent.programLength = program.length;
        this.mLastInstallEvent.flags = ApfProgramEvent.flagsFor(this.mIPv4Address != null, this.mMulticastFilter);
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$logApfProgramEventLocked(long now) {
        if (this.mLastInstallEvent == null) {
            return;
        }
        ApfProgramEvent ev = this.mLastInstallEvent;
        this.mLastInstallEvent = null;
        ev.actualLifetime = now - this.mLastTimeInstalledProgram;
        if (ev.actualLifetime < 2L) {
            return;
        }
        this.mMetricsLog.log(ev);
    }

    private final boolean $$robo$$android_net_apf_ApfFilter$shouldInstallnewProgram() {
        long expiry = this.mLastTimeInstalledProgram + this.mLastInstalledProgramMinLifetime;
        return expiry < this.currentTimeSeconds() + 30L;
    }

    private final void $$robo$$android_net_apf_ApfFilter$hexDump(String msg, byte[] packet, int length) {
        this.log(msg + HexDump.toHexString(packet, 0, length, false));
    }

    @GuardedBy(value="this")
    private final void $$robo$$android_net_apf_ApfFilter$purgeExpiredRasLocked() {
        int i = 0;
        while (i < this.mRas.size()) {
            if (this.mRas.get(i).isExpired()) {
                this.log("Expiring " + this.mRas.get(i));
                this.mRas.remove(i);
                continue;
            }
            ++i;
        }
    }

    @VisibleForTesting
    private final synchronized ProcessRaResult $$robo$$android_net_apf_ApfFilter$processRa(byte[] packet, int length) {
        Ra ra;
        for (int i = 0; i < this.mRas.size(); ++i) {
            Ra ra2 = this.mRas.get(i);
            if (!ra2.matches(packet, length)) continue;
            ra2.mLastSeen = this.currentTimeSeconds();
            ra2.mMinLifetime = ra2.minLifetime(packet, length);
            ++ra2.seenCount;
            this.mRas.add(0, this.mRas.remove(i));
            if (this.shouldInstallnewProgram()) {
                this.installNewProgramLocked();
                return ProcessRaResult.UPDATE_EXPIRY;
            }
            return ProcessRaResult.MATCH;
        }
        this.purgeExpiredRasLocked();
        if (this.mRas.size() >= 10) {
            return ProcessRaResult.DROPPED;
        }
        try {
            ra = new Ra(this, packet, length);
        }
        catch (Exception e) {
            Log.e("ApfFilter", "Error parsing RA", e);
            return ProcessRaResult.PARSE_ERROR;
        }
        if (ra.isExpired()) {
            return ProcessRaResult.ZERO_LIFETIME;
        }
        this.log("Adding " + ra);
        this.mRas.add(ra);
        this.installNewProgramLocked();
        return ProcessRaResult.UPDATE_NEW_RA;
    }

    private static final ApfFilter $$robo$$android_net_apf_ApfFilter$maybeCreate(Context context, ApfConfiguration config, InterfaceParams ifParams, IpClient.Callback ipClientCallback) {
        if (context == null || config == null || ifParams == null) {
            return null;
        }
        ApfCapabilities apfCapabilities = config.apfCapabilities;
        if (apfCapabilities == null) {
            return null;
        }
        if (apfCapabilities.apfVersionSupported == 0) {
            return null;
        }
        if (apfCapabilities.maximumApfProgramSize < 512) {
            Log.e("ApfFilter", "Unacceptably small APF limit: " + apfCapabilities.maximumApfProgramSize);
            return null;
        }
        if (apfCapabilities.apfPacketFormat != OsConstants.ARPHRD_ETHER) {
            return null;
        }
        if (!ApfGenerator.supportsVersion(apfCapabilities.apfVersionSupported)) {
            Log.e("ApfFilter", "Unsupported APF version: " + apfCapabilities.apfVersionSupported);
            return null;
        }
        return new ApfFilter(context, config, ifParams, ipClientCallback, new IpConnectivityLog());
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$shutdown() {
        if (this.mReceiveThread != null) {
            this.log("shutting down");
            this.mReceiveThread.halt();
            this.mReceiveThread = null;
        }
        this.mRas.clear();
        this.mContext.unregisterReceiver(this.mDeviceIdleReceiver);
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$setMulticastFilter(boolean isEnabled) {
        if (this.mMulticastFilter == isEnabled) {
            return;
        }
        this.mMulticastFilter = isEnabled;
        if (!isEnabled) {
            ++this.mNumProgramUpdatesAllowingMulticast;
        }
        this.installNewProgramLocked();
    }

    @VisibleForTesting
    private final synchronized void $$robo$$android_net_apf_ApfFilter$setDozeMode(boolean isEnabled) {
        if (this.mInDozeMode == isEnabled) {
            return;
        }
        this.mInDozeMode = isEnabled;
        this.installNewProgramLocked();
    }

    private static final LinkAddress $$robo$$android_net_apf_ApfFilter$findIPv4LinkAddress(LinkProperties lp) {
        LinkAddress ipv4Address = null;
        for (LinkAddress address : lp.getLinkAddresses()) {
            if (!(address.getAddress() instanceof Inet4Address)) continue;
            if (ipv4Address != null && !ipv4Address.isSameAddressAs(address)) {
                return null;
            }
            ipv4Address = address;
        }
        return ipv4Address;
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$setLinkProperties(LinkProperties lp) {
        int prefix;
        LinkAddress ipv4Address = ApfFilter.findIPv4LinkAddress(lp);
        byte[] addr = ipv4Address != null ? ipv4Address.getAddress().getAddress() : null;
        int n = prefix = ipv4Address != null ? ipv4Address.getPrefixLength() : 0;
        if (prefix == this.mIPv4PrefixLength && Arrays.equals(addr, this.mIPv4Address)) {
            return;
        }
        this.mIPv4Address = addr;
        this.mIPv4PrefixLength = prefix;
        this.installNewProgramLocked();
    }

    private static final long $$robo$$android_net_apf_ApfFilter$counterValue(byte[] data, Counter counter) throws ArrayIndexOutOfBoundsException {
        int offset = counter.offset();
        if (offset < 0) {
            offset = data.length + offset;
        }
        long value = 0L;
        for (int i = 0; i < 4; ++i) {
            value = value << 8 | (long)(data[offset] & 0xFF);
            ++offset;
        }
        return value;
    }

    private final synchronized void $$robo$$android_net_apf_ApfFilter$dump(IndentingPrintWriter pw) {
        pw.println("Capabilities: " + this.mApfCapabilities);
        pw.println("Receive thread: " + (this.mReceiveThread != null ? "RUNNING" : "STOPPED"));
        pw.println("Multicast: " + (this.mMulticastFilter ? "DROP" : "ALLOW"));
        try {
            pw.println("IPv4 address: " + InetAddress.getByAddress(this.mIPv4Address).getHostAddress());
        }
        catch (NullPointerException | UnknownHostException exception) {
            // empty catch block
        }
        if (this.mLastTimeInstalledProgram == 0L) {
            pw.println("No program installed.");
            return;
        }
        pw.println("Program updates: " + this.mNumProgramUpdates);
        pw.println(String.format("Last program length %d, installed %ds ago, lifetime %ds", this.mLastInstalledProgram.length, this.currentTimeSeconds() - this.mLastTimeInstalledProgram, this.mLastInstalledProgramMinLifetime));
        pw.println("RA filters:");
        pw.increaseIndent();
        for (Ra ra : this.mRas) {
            pw.println(ra);
            pw.increaseIndent();
            pw.println(String.format("Seen: %d, last %ds ago", ra.seenCount, this.currentTimeSeconds() - ra.mLastSeen));
            pw.println("Last match:");
            pw.increaseIndent();
            pw.println(ra.getLastMatchingPacket());
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println("Last program:");
        pw.increaseIndent();
        pw.println(HexDump.toHexString(this.mLastInstalledProgram, false));
        pw.decreaseIndent();
        pw.println("APF packet counters: ");
        pw.increaseIndent();
        if (!this.mApfCapabilities.hasDataAccess()) {
            pw.println("APF counters not supported");
        } else if (this.mDataSnapshot == null) {
            pw.println("No last snapshot.");
        } else {
            try {
                Counter[] counters = (Counter[])Counter.class.getEnumConstants();
                for (Counter c : Arrays.asList(counters).subList(1, counters.length)) {
                    long value = ApfFilter.counterValue(this.mDataSnapshot, c);
                    if (value == 0L) continue;
                    pw.println(c.toString() + ": " + value);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                pw.println("Uh-oh: " + e);
            }
        }
        pw.decreaseIndent();
    }

    @VisibleForTesting
    private static final int $$robo$$android_net_apf_ApfFilter$ipv4BroadcastAddress(byte[] addrBytes, int prefixLength) {
        return BitUtils.bytesToBEInt(addrBytes) | (int)(BitUtils.uint32(-1) >>> prefixLength);
    }

    static void __staticInitializer__() {
        ETH_BROADCAST_MAC_ADDRESS = new byte[]{-1, -1, -1, -1, -1, -1};
        IPV6_ALL_NODES_ADDRESS = new byte[]{-1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        ARP_IPV4_HEADER = new byte[]{0, 1, 8, 0, 6, 4};
    }

    private void maybeSetCounter(ApfGenerator apfGenerator, Counter counter) {
        InvokeDynamicSupport.bootstrap("maybeSetCounter", $$robo$$android_net_apf_ApfFilter$maybeSetCounter(android.net.apf.ApfGenerator android.net.apf.ApfFilter$Counter ), 0, this, apfGenerator, counter);
    }

    private void __constructor__(Context context, ApfConfiguration apfConfiguration, InterfaceParams interfaceParams, IpClient.Callback callback, IpConnectivityLog ipConnectivityLog) {
        this.$$robo$$android_net_apf_ApfFilter$__constructor__(context, apfConfiguration, interfaceParams, callback, ipConnectivityLog);
    }

    ApfFilter(Context context, ApfConfiguration apfConfiguration, InterfaceParams interfaceParams, IpClient.Callback callback, IpConnectivityLog ipConnectivityLog) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter$__constructor__(android.content.Context android.net.apf.ApfFilter$ApfConfiguration android.net.util.InterfaceParams android.net.ip.IpClient$Callback android.net.metrics.IpConnectivityLog ), 0, this, context, apfConfiguration, interfaceParams, callback, ipConnectivityLog);
    }

    public synchronized void setDataSnapshot(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setDataSnapshot", $$robo$$android_net_apf_ApfFilter$setDataSnapshot(byte[] ), 0, this, byArray);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_net_apf_ApfFilter$log(java.lang.String ), 0, this, string2);
    }

    private long getUniqueNumberLocked() {
        return (long)InvokeDynamicSupport.bootstrap("getUniqueNumberLocked", $$robo$$android_net_apf_ApfFilter$getUniqueNumberLocked(), 0, this);
    }

    private static int[] filterEthTypeBlackList(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("filterEthTypeBlackList", $$robo$$android_net_apf_ApfFilter$filterEthTypeBlackList(int[] ), 0, (int[])nArray);
    }

    void maybeStartFilter() {
        InvokeDynamicSupport.bootstrap("maybeStartFilter", $$robo$$android_net_apf_ApfFilter$maybeStartFilter(), 0, this);
    }

    protected long currentTimeSeconds() {
        return (long)InvokeDynamicSupport.bootstrap("currentTimeSeconds", $$robo$$android_net_apf_ApfFilter$currentTimeSeconds(), 0, this);
    }

    private void generateArpFilterLocked(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
        InvokeDynamicSupport.bootstrap("generateArpFilterLocked", $$robo$$android_net_apf_ApfFilter$generateArpFilterLocked(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
    }

    private void generateIPv4FilterLocked(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
        InvokeDynamicSupport.bootstrap("generateIPv4FilterLocked", $$robo$$android_net_apf_ApfFilter$generateIPv4FilterLocked(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
    }

    private void generateIPv6FilterLocked(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
        InvokeDynamicSupport.bootstrap("generateIPv6FilterLocked", $$robo$$android_net_apf_ApfFilter$generateIPv6FilterLocked(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
    }

    private ApfGenerator emitPrologueLocked() throws ApfGenerator.IllegalInstructionException {
        return InvokeDynamicSupport.bootstrap("emitPrologueLocked", $$robo$$android_net_apf_ApfFilter$emitPrologueLocked(), 0, this);
    }

    private void emitEpilogue(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
        InvokeDynamicSupport.bootstrap("emitEpilogue", $$robo$$android_net_apf_ApfFilter$emitEpilogue(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
    }

    void installNewProgramLocked() {
        InvokeDynamicSupport.bootstrap("installNewProgramLocked", $$robo$$android_net_apf_ApfFilter$installNewProgramLocked(), 0, this);
    }

    private void logApfProgramEventLocked(long l) {
        InvokeDynamicSupport.bootstrap("logApfProgramEventLocked", $$robo$$android_net_apf_ApfFilter$logApfProgramEventLocked(long ), 0, this, l);
    }

    private boolean shouldInstallnewProgram() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldInstallnewProgram", $$robo$$android_net_apf_ApfFilter$shouldInstallnewProgram(), 0, this);
    }

    private void hexDump(String string2, byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("hexDump", $$robo$$android_net_apf_ApfFilter$hexDump(java.lang.String byte[] int ), 0, this, string2, byArray, n);
    }

    private void purgeExpiredRasLocked() {
        InvokeDynamicSupport.bootstrap("purgeExpiredRasLocked", $$robo$$android_net_apf_ApfFilter$purgeExpiredRasLocked(), 0, this);
    }

    synchronized ProcessRaResult processRa(byte[] byArray, int n) {
        return InvokeDynamicSupport.bootstrap("processRa", $$robo$$android_net_apf_ApfFilter$processRa(byte[] int ), 0, this, byArray, n);
    }

    public static ApfFilter maybeCreate(Context context, ApfConfiguration apfConfiguration, InterfaceParams interfaceParams, IpClient.Callback callback) {
        return InvokeDynamicSupport.bootstrapStatic("maybeCreate", $$robo$$android_net_apf_ApfFilter$maybeCreate(android.content.Context android.net.apf.ApfFilter$ApfConfiguration android.net.util.InterfaceParams android.net.ip.IpClient$Callback ), 0, (Context)context, (ApfConfiguration)apfConfiguration, (InterfaceParams)interfaceParams, (IpClient.Callback)callback);
    }

    public synchronized void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_net_apf_ApfFilter$shutdown(), 0, this);
    }

    public synchronized void setMulticastFilter(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMulticastFilter", $$robo$$android_net_apf_ApfFilter$setMulticastFilter(boolean ), 0, this, bl);
    }

    public synchronized void setDozeMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDozeMode", $$robo$$android_net_apf_ApfFilter$setDozeMode(boolean ), 0, this, bl);
    }

    private static LinkAddress findIPv4LinkAddress(LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrapStatic("findIPv4LinkAddress", $$robo$$android_net_apf_ApfFilter$findIPv4LinkAddress(android.net.LinkProperties ), 0, (LinkProperties)linkProperties);
    }

    public synchronized void setLinkProperties(LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("setLinkProperties", $$robo$$android_net_apf_ApfFilter$setLinkProperties(android.net.LinkProperties ), 0, this, linkProperties);
    }

    public static long counterValue(byte[] byArray, Counter counter) throws ArrayIndexOutOfBoundsException {
        return (long)InvokeDynamicSupport.bootstrapStatic("counterValue", $$robo$$android_net_apf_ApfFilter$counterValue(byte[] android.net.apf.ApfFilter$Counter ), 0, (byte[])byArray, (Counter)counter);
    }

    public synchronized void dump(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_apf_ApfFilter$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
    }

    public static int ipv4BroadcastAddress(byte[] byArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("ipv4BroadcastAddress", $$robo$$android_net_apf_ApfFilter$ipv4BroadcastAddress(byte[] int ), 0, (byte[])byArray, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(ApfFilter.class);
    }

    public /* synthetic */ ApfFilter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApfFilter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @VisibleForTesting
    public class Ra
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int ICMP6_RA_HEADER_LEN = 16;
        private static int ICMP6_RA_CHECKSUM_OFFSET = 56;
        private static int ICMP6_RA_CHECKSUM_LEN = 2;
        private static int ICMP6_RA_OPTION_OFFSET = 70;
        private static int ICMP6_RA_ROUTER_LIFETIME_OFFSET = 60;
        private static int ICMP6_RA_ROUTER_LIFETIME_LEN = 2;
        private static int ICMP6_PREFIX_OPTION_TYPE = 3;
        private static int ICMP6_PREFIX_OPTION_LEN = 32;
        private static int ICMP6_PREFIX_OPTION_VALID_LIFETIME_OFFSET = 4;
        private static int ICMP6_PREFIX_OPTION_VALID_LIFETIME_LEN = 4;
        private static int ICMP6_PREFIX_OPTION_PREFERRED_LIFETIME_OFFSET = 8;
        private static int ICMP6_PREFIX_OPTION_PREFERRED_LIFETIME_LEN = 4;
        private static int ICMP6_RDNSS_OPTION_TYPE = 25;
        private static int ICMP6_DNSSL_OPTION_TYPE = 31;
        private static int ICMP6_ROUTE_INFO_OPTION_TYPE = 24;
        private static int ICMP6_4_BYTE_LIFETIME_OFFSET = 4;
        private static int ICMP6_4_BYTE_LIFETIME_LEN = 4;
        private ByteBuffer mPacket;
        private ArrayList<Pair<Integer, Integer>> mNonLifetimes;
        long mMinLifetime;
        long mLastSeen;
        private ArrayList<Integer> mPrefixOptionOffsets;
        private ArrayList<Integer> mRdnssOptionOffsets;
        int seenCount;
        /* synthetic */ ApfFilter this$0;

        private final String $$robo$$android_net_apf_ApfFilter_Ra$getLastMatchingPacket() {
            return HexDump.toHexString(this.mPacket.array(), 0, this.mPacket.capacity(), false);
        }

        private final String $$robo$$android_net_apf_ApfFilter_Ra$IPv6AddresstoString(int pos) {
            try {
                byte[] array2 = this.mPacket.array();
                if (pos < 0 || pos + 16 > array2.length || pos + 16 < pos) {
                    return "???";
                }
                byte[] addressBytes = Arrays.copyOfRange(array2, pos, pos + 16);
                Inet6Address address = (Inet6Address)InetAddress.getByAddress(addressBytes);
                return ((InetAddress)address).getHostAddress();
            }
            catch (UnsupportedOperationException e) {
                return "???";
            }
            catch (ClassCastException | UnknownHostException e) {
                return "???";
            }
        }

        private final void $$robo$$android_net_apf_ApfFilter_Ra$prefixOptionToString(StringBuffer sb, int offset) {
            String prefix = this.IPv6AddresstoString(offset + 16);
            int length = BitUtils.getUint8(this.mPacket, offset + 2);
            long valid = BitUtils.getUint32(this.mPacket, offset + 4);
            long preferred = BitUtils.getUint32(this.mPacket, offset + 8);
            sb.append(String.format("%s/%d %ds/%ds ", prefix, length, valid, preferred));
        }

        private final void $$robo$$android_net_apf_ApfFilter_Ra$rdnssOptionToString(StringBuffer sb, int offset) {
            int optLen = BitUtils.getUint8(this.mPacket, offset + 1) * 8;
            if (optLen < 24) {
                return;
            }
            long lifetime = BitUtils.getUint32(this.mPacket, offset + 4);
            int numServers = (optLen - 8) / 16;
            sb.append("DNS ").append(lifetime).append("s");
            for (int server = 0; server < numServers; ++server) {
                sb.append(" ").append(this.IPv6AddresstoString(offset + 8 + 16 * server));
            }
        }

        private final String $$robo$$android_net_apf_ApfFilter_Ra$toString() {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append(String.format("RA %s -> %s %ds ", this.IPv6AddresstoString(22), this.IPv6AddresstoString(38), BitUtils.getUint16(this.mPacket, 60)));
                for (int i : this.mPrefixOptionOffsets) {
                    this.prefixOptionToString(sb, i);
                }
                for (int i : this.mRdnssOptionOffsets) {
                    this.rdnssOptionToString(sb, i);
                }
                return sb.toString();
            }
            catch (IndexOutOfBoundsException | BufferUnderflowException e) {
                return "<Malformed RA>";
            }
        }

        private final int $$robo$$android_net_apf_ApfFilter_Ra$addNonLifetime(int lastNonLifetimeStart, int lifetimeOffset, int lifetimeLength) {
            this.mNonLifetimes.add(new Pair<Integer, Integer>(lastNonLifetimeStart, (lifetimeOffset += this.mPacket.position()) - lastNonLifetimeStart));
            return lifetimeOffset + lifetimeLength;
        }

        private final int $$robo$$android_net_apf_ApfFilter_Ra$addNonLifetimeU32(int lastNonLifetimeStart) {
            return this.addNonLifetime(lastNonLifetimeStart, 4, 4);
        }

        private void $$robo$$android_net_apf_ApfFilter_Ra$__constructor__(ApfFilter this$0, byte[] packet, int length) throws InvalidRaException {
            this.mNonLifetimes = new ArrayList();
            this.mPrefixOptionOffsets = new ArrayList();
            this.mRdnssOptionOffsets = new ArrayList();
            this.seenCount = 0;
            if (length < 70) {
                throw new InvalidRaException("Not an ICMP6 router advertisement");
            }
            this.mPacket = ByteBuffer.wrap(Arrays.copyOf(packet, length));
            this.mLastSeen = this$0.currentTimeSeconds();
            if (BitUtils.getUint16(this.mPacket, 12) != OsConstants.ETH_P_IPV6 || BitUtils.getUint8(this.mPacket, 20) != OsConstants.IPPROTO_ICMPV6 || BitUtils.getUint8(this.mPacket, 54) != 134) {
                throw new InvalidRaException("Not an ICMP6 router advertisement");
            }
            RaEvent.Builder builder = new RaEvent.Builder();
            int lastNonLifetimeStart = this.addNonLifetime(0, 15, 3);
            lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 56, 2);
            lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 60, 2);
            builder.updateRouterLifetime(BitUtils.getUint16(this.mPacket, 60));
            this.mPacket.position(70);
            while (this.mPacket.hasRemaining()) {
                int position = this.mPacket.position();
                int optionType = BitUtils.getUint8(this.mPacket, position);
                int optionLength = BitUtils.getUint8(this.mPacket, position + 1) * 8;
                switch (optionType) {
                    case 3: {
                        lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 4, 4);
                        long lifetime = BitUtils.getUint32(this.mPacket, position + 4);
                        builder.updatePrefixValidLifetime(lifetime);
                        lastNonLifetimeStart = this.addNonLifetime(lastNonLifetimeStart, 8, 4);
                        lifetime = BitUtils.getUint32(this.mPacket, position + 8);
                        builder.updatePrefixPreferredLifetime(lifetime);
                        this.mPrefixOptionOffsets.add(position);
                        break;
                    }
                    case 25: {
                        this.mRdnssOptionOffsets.add(position);
                        lastNonLifetimeStart = this.addNonLifetimeU32(lastNonLifetimeStart);
                        long lifetime = BitUtils.getUint32(this.mPacket, position + 4);
                        builder.updateRdnssLifetime(lifetime);
                        break;
                    }
                    case 24: {
                        lastNonLifetimeStart = this.addNonLifetimeU32(lastNonLifetimeStart);
                        long lifetime = BitUtils.getUint32(this.mPacket, position + 4);
                        builder.updateRouteInfoLifetime(lifetime);
                        break;
                    }
                    case 31: {
                        lastNonLifetimeStart = this.addNonLifetimeU32(lastNonLifetimeStart);
                        long lifetime = BitUtils.getUint32(this.mPacket, position + 4);
                        builder.updateDnsslLifetime(lifetime);
                        break;
                    }
                }
                if (optionLength <= 0) {
                    throw new InvalidRaException(String.format("Invalid option length opt=%d len=%d", optionType, optionLength));
                }
                this.mPacket.position(position + optionLength);
            }
            this.addNonLifetime(lastNonLifetimeStart, 0, 0);
            this.mMinLifetime = this.minLifetime(packet, length);
            this$0.mMetricsLog.log(builder.build());
        }

        private final boolean $$robo$$android_net_apf_ApfFilter_Ra$matches(byte[] packet, int length) {
            if (length != this.mPacket.capacity()) {
                return false;
            }
            byte[] referencePacket = this.mPacket.array();
            for (Pair<Integer, Integer> nonLifetime : this.mNonLifetimes) {
                for (int i = ((Integer)nonLifetime.first).intValue(); i < (Integer)nonLifetime.first + (Integer)nonLifetime.second; ++i) {
                    if (packet[i] == referencePacket[i]) continue;
                    return false;
                }
            }
            return true;
        }

        private final long $$robo$$android_net_apf_ApfFilter_Ra$minLifetime(byte[] packet, int length) {
            long minLifetime = Long.MAX_VALUE;
            ByteBuffer byteBuffer = ByteBuffer.wrap(packet);
            int i = 0;
            while (i + 1 < this.mNonLifetimes.size()) {
                int offset = (Integer)this.mNonLifetimes.get((int)i).first + (Integer)this.mNonLifetimes.get((int)i).second;
                if (offset != 15 && offset != 56) {
                    long optionLifetime;
                    int lifetimeLength = (Integer)this.mNonLifetimes.get((int)(i + 1)).first - offset;
                    switch (lifetimeLength) {
                        case 2: {
                            optionLifetime = BitUtils.getUint16(byteBuffer, offset);
                            break;
                        }
                        case 4: {
                            optionLifetime = BitUtils.getUint32(byteBuffer, offset);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("bogus lifetime size " + lifetimeLength);
                        }
                    }
                    minLifetime = Math.min(minLifetime, optionLifetime);
                }
                ++i;
            }
            return minLifetime;
        }

        private final long $$robo$$android_net_apf_ApfFilter_Ra$currentLifetime() {
            return this.mMinLifetime - (this.this$0.currentTimeSeconds() - this.mLastSeen);
        }

        private final boolean $$robo$$android_net_apf_ApfFilter_Ra$isExpired() {
            return this.currentLifetime() <= 0L;
        }

        @GuardedBy(value="ApfFilter.this")
        private final long $$robo$$android_net_apf_ApfFilter_Ra$generateFilterLocked(ApfGenerator gen) throws ApfGenerator.IllegalInstructionException {
            String nextFilterLabel = "Ra" + this.this$0.getUniqueNumberLocked();
            gen.addLoadFromMemory(ApfGenerator.Register.R0, 14);
            gen.addJumpIfR0NotEquals(this.mPacket.capacity(), nextFilterLabel);
            int filterLifetime = (int)(this.currentLifetime() / 6L);
            gen.addLoadFromMemory(ApfGenerator.Register.R0, 15);
            gen.addJumpIfR0GreaterThan(filterLifetime, nextFilterLabel);
            for (int i = 0; i < this.mNonLifetimes.size(); ++i) {
                Pair<Integer, Integer> nonLifetime = this.mNonLifetimes.get(i);
                if ((Integer)nonLifetime.second != 0) {
                    gen.addLoadImmediate(ApfGenerator.Register.R0, (Integer)nonLifetime.first);
                    gen.addJumpIfBytesNotEqual(ApfGenerator.Register.R0, Arrays.copyOfRange(this.mPacket.array(), (int)((Integer)nonLifetime.first), (Integer)nonLifetime.first + (Integer)nonLifetime.second), nextFilterLabel);
                }
                if (i + 1 >= this.mNonLifetimes.size()) continue;
                Pair<Integer, Integer> nextNonLifetime = this.mNonLifetimes.get(i + 1);
                int offset = (Integer)nonLifetime.first + (Integer)nonLifetime.second;
                if (offset == 15 || offset == 56) continue;
                int length = (Integer)nextNonLifetime.first - offset;
                switch (length) {
                    case 4: {
                        gen.addLoad32(ApfGenerator.Register.R0, offset);
                        break;
                    }
                    case 2: {
                        gen.addLoad16(ApfGenerator.Register.R0, offset);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("bogus lifetime size " + length);
                    }
                }
                gen.addJumpIfR0LessThan(filterLifetime, nextFilterLabel);
            }
            this.this$0.maybeSetCounter(gen, Counter.DROPPED_RA);
            gen.addJump(this.this$0.mCountAndDropLabel);
            gen.defineLabel(nextFilterLabel);
            return filterLifetime;
        }

        String getLastMatchingPacket() {
            return InvokeDynamicSupport.bootstrap("getLastMatchingPacket", $$robo$$android_net_apf_ApfFilter_Ra$getLastMatchingPacket(), 0, this);
        }

        private String IPv6AddresstoString(int n) {
            return InvokeDynamicSupport.bootstrap("IPv6AddresstoString", $$robo$$android_net_apf_ApfFilter_Ra$IPv6AddresstoString(int ), 0, this, n);
        }

        private void prefixOptionToString(StringBuffer stringBuffer, int n) {
            InvokeDynamicSupport.bootstrap("prefixOptionToString", $$robo$$android_net_apf_ApfFilter_Ra$prefixOptionToString(java.lang.StringBuffer int ), 0, this, stringBuffer, n);
        }

        private void rdnssOptionToString(StringBuffer stringBuffer, int n) {
            InvokeDynamicSupport.bootstrap("rdnssOptionToString", $$robo$$android_net_apf_ApfFilter_Ra$rdnssOptionToString(java.lang.StringBuffer int ), 0, this, stringBuffer, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_apf_ApfFilter_Ra$toString(), 0, this);
        }

        private int addNonLifetime(int n, int n2, int n3) {
            return (int)InvokeDynamicSupport.bootstrap("addNonLifetime", $$robo$$android_net_apf_ApfFilter_Ra$addNonLifetime(int int int ), 0, this, n, n2, n3);
        }

        private int addNonLifetimeU32(int n) {
            return (int)InvokeDynamicSupport.bootstrap("addNonLifetimeU32", $$robo$$android_net_apf_ApfFilter_Ra$addNonLifetimeU32(int ), 0, this, n);
        }

        private void __constructor__(ApfFilter apfFilter, byte[] byArray, int n) throws InvalidRaException {
            this.$$robo$$android_net_apf_ApfFilter_Ra$__constructor__(apfFilter, byArray, n);
        }

        Ra(ApfFilter apfFilter, byte[] byArray, int n) throws InvalidRaException {
            this.this$0 = apfFilter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_Ra$__constructor__(android.net.apf.ApfFilter byte[] int ), 0, this, apfFilter, byArray, n);
        }

        boolean matches(byte[] byArray, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_net_apf_ApfFilter_Ra$matches(byte[] int ), 0, this, byArray, n);
        }

        long minLifetime(byte[] byArray, int n) {
            return (long)InvokeDynamicSupport.bootstrap("minLifetime", $$robo$$android_net_apf_ApfFilter_Ra$minLifetime(byte[] int ), 0, this, byArray, n);
        }

        long currentLifetime() {
            return (long)InvokeDynamicSupport.bootstrap("currentLifetime", $$robo$$android_net_apf_ApfFilter_Ra$currentLifetime(), 0, this);
        }

        boolean isExpired() {
            return (boolean)InvokeDynamicSupport.bootstrap("isExpired", $$robo$$android_net_apf_ApfFilter_Ra$isExpired(), 0, this);
        }

        long generateFilterLocked(ApfGenerator apfGenerator) throws ApfGenerator.IllegalInstructionException {
            return (long)InvokeDynamicSupport.bootstrap("generateFilterLocked", $$robo$$android_net_apf_ApfFilter_Ra$generateFilterLocked(android.net.apf.ApfGenerator ), 0, this, apfGenerator);
        }

        public /* synthetic */ Ra() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ra)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class InvalidRaException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_apf_ApfFilter_InvalidRaException$__constructor__(String m) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_net_apf_ApfFilter_InvalidRaException$__constructor__(string2);
        }

        public InvalidRaException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_InvalidRaException$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ InvalidRaException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InvalidRaException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @VisibleForTesting
    public class ReceiveThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mPacket;
        private FileDescriptor mSocket;
        private long mStart;
        private ApfStats mStats;
        private volatile boolean mStopped;
        /* synthetic */ ApfFilter this$0;

        private void $$robo$$android_net_apf_ApfFilter_ReceiveThread$__constructor__(ApfFilter this$0, FileDescriptor socket) {
            this.mPacket = new byte[1514];
            this.mStart = SystemClock.elapsedRealtime();
            this.mStats = new ApfStats();
            this.mSocket = socket;
        }

        private final void $$robo$$android_net_apf_ApfFilter_ReceiveThread$halt() {
            this.mStopped = true;
            try {
                IoBridge.closeAndSignalBlockedThreads(this.mSocket);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private final void $$robo$$android_net_apf_ApfFilter_ReceiveThread$run() {
            this.this$0.log("begin monitoring");
            while (!this.mStopped) {
                try {
                    int length = Os.read(this.mSocket, this.mPacket, 0, this.mPacket.length);
                    this.updateStats(this.this$0.processRa(this.mPacket, length));
                }
                catch (ErrnoException | IOException e) {
                    if (this.mStopped) continue;
                    Log.e("ApfFilter", "Read error", e);
                }
            }
            this.logStats();
        }

        private final void $$robo$$android_net_apf_ApfFilter_ReceiveThread$updateStats(ProcessRaResult result) {
            ++this.mStats.receivedRas;
            switch (2.$SwitchMap$android$net$apf$ApfFilter$ProcessRaResult[result.ordinal()]) {
                case 1: {
                    ++this.mStats.matchingRas;
                    return;
                }
                case 2: {
                    ++this.mStats.droppedRas;
                    return;
                }
                case 3: {
                    ++this.mStats.parseErrors;
                    return;
                }
                case 4: {
                    ++this.mStats.zeroLifetimeRas;
                    return;
                }
                case 5: {
                    ++this.mStats.matchingRas;
                    ++this.mStats.programUpdates;
                    return;
                }
                case 6: {
                    ++this.mStats.programUpdates;
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_apf_ApfFilter_ReceiveThread$logStats() {
            long nowMs = SystemClock.elapsedRealtime();
            ReceiveThread receiveThread = this;
            synchronized (receiveThread) {
                this.mStats.durationMs = nowMs - this.mStart;
                this.mStats.maxProgramSize = ((ApfFilter)this.this$0).mApfCapabilities.maximumApfProgramSize;
                this.mStats.programUpdatesAll = this.this$0.mNumProgramUpdates;
                this.mStats.programUpdatesAllowingMulticast = this.this$0.mNumProgramUpdatesAllowingMulticast;
                this.this$0.mMetricsLog.log(this.mStats);
                this.this$0.logApfProgramEventLocked(nowMs / 1000L);
            }
        }

        private void __constructor__(ApfFilter apfFilter, FileDescriptor fileDescriptor) {
            this.$$robo$$android_net_apf_ApfFilter_ReceiveThread$__constructor__(apfFilter, fileDescriptor);
        }

        public ReceiveThread(ApfFilter apfFilter, FileDescriptor fileDescriptor) {
            this.this$0 = apfFilter;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_ReceiveThread$__constructor__(android.net.apf.ApfFilter java.io.FileDescriptor ), 0, this, apfFilter, fileDescriptor);
        }

        public void halt() {
            InvokeDynamicSupport.bootstrap("halt", $$robo$$android_net_apf_ApfFilter_ReceiveThread$halt(), 0, this);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_net_apf_ApfFilter_ReceiveThread$run(), 0, this);
        }

        private void updateStats(ProcessRaResult processRaResult) {
            InvokeDynamicSupport.bootstrap("updateStats", $$robo$$android_net_apf_ApfFilter_ReceiveThread$updateStats(android.net.apf.ApfFilter$ProcessRaResult ), 0, this, processRaResult);
        }

        private void logStats() {
            InvokeDynamicSupport.bootstrap("logStats", $$robo$$android_net_apf_ApfFilter_ReceiveThread$logStats(), 0, this);
        }

        public /* synthetic */ ReceiveThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReceiveThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    @VisibleForTesting
    private static final class Counter
    extends Enum<Counter> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Counter RESERVED_OOB;
        public static /* enum */ Counter TOTAL_PACKETS;
        public static /* enum */ Counter PASSED_ARP;
        public static /* enum */ Counter PASSED_DHCP;
        public static /* enum */ Counter PASSED_IPV4;
        public static /* enum */ Counter PASSED_IPV6_NON_ICMP;
        public static /* enum */ Counter PASSED_IPV4_UNICAST;
        public static /* enum */ Counter PASSED_IPV6_ICMP;
        public static /* enum */ Counter PASSED_IPV6_UNICAST_NON_ICMP;
        public static /* enum */ Counter PASSED_ARP_NON_IPV4;
        public static /* enum */ Counter PASSED_ARP_UNKNOWN;
        public static /* enum */ Counter PASSED_ARP_UNICAST_REPLY;
        public static /* enum */ Counter PASSED_NON_IP_UNICAST;
        public static /* enum */ Counter DROPPED_ETH_BROADCAST;
        public static /* enum */ Counter DROPPED_RA;
        public static /* enum */ Counter DROPPED_GARP_REPLY;
        public static /* enum */ Counter DROPPED_ARP_OTHER_HOST;
        public static /* enum */ Counter DROPPED_IPV4_L2_BROADCAST;
        public static /* enum */ Counter DROPPED_IPV4_BROADCAST_ADDR;
        public static /* enum */ Counter DROPPED_IPV4_BROADCAST_NET;
        public static /* enum */ Counter DROPPED_IPV4_MULTICAST;
        public static /* enum */ Counter DROPPED_IPV6_ROUTER_SOLICITATION;
        public static /* enum */ Counter DROPPED_IPV6_MULTICAST_NA;
        public static /* enum */ Counter DROPPED_IPV6_MULTICAST;
        public static /* enum */ Counter DROPPED_IPV6_MULTICAST_PING;
        public static /* enum */ Counter DROPPED_IPV6_NON_ICMP_MULTICAST;
        public static /* enum */ Counter DROPPED_802_3_FRAME;
        public static /* enum */ Counter DROPPED_ETHERTYPE_BLACKLISTED;
        private static /* synthetic */ Counter[] $VALUES;

        private static final Counter[] $$robo$$android_net_apf_ApfFilter_Counter$values() {
            return (Counter[])$VALUES.clone();
        }

        private static final Counter $$robo$$android_net_apf_ApfFilter_Counter$valueOf(String name) {
            return Enum.valueOf(Counter.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_apf_ApfFilter_Counter$__constructor__(String string2, int n) {
        }

        private final int $$robo$$android_net_apf_ApfFilter_Counter$offset() {
            return -this.ordinal() * 4;
        }

        private static final int $$robo$$android_net_apf_ApfFilter_Counter$totalSize() {
            return (((Counter[])Counter.class.getEnumConstants()).length - 1) * 4;
        }

        static void __staticInitializer__() {
            RESERVED_OOB = new Counter();
            TOTAL_PACKETS = new Counter();
            PASSED_ARP = new Counter();
            PASSED_DHCP = new Counter();
            PASSED_IPV4 = new Counter();
            PASSED_IPV6_NON_ICMP = new Counter();
            PASSED_IPV4_UNICAST = new Counter();
            PASSED_IPV6_ICMP = new Counter();
            PASSED_IPV6_UNICAST_NON_ICMP = new Counter();
            PASSED_ARP_NON_IPV4 = new Counter();
            PASSED_ARP_UNKNOWN = new Counter();
            PASSED_ARP_UNICAST_REPLY = new Counter();
            PASSED_NON_IP_UNICAST = new Counter();
            DROPPED_ETH_BROADCAST = new Counter();
            DROPPED_RA = new Counter();
            DROPPED_GARP_REPLY = new Counter();
            DROPPED_ARP_OTHER_HOST = new Counter();
            DROPPED_IPV4_L2_BROADCAST = new Counter();
            DROPPED_IPV4_BROADCAST_ADDR = new Counter();
            DROPPED_IPV4_BROADCAST_NET = new Counter();
            DROPPED_IPV4_MULTICAST = new Counter();
            DROPPED_IPV6_ROUTER_SOLICITATION = new Counter();
            DROPPED_IPV6_MULTICAST_NA = new Counter();
            DROPPED_IPV6_MULTICAST = new Counter();
            DROPPED_IPV6_MULTICAST_PING = new Counter();
            DROPPED_IPV6_NON_ICMP_MULTICAST = new Counter();
            DROPPED_802_3_FRAME = new Counter();
            DROPPED_ETHERTYPE_BLACKLISTED = new Counter();
            $VALUES = new Counter[]{RESERVED_OOB, TOTAL_PACKETS, PASSED_ARP, PASSED_DHCP, PASSED_IPV4, PASSED_IPV6_NON_ICMP, PASSED_IPV4_UNICAST, PASSED_IPV6_ICMP, PASSED_IPV6_UNICAST_NON_ICMP, PASSED_ARP_NON_IPV4, PASSED_ARP_UNKNOWN, PASSED_ARP_UNICAST_REPLY, PASSED_NON_IP_UNICAST, DROPPED_ETH_BROADCAST, DROPPED_RA, DROPPED_GARP_REPLY, DROPPED_ARP_OTHER_HOST, DROPPED_IPV4_L2_BROADCAST, DROPPED_IPV4_BROADCAST_ADDR, DROPPED_IPV4_BROADCAST_NET, DROPPED_IPV4_MULTICAST, DROPPED_IPV6_ROUTER_SOLICITATION, DROPPED_IPV6_MULTICAST_NA, DROPPED_IPV6_MULTICAST, DROPPED_IPV6_MULTICAST_PING, DROPPED_IPV6_NON_ICMP_MULTICAST, DROPPED_802_3_FRAME, DROPPED_ETHERTYPE_BLACKLISTED};
        }

        public static Counter[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_apf_ApfFilter_Counter$values(), 0);
        }

        public static Counter valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_apf_ApfFilter_Counter$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_apf_ApfFilter_Counter$__constructor__(string2, n);
        }

        private Counter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_Counter$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public int offset() {
            return (int)InvokeDynamicSupport.bootstrap("offset", $$robo$$android_net_apf_ApfFilter_Counter$offset(), 0, this);
        }

        public static int totalSize() {
            return (int)InvokeDynamicSupport.bootstrapStatic("totalSize", $$robo$$android_net_apf_ApfFilter_Counter$totalSize(), 0);
        }

        static {
            RobolectricInternals.classInitializing(Counter.class);
        }

        public /* synthetic */ Counter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Counter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ProcessRaResult
    extends Enum<ProcessRaResult> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ProcessRaResult MATCH;
        public static /* enum */ ProcessRaResult DROPPED;
        public static /* enum */ ProcessRaResult PARSE_ERROR;
        public static /* enum */ ProcessRaResult ZERO_LIFETIME;
        public static /* enum */ ProcessRaResult UPDATE_NEW_RA;
        public static /* enum */ ProcessRaResult UPDATE_EXPIRY;
        private static /* synthetic */ ProcessRaResult[] $VALUES;

        private static final ProcessRaResult[] $$robo$$android_net_apf_ApfFilter_ProcessRaResult$values() {
            return (ProcessRaResult[])$VALUES.clone();
        }

        private static final ProcessRaResult $$robo$$android_net_apf_ApfFilter_ProcessRaResult$valueOf(String name) {
            return Enum.valueOf(ProcessRaResult.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_net_apf_ApfFilter_ProcessRaResult$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            MATCH = new ProcessRaResult();
            DROPPED = new ProcessRaResult();
            PARSE_ERROR = new ProcessRaResult();
            ZERO_LIFETIME = new ProcessRaResult();
            UPDATE_NEW_RA = new ProcessRaResult();
            UPDATE_EXPIRY = new ProcessRaResult();
            $VALUES = new ProcessRaResult[]{MATCH, DROPPED, PARSE_ERROR, ZERO_LIFETIME, UPDATE_NEW_RA, UPDATE_EXPIRY};
        }

        public static ProcessRaResult[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_net_apf_ApfFilter_ProcessRaResult$values(), 0);
        }

        public static ProcessRaResult valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_net_apf_ApfFilter_ProcessRaResult$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_net_apf_ApfFilter_ProcessRaResult$__constructor__(string2, n);
        }

        private ProcessRaResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_ProcessRaResult$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(ProcessRaResult.class);
        }

        public /* synthetic */ ProcessRaResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessRaResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ApfConfiguration
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ApfCapabilities apfCapabilities;
        public boolean multicastFilter;
        public boolean ieee802_3Filter;
        public int[] ethTypeBlackList;

        private void $$robo$$android_net_apf_ApfFilter_ApfConfiguration$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_apf_ApfFilter_ApfConfiguration$__constructor__();
        }

        public ApfConfiguration() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_apf_ApfFilter_ApfConfiguration$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApfConfiguration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

