/*
 * Decompiled with CFR 0.152.
 */
package android.net.captiveportal;

import android.net.captiveportal.CaptivePortalProbeResult;
import android.text.TextUtils;
import android.util.Log;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class CaptivePortalProbeSpec
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String HTTP_LOCATION_HEADER_NAME = "Location";
    private static String TAG;
    private static String REGEX_SEPARATOR = "@@/@@";
    private static String SPEC_SEPARATOR = "@@,@@";
    private String mEncodedSpec;
    private URL mUrl;

    private void $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$__constructor__(String encodedSpec, URL url) {
        this.mEncodedSpec = encodedSpec;
        this.mUrl = url;
    }

    private static final CaptivePortalProbeSpec $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$parseSpec(String spec) throws ParseException, MalformedURLException {
        if (TextUtils.isEmpty(spec)) {
            throw new ParseException("Empty probe spec", 0);
        }
        String[] splits = TextUtils.split(spec, "@@/@@");
        if (splits.length != 3) {
            throw new ParseException("Probe spec does not have 3 parts", 0);
        }
        int statusRegexPos = splits[0].length() + "@@/@@".length();
        int locationRegexPos = statusRegexPos + splits[1].length() + "@@/@@".length();
        Pattern statusRegex = CaptivePortalProbeSpec.parsePatternIfNonEmpty(splits[1], statusRegexPos);
        Pattern locationRegex = CaptivePortalProbeSpec.parsePatternIfNonEmpty(splits[2], locationRegexPos);
        return new RegexMatchProbeSpec(spec, new URL(splits[0]), statusRegex, locationRegex);
    }

    private static final Pattern $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$parsePatternIfNonEmpty(String pattern, int pos) throws ParseException {
        if (TextUtils.isEmpty(pattern)) {
            return null;
        }
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ParseException(String.format("Invalid status pattern [%s]: %s", pattern, e), pos);
        }
    }

    private static final CaptivePortalProbeSpec $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$parseSpecOrNull(String spec) {
        if (spec != null) {
            try {
                return CaptivePortalProbeSpec.parseSpec(spec);
            }
            catch (MalformedURLException | ParseException e) {
                Log.e(TAG, "Invalid probe spec: " + spec, e);
            }
        }
        return null;
    }

    private static final CaptivePortalProbeSpec[] $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$parseCaptivePortalProbeSpecs(String settingsVal) {
        ArrayList<CaptivePortalProbeSpec> specs = new ArrayList<CaptivePortalProbeSpec>();
        if (settingsVal != null) {
            for (String spec : TextUtils.split(settingsVal, "@@,@@")) {
                try {
                    specs.add(CaptivePortalProbeSpec.parseSpec(spec));
                }
                catch (MalformedURLException | ParseException e) {
                    Log.e(TAG, "Invalid probe spec: " + spec, e);
                }
            }
        }
        if (specs.isEmpty()) {
            Log.e(TAG, String.format("could not create any validation spec from %s", settingsVal));
        }
        return specs.toArray(new CaptivePortalProbeSpec[specs.size()]);
    }

    public abstract CaptivePortalProbeResult getResult(int var1, String var2);

    private final String $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$getEncodedSpec() {
        return this.mEncodedSpec;
    }

    private final URL $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$getUrl() {
        return this.mUrl;
    }

    private static final boolean $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$safeMatch(String value, Pattern pattern) {
        return pattern == null || TextUtils.isEmpty(value) || pattern.matcher(value).matches();
    }

    static void __staticInitializer__() {
        TAG = CaptivePortalProbeSpec.class.getSimpleName();
    }

    private void __constructor__(String string2, URL uRL) {
        this.$$robo$$android_net_captiveportal_CaptivePortalProbeSpec$__constructor__(string2, uRL);
    }

    CaptivePortalProbeSpec(String string2, URL uRL) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$__constructor__(java.lang.String java.net.URL ), 0, this, string2, uRL);
    }

    public static CaptivePortalProbeSpec parseSpec(String string2) throws ParseException, MalformedURLException {
        return InvokeDynamicSupport.bootstrapStatic("parseSpec", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$parseSpec(java.lang.String ), 0, (String)string2);
    }

    private static Pattern parsePatternIfNonEmpty(String string2, int n) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("parsePatternIfNonEmpty", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$parsePatternIfNonEmpty(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static CaptivePortalProbeSpec parseSpecOrNull(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseSpecOrNull", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$parseSpecOrNull(java.lang.String ), 0, (String)string2);
    }

    public static CaptivePortalProbeSpec[] parseCaptivePortalProbeSpecs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("parseCaptivePortalProbeSpecs", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$parseCaptivePortalProbeSpecs(java.lang.String ), 0, (String)string2);
    }

    public String getEncodedSpec() {
        return InvokeDynamicSupport.bootstrap("getEncodedSpec", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$getEncodedSpec(), 0, this);
    }

    public URL getUrl() {
        return InvokeDynamicSupport.bootstrap("getUrl", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$getUrl(), 0, this);
    }

    private static boolean safeMatch(String string2, Pattern pattern) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("safeMatch", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec$safeMatch(java.lang.String java.util.regex.Pattern ), 0, (String)string2, (Pattern)pattern);
    }

    static {
        RobolectricInternals.classInitializing(CaptivePortalProbeSpec.class);
    }

    public /* synthetic */ CaptivePortalProbeSpec() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CaptivePortalProbeSpec)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class RegexMatchProbeSpec
    extends CaptivePortalProbeSpec
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Pattern mStatusRegex;
        Pattern mLocationHeaderRegex;

        private void $$robo$$android_net_captiveportal_CaptivePortalProbeSpec_RegexMatchProbeSpec$__constructor__(String spec, URL url, Pattern statusRegex, Pattern locationHeaderRegex) {
            this.mStatusRegex = statusRegex;
            this.mLocationHeaderRegex = locationHeaderRegex;
        }

        private final CaptivePortalProbeResult $$robo$$android_net_captiveportal_CaptivePortalProbeSpec_RegexMatchProbeSpec$getResult(int status, String locationHeader) {
            boolean statusMatch = CaptivePortalProbeSpec.safeMatch(String.valueOf(status), this.mStatusRegex);
            boolean locationMatch = CaptivePortalProbeSpec.safeMatch(locationHeader, this.mLocationHeaderRegex);
            int returnCode = statusMatch && locationMatch ? 204 : 302;
            return new CaptivePortalProbeResult(returnCode, locationHeader, this.getUrl().toString(), this);
        }

        private void __constructor__(String string2, URL uRL, Pattern pattern, Pattern pattern2) {
            this.$$robo$$android_net_captiveportal_CaptivePortalProbeSpec_RegexMatchProbeSpec$__constructor__(string2, uRL, pattern, pattern2);
        }

        RegexMatchProbeSpec(String string2, URL uRL, Pattern pattern, Pattern pattern2) {
            super(string2, uRL);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec_RegexMatchProbeSpec$__constructor__(java.lang.String java.net.URL java.util.regex.Pattern java.util.regex.Pattern ), 0, this, string2, uRL, pattern, pattern2);
        }

        @Override
        public CaptivePortalProbeResult getResult(int n, String string2) {
            return InvokeDynamicSupport.bootstrap("getResult", $$robo$$android_net_captiveportal_CaptivePortalProbeSpec_RegexMatchProbeSpec$getResult(int java.lang.String ), 0, this, n, string2);
        }

        public /* synthetic */ RegexMatchProbeSpec() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RegexMatchProbeSpec)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

