/*
 * Decompiled with CFR 0.152.
 */
package android.net.dhcp;

import android.net.DhcpResults;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.dhcp.DhcpAckPacket;
import android.net.dhcp.DhcpDeclinePacket;
import android.net.dhcp.DhcpDiscoverPacket;
import android.net.dhcp.DhcpInformPacket;
import android.net.dhcp.DhcpNakPacket;
import android.net.dhcp.DhcpOfferPacket;
import android.net.dhcp.DhcpRequestPacket;
import android.net.metrics.DhcpErrorEvent;
import android.os.Build;
import android.os.SystemProperties;
import android.system.OsConstants;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class DhcpPacket
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static String TAG = "DhcpPacket";
    public static int MINIMUM_LEASE = 60;
    public static int INFINITE_LEASE = -1;
    public static Inet4Address INADDR_ANY;
    public static Inet4Address INADDR_BROADCAST;
    public static byte[] ETHER_BROADCAST;
    public static int ENCAP_L2 = 0;
    public static int ENCAP_L3 = 1;
    public static int ENCAP_BOOTP = 2;
    public static int MIN_PACKET_LENGTH_BOOTP = 236;
    public static int MIN_PACKET_LENGTH_L3 = 264;
    public static int MIN_PACKET_LENGTH_L2 = 278;
    public static int HWADDR_LEN = 16;
    public static int MAX_OPTION_LEN = 255;
    private static int MIN_MTU = 1280;
    private static int MAX_MTU = 1500;
    private static byte IP_TYPE_UDP = 17;
    private static byte IP_VERSION_HEADER_LEN = 69;
    private static short IP_FLAGS_OFFSET = 16384;
    private static byte IP_TOS_LOWDELAY = 16;
    private static byte IP_TTL = 64;
    static short DHCP_CLIENT = 68;
    static short DHCP_SERVER = 67;
    protected static byte DHCP_BOOTREQUEST = 1;
    protected static byte DHCP_BOOTREPLY = 2;
    protected static byte CLIENT_ID_ETHER = 1;
    protected static int MAX_LENGTH = 1500;
    private static int DHCP_MAGIC_COOKIE = 1669485411;
    protected static byte DHCP_SUBNET_MASK = 1;
    protected Inet4Address mSubnetMask;
    protected static byte DHCP_ROUTER = 3;
    protected List<Inet4Address> mGateways;
    protected static byte DHCP_DNS_SERVER = 6;
    protected List<Inet4Address> mDnsServers;
    protected static byte DHCP_HOST_NAME = 12;
    protected String mHostName;
    protected static byte DHCP_DOMAIN_NAME = 15;
    protected String mDomainName;
    protected static byte DHCP_MTU = 26;
    protected Short mMtu;
    protected static byte DHCP_BROADCAST_ADDRESS = 28;
    protected Inet4Address mBroadcastAddress;
    protected static byte DHCP_VENDOR_INFO = 43;
    protected String mVendorInfo;
    protected static byte DHCP_REQUESTED_IP = 50;
    protected Inet4Address mRequestedIp;
    protected static byte DHCP_LEASE_TIME = 51;
    protected Integer mLeaseTime;
    protected static byte DHCP_MESSAGE_TYPE = 53;
    protected static byte DHCP_MESSAGE_TYPE_DISCOVER = 1;
    protected static byte DHCP_MESSAGE_TYPE_OFFER = 2;
    protected static byte DHCP_MESSAGE_TYPE_REQUEST = 3;
    protected static byte DHCP_MESSAGE_TYPE_DECLINE = 4;
    protected static byte DHCP_MESSAGE_TYPE_ACK = 5;
    protected static byte DHCP_MESSAGE_TYPE_NAK = 6;
    protected static byte DHCP_MESSAGE_TYPE_INFORM = 8;
    protected static byte DHCP_SERVER_IDENTIFIER = 54;
    protected Inet4Address mServerIdentifier;
    protected static byte DHCP_PARAMETER_LIST = 55;
    protected byte[] mRequestedParams;
    protected static byte DHCP_MESSAGE = 56;
    protected String mMessage;
    protected static byte DHCP_MAX_MESSAGE_SIZE = 57;
    protected Short mMaxMessageSize;
    protected static byte DHCP_RENEWAL_TIME = 58;
    protected Integer mT1;
    protected static byte DHCP_REBINDING_TIME = 59;
    protected Integer mT2;
    protected static byte DHCP_VENDOR_CLASS_ID = 60;
    protected String mVendorId;
    protected static byte DHCP_CLIENT_IDENTIFIER = 61;
    protected static byte DHCP_OPTION_PAD = 0;
    protected static byte DHCP_OPTION_END = -1;
    protected int mTransId;
    protected short mSecs;
    protected Inet4Address mClientIp;
    protected Inet4Address mYourIp;
    private Inet4Address mNextIp;
    private Inet4Address mRelayIp;
    protected boolean mBroadcast;
    protected byte[] mClientMac;
    static String testOverrideVendorId;
    static String testOverrideHostname;

    public abstract ByteBuffer buildPacket(int var1, short var2, short var3);

    abstract void finishPacket(ByteBuffer var1);

    private void $$robo$$android_net_dhcp_DhcpPacket$__constructor__(int transId, short secs, Inet4Address clientIp, Inet4Address yourIp, Inet4Address nextIp, Inet4Address relayIp, byte[] clientMac, boolean broadcast) {
        this.mTransId = transId;
        this.mSecs = secs;
        this.mClientIp = clientIp;
        this.mYourIp = yourIp;
        this.mNextIp = nextIp;
        this.mRelayIp = relayIp;
        this.mClientMac = clientMac;
        this.mBroadcast = broadcast;
    }

    private final int $$robo$$android_net_dhcp_DhcpPacket$getTransactionId() {
        return this.mTransId;
    }

    private final byte[] $$robo$$android_net_dhcp_DhcpPacket$getClientMac() {
        return this.mClientMac;
    }

    private final byte[] $$robo$$android_net_dhcp_DhcpPacket$getClientId() {
        byte[] clientId = new byte[this.mClientMac.length + 1];
        clientId[0] = 1;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mClientMac, (int)0, (byte[])clientId, (int)1, (int)this.mClientMac.length);
        return clientId;
    }

    private final void $$robo$$android_net_dhcp_DhcpPacket$fillInPacket(int encap, Inet4Address destIp, Inet4Address srcIp, short destUdp, short srcUdp, ByteBuffer buf, byte requestCode, boolean broadcast) {
        byte[] destIpArray = destIp.getAddress();
        byte[] srcIpArray = srcIp.getAddress();
        int ipHeaderOffset = 0;
        int ipLengthOffset = 0;
        int ipChecksumOffset = 0;
        int endIpHeader = 0;
        int udpHeaderOffset = 0;
        int udpLengthOffset = 0;
        int udpChecksumOffset = 0;
        buf.clear();
        buf.order(ByteOrder.BIG_ENDIAN);
        if (encap == 0) {
            buf.put(ETHER_BROADCAST);
            buf.put(this.mClientMac);
            buf.putShort((short)OsConstants.ETH_P_IP);
        }
        if (encap <= 1) {
            ipHeaderOffset = buf.position();
            buf.put((byte)69);
            buf.put((byte)16);
            ipLengthOffset = buf.position();
            buf.putShort((short)0);
            buf.putShort((short)0);
            buf.putShort((short)16384);
            buf.put((byte)64);
            buf.put((byte)17);
            ipChecksumOffset = buf.position();
            buf.putShort((short)0);
            buf.put(srcIpArray);
            buf.put(destIpArray);
            endIpHeader = buf.position();
            udpHeaderOffset = buf.position();
            buf.putShort(srcUdp);
            buf.putShort(destUdp);
            udpLengthOffset = buf.position();
            buf.putShort((short)0);
            udpChecksumOffset = buf.position();
            buf.putShort((short)0);
        }
        buf.put(requestCode);
        buf.put((byte)1);
        buf.put((byte)this.mClientMac.length);
        buf.put((byte)0);
        buf.putInt(this.mTransId);
        buf.putShort(this.mSecs);
        if (broadcast) {
            buf.putShort((short)Short.MIN_VALUE);
        } else {
            buf.putShort((short)0);
        }
        buf.put(this.mClientIp.getAddress());
        buf.put(this.mYourIp.getAddress());
        buf.put(this.mNextIp.getAddress());
        buf.put(this.mRelayIp.getAddress());
        buf.put(this.mClientMac);
        buf.position(buf.position() + (16 - this.mClientMac.length) + 64 + 128);
        buf.putInt(1669485411);
        this.finishPacket(buf);
        if ((buf.position() & 1) == 1) {
            buf.put((byte)0);
        }
        if (encap <= 1) {
            short udpLen = (short)(buf.position() - udpHeaderOffset);
            buf.putShort(udpLengthOffset, udpLen);
            int udpSeed = 0;
            udpSeed += DhcpPacket.intAbs(buf.getShort(ipChecksumOffset + 2));
            udpSeed += DhcpPacket.intAbs(buf.getShort(ipChecksumOffset + 4));
            udpSeed += DhcpPacket.intAbs(buf.getShort(ipChecksumOffset + 6));
            udpSeed += DhcpPacket.intAbs(buf.getShort(ipChecksumOffset + 8));
            udpSeed += 17;
            buf.putShort(udpChecksumOffset, (short)this.checksum(buf, udpSeed += udpLen, udpHeaderOffset, buf.position()));
            buf.putShort(ipLengthOffset, (short)(buf.position() - ipHeaderOffset));
            buf.putShort(ipChecksumOffset, (short)this.checksum(buf, 0, ipHeaderOffset, endIpHeader));
        }
    }

    private static final int $$robo$$android_net_dhcp_DhcpPacket$intAbs(short v) {
        return v & 0xFFFF;
    }

    private final int $$robo$$android_net_dhcp_DhcpPacket$checksum(ByteBuffer buf, int seed, int start, int end) {
        int sum = seed;
        int bufPosition = buf.position();
        buf.position(start);
        ShortBuffer shortBuf = buf.asShortBuffer();
        buf.position(bufPosition);
        short[] shortArray = new short[(end - start) / 2];
        shortBuf.get(shortArray);
        for (short s : shortArray) {
            sum += DhcpPacket.intAbs(s);
        }
        if (end != (start += shortArray.length * 2)) {
            short b = buf.get(start);
            if (b < 0) {
                b = (short)(b + 256);
            }
            sum += b * 256;
        }
        sum = (sum >> 16 & 0xFFFF) + (sum & 0xFFFF);
        sum = sum + (sum >> 16 & 0xFFFF) & 0xFFFF;
        int negated = ~sum;
        return DhcpPacket.intAbs((short)negated);
    }

    private static final void $$robo$$android_net_dhcp_DhcpPacket$addTlv(ByteBuffer buf, byte type, byte value) {
        buf.put(type);
        buf.put((byte)1);
        buf.put(value);
    }

    private static final void $$robo$$android_net_dhcp_DhcpPacket$addTlv(ByteBuffer buf, byte type, byte[] payload) {
        if (payload != null) {
            if (payload.length > 255) {
                throw new IllegalArgumentException("DHCP option too long: " + payload.length + " vs. " + 255);
            }
            buf.put(type);
            buf.put((byte)payload.length);
            buf.put(payload);
        }
    }

    private static final void $$robo$$android_net_dhcp_DhcpPacket$addTlv(ByteBuffer buf, byte type, Inet4Address addr) {
        if (addr != null) {
            DhcpPacket.addTlv(buf, type, addr.getAddress());
        }
    }

    private static final void $$robo$$android_net_dhcp_DhcpPacket$addTlv(ByteBuffer buf, byte type, List<Inet4Address> addrs) {
        if (addrs == null || addrs.size() == 0) {
            return;
        }
        int optionLen = 4 * addrs.size();
        if (optionLen > 255) {
            throw new IllegalArgumentException("DHCP option too long: " + optionLen + " vs. " + 255);
        }
        buf.put(type);
        buf.put((byte)optionLen);
        for (Inet4Address addr : addrs) {
            buf.put(addr.getAddress());
        }
    }

    private static final void $$robo$$android_net_dhcp_DhcpPacket$addTlv(ByteBuffer buf, byte type, Short value) {
        if (value != null) {
            buf.put(type);
            buf.put((byte)2);
            buf.putShort(value);
        }
    }

    private static final void $$robo$$android_net_dhcp_DhcpPacket$addTlv(ByteBuffer buf, byte type, Integer value) {
        if (value != null) {
            buf.put(type);
            buf.put((byte)4);
            buf.putInt(value);
        }
    }

    private static final void $$robo$$android_net_dhcp_DhcpPacket$addTlv(ByteBuffer buf, byte type, String str) {
        try {
            DhcpPacket.addTlv(buf, type, str.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("String is not US-ASCII: " + str);
        }
    }

    private static final void $$robo$$android_net_dhcp_DhcpPacket$addTlvEnd(ByteBuffer buf) {
        buf.put((byte)-1);
    }

    private final String $$robo$$android_net_dhcp_DhcpPacket$getVendorId() {
        if (testOverrideVendorId != null) {
            return testOverrideVendorId;
        }
        return "android-dhcp-" + Build.VERSION.RELEASE;
    }

    private final String $$robo$$android_net_dhcp_DhcpPacket$getHostname() {
        if (testOverrideHostname != null) {
            return testOverrideHostname;
        }
        return SystemProperties.get("net.hostname");
    }

    private final void $$robo$$android_net_dhcp_DhcpPacket$addCommonClientTlvs(ByteBuffer buf) {
        DhcpPacket.addTlv(buf, (byte)57, (short)1500);
        DhcpPacket.addTlv(buf, (byte)60, this.getVendorId());
        String hn = this.getHostname();
        if (!TextUtils.isEmpty(hn)) {
            DhcpPacket.addTlv(buf, (byte)12, hn);
        }
    }

    private static final String $$robo$$android_net_dhcp_DhcpPacket$macToString(byte[] mac) {
        String macAddr = "";
        for (int i = 0; i < mac.length; ++i) {
            String hexString = "0" + Integer.toHexString(mac[i]);
            macAddr = macAddr + hexString.substring(hexString.length() - 2);
            if (i == mac.length - 1) continue;
            macAddr = macAddr + ":";
        }
        return macAddr;
    }

    private final String $$robo$$android_net_dhcp_DhcpPacket$toString() {
        String macAddr = DhcpPacket.macToString(this.mClientMac);
        return macAddr;
    }

    private static final Inet4Address $$robo$$android_net_dhcp_DhcpPacket$readIpAddress(ByteBuffer packet) {
        Inet4Address result = null;
        byte[] ipAddr = new byte[4];
        packet.get(ipAddr);
        try {
            result = (Inet4Address)Inet4Address.getByAddress(ipAddr);
        }
        catch (UnknownHostException ex) {
            result = null;
        }
        return result;
    }

    private static final String $$robo$$android_net_dhcp_DhcpPacket$readAsciiString(ByteBuffer buf, int byteCount, boolean nullOk) {
        byte[] bytes = new byte[byteCount];
        buf.get(bytes);
        int length = bytes.length;
        if (!nullOk) {
            for (length = 0; length < bytes.length && bytes[length] != 0; ++length) {
            }
        }
        return new String(bytes, 0, length, StandardCharsets.US_ASCII);
    }

    private static final boolean $$robo$$android_net_dhcp_DhcpPacket$isPacketToOrFromClient(short udpSrcPort, short udpDstPort) {
        return udpSrcPort == 68 || udpDstPort == 68;
    }

    private static final boolean $$robo$$android_net_dhcp_DhcpPacket$isPacketServerToServer(short udpSrcPort, short udpDstPort) {
        return udpSrcPort == 67 && udpDstPort == 67;
    }

    @VisibleForTesting
    private static final DhcpPacket $$robo$$android_net_dhcp_DhcpPacket$decodeFullPacket(ByteBuffer packet, int pktType) throws ParseException {
        DhcpPacket newPacket;
        Inet4Address relayIp;
        Inet4Address nextIp;
        Inet4Address yourIp;
        Inet4Address clientIp;
        ArrayList<Inet4Address> dnsServers = new ArrayList<Inet4Address>();
        ArrayList<Inet4Address> gateways = new ArrayList<Inet4Address>();
        Inet4Address serverIdentifier = null;
        Inet4Address netMask = null;
        String message = null;
        String vendorId = null;
        String vendorInfo = null;
        byte[] expectedParams = null;
        String hostName = null;
        String domainName = null;
        Inet4Address ipSrc = null;
        Inet4Address ipDst = null;
        Inet4Address bcAddr = null;
        Inet4Address requestedIp = null;
        Short mtu = null;
        Short maxMessageSize = null;
        Integer leaseTime = null;
        Integer T1 = null;
        Integer T2 = null;
        byte dhcpType = -1;
        packet.order(ByteOrder.BIG_ENDIAN);
        if (pktType == 0) {
            if (packet.remaining() < 278) {
                throw new ParseException(DhcpErrorEvent.L2_TOO_SHORT, "L2 packet too short, %d < %d", packet.remaining(), 278);
            }
            byte[] l2dst = new byte[6];
            byte[] l2src = new byte[6];
            packet.get(l2dst);
            packet.get(l2src);
            short l2type = packet.getShort();
            if (l2type != OsConstants.ETH_P_IP) {
                throw new ParseException(DhcpErrorEvent.L2_WRONG_ETH_TYPE, "Unexpected L2 type 0x%04x, expected 0x%04x", l2type, OsConstants.ETH_P_IP);
            }
        }
        if (pktType <= 1) {
            if (packet.remaining() < 264) {
                throw new ParseException(DhcpErrorEvent.L3_TOO_SHORT, "L3 packet too short, %d < %d", packet.remaining(), 264);
            }
            byte ipTypeAndLength = packet.get();
            int ipVersion = (ipTypeAndLength & 0xF0) >> 4;
            if (ipVersion != 4) {
                throw new ParseException(DhcpErrorEvent.L3_NOT_IPV4, "Invalid IP version %d", ipVersion);
            }
            byte ipDiffServicesField = packet.get();
            short ipTotalLength = packet.getShort();
            short ipIdentification = packet.getShort();
            byte ipFlags = packet.get();
            byte ipFragOffset = packet.get();
            byte ipTTL = packet.get();
            byte ipProto = packet.get();
            short ipChksm = packet.getShort();
            ipSrc = DhcpPacket.readIpAddress(packet);
            ipDst = DhcpPacket.readIpAddress(packet);
            if (ipProto != 17) {
                throw new ParseException(DhcpErrorEvent.L4_NOT_UDP, "Protocol not UDP: %d", ipProto);
            }
            int optionWords = (ipTypeAndLength & 0xF) - 5;
            for (int i = 0; i < optionWords; ++i) {
                packet.getInt();
            }
            short udpSrcPort = packet.getShort();
            short udpDstPort = packet.getShort();
            short udpLen = packet.getShort();
            short udpChkSum = packet.getShort();
            if (!DhcpPacket.isPacketToOrFromClient(udpSrcPort, udpDstPort) && !DhcpPacket.isPacketServerToServer(udpSrcPort, udpDstPort)) {
                throw new ParseException(DhcpErrorEvent.L4_WRONG_PORT, "Unexpected UDP ports %d->%d", udpSrcPort, udpDstPort);
            }
        }
        if (pktType > 2 || packet.remaining() < 236) {
            throw new ParseException(DhcpErrorEvent.BOOTP_TOO_SHORT, "Invalid type or BOOTP packet too short, %d < %d", packet.remaining(), 236);
        }
        byte type = packet.get();
        byte hwType = packet.get();
        int addrLen = packet.get() & 0xFF;
        byte hops = packet.get();
        int transactionId = packet.getInt();
        short secs = packet.getShort();
        short bootpFlags = packet.getShort();
        boolean broadcast = (bootpFlags & 0x8000) != 0;
        byte[] ipv4addr = new byte[4];
        try {
            packet.get(ipv4addr);
            clientIp = (Inet4Address)Inet4Address.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            yourIp = (Inet4Address)Inet4Address.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            nextIp = (Inet4Address)Inet4Address.getByAddress(ipv4addr);
            packet.get(ipv4addr);
            relayIp = (Inet4Address)Inet4Address.getByAddress(ipv4addr);
        }
        catch (UnknownHostException ex) {
            throw new ParseException(DhcpErrorEvent.L3_INVALID_IP, "Invalid IPv4 address: %s", Arrays.toString(ipv4addr));
        }
        if (addrLen > 16) {
            addrLen = ETHER_BROADCAST.length;
        }
        byte[] clientMac = new byte[addrLen];
        packet.get(clientMac);
        packet.position(packet.position() + (16 - addrLen) + 64 + 128);
        if (packet.remaining() < 4) {
            throw new ParseException(DhcpErrorEvent.DHCP_NO_COOKIE, "not a DHCP message", new Object[0]);
        }
        int dhcpMagicCookie = packet.getInt();
        if (dhcpMagicCookie != 1669485411) {
            throw new ParseException(DhcpErrorEvent.DHCP_BAD_MAGIC_COOKIE, "Bad magic cookie 0x%08x, should be 0x%08x", dhcpMagicCookie, 1669485411);
        }
        boolean notFinishedOptions = true;
        while (packet.position() < packet.limit() && notFinishedOptions) {
            byte optionType = packet.get();
            try {
                if (optionType == -1) {
                    notFinishedOptions = false;
                    continue;
                }
                if (optionType == 0) continue;
                int optionLen = packet.get() & 0xFF;
                int expectedLen = 0;
                switch (optionType) {
                    case 1: {
                        netMask = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 3: {
                        for (expectedLen = 0; expectedLen < optionLen; expectedLen += 4) {
                            gateways.add(DhcpPacket.readIpAddress(packet));
                        }
                        break;
                    }
                    case 6: {
                        for (expectedLen = 0; expectedLen < optionLen; expectedLen += 4) {
                            dnsServers.add(DhcpPacket.readIpAddress(packet));
                        }
                        break;
                    }
                    case 12: {
                        expectedLen = optionLen;
                        hostName = DhcpPacket.readAsciiString(packet, optionLen, false);
                        break;
                    }
                    case 26: {
                        expectedLen = 2;
                        mtu = packet.getShort();
                        break;
                    }
                    case 15: {
                        expectedLen = optionLen;
                        domainName = DhcpPacket.readAsciiString(packet, optionLen, false);
                        break;
                    }
                    case 28: {
                        bcAddr = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 50: {
                        requestedIp = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 51: {
                        leaseTime = packet.getInt();
                        expectedLen = 4;
                        break;
                    }
                    case 53: {
                        dhcpType = packet.get();
                        expectedLen = 1;
                        break;
                    }
                    case 54: {
                        serverIdentifier = DhcpPacket.readIpAddress(packet);
                        expectedLen = 4;
                        break;
                    }
                    case 55: {
                        expectedParams = new byte[optionLen];
                        packet.get(expectedParams);
                        expectedLen = optionLen;
                        break;
                    }
                    case 56: {
                        expectedLen = optionLen;
                        message = DhcpPacket.readAsciiString(packet, optionLen, false);
                        break;
                    }
                    case 57: {
                        expectedLen = 2;
                        maxMessageSize = packet.getShort();
                        break;
                    }
                    case 58: {
                        expectedLen = 4;
                        T1 = packet.getInt();
                        break;
                    }
                    case 59: {
                        expectedLen = 4;
                        T2 = packet.getInt();
                        break;
                    }
                    case 60: {
                        expectedLen = optionLen;
                        vendorId = DhcpPacket.readAsciiString(packet, optionLen, true);
                        break;
                    }
                    case 61: {
                        byte[] id2 = new byte[optionLen];
                        packet.get(id2);
                        expectedLen = optionLen;
                        break;
                    }
                    case 43: {
                        expectedLen = optionLen;
                        vendorInfo = DhcpPacket.readAsciiString(packet, optionLen, true);
                        break;
                    }
                    default: {
                        for (int i = 0; i < optionLen; ++i) {
                            ++expectedLen;
                            byte by = packet.get();
                        }
                    }
                }
                if (expectedLen == optionLen) continue;
                int errorCode = DhcpErrorEvent.errorCodeWithOption(DhcpErrorEvent.DHCP_INVALID_OPTION_LENGTH, optionType);
                throw new ParseException(errorCode, "Invalid length %d for option %d, expected %d", optionLen, optionType, expectedLen);
            }
            catch (BufferUnderflowException e) {
                int errorCode = DhcpErrorEvent.errorCodeWithOption(DhcpErrorEvent.BUFFER_UNDERFLOW, optionType);
                throw new ParseException(errorCode, "BufferUnderflowException", new Object[0]);
            }
        }
        switch (dhcpType) {
            case -1: {
                throw new ParseException(DhcpErrorEvent.DHCP_NO_MSG_TYPE, "No DHCP message type option", new Object[0]);
            }
            case 1: {
                newPacket = new DhcpDiscoverPacket(transactionId, secs, clientMac, broadcast);
                break;
            }
            case 2: {
                newPacket = new DhcpOfferPacket(transactionId, secs, broadcast, ipSrc, clientIp, yourIp, clientMac);
                break;
            }
            case 3: {
                newPacket = new DhcpRequestPacket(transactionId, secs, clientIp, clientMac, broadcast);
                break;
            }
            case 4: {
                newPacket = new DhcpDeclinePacket(transactionId, secs, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            case 5: {
                newPacket = new DhcpAckPacket(transactionId, secs, broadcast, ipSrc, clientIp, yourIp, clientMac);
                break;
            }
            case 6: {
                newPacket = new DhcpNakPacket(transactionId, secs, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            case 8: {
                newPacket = new DhcpInformPacket(transactionId, secs, clientIp, yourIp, nextIp, relayIp, clientMac);
                break;
            }
            default: {
                throw new ParseException(DhcpErrorEvent.DHCP_UNKNOWN_MSG_TYPE, "Unimplemented DHCP type %d", dhcpType);
            }
        }
        newPacket.mBroadcastAddress = bcAddr;
        newPacket.mDnsServers = dnsServers;
        newPacket.mDomainName = domainName;
        newPacket.mGateways = gateways;
        newPacket.mHostName = hostName;
        newPacket.mLeaseTime = leaseTime;
        newPacket.mMessage = message;
        newPacket.mMtu = mtu;
        newPacket.mRequestedIp = requestedIp;
        newPacket.mRequestedParams = expectedParams;
        newPacket.mServerIdentifier = serverIdentifier;
        newPacket.mSubnetMask = netMask;
        newPacket.mMaxMessageSize = maxMessageSize;
        newPacket.mT1 = T1;
        newPacket.mT2 = T2;
        newPacket.mVendorId = vendorId;
        newPacket.mVendorInfo = vendorInfo;
        return newPacket;
    }

    private static final DhcpPacket $$robo$$android_net_dhcp_DhcpPacket$decodeFullPacket(byte[] packet, int length, int pktType) throws ParseException {
        ByteBuffer buffer = ByteBuffer.wrap(packet, 0, length).order(ByteOrder.BIG_ENDIAN);
        try {
            return DhcpPacket.decodeFullPacket(buffer, pktType);
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(DhcpErrorEvent.PARSING_ERROR, e.getMessage(), new Object[0]);
        }
    }

    private final DhcpResults $$robo$$android_net_dhcp_DhcpPacket$toDhcpResults() {
        int prefixLength;
        Inet4Address ipAddress = this.mYourIp;
        if (ipAddress.equals(Inet4Address.ANY) && (ipAddress = this.mClientIp).equals(Inet4Address.ANY)) {
            return null;
        }
        if (this.mSubnetMask != null) {
            try {
                prefixLength = NetworkUtils.netmaskToPrefixLength(this.mSubnetMask);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        } else {
            prefixLength = NetworkUtils.getImplicitNetmask(ipAddress);
        }
        DhcpResults results = new DhcpResults();
        try {
            results.ipAddress = new LinkAddress(ipAddress, prefixLength);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (this.mGateways.size() > 0) {
            results.gateway = this.mGateways.get(0);
        }
        results.dnsServers.addAll(this.mDnsServers);
        results.domains = this.mDomainName;
        results.serverAddress = this.mServerIdentifier;
        results.vendorInfo = this.mVendorInfo;
        results.leaseDuration = this.mLeaseTime != null ? this.mLeaseTime : -1;
        results.mtu = this.mMtu != null && 1280 <= this.mMtu && this.mMtu <= 1500 ? (int)this.mMtu.shortValue() : 0;
        return results;
    }

    private final long $$robo$$android_net_dhcp_DhcpPacket$getLeaseTimeMillis() {
        if (this.mLeaseTime == null || this.mLeaseTime == -1) {
            return 0L;
        }
        if (0 <= this.mLeaseTime && this.mLeaseTime < 60) {
            return 60000L;
        }
        return ((long)this.mLeaseTime.intValue() & 0xFFFFFFFFL) * 1000L;
    }

    private static final ByteBuffer $$robo$$android_net_dhcp_DhcpPacket$buildDiscoverPacket(int encap, int transactionId, short secs, byte[] clientMac, boolean broadcast, byte[] expectedParams) {
        DhcpDiscoverPacket pkt = new DhcpDiscoverPacket(transactionId, secs, clientMac, broadcast);
        pkt.mRequestedParams = expectedParams;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)67, (short)68);
    }

    private static final ByteBuffer $$robo$$android_net_dhcp_DhcpPacket$buildOfferPacket(int encap, int transactionId, boolean broadcast, Inet4Address serverIpAddr, Inet4Address clientIpAddr, byte[] mac, Integer timeout, Inet4Address netMask, Inet4Address bcAddr, List<Inet4Address> gateways, List<Inet4Address> dnsServers, Inet4Address dhcpServerIdentifier, String domainName) {
        DhcpOfferPacket pkt = new DhcpOfferPacket(transactionId, 0, broadcast, serverIpAddr, INADDR_ANY, clientIpAddr, mac);
        pkt.mGateways = gateways;
        pkt.mDnsServers = dnsServers;
        pkt.mLeaseTime = timeout;
        pkt.mDomainName = domainName;
        pkt.mServerIdentifier = dhcpServerIdentifier;
        pkt.mSubnetMask = netMask;
        pkt.mBroadcastAddress = bcAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    private static final ByteBuffer $$robo$$android_net_dhcp_DhcpPacket$buildAckPacket(int encap, int transactionId, boolean broadcast, Inet4Address serverIpAddr, Inet4Address clientIpAddr, byte[] mac, Integer timeout, Inet4Address netMask, Inet4Address bcAddr, List<Inet4Address> gateways, List<Inet4Address> dnsServers, Inet4Address dhcpServerIdentifier, String domainName) {
        DhcpAckPacket pkt = new DhcpAckPacket(transactionId, 0, broadcast, serverIpAddr, INADDR_ANY, clientIpAddr, mac);
        pkt.mGateways = gateways;
        pkt.mDnsServers = dnsServers;
        pkt.mLeaseTime = timeout;
        pkt.mDomainName = domainName;
        pkt.mSubnetMask = netMask;
        pkt.mServerIdentifier = dhcpServerIdentifier;
        pkt.mBroadcastAddress = bcAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    private static final ByteBuffer $$robo$$android_net_dhcp_DhcpPacket$buildNakPacket(int encap, int transactionId, Inet4Address serverIpAddr, Inet4Address clientIpAddr, byte[] mac) {
        DhcpNakPacket pkt = new DhcpNakPacket(transactionId, 0, clientIpAddr, serverIpAddr, serverIpAddr, serverIpAddr, mac);
        pkt.mMessage = "requested address not available";
        pkt.mRequestedIp = clientIpAddr;
        return ((DhcpPacket)pkt).buildPacket(encap, (short)68, (short)67);
    }

    private static final ByteBuffer $$robo$$android_net_dhcp_DhcpPacket$buildRequestPacket(int encap, int transactionId, short secs, Inet4Address clientIp, boolean broadcast, byte[] clientMac, Inet4Address requestedIpAddress, Inet4Address serverIdentifier, byte[] requestedParams, String hostName) {
        DhcpRequestPacket pkt = new DhcpRequestPacket(transactionId, secs, clientIp, clientMac, broadcast);
        pkt.mRequestedIp = requestedIpAddress;
        pkt.mServerIdentifier = serverIdentifier;
        pkt.mHostName = hostName;
        pkt.mRequestedParams = requestedParams;
        ByteBuffer result = ((DhcpPacket)pkt).buildPacket(encap, (short)67, (short)68);
        return result;
    }

    static void __staticInitializer__() {
        INADDR_ANY = (Inet4Address)Inet4Address.ANY;
        INADDR_BROADCAST = (Inet4Address)Inet4Address.ALL;
        ETHER_BROADCAST = new byte[]{-1, -1, -1, -1, -1, -1};
        testOverrideVendorId = null;
        testOverrideHostname = null;
    }

    private void __constructor__(int n, short s, Inet4Address inet4Address, Inet4Address inet4Address2, Inet4Address inet4Address3, Inet4Address inet4Address4, byte[] byArray, boolean bl) {
        this.$$robo$$android_net_dhcp_DhcpPacket$__constructor__(n, s, inet4Address, inet4Address2, inet4Address3, inet4Address4, byArray, bl);
    }

    protected DhcpPacket(int n, short s, Inet4Address inet4Address, Inet4Address inet4Address2, Inet4Address inet4Address3, Inet4Address inet4Address4, byte[] byArray, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpPacket$__constructor__(int short java.net.Inet4Address java.net.Inet4Address java.net.Inet4Address java.net.Inet4Address byte[] boolean ), 0, this, n, s, inet4Address, inet4Address2, inet4Address3, inet4Address4, byArray, bl);
    }

    public int getTransactionId() {
        return (int)InvokeDynamicSupport.bootstrap("getTransactionId", $$robo$$android_net_dhcp_DhcpPacket$getTransactionId(), 0, this);
    }

    public byte[] getClientMac() {
        return InvokeDynamicSupport.bootstrap("getClientMac", $$robo$$android_net_dhcp_DhcpPacket$getClientMac(), 0, this);
    }

    public byte[] getClientId() {
        return InvokeDynamicSupport.bootstrap("getClientId", $$robo$$android_net_dhcp_DhcpPacket$getClientId(), 0, this);
    }

    protected void fillInPacket(int n, Inet4Address inet4Address, Inet4Address inet4Address2, short s, short s2, ByteBuffer byteBuffer, byte by, boolean bl) {
        InvokeDynamicSupport.bootstrap("fillInPacket", $$robo$$android_net_dhcp_DhcpPacket$fillInPacket(int java.net.Inet4Address java.net.Inet4Address short short java.nio.ByteBuffer byte boolean ), 0, this, n, inet4Address, inet4Address2, s, s2, byteBuffer, by, bl);
    }

    private static int intAbs(short s) {
        return (int)InvokeDynamicSupport.bootstrapStatic("intAbs", $$robo$$android_net_dhcp_DhcpPacket$intAbs(short ), 0, (short)s);
    }

    private int checksum(ByteBuffer byteBuffer, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("checksum", $$robo$$android_net_dhcp_DhcpPacket$checksum(java.nio.ByteBuffer int int int ), 0, this, byteBuffer, n, n2, n3);
    }

    protected static void addTlv(ByteBuffer byteBuffer, byte by, byte by2) {
        InvokeDynamicSupport.bootstrapStatic("addTlv", $$robo$$android_net_dhcp_DhcpPacket$addTlv(java.nio.ByteBuffer byte byte ), 0, (ByteBuffer)byteBuffer, (byte)by, (byte)by2);
    }

    protected static void addTlv(ByteBuffer byteBuffer, byte by, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("addTlv", $$robo$$android_net_dhcp_DhcpPacket$addTlv(java.nio.ByteBuffer byte byte[] ), 0, (ByteBuffer)byteBuffer, (byte)by, (byte[])byArray);
    }

    protected static void addTlv(ByteBuffer byteBuffer, byte by, Inet4Address inet4Address) {
        InvokeDynamicSupport.bootstrapStatic("addTlv", $$robo$$android_net_dhcp_DhcpPacket$addTlv(java.nio.ByteBuffer byte java.net.Inet4Address ), 0, (ByteBuffer)byteBuffer, (byte)by, (Inet4Address)inet4Address);
    }

    protected static void addTlv(ByteBuffer byteBuffer, byte by, List<Inet4Address> list) {
        InvokeDynamicSupport.bootstrapStatic("addTlv", $$robo$$android_net_dhcp_DhcpPacket$addTlv(java.nio.ByteBuffer byte java.util.List<java.net.Inet4Address> ), 0, (ByteBuffer)byteBuffer, (byte)by, list);
    }

    protected static void addTlv(ByteBuffer byteBuffer, byte by, Short s) {
        InvokeDynamicSupport.bootstrapStatic("addTlv", $$robo$$android_net_dhcp_DhcpPacket$addTlv(java.nio.ByteBuffer byte java.lang.Short ), 0, (ByteBuffer)byteBuffer, (byte)by, (Short)s);
    }

    protected static void addTlv(ByteBuffer byteBuffer, byte by, Integer n) {
        InvokeDynamicSupport.bootstrapStatic("addTlv", $$robo$$android_net_dhcp_DhcpPacket$addTlv(java.nio.ByteBuffer byte java.lang.Integer ), 0, (ByteBuffer)byteBuffer, (byte)by, (Integer)n);
    }

    protected static void addTlv(ByteBuffer byteBuffer, byte by, String string2) {
        InvokeDynamicSupport.bootstrapStatic("addTlv", $$robo$$android_net_dhcp_DhcpPacket$addTlv(java.nio.ByteBuffer byte java.lang.String ), 0, (ByteBuffer)byteBuffer, (byte)by, (String)string2);
    }

    protected static void addTlvEnd(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrapStatic("addTlvEnd", $$robo$$android_net_dhcp_DhcpPacket$addTlvEnd(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    private String getVendorId() {
        return InvokeDynamicSupport.bootstrap("getVendorId", $$robo$$android_net_dhcp_DhcpPacket$getVendorId(), 0, this);
    }

    private String getHostname() {
        return InvokeDynamicSupport.bootstrap("getHostname", $$robo$$android_net_dhcp_DhcpPacket$getHostname(), 0, this);
    }

    protected void addCommonClientTlvs(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("addCommonClientTlvs", $$robo$$android_net_dhcp_DhcpPacket$addCommonClientTlvs(java.nio.ByteBuffer ), 0, this, byteBuffer);
    }

    public static String macToString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("macToString", $$robo$$android_net_dhcp_DhcpPacket$macToString(byte[] ), 0, (byte[])byArray);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_dhcp_DhcpPacket$toString(), 0, this);
    }

    private static Inet4Address readIpAddress(ByteBuffer byteBuffer) {
        return InvokeDynamicSupport.bootstrapStatic("readIpAddress", $$robo$$android_net_dhcp_DhcpPacket$readIpAddress(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    private static String readAsciiString(ByteBuffer byteBuffer, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("readAsciiString", $$robo$$android_net_dhcp_DhcpPacket$readAsciiString(java.nio.ByteBuffer int boolean ), 0, (ByteBuffer)byteBuffer, (int)n, (boolean)bl);
    }

    private static boolean isPacketToOrFromClient(short s, short s2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPacketToOrFromClient", $$robo$$android_net_dhcp_DhcpPacket$isPacketToOrFromClient(short short ), 0, (short)s, (short)s2);
    }

    private static boolean isPacketServerToServer(short s, short s2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPacketServerToServer", $$robo$$android_net_dhcp_DhcpPacket$isPacketServerToServer(short short ), 0, (short)s, (short)s2);
    }

    static DhcpPacket decodeFullPacket(ByteBuffer byteBuffer, int n) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("decodeFullPacket", $$robo$$android_net_dhcp_DhcpPacket$decodeFullPacket(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    public static DhcpPacket decodeFullPacket(byte[] byArray, int n, int n2) throws ParseException {
        return InvokeDynamicSupport.bootstrapStatic("decodeFullPacket", $$robo$$android_net_dhcp_DhcpPacket$decodeFullPacket(byte[] int int ), 0, (byte[])byArray, (int)n, (int)n2);
    }

    public DhcpResults toDhcpResults() {
        return InvokeDynamicSupport.bootstrap("toDhcpResults", $$robo$$android_net_dhcp_DhcpPacket$toDhcpResults(), 0, this);
    }

    public long getLeaseTimeMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getLeaseTimeMillis", $$robo$$android_net_dhcp_DhcpPacket$getLeaseTimeMillis(), 0, this);
    }

    public static ByteBuffer buildDiscoverPacket(int n, int n2, short s, byte[] byArray, boolean bl, byte[] byArray2) {
        return InvokeDynamicSupport.bootstrapStatic("buildDiscoverPacket", $$robo$$android_net_dhcp_DhcpPacket$buildDiscoverPacket(int int short byte[] boolean byte[] ), 0, (int)n, (int)n2, (short)s, (byte[])byArray, (boolean)bl, (byte[])byArray2);
    }

    public static ByteBuffer buildOfferPacket(int n, int n2, boolean bl, Inet4Address inet4Address, Inet4Address inet4Address2, byte[] byArray, Integer n3, Inet4Address inet4Address3, Inet4Address inet4Address4, List<Inet4Address> list, List<Inet4Address> list2, Inet4Address inet4Address5, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildOfferPacket", $$robo$$android_net_dhcp_DhcpPacket$buildOfferPacket(int int boolean java.net.Inet4Address java.net.Inet4Address byte[] java.lang.Integer java.net.Inet4Address java.net.Inet4Address java.util.List<java.net.Inet4Address> java.util.List<java.net.Inet4Address> java.net.Inet4Address java.lang.String ), 0, (int)n, (int)n2, (boolean)bl, (Inet4Address)inet4Address, (Inet4Address)inet4Address2, (byte[])byArray, (Integer)n3, (Inet4Address)inet4Address3, (Inet4Address)inet4Address4, list, list2, (Inet4Address)inet4Address5, (String)string2);
    }

    public static ByteBuffer buildAckPacket(int n, int n2, boolean bl, Inet4Address inet4Address, Inet4Address inet4Address2, byte[] byArray, Integer n3, Inet4Address inet4Address3, Inet4Address inet4Address4, List<Inet4Address> list, List<Inet4Address> list2, Inet4Address inet4Address5, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildAckPacket", $$robo$$android_net_dhcp_DhcpPacket$buildAckPacket(int int boolean java.net.Inet4Address java.net.Inet4Address byte[] java.lang.Integer java.net.Inet4Address java.net.Inet4Address java.util.List<java.net.Inet4Address> java.util.List<java.net.Inet4Address> java.net.Inet4Address java.lang.String ), 0, (int)n, (int)n2, (boolean)bl, (Inet4Address)inet4Address, (Inet4Address)inet4Address2, (byte[])byArray, (Integer)n3, (Inet4Address)inet4Address3, (Inet4Address)inet4Address4, list, list2, (Inet4Address)inet4Address5, (String)string2);
    }

    public static ByteBuffer buildNakPacket(int n, int n2, Inet4Address inet4Address, Inet4Address inet4Address2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildNakPacket", $$robo$$android_net_dhcp_DhcpPacket$buildNakPacket(int int java.net.Inet4Address java.net.Inet4Address byte[] ), 0, (int)n, (int)n2, (Inet4Address)inet4Address, (Inet4Address)inet4Address2, (byte[])byArray);
    }

    public static ByteBuffer buildRequestPacket(int n, int n2, short s, Inet4Address inet4Address, boolean bl, byte[] byArray, Inet4Address inet4Address2, Inet4Address inet4Address3, byte[] byArray2, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildRequestPacket", $$robo$$android_net_dhcp_DhcpPacket$buildRequestPacket(int int short java.net.Inet4Address boolean byte[] java.net.Inet4Address java.net.Inet4Address byte[] java.lang.String ), 0, (int)n, (int)n2, (short)s, (Inet4Address)inet4Address, (boolean)bl, (byte[])byArray, (Inet4Address)inet4Address2, (Inet4Address)inet4Address3, (byte[])byArray2, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(DhcpPacket.class);
    }

    public /* synthetic */ DhcpPacket() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DhcpPacket)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ParseException
    extends Exception
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int errorCode;

        private void $$robo$$android_net_dhcp_DhcpPacket_ParseException$__constructor__(int errorCode, String msg, Object ... args) {
            this.errorCode = errorCode;
        }

        private void __constructor__(int n, String string2, Object ... objectArray) {
            this.$$robo$$android_net_dhcp_DhcpPacket_ParseException$__constructor__(n, string2, objectArray);
        }

        public ParseException(int n, String string2, Object ... objectArray) {
            super(String.format(string2, objectArray));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_dhcp_DhcpPacket_ParseException$__constructor__(int java.lang.String java.lang.Object[] ), 0, this, n, string2, objectArray);
        }

        public /* synthetic */ ParseException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParseException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

