/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.NetworkUtils;
import android.net.util.ConnectivityPacketSummary;
import android.net.util.InterfaceParams;
import android.net.util.PacketReader;
import android.os.Handler;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.PacketSocketAddress;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.util.HexEncoding;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConnectivityPacketTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    private static String MARK_START = "--- START ---";
    private static String MARK_STOP = "--- STOP ---";
    private static String MARK_NAMED_START = "--- START (%s) ---";
    private static String MARK_NAMED_STOP = "--- STOP (%s) ---";
    private String mTag;
    private LocalLog mLog;
    private PacketReader mPacketListener;
    private boolean mRunning;
    private String mDisplayName;

    private void $$robo$$android_net_ip_ConnectivityPacketTracker$__constructor__(Handler h, InterfaceParams ifParams, LocalLog log) {
        if (ifParams == null) {
            throw new IllegalArgumentException("null InterfaceParams");
        }
        this.mTag = TAG + "." + ifParams.name;
        this.mLog = log;
        this.mPacketListener = new PacketListener(this, h, ifParams);
    }

    private final void $$robo$$android_net_ip_ConnectivityPacketTracker$start(String displayName) {
        this.mRunning = true;
        this.mDisplayName = displayName;
        this.mPacketListener.start();
    }

    private final void $$robo$$android_net_ip_ConnectivityPacketTracker$stop() {
        this.mPacketListener.stop();
        this.mRunning = false;
        this.mDisplayName = null;
    }

    static void __staticInitializer__() {
        TAG = ConnectivityPacketTracker.class.getSimpleName();
    }

    private void __constructor__(Handler handler, InterfaceParams interfaceParams, LocalLog localLog) {
        this.$$robo$$android_net_ip_ConnectivityPacketTracker$__constructor__(handler, interfaceParams, localLog);
    }

    public ConnectivityPacketTracker(Handler handler, InterfaceParams interfaceParams, LocalLog localLog) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_ConnectivityPacketTracker$__constructor__(android.os.Handler android.net.util.InterfaceParams android.util.LocalLog ), 0, this, handler, interfaceParams, localLog);
    }

    public void start(String string2) {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_net_ip_ConnectivityPacketTracker$start(java.lang.String ), 0, this, string2);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_ip_ConnectivityPacketTracker$stop(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ConnectivityPacketTracker.class);
    }

    public /* synthetic */ ConnectivityPacketTracker() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectivityPacketTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class PacketListener
    extends PacketReader
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private InterfaceParams mInterface;
        /* synthetic */ ConnectivityPacketTracker this$0;

        private void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$__constructor__(ConnectivityPacketTracker connectivityPacketTracker, Handler h, InterfaceParams ifParams) {
            this.mInterface = ifParams;
        }

        private final FileDescriptor $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$createFd() {
            FileDescriptor s = null;
            try {
                s = Os.socket(OsConstants.AF_PACKET, OsConstants.SOCK_RAW, 0);
                NetworkUtils.attachControlPacketFilter(s, OsConstants.ARPHRD_ETHER);
                Os.bind(s, new PacketSocketAddress((short)OsConstants.ETH_P_ALL, this.mInterface.index));
            }
            catch (ErrnoException | IOException e) {
                this.logError("Failed to create packet tracking socket: ", e);
                PacketListener.closeFd(s);
                return null;
            }
            return s;
        }

        private final void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$handlePacket(byte[] recvbuf, int length) {
            String summary = ConnectivityPacketSummary.summarize(this.mInterface.macAddr, recvbuf, length);
            if (summary == null) {
                return;
            }
            this.addLogEntry(summary + "\n[" + new String(HexEncoding.encode(recvbuf, 0, length)) + "]");
        }

        private final void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$onStart() {
            String msg = TextUtils.isEmpty(this.this$0.mDisplayName) ? "--- START ---" : String.format("--- START (%s) ---", this.this$0.mDisplayName);
            this.this$0.mLog.log(msg);
        }

        private final void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$onStop() {
            String msg;
            String string2 = msg = TextUtils.isEmpty(this.this$0.mDisplayName) ? "--- STOP ---" : String.format("--- STOP (%s) ---", this.this$0.mDisplayName);
            if (!this.this$0.mRunning) {
                msg = msg + " (packet listener stopped unexpectedly)";
            }
            this.this$0.mLog.log(msg);
        }

        private final void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$logError(String msg, Exception e) {
            Log.e(this.this$0.mTag, msg, e);
            this.addLogEntry(msg + e);
        }

        private final void $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$addLogEntry(String entry) {
            this.this$0.mLog.log(entry);
        }

        private void __constructor__(ConnectivityPacketTracker connectivityPacketTracker, Handler handler, InterfaceParams interfaceParams) {
            this.$$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$__constructor__(connectivityPacketTracker, handler, interfaceParams);
        }

        PacketListener(ConnectivityPacketTracker connectivityPacketTracker, Handler handler, InterfaceParams interfaceParams) {
            this.this$0 = connectivityPacketTracker;
            super(handler, interfaceParams.defaultMtu);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$__constructor__(android.net.ip.ConnectivityPacketTracker android.os.Handler android.net.util.InterfaceParams ), 0, this, connectivityPacketTracker, handler, interfaceParams);
        }

        @Override
        protected FileDescriptor createFd() {
            return InvokeDynamicSupport.bootstrap("createFd", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$createFd(), 0, this);
        }

        @Override
        protected void handlePacket(byte[] byArray, int n) {
            InvokeDynamicSupport.bootstrap("handlePacket", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$handlePacket(byte[] int ), 0, this, byArray, n);
        }

        @Override
        protected void onStart() {
            InvokeDynamicSupport.bootstrap("onStart", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$onStart(), 0, this);
        }

        @Override
        protected void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$onStop(), 0, this);
        }

        @Override
        protected void logError(String string2, Exception exception) {
            InvokeDynamicSupport.bootstrap("logError", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$logError(java.lang.String java.lang.Exception ), 0, this, string2, exception);
        }

        private void addLogEntry(String string2) {
            InvokeDynamicSupport.bootstrap("addLogEntry", $$robo$$android_net_ip_ConnectivityPacketTracker_PacketListener$addLogEntry(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ PacketListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PacketListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

