/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.content.Context;
import android.net.DhcpResults;
import android.net.INetd;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.StaticIpConfiguration;
import android.net.apf.ApfCapabilities;
import android.net.apf.ApfFilter;
import android.net.dhcp.DhcpClient;
import android.net.ip.ConnectivityPacketTracker;
import android.net.ip.InterfaceController;
import android.net.ip.IpReachabilityMonitor;
import android.net.metrics.IpConnectivityLog;
import android.net.metrics.IpManagerEvent;
import android.net.util.InterfaceParams;
import android.net.util.MultinetworkPolicyTracker;
import android.net.util.NetdService;
import android.net.util.SharedLog;
import android.os.ConditionVariable;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IState;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.MessageUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.internal.util.WakeupMessage;
import com.android.server.net.NetlinkTracker;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IpClient
extends StateMachine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static Class[] sMessageClasses;
    private static SparseArray<String> sWhatToString;
    private static ConcurrentHashMap<String, SharedLog> sSmLogs;
    private static ConcurrentHashMap<String, LocalLog> sPktLogs;
    public static String DUMP_ARG = "ipclient";
    public static String DUMP_ARG_CONFIRM = "confirm";
    private static int CMD_TERMINATE_AFTER_STOP = 1;
    private static int CMD_STOP = 2;
    private static int CMD_START = 3;
    private static int CMD_CONFIRM = 4;
    private static int EVENT_PRE_DHCP_ACTION_COMPLETE = 5;
    private static int EVENT_NETLINK_LINKPROPERTIES_CHANGED = 6;
    private static int CMD_UPDATE_TCP_BUFFER_SIZES = 7;
    private static int CMD_UPDATE_HTTP_PROXY = 8;
    private static int CMD_SET_MULTICAST_FILTER = 9;
    private static int EVENT_PROVISIONING_TIMEOUT = 10;
    private static int EVENT_DHCPACTION_TIMEOUT = 11;
    private static int EVENT_READ_PACKET_FILTER_COMPLETE = 12;
    private static int MAX_LOG_RECORDS = 500;
    private static int MAX_PACKET_RECORDS = 100;
    private static boolean NO_CALLBACKS = false;
    private static boolean SEND_CALLBACKS = true;
    private static String CLAT_PREFIX = "v4-";
    private static int IMMEDIATE_FAILURE_DURATION = 0;
    private State mStoppedState;
    private State mStoppingState;
    private State mStartedState;
    private State mRunningState;
    private String mTag;
    private Context mContext;
    private String mInterfaceName;
    private String mClatInterfaceName;
    @VisibleForTesting
    protected Callback mCallback;
    private Dependencies mDependencies;
    private CountDownLatch mShutdownLatch;
    private INetworkManagementService mNwService;
    private NetlinkTracker mNetlinkTracker;
    private WakeupMessage mProvisioningTimeoutAlarm;
    private WakeupMessage mDhcpActionTimeoutAlarm;
    private SharedLog mLog;
    private LocalLog mConnectivityPacketLog;
    private MessageHandlingLogger mMsgStateLogger;
    private IpConnectivityLog mMetricsLog;
    private InterfaceController mInterfaceCtrl;
    private InterfaceParams mInterfaceParams;
    private LinkProperties mLinkProperties;
    private ProvisioningConfiguration mConfiguration;
    private MultinetworkPolicyTracker mMultinetworkPolicyTracker;
    private IpReachabilityMonitor mIpReachabilityMonitor;
    private DhcpClient mDhcpClient;
    private DhcpResults mDhcpResults;
    private String mTcpBufferSizes;
    private ProxyInfo mHttpProxy;
    private ApfFilter mApfFilter;
    private boolean mMulticastFiltering;
    private long mStartTimeMillis;
    private ConditionVariable mApfDataSnapshotComplete;

    private static final void $$robo$$android_net_ip_IpClient$dumpAllLogs(PrintWriter writer, String[] args) {
        for (String ifname : sSmLogs.keySet()) {
            if (!ArrayUtils.isEmpty(args) && !ArrayUtils.contains(args, ifname)) continue;
            writer.println(String.format("--- BEGIN %s ---", ifname));
            SharedLog smLog = sSmLogs.get(ifname);
            if (smLog != null) {
                writer.println("State machine log:");
                smLog.dump(null, writer, null);
            }
            writer.println("");
            LocalLog pktLog = sPktLogs.get(ifname);
            if (pktLog != null) {
                writer.println("Connectivity packet log:");
                pktLog.readOnlyLocalLog().dump(null, writer, null);
            }
            writer.println(String.format("--- END %s ---", ifname));
        }
    }

    private void $$robo$$android_net_ip_IpClient$__constructor__(Context context, String ifName, Callback callback) {
    }

    private void $$robo$$android_net_ip_IpClient$__constructor__(Context context, String ifName, Callback callback, INetworkManagementService nwService) {
    }

    @VisibleForTesting
    private void $$robo$$android_net_ip_IpClient$__constructor__(Context context, String ifName, Callback callback, Dependencies deps) {
        this.mStoppedState = new StoppedState(this);
        this.mStoppingState = new StoppingState(this);
        this.mStartedState = new StartedState(this);
        this.mRunningState = new RunningState(this);
        this.mMetricsLog = new IpConnectivityLog();
        this.mApfDataSnapshotComplete = new ConditionVariable();
        Preconditions.checkNotNull(ifName);
        Preconditions.checkNotNull(callback);
        this.mTag = this.getName();
        this.mContext = context;
        this.mInterfaceName = ifName;
        this.mClatInterfaceName = "v4-" + ifName;
        this.mCallback = new LoggingCallbackWrapper(this, callback);
        this.mDependencies = deps;
        this.mShutdownLatch = new CountDownLatch(1);
        this.mNwService = deps.getNMS();
        sSmLogs.putIfAbsent(this.mInterfaceName, new SharedLog(500, this.mTag));
        this.mLog = sSmLogs.get(this.mInterfaceName);
        sPktLogs.putIfAbsent(this.mInterfaceName, new LocalLog(100));
        this.mConnectivityPacketLog = sPktLogs.get(this.mInterfaceName);
        this.mMsgStateLogger = new MessageHandlingLogger();
        this.mInterfaceCtrl = new InterfaceController(this.mInterfaceName, this.mNwService, deps.getNetd(), this.mLog);
        this.mNetlinkTracker = new ShadowedObject(this, this.mInterfaceName, new NetlinkTracker.Callback(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IpClient this$0;

            private void $$robo$$android_net_ip_IpClient_2$__constructor__(IpClient this$0) {
            }

            private final void $$robo$$android_net_ip_IpClient_2$update() {
                this.this$0.sendMessage(6);
            }

            private void __constructor__(IpClient ipClient) {
                this.$$robo$$android_net_ip_IpClient_2$__constructor__(ipClient);
            }
            {
                this.this$0 = ipClient;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_2$__constructor__(android.net.ip.IpClient ), 0, this, ipClient);
            }

            @Override
            public void update() {
                InvokeDynamicSupport.bootstrap("update", $$robo$$android_net_ip_IpClient_2$update(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IpClient this$0;

            private void $$robo$$android_net_ip_IpClient_3$__constructor__(IpClient this$0, String x0, NetlinkTracker.Callback x1) {
            }

            private final void $$robo$$android_net_ip_IpClient_3$interfaceAdded(String iface) {
                super.interfaceAdded(iface);
                if (this.this$0.mClatInterfaceName.equals(iface)) {
                    this.this$0.mCallback.setNeighborDiscoveryOffload(false);
                } else if (!this.this$0.mInterfaceName.equals(iface)) {
                    return;
                }
                String msg = "interfaceAdded(" + iface + ")";
                this.logMsg(msg);
            }

            private final void $$robo$$android_net_ip_IpClient_3$interfaceRemoved(String iface) {
                super.interfaceRemoved(iface);
                if (this.this$0.mClatInterfaceName.equals(iface)) {
                    this.this$0.mCallback.setNeighborDiscoveryOffload(true);
                } else if (!this.this$0.mInterfaceName.equals(iface)) {
                    return;
                }
                String msg = "interfaceRemoved(" + iface + ")";
                this.logMsg(msg);
            }

            private final void $$robo$$android_net_ip_IpClient_3$logMsg(String msg) {
                Log.d(this.this$0.mTag, msg);
                this.this$0.getHandler().post(() -> this.this$0.mLog.log("OBSERVED " + msg));
            }

            private void __constructor__(IpClient ipClient, String string2, NetlinkTracker.Callback callback) {
                this.$$robo$$android_net_ip_IpClient_3$__constructor__(ipClient, string2, callback);
            }
            {
                this.this$0 = ipClient;
                super(string2, callback);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_3$__constructor__(android.net.ip.IpClient java.lang.String com.android.server.net.NetlinkTracker$Callback ), 0, this, ipClient, string2, callback);
            }

            @Override
            public void interfaceAdded(String string2) {
                InvokeDynamicSupport.bootstrap("interfaceAdded", $$robo$$android_net_ip_IpClient_3$interfaceAdded(java.lang.String ), 0, this, string2);
            }

            @Override
            public void interfaceRemoved(String string2) {
                InvokeDynamicSupport.bootstrap("interfaceRemoved", $$robo$$android_net_ip_IpClient_3$interfaceRemoved(java.lang.String ), 0, this, string2);
            }

            private void logMsg(String string2) {
                InvokeDynamicSupport.bootstrap("logMsg", $$robo$$android_net_ip_IpClient_3$logMsg(java.lang.String ), 0, this, string2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mLinkProperties = new LinkProperties();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
        this.mProvisioningTimeoutAlarm = new WakeupMessage(this.mContext, this.getHandler(), this.mTag + ".EVENT_PROVISIONING_TIMEOUT", 10);
        this.mDhcpActionTimeoutAlarm = new WakeupMessage(this.mContext, this.getHandler(), this.mTag + ".EVENT_DHCPACTION_TIMEOUT", 11);
        this.configureAndStartStateMachine();
        this.startStateMachineUpdaters();
    }

    private final void $$robo$$android_net_ip_IpClient$configureAndStartStateMachine() {
        this.addState(this.mStoppedState);
        this.addState(this.mStartedState);
        this.addState(this.mRunningState, this.mStartedState);
        this.addState(this.mStoppingState);
        this.setInitialState(this.mStoppedState);
        super.start();
    }

    private final void $$robo$$android_net_ip_IpClient$startStateMachineUpdaters() {
        try {
            this.mNwService.registerObserver(this.mNetlinkTracker);
        }
        catch (RemoteException e) {
            this.logError("Couldn't register NetlinkTracker: %s", e);
        }
    }

    private final void $$robo$$android_net_ip_IpClient$stopStateMachineUpdaters() {
        try {
            this.mNwService.unregisterObserver(this.mNetlinkTracker);
        }
        catch (RemoteException e) {
            this.logError("Couldn't unregister NetlinkTracker: %s", e);
        }
    }

    private final void $$robo$$android_net_ip_IpClient$onQuitting() {
        this.mCallback.onQuit();
        this.mShutdownLatch.countDown();
    }

    private final void $$robo$$android_net_ip_IpClient$shutdown() {
        this.stop();
        this.sendMessage(1);
    }

    private final void $$robo$$android_net_ip_IpClient$awaitShutdown() {
        try {
            this.mShutdownLatch.await();
        }
        catch (InterruptedException e) {
            this.mLog.e("Interrupted while awaiting shutdown: " + e);
        }
    }

    private static final ProvisioningConfiguration.Builder $$robo$$android_net_ip_IpClient$buildProvisioningConfiguration() {
        return new ProvisioningConfiguration.Builder();
    }

    private final void $$robo$$android_net_ip_IpClient$startProvisioning(ProvisioningConfiguration req) {
        if (!req.isValid()) {
            this.doImmediateProvisioningFailure(7);
            return;
        }
        this.mInterfaceParams = this.mDependencies.getInterfaceParams(this.mInterfaceName);
        if (this.mInterfaceParams == null) {
            this.logError("Failed to find InterfaceParams for " + this.mInterfaceName, new Object[0]);
            this.doImmediateProvisioningFailure(8);
            return;
        }
        this.mCallback.setNeighborDiscoveryOffload(true);
        this.sendMessage(3, new ProvisioningConfiguration(req));
    }

    private final void $$robo$$android_net_ip_IpClient$startProvisioning(StaticIpConfiguration staticIpConfig) {
        this.startProvisioning(IpClient.buildProvisioningConfiguration().withStaticConfiguration(staticIpConfig).build());
    }

    private final void $$robo$$android_net_ip_IpClient$startProvisioning() {
        this.startProvisioning(new ProvisioningConfiguration());
    }

    private final void $$robo$$android_net_ip_IpClient$stop() {
        this.sendMessage(2);
    }

    private final void $$robo$$android_net_ip_IpClient$confirmConfiguration() {
        this.sendMessage(4);
    }

    private final void $$robo$$android_net_ip_IpClient$completedPreDhcpAction() {
        this.sendMessage(5);
    }

    private final void $$robo$$android_net_ip_IpClient$readPacketFilterComplete(byte[] data) {
        this.sendMessage(12, data);
    }

    private final void $$robo$$android_net_ip_IpClient$setTcpBufferSizes(String tcpBufferSizes) {
        this.sendMessage(7, tcpBufferSizes);
    }

    private final void $$robo$$android_net_ip_IpClient$setHttpProxy(ProxyInfo proxyInfo) {
        this.sendMessage(8, proxyInfo);
    }

    private final void $$robo$$android_net_ip_IpClient$setMulticastFilter(boolean enabled) {
        this.sendMessage(9, enabled);
    }

    private final void $$robo$$android_net_ip_IpClient$dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (args != null && args.length > 0 && "confirm".equals(args[0])) {
            this.confirmConfiguration();
            return;
        }
        ApfFilter apfFilter = this.mApfFilter;
        ProvisioningConfiguration provisioningConfig = this.mConfiguration;
        ApfCapabilities apfCapabilities = provisioningConfig != null ? provisioningConfig.mApfCapabilities : null;
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(this.mTag + " APF dump:");
        pw.increaseIndent();
        if (apfFilter != null) {
            if (apfCapabilities.hasDataAccess()) {
                this.mApfDataSnapshotComplete.close();
                this.mCallback.startReadPacketFilter();
                if (!this.mApfDataSnapshotComplete.block(1000L)) {
                    pw.print("TIMEOUT: DUMPING STALE APF SNAPSHOT");
                }
            }
            apfFilter.dump(pw);
        } else {
            pw.print("No active ApfFilter; ");
            if (provisioningConfig == null) {
                pw.println("IpClient not yet started.");
            } else if (apfCapabilities == null || apfCapabilities.apfVersionSupported == 0) {
                pw.println("Hardware does not support APF.");
            } else {
                pw.println("ApfFilter not yet started, APF capabilities: " + apfCapabilities);
            }
        }
        pw.decreaseIndent();
        pw.println();
        pw.println(this.mTag + " current ProvisioningConfiguration:");
        pw.increaseIndent();
        pw.println(Objects.toString(provisioningConfig, "N/A"));
        pw.decreaseIndent();
        IpReachabilityMonitor iprm = this.mIpReachabilityMonitor;
        if (iprm != null) {
            pw.println();
            pw.println(this.mTag + " current IpReachabilityMonitor state:");
            pw.increaseIndent();
            iprm.dump(pw);
            pw.decreaseIndent();
        }
        pw.println();
        pw.println(this.mTag + " StateMachine dump:");
        pw.increaseIndent();
        this.mLog.dump(fd, pw, args);
        pw.decreaseIndent();
        pw.println();
        pw.println(this.mTag + " connectivity packet log:");
        pw.println();
        pw.println("Debug with python and scapy via:");
        pw.println("shell$ python");
        pw.println(">>> from scapy import all as scapy");
        pw.println(">>> scapy.Ether(\"<paste_hex_string>\".decode(\"hex\")).show2()");
        pw.println();
        pw.increaseIndent();
        this.mConnectivityPacketLog.readOnlyLocalLog().dump(fd, pw, args);
        pw.decreaseIndent();
    }

    private final String $$robo$$android_net_ip_IpClient$getWhatToString(int what) {
        return sWhatToString.get(what, "UNKNOWN: " + Integer.toString(what));
    }

    private final String $$robo$$android_net_ip_IpClient$getLogRecString(Message msg) {
        String logLine = String.format("%s/%d %d %d %s [%s]", this.mInterfaceName, this.mInterfaceParams == null ? -1 : this.mInterfaceParams.index, msg.arg1, msg.arg2, Objects.toString(msg.obj), this.mMsgStateLogger);
        String richerLogLine = this.getWhatToString(msg.what) + " " + logLine;
        this.mLog.log(richerLogLine);
        this.mMsgStateLogger.reset();
        return logLine;
    }

    private final boolean $$robo$$android_net_ip_IpClient$recordLogRec(Message msg) {
        boolean shouldLog;
        boolean bl = shouldLog = msg.what != 6;
        if (!shouldLog) {
            this.mMsgStateLogger.reset();
        }
        return shouldLog;
    }

    private final void $$robo$$android_net_ip_IpClient$logError(String fmt, Object ... args) {
        String msg = "ERROR " + String.format(fmt, args);
        Log.e(this.mTag, msg);
        this.mLog.log(msg);
    }

    private final void $$robo$$android_net_ip_IpClient$resetLinkProperties() {
        this.mNetlinkTracker.clearLinkProperties();
        this.mConfiguration = null;
        this.mDhcpResults = null;
        this.mTcpBufferSizes = "";
        this.mHttpProxy = null;
        this.mLinkProperties = new LinkProperties();
        this.mLinkProperties.setInterfaceName(this.mInterfaceName);
    }

    private final void $$robo$$android_net_ip_IpClient$recordMetric(int type) {
        long duration = this.mStartTimeMillis > 0L ? SystemClock.elapsedRealtime() - this.mStartTimeMillis : 0L;
        this.mMetricsLog.log(this.mInterfaceName, (Parcelable)new IpManagerEvent(type, duration));
    }

    @VisibleForTesting
    private static final boolean $$robo$$android_net_ip_IpClient$isProvisioned(LinkProperties lp, InitialConfiguration config) {
        if (lp.hasIPv4Address() || lp.isProvisioned()) {
            return true;
        }
        if (config == null) {
            return false;
        }
        return config.isProvisionedBy(lp.getLinkAddresses(), lp.getRoutes());
    }

    private final LinkProperties.ProvisioningChange $$robo$$android_net_ip_IpClient$compareProvisioning(LinkProperties oldLp, LinkProperties newLp) {
        boolean ignoreIPv6ProvisioningLoss;
        InitialConfiguration config = this.mConfiguration != null ? this.mConfiguration.mInitialConfig : null;
        boolean wasProvisioned = IpClient.isProvisioned(oldLp, config);
        boolean isProvisioned = IpClient.isProvisioned(newLp, config);
        LinkProperties.ProvisioningChange delta = !wasProvisioned && isProvisioned ? LinkProperties.ProvisioningChange.GAINED_PROVISIONING : (wasProvisioned && isProvisioned ? LinkProperties.ProvisioningChange.STILL_PROVISIONED : (!wasProvisioned && !isProvisioned ? LinkProperties.ProvisioningChange.STILL_NOT_PROVISIONED : LinkProperties.ProvisioningChange.LOST_PROVISIONING));
        boolean lostIPv6 = oldLp.isIPv6Provisioned() && !newLp.isIPv6Provisioned();
        boolean lostIPv4Address = oldLp.hasIPv4Address() && !newLp.hasIPv4Address();
        boolean lostIPv6Router = oldLp.hasIPv6DefaultRoute() && !newLp.hasIPv6DefaultRoute();
        boolean bl = ignoreIPv6ProvisioningLoss = this.mMultinetworkPolicyTracker != null && !this.mMultinetworkPolicyTracker.getAvoidBadWifi();
        if (lostIPv4Address || lostIPv6 && !ignoreIPv6ProvisioningLoss) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        if (oldLp.hasGlobalIPv6Address() && lostIPv6Router && !ignoreIPv6ProvisioningLoss) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        return delta;
    }

    private final void $$robo$$android_net_ip_IpClient$dispatchCallback(LinkProperties.ProvisioningChange delta, LinkProperties newLp) {
        switch (5.$SwitchMap$android$net$LinkProperties$ProvisioningChange[delta.ordinal()]) {
            case 1: {
                this.recordMetric(1);
                this.mCallback.onProvisioningSuccess(newLp);
                break;
            }
            case 2: {
                this.recordMetric(2);
                this.mCallback.onProvisioningFailure(newLp);
                break;
            }
            default: {
                this.mCallback.onLinkPropertiesChange(newLp);
            }
        }
    }

    private final LinkProperties.ProvisioningChange $$robo$$android_net_ip_IpClient$setLinkProperties(LinkProperties newLp) {
        if (this.mApfFilter != null) {
            this.mApfFilter.setLinkProperties(newLp);
        }
        if (this.mIpReachabilityMonitor != null) {
            this.mIpReachabilityMonitor.updateLinkProperties(newLp);
        }
        LinkProperties.ProvisioningChange delta = this.compareProvisioning(this.mLinkProperties, newLp);
        this.mLinkProperties = new LinkProperties(newLp);
        if (delta == LinkProperties.ProvisioningChange.GAINED_PROVISIONING) {
            this.mProvisioningTimeoutAlarm.cancel();
        }
        return delta;
    }

    private final LinkProperties $$robo$$android_net_ip_IpClient$assembleLinkProperties() {
        LinkProperties newLp = new LinkProperties();
        newLp.setInterfaceName(this.mInterfaceName);
        LinkProperties netlinkLinkProperties = this.mNetlinkTracker.getLinkProperties();
        newLp.setLinkAddresses(netlinkLinkProperties.getLinkAddresses());
        for (RouteInfo route : netlinkLinkProperties.getRoutes()) {
            newLp.addRoute(route);
        }
        IpClient.addAllReachableDnsServers(newLp, netlinkLinkProperties.getDnsServers());
        if (this.mDhcpResults != null) {
            for (RouteInfo route : this.mDhcpResults.getRoutes(this.mInterfaceName)) {
                newLp.addRoute(route);
            }
            IpClient.addAllReachableDnsServers(newLp, this.mDhcpResults.dnsServers);
            newLp.setDomains(this.mDhcpResults.domains);
            if (this.mDhcpResults.mtu != 0) {
                newLp.setMtu(this.mDhcpResults.mtu);
            }
        }
        if (!TextUtils.isEmpty(this.mTcpBufferSizes)) {
            newLp.setTcpBufferSizes(this.mTcpBufferSizes);
        }
        if (this.mHttpProxy != null) {
            newLp.setHttpProxy(this.mHttpProxy);
        }
        if (this.mConfiguration != null && this.mConfiguration.mInitialConfig != null) {
            InitialConfiguration config = this.mConfiguration.mInitialConfig;
            if (config.isProvisionedBy(newLp.getLinkAddresses(), null)) {
                for (IpPrefix prefix : config.directlyConnectedRoutes) {
                    newLp.addRoute(new RouteInfo(prefix, null, this.mInterfaceName));
                }
            }
            IpClient.addAllReachableDnsServers(newLp, config.dnsServers);
        }
        LinkProperties oldLp = this.mLinkProperties;
        return newLp;
    }

    private static final void $$robo$$android_net_ip_IpClient$addAllReachableDnsServers(LinkProperties lp, Iterable<InetAddress> dnses) {
        for (InetAddress dns : dnses) {
            if (dns.isAnyLocalAddress() || !lp.isReachable(dns)) continue;
            lp.addDnsServer(dns);
        }
    }

    private final boolean $$robo$$android_net_ip_IpClient$handleLinkPropertiesUpdate(boolean sendCallbacks) {
        LinkProperties newLp = this.assembleLinkProperties();
        if (Objects.equals(newLp, this.mLinkProperties)) {
            return true;
        }
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        if (sendCallbacks) {
            this.dispatchCallback(delta, newLp);
        }
        return delta != LinkProperties.ProvisioningChange.LOST_PROVISIONING;
    }

    private final void $$robo$$android_net_ip_IpClient$handleIPv4Success(DhcpResults dhcpResults) {
        this.mDhcpResults = new DhcpResults(dhcpResults);
        LinkProperties newLp = this.assembleLinkProperties();
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        this.mCallback.onNewDhcpResults(dhcpResults);
        this.dispatchCallback(delta, newLp);
    }

    private final void $$robo$$android_net_ip_IpClient$handleIPv4Failure() {
        this.mInterfaceCtrl.clearIPv4Address();
        this.mDhcpResults = null;
        this.mCallback.onNewDhcpResults(null);
        this.handleProvisioningFailure();
    }

    private final void $$robo$$android_net_ip_IpClient$handleProvisioningFailure() {
        LinkProperties newLp = this.assembleLinkProperties();
        LinkProperties.ProvisioningChange delta = this.setLinkProperties(newLp);
        if (delta == LinkProperties.ProvisioningChange.STILL_NOT_PROVISIONED) {
            delta = LinkProperties.ProvisioningChange.LOST_PROVISIONING;
        }
        this.dispatchCallback(delta, newLp);
        if (delta == LinkProperties.ProvisioningChange.LOST_PROVISIONING) {
            this.transitionTo(this.mStoppingState);
        }
    }

    private final void $$robo$$android_net_ip_IpClient$doImmediateProvisioningFailure(int failureType) {
        this.logError("onProvisioningFailure(): %s", failureType);
        this.recordMetric(failureType);
        this.mCallback.onProvisioningFailure(new LinkProperties(this.mLinkProperties));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean $$robo$$android_net_ip_IpClient$startIPv4() {
        if (this.mConfiguration.mStaticIpConfig != null) {
            if (!this.mInterfaceCtrl.setIPv4Address(this.mConfiguration.mStaticIpConfig.ipAddress)) return false;
            this.handleIPv4Success(new DhcpResults(this.mConfiguration.mStaticIpConfig));
            return true;
        } else {
            this.mDhcpClient = DhcpClient.makeDhcpClient(this.mContext, this, this.mInterfaceParams);
            this.mDhcpClient.registerForPreDhcpNotification();
            this.mDhcpClient.sendMessage(196609);
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_IpClient$startIPv6() {
        return this.mInterfaceCtrl.setIPv6PrivacyExtensions(true) && this.mInterfaceCtrl.setIPv6AddrGenModeIfSupported(this.mConfiguration.mIPv6AddrGenMode) && this.mInterfaceCtrl.enableIPv6();
    }

    private final boolean $$robo$$android_net_ip_IpClient$applyInitialConfig(InitialConfiguration config) {
        for (LinkAddress addr : IpClient.findAll(config.ipAddresses, LinkAddress::isIPv6)) {
            if (this.mInterfaceCtrl.addAddress(addr)) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_ip_IpClient$startIpReachabilityMonitor() {
        try {
            this.mIpReachabilityMonitor = new IpReachabilityMonitor(this.mContext, this.mInterfaceParams, this.getHandler(), this.mLog, new IpReachabilityMonitor.Callback(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IpClient this$0;

                private void $$robo$$android_net_ip_IpClient_4$__constructor__(IpClient this$0) {
                }

                private final void $$robo$$android_net_ip_IpClient_4$notifyLost(InetAddress ip, String logMsg) {
                    this.this$0.mCallback.onReachabilityLost(logMsg);
                }

                private void __constructor__(IpClient ipClient) {
                    this.$$robo$$android_net_ip_IpClient_4$__constructor__(ipClient);
                }
                {
                    this.this$0 = ipClient;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_4$__constructor__(android.net.ip.IpClient ), 0, this, ipClient);
                }

                @Override
                public void notifyLost(InetAddress inetAddress, String string2) {
                    InvokeDynamicSupport.bootstrap("notifyLost", $$robo$$android_net_ip_IpClient_4$notifyLost(java.net.InetAddress java.lang.String ), 0, this, inetAddress, string2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }, this.mMultinetworkPolicyTracker);
        }
        catch (IllegalArgumentException iae) {
            this.logError("IpReachabilityMonitor failure: %s", iae);
            this.mIpReachabilityMonitor = null;
        }
        return this.mIpReachabilityMonitor != null;
    }

    private final void $$robo$$android_net_ip_IpClient$stopAllIP() {
        this.mInterfaceCtrl.disableIPv6();
        this.mInterfaceCtrl.clearAllAddresses();
    }

    private static final <T> boolean $$robo$$android_net_ip_IpClient$any(Iterable<T> coll, Predicate<T> fn) {
        for (T t : coll) {
            if (!fn.test(t)) continue;
            return true;
        }
        return false;
    }

    private static final <T> boolean $$robo$$android_net_ip_IpClient$all(Iterable<T> coll, Predicate<T> fn) {
        return !IpClient.any(coll, IpClient.not(fn));
    }

    private static final <T> Predicate<T> $$robo$$android_net_ip_IpClient$not(Predicate<T> fn) {
        return t -> !fn.test(t);
    }

    private static final <T> String $$robo$$android_net_ip_IpClient$join(String delimiter, Collection<T> coll) {
        return coll.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    private static final <T> T $$robo$$android_net_ip_IpClient$find(Iterable<T> coll, Predicate<T> fn) {
        for (T t : coll) {
            if (!fn.test(t)) continue;
            return t;
        }
        return null;
    }

    private static final <T> List<T> $$robo$$android_net_ip_IpClient$findAll(Collection<T> coll, Predicate<T> fn) {
        return coll.stream().filter(fn).collect(Collectors.toList());
    }

    static void __staticInitializer__() {
        sMessageClasses = new Class[]{IpClient.class, DhcpClient.class};
        sWhatToString = MessageUtils.findMessageNames(sMessageClasses);
        sSmLogs = new ConcurrentHashMap();
        sPktLogs = new ConcurrentHashMap();
    }

    public static void dumpAllLogs(PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("dumpAllLogs", $$robo$$android_net_ip_IpClient$dumpAllLogs(java.io.PrintWriter java.lang.String[] ), 0, (PrintWriter)printWriter, (String[])stringArray);
    }

    private void __constructor__(Context context, String string2, Callback callback) {
        this.$$robo$$android_net_ip_IpClient$__constructor__(context, string2, callback);
    }

    public IpClient(Context context, String string2, Callback callback) {
        this(context, string2, callback, new Dependencies());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient$__constructor__(android.content.Context java.lang.String android.net.ip.IpClient$Callback ), 0, this, context, string2, callback);
    }

    private void __constructor__(Context context, String string2, Callback callback, INetworkManagementService iNetworkManagementService) {
        this.$$robo$$android_net_ip_IpClient$__constructor__(context, string2, callback, iNetworkManagementService);
    }

    public IpClient(Context context, String string2, Callback callback, INetworkManagementService iNetworkManagementService) {
        this(context, string2, callback, (Dependencies)new ShadowedObject(iNetworkManagementService){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ INetworkManagementService val$nwService;

            private void $$robo$$android_net_ip_IpClient_1$__constructor__(INetworkManagementService iNetworkManagementService) {
            }

            private final INetworkManagementService $$robo$$android_net_ip_IpClient_1$getNMS() {
                return this.val$nwService;
            }

            private void __constructor__(INetworkManagementService iNetworkManagementService) {
                this.$$robo$$android_net_ip_IpClient_1$__constructor__(iNetworkManagementService);
            }
            {
                this.val$nwService = iNetworkManagementService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_1$__constructor__(android.os.INetworkManagementService ), 0, this, iNetworkManagementService);
            }

            @Override
            public INetworkManagementService getNMS() {
                return InvokeDynamicSupport.bootstrap("getNMS", $$robo$$android_net_ip_IpClient_1$getNMS(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient$__constructor__(android.content.Context java.lang.String android.net.ip.IpClient$Callback android.os.INetworkManagementService ), 0, this, context, string2, callback, iNetworkManagementService);
    }

    private void __constructor__(Context context, String string2, Callback callback, Dependencies dependencies) {
        this.$$robo$$android_net_ip_IpClient$__constructor__(context, string2, callback, dependencies);
    }

    IpClient(Context context, String string2, Callback callback, Dependencies dependencies) {
        super(IpClient.class.getSimpleName() + "." + string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient$__constructor__(android.content.Context java.lang.String android.net.ip.IpClient$Callback android.net.ip.IpClient$Dependencies ), 0, this, context, string2, callback, dependencies);
    }

    private void configureAndStartStateMachine() {
        InvokeDynamicSupport.bootstrap("configureAndStartStateMachine", $$robo$$android_net_ip_IpClient$configureAndStartStateMachine(), 0, this);
    }

    private void startStateMachineUpdaters() {
        InvokeDynamicSupport.bootstrap("startStateMachineUpdaters", $$robo$$android_net_ip_IpClient$startStateMachineUpdaters(), 0, this);
    }

    private void stopStateMachineUpdaters() {
        InvokeDynamicSupport.bootstrap("stopStateMachineUpdaters", $$robo$$android_net_ip_IpClient$stopStateMachineUpdaters(), 0, this);
    }

    @Override
    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$android_net_ip_IpClient$onQuitting(), 0, this);
    }

    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_net_ip_IpClient$shutdown(), 0, this);
    }

    public void awaitShutdown() {
        InvokeDynamicSupport.bootstrap("awaitShutdown", $$robo$$android_net_ip_IpClient$awaitShutdown(), 0, this);
    }

    public static ProvisioningConfiguration.Builder buildProvisioningConfiguration() {
        return InvokeDynamicSupport.bootstrapStatic("buildProvisioningConfiguration", $$robo$$android_net_ip_IpClient$buildProvisioningConfiguration(), 0);
    }

    public void startProvisioning(ProvisioningConfiguration provisioningConfiguration) {
        InvokeDynamicSupport.bootstrap("startProvisioning", $$robo$$android_net_ip_IpClient$startProvisioning(android.net.ip.IpClient$ProvisioningConfiguration ), 0, this, provisioningConfiguration);
    }

    public void startProvisioning(StaticIpConfiguration staticIpConfiguration) {
        InvokeDynamicSupport.bootstrap("startProvisioning", $$robo$$android_net_ip_IpClient$startProvisioning(android.net.StaticIpConfiguration ), 0, this, staticIpConfiguration);
    }

    public void startProvisioning() {
        InvokeDynamicSupport.bootstrap("startProvisioning", $$robo$$android_net_ip_IpClient$startProvisioning(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_ip_IpClient$stop(), 0, this);
    }

    public void confirmConfiguration() {
        InvokeDynamicSupport.bootstrap("confirmConfiguration", $$robo$$android_net_ip_IpClient$confirmConfiguration(), 0, this);
    }

    public void completedPreDhcpAction() {
        InvokeDynamicSupport.bootstrap("completedPreDhcpAction", $$robo$$android_net_ip_IpClient$completedPreDhcpAction(), 0, this);
    }

    public void readPacketFilterComplete(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("readPacketFilterComplete", $$robo$$android_net_ip_IpClient$readPacketFilterComplete(byte[] ), 0, this, byArray);
    }

    public void setTcpBufferSizes(String string2) {
        InvokeDynamicSupport.bootstrap("setTcpBufferSizes", $$robo$$android_net_ip_IpClient$setTcpBufferSizes(java.lang.String ), 0, this, string2);
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setHttpProxy", $$robo$$android_net_ip_IpClient$setHttpProxy(android.net.ProxyInfo ), 0, this, proxyInfo);
    }

    public void setMulticastFilter(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMulticastFilter", $$robo$$android_net_ip_IpClient$setMulticastFilter(boolean ), 0, this, bl);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_ip_IpClient$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    protected String getWhatToString(int n) {
        return InvokeDynamicSupport.bootstrap("getWhatToString", $$robo$$android_net_ip_IpClient$getWhatToString(int ), 0, this, n);
    }

    @Override
    protected String getLogRecString(Message message) {
        return InvokeDynamicSupport.bootstrap("getLogRecString", $$robo$$android_net_ip_IpClient$getLogRecString(android.os.Message ), 0, this, message);
    }

    @Override
    protected boolean recordLogRec(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("recordLogRec", $$robo$$android_net_ip_IpClient$recordLogRec(android.os.Message ), 0, this, message);
    }

    private void logError(String string2, Object ... objectArray) {
        InvokeDynamicSupport.bootstrap("logError", $$robo$$android_net_ip_IpClient$logError(java.lang.String java.lang.Object[] ), 0, this, string2, objectArray);
    }

    private void resetLinkProperties() {
        InvokeDynamicSupport.bootstrap("resetLinkProperties", $$robo$$android_net_ip_IpClient$resetLinkProperties(), 0, this);
    }

    private void recordMetric(int n) {
        InvokeDynamicSupport.bootstrap("recordMetric", $$robo$$android_net_ip_IpClient$recordMetric(int ), 0, this, n);
    }

    static boolean isProvisioned(LinkProperties linkProperties, InitialConfiguration initialConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isProvisioned", $$robo$$android_net_ip_IpClient$isProvisioned(android.net.LinkProperties android.net.ip.IpClient$InitialConfiguration ), 0, (LinkProperties)linkProperties, (InitialConfiguration)initialConfiguration);
    }

    private LinkProperties.ProvisioningChange compareProvisioning(LinkProperties linkProperties, LinkProperties linkProperties2) {
        return InvokeDynamicSupport.bootstrap("compareProvisioning", $$robo$$android_net_ip_IpClient$compareProvisioning(android.net.LinkProperties android.net.LinkProperties ), 0, this, linkProperties, linkProperties2);
    }

    private void dispatchCallback(LinkProperties.ProvisioningChange provisioningChange, LinkProperties linkProperties) {
        InvokeDynamicSupport.bootstrap("dispatchCallback", $$robo$$android_net_ip_IpClient$dispatchCallback(android.net.LinkProperties$ProvisioningChange android.net.LinkProperties ), 0, this, provisioningChange, linkProperties);
    }

    private LinkProperties.ProvisioningChange setLinkProperties(LinkProperties linkProperties) {
        return InvokeDynamicSupport.bootstrap("setLinkProperties", $$robo$$android_net_ip_IpClient$setLinkProperties(android.net.LinkProperties ), 0, this, linkProperties);
    }

    private LinkProperties assembleLinkProperties() {
        return InvokeDynamicSupport.bootstrap("assembleLinkProperties", $$robo$$android_net_ip_IpClient$assembleLinkProperties(), 0, this);
    }

    private static void addAllReachableDnsServers(LinkProperties linkProperties, Iterable<InetAddress> iterable) {
        InvokeDynamicSupport.bootstrapStatic("addAllReachableDnsServers", $$robo$$android_net_ip_IpClient$addAllReachableDnsServers(android.net.LinkProperties java.lang.Iterable<java.net.InetAddress> ), 0, (LinkProperties)linkProperties, iterable);
    }

    private boolean handleLinkPropertiesUpdate(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleLinkPropertiesUpdate", $$robo$$android_net_ip_IpClient$handleLinkPropertiesUpdate(boolean ), 0, this, bl);
    }

    private void handleIPv4Success(DhcpResults dhcpResults) {
        InvokeDynamicSupport.bootstrap("handleIPv4Success", $$robo$$android_net_ip_IpClient$handleIPv4Success(android.net.DhcpResults ), 0, this, dhcpResults);
    }

    private void handleIPv4Failure() {
        InvokeDynamicSupport.bootstrap("handleIPv4Failure", $$robo$$android_net_ip_IpClient$handleIPv4Failure(), 0, this);
    }

    private void handleProvisioningFailure() {
        InvokeDynamicSupport.bootstrap("handleProvisioningFailure", $$robo$$android_net_ip_IpClient$handleProvisioningFailure(), 0, this);
    }

    private void doImmediateProvisioningFailure(int n) {
        InvokeDynamicSupport.bootstrap("doImmediateProvisioningFailure", $$robo$$android_net_ip_IpClient$doImmediateProvisioningFailure(int ), 0, this, n);
    }

    private boolean startIPv4() {
        return (boolean)InvokeDynamicSupport.bootstrap("startIPv4", $$robo$$android_net_ip_IpClient$startIPv4(), 0, this);
    }

    private boolean startIPv6() {
        return (boolean)InvokeDynamicSupport.bootstrap("startIPv6", $$robo$$android_net_ip_IpClient$startIPv6(), 0, this);
    }

    private boolean applyInitialConfig(InitialConfiguration initialConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("applyInitialConfig", $$robo$$android_net_ip_IpClient$applyInitialConfig(android.net.ip.IpClient$InitialConfiguration ), 0, this, initialConfiguration);
    }

    private boolean startIpReachabilityMonitor() {
        return (boolean)InvokeDynamicSupport.bootstrap("startIpReachabilityMonitor", $$robo$$android_net_ip_IpClient$startIpReachabilityMonitor(), 0, this);
    }

    private void stopAllIP() {
        InvokeDynamicSupport.bootstrap("stopAllIP", $$robo$$android_net_ip_IpClient$stopAllIP(), 0, this);
    }

    static <T> boolean any(Iterable<T> iterable, Predicate<T> predicate) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("any", $$robo$$android_net_ip_IpClient$any(java.lang.Iterable<T> java.util.function.Predicate<T> ), 0, iterable, predicate);
    }

    static <T> boolean all(Iterable<T> iterable, Predicate<T> predicate) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("all", $$robo$$android_net_ip_IpClient$all(java.lang.Iterable<T> java.util.function.Predicate<T> ), 0, iterable, predicate);
    }

    static <T> Predicate<T> not(Predicate<T> predicate) {
        return InvokeDynamicSupport.bootstrapStatic("not", $$robo$$android_net_ip_IpClient$not(java.util.function.Predicate<T> ), 0, predicate);
    }

    static <T> String join(String string2, Collection<T> collection) {
        return InvokeDynamicSupport.bootstrapStatic("join", $$robo$$android_net_ip_IpClient$join(java.lang.String java.util.Collection<T> ), 0, (String)string2, collection);
    }

    static <T> T find(Iterable<T> iterable, Predicate<T> predicate) {
        return (T)InvokeDynamicSupport.bootstrapStatic("find", $$robo$$android_net_ip_IpClient$find(java.lang.Iterable<T> java.util.function.Predicate<T> ), 0, iterable, predicate);
    }

    static <T> List<T> findAll(Collection<T> collection, Predicate<T> predicate) {
        return InvokeDynamicSupport.bootstrapStatic("findAll", $$robo$$android_net_ip_IpClient$findAll(java.util.Collection<T> java.util.function.Predicate<T> ), 0, collection, predicate);
    }

    static {
        RobolectricInternals.classInitializing(IpClient.class);
    }

    public /* synthetic */ IpClient() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpClient)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class MessageHandlingLogger
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String processedInState;
        public String receivedInState;

        private void $$robo$$android_net_ip_IpClient_MessageHandlingLogger$__constructor__() {
        }

        private final void $$robo$$android_net_ip_IpClient_MessageHandlingLogger$reset() {
            this.processedInState = null;
            this.receivedInState = null;
        }

        private final void $$robo$$android_net_ip_IpClient_MessageHandlingLogger$handled(State processedIn, IState receivedIn) {
            this.processedInState = processedIn.getClass().getSimpleName();
            this.receivedInState = receivedIn.getName();
        }

        private final String $$robo$$android_net_ip_IpClient_MessageHandlingLogger$toString() {
            return String.format("rcvd_in=%s, proc_in=%s", this.receivedInState, this.processedInState);
        }

        private /* synthetic */ void $$robo$$android_net_ip_IpClient_MessageHandlingLogger$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ip_IpClient_MessageHandlingLogger$__constructor__();
        }

        private MessageHandlingLogger() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_MessageHandlingLogger$__constructor__(), 0, this);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_net_ip_IpClient_MessageHandlingLogger$reset(), 0, this);
        }

        public void handled(State state, IState iState) {
            InvokeDynamicSupport.bootstrap("handled", $$robo$$android_net_ip_IpClient_MessageHandlingLogger$handled(com.android.internal.util.State com.android.internal.util.IState ), 0, this, state, iState);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_ip_IpClient_MessageHandlingLogger$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_net_ip_IpClient_MessageHandlingLogger$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageHandlingLogger)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class RunningState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ConnectivityPacketTracker mPacketTracker;
        private boolean mDhcpActionInFlight;
        /* synthetic */ IpClient this$0;

        private void $$robo$$android_net_ip_IpClient_RunningState$__constructor__(IpClient this$0) {
        }

        private final void $$robo$$android_net_ip_IpClient_RunningState$enter() {
            ApfFilter.ApfConfiguration apfConfig = new ApfFilter.ApfConfiguration();
            apfConfig.apfCapabilities = ((IpClient)this.this$0).mConfiguration.mApfCapabilities;
            apfConfig.multicastFilter = this.this$0.mMulticastFiltering;
            apfConfig.ieee802_3Filter = this.this$0.mContext.getResources().getBoolean(17956890);
            apfConfig.ethTypeBlackList = this.this$0.mContext.getResources().getIntArray(17235980);
            this.this$0.mApfFilter = ApfFilter.maybeCreate(this.this$0.mContext, apfConfig, this.this$0.mInterfaceParams, this.this$0.mCallback);
            if (this.this$0.mApfFilter == null) {
                this.this$0.mCallback.setFallbackMulticastFilter(this.this$0.mMulticastFiltering);
            }
            this.mPacketTracker = this.createPacketTracker();
            if (this.mPacketTracker != null) {
                this.mPacketTracker.start(((IpClient)this.this$0).mConfiguration.mDisplayName);
            }
            if (((IpClient)this.this$0).mConfiguration.mEnableIPv6 && !this.this$0.startIPv6()) {
                this.this$0.doImmediateProvisioningFailure(5);
                this.this$0.transitionTo(this.this$0.mStoppingState);
                return;
            }
            if (((IpClient)this.this$0).mConfiguration.mEnableIPv4 && !this.this$0.startIPv4()) {
                this.this$0.doImmediateProvisioningFailure(4);
                this.this$0.transitionTo(this.this$0.mStoppingState);
                return;
            }
            InitialConfiguration config = ((IpClient)this.this$0).mConfiguration.mInitialConfig;
            if (config != null && !this.this$0.applyInitialConfig(config)) {
                this.this$0.doImmediateProvisioningFailure(7);
                this.this$0.transitionTo(this.this$0.mStoppingState);
                return;
            }
            if (((IpClient)this.this$0).mConfiguration.mUsingMultinetworkPolicyTracker) {
                this.this$0.mMultinetworkPolicyTracker = new MultinetworkPolicyTracker(this.this$0.mContext, this.this$0.getHandler(), () -> this.this$0.mLog.log("OBSERVED AvoidBadWifi changed"));
                this.this$0.mMultinetworkPolicyTracker.start();
            }
            if (((IpClient)this.this$0).mConfiguration.mUsingIpReachabilityMonitor && !this.this$0.startIpReachabilityMonitor()) {
                this.this$0.doImmediateProvisioningFailure(6);
                this.this$0.transitionTo(this.this$0.mStoppingState);
                return;
            }
        }

        private final void $$robo$$android_net_ip_IpClient_RunningState$exit() {
            this.stopDhcpAction();
            if (this.this$0.mIpReachabilityMonitor != null) {
                this.this$0.mIpReachabilityMonitor.stop();
                this.this$0.mIpReachabilityMonitor = null;
            }
            if (this.this$0.mMultinetworkPolicyTracker != null) {
                this.this$0.mMultinetworkPolicyTracker.shutdown();
                this.this$0.mMultinetworkPolicyTracker = null;
            }
            if (this.this$0.mDhcpClient != null) {
                this.this$0.mDhcpClient.sendMessage(196610);
                this.this$0.mDhcpClient.doQuit();
            }
            if (this.mPacketTracker != null) {
                this.mPacketTracker.stop();
                this.mPacketTracker = null;
            }
            if (this.this$0.mApfFilter != null) {
                this.this$0.mApfFilter.shutdown();
                this.this$0.mApfFilter = null;
            }
            this.this$0.resetLinkProperties();
        }

        private final ConnectivityPacketTracker $$robo$$android_net_ip_IpClient_RunningState$createPacketTracker() {
            try {
                return new ConnectivityPacketTracker(this.this$0.getHandler(), this.this$0.mInterfaceParams, this.this$0.mConnectivityPacketLog);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        private final void $$robo$$android_net_ip_IpClient_RunningState$ensureDhcpAction() {
            if (!this.mDhcpActionInFlight) {
                this.this$0.mCallback.onPreDhcpAction();
                this.mDhcpActionInFlight = true;
                long alarmTime = SystemClock.elapsedRealtime() + (long)((IpClient)this.this$0).mConfiguration.mRequestedPreDhcpActionMs;
                this.this$0.mDhcpActionTimeoutAlarm.schedule(alarmTime);
            }
        }

        private final void $$robo$$android_net_ip_IpClient_RunningState$stopDhcpAction() {
            this.this$0.mDhcpActionTimeoutAlarm.cancel();
            if (this.mDhcpActionInFlight) {
                this.this$0.mCallback.onPostDhcpAction();
                this.mDhcpActionInFlight = false;
            }
        }

        private final boolean $$robo$$android_net_ip_IpClient_RunningState$processMessage(Message msg) {
            block0 : switch (msg.what) {
                case 2: {
                    this.this$0.transitionTo(this.this$0.mStoppingState);
                    break;
                }
                case 3: {
                    this.this$0.logError("ALERT: START received in StartedState. Please fix caller.", new Object[0]);
                    break;
                }
                case 4: {
                    if (this.this$0.mIpReachabilityMonitor == null) break;
                    this.this$0.mIpReachabilityMonitor.probeAll();
                    break;
                }
                case 5: {
                    if (this.this$0.mDhcpClient == null) break;
                    this.this$0.mDhcpClient.sendMessage(196614);
                    break;
                }
                case 6: {
                    if (this.this$0.handleLinkPropertiesUpdate(true)) break;
                    this.this$0.transitionTo(this.this$0.mStoppingState);
                    break;
                }
                case 7: {
                    this.this$0.mTcpBufferSizes = (String)msg.obj;
                    this.this$0.handleLinkPropertiesUpdate(true);
                    break;
                }
                case 8: {
                    this.this$0.mHttpProxy = (ProxyInfo)msg.obj;
                    this.this$0.handleLinkPropertiesUpdate(true);
                    break;
                }
                case 9: {
                    this.this$0.mMulticastFiltering = (Boolean)msg.obj;
                    if (this.this$0.mApfFilter != null) {
                        this.this$0.mApfFilter.setMulticastFilter(this.this$0.mMulticastFiltering);
                        break;
                    }
                    this.this$0.mCallback.setFallbackMulticastFilter(this.this$0.mMulticastFiltering);
                    break;
                }
                case 12: {
                    if (this.this$0.mApfFilter != null) {
                        this.this$0.mApfFilter.setDataSnapshot((byte[])msg.obj);
                    }
                    this.this$0.mApfDataSnapshotComplete.open();
                    break;
                }
                case 11: {
                    this.stopDhcpAction();
                    break;
                }
                case 196611: {
                    if (((IpClient)this.this$0).mConfiguration.mRequestedPreDhcpActionMs > 0) {
                        this.ensureDhcpAction();
                        break;
                    }
                    this.this$0.sendMessage(5);
                    break;
                }
                case 196615: {
                    this.this$0.mInterfaceCtrl.clearIPv4Address();
                    break;
                }
                case 196616: {
                    LinkAddress ipAddress = (LinkAddress)msg.obj;
                    if (this.this$0.mInterfaceCtrl.setIPv4Address(ipAddress)) {
                        this.this$0.mDhcpClient.sendMessage(196617);
                        break;
                    }
                    this.this$0.logError("Failed to set IPv4 address.", new Object[0]);
                    this.this$0.dispatchCallback(LinkProperties.ProvisioningChange.LOST_PROVISIONING, new LinkProperties(this.this$0.mLinkProperties));
                    this.this$0.transitionTo(this.this$0.mStoppingState);
                    break;
                }
                case 196612: {
                    this.stopDhcpAction();
                    switch (msg.arg1) {
                        case 1: {
                            this.this$0.handleIPv4Success((DhcpResults)msg.obj);
                            break block0;
                        }
                        case 2: {
                            this.this$0.handleIPv4Failure();
                            break block0;
                        }
                    }
                    this.this$0.logError("Unknown CMD_POST_DHCP_ACTION status: %s", new Object[]{msg.arg1});
                    break;
                }
                case 196613: {
                    this.this$0.logError("Unexpected CMD_ON_QUIT.", new Object[0]);
                    this.this$0.mDhcpClient = null;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.this$0.mMsgStateLogger.handled(this, this.this$0.getCurrentState());
            return true;
        }

        private void __constructor__(IpClient ipClient) {
            this.$$robo$$android_net_ip_IpClient_RunningState$__constructor__(ipClient);
        }

        RunningState(IpClient ipClient) {
            this.this$0 = ipClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_RunningState$__constructor__(android.net.ip.IpClient ), 0, this, ipClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_ip_IpClient_RunningState$enter(), 0, this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_ip_IpClient_RunningState$exit(), 0, this);
        }

        private ConnectivityPacketTracker createPacketTracker() {
            return InvokeDynamicSupport.bootstrap("createPacketTracker", $$robo$$android_net_ip_IpClient_RunningState$createPacketTracker(), 0, this);
        }

        private void ensureDhcpAction() {
            InvokeDynamicSupport.bootstrap("ensureDhcpAction", $$robo$$android_net_ip_IpClient_RunningState$ensureDhcpAction(), 0, this);
        }

        private void stopDhcpAction() {
            InvokeDynamicSupport.bootstrap("stopDhcpAction", $$robo$$android_net_ip_IpClient_RunningState$stopDhcpAction(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_ip_IpClient_RunningState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ RunningState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RunningState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class StartedState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ IpClient this$0;

        private void $$robo$$android_net_ip_IpClient_StartedState$__constructor__(IpClient this$0) {
        }

        private final void $$robo$$android_net_ip_IpClient_StartedState$enter() {
            this.this$0.mStartTimeMillis = SystemClock.elapsedRealtime();
            if (((IpClient)this.this$0).mConfiguration.mProvisioningTimeoutMs > 0) {
                long alarmTime = SystemClock.elapsedRealtime() + (long)((IpClient)this.this$0).mConfiguration.mProvisioningTimeoutMs;
                this.this$0.mProvisioningTimeoutAlarm.schedule(alarmTime);
            }
            if (this.readyToProceed()) {
                this.this$0.transitionTo(this.this$0.mRunningState);
            } else {
                this.this$0.stopAllIP();
            }
        }

        private final void $$robo$$android_net_ip_IpClient_StartedState$exit() {
            this.this$0.mProvisioningTimeoutAlarm.cancel();
        }

        private final boolean $$robo$$android_net_ip_IpClient_StartedState$processMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    this.this$0.transitionTo(this.this$0.mStoppingState);
                    break;
                }
                case 6: {
                    this.this$0.handleLinkPropertiesUpdate(false);
                    if (!this.readyToProceed()) break;
                    this.this$0.transitionTo(this.this$0.mRunningState);
                    break;
                }
                case 10: {
                    this.this$0.handleProvisioningFailure();
                    break;
                }
                default: {
                    this.this$0.deferMessage(msg);
                }
            }
            this.this$0.mMsgStateLogger.handled(this, this.this$0.getCurrentState());
            return true;
        }

        private final boolean $$robo$$android_net_ip_IpClient_StartedState$readyToProceed() {
            return !this.this$0.mLinkProperties.hasIPv4Address() && !this.this$0.mLinkProperties.hasGlobalIPv6Address();
        }

        private void __constructor__(IpClient ipClient) {
            this.$$robo$$android_net_ip_IpClient_StartedState$__constructor__(ipClient);
        }

        StartedState(IpClient ipClient) {
            this.this$0 = ipClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_StartedState$__constructor__(android.net.ip.IpClient ), 0, this, ipClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_ip_IpClient_StartedState$enter(), 0, this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$android_net_ip_IpClient_StartedState$exit(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_ip_IpClient_StartedState$processMessage(android.os.Message ), 0, this, message);
        }

        boolean readyToProceed() {
            return (boolean)InvokeDynamicSupport.bootstrap("readyToProceed", $$robo$$android_net_ip_IpClient_StartedState$readyToProceed(), 0, this);
        }

        public /* synthetic */ StartedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StartedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class StoppingState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ IpClient this$0;

        private void $$robo$$android_net_ip_IpClient_StoppingState$__constructor__(IpClient this$0) {
        }

        private final void $$robo$$android_net_ip_IpClient_StoppingState$enter() {
            if (this.this$0.mDhcpClient == null) {
                this.this$0.transitionTo(this.this$0.mStoppedState);
            }
        }

        private final boolean $$robo$$android_net_ip_IpClient_StoppingState$processMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    break;
                }
                case 196615: {
                    this.this$0.mInterfaceCtrl.clearIPv4Address();
                    break;
                }
                case 196613: {
                    this.this$0.mDhcpClient = null;
                    this.this$0.transitionTo(this.this$0.mStoppedState);
                    break;
                }
                default: {
                    this.this$0.deferMessage(msg);
                }
            }
            this.this$0.mMsgStateLogger.handled(this, this.this$0.getCurrentState());
            return true;
        }

        private void __constructor__(IpClient ipClient) {
            this.$$robo$$android_net_ip_IpClient_StoppingState$__constructor__(ipClient);
        }

        StoppingState(IpClient ipClient) {
            this.this$0 = ipClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_StoppingState$__constructor__(android.net.ip.IpClient ), 0, this, ipClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_ip_IpClient_StoppingState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_ip_IpClient_StoppingState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ StoppingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StoppingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class StoppedState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ IpClient this$0;

        private void $$robo$$android_net_ip_IpClient_StoppedState$__constructor__(IpClient this$0) {
        }

        private final void $$robo$$android_net_ip_IpClient_StoppedState$enter() {
            this.this$0.stopAllIP();
            this.this$0.resetLinkProperties();
            if (this.this$0.mStartTimeMillis > 0L) {
                this.this$0.recordMetric(3);
                this.this$0.mStartTimeMillis = 0L;
            }
        }

        private final boolean $$robo$$android_net_ip_IpClient_StoppedState$processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.this$0.stopStateMachineUpdaters();
                    this.this$0.quit();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.this$0.mConfiguration = (ProvisioningConfiguration)msg.obj;
                    this.this$0.transitionTo(this.this$0.mStartedState);
                    break;
                }
                case 6: {
                    this.this$0.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 7: {
                    this.this$0.mTcpBufferSizes = (String)msg.obj;
                    this.this$0.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 8: {
                    this.this$0.mHttpProxy = (ProxyInfo)msg.obj;
                    this.this$0.handleLinkPropertiesUpdate(false);
                    break;
                }
                case 9: {
                    this.this$0.mMulticastFiltering = (Boolean)msg.obj;
                    break;
                }
                case 196613: {
                    this.this$0.logError("Unexpected CMD_ON_QUIT (already stopped).", new Object[0]);
                    break;
                }
                default: {
                    return false;
                }
            }
            this.this$0.mMsgStateLogger.handled(this, this.this$0.getCurrentState());
            return true;
        }

        private void __constructor__(IpClient ipClient) {
            this.$$robo$$android_net_ip_IpClient_StoppedState$__constructor__(ipClient);
        }

        StoppedState(IpClient ipClient) {
            this.this$0 = ipClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_StoppedState$__constructor__(android.net.ip.IpClient ), 0, this, ipClient);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$android_net_ip_IpClient_StoppedState$enter(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_net_ip_IpClient_StoppedState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ StoppedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StoppedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Dependencies
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_ip_IpClient_Dependencies$__constructor__() {
        }

        private final INetworkManagementService $$robo$$android_net_ip_IpClient_Dependencies$getNMS() {
            return INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management"));
        }

        private final INetd $$robo$$android_net_ip_IpClient_Dependencies$getNetd() {
            return NetdService.getInstance();
        }

        private final InterfaceParams $$robo$$android_net_ip_IpClient_Dependencies$getInterfaceParams(String ifname) {
            return InterfaceParams.getByName(ifname);
        }

        private void __constructor__() {
            this.$$robo$$android_net_ip_IpClient_Dependencies$__constructor__();
        }

        public Dependencies() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_Dependencies$__constructor__(), 0, this);
        }

        public INetworkManagementService getNMS() {
            return InvokeDynamicSupport.bootstrap("getNMS", $$robo$$android_net_ip_IpClient_Dependencies$getNMS(), 0, this);
        }

        public INetd getNetd() {
            return InvokeDynamicSupport.bootstrap("getNetd", $$robo$$android_net_ip_IpClient_Dependencies$getNetd(), 0, this);
        }

        public InterfaceParams getInterfaceParams(String string2) {
            return InvokeDynamicSupport.bootstrap("getInterfaceParams", $$robo$$android_net_ip_IpClient_Dependencies$getInterfaceParams(java.lang.String ), 0, this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Dependencies)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class InitialConfiguration
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Set<LinkAddress> ipAddresses;
        public Set<IpPrefix> directlyConnectedRoutes;
        public Set<InetAddress> dnsServers;
        public Inet4Address gateway;

        private void $$robo$$android_net_ip_IpClient_InitialConfiguration$__constructor__() {
            this.ipAddresses = new HashSet<LinkAddress>();
            this.directlyConnectedRoutes = new HashSet<IpPrefix>();
            this.dnsServers = new HashSet<InetAddress>();
        }

        private static final InitialConfiguration $$robo$$android_net_ip_IpClient_InitialConfiguration$copy(InitialConfiguration config) {
            if (config == null) {
                return null;
            }
            InitialConfiguration configCopy = new InitialConfiguration();
            configCopy.ipAddresses.addAll(config.ipAddresses);
            configCopy.directlyConnectedRoutes.addAll(config.directlyConnectedRoutes);
            configCopy.dnsServers.addAll(config.dnsServers);
            return configCopy;
        }

        private final String $$robo$$android_net_ip_IpClient_InitialConfiguration$toString() {
            return String.format("InitialConfiguration(IPs: {%s}, prefixes: {%s}, DNS: {%s}, v4 gateway: %s)", IpClient.join(", ", this.ipAddresses), IpClient.join(", ", this.directlyConnectedRoutes), IpClient.join(", ", this.dnsServers), this.gateway);
        }

        private final boolean $$robo$$android_net_ip_IpClient_InitialConfiguration$isValid() {
            if (this.ipAddresses.isEmpty()) {
                return false;
            }
            for (LinkAddress linkAddress : this.ipAddresses) {
                if (IpClient.any(this.directlyConnectedRoutes, p -> p.contains(linkAddress.getAddress()))) continue;
                return false;
            }
            for (InetAddress inetAddress : this.dnsServers) {
                if (IpClient.any(this.directlyConnectedRoutes, p -> p.contains(inetAddress))) continue;
                return false;
            }
            if (IpClient.any(this.ipAddresses, IpClient.not(InitialConfiguration::isPrefixLengthCompliant))) {
                return false;
            }
            if (IpClient.any(this.directlyConnectedRoutes, InitialConfiguration::isIPv6DefaultRoute) && IpClient.all(this.ipAddresses, IpClient.not(InitialConfiguration::isIPv6GUA))) {
                return false;
            }
            if (IpClient.any(this.directlyConnectedRoutes, IpClient.not(InitialConfiguration::isPrefixLengthCompliant))) {
                return false;
            }
            return this.ipAddresses.stream().filter(Inet4Address.class::isInstance).count() <= 1L;
        }

        private final boolean $$robo$$android_net_ip_IpClient_InitialConfiguration$isProvisionedBy(List<LinkAddress> addresses, List<RouteInfo> routes) {
            if (this.ipAddresses.isEmpty()) {
                return false;
            }
            for (LinkAddress addr : this.ipAddresses) {
                if (IpClient.any(addresses, addrSeen -> addr.isSameAddressAs((LinkAddress)addrSeen))) continue;
                return false;
            }
            if (routes != null) {
                for (IpPrefix prefix : this.directlyConnectedRoutes) {
                    if (IpClient.any(routes, routeSeen -> InitialConfiguration.isDirectlyConnectedRoute(routeSeen, prefix))) continue;
                    return false;
                }
            }
            return true;
        }

        private static final boolean $$robo$$android_net_ip_IpClient_InitialConfiguration$isDirectlyConnectedRoute(RouteInfo route, IpPrefix prefix) {
            return !route.hasGateway() && prefix.equals(route.getDestination());
        }

        private static final boolean $$robo$$android_net_ip_IpClient_InitialConfiguration$isPrefixLengthCompliant(LinkAddress addr) {
            return addr.isIPv4() || InitialConfiguration.isCompliantIPv6PrefixLength(addr.getPrefixLength());
        }

        private static final boolean $$robo$$android_net_ip_IpClient_InitialConfiguration$isPrefixLengthCompliant(IpPrefix prefix) {
            return prefix.isIPv4() || InitialConfiguration.isCompliantIPv6PrefixLength(prefix.getPrefixLength());
        }

        private static final boolean $$robo$$android_net_ip_IpClient_InitialConfiguration$isCompliantIPv6PrefixLength(int prefixLength) {
            return 48 <= prefixLength && prefixLength <= 64;
        }

        private static final boolean $$robo$$android_net_ip_IpClient_InitialConfiguration$isIPv6DefaultRoute(IpPrefix prefix) {
            return prefix.getAddress().equals(Inet6Address.ANY);
        }

        private static final boolean $$robo$$android_net_ip_IpClient_InitialConfiguration$isIPv6GUA(LinkAddress addr) {
            return addr.isIPv6() && addr.isGlobalPreferred();
        }

        private void __constructor__() {
            this.$$robo$$android_net_ip_IpClient_InitialConfiguration$__constructor__();
        }

        public InitialConfiguration() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_InitialConfiguration$__constructor__(), 0, this);
        }

        public static InitialConfiguration copy(InitialConfiguration initialConfiguration) {
            return InvokeDynamicSupport.bootstrapStatic("copy", $$robo$$android_net_ip_IpClient_InitialConfiguration$copy(android.net.ip.IpClient$InitialConfiguration ), 0, (InitialConfiguration)initialConfiguration);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_ip_IpClient_InitialConfiguration$toString(), 0, this);
        }

        public boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_net_ip_IpClient_InitialConfiguration$isValid(), 0, this);
        }

        public boolean isProvisionedBy(List<LinkAddress> list, List<RouteInfo> list2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isProvisionedBy", $$robo$$android_net_ip_IpClient_InitialConfiguration$isProvisionedBy(java.util.List<android.net.LinkAddress> java.util.List<android.net.RouteInfo> ), 0, this, list, list2);
        }

        private static boolean isDirectlyConnectedRoute(RouteInfo routeInfo, IpPrefix ipPrefix) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isDirectlyConnectedRoute", $$robo$$android_net_ip_IpClient_InitialConfiguration$isDirectlyConnectedRoute(android.net.RouteInfo android.net.IpPrefix ), 0, (RouteInfo)routeInfo, (IpPrefix)ipPrefix);
        }

        private static boolean isPrefixLengthCompliant(LinkAddress linkAddress) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrefixLengthCompliant", $$robo$$android_net_ip_IpClient_InitialConfiguration$isPrefixLengthCompliant(android.net.LinkAddress ), 0, (LinkAddress)linkAddress);
        }

        private static boolean isPrefixLengthCompliant(IpPrefix ipPrefix) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrefixLengthCompliant", $$robo$$android_net_ip_IpClient_InitialConfiguration$isPrefixLengthCompliant(android.net.IpPrefix ), 0, (IpPrefix)ipPrefix);
        }

        private static boolean isCompliantIPv6PrefixLength(int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isCompliantIPv6PrefixLength", $$robo$$android_net_ip_IpClient_InitialConfiguration$isCompliantIPv6PrefixLength(int ), 0, (int)n);
        }

        private static boolean isIPv6DefaultRoute(IpPrefix ipPrefix) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isIPv6DefaultRoute", $$robo$$android_net_ip_IpClient_InitialConfiguration$isIPv6DefaultRoute(android.net.IpPrefix ), 0, (IpPrefix)ipPrefix);
        }

        private static boolean isIPv6GUA(LinkAddress linkAddress) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("isIPv6GUA", $$robo$$android_net_ip_IpClient_InitialConfiguration$isIPv6GUA(android.net.LinkAddress ), 0, (LinkAddress)linkAddress);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InitialConfiguration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ProvisioningConfiguration
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int DEFAULT_TIMEOUT_MS = 36000;
        boolean mEnableIPv4;
        boolean mEnableIPv6;
        boolean mUsingMultinetworkPolicyTracker;
        boolean mUsingIpReachabilityMonitor;
        int mRequestedPreDhcpActionMs;
        InitialConfiguration mInitialConfig;
        StaticIpConfiguration mStaticIpConfig;
        ApfCapabilities mApfCapabilities;
        int mProvisioningTimeoutMs;
        int mIPv6AddrGenMode;
        Network mNetwork;
        String mDisplayName;

        private void $$robo$$android_net_ip_IpClient_ProvisioningConfiguration$__constructor__() {
            this.mEnableIPv4 = true;
            this.mEnableIPv6 = true;
            this.mUsingMultinetworkPolicyTracker = true;
            this.mUsingIpReachabilityMonitor = true;
            this.mProvisioningTimeoutMs = 36000;
            this.mIPv6AddrGenMode = 2;
            this.mNetwork = null;
            this.mDisplayName = null;
        }

        private void $$robo$$android_net_ip_IpClient_ProvisioningConfiguration$__constructor__(ProvisioningConfiguration other) {
            this.mEnableIPv4 = true;
            this.mEnableIPv6 = true;
            this.mUsingMultinetworkPolicyTracker = true;
            this.mUsingIpReachabilityMonitor = true;
            this.mProvisioningTimeoutMs = 36000;
            this.mIPv6AddrGenMode = 2;
            this.mNetwork = null;
            this.mDisplayName = null;
            this.mEnableIPv4 = other.mEnableIPv4;
            this.mEnableIPv6 = other.mEnableIPv6;
            this.mUsingIpReachabilityMonitor = other.mUsingIpReachabilityMonitor;
            this.mRequestedPreDhcpActionMs = other.mRequestedPreDhcpActionMs;
            this.mInitialConfig = InitialConfiguration.copy(other.mInitialConfig);
            this.mStaticIpConfig = other.mStaticIpConfig;
            this.mApfCapabilities = other.mApfCapabilities;
            this.mProvisioningTimeoutMs = other.mProvisioningTimeoutMs;
            this.mIPv6AddrGenMode = other.mIPv6AddrGenMode;
            this.mNetwork = other.mNetwork;
            this.mDisplayName = other.mDisplayName;
        }

        private final String $$robo$$android_net_ip_IpClient_ProvisioningConfiguration$toString() {
            return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("mEnableIPv4: " + this.mEnableIPv4).add("mEnableIPv6: " + this.mEnableIPv6).add("mUsingMultinetworkPolicyTracker: " + this.mUsingMultinetworkPolicyTracker).add("mUsingIpReachabilityMonitor: " + this.mUsingIpReachabilityMonitor).add("mRequestedPreDhcpActionMs: " + this.mRequestedPreDhcpActionMs).add("mInitialConfig: " + this.mInitialConfig).add("mStaticIpConfig: " + this.mStaticIpConfig).add("mApfCapabilities: " + this.mApfCapabilities).add("mProvisioningTimeoutMs: " + this.mProvisioningTimeoutMs).add("mIPv6AddrGenMode: " + this.mIPv6AddrGenMode).add("mNetwork: " + this.mNetwork).add("mDisplayName: " + this.mDisplayName).toString();
        }

        private final boolean $$robo$$android_net_ip_IpClient_ProvisioningConfiguration$isValid() {
            return this.mInitialConfig == null || this.mInitialConfig.isValid();
        }

        private void __constructor__() {
            this.$$robo$$android_net_ip_IpClient_ProvisioningConfiguration$__constructor__();
        }

        public ProvisioningConfiguration() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration$__constructor__(), 0, this);
        }

        private void __constructor__(ProvisioningConfiguration provisioningConfiguration) {
            this.$$robo$$android_net_ip_IpClient_ProvisioningConfiguration$__constructor__(provisioningConfiguration);
        }

        public ProvisioningConfiguration(ProvisioningConfiguration provisioningConfiguration) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration$__constructor__(android.net.ip.IpClient$ProvisioningConfiguration ), 0, this, provisioningConfiguration);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration$toString(), 0, this);
        }

        public boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration$isValid(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisioningConfiguration)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private ProvisioningConfiguration mConfig;

            private void $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$__constructor__() {
                this.mConfig = new ProvisioningConfiguration();
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withoutIPv4() {
                this.mConfig.mEnableIPv4 = false;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withoutIPv6() {
                this.mConfig.mEnableIPv6 = false;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withoutMultinetworkPolicyTracker() {
                this.mConfig.mUsingMultinetworkPolicyTracker = false;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withoutIpReachabilityMonitor() {
                this.mConfig.mUsingIpReachabilityMonitor = false;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withPreDhcpAction() {
                this.mConfig.mRequestedPreDhcpActionMs = 36000;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withPreDhcpAction(int dhcpActionTimeoutMs) {
                this.mConfig.mRequestedPreDhcpActionMs = dhcpActionTimeoutMs;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withInitialConfiguration(InitialConfiguration initialConfig) {
                this.mConfig.mInitialConfig = initialConfig;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withStaticConfiguration(StaticIpConfiguration staticConfig) {
                this.mConfig.mStaticIpConfig = staticConfig;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withApfCapabilities(ApfCapabilities apfCapabilities) {
                this.mConfig.mApfCapabilities = apfCapabilities;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withProvisioningTimeoutMs(int timeoutMs) {
                this.mConfig.mProvisioningTimeoutMs = timeoutMs;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withRandomMacAddress() {
                this.mConfig.mIPv6AddrGenMode = 0;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withStableMacAddress() {
                this.mConfig.mIPv6AddrGenMode = 2;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withNetwork(Network network) {
                this.mConfig.mNetwork = network;
                return this;
            }

            private final Builder $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withDisplayName(String displayName) {
                this.mConfig.mDisplayName = displayName;
                return this;
            }

            private final ProvisioningConfiguration $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$build() {
                return new ProvisioningConfiguration(this.mConfig);
            }

            private void __constructor__() {
                this.$$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$__constructor__(), 0, this);
            }

            public Builder withoutIPv4() {
                return InvokeDynamicSupport.bootstrap("withoutIPv4", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withoutIPv4(), 0, this);
            }

            public Builder withoutIPv6() {
                return InvokeDynamicSupport.bootstrap("withoutIPv6", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withoutIPv6(), 0, this);
            }

            public Builder withoutMultinetworkPolicyTracker() {
                return InvokeDynamicSupport.bootstrap("withoutMultinetworkPolicyTracker", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withoutMultinetworkPolicyTracker(), 0, this);
            }

            public Builder withoutIpReachabilityMonitor() {
                return InvokeDynamicSupport.bootstrap("withoutIpReachabilityMonitor", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withoutIpReachabilityMonitor(), 0, this);
            }

            public Builder withPreDhcpAction() {
                return InvokeDynamicSupport.bootstrap("withPreDhcpAction", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withPreDhcpAction(), 0, this);
            }

            public Builder withPreDhcpAction(int n) {
                return InvokeDynamicSupport.bootstrap("withPreDhcpAction", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withPreDhcpAction(int ), 0, this, n);
            }

            public Builder withInitialConfiguration(InitialConfiguration initialConfiguration) {
                return InvokeDynamicSupport.bootstrap("withInitialConfiguration", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withInitialConfiguration(android.net.ip.IpClient$InitialConfiguration ), 0, this, initialConfiguration);
            }

            public Builder withStaticConfiguration(StaticIpConfiguration staticIpConfiguration) {
                return InvokeDynamicSupport.bootstrap("withStaticConfiguration", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withStaticConfiguration(android.net.StaticIpConfiguration ), 0, this, staticIpConfiguration);
            }

            public Builder withApfCapabilities(ApfCapabilities apfCapabilities) {
                return InvokeDynamicSupport.bootstrap("withApfCapabilities", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withApfCapabilities(android.net.apf.ApfCapabilities ), 0, this, apfCapabilities);
            }

            public Builder withProvisioningTimeoutMs(int n) {
                return InvokeDynamicSupport.bootstrap("withProvisioningTimeoutMs", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withProvisioningTimeoutMs(int ), 0, this, n);
            }

            public Builder withRandomMacAddress() {
                return InvokeDynamicSupport.bootstrap("withRandomMacAddress", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withRandomMacAddress(), 0, this);
            }

            public Builder withStableMacAddress() {
                return InvokeDynamicSupport.bootstrap("withStableMacAddress", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withStableMacAddress(), 0, this);
            }

            public Builder withNetwork(Network network) {
                return InvokeDynamicSupport.bootstrap("withNetwork", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withNetwork(android.net.Network ), 0, this, network);
            }

            public Builder withDisplayName(String string2) {
                return InvokeDynamicSupport.bootstrap("withDisplayName", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$withDisplayName(java.lang.String ), 0, this, string2);
            }

            public ProvisioningConfiguration build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_net_ip_IpClient_ProvisioningConfiguration_Builder$build(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private class LoggingCallbackWrapper
    extends Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String PREFIX = "INVOKE ";
        private Callback mCallback;
        /* synthetic */ IpClient this$0;

        private void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$__constructor__(IpClient ipClient, Callback callback) {
            this.mCallback = callback;
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$log(String msg) {
            this.this$0.mLog.log("INVOKE " + msg);
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onPreDhcpAction() {
            this.mCallback.onPreDhcpAction();
            this.log("onPreDhcpAction()");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onPostDhcpAction() {
            this.mCallback.onPostDhcpAction();
            this.log("onPostDhcpAction()");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onNewDhcpResults(DhcpResults dhcpResults) {
            this.mCallback.onNewDhcpResults(dhcpResults);
            this.log("onNewDhcpResults({" + dhcpResults + "})");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onProvisioningSuccess(LinkProperties newLp) {
            this.mCallback.onProvisioningSuccess(newLp);
            this.log("onProvisioningSuccess({" + newLp + "})");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onProvisioningFailure(LinkProperties newLp) {
            this.mCallback.onProvisioningFailure(newLp);
            this.log("onProvisioningFailure({" + newLp + "})");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onLinkPropertiesChange(LinkProperties newLp) {
            this.mCallback.onLinkPropertiesChange(newLp);
            this.log("onLinkPropertiesChange({" + newLp + "})");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onReachabilityLost(String logMsg) {
            this.mCallback.onReachabilityLost(logMsg);
            this.log("onReachabilityLost(" + logMsg + ")");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onQuit() {
            this.mCallback.onQuit();
            this.log("onQuit()");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$installPacketFilter(byte[] filter) {
            this.mCallback.installPacketFilter(filter);
            this.log("installPacketFilter(byte[" + filter.length + "])");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$startReadPacketFilter() {
            this.mCallback.startReadPacketFilter();
            this.log("startReadPacketFilter()");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$setFallbackMulticastFilter(boolean enabled) {
            this.mCallback.setFallbackMulticastFilter(enabled);
            this.log("setFallbackMulticastFilter(" + enabled + ")");
        }

        private final void $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$setNeighborDiscoveryOffload(boolean enable) {
            this.mCallback.setNeighborDiscoveryOffload(enable);
            this.log("setNeighborDiscoveryOffload(" + enable + ")");
        }

        private void __constructor__(IpClient ipClient, Callback callback) {
            this.$$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$__constructor__(ipClient, callback);
        }

        public LoggingCallbackWrapper(IpClient ipClient, Callback callback) {
            this.this$0 = ipClient;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$__constructor__(android.net.ip.IpClient android.net.ip.IpClient$Callback ), 0, this, ipClient, callback);
        }

        private void log(String string2) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$log(java.lang.String ), 0, this, string2);
        }

        @Override
        public void onPreDhcpAction() {
            InvokeDynamicSupport.bootstrap("onPreDhcpAction", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onPreDhcpAction(), 0, this);
        }

        @Override
        public void onPostDhcpAction() {
            InvokeDynamicSupport.bootstrap("onPostDhcpAction", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onPostDhcpAction(), 0, this);
        }

        @Override
        public void onNewDhcpResults(DhcpResults dhcpResults) {
            InvokeDynamicSupport.bootstrap("onNewDhcpResults", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onNewDhcpResults(android.net.DhcpResults ), 0, this, dhcpResults);
        }

        @Override
        public void onProvisioningSuccess(LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onProvisioningSuccess", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onProvisioningSuccess(android.net.LinkProperties ), 0, this, linkProperties);
        }

        @Override
        public void onProvisioningFailure(LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onProvisioningFailure", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onProvisioningFailure(android.net.LinkProperties ), 0, this, linkProperties);
        }

        @Override
        public void onLinkPropertiesChange(LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onLinkPropertiesChange", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onLinkPropertiesChange(android.net.LinkProperties ), 0, this, linkProperties);
        }

        @Override
        public void onReachabilityLost(String string2) {
            InvokeDynamicSupport.bootstrap("onReachabilityLost", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onReachabilityLost(java.lang.String ), 0, this, string2);
        }

        @Override
        public void onQuit() {
            InvokeDynamicSupport.bootstrap("onQuit", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$onQuit(), 0, this);
        }

        @Override
        public void installPacketFilter(byte[] byArray) {
            InvokeDynamicSupport.bootstrap("installPacketFilter", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$installPacketFilter(byte[] ), 0, this, byArray);
        }

        @Override
        public void startReadPacketFilter() {
            InvokeDynamicSupport.bootstrap("startReadPacketFilter", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$startReadPacketFilter(), 0, this);
        }

        @Override
        public void setFallbackMulticastFilter(boolean bl) {
            InvokeDynamicSupport.bootstrap("setFallbackMulticastFilter", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$setFallbackMulticastFilter(boolean ), 0, this, bl);
        }

        @Override
        public void setNeighborDiscoveryOffload(boolean bl) {
            InvokeDynamicSupport.bootstrap("setNeighborDiscoveryOffload", $$robo$$android_net_ip_IpClient_LoggingCallbackWrapper$setNeighborDiscoveryOffload(boolean ), 0, this, bl);
        }

        public /* synthetic */ LoggingCallbackWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoggingCallbackWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class WaitForProvisioningCallback
    extends Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ConditionVariable mCV;
        private LinkProperties mCallbackLinkProperties;

        private void $$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$__constructor__() {
            this.mCV = new ConditionVariable();
        }

        private final LinkProperties $$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$waitForProvisioning() {
            this.mCV.block();
            return this.mCallbackLinkProperties;
        }

        private final void $$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$onProvisioningSuccess(LinkProperties newLp) {
            this.mCallbackLinkProperties = newLp;
            this.mCV.open();
        }

        private final void $$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$onProvisioningFailure(LinkProperties newLp) {
            this.mCallbackLinkProperties = null;
            this.mCV.open();
        }

        private void __constructor__() {
            this.$$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$__constructor__();
        }

        public WaitForProvisioningCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$__constructor__(), 0, this);
        }

        public LinkProperties waitForProvisioning() {
            return InvokeDynamicSupport.bootstrap("waitForProvisioning", $$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$waitForProvisioning(), 0, this);
        }

        @Override
        public void onProvisioningSuccess(LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onProvisioningSuccess", $$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$onProvisioningSuccess(android.net.LinkProperties ), 0, this, linkProperties);
        }

        @Override
        public void onProvisioningFailure(LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onProvisioningFailure", $$robo$$android_net_ip_IpClient_WaitForProvisioningCallback$onProvisioningFailure(android.net.LinkProperties ), 0, this, linkProperties);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaitForProvisioningCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_ip_IpClient_Callback$__constructor__() {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$onPreDhcpAction() {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$onPostDhcpAction() {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$onNewDhcpResults(DhcpResults dhcpResults) {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$onProvisioningSuccess(LinkProperties newLp) {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$onProvisioningFailure(LinkProperties newLp) {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$onLinkPropertiesChange(LinkProperties newLp) {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$onReachabilityLost(String logMsg) {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$onQuit() {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$installPacketFilter(byte[] filter) {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$startReadPacketFilter() {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$setFallbackMulticastFilter(boolean enabled) {
        }

        private final void $$robo$$android_net_ip_IpClient_Callback$setNeighborDiscoveryOffload(boolean enable) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ip_IpClient_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpClient_Callback$__constructor__(), 0, this);
        }

        public void onPreDhcpAction() {
            InvokeDynamicSupport.bootstrap("onPreDhcpAction", $$robo$$android_net_ip_IpClient_Callback$onPreDhcpAction(), 0, this);
        }

        public void onPostDhcpAction() {
            InvokeDynamicSupport.bootstrap("onPostDhcpAction", $$robo$$android_net_ip_IpClient_Callback$onPostDhcpAction(), 0, this);
        }

        public void onNewDhcpResults(DhcpResults dhcpResults) {
            InvokeDynamicSupport.bootstrap("onNewDhcpResults", $$robo$$android_net_ip_IpClient_Callback$onNewDhcpResults(android.net.DhcpResults ), 0, this, dhcpResults);
        }

        public void onProvisioningSuccess(LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onProvisioningSuccess", $$robo$$android_net_ip_IpClient_Callback$onProvisioningSuccess(android.net.LinkProperties ), 0, this, linkProperties);
        }

        public void onProvisioningFailure(LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onProvisioningFailure", $$robo$$android_net_ip_IpClient_Callback$onProvisioningFailure(android.net.LinkProperties ), 0, this, linkProperties);
        }

        public void onLinkPropertiesChange(LinkProperties linkProperties) {
            InvokeDynamicSupport.bootstrap("onLinkPropertiesChange", $$robo$$android_net_ip_IpClient_Callback$onLinkPropertiesChange(android.net.LinkProperties ), 0, this, linkProperties);
        }

        public void onReachabilityLost(String string2) {
            InvokeDynamicSupport.bootstrap("onReachabilityLost", $$robo$$android_net_ip_IpClient_Callback$onReachabilityLost(java.lang.String ), 0, this, string2);
        }

        public void onQuit() {
            InvokeDynamicSupport.bootstrap("onQuit", $$robo$$android_net_ip_IpClient_Callback$onQuit(), 0, this);
        }

        public void installPacketFilter(byte[] byArray) {
            InvokeDynamicSupport.bootstrap("installPacketFilter", $$robo$$android_net_ip_IpClient_Callback$installPacketFilter(byte[] ), 0, this, byArray);
        }

        public void startReadPacketFilter() {
            InvokeDynamicSupport.bootstrap("startReadPacketFilter", $$robo$$android_net_ip_IpClient_Callback$startReadPacketFilter(), 0, this);
        }

        public void setFallbackMulticastFilter(boolean bl) {
            InvokeDynamicSupport.bootstrap("setFallbackMulticastFilter", $$robo$$android_net_ip_IpClient_Callback$setFallbackMulticastFilter(boolean ), 0, this, bl);
        }

        public void setNeighborDiscoveryOffload(boolean bl) {
            InvokeDynamicSupport.bootstrap("setNeighborDiscoveryOffload", $$robo$$android_net_ip_IpClient_Callback$setNeighborDiscoveryOffload(boolean ), 0, this, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

