/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.MacAddress;
import android.net.netlink.NetlinkConstants;
import android.net.netlink.NetlinkErrorMessage;
import android.net.netlink.NetlinkMessage;
import android.net.netlink.NetlinkSocket;
import android.net.netlink.RtNetlinkNeighborMessage;
import android.net.netlink.StructNdMsg;
import android.net.util.PacketReader;
import android.net.util.SharedLog;
import android.os.Handler;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.NetlinkSocketAddress;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.util.BitUtils;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.StringJoiner;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IpNeighborMonitor
extends PacketReader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    private static boolean VDBG = false;
    private SharedLog mLog;
    private NeighborEventConsumer mConsumer;

    private static final int $$robo$$android_net_ip_IpNeighborMonitor$startKernelNeighborProbe(int ifIndex, InetAddress ip) {
        String msgSnippet = "probing ip=" + ip.getHostAddress() + "%" + ifIndex;
        byte[] msg = RtNetlinkNeighborMessage.newNewNeighborMessage(1, ip, (short)16, ifIndex, null);
        try {
            NetlinkSocket.sendOneShotKernelMessage(OsConstants.NETLINK_ROUTE, msg);
        }
        catch (ErrnoException e) {
            Log.e(TAG, "Error " + msgSnippet + ": " + e);
            return -e.errno;
        }
        return 0;
    }

    private void $$robo$$android_net_ip_IpNeighborMonitor$__constructor__(Handler h, SharedLog log, NeighborEventConsumer cb) {
        this.mLog = log.forSubComponent(TAG);
        this.mConsumer = cb != null ? cb : event -> {};
    }

    private final FileDescriptor $$robo$$android_net_ip_IpNeighborMonitor$createFd() {
        FileDescriptor fd = null;
        try {
            fd = NetlinkSocket.forProto(OsConstants.NETLINK_ROUTE);
            Os.bind(fd, new NetlinkSocketAddress(0, OsConstants.RTMGRP_NEIGH));
            Os.connect(fd, new NetlinkSocketAddress(0, 0));
        }
        catch (ErrnoException | SocketException e) {
            this.logError("Failed to create rtnetlink socket", e);
            IoUtils.closeQuietly(fd);
            return null;
        }
        return fd;
    }

    private final void $$robo$$android_net_ip_IpNeighborMonitor$handlePacket(byte[] recvbuf, int length) {
        long whenMs = SystemClock.elapsedRealtime();
        ByteBuffer byteBuffer = ByteBuffer.wrap(recvbuf, 0, length);
        byteBuffer.order(ByteOrder.nativeOrder());
        this.parseNetlinkMessageBuffer(byteBuffer, whenMs);
    }

    private final void $$robo$$android_net_ip_IpNeighborMonitor$parseNetlinkMessageBuffer(ByteBuffer byteBuffer, long whenMs) {
        while (byteBuffer.remaining() > 0) {
            int position = byteBuffer.position();
            NetlinkMessage nlMsg = NetlinkMessage.parse(byteBuffer);
            if (nlMsg == null || nlMsg.getHeader() == null) {
                byteBuffer.position(position);
                this.mLog.e("unparsable netlink msg: " + NetlinkConstants.hexify(byteBuffer));
                break;
            }
            int srcPortId = nlMsg.getHeader().nlmsg_pid;
            if (srcPortId != 0) {
                this.mLog.e("non-kernel source portId: " + BitUtils.uint32(srcPortId));
                break;
            }
            if (nlMsg instanceof NetlinkErrorMessage) {
                this.mLog.e("netlink error: " + nlMsg);
                continue;
            }
            if (!(nlMsg instanceof RtNetlinkNeighborMessage)) {
                this.mLog.i("non-rtnetlink neighbor msg: " + nlMsg);
                continue;
            }
            this.evaluateRtNetlinkNeighborMessage((RtNetlinkNeighborMessage)nlMsg, whenMs);
        }
    }

    private final void $$robo$$android_net_ip_IpNeighborMonitor$evaluateRtNetlinkNeighborMessage(RtNetlinkNeighborMessage neighMsg, long whenMs) {
        short msgType = neighMsg.getHeader().nlmsg_type;
        StructNdMsg ndMsg = neighMsg.getNdHeader();
        if (ndMsg == null) {
            this.mLog.e("RtNetlinkNeighborMessage without ND message header!");
            return;
        }
        int ifindex = ndMsg.ndm_ifindex;
        InetAddress destination = neighMsg.getDestination();
        short nudState = msgType == 29 ? (short)0 : ndMsg.ndm_state;
        NeighborEvent event = new NeighborEvent(whenMs, msgType, ifindex, destination, nudState, IpNeighborMonitor.getMacAddress(neighMsg.getLinkLayerAddress()));
        this.mConsumer.accept(event);
    }

    private static final MacAddress $$robo$$android_net_ip_IpNeighborMonitor$getMacAddress(byte[] linkLayerAddress) {
        if (linkLayerAddress != null) {
            try {
                return MacAddress.fromBytes(linkLayerAddress);
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "Failed to parse link-layer address: " + NetlinkConstants.hexify(linkLayerAddress));
            }
        }
        return null;
    }

    static void __staticInitializer__() {
        TAG = IpNeighborMonitor.class.getSimpleName();
    }

    public static int startKernelNeighborProbe(int n, InetAddress inetAddress) {
        return (int)InvokeDynamicSupport.bootstrapStatic("startKernelNeighborProbe", $$robo$$android_net_ip_IpNeighborMonitor$startKernelNeighborProbe(int java.net.InetAddress ), 0, (int)n, (InetAddress)inetAddress);
    }

    private void __constructor__(Handler handler, SharedLog sharedLog, NeighborEventConsumer neighborEventConsumer) {
        this.$$robo$$android_net_ip_IpNeighborMonitor$__constructor__(handler, sharedLog, neighborEventConsumer);
    }

    public IpNeighborMonitor(Handler handler, SharedLog sharedLog, NeighborEventConsumer neighborEventConsumer) {
        super(handler, 8192);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpNeighborMonitor$__constructor__(android.os.Handler android.net.util.SharedLog android.net.ip.IpNeighborMonitor$NeighborEventConsumer ), 0, this, handler, sharedLog, neighborEventConsumer);
    }

    @Override
    protected FileDescriptor createFd() {
        return InvokeDynamicSupport.bootstrap("createFd", $$robo$$android_net_ip_IpNeighborMonitor$createFd(), 0, this);
    }

    @Override
    protected void handlePacket(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("handlePacket", $$robo$$android_net_ip_IpNeighborMonitor$handlePacket(byte[] int ), 0, this, byArray, n);
    }

    private void parseNetlinkMessageBuffer(ByteBuffer byteBuffer, long l) {
        InvokeDynamicSupport.bootstrap("parseNetlinkMessageBuffer", $$robo$$android_net_ip_IpNeighborMonitor$parseNetlinkMessageBuffer(java.nio.ByteBuffer long ), 0, this, byteBuffer, l);
    }

    private void evaluateRtNetlinkNeighborMessage(RtNetlinkNeighborMessage rtNetlinkNeighborMessage, long l) {
        InvokeDynamicSupport.bootstrap("evaluateRtNetlinkNeighborMessage", $$robo$$android_net_ip_IpNeighborMonitor$evaluateRtNetlinkNeighborMessage(android.net.netlink.RtNetlinkNeighborMessage long ), 0, this, rtNetlinkNeighborMessage, l);
    }

    private static MacAddress getMacAddress(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("getMacAddress", $$robo$$android_net_ip_IpNeighborMonitor$getMacAddress(byte[] ), 0, (byte[])byArray);
    }

    static {
        RobolectricInternals.classInitializing(IpNeighborMonitor.class);
    }

    public /* synthetic */ IpNeighborMonitor() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IpNeighborMonitor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface NeighborEventConsumer
    extends InstrumentedInterface {
        public void accept(NeighborEvent var1);
    }

    public static class NeighborEvent
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long elapsedMs;
        short msgType;
        int ifindex;
        InetAddress ip;
        short nudState;
        MacAddress macAddr;

        private void $$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$__constructor__(long elapsedMs, short msgType, int ifindex, InetAddress ip, short nudState, MacAddress macAddr) {
            this.elapsedMs = elapsedMs;
            this.msgType = msgType;
            this.ifindex = ifindex;
            this.ip = ip;
            this.nudState = nudState;
            this.macAddr = macAddr;
        }

        private final boolean $$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$isConnected() {
            return this.msgType != 29 && StructNdMsg.isNudStateConnected(this.nudState);
        }

        private final boolean $$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$isValid() {
            return this.msgType != 29 && StructNdMsg.isNudStateValid(this.nudState);
        }

        private final String $$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$toString() {
            StringJoiner j = new StringJoiner(",", "NeighborEvent{", "}");
            return j.add("@" + this.elapsedMs).add(NetlinkConstants.stringForNlMsgType(this.msgType)).add("if=" + this.ifindex).add(this.ip.getHostAddress()).add(StructNdMsg.stringForNudState(this.nudState)).add("[" + this.macAddr + "]").toString();
        }

        private void __constructor__(long l, short s, int n, InetAddress inetAddress, short s2, MacAddress macAddress) {
            this.$$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$__constructor__(l, s, n, inetAddress, s2, macAddress);
        }

        public NeighborEvent(long l, short s, int n, InetAddress inetAddress, short s2, MacAddress macAddress) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$__constructor__(long short int java.net.InetAddress short android.net.MacAddress ), 0, this, l, s, n, inetAddress, s2, macAddress);
        }

        boolean isConnected() {
            return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$isConnected(), 0, this);
        }

        boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$isValid(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_ip_IpNeighborMonitor_NeighborEvent$toString(), 0, this);
        }

        public /* synthetic */ NeighborEvent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NeighborEvent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

