/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.NetworkCapabilities;
import android.net.metrics.ConnectStats;
import android.net.metrics.DnsEvent;
import com.android.internal.util.BitUtils;
import com.android.internal.util.TokenBucket;
import java.util.StringJoiner;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkMetrics
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int INITIAL_DNS_BATCH_SIZE = 100;
    private static int CONNECT_LATENCY_MAXIMUM_RECORDS = 20000;
    public int netId;
    public long transports;
    public ConnectStats connectMetrics;
    public DnsEvent dnsMetrics;
    public Summary summary;
    public Summary pendingSummary;

    private void $$robo$$android_net_metrics_NetworkMetrics$__constructor__(int netId, long transports, TokenBucket tb) {
        this.netId = netId;
        this.transports = transports;
        this.connectMetrics = new ConnectStats(netId, transports, tb, 20000);
        this.dnsMetrics = new DnsEvent(netId, transports, 100);
        this.summary = new Summary(netId, transports);
    }

    private final Summary $$robo$$android_net_metrics_NetworkMetrics$getPendingStats() {
        Summary s = this.pendingSummary;
        this.pendingSummary = null;
        if (s != null) {
            this.summary.merge(s);
        }
        return s;
    }

    private final void $$robo$$android_net_metrics_NetworkMetrics$addDnsResult(int eventType, int returnCode, int latencyMs) {
        if (this.pendingSummary == null) {
            this.pendingSummary = new Summary(this.netId, this.transports);
        }
        boolean isSuccess = this.dnsMetrics.addResult((byte)eventType, (byte)returnCode, latencyMs);
        this.pendingSummary.dnsLatencies.count(latencyMs);
        this.pendingSummary.dnsErrorRate.count(isSuccess ? 0.0 : 1.0);
    }

    private final void $$robo$$android_net_metrics_NetworkMetrics$addConnectResult(int error, int latencyMs, String ipAddr) {
        if (this.pendingSummary == null) {
            this.pendingSummary = new Summary(this.netId, this.transports);
        }
        boolean isSuccess = this.connectMetrics.addEvent(error, latencyMs, ipAddr);
        this.pendingSummary.connectErrorRate.count(isSuccess ? 0.0 : 1.0);
        if (ConnectStats.isNonBlocking(error)) {
            this.pendingSummary.connectLatencies.count(latencyMs);
        }
    }

    private final void $$robo$$android_net_metrics_NetworkMetrics$addTcpStatsResult(int sent, int lost, int rttUs, int sentAckDiffMs) {
        if (this.pendingSummary == null) {
            this.pendingSummary = new Summary(this.netId, this.transports);
        }
        this.pendingSummary.tcpLossRate.count(lost, sent);
        this.pendingSummary.roundTripTimeUs.count(rttUs);
        this.pendingSummary.sentAckTimeDiffenceMs.count(sentAckDiffMs);
    }

    private void __constructor__(int n, long l, TokenBucket tokenBucket) {
        this.$$robo$$android_net_metrics_NetworkMetrics$__constructor__(n, l, tokenBucket);
    }

    public NetworkMetrics(int n, long l, TokenBucket tokenBucket) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_metrics_NetworkMetrics$__constructor__(int long com.android.internal.util.TokenBucket ), 0, this, n, l, tokenBucket);
    }

    public Summary getPendingStats() {
        return InvokeDynamicSupport.bootstrap("getPendingStats", $$robo$$android_net_metrics_NetworkMetrics$getPendingStats(), 0, this);
    }

    public void addDnsResult(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("addDnsResult", $$robo$$android_net_metrics_NetworkMetrics$addDnsResult(int int int ), 0, this, n, n2, n3);
    }

    public void addConnectResult(int n, int n2, String string2) {
        InvokeDynamicSupport.bootstrap("addConnectResult", $$robo$$android_net_metrics_NetworkMetrics$addConnectResult(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public void addTcpStatsResult(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("addTcpStatsResult", $$robo$$android_net_metrics_NetworkMetrics$addTcpStatsResult(int int int int ), 0, this, n, n2, n3, n4);
    }

    public /* synthetic */ NetworkMetrics() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkMetrics)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Metrics
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public double sum;
        public double max;
        public int count;

        private void $$robo$$android_net_metrics_NetworkMetrics_Metrics$__constructor__() {
            this.max = Double.MIN_VALUE;
        }

        private final void $$robo$$android_net_metrics_NetworkMetrics_Metrics$merge(Metrics that) {
            this.count += that.count;
            this.sum += that.sum;
            this.max = Math.max(this.max, that.max);
        }

        private final void $$robo$$android_net_metrics_NetworkMetrics_Metrics$count(double value) {
            this.count(value, 1);
        }

        private final void $$robo$$android_net_metrics_NetworkMetrics_Metrics$count(double value, int subcount) {
            this.count += subcount;
            this.sum += value;
            this.max = Math.max(this.max, value);
        }

        private final double $$robo$$android_net_metrics_NetworkMetrics_Metrics$average() {
            double a = this.sum / (double)this.count;
            if (Double.isNaN(a)) {
                a = 0.0;
            }
            return a;
        }

        private void __constructor__() {
            this.$$robo$$android_net_metrics_NetworkMetrics_Metrics$__constructor__();
        }

        Metrics() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_metrics_NetworkMetrics_Metrics$__constructor__(), 0, this);
        }

        void merge(Metrics metrics) {
            InvokeDynamicSupport.bootstrap("merge", $$robo$$android_net_metrics_NetworkMetrics_Metrics$merge(android.net.metrics.NetworkMetrics$Metrics ), 0, this, metrics);
        }

        void count(double d) {
            InvokeDynamicSupport.bootstrap("count", $$robo$$android_net_metrics_NetworkMetrics_Metrics$count(double ), 0, this, d);
        }

        void count(double d, int n) {
            InvokeDynamicSupport.bootstrap("count", $$robo$$android_net_metrics_NetworkMetrics_Metrics$count(double int ), 0, this, d, n);
        }

        double average() {
            return (double)InvokeDynamicSupport.bootstrap("average", $$robo$$android_net_metrics_NetworkMetrics_Metrics$average(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Metrics)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Summary
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int netId;
        public long transports;
        public Metrics dnsLatencies;
        public Metrics dnsErrorRate;
        public Metrics connectLatencies;
        public Metrics connectErrorRate;
        public Metrics tcpLossRate;
        public Metrics roundTripTimeUs;
        public Metrics sentAckTimeDiffenceMs;

        private void $$robo$$android_net_metrics_NetworkMetrics_Summary$__constructor__(int netId, long transports) {
            this.dnsLatencies = new Metrics();
            this.dnsErrorRate = new Metrics();
            this.connectLatencies = new Metrics();
            this.connectErrorRate = new Metrics();
            this.tcpLossRate = new Metrics();
            this.roundTripTimeUs = new Metrics();
            this.sentAckTimeDiffenceMs = new Metrics();
            this.netId = netId;
            this.transports = transports;
        }

        private final void $$robo$$android_net_metrics_NetworkMetrics_Summary$merge(Summary that) {
            this.dnsLatencies.merge(that.dnsLatencies);
            this.dnsErrorRate.merge(that.dnsErrorRate);
            this.connectLatencies.merge(that.connectLatencies);
            this.connectErrorRate.merge(that.connectErrorRate);
            this.tcpLossRate.merge(that.tcpLossRate);
        }

        private final String $$robo$$android_net_metrics_NetworkMetrics_Summary$toString() {
            StringJoiner j = new StringJoiner(", ", "{", "}");
            j.add("netId=" + this.netId);
            for (int t : BitUtils.unpackBits(this.transports)) {
                j.add(NetworkCapabilities.transportNameOf(t));
            }
            j.add(String.format("dns avg=%dms max=%dms err=%.1f%% tot=%d", (int)this.dnsLatencies.average(), (int)this.dnsLatencies.max, 100.0 * this.dnsErrorRate.average(), this.dnsErrorRate.count));
            j.add(String.format("connect avg=%dms max=%dms err=%.1f%% tot=%d", (int)this.connectLatencies.average(), (int)this.connectLatencies.max, 100.0 * this.connectErrorRate.average(), this.connectErrorRate.count));
            j.add(String.format("tcp avg_loss=%.1f%% total_sent=%d total_lost=%d", 100.0 * this.tcpLossRate.average(), this.tcpLossRate.count, (int)this.tcpLossRate.sum));
            j.add(String.format("tcp rtt=%dms", (int)(this.roundTripTimeUs.average() / 1000.0)));
            j.add(String.format("tcp sent-ack_diff=%dms", (int)this.sentAckTimeDiffenceMs.average()));
            return j.toString();
        }

        private void __constructor__(int n, long l) {
            this.$$robo$$android_net_metrics_NetworkMetrics_Summary$__constructor__(n, l);
        }

        public Summary(int n, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_metrics_NetworkMetrics_Summary$__constructor__(int long ), 0, this, n, l);
        }

        void merge(Summary summary) {
            InvokeDynamicSupport.bootstrap("merge", $$robo$$android_net_metrics_NetworkMetrics_Summary$merge(android.net.metrics.NetworkMetrics$Summary ), 0, this, summary);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_metrics_NetworkMetrics_Summary$toString(), 0, this);
        }

        public /* synthetic */ Summary() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Summary)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

