/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.metrics.WakeupEvent;
import android.os.SystemClock;
import android.util.SparseIntArray;
import java.util.StringJoiner;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WakeupStats
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int NO_UID = -1;
    public long creationTimeMs;
    public String iface;
    public long totalWakeups;
    public long rootWakeups;
    public long systemWakeups;
    public long nonApplicationWakeups;
    public long applicationWakeups;
    public long noUidWakeups;
    public long durationSec;
    public long l2UnicastCount;
    public long l2MulticastCount;
    public long l2BroadcastCount;
    public SparseIntArray ethertypes;
    public SparseIntArray ipNextHeaders;

    private void $$robo$$android_net_metrics_WakeupStats$__constructor__(String iface) {
        this.creationTimeMs = SystemClock.elapsedRealtime();
        this.totalWakeups = 0L;
        this.rootWakeups = 0L;
        this.systemWakeups = 0L;
        this.nonApplicationWakeups = 0L;
        this.applicationWakeups = 0L;
        this.noUidWakeups = 0L;
        this.durationSec = 0L;
        this.l2UnicastCount = 0L;
        this.l2MulticastCount = 0L;
        this.l2BroadcastCount = 0L;
        this.ethertypes = new SparseIntArray();
        this.ipNextHeaders = new SparseIntArray();
        this.iface = iface;
    }

    private final void $$robo$$android_net_metrics_WakeupStats$updateDuration() {
        this.durationSec = (SystemClock.elapsedRealtime() - this.creationTimeMs) / 1000L;
    }

    private final void $$robo$$android_net_metrics_WakeupStats$countEvent(WakeupEvent ev) {
        ++this.totalWakeups;
        switch (ev.uid) {
            case 0: {
                ++this.rootWakeups;
                break;
            }
            case 1000: {
                ++this.systemWakeups;
                break;
            }
            case -1: {
                ++this.noUidWakeups;
                break;
            }
            default: {
                if (ev.uid >= 10000) {
                    ++this.applicationWakeups;
                    break;
                }
                ++this.nonApplicationWakeups;
            }
        }
        switch (ev.dstHwAddr.getAddressType()) {
            case 1: {
                ++this.l2UnicastCount;
                break;
            }
            case 2: {
                ++this.l2MulticastCount;
                break;
            }
            case 3: {
                ++this.l2BroadcastCount;
                break;
            }
        }
        WakeupStats.increment(this.ethertypes, ev.ethertype);
        if (ev.ipNextHeader >= 0) {
            WakeupStats.increment(this.ipNextHeaders, ev.ipNextHeader);
        }
    }

    private final String $$robo$$android_net_metrics_WakeupStats$toString() {
        int count;
        int i;
        this.updateDuration();
        StringJoiner j = new StringJoiner(", ", "WakeupStats(", ")");
        j.add(this.iface);
        j.add("" + this.durationSec + "s");
        j.add("total: " + this.totalWakeups);
        j.add("root: " + this.rootWakeups);
        j.add("system: " + this.systemWakeups);
        j.add("apps: " + this.applicationWakeups);
        j.add("non-apps: " + this.nonApplicationWakeups);
        j.add("no uid: " + this.noUidWakeups);
        j.add(String.format("l2 unicast/multicast/broadcast: %d/%d/%d", this.l2UnicastCount, this.l2MulticastCount, this.l2BroadcastCount));
        for (i = 0; i < this.ethertypes.size(); ++i) {
            int eth = this.ethertypes.keyAt(i);
            count = this.ethertypes.valueAt(i);
            j.add(String.format("ethertype 0x%x: %d", eth, count));
        }
        for (i = 0; i < this.ipNextHeaders.size(); ++i) {
            int proto = this.ipNextHeaders.keyAt(i);
            count = this.ipNextHeaders.valueAt(i);
            j.add(String.format("ipNxtHdr %d: %d", proto, count));
        }
        return j.toString();
    }

    private static final void $$robo$$android_net_metrics_WakeupStats$increment(SparseIntArray counters, int key) {
        int newcount = counters.get(key, 0) + 1;
        counters.put(key, newcount);
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_net_metrics_WakeupStats$__constructor__(string2);
    }

    public WakeupStats(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_metrics_WakeupStats$__constructor__(java.lang.String ), 0, this, string2);
    }

    public void updateDuration() {
        InvokeDynamicSupport.bootstrap("updateDuration", $$robo$$android_net_metrics_WakeupStats$updateDuration(), 0, this);
    }

    public void countEvent(WakeupEvent wakeupEvent) {
        InvokeDynamicSupport.bootstrap("countEvent", $$robo$$android_net_metrics_WakeupStats$countEvent(android.net.metrics.WakeupEvent ), 0, this, wakeupEvent);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_metrics_WakeupStats$toString(), 0, this);
    }

    private static void increment(SparseIntArray sparseIntArray, int n) {
        InvokeDynamicSupport.bootstrapStatic("increment", $$robo$$android_net_metrics_WakeupStats$increment(android.util.SparseIntArray int ), 0, (SparseIntArray)sparseIntArray, (int)n);
    }

    public /* synthetic */ WakeupStats() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WakeupStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

