/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.content.Context;
import android.net.nsd.INsdManager;
import android.net.nsd.NsdServiceInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.concurrent.CountDownLatch;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NsdManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DBG = false;
    public static String ACTION_NSD_STATE_CHANGED = "android.net.nsd.STATE_CHANGED";
    public static String EXTRA_NSD_STATE = "nsd_state";
    public static int NSD_STATE_DISABLED = 1;
    public static int NSD_STATE_ENABLED = 2;
    private static int BASE = 393216;
    public static int DISCOVER_SERVICES = 393217;
    public static int DISCOVER_SERVICES_STARTED = 393218;
    public static int DISCOVER_SERVICES_FAILED = 393219;
    public static int SERVICE_FOUND = 393220;
    public static int SERVICE_LOST = 393221;
    public static int STOP_DISCOVERY = 393222;
    public static int STOP_DISCOVERY_FAILED = 393223;
    public static int STOP_DISCOVERY_SUCCEEDED = 393224;
    public static int REGISTER_SERVICE = 393225;
    public static int REGISTER_SERVICE_FAILED = 393226;
    public static int REGISTER_SERVICE_SUCCEEDED = 393227;
    public static int UNREGISTER_SERVICE = 393228;
    public static int UNREGISTER_SERVICE_FAILED = 393229;
    public static int UNREGISTER_SERVICE_SUCCEEDED = 393230;
    public static int RESOLVE_SERVICE = 393234;
    public static int RESOLVE_SERVICE_FAILED = 393235;
    public static int RESOLVE_SERVICE_SUCCEEDED = 393236;
    public static int ENABLE = 393240;
    public static int DISABLE = 393241;
    public static int NATIVE_DAEMON_EVENT = 393242;
    public static int PROTOCOL_DNS_SD = 1;
    private static SparseArray<String> EVENT_NAMES;
    private static int FIRST_LISTENER_KEY = 1;
    private INsdManager mService;
    private Context mContext;
    private int mListenerKey;
    private SparseArray mListenerMap;
    private SparseArray<NsdServiceInfo> mServiceMap;
    private Object mMapLock;
    private AsyncChannel mAsyncChannel;
    private ServiceHandler mHandler;
    private CountDownLatch mConnected;
    public static int FAILURE_INTERNAL_ERROR = 0;
    public static int FAILURE_ALREADY_ACTIVE = 3;
    public static int FAILURE_MAX_LIMIT = 4;

    private static final String $$robo$$android_net_nsd_NsdManager$nameOf(int event) {
        String name = EVENT_NAMES.get(event);
        if (name == null) {
            return Integer.toString(event);
        }
        return name;
    }

    private void $$robo$$android_net_nsd_NsdManager$__constructor__(Context context, INsdManager service) {
        this.mListenerKey = 1;
        this.mListenerMap = new SparseArray();
        this.mServiceMap = new SparseArray();
        this.mMapLock = new Object();
        this.mAsyncChannel = new AsyncChannel();
        this.mConnected = new CountDownLatch(1);
        this.mService = service;
        this.mContext = context;
        this.init();
    }

    @VisibleForTesting
    private final void $$robo$$android_net_nsd_NsdManager$disconnect() {
        this.mAsyncChannel.disconnect();
        this.mHandler.getLooper().quitSafely();
    }

    private final int $$robo$$android_net_nsd_NsdManager$nextListenerKey() {
        this.mListenerKey = Math.max(1, this.mListenerKey + 1);
        return this.mListenerKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_nsd_NsdManager$putListener(Object listener, NsdServiceInfo s) {
        int key;
        NsdManager.checkListener(listener);
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            Preconditions.checkArgument(valueIndex == -1, "listener already in use");
            key = this.nextListenerKey();
            this.mListenerMap.put(key, listener);
            this.mServiceMap.put(key, s);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_nsd_NsdManager$removeListener(int key) {
        Object object = this.mMapLock;
        synchronized (object) {
            this.mListenerMap.remove(key);
            this.mServiceMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_nsd_NsdManager$getListenerKey(Object listener) {
        NsdManager.checkListener(listener);
        Object object = this.mMapLock;
        synchronized (object) {
            int valueIndex = this.mListenerMap.indexOfValue(listener);
            Preconditions.checkArgument(valueIndex != -1, "listener not registered");
            return this.mListenerMap.keyAt(valueIndex);
        }
    }

    private static final String $$robo$$android_net_nsd_NsdManager$getNsdServiceInfoType(NsdServiceInfo s) {
        if (s == null) {
            return "?";
        }
        return s.getServiceType();
    }

    private final void $$robo$$android_net_nsd_NsdManager$init() {
        Messenger messenger = this.getMessenger();
        if (messenger == null) {
            NsdManager.fatal("Failed to obtain service Messenger");
        }
        HandlerThread t = new HandlerThread("NsdManager");
        t.start();
        this.mHandler = new ServiceHandler(this, t.getLooper());
        this.mAsyncChannel.connect(this.mContext, (Handler)this.mHandler, messenger);
        try {
            this.mConnected.await();
        }
        catch (InterruptedException e) {
            NsdManager.fatal("Interrupted wait at init");
        }
    }

    private static final void $$robo$$android_net_nsd_NsdManager$fatal(String msg) {
        Log.e(TAG, msg);
        throw new RuntimeException(msg);
    }

    private final void $$robo$$android_net_nsd_NsdManager$registerService(NsdServiceInfo serviceInfo, int protocolType, RegistrationListener listener) {
        Preconditions.checkArgument(serviceInfo.getPort() > 0, "Invalid port number");
        NsdManager.checkServiceInfo(serviceInfo);
        NsdManager.checkProtocol(protocolType);
        int key = this.putListener(listener, serviceInfo);
        this.mAsyncChannel.sendMessage(393225, 0, key, serviceInfo);
    }

    private final void $$robo$$android_net_nsd_NsdManager$unregisterService(RegistrationListener listener) {
        int id2 = this.getListenerKey(listener);
        this.mAsyncChannel.sendMessage(393228, 0, id2);
    }

    private final void $$robo$$android_net_nsd_NsdManager$discoverServices(String serviceType, int protocolType, DiscoveryListener listener) {
        Preconditions.checkStringNotEmpty(serviceType, "Service type cannot be empty");
        NsdManager.checkProtocol(protocolType);
        NsdServiceInfo s = new NsdServiceInfo();
        s.setServiceType(serviceType);
        int key = this.putListener(listener, s);
        this.mAsyncChannel.sendMessage(393217, 0, key, s);
    }

    private final void $$robo$$android_net_nsd_NsdManager$stopServiceDiscovery(DiscoveryListener listener) {
        int id2 = this.getListenerKey(listener);
        this.mAsyncChannel.sendMessage(393222, 0, id2);
    }

    private final void $$robo$$android_net_nsd_NsdManager$resolveService(NsdServiceInfo serviceInfo, ResolveListener listener) {
        NsdManager.checkServiceInfo(serviceInfo);
        int key = this.putListener(listener, serviceInfo);
        this.mAsyncChannel.sendMessage(393234, 0, key, serviceInfo);
    }

    private final void $$robo$$android_net_nsd_NsdManager$setEnabled(boolean enabled) {
        try {
            this.mService.setEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Messenger $$robo$$android_net_nsd_NsdManager$getMessenger() {
        try {
            return this.mService.getMessenger();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static final void $$robo$$android_net_nsd_NsdManager$checkListener(Object listener) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
    }

    private static final void $$robo$$android_net_nsd_NsdManager$checkProtocol(int protocolType) {
        Preconditions.checkArgument(protocolType == 1, "Unsupported protocol");
    }

    private static final void $$robo$$android_net_nsd_NsdManager$checkServiceInfo(NsdServiceInfo serviceInfo) {
        Preconditions.checkNotNull(serviceInfo, "NsdServiceInfo cannot be null");
        Preconditions.checkStringNotEmpty(serviceInfo.getServiceName(), "Service name cannot be empty");
        Preconditions.checkStringNotEmpty(serviceInfo.getServiceType(), "Service type cannot be empty");
    }

    static void __staticInitializer__() {
        TAG = NsdManager.class.getSimpleName();
        EVENT_NAMES = new SparseArray();
        EVENT_NAMES.put(393217, "DISCOVER_SERVICES");
        EVENT_NAMES.put(393218, "DISCOVER_SERVICES_STARTED");
        EVENT_NAMES.put(393219, "DISCOVER_SERVICES_FAILED");
        EVENT_NAMES.put(393220, "SERVICE_FOUND");
        EVENT_NAMES.put(393221, "SERVICE_LOST");
        EVENT_NAMES.put(393222, "STOP_DISCOVERY");
        EVENT_NAMES.put(393223, "STOP_DISCOVERY_FAILED");
        EVENT_NAMES.put(393224, "STOP_DISCOVERY_SUCCEEDED");
        EVENT_NAMES.put(393225, "REGISTER_SERVICE");
        EVENT_NAMES.put(393226, "REGISTER_SERVICE_FAILED");
        EVENT_NAMES.put(393227, "REGISTER_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(393228, "UNREGISTER_SERVICE");
        EVENT_NAMES.put(393229, "UNREGISTER_SERVICE_FAILED");
        EVENT_NAMES.put(393230, "UNREGISTER_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(393234, "RESOLVE_SERVICE");
        EVENT_NAMES.put(393235, "RESOLVE_SERVICE_FAILED");
        EVENT_NAMES.put(393236, "RESOLVE_SERVICE_SUCCEEDED");
        EVENT_NAMES.put(393240, "ENABLE");
        EVENT_NAMES.put(393241, "DISABLE");
        EVENT_NAMES.put(393242, "NATIVE_DAEMON_EVENT");
    }

    public static String nameOf(int n) {
        return InvokeDynamicSupport.bootstrapStatic("nameOf", $$robo$$android_net_nsd_NsdManager$nameOf(int ), 0, (int)n);
    }

    private void __constructor__(Context context, INsdManager iNsdManager) {
        this.$$robo$$android_net_nsd_NsdManager$__constructor__(context, iNsdManager);
    }

    public NsdManager(Context context, INsdManager iNsdManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_nsd_NsdManager$__constructor__(android.content.Context android.net.nsd.INsdManager ), 0, this, context, iNsdManager);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_net_nsd_NsdManager$disconnect(), 0, this);
    }

    private int nextListenerKey() {
        return (int)InvokeDynamicSupport.bootstrap("nextListenerKey", $$robo$$android_net_nsd_NsdManager$nextListenerKey(), 0, this);
    }

    private int putListener(Object object, NsdServiceInfo nsdServiceInfo) {
        return (int)InvokeDynamicSupport.bootstrap("putListener", $$robo$$android_net_nsd_NsdManager$putListener(java.lang.Object android.net.nsd.NsdServiceInfo ), 0, this, object, nsdServiceInfo);
    }

    private void removeListener(int n) {
        InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_net_nsd_NsdManager$removeListener(int ), 0, this, n);
    }

    private int getListenerKey(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("getListenerKey", $$robo$$android_net_nsd_NsdManager$getListenerKey(java.lang.Object ), 0, this, object);
    }

    private static String getNsdServiceInfoType(NsdServiceInfo nsdServiceInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getNsdServiceInfoType", $$robo$$android_net_nsd_NsdManager$getNsdServiceInfoType(android.net.nsd.NsdServiceInfo ), 0, (NsdServiceInfo)nsdServiceInfo);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_net_nsd_NsdManager$init(), 0, this);
    }

    private static void fatal(String string2) {
        InvokeDynamicSupport.bootstrapStatic("fatal", $$robo$$android_net_nsd_NsdManager$fatal(java.lang.String ), 0, (String)string2);
    }

    public void registerService(NsdServiceInfo nsdServiceInfo, int n, RegistrationListener registrationListener) {
        InvokeDynamicSupport.bootstrap("registerService", $$robo$$android_net_nsd_NsdManager$registerService(android.net.nsd.NsdServiceInfo int android.net.nsd.NsdManager$RegistrationListener ), 0, this, nsdServiceInfo, n, registrationListener);
    }

    public void unregisterService(RegistrationListener registrationListener) {
        InvokeDynamicSupport.bootstrap("unregisterService", $$robo$$android_net_nsd_NsdManager$unregisterService(android.net.nsd.NsdManager$RegistrationListener ), 0, this, registrationListener);
    }

    public void discoverServices(String string2, int n, DiscoveryListener discoveryListener) {
        InvokeDynamicSupport.bootstrap("discoverServices", $$robo$$android_net_nsd_NsdManager$discoverServices(java.lang.String int android.net.nsd.NsdManager$DiscoveryListener ), 0, this, string2, n, discoveryListener);
    }

    public void stopServiceDiscovery(DiscoveryListener discoveryListener) {
        InvokeDynamicSupport.bootstrap("stopServiceDiscovery", $$robo$$android_net_nsd_NsdManager$stopServiceDiscovery(android.net.nsd.NsdManager$DiscoveryListener ), 0, this, discoveryListener);
    }

    public void resolveService(NsdServiceInfo nsdServiceInfo, ResolveListener resolveListener) {
        InvokeDynamicSupport.bootstrap("resolveService", $$robo$$android_net_nsd_NsdManager$resolveService(android.net.nsd.NsdServiceInfo android.net.nsd.NsdManager$ResolveListener ), 0, this, nsdServiceInfo, resolveListener);
    }

    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_net_nsd_NsdManager$setEnabled(boolean ), 0, this, bl);
    }

    private Messenger getMessenger() {
        return InvokeDynamicSupport.bootstrap("getMessenger", $$robo$$android_net_nsd_NsdManager$getMessenger(), 0, this);
    }

    private static void checkListener(Object object) {
        InvokeDynamicSupport.bootstrapStatic("checkListener", $$robo$$android_net_nsd_NsdManager$checkListener(java.lang.Object ), 0, (Object)object);
    }

    private static void checkProtocol(int n) {
        InvokeDynamicSupport.bootstrapStatic("checkProtocol", $$robo$$android_net_nsd_NsdManager$checkProtocol(int ), 0, (int)n);
    }

    private static void checkServiceInfo(NsdServiceInfo nsdServiceInfo) {
        InvokeDynamicSupport.bootstrapStatic("checkServiceInfo", $$robo$$android_net_nsd_NsdManager$checkServiceInfo(android.net.nsd.NsdServiceInfo ), 0, (NsdServiceInfo)nsdServiceInfo);
    }

    static {
        RobolectricInternals.classInitializing(NsdManager.class);
    }

    public /* synthetic */ NsdManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NsdManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @VisibleForTesting
    public class ServiceHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NsdManager this$0;

        private void $$robo$$android_net_nsd_NsdManager_ServiceHandler$__constructor__(NsdManager this$0, Looper looper) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_nsd_NsdManager_ServiceHandler$handleMessage(Message message) {
            NsdServiceInfo ns;
            Object listener;
            int what = message.what;
            int key = message.arg2;
            switch (what) {
                case 69632: {
                    this.this$0.mAsyncChannel.sendMessage(69633);
                    return;
                }
                case 69634: {
                    this.this$0.mConnected.countDown();
                    return;
                }
                case 69636: {
                    Log.e(TAG, "Channel lost");
                    return;
                }
            }
            Object object = this.this$0.mMapLock;
            synchronized (object) {
                listener = this.this$0.mListenerMap.get(key);
                ns = (NsdServiceInfo)this.this$0.mServiceMap.get(key);
            }
            if (listener == null) {
                Log.d(TAG, "Stale key " + message.arg2);
                return;
            }
            switch (what) {
                case 393218: {
                    String s = NsdManager.getNsdServiceInfoType((NsdServiceInfo)message.obj);
                    ((DiscoveryListener)listener).onDiscoveryStarted(s);
                    break;
                }
                case 393219: {
                    this.this$0.removeListener(key);
                    ((DiscoveryListener)listener).onStartDiscoveryFailed(NsdManager.getNsdServiceInfoType(ns), message.arg1);
                    break;
                }
                case 393220: {
                    ((DiscoveryListener)listener).onServiceFound((NsdServiceInfo)message.obj);
                    break;
                }
                case 393221: {
                    ((DiscoveryListener)listener).onServiceLost((NsdServiceInfo)message.obj);
                    break;
                }
                case 393223: {
                    this.this$0.removeListener(key);
                    ((DiscoveryListener)listener).onStopDiscoveryFailed(NsdManager.getNsdServiceInfoType(ns), message.arg1);
                    break;
                }
                case 393224: {
                    this.this$0.removeListener(key);
                    ((DiscoveryListener)listener).onDiscoveryStopped(NsdManager.getNsdServiceInfoType(ns));
                    break;
                }
                case 393226: {
                    this.this$0.removeListener(key);
                    ((RegistrationListener)listener).onRegistrationFailed(ns, message.arg1);
                    break;
                }
                case 393227: {
                    ((RegistrationListener)listener).onServiceRegistered((NsdServiceInfo)message.obj);
                    break;
                }
                case 393229: {
                    this.this$0.removeListener(key);
                    ((RegistrationListener)listener).onUnregistrationFailed(ns, message.arg1);
                    break;
                }
                case 393230: {
                    this.this$0.removeListener(message.arg2);
                    ((RegistrationListener)listener).onServiceUnregistered(ns);
                    break;
                }
                case 393235: {
                    this.this$0.removeListener(key);
                    ((ResolveListener)listener).onResolveFailed(ns, message.arg1);
                    break;
                }
                case 393236: {
                    this.this$0.removeListener(key);
                    ((ResolveListener)listener).onServiceResolved((NsdServiceInfo)message.obj);
                    break;
                }
                default: {
                    Log.d(TAG, "Ignored " + message);
                }
            }
        }

        private void __constructor__(NsdManager nsdManager, Looper looper) {
            this.$$robo$$android_net_nsd_NsdManager_ServiceHandler$__constructor__(nsdManager, looper);
        }

        ServiceHandler(NsdManager nsdManager, Looper looper) {
            this.this$0 = nsdManager;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_nsd_NsdManager_ServiceHandler$__constructor__(android.net.nsd.NsdManager android.os.Looper ), 0, this, nsdManager, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_nsd_NsdManager_ServiceHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ ServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ResolveListener
    extends InstrumentedInterface {
        public void onResolveFailed(NsdServiceInfo var1, int var2);

        public void onServiceResolved(NsdServiceInfo var1);
    }

    public static interface RegistrationListener
    extends InstrumentedInterface {
        public void onRegistrationFailed(NsdServiceInfo var1, int var2);

        public void onUnregistrationFailed(NsdServiceInfo var1, int var2);

        public void onServiceRegistered(NsdServiceInfo var1);

        public void onServiceUnregistered(NsdServiceInfo var1);
    }

    public static interface DiscoveryListener
    extends InstrumentedInterface {
        public void onStartDiscoveryFailed(String var1, int var2);

        public void onStopDiscoveryFailed(String var1, int var2);

        public void onDiscoveryStarted(String var1);

        public void onDiscoveryStopped(String var1);

        public void onServiceFound(NsdServiceInfo var1);

        public void onServiceLost(NsdServiceInfo var1);
    }
}

