/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.net.DhcpInfo;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.wifi.ISoftApCallback;
import android.net.wifi.IWifiManager;
import android.net.wifi.RssiPacketCountInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiActivityEnergyInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WpsInfo;
import android.net.wifi.hotspot2.IProvisioningCallback;
import android.net.wifi.hotspot2.OsuProvider;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.net.wifi.hotspot2.ProvisioningCallback;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.AsyncChannel;
import com.android.server.net.NetworkPinner;
import dalvik.system.CloseGuard;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiManager";
    @Deprecated
    public static int ERROR_AUTHENTICATING = 1;
    @Deprecated
    public static int ERROR_AUTH_FAILURE_NONE = 0;
    @Deprecated
    public static int ERROR_AUTH_FAILURE_TIMEOUT = 1;
    @Deprecated
    public static int ERROR_AUTH_FAILURE_WRONG_PSWD = 2;
    @Deprecated
    public static int ERROR_AUTH_FAILURE_EAP_FAILURE = 3;
    public static String WIFI_SCAN_AVAILABLE = "wifi_scan_available";
    public static String EXTRA_SCAN_AVAILABLE = "scan_enabled";
    @SystemApi
    public static String WIFI_CREDENTIAL_CHANGED_ACTION = "android.net.wifi.WIFI_CREDENTIAL_CHANGED";
    @SystemApi
    public static String EXTRA_WIFI_CREDENTIAL_EVENT_TYPE = "et";
    @SystemApi
    public static String EXTRA_WIFI_CREDENTIAL_SSID = "ssid";
    @SystemApi
    public static int WIFI_CREDENTIAL_SAVED = 0;
    @SystemApi
    public static int WIFI_CREDENTIAL_FORGOT = 1;
    public static String ACTION_PASSPOINT_ICON = "android.net.wifi.action.PASSPOINT_ICON";
    public static String EXTRA_BSSID_LONG = "android.net.wifi.extra.BSSID_LONG";
    public static String EXTRA_ICON = "android.net.wifi.extra.ICON";
    public static String EXTRA_FILENAME = "android.net.wifi.extra.FILENAME";
    public static String ACTION_PASSPOINT_OSU_PROVIDERS_LIST = "android.net.wifi.action.PASSPOINT_OSU_PROVIDERS_LIST";
    public static String EXTRA_ANQP_ELEMENT_DATA = "android.net.wifi.extra.ANQP_ELEMENT_DATA";
    public static String ACTION_PASSPOINT_DEAUTH_IMMINENT = "android.net.wifi.action.PASSPOINT_DEAUTH_IMMINENT";
    public static String EXTRA_ESS = "android.net.wifi.extra.ESS";
    public static String EXTRA_DELAY = "android.net.wifi.extra.DELAY";
    public static String EXTRA_URL = "android.net.wifi.extra.URL";
    public static String ACTION_PASSPOINT_SUBSCRIPTION_REMEDIATION = "android.net.wifi.action.PASSPOINT_SUBSCRIPTION_REMEDIATION";
    public static String EXTRA_SUBSCRIPTION_REMEDIATION_METHOD = "android.net.wifi.extra.SUBSCRIPTION_REMEDIATION_METHOD";
    public static String WIFI_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_STATE_CHANGED";
    public static String EXTRA_WIFI_STATE = "wifi_state";
    public static String EXTRA_PREVIOUS_WIFI_STATE = "previous_wifi_state";
    public static int WIFI_STATE_DISABLING = 0;
    public static int WIFI_STATE_DISABLED = 1;
    public static int WIFI_STATE_ENABLING = 2;
    public static int WIFI_STATE_ENABLED = 3;
    public static int WIFI_STATE_UNKNOWN = 4;
    @SystemApi
    public static String WIFI_AP_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_AP_STATE_CHANGED";
    @SystemApi
    public static String EXTRA_WIFI_AP_STATE = "wifi_state";
    public static String EXTRA_WIFI_AP_FAILURE_REASON = "wifi_ap_error_code";
    @SystemApi
    public static String EXTRA_PREVIOUS_WIFI_AP_STATE = "previous_wifi_state";
    public static String EXTRA_WIFI_AP_INTERFACE_NAME = "wifi_ap_interface_name";
    public static String EXTRA_WIFI_AP_MODE = "wifi_ap_mode";
    @SystemApi
    public static int WIFI_AP_STATE_DISABLING = 10;
    @SystemApi
    public static int WIFI_AP_STATE_DISABLED = 11;
    @SystemApi
    public static int WIFI_AP_STATE_ENABLING = 12;
    @SystemApi
    public static int WIFI_AP_STATE_ENABLED = 13;
    @SystemApi
    public static int WIFI_AP_STATE_FAILED = 14;
    public static int SAP_START_FAILURE_GENERAL = 0;
    public static int SAP_START_FAILURE_NO_CHANNEL = 1;
    public static int IFACE_IP_MODE_UNSPECIFIED = -1;
    public static int IFACE_IP_MODE_CONFIGURATION_ERROR = 0;
    public static int IFACE_IP_MODE_TETHERED = 1;
    public static int IFACE_IP_MODE_LOCAL_ONLY = 2;
    @Deprecated
    public static String SUPPLICANT_CONNECTION_CHANGE_ACTION = "android.net.wifi.supplicant.CONNECTION_CHANGE";
    @Deprecated
    public static String EXTRA_SUPPLICANT_CONNECTED = "connected";
    public static String NETWORK_STATE_CHANGED_ACTION = "android.net.wifi.STATE_CHANGE";
    public static String EXTRA_NETWORK_INFO = "networkInfo";
    @Deprecated
    public static String EXTRA_BSSID = "bssid";
    @Deprecated
    public static String EXTRA_WIFI_INFO = "wifiInfo";
    @Deprecated
    public static String SUPPLICANT_STATE_CHANGED_ACTION = "android.net.wifi.supplicant.STATE_CHANGE";
    @Deprecated
    public static String EXTRA_NEW_STATE = "newState";
    @Deprecated
    public static String EXTRA_SUPPLICANT_ERROR = "supplicantError";
    @Deprecated
    public static String EXTRA_SUPPLICANT_ERROR_REASON = "supplicantErrorReason";
    @SystemApi
    public static String CONFIGURED_NETWORKS_CHANGED_ACTION = "android.net.wifi.CONFIGURED_NETWORKS_CHANGE";
    @SystemApi
    public static String EXTRA_WIFI_CONFIGURATION = "wifiConfiguration";
    @SystemApi
    public static String EXTRA_MULTIPLE_NETWORKS_CHANGED = "multipleChanges";
    @SystemApi
    public static String EXTRA_CHANGE_REASON = "changeReason";
    @SystemApi
    public static int CHANGE_REASON_ADDED = 0;
    @SystemApi
    public static int CHANGE_REASON_REMOVED = 1;
    @SystemApi
    public static int CHANGE_REASON_CONFIG_CHANGE = 2;
    public static String SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.SCAN_RESULTS";
    public static String EXTRA_RESULTS_UPDATED = "resultsUpdated";
    @Deprecated
    public static String BATCHED_SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.BATCHED_RESULTS";
    public static String RSSI_CHANGED_ACTION = "android.net.wifi.RSSI_CHANGED";
    public static String EXTRA_NEW_RSSI = "newRssi";
    public static String LINK_CONFIGURATION_CHANGED_ACTION = "android.net.wifi.LINK_CONFIGURATION_CHANGED";
    public static String EXTRA_LINK_PROPERTIES = "linkProperties";
    public static String EXTRA_NETWORK_CAPABILITIES = "networkCapabilities";
    public static String NETWORK_IDS_CHANGED_ACTION = "android.net.wifi.NETWORK_IDS_CHANGED";
    public static String ACTION_REQUEST_SCAN_ALWAYS_AVAILABLE = "android.net.wifi.action.REQUEST_SCAN_ALWAYS_AVAILABLE";
    public static String ACTION_PICK_WIFI_NETWORK = "android.net.wifi.PICK_WIFI_NETWORK";
    public static String ACTION_REQUEST_ENABLE = "android.net.wifi.action.REQUEST_ENABLE";
    public static String ACTION_REQUEST_DISABLE = "android.net.wifi.action.REQUEST_DISABLE";
    public static int WIFI_MODE_NO_LOCKS_HELD = 0;
    public static int WIFI_MODE_FULL = 1;
    public static int WIFI_MODE_SCAN_ONLY = 2;
    public static int WIFI_MODE_FULL_HIGH_PERF = 3;
    private static int MIN_RSSI = -100;
    private static int MAX_RSSI = -55;
    public static int RSSI_LEVELS = 5;
    public static int WIFI_FREQUENCY_BAND_AUTO = 0;
    public static int WIFI_FREQUENCY_BAND_5GHZ = 1;
    public static int WIFI_FREQUENCY_BAND_2GHZ = 2;
    public static int DATA_ACTIVITY_NOTIFICATION = 1;
    public static int DATA_ACTIVITY_NONE = 0;
    public static int DATA_ACTIVITY_IN = 1;
    public static int DATA_ACTIVITY_OUT = 2;
    public static int DATA_ACTIVITY_INOUT = 3;
    public static boolean DEFAULT_POOR_NETWORK_AVOIDANCE_ENABLED = false;
    private static int MAX_ACTIVE_LOCKS = 50;
    private int mActiveLockCount;
    private Context mContext;
    IWifiManager mService;
    private int mTargetSdkVersion;
    private static int INVALID_KEY = 0;
    private int mListenerKey;
    private SparseArray mListenerMap;
    private Object mListenerMapLock;
    private AsyncChannel mAsyncChannel;
    private CountDownLatch mConnected;
    private Looper mLooper;
    public static int HOTSPOT_STARTED = 0;
    public static int HOTSPOT_STOPPED = 1;
    public static int HOTSPOT_FAILED = 2;
    public static int HOTSPOT_OBSERVER_REGISTERED = 3;
    private Object mLock;
    @GuardedBy(value="mLock")
    private LocalOnlyHotspotCallbackProxy mLOHSCallbackProxy;
    @GuardedBy(value="mLock")
    private LocalOnlyHotspotObserverProxy mLOHSObserverProxy;
    public static int WIFI_FEATURE_INFRA = 1;
    public static int WIFI_FEATURE_INFRA_5G = 2;
    public static int WIFI_FEATURE_PASSPOINT = 4;
    public static int WIFI_FEATURE_P2P = 8;
    public static int WIFI_FEATURE_MOBILE_HOTSPOT = 16;
    public static int WIFI_FEATURE_SCANNER = 32;
    public static int WIFI_FEATURE_AWARE = 64;
    public static int WIFI_FEATURE_D2D_RTT = 128;
    public static int WIFI_FEATURE_D2AP_RTT = 256;
    public static int WIFI_FEATURE_BATCH_SCAN = 512;
    public static int WIFI_FEATURE_PNO = 1024;
    public static int WIFI_FEATURE_ADDITIONAL_STA = 2048;
    public static int WIFI_FEATURE_TDLS = 4096;
    public static int WIFI_FEATURE_TDLS_OFFCHANNEL = 8192;
    public static int WIFI_FEATURE_EPR = 16384;
    public static int WIFI_FEATURE_AP_STA = 32768;
    public static int WIFI_FEATURE_LINK_LAYER_STATS = 65536;
    public static int WIFI_FEATURE_LOGGER = 131072;
    public static int WIFI_FEATURE_HAL_EPNO = 262144;
    public static int WIFI_FEATURE_RSSI_MONITOR = 524288;
    public static int WIFI_FEATURE_MKEEP_ALIVE = 0x100000;
    public static int WIFI_FEATURE_CONFIG_NDO = 0x200000;
    public static int WIFI_FEATURE_TRANSMIT_POWER = 0x400000;
    public static int WIFI_FEATURE_CONTROL_ROAMING = 0x800000;
    public static int WIFI_FEATURE_IE_WHITELIST = 0x1000000;
    public static int WIFI_FEATURE_SCAN_RAND = 0x2000000;
    public static int WIFI_FEATURE_TX_POWER_LIMIT = 0x4000000;
    private static int BASE = 151552;
    public static int CONNECT_NETWORK = 151553;
    public static int CONNECT_NETWORK_FAILED = 151554;
    public static int CONNECT_NETWORK_SUCCEEDED = 151555;
    public static int FORGET_NETWORK = 151556;
    public static int FORGET_NETWORK_FAILED = 151557;
    public static int FORGET_NETWORK_SUCCEEDED = 151558;
    public static int SAVE_NETWORK = 151559;
    public static int SAVE_NETWORK_FAILED = 151560;
    public static int SAVE_NETWORK_SUCCEEDED = 151561;
    public static int START_WPS = 151562;
    public static int START_WPS_SUCCEEDED = 151563;
    public static int WPS_FAILED = 151564;
    public static int WPS_COMPLETED = 151565;
    public static int CANCEL_WPS = 151566;
    public static int CANCEL_WPS_FAILED = 151567;
    public static int CANCEL_WPS_SUCCEDED = 151568;
    public static int DISABLE_NETWORK = 151569;
    public static int DISABLE_NETWORK_FAILED = 151570;
    public static int DISABLE_NETWORK_SUCCEEDED = 151571;
    public static int RSSI_PKTCNT_FETCH = 151572;
    public static int RSSI_PKTCNT_FETCH_SUCCEEDED = 151573;
    public static int RSSI_PKTCNT_FETCH_FAILED = 151574;
    public static int ERROR = 0;
    public static int IN_PROGRESS = 1;
    public static int BUSY = 2;
    public static int WPS_OVERLAP_ERROR = 3;
    public static int WPS_WEP_PROHIBITED = 4;
    public static int WPS_TKIP_ONLY_PROHIBITED = 5;
    public static int WPS_AUTH_FAILURE = 6;
    public static int WPS_TIMED_OUT = 7;
    public static int INVALID_ARGS = 8;
    public static int NOT_AUTHORIZED = 9;
    private static Object sServiceHandlerDispatchLock;

    private void $$robo$$android_net_wifi_WifiManager$__constructor__(Context context, IWifiManager service, Looper looper) {
        this.mListenerKey = 1;
        this.mListenerMap = new SparseArray();
        this.mListenerMapLock = new Object();
        this.mLock = new Object();
        this.mContext = context;
        this.mService = service;
        this.mLooper = looper;
        this.mTargetSdkVersion = context.getApplicationInfo().targetSdkVersion;
    }

    private final List<WifiConfiguration> $$robo$$android_net_wifi_WifiManager$getConfiguredNetworks() {
        try {
            ParceledListSlice parceledList = this.mService.getConfiguredNetworks();
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final List<WifiConfiguration> $$robo$$android_net_wifi_WifiManager$getPrivilegedConfiguredNetworks() {
        try {
            ParceledListSlice parceledList = this.mService.getPrivilegedConfiguredNetworks();
            if (parceledList == null) {
                return Collections.emptyList();
            }
            return parceledList.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final WifiConfiguration $$robo$$android_net_wifi_WifiManager$getMatchingWifiConfig(ScanResult scanResult) {
        try {
            return this.mService.getMatchingWifiConfig(scanResult);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<WifiConfiguration> $$robo$$android_net_wifi_WifiManager$getAllMatchingWifiConfigs(ScanResult scanResult) {
        try {
            return this.mService.getAllMatchingWifiConfigs(scanResult);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<OsuProvider> $$robo$$android_net_wifi_WifiManager$getMatchingOsuProviders(ScanResult scanResult) {
        try {
            return this.mService.getMatchingOsuProviders(scanResult);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_wifi_WifiManager$addNetwork(WifiConfiguration config) {
        if (config == null) {
            return -1;
        }
        config.networkId = -1;
        return this.addOrUpdateNetwork(config);
    }

    private final int $$robo$$android_net_wifi_WifiManager$updateNetwork(WifiConfiguration config) {
        if (config == null || config.networkId < 0) {
            return -1;
        }
        return this.addOrUpdateNetwork(config);
    }

    private final int $$robo$$android_net_wifi_WifiManager$addOrUpdateNetwork(WifiConfiguration config) {
        try {
            return this.mService.addOrUpdateNetwork(config, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$addOrUpdatePasspointConfiguration(PasspointConfiguration config) {
        try {
            if (!this.mService.addOrUpdatePasspointConfiguration(config, this.mContext.getOpPackageName())) {
                throw new IllegalArgumentException();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$removePasspointConfiguration(String fqdn) {
        try {
            if (!this.mService.removePasspointConfiguration(fqdn, this.mContext.getOpPackageName())) {
                throw new IllegalArgumentException();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<PasspointConfiguration> $$robo$$android_net_wifi_WifiManager$getPasspointConfigurations() {
        try {
            return this.mService.getPasspointConfigurations();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$queryPasspointIcon(long bssid, String fileName) {
        try {
            this.mService.queryPasspointIcon(bssid, fileName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_wifi_WifiManager$matchProviderWithCurrentNetwork(String fqdn) {
        try {
            return this.mService.matchProviderWithCurrentNetwork(fqdn);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$deauthenticateNetwork(long holdoff, boolean ess) {
        try {
            this.mService.deauthenticateNetwork(holdoff, ess);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$removeNetwork(int netId) {
        try {
            return this.mService.removeNetwork(netId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$enableNetwork(int netId, boolean attemptConnect) {
        boolean success;
        boolean pin;
        boolean bl = pin = attemptConnect && this.mTargetSdkVersion < 21;
        if (pin) {
            NetworkRequest request = new NetworkRequest.Builder().clearCapabilities().addCapability(15).addTransportType(1).build();
            NetworkPinner.pin(this.mContext, request);
        }
        try {
            success = this.mService.enableNetwork(netId, attemptConnect, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (pin && !success) {
            NetworkPinner.unpin();
        }
        return success;
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$disableNetwork(int netId) {
        try {
            return this.mService.disableNetwork(netId, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$disconnect() {
        try {
            this.mService.disconnect(this.mContext.getOpPackageName());
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$reconnect() {
        try {
            this.mService.reconnect(this.mContext.getOpPackageName());
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$reassociate() {
        try {
            this.mService.reassociate(this.mContext.getOpPackageName());
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_net_wifi_WifiManager$pingSupplicant() {
        return this.isWifiEnabled();
    }

    private final int $$robo$$android_net_wifi_WifiManager$getSupportedFeatures() {
        try {
            return this.mService.getSupportedFeatures();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isFeatureSupported(int feature) {
        return (this.getSupportedFeatures() & feature) == feature;
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$is5GHzBandSupported() {
        return this.isFeatureSupported(2);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isPasspointSupported() {
        return this.isFeatureSupported(4);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isP2pSupported() {
        return this.isFeatureSupported(8);
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiManager$isPortableHotspotSupported() {
        return this.isFeatureSupported(16);
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiManager$isWifiScannerSupported() {
        return this.isFeatureSupported(32);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isWifiAwareSupported() {
        return this.isFeatureSupported(64);
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiManager$isDeviceToDeviceRttSupported() {
        return this.isFeatureSupported(128);
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiManager$isDeviceToApRttSupported() {
        return this.isFeatureSupported(256);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isPreferredNetworkOffloadSupported() {
        return this.isFeatureSupported(1024);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isAdditionalStaSupported() {
        return this.isFeatureSupported(2048);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isTdlsSupported() {
        return this.isFeatureSupported(4096);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isOffChannelTdlsSupported() {
        return this.isFeatureSupported(8192);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isEnhancedPowerReportingSupported() {
        return this.isFeatureSupported(65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WifiActivityEnergyInfo $$robo$$android_net_wifi_WifiManager$getControllerActivityEnergyInfo(int updateType) {
        if (this.mService == null) {
            return null;
        }
        try {
            WifiManager wifiManager = this;
            synchronized (wifiManager) {
                return this.mService.reportActivityInfo();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_net_wifi_WifiManager$startScan() {
        return this.startScan(null);
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiManager$startScan(WorkSource workSource) {
        try {
            String packageName = this.mContext.getOpPackageName();
            return this.mService.startScan(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_net_wifi_WifiManager$getCurrentNetworkWpsNfcConfigurationToken() {
        return null;
    }

    private final WifiInfo $$robo$$android_net_wifi_WifiManager$getConnectionInfo() {
        try {
            return this.mService.getConnectionInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<ScanResult> $$robo$$android_net_wifi_WifiManager$getScanResults() {
        try {
            return this.mService.getScanResults(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isScanAlwaysAvailable() {
        try {
            return this.mService.isScanAlwaysAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_net_wifi_WifiManager$saveConfiguration() {
        return true;
    }

    private final void $$robo$$android_net_wifi_WifiManager$setCountryCode(String country) {
        try {
            this.mService.setCountryCode(country);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final String $$robo$$android_net_wifi_WifiManager$getCountryCode() {
        try {
            String country = this.mService.getCountryCode();
            return country;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isDualBandSupported() {
        try {
            return this.mService.isDualBandSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isDualModeSupported() {
        try {
            return this.mService.needs5GHzToAnyApBandConversion();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final DhcpInfo $$robo$$android_net_wifi_WifiManager$getDhcpInfo() {
        try {
            return this.mService.getDhcpInfo();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$setWifiEnabled(boolean enabled) {
        try {
            return this.mService.setWifiEnabled(this.mContext.getOpPackageName(), enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_net_wifi_WifiManager$getWifiState() {
        try {
            return this.mService.getWifiEnabledState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isWifiEnabled() {
        return this.getWifiState() == 3;
    }

    private final void $$robo$$android_net_wifi_WifiManager$getTxPacketCount(TxPacketCountListener listener) {
        this.getChannel().sendMessage(151572, 0, this.putListener(listener));
    }

    private static final int $$robo$$android_net_wifi_WifiManager$calculateSignalLevel(int rssi, int numLevels) {
        if (rssi <= -100) {
            return 0;
        }
        if (rssi >= -55) {
            return numLevels - 1;
        }
        float inputRange = 45.0f;
        float outputRange = numLevels - 1;
        return (int)((float)(rssi - -100) * outputRange / inputRange);
    }

    private static final int $$robo$$android_net_wifi_WifiManager$compareSignalLevel(int rssiA, int rssiB) {
        return rssiA - rssiB;
    }

    private final void $$robo$$android_net_wifi_WifiManager$updateInterfaceIpState(String ifaceName, int mode) {
        try {
            this.mService.updateInterfaceIpState(ifaceName, mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$startSoftAp(WifiConfiguration wifiConfig) {
        try {
            return this.mService.startSoftAp(wifiConfig);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$stopSoftAp() {
        try {
            return this.mService.stopSoftAp();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiManager$startLocalOnlyHotspot(LocalOnlyHotspotCallback callback, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            Looper looper = handler == null ? this.mContext.getMainLooper() : handler.getLooper();
            LocalOnlyHotspotCallbackProxy proxy = new LocalOnlyHotspotCallbackProxy(this, looper, callback);
            try {
                String packageName = this.mContext.getOpPackageName();
                int returnCode = this.mService.startLocalOnlyHotspot(proxy.getMessenger(), new Binder(), packageName);
                if (returnCode != 0) {
                    proxy.notifyFailed(returnCode);
                    return;
                }
                this.mLOHSCallbackProxy = proxy;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiManager$cancelLocalOnlyHotspotRequest() {
        Object object = this.mLock;
        synchronized (object) {
            this.stopLocalOnlyHotspot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiManager$stopLocalOnlyHotspot() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLOHSCallbackProxy == null) {
                return;
            }
            this.mLOHSCallbackProxy = null;
            try {
                this.mService.stopLocalOnlyHotspot();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiManager$watchLocalOnlyHotspot(LocalOnlyHotspotObserver observer, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            Looper looper = handler == null ? this.mContext.getMainLooper() : handler.getLooper();
            this.mLOHSObserverProxy = new LocalOnlyHotspotObserverProxy(this, looper, observer);
            try {
                this.mService.startWatchLocalOnlyHotspot(this.mLOHSObserverProxy.getMessenger(), new Binder());
                this.mLOHSObserverProxy.registered();
            }
            catch (RemoteException e) {
                this.mLOHSObserverProxy = null;
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiManager$unregisterLocalOnlyHotspotObserver() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mLOHSObserverProxy == null) {
                return;
            }
            this.mLOHSObserverProxy = null;
            try {
                this.mService.stopWatchLocalOnlyHotspot();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @SystemApi
    private final int $$robo$$android_net_wifi_WifiManager$getWifiApState() {
        try {
            return this.mService.getWifiApEnabledState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiManager$isWifiApEnabled() {
        return this.getWifiApState() == 13;
    }

    @SystemApi
    private final WifiConfiguration $$robo$$android_net_wifi_WifiManager$getWifiApConfiguration() {
        try {
            return this.mService.getWifiApConfiguration();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiManager$setWifiApConfiguration(WifiConfiguration wifiConfig) {
        try {
            return this.mService.setWifiApConfiguration(wifiConfig, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$notifyUserOfApBandConversion() {
        Log.d("WifiManager", "apBand was converted, notify the user");
        try {
            this.mService.notifyUserOfApBandConversion(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$setTdlsEnabled(InetAddress remoteIPAddress, boolean enable) {
        try {
            this.mService.enableTdls(remoteIPAddress.getHostAddress(), enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$setTdlsEnabledWithMacAddress(String remoteMacAddress, boolean enable) {
        try {
            this.mService.enableTdlsWithMacAddress(remoteMacAddress, enable);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$registerSoftApCallback(SoftApCallback callback, Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v("WifiManager", "registerSoftApCallback: callback=" + callback + ", handler=" + handler);
        Looper looper = handler == null ? this.mContext.getMainLooper() : handler.getLooper();
        Binder binder = new Binder();
        try {
            this.mService.registerSoftApCallback(binder, new SoftApCallbackProxy(looper, callback), callback.hashCode());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$unregisterSoftApCallback(SoftApCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        Log.v("WifiManager", "unregisterSoftApCallback: callback=" + callback);
        try {
            this.mService.unregisterSoftApCallback(callback.hashCode());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_net_wifi_WifiManager$putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            do {
                ++this.mListenerKey;
            } while (key == 0);
            this.mListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_net_wifi_WifiManager$removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = this.mListenerMapLock;
        synchronized (object) {
            Object listener = this.mListenerMap.get(key);
            this.mListenerMap.remove(key);
            return listener;
        }
    }

    private final synchronized AsyncChannel $$robo$$android_net_wifi_WifiManager$getChannel() {
        if (this.mAsyncChannel == null) {
            Messenger messenger = this.getWifiServiceMessenger();
            if (messenger == null) {
                throw new IllegalStateException("getWifiServiceMessenger() returned null!  This is invalid.");
            }
            this.mAsyncChannel = new AsyncChannel();
            this.mConnected = new CountDownLatch(1);
            ServiceHandler handler = new ServiceHandler(this, this.mLooper);
            this.mAsyncChannel.connect(this.mContext, (Handler)handler, messenger);
            try {
                this.mConnected.await();
            }
            catch (InterruptedException e) {
                Log.e("WifiManager", "interrupted wait at init");
            }
        }
        return this.mAsyncChannel;
    }

    @SystemApi
    private final void $$robo$$android_net_wifi_WifiManager$connect(WifiConfiguration config, ActionListener listener) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.getChannel().sendMessage(151553, -1, this.putListener(listener), config);
    }

    private final void $$robo$$android_net_wifi_WifiManager$connect(int networkId, ActionListener listener) {
        if (networkId < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        this.getChannel().sendMessage(151553, networkId, this.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_WifiManager$save(WifiConfiguration config, ActionListener listener) {
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.getChannel().sendMessage(151559, 0, this.putListener(listener), config);
    }

    private final void $$robo$$android_net_wifi_WifiManager$forget(int netId, ActionListener listener) {
        if (netId < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        this.getChannel().sendMessage(151556, netId, this.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_WifiManager$disable(int netId, ActionListener listener) {
        if (netId < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        this.getChannel().sendMessage(151569, netId, this.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_WifiManager$disableEphemeralNetwork(String SSID) {
        if (SSID == null) {
            throw new IllegalArgumentException("SSID cannot be null");
        }
        try {
            this.mService.disableEphemeralNetwork(SSID, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$startWps(WpsInfo config, WpsCallback listener) {
        if (listener != null) {
            listener.onFailed(0);
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$cancelWps(WpsCallback listener) {
        if (listener != null) {
            listener.onFailed(0);
        }
    }

    private final Messenger $$robo$$android_net_wifi_WifiManager$getWifiServiceMessenger() {
        try {
            return this.mService.getWifiServiceMessenger(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final WifiLock $$robo$$android_net_wifi_WifiManager$createWifiLock(int lockType, String tag) {
        return new WifiLock(this, lockType, tag);
    }

    private final WifiLock $$robo$$android_net_wifi_WifiManager$createWifiLock(String tag) {
        return new WifiLock(this, 1, tag);
    }

    private final MulticastLock $$robo$$android_net_wifi_WifiManager$createMulticastLock(String tag) {
        return new MulticastLock(this, tag);
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$isMulticastEnabled() {
        try {
            return this.mService.isMulticastEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$initializeMulticastFiltering() {
        try {
            this.mService.initializeMulticastFiltering();
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$finalize() throws Throwable {
        try {
            if (this.mAsyncChannel != null) {
                this.mAsyncChannel.disconnect();
            }
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$enableVerboseLogging(int verbose) {
        try {
            this.mService.enableVerboseLogging(verbose);
        }
        catch (Exception e) {
            Log.e("WifiManager", "enableVerboseLogging " + e.toString());
        }
    }

    private final int $$robo$$android_net_wifi_WifiManager$getVerboseLoggingLevel() {
        try {
            return this.mService.getVerboseLoggingLevel();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$factoryReset() {
        try {
            this.mService.factoryReset(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Network $$robo$$android_net_wifi_WifiManager$getCurrentNetwork() {
        try {
            return this.mService.getCurrentNetwork();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$setEnableAutoJoinWhenAssociated(boolean enabled) {
        return false;
    }

    private final boolean $$robo$$android_net_wifi_WifiManager$getEnableAutoJoinWhenAssociated() {
        return false;
    }

    private final void $$robo$$android_net_wifi_WifiManager$enableWifiConnectivityManager(boolean enabled) {
        try {
            this.mService.enableWifiConnectivityManager(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final byte[] $$robo$$android_net_wifi_WifiManager$retrieveBackupData() {
        try {
            return this.mService.retrieveBackupData();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$restoreBackupData(byte[] data) {
        try {
            this.mService.restoreBackupData(data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final void $$robo$$android_net_wifi_WifiManager$restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) {
        try {
            this.mService.restoreSupplicantBackupData(supplicantData, ipConfigData);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_net_wifi_WifiManager$startSubscriptionProvisioning(OsuProvider provider, ProvisioningCallback callback, Handler handler) {
        Looper looper = handler == null ? Looper.getMainLooper() : handler.getLooper();
        try {
            this.mService.startSubscriptionProvisioning(provider, new ProvisioningCallbackProxy(looper, callback));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void __staticInitializer__() {
        sServiceHandlerDispatchLock = new Object();
    }

    private void __constructor__(Context context, IWifiManager iWifiManager, Looper looper) {
        this.$$robo$$android_net_wifi_WifiManager$__constructor__(context, iWifiManager, looper);
    }

    public WifiManager(Context context, IWifiManager iWifiManager, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager$__constructor__(android.content.Context android.net.wifi.IWifiManager android.os.Looper ), 0, this, context, iWifiManager, looper);
    }

    public List<WifiConfiguration> getConfiguredNetworks() {
        return InvokeDynamicSupport.bootstrap("getConfiguredNetworks", $$robo$$android_net_wifi_WifiManager$getConfiguredNetworks(), 0, this);
    }

    @SystemApi
    public List<WifiConfiguration> getPrivilegedConfiguredNetworks() {
        return InvokeDynamicSupport.bootstrap("getPrivilegedConfiguredNetworks", $$robo$$android_net_wifi_WifiManager$getPrivilegedConfiguredNetworks(), 0, this);
    }

    public WifiConfiguration getMatchingWifiConfig(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrap("getMatchingWifiConfig", $$robo$$android_net_wifi_WifiManager$getMatchingWifiConfig(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    public List<WifiConfiguration> getAllMatchingWifiConfigs(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrap("getAllMatchingWifiConfigs", $$robo$$android_net_wifi_WifiManager$getAllMatchingWifiConfigs(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    public List<OsuProvider> getMatchingOsuProviders(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrap("getMatchingOsuProviders", $$robo$$android_net_wifi_WifiManager$getMatchingOsuProviders(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    public int addNetwork(WifiConfiguration wifiConfiguration) {
        return (int)InvokeDynamicSupport.bootstrap("addNetwork", $$robo$$android_net_wifi_WifiManager$addNetwork(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
    }

    public int updateNetwork(WifiConfiguration wifiConfiguration) {
        return (int)InvokeDynamicSupport.bootstrap("updateNetwork", $$robo$$android_net_wifi_WifiManager$updateNetwork(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
    }

    private int addOrUpdateNetwork(WifiConfiguration wifiConfiguration) {
        return (int)InvokeDynamicSupport.bootstrap("addOrUpdateNetwork", $$robo$$android_net_wifi_WifiManager$addOrUpdateNetwork(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
    }

    public void addOrUpdatePasspointConfiguration(PasspointConfiguration passpointConfiguration) {
        InvokeDynamicSupport.bootstrap("addOrUpdatePasspointConfiguration", $$robo$$android_net_wifi_WifiManager$addOrUpdatePasspointConfiguration(android.net.wifi.hotspot2.PasspointConfiguration ), 0, this, passpointConfiguration);
    }

    public void removePasspointConfiguration(String string2) {
        InvokeDynamicSupport.bootstrap("removePasspointConfiguration", $$robo$$android_net_wifi_WifiManager$removePasspointConfiguration(java.lang.String ), 0, this, string2);
    }

    public List<PasspointConfiguration> getPasspointConfigurations() {
        return InvokeDynamicSupport.bootstrap("getPasspointConfigurations", $$robo$$android_net_wifi_WifiManager$getPasspointConfigurations(), 0, this);
    }

    public void queryPasspointIcon(long l, String string2) {
        InvokeDynamicSupport.bootstrap("queryPasspointIcon", $$robo$$android_net_wifi_WifiManager$queryPasspointIcon(long java.lang.String ), 0, this, l, string2);
    }

    public int matchProviderWithCurrentNetwork(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("matchProviderWithCurrentNetwork", $$robo$$android_net_wifi_WifiManager$matchProviderWithCurrentNetwork(java.lang.String ), 0, this, string2);
    }

    public void deauthenticateNetwork(long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("deauthenticateNetwork", $$robo$$android_net_wifi_WifiManager$deauthenticateNetwork(long boolean ), 0, this, l, bl);
    }

    public boolean removeNetwork(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeNetwork", $$robo$$android_net_wifi_WifiManager$removeNetwork(int ), 0, this, n);
    }

    public boolean enableNetwork(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("enableNetwork", $$robo$$android_net_wifi_WifiManager$enableNetwork(int boolean ), 0, this, n, bl);
    }

    public boolean disableNetwork(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("disableNetwork", $$robo$$android_net_wifi_WifiManager$disableNetwork(int ), 0, this, n);
    }

    public boolean disconnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_net_wifi_WifiManager$disconnect(), 0, this);
    }

    public boolean reconnect() {
        return (boolean)InvokeDynamicSupport.bootstrap("reconnect", $$robo$$android_net_wifi_WifiManager$reconnect(), 0, this);
    }

    public boolean reassociate() {
        return (boolean)InvokeDynamicSupport.bootstrap("reassociate", $$robo$$android_net_wifi_WifiManager$reassociate(), 0, this);
    }

    @Deprecated
    public boolean pingSupplicant() {
        return (boolean)InvokeDynamicSupport.bootstrap("pingSupplicant", $$robo$$android_net_wifi_WifiManager$pingSupplicant(), 0, this);
    }

    private int getSupportedFeatures() {
        return (int)InvokeDynamicSupport.bootstrap("getSupportedFeatures", $$robo$$android_net_wifi_WifiManager$getSupportedFeatures(), 0, this);
    }

    private boolean isFeatureSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isFeatureSupported", $$robo$$android_net_wifi_WifiManager$isFeatureSupported(int ), 0, this, n);
    }

    public boolean is5GHzBandSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("is5GHzBandSupported", $$robo$$android_net_wifi_WifiManager$is5GHzBandSupported(), 0, this);
    }

    public boolean isPasspointSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPasspointSupported", $$robo$$android_net_wifi_WifiManager$isPasspointSupported(), 0, this);
    }

    public boolean isP2pSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isP2pSupported", $$robo$$android_net_wifi_WifiManager$isP2pSupported(), 0, this);
    }

    @SystemApi
    public boolean isPortableHotspotSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPortableHotspotSupported", $$robo$$android_net_wifi_WifiManager$isPortableHotspotSupported(), 0, this);
    }

    @SystemApi
    public boolean isWifiScannerSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifiScannerSupported", $$robo$$android_net_wifi_WifiManager$isWifiScannerSupported(), 0, this);
    }

    public boolean isWifiAwareSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifiAwareSupported", $$robo$$android_net_wifi_WifiManager$isWifiAwareSupported(), 0, this);
    }

    @SystemApi
    public boolean isDeviceToDeviceRttSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceToDeviceRttSupported", $$robo$$android_net_wifi_WifiManager$isDeviceToDeviceRttSupported(), 0, this);
    }

    @SystemApi
    public boolean isDeviceToApRttSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceToApRttSupported", $$robo$$android_net_wifi_WifiManager$isDeviceToApRttSupported(), 0, this);
    }

    public boolean isPreferredNetworkOffloadSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPreferredNetworkOffloadSupported", $$robo$$android_net_wifi_WifiManager$isPreferredNetworkOffloadSupported(), 0, this);
    }

    public boolean isAdditionalStaSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAdditionalStaSupported", $$robo$$android_net_wifi_WifiManager$isAdditionalStaSupported(), 0, this);
    }

    public boolean isTdlsSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTdlsSupported", $$robo$$android_net_wifi_WifiManager$isTdlsSupported(), 0, this);
    }

    public boolean isOffChannelTdlsSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffChannelTdlsSupported", $$robo$$android_net_wifi_WifiManager$isOffChannelTdlsSupported(), 0, this);
    }

    public boolean isEnhancedPowerReportingSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnhancedPowerReportingSupported", $$robo$$android_net_wifi_WifiManager$isEnhancedPowerReportingSupported(), 0, this);
    }

    public WifiActivityEnergyInfo getControllerActivityEnergyInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getControllerActivityEnergyInfo", $$robo$$android_net_wifi_WifiManager$getControllerActivityEnergyInfo(int ), 0, this, n);
    }

    @Deprecated
    public boolean startScan() {
        return (boolean)InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_net_wifi_WifiManager$startScan(), 0, this);
    }

    @SystemApi
    public boolean startScan(WorkSource workSource) {
        return (boolean)InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_net_wifi_WifiManager$startScan(android.os.WorkSource ), 0, this, workSource);
    }

    public String getCurrentNetworkWpsNfcConfigurationToken() {
        return InvokeDynamicSupport.bootstrap("getCurrentNetworkWpsNfcConfigurationToken", $$robo$$android_net_wifi_WifiManager$getCurrentNetworkWpsNfcConfigurationToken(), 0, this);
    }

    public WifiInfo getConnectionInfo() {
        return InvokeDynamicSupport.bootstrap("getConnectionInfo", $$robo$$android_net_wifi_WifiManager$getConnectionInfo(), 0, this);
    }

    public List<ScanResult> getScanResults() {
        return InvokeDynamicSupport.bootstrap("getScanResults", $$robo$$android_net_wifi_WifiManager$getScanResults(), 0, this);
    }

    public boolean isScanAlwaysAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScanAlwaysAvailable", $$robo$$android_net_wifi_WifiManager$isScanAlwaysAvailable(), 0, this);
    }

    @Deprecated
    public boolean saveConfiguration() {
        return (boolean)InvokeDynamicSupport.bootstrap("saveConfiguration", $$robo$$android_net_wifi_WifiManager$saveConfiguration(), 0, this);
    }

    public void setCountryCode(String string2) {
        InvokeDynamicSupport.bootstrap("setCountryCode", $$robo$$android_net_wifi_WifiManager$setCountryCode(java.lang.String ), 0, this, string2);
    }

    public String getCountryCode() {
        return InvokeDynamicSupport.bootstrap("getCountryCode", $$robo$$android_net_wifi_WifiManager$getCountryCode(), 0, this);
    }

    public boolean isDualBandSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDualBandSupported", $$robo$$android_net_wifi_WifiManager$isDualBandSupported(), 0, this);
    }

    public boolean isDualModeSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDualModeSupported", $$robo$$android_net_wifi_WifiManager$isDualModeSupported(), 0, this);
    }

    public DhcpInfo getDhcpInfo() {
        return InvokeDynamicSupport.bootstrap("getDhcpInfo", $$robo$$android_net_wifi_WifiManager$getDhcpInfo(), 0, this);
    }

    public boolean setWifiEnabled(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setWifiEnabled", $$robo$$android_net_wifi_WifiManager$setWifiEnabled(boolean ), 0, this, bl);
    }

    public int getWifiState() {
        return (int)InvokeDynamicSupport.bootstrap("getWifiState", $$robo$$android_net_wifi_WifiManager$getWifiState(), 0, this);
    }

    public boolean isWifiEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifiEnabled", $$robo$$android_net_wifi_WifiManager$isWifiEnabled(), 0, this);
    }

    public void getTxPacketCount(TxPacketCountListener txPacketCountListener) {
        InvokeDynamicSupport.bootstrap("getTxPacketCount", $$robo$$android_net_wifi_WifiManager$getTxPacketCount(android.net.wifi.WifiManager$TxPacketCountListener ), 0, this, txPacketCountListener);
    }

    public static int calculateSignalLevel(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculateSignalLevel", $$robo$$android_net_wifi_WifiManager$calculateSignalLevel(int int ), 0, (int)n, (int)n2);
    }

    public static int compareSignalLevel(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("compareSignalLevel", $$robo$$android_net_wifi_WifiManager$compareSignalLevel(int int ), 0, (int)n, (int)n2);
    }

    public void updateInterfaceIpState(String string2, int n) {
        InvokeDynamicSupport.bootstrap("updateInterfaceIpState", $$robo$$android_net_wifi_WifiManager$updateInterfaceIpState(java.lang.String int ), 0, this, string2, n);
    }

    public boolean startSoftAp(WifiConfiguration wifiConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("startSoftAp", $$robo$$android_net_wifi_WifiManager$startSoftAp(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
    }

    public boolean stopSoftAp() {
        return (boolean)InvokeDynamicSupport.bootstrap("stopSoftAp", $$robo$$android_net_wifi_WifiManager$stopSoftAp(), 0, this);
    }

    public void startLocalOnlyHotspot(LocalOnlyHotspotCallback localOnlyHotspotCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("startLocalOnlyHotspot", $$robo$$android_net_wifi_WifiManager$startLocalOnlyHotspot(android.net.wifi.WifiManager$LocalOnlyHotspotCallback android.os.Handler ), 0, this, localOnlyHotspotCallback, handler);
    }

    public void cancelLocalOnlyHotspotRequest() {
        InvokeDynamicSupport.bootstrap("cancelLocalOnlyHotspotRequest", $$robo$$android_net_wifi_WifiManager$cancelLocalOnlyHotspotRequest(), 0, this);
    }

    private void stopLocalOnlyHotspot() {
        InvokeDynamicSupport.bootstrap("stopLocalOnlyHotspot", $$robo$$android_net_wifi_WifiManager$stopLocalOnlyHotspot(), 0, this);
    }

    public void watchLocalOnlyHotspot(LocalOnlyHotspotObserver localOnlyHotspotObserver, Handler handler) {
        InvokeDynamicSupport.bootstrap("watchLocalOnlyHotspot", $$robo$$android_net_wifi_WifiManager$watchLocalOnlyHotspot(android.net.wifi.WifiManager$LocalOnlyHotspotObserver android.os.Handler ), 0, this, localOnlyHotspotObserver, handler);
    }

    public void unregisterLocalOnlyHotspotObserver() {
        InvokeDynamicSupport.bootstrap("unregisterLocalOnlyHotspotObserver", $$robo$$android_net_wifi_WifiManager$unregisterLocalOnlyHotspotObserver(), 0, this);
    }

    @SystemApi
    public int getWifiApState() {
        return (int)InvokeDynamicSupport.bootstrap("getWifiApState", $$robo$$android_net_wifi_WifiManager$getWifiApState(), 0, this);
    }

    @SystemApi
    public boolean isWifiApEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifiApEnabled", $$robo$$android_net_wifi_WifiManager$isWifiApEnabled(), 0, this);
    }

    @SystemApi
    public WifiConfiguration getWifiApConfiguration() {
        return InvokeDynamicSupport.bootstrap("getWifiApConfiguration", $$robo$$android_net_wifi_WifiManager$getWifiApConfiguration(), 0, this);
    }

    @SystemApi
    public boolean setWifiApConfiguration(WifiConfiguration wifiConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("setWifiApConfiguration", $$robo$$android_net_wifi_WifiManager$setWifiApConfiguration(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
    }

    public void notifyUserOfApBandConversion() {
        InvokeDynamicSupport.bootstrap("notifyUserOfApBandConversion", $$robo$$android_net_wifi_WifiManager$notifyUserOfApBandConversion(), 0, this);
    }

    public void setTdlsEnabled(InetAddress inetAddress, boolean bl) {
        InvokeDynamicSupport.bootstrap("setTdlsEnabled", $$robo$$android_net_wifi_WifiManager$setTdlsEnabled(java.net.InetAddress boolean ), 0, this, inetAddress, bl);
    }

    public void setTdlsEnabledWithMacAddress(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setTdlsEnabledWithMacAddress", $$robo$$android_net_wifi_WifiManager$setTdlsEnabledWithMacAddress(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void registerSoftApCallback(SoftApCallback softApCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerSoftApCallback", $$robo$$android_net_wifi_WifiManager$registerSoftApCallback(android.net.wifi.WifiManager$SoftApCallback android.os.Handler ), 0, this, softApCallback, handler);
    }

    public void unregisterSoftApCallback(SoftApCallback softApCallback) {
        InvokeDynamicSupport.bootstrap("unregisterSoftApCallback", $$robo$$android_net_wifi_WifiManager$unregisterSoftApCallback(android.net.wifi.WifiManager$SoftApCallback ), 0, this, softApCallback);
    }

    private int putListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrap("putListener", $$robo$$android_net_wifi_WifiManager$putListener(java.lang.Object ), 0, this, object);
    }

    private Object removeListener(int n) {
        return InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_net_wifi_WifiManager$removeListener(int ), 0, this, n);
    }

    private synchronized AsyncChannel getChannel() {
        return InvokeDynamicSupport.bootstrap("getChannel", $$robo$$android_net_wifi_WifiManager$getChannel(), 0, this);
    }

    @SystemApi
    public void connect(WifiConfiguration wifiConfiguration, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_net_wifi_WifiManager$connect(android.net.wifi.WifiConfiguration android.net.wifi.WifiManager$ActionListener ), 0, this, wifiConfiguration, actionListener);
    }

    public void connect(int n, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_net_wifi_WifiManager$connect(int android.net.wifi.WifiManager$ActionListener ), 0, this, n, actionListener);
    }

    public void save(WifiConfiguration wifiConfiguration, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("save", $$robo$$android_net_wifi_WifiManager$save(android.net.wifi.WifiConfiguration android.net.wifi.WifiManager$ActionListener ), 0, this, wifiConfiguration, actionListener);
    }

    public void forget(int n, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("forget", $$robo$$android_net_wifi_WifiManager$forget(int android.net.wifi.WifiManager$ActionListener ), 0, this, n, actionListener);
    }

    public void disable(int n, ActionListener actionListener) {
        InvokeDynamicSupport.bootstrap("disable", $$robo$$android_net_wifi_WifiManager$disable(int android.net.wifi.WifiManager$ActionListener ), 0, this, n, actionListener);
    }

    public void disableEphemeralNetwork(String string2) {
        InvokeDynamicSupport.bootstrap("disableEphemeralNetwork", $$robo$$android_net_wifi_WifiManager$disableEphemeralNetwork(java.lang.String ), 0, this, string2);
    }

    public void startWps(WpsInfo wpsInfo, WpsCallback wpsCallback) {
        InvokeDynamicSupport.bootstrap("startWps", $$robo$$android_net_wifi_WifiManager$startWps(android.net.wifi.WpsInfo android.net.wifi.WifiManager$WpsCallback ), 0, this, wpsInfo, wpsCallback);
    }

    public void cancelWps(WpsCallback wpsCallback) {
        InvokeDynamicSupport.bootstrap("cancelWps", $$robo$$android_net_wifi_WifiManager$cancelWps(android.net.wifi.WifiManager$WpsCallback ), 0, this, wpsCallback);
    }

    public Messenger getWifiServiceMessenger() {
        return InvokeDynamicSupport.bootstrap("getWifiServiceMessenger", $$robo$$android_net_wifi_WifiManager$getWifiServiceMessenger(), 0, this);
    }

    public WifiLock createWifiLock(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("createWifiLock", $$robo$$android_net_wifi_WifiManager$createWifiLock(int java.lang.String ), 0, this, n, string2);
    }

    public WifiLock createWifiLock(String string2) {
        return InvokeDynamicSupport.bootstrap("createWifiLock", $$robo$$android_net_wifi_WifiManager$createWifiLock(java.lang.String ), 0, this, string2);
    }

    public MulticastLock createMulticastLock(String string2) {
        return InvokeDynamicSupport.bootstrap("createMulticastLock", $$robo$$android_net_wifi_WifiManager$createMulticastLock(java.lang.String ), 0, this, string2);
    }

    public boolean isMulticastEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMulticastEnabled", $$robo$$android_net_wifi_WifiManager$isMulticastEnabled(), 0, this);
    }

    public boolean initializeMulticastFiltering() {
        return (boolean)InvokeDynamicSupport.bootstrap("initializeMulticastFiltering", $$robo$$android_net_wifi_WifiManager$initializeMulticastFiltering(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_wifi_WifiManager$finalize(), 0, this);
    }

    public void enableVerboseLogging(int n) {
        InvokeDynamicSupport.bootstrap("enableVerboseLogging", $$robo$$android_net_wifi_WifiManager$enableVerboseLogging(int ), 0, this, n);
    }

    public int getVerboseLoggingLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getVerboseLoggingLevel", $$robo$$android_net_wifi_WifiManager$getVerboseLoggingLevel(), 0, this);
    }

    public void factoryReset() {
        InvokeDynamicSupport.bootstrap("factoryReset", $$robo$$android_net_wifi_WifiManager$factoryReset(), 0, this);
    }

    public Network getCurrentNetwork() {
        return InvokeDynamicSupport.bootstrap("getCurrentNetwork", $$robo$$android_net_wifi_WifiManager$getCurrentNetwork(), 0, this);
    }

    public boolean setEnableAutoJoinWhenAssociated(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setEnableAutoJoinWhenAssociated", $$robo$$android_net_wifi_WifiManager$setEnableAutoJoinWhenAssociated(boolean ), 0, this, bl);
    }

    public boolean getEnableAutoJoinWhenAssociated() {
        return (boolean)InvokeDynamicSupport.bootstrap("getEnableAutoJoinWhenAssociated", $$robo$$android_net_wifi_WifiManager$getEnableAutoJoinWhenAssociated(), 0, this);
    }

    public void enableWifiConnectivityManager(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableWifiConnectivityManager", $$robo$$android_net_wifi_WifiManager$enableWifiConnectivityManager(boolean ), 0, this, bl);
    }

    public byte[] retrieveBackupData() {
        return InvokeDynamicSupport.bootstrap("retrieveBackupData", $$robo$$android_net_wifi_WifiManager$retrieveBackupData(), 0, this);
    }

    public void restoreBackupData(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("restoreBackupData", $$robo$$android_net_wifi_WifiManager$restoreBackupData(byte[] ), 0, this, byArray);
    }

    @Deprecated
    public void restoreSupplicantBackupData(byte[] byArray, byte[] byArray2) {
        InvokeDynamicSupport.bootstrap("restoreSupplicantBackupData", $$robo$$android_net_wifi_WifiManager$restoreSupplicantBackupData(byte[] byte[] ), 0, this, byArray, byArray2);
    }

    public void startSubscriptionProvisioning(OsuProvider osuProvider, ProvisioningCallback provisioningCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("startSubscriptionProvisioning", $$robo$$android_net_wifi_WifiManager$startSubscriptionProvisioning(android.net.wifi.hotspot2.OsuProvider android.net.wifi.hotspot2.ProvisioningCallback android.os.Handler ), 0, this, osuProvider, provisioningCallback, handler);
    }

    static {
        RobolectricInternals.classInitializing(WifiManager.class);
    }

    public /* synthetic */ WifiManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ProvisioningCallbackProxy
    extends IProvisioningCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        private ProvisioningCallback mCallback;

        private void $$robo$$android_net_wifi_WifiManager_ProvisioningCallbackProxy$__constructor__(Looper looper, ProvisioningCallback callback) {
            this.mHandler = new Handler(looper);
            this.mCallback = callback;
        }

        private final void $$robo$$android_net_wifi_WifiManager_ProvisioningCallbackProxy$onProvisioningStatus(int status) {
            this.mHandler.post(() -> this.mCallback.onProvisioningStatus(status));
        }

        private final void $$robo$$android_net_wifi_WifiManager_ProvisioningCallbackProxy$onProvisioningFailure(int status) {
            this.mHandler.post(() -> this.mCallback.onProvisioningFailure(status));
        }

        private void __constructor__(Looper looper, ProvisioningCallback provisioningCallback) {
            this.$$robo$$android_net_wifi_WifiManager_ProvisioningCallbackProxy$__constructor__(looper, provisioningCallback);
        }

        ProvisioningCallbackProxy(Looper looper, ProvisioningCallback provisioningCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_ProvisioningCallbackProxy$__constructor__(android.os.Looper android.net.wifi.hotspot2.ProvisioningCallback ), 0, this, looper, provisioningCallback);
        }

        @Override
        public void onProvisioningStatus(int n) {
            InvokeDynamicSupport.bootstrap("onProvisioningStatus", $$robo$$android_net_wifi_WifiManager_ProvisioningCallbackProxy$onProvisioningStatus(int ), 0, this, n);
        }

        @Override
        public void onProvisioningFailure(int n) {
            InvokeDynamicSupport.bootstrap("onProvisioningFailure", $$robo$$android_net_wifi_WifiManager_ProvisioningCallbackProxy$onProvisioningFailure(int ), 0, this, n);
        }

        public /* synthetic */ ProvisioningCallbackProxy() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProvisioningCallbackProxy)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class MulticastLock
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mTag;
        private IBinder mBinder;
        private int mRefCount;
        private boolean mRefCounted;
        private boolean mHeld;
        /* synthetic */ WifiManager this$0;

        private void $$robo$$android_net_wifi_WifiManager_MulticastLock$__constructor__(WifiManager this$0, String tag) {
            this.mTag = tag;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_wifi_WifiManager_MulticastLock$acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount == 1 : !this.mHeld) {
                    try {
                        this.this$0.mService.acquireMulticastLock(this.mBinder, this.mTag);
                        WifiManager wifiManager = this.this$0;
                        synchronized (wifiManager) {
                            if (this.this$0.mActiveLockCount >= 50) {
                                this.this$0.mService.releaseMulticastLock();
                                throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                            }
                            this.this$0.mActiveLockCount++;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_wifi_WifiManager_MulticastLock$release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        this.this$0.mService.releaseMulticastLock();
                        WifiManager wifiManager = this.this$0;
                        synchronized (wifiManager) {
                            this.this$0.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("MulticastLock under-locked " + this.mTag);
                }
            }
        }

        private final void $$robo$$android_net_wifi_WifiManager_MulticastLock$setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_net_wifi_WifiManager_MulticastLock$isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_net_wifi_WifiManager_MulticastLock$toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "MulticastLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        private final void $$robo$$android_net_wifi_WifiManager_MulticastLock$finalize() throws Throwable {
            super.finalize();
            this.setReferenceCounted(false);
            this.release();
        }

        private /* synthetic */ void $$robo$$android_net_wifi_WifiManager_MulticastLock$__constructor__(WifiManager x0, String x1, 1 x2) {
        }

        private void __constructor__(WifiManager wifiManager, String string2) {
            this.$$robo$$android_net_wifi_WifiManager_MulticastLock$__constructor__(wifiManager, string2);
        }

        private MulticastLock(WifiManager wifiManager, String string2) {
            this.this$0 = wifiManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_MulticastLock$__constructor__(android.net.wifi.WifiManager java.lang.String ), 0, this, wifiManager, string2);
        }

        public void acquire() {
            InvokeDynamicSupport.bootstrap("acquire", $$robo$$android_net_wifi_WifiManager_MulticastLock$acquire(), 0, this);
        }

        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_net_wifi_WifiManager_MulticastLock$release(), 0, this);
        }

        public void setReferenceCounted(boolean bl) {
            InvokeDynamicSupport.bootstrap("setReferenceCounted", $$robo$$android_net_wifi_WifiManager_MulticastLock$setReferenceCounted(boolean ), 0, this, bl);
        }

        public boolean isHeld() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHeld", $$robo$$android_net_wifi_WifiManager_MulticastLock$isHeld(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiManager_MulticastLock$toString(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_wifi_WifiManager_MulticastLock$finalize(), 0, this);
        }

        private /* synthetic */ void __constructor__(WifiManager wifiManager, String string2, 1 var3_3) {
            this.$$robo$$android_net_wifi_WifiManager_MulticastLock$__constructor__(wifiManager, string2, var3_3);
        }

        public /* synthetic */ MulticastLock() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MulticastLock)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class WifiLock
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mTag;
        private IBinder mBinder;
        private int mRefCount;
        int mLockType;
        private boolean mRefCounted;
        private boolean mHeld;
        private WorkSource mWorkSource;
        /* synthetic */ WifiManager this$0;

        private void $$robo$$android_net_wifi_WifiManager_WifiLock$__constructor__(WifiManager this$0, int lockType, String tag) {
            this.mTag = tag;
            this.mLockType = lockType;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_wifi_WifiManager_WifiLock$acquire() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? ++this.mRefCount == 1 : !this.mHeld) {
                    try {
                        this.this$0.mService.acquireWifiLock(this.mBinder, this.mLockType, this.mTag, this.mWorkSource);
                        WifiManager wifiManager = this.this$0;
                        synchronized (wifiManager) {
                            if (this.this$0.mActiveLockCount >= 50) {
                                this.this$0.mService.releaseWifiLock(this.mBinder);
                                throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                            }
                            this.this$0.mActiveLockCount++;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_wifi_WifiManager_WifiLock$release() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mRefCounted ? --this.mRefCount == 0 : this.mHeld) {
                    try {
                        this.this$0.mService.releaseWifiLock(this.mBinder);
                        WifiManager wifiManager = this.this$0;
                        synchronized (wifiManager) {
                            this.this$0.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                    this.mHeld = false;
                }
                if (this.mRefCount < 0) {
                    throw new RuntimeException("WifiLock under-locked " + this.mTag);
                }
            }
        }

        private final void $$robo$$android_net_wifi_WifiManager_WifiLock$setReferenceCounted(boolean refCounted) {
            this.mRefCounted = refCounted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_net_wifi_WifiManager_WifiLock$isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_wifi_WifiManager_WifiLock$setWorkSource(WorkSource ws) {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (ws != null && ws.isEmpty()) {
                    ws = null;
                }
                boolean changed = true;
                if (ws == null) {
                    this.mWorkSource = null;
                } else {
                    ws.clearNames();
                    if (this.mWorkSource == null) {
                        changed = this.mWorkSource != null;
                        this.mWorkSource = new WorkSource(ws);
                    } else {
                        boolean bl = changed = !this.mWorkSource.equals(ws);
                        if (changed) {
                            this.mWorkSource.set(ws);
                        }
                    }
                }
                if (changed && this.mHeld) {
                    try {
                        this.this$0.mService.updateWifiLockWorkSource(this.mBinder, this.mWorkSource);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_net_wifi_WifiManager_WifiLock$toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String s1 = Integer.toHexString(System.identityHashCode(this));
                String s2 = this.mHeld ? "held; " : "";
                String s3 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "WifiLock{ " + s1 + "; " + s2 + s3 + " }";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_wifi_WifiManager_WifiLock$finalize() throws Throwable {
            super.finalize();
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                if (this.mHeld) {
                    try {
                        this.this$0.mService.releaseWifiLock(this.mBinder);
                        WifiManager wifiManager = this.this$0;
                        synchronized (wifiManager) {
                            this.this$0.mActiveLockCount--;
                        }
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        private /* synthetic */ void $$robo$$android_net_wifi_WifiManager_WifiLock$__constructor__(WifiManager x0, int x1, String x2, 1 x3) {
        }

        private void __constructor__(WifiManager wifiManager, int n, String string2) {
            this.$$robo$$android_net_wifi_WifiManager_WifiLock$__constructor__(wifiManager, n, string2);
        }

        private WifiLock(WifiManager wifiManager, int n, String string2) {
            this.this$0 = wifiManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_WifiLock$__constructor__(android.net.wifi.WifiManager int java.lang.String ), 0, this, wifiManager, n, string2);
        }

        public void acquire() {
            InvokeDynamicSupport.bootstrap("acquire", $$robo$$android_net_wifi_WifiManager_WifiLock$acquire(), 0, this);
        }

        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_net_wifi_WifiManager_WifiLock$release(), 0, this);
        }

        public void setReferenceCounted(boolean bl) {
            InvokeDynamicSupport.bootstrap("setReferenceCounted", $$robo$$android_net_wifi_WifiManager_WifiLock$setReferenceCounted(boolean ), 0, this, bl);
        }

        public boolean isHeld() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHeld", $$robo$$android_net_wifi_WifiManager_WifiLock$isHeld(), 0, this);
        }

        public void setWorkSource(WorkSource workSource) {
            InvokeDynamicSupport.bootstrap("setWorkSource", $$robo$$android_net_wifi_WifiManager_WifiLock$setWorkSource(android.os.WorkSource ), 0, this, workSource);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiManager_WifiLock$toString(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_wifi_WifiManager_WifiLock$finalize(), 0, this);
        }

        private /* synthetic */ void __constructor__(WifiManager wifiManager, int n, String string2, 1 var4_4) {
            this.$$robo$$android_net_wifi_WifiManager_WifiLock$__constructor__(wifiManager, n, string2, var4_4);
        }

        public /* synthetic */ WifiLock() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiLock)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ServiceHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ WifiManager this$0;

        private void $$robo$$android_net_wifi_WifiManager_ServiceHandler$__constructor__(WifiManager wifiManager, Looper looper) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_wifi_WifiManager_ServiceHandler$handleMessage(Message message) {
            Object object = sServiceHandlerDispatchLock;
            synchronized (object) {
                this.dispatchMessageToListeners(message);
            }
        }

        private final void $$robo$$android_net_wifi_WifiManager_ServiceHandler$dispatchMessageToListeners(Message message) {
            Object listener = this.this$0.removeListener(message.arg2);
            switch (message.what) {
                case 69632: {
                    if (message.arg1 == 0) {
                        this.this$0.mAsyncChannel.sendMessage(69633);
                    } else {
                        Log.e("WifiManager", "Failed to set up channel connection");
                        this.this$0.mAsyncChannel = null;
                    }
                    this.this$0.mConnected.countDown();
                    break;
                }
                case 69634: {
                    break;
                }
                case 69636: {
                    Log.e("WifiManager", "Channel connection lost");
                    this.this$0.mAsyncChannel = null;
                    this.getLooper().quit();
                    break;
                }
                case 151554: 
                case 151557: 
                case 151560: 
                case 151570: {
                    if (listener == null) break;
                    ((ActionListener)listener).onFailure(message.arg1);
                    break;
                }
                case 151555: 
                case 151558: 
                case 151561: 
                case 151571: {
                    if (listener == null) break;
                    ((ActionListener)listener).onSuccess();
                    break;
                }
                case 151573: {
                    if (listener == null) break;
                    RssiPacketCountInfo info = (RssiPacketCountInfo)message.obj;
                    if (info != null) {
                        ((TxPacketCountListener)listener).onSuccess(info.txgood + info.txbad);
                        break;
                    }
                    ((TxPacketCountListener)listener).onFailure(0);
                    break;
                }
                case 151574: {
                    if (listener == null) break;
                    ((TxPacketCountListener)listener).onFailure(message.arg1);
                    break;
                }
            }
        }

        private void __constructor__(WifiManager wifiManager, Looper looper) {
            this.$$robo$$android_net_wifi_WifiManager_ServiceHandler$__constructor__(wifiManager, looper);
        }

        ServiceHandler(WifiManager wifiManager, Looper looper) {
            this.this$0 = wifiManager;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_ServiceHandler$__constructor__(android.net.wifi.WifiManager android.os.Looper ), 0, this, wifiManager, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_WifiManager_ServiceHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private void dispatchMessageToListeners(Message message) {
            InvokeDynamicSupport.bootstrap("dispatchMessageToListeners", $$robo$$android_net_wifi_WifiManager_ServiceHandler$dispatchMessageToListeners(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ ServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LocalOnlyHotspotObserverProxy
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        private WeakReference<WifiManager> mWifiManager;
        private Looper mLooper;
        private Messenger mMessenger;

        private void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy$__constructor__(WifiManager manager, Looper looper, LocalOnlyHotspotObserver observer) {
            this.mWifiManager = new WeakReference<WifiManager>(manager);
            this.mLooper = looper;
            this.mHandler = new ShadowedObject(this, looper, observer){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LocalOnlyHotspotObserver val$observer;
                /* synthetic */ LocalOnlyHotspotObserverProxy this$0;

                private void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy_1$__constructor__(LocalOnlyHotspotObserverProxy this$0, Looper x0, LocalOnlyHotspotObserver localOnlyHotspotObserver) {
                }

                private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy_1$handleMessage(Message msg) {
                    Log.d("WifiManager", "LocalOnlyHotspotObserverProxy: handle message what: " + msg.what + " msg: " + msg);
                    WifiManager manager = (WifiManager)this.this$0.mWifiManager.get();
                    if (manager == null) {
                        Log.w("WifiManager", "LocalOnlyHotspotObserverProxy: handle message post GC");
                        return;
                    }
                    switch (msg.what) {
                        case 3: {
                            this.val$observer.onRegistered(new LocalOnlyHotspotSubscription(manager));
                            break;
                        }
                        case 0: {
                            WifiConfiguration config = (WifiConfiguration)msg.obj;
                            if (config == null) {
                                Log.e("WifiManager", "LocalOnlyHotspotObserverProxy: config cannot be null.");
                                return;
                            }
                            this.val$observer.onStarted(config);
                            break;
                        }
                        case 1: {
                            this.val$observer.onStopped();
                            break;
                        }
                        default: {
                            Log.e("WifiManager", "LocalOnlyHotspotObserverProxy unhandled message.  type: " + msg.what);
                        }
                    }
                }

                private void __constructor__(LocalOnlyHotspotObserverProxy localOnlyHotspotObserverProxy, Looper looper, LocalOnlyHotspotObserver localOnlyHotspotObserver) {
                    this.$$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy_1$__constructor__(localOnlyHotspotObserverProxy, looper, localOnlyHotspotObserver);
                }
                {
                    this.this$0 = localOnlyHotspotObserverProxy;
                    this.val$observer = localOnlyHotspotObserver;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy_1$__constructor__(android.net.wifi.WifiManager$LocalOnlyHotspotObserverProxy android.os.Looper android.net.wifi.WifiManager$LocalOnlyHotspotObserver ), 0, this, localOnlyHotspotObserverProxy, looper, localOnlyHotspotObserver);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mMessenger = new Messenger(this.mHandler);
        }

        private final Messenger $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy$getMessenger() {
            return this.mMessenger;
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy$registered() throws RemoteException {
            Message msg = Message.obtain();
            msg.what = 3;
            this.mMessenger.send(msg);
        }

        private void __constructor__(WifiManager wifiManager, Looper looper, LocalOnlyHotspotObserver localOnlyHotspotObserver) {
            this.$$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy$__constructor__(wifiManager, looper, localOnlyHotspotObserver);
        }

        LocalOnlyHotspotObserverProxy(WifiManager wifiManager, Looper looper, LocalOnlyHotspotObserver localOnlyHotspotObserver) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy$__constructor__(android.net.wifi.WifiManager android.os.Looper android.net.wifi.WifiManager$LocalOnlyHotspotObserver ), 0, this, wifiManager, looper, localOnlyHotspotObserver);
        }

        public Messenger getMessenger() {
            return InvokeDynamicSupport.bootstrap("getMessenger", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy$getMessenger(), 0, this);
        }

        public void registered() throws RemoteException {
            InvokeDynamicSupport.bootstrap("registered", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserverProxy$registered(), 0, this);
        }

        public /* synthetic */ LocalOnlyHotspotObserverProxy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalOnlyHotspotObserverProxy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LocalOnlyHotspotObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$__constructor__() {
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$onRegistered(LocalOnlyHotspotSubscription subscription) {
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$onStarted(WifiConfiguration config) {
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$onStopped() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$__constructor__();
        }

        public LocalOnlyHotspotObserver() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$__constructor__(), 0, this);
        }

        public void onRegistered(LocalOnlyHotspotSubscription localOnlyHotspotSubscription) {
            InvokeDynamicSupport.bootstrap("onRegistered", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$onRegistered(android.net.wifi.WifiManager$LocalOnlyHotspotSubscription ), 0, this, localOnlyHotspotSubscription);
        }

        public void onStarted(WifiConfiguration wifiConfiguration) {
            InvokeDynamicSupport.bootstrap("onStarted", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$onStarted(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
        }

        public void onStopped() {
            InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotObserver$onStopped(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalOnlyHotspotObserver)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class LocalOnlyHotspotSubscription
    implements AutoCloseable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CloseGuard mCloseGuard;
        /* synthetic */ WifiManager this$0;

        @VisibleForTesting
        private void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotSubscription$__constructor__(WifiManager this$0) {
            this.mCloseGuard = CloseGuard.get();
            this.mCloseGuard.open("close");
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotSubscription$close() {
            try {
                this.this$0.unregisterLocalOnlyHotspotObserver();
                this.mCloseGuard.close();
            }
            catch (Exception e) {
                Log.e("WifiManager", "Failed to unregister LocalOnlyHotspotObserver.");
            }
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotSubscription$finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void __constructor__(WifiManager wifiManager) {
            this.$$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotSubscription$__constructor__(wifiManager);
        }

        public LocalOnlyHotspotSubscription(WifiManager wifiManager) {
            this.this$0 = wifiManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotSubscription$__constructor__(android.net.wifi.WifiManager ), 0, this, wifiManager);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotSubscription$close(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotSubscription$finalize(), 0, this);
        }

        public /* synthetic */ LocalOnlyHotspotSubscription() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalOnlyHotspotSubscription)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class LocalOnlyHotspotCallbackProxy
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        private WeakReference<WifiManager> mWifiManager;
        private Looper mLooper;
        private Messenger mMessenger;

        private void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy$__constructor__(WifiManager manager, Looper looper, LocalOnlyHotspotCallback callback) {
            this.mWifiManager = new WeakReference<WifiManager>(manager);
            this.mLooper = looper;
            this.mHandler = new ShadowedObject(this, looper, callback){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ LocalOnlyHotspotCallback val$callback;
                /* synthetic */ LocalOnlyHotspotCallbackProxy this$0;

                private void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy_1$__constructor__(LocalOnlyHotspotCallbackProxy this$0, Looper x0, LocalOnlyHotspotCallback localOnlyHotspotCallback) {
                }

                private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy_1$handleMessage(Message msg) {
                    Log.d("WifiManager", "LocalOnlyHotspotCallbackProxy: handle message what: " + msg.what + " msg: " + msg);
                    WifiManager manager = (WifiManager)this.this$0.mWifiManager.get();
                    if (manager == null) {
                        Log.w("WifiManager", "LocalOnlyHotspotCallbackProxy: handle message post GC");
                        return;
                    }
                    switch (msg.what) {
                        case 0: {
                            WifiConfiguration config = (WifiConfiguration)msg.obj;
                            if (config == null) {
                                Log.e("WifiManager", "LocalOnlyHotspotCallbackProxy: config cannot be null.");
                                this.val$callback.onFailed(2);
                                return;
                            }
                            WifiManager wifiManager = manager;
                            Objects.requireNonNull(wifiManager);
                            this.val$callback.onStarted(new LocalOnlyHotspotReservation(wifiManager, config));
                            break;
                        }
                        case 1: {
                            Log.w("WifiManager", "LocalOnlyHotspotCallbackProxy: hotspot stopped");
                            this.val$callback.onStopped();
                            break;
                        }
                        case 2: {
                            int reasonCode = msg.arg1;
                            Log.w("WifiManager", "LocalOnlyHotspotCallbackProxy: failed to start.  reason: " + reasonCode);
                            this.val$callback.onFailed(reasonCode);
                            Log.w("WifiManager", "done with the callback...");
                            break;
                        }
                        default: {
                            Log.e("WifiManager", "LocalOnlyHotspotCallbackProxy unhandled message.  type: " + msg.what);
                        }
                    }
                }

                private void __constructor__(LocalOnlyHotspotCallbackProxy localOnlyHotspotCallbackProxy, Looper looper, LocalOnlyHotspotCallback localOnlyHotspotCallback) {
                    this.$$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy_1$__constructor__(localOnlyHotspotCallbackProxy, looper, localOnlyHotspotCallback);
                }
                {
                    this.this$0 = localOnlyHotspotCallbackProxy;
                    this.val$callback = localOnlyHotspotCallback;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy_1$__constructor__(android.net.wifi.WifiManager$LocalOnlyHotspotCallbackProxy android.os.Looper android.net.wifi.WifiManager$LocalOnlyHotspotCallback ), 0, this, localOnlyHotspotCallbackProxy, looper, localOnlyHotspotCallback);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mMessenger = new Messenger(this.mHandler);
        }

        private final Messenger $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy$getMessenger() {
            return this.mMessenger;
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy$notifyFailed(int reason) throws RemoteException {
            Message msg = Message.obtain();
            msg.what = 2;
            msg.arg1 = reason;
            this.mMessenger.send(msg);
        }

        private void __constructor__(WifiManager wifiManager, Looper looper, LocalOnlyHotspotCallback localOnlyHotspotCallback) {
            this.$$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy$__constructor__(wifiManager, looper, localOnlyHotspotCallback);
        }

        LocalOnlyHotspotCallbackProxy(WifiManager wifiManager, Looper looper, LocalOnlyHotspotCallback localOnlyHotspotCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy$__constructor__(android.net.wifi.WifiManager android.os.Looper android.net.wifi.WifiManager$LocalOnlyHotspotCallback ), 0, this, wifiManager, looper, localOnlyHotspotCallback);
        }

        public Messenger getMessenger() {
            return InvokeDynamicSupport.bootstrap("getMessenger", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy$getMessenger(), 0, this);
        }

        public void notifyFailed(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("notifyFailed", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallbackProxy$notifyFailed(int ), 0, this, n);
        }

        public /* synthetic */ LocalOnlyHotspotCallbackProxy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalOnlyHotspotCallbackProxy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LocalOnlyHotspotCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int REQUEST_REGISTERED = 0;
        public static int ERROR_NO_CHANNEL = 1;
        public static int ERROR_GENERIC = 2;
        public static int ERROR_INCOMPATIBLE_MODE = 3;
        public static int ERROR_TETHERING_DISALLOWED = 4;

        private void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$__constructor__() {
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$onStarted(LocalOnlyHotspotReservation reservation) {
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$onStopped() {
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$onFailed(int reason) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$__constructor__();
        }

        public LocalOnlyHotspotCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$__constructor__(), 0, this);
        }

        public void onStarted(LocalOnlyHotspotReservation localOnlyHotspotReservation) {
            InvokeDynamicSupport.bootstrap("onStarted", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$onStarted(android.net.wifi.WifiManager$LocalOnlyHotspotReservation ), 0, this, localOnlyHotspotReservation);
        }

        public void onStopped() {
            InvokeDynamicSupport.bootstrap("onStopped", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$onStopped(), 0, this);
        }

        public void onFailed(int n) {
            InvokeDynamicSupport.bootstrap("onFailed", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotCallback$onFailed(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalOnlyHotspotCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class LocalOnlyHotspotReservation
    implements AutoCloseable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CloseGuard mCloseGuard;
        private WifiConfiguration mConfig;
        /* synthetic */ WifiManager this$0;

        @VisibleForTesting
        private void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$__constructor__(WifiManager this$0, WifiConfiguration config) {
            this.mCloseGuard = CloseGuard.get();
            this.mConfig = config;
            this.mCloseGuard.open("close");
        }

        private final WifiConfiguration $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$getWifiConfiguration() {
            return this.mConfig;
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$close() {
            try {
                this.this$0.stopLocalOnlyHotspot();
                this.mCloseGuard.close();
            }
            catch (Exception e) {
                Log.e("WifiManager", "Failed to stop Local Only Hotspot.");
            }
        }

        private final void $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void __constructor__(WifiManager wifiManager, WifiConfiguration wifiConfiguration) {
            this.$$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$__constructor__(wifiManager, wifiConfiguration);
        }

        public LocalOnlyHotspotReservation(WifiManager wifiManager, WifiConfiguration wifiConfiguration) {
            this.this$0 = wifiManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$__constructor__(android.net.wifi.WifiManager android.net.wifi.WifiConfiguration ), 0, this, wifiManager, wifiConfiguration);
        }

        public WifiConfiguration getWifiConfiguration() {
            return InvokeDynamicSupport.bootstrap("getWifiConfiguration", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$getWifiConfiguration(), 0, this);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$close(), 0, this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_wifi_WifiManager_LocalOnlyHotspotReservation$finalize(), 0, this);
        }

        public /* synthetic */ LocalOnlyHotspotReservation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalOnlyHotspotReservation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SoftApCallbackProxy
    extends ISoftApCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        private SoftApCallback mCallback;

        private void $$robo$$android_net_wifi_WifiManager_SoftApCallbackProxy$__constructor__(Looper looper, SoftApCallback callback) {
            this.mHandler = new Handler(looper);
            this.mCallback = callback;
        }

        private final void $$robo$$android_net_wifi_WifiManager_SoftApCallbackProxy$onStateChanged(int state, int failureReason) throws RemoteException {
            Log.v("WifiManager", "SoftApCallbackProxy: onStateChanged: state=" + state + ", failureReason=" + failureReason);
            this.mHandler.post(() -> this.mCallback.onStateChanged(state, failureReason));
        }

        private final void $$robo$$android_net_wifi_WifiManager_SoftApCallbackProxy$onNumClientsChanged(int numClients) throws RemoteException {
            Log.v("WifiManager", "SoftApCallbackProxy: onNumClientsChanged: numClients=" + numClients);
            this.mHandler.post(() -> this.mCallback.onNumClientsChanged(numClients));
        }

        private void __constructor__(Looper looper, SoftApCallback softApCallback) {
            this.$$robo$$android_net_wifi_WifiManager_SoftApCallbackProxy$__constructor__(looper, softApCallback);
        }

        SoftApCallbackProxy(Looper looper, SoftApCallback softApCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_SoftApCallbackProxy$__constructor__(android.os.Looper android.net.wifi.WifiManager$SoftApCallback ), 0, this, looper, softApCallback);
        }

        @Override
        public void onStateChanged(int n, int n2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_net_wifi_WifiManager_SoftApCallbackProxy$onStateChanged(int int ), 0, this, n, n2);
        }

        @Override
        public void onNumClientsChanged(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onNumClientsChanged", $$robo$$android_net_wifi_WifiManager_SoftApCallbackProxy$onNumClientsChanged(int ), 0, this, n);
        }

        public /* synthetic */ SoftApCallbackProxy() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SoftApCallbackProxy)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface SoftApCallback
    extends InstrumentedInterface {
        public void onStateChanged(int var1, int var2);

        public void onNumClientsChanged(int var1);
    }

    public static interface TxPacketCountListener
    extends InstrumentedInterface {
        public void onSuccess(int var1);

        public void onFailure(int var1);
    }

    public static abstract class WpsCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_wifi_WifiManager_WpsCallback$__constructor__() {
        }

        public abstract void onStarted(String var1);

        public abstract void onSucceeded();

        public abstract void onFailed(int var1);

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiManager_WpsCallback$__constructor__();
        }

        public WpsCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiManager_WpsCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WpsCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @SystemApi
    public static interface ActionListener
    extends InstrumentedInterface {
        public void onSuccess();

        public void onFailure(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SapStartFailure {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WifiApState {
    }
}

