/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.nsd.WifiP2pDnsSdServiceResponse;
import android.net.wifi.p2p.nsd.WifiP2pUpnpServiceResponse;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pServiceResponse
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int MAX_BUF_SIZE;
    protected int mServiceType;
    protected int mStatus;
    protected int mTransId;
    protected WifiP2pDevice mDevice;
    protected byte[] mData;
    public static Parcelable.Creator<WifiP2pServiceResponse> CREATOR;

    private void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$__constructor__(int serviceType, int status, int transId, WifiP2pDevice device, byte[] data) {
        this.mServiceType = serviceType;
        this.mStatus = status;
        this.mTransId = transId;
        this.mDevice = device;
        this.mData = data;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getServiceType() {
        return this.mServiceType;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getStatus() {
        return this.mStatus;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getTransactionId() {
        return this.mTransId;
    }

    private final byte[] $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getRawData() {
        return this.mData;
    }

    private final WifiP2pDevice $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getSrcDevice() {
        return this.mDevice;
    }

    private final void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$setSrcDevice(WifiP2pDevice dev) {
        if (dev == null) {
            return;
        }
        this.mDevice = dev;
    }

    private static final List<WifiP2pServiceResponse> $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$newInstance(String srcAddr, byte[] tlvsBin) {
        ArrayList<WifiP2pServiceResponse> respList = new ArrayList<WifiP2pServiceResponse>();
        WifiP2pDevice dev = new WifiP2pDevice();
        dev.deviceAddress = srcAddr;
        if (tlvsBin == null) {
            return null;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(tlvsBin));
        try {
            while (dis.available() > 0) {
                int length = dis.readUnsignedByte() + (dis.readUnsignedByte() << 8) - 3;
                int type = dis.readUnsignedByte();
                int transId = dis.readUnsignedByte();
                int status = dis.readUnsignedByte();
                if (length < 0) {
                    return null;
                }
                if (length == 0) {
                    if (status != 0) continue;
                    respList.add(new WifiP2pServiceResponse(type, status, transId, dev, null));
                    continue;
                }
                if (length > MAX_BUF_SIZE) {
                    dis.skip(length);
                    continue;
                }
                byte[] data = new byte[length];
                dis.readFully(data);
                WifiP2pServiceResponse resp = type == 1 ? WifiP2pDnsSdServiceResponse.newInstance(status, transId, dev, data) : (type == 2 ? WifiP2pUpnpServiceResponse.newInstance(status, transId, dev, data) : new WifiP2pServiceResponse(type, status, transId, dev, data));
                if (resp == null || resp.getStatus() != 0) continue;
                respList.add(resp);
            }
            return respList;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (respList.size() > 0) {
                return respList;
            }
            return null;
        }
    }

    private static final byte[] $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$hexStr2Bin(String hex) {
        int sz = hex.length() / 2;
        byte[] b = new byte[hex.length() / 2];
        for (int i = 0; i < sz; ++i) {
            try {
                b[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return b;
    }

    private final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("serviceType:").append(this.mServiceType);
        sbuf.append(" status:").append(Status.toString(this.mStatus));
        sbuf.append(" srcAddr:").append(this.mDevice.deviceAddress);
        sbuf.append(" data:").append(Arrays.toString(this.mData));
        return sbuf.toString();
    }

    private final boolean $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WifiP2pServiceResponse)) {
            return false;
        }
        WifiP2pServiceResponse req = (WifiP2pServiceResponse)o;
        return req.mServiceType == this.mServiceType && req.mStatus == this.mStatus && this.equals(req.mDevice.deviceAddress, this.mDevice.deviceAddress) && Arrays.equals(req.mData, this.mData);
    }

    private final boolean $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return false;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$hashCode() {
        int result = 17;
        result = 31 * result + this.mServiceType;
        result = 31 * result + this.mStatus;
        result = 31 * result + this.mTransId;
        result = 31 * result + (this.mDevice.deviceAddress == null ? 0 : this.mDevice.deviceAddress.hashCode());
        result = 31 * result + (this.mData == null ? 0 : Arrays.hashCode(this.mData));
        return result;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mServiceType);
        dest.writeInt(this.mStatus);
        dest.writeInt(this.mTransId);
        dest.writeParcelable(this.mDevice, flags);
        if (this.mData == null || this.mData.length == 0) {
            dest.writeInt(0);
        } else {
            dest.writeInt(this.mData.length);
            dest.writeByteArray(this.mData);
        }
    }

    static void __staticInitializer__() {
        MAX_BUF_SIZE = 1024;
        CREATOR = new Parcelable.Creator<WifiP2pServiceResponse>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_1$__constructor__() {
            }

            private final WifiP2pServiceResponse $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_1$createFromParcel(Parcel in) {
                int type = in.readInt();
                int status = in.readInt();
                int transId = in.readInt();
                WifiP2pDevice dev = (WifiP2pDevice)in.readParcelable(null);
                int len = in.readInt();
                byte[] data = null;
                if (len > 0) {
                    data = new byte[len];
                    in.readByteArray(data);
                }
                if (type == 1) {
                    return WifiP2pDnsSdServiceResponse.newInstance(status, transId, dev, data);
                }
                if (type == 2) {
                    return WifiP2pUpnpServiceResponse.newInstance(status, transId, dev, data);
                }
                return new WifiP2pServiceResponse(type, status, transId, dev, data);
            }

            private final WifiP2pServiceResponse[] $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_1$newArray(int size) {
                return new WifiP2pServiceResponse[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_1$__constructor__(), 0, this);
            }

            @Override
            public WifiP2pServiceResponse createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WifiP2pServiceResponse[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, int n3, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$__constructor__(n, n2, n3, wifiP2pDevice, byArray);
    }

    protected WifiP2pServiceResponse(int n, int n2, int n3, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$__constructor__(int int int android.net.wifi.p2p.WifiP2pDevice byte[] ), 0, this, n, n2, n3, wifiP2pDevice, byArray);
    }

    public int getServiceType() {
        return (int)InvokeDynamicSupport.bootstrap("getServiceType", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getServiceType(), 0, this);
    }

    public int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getStatus(), 0, this);
    }

    public int getTransactionId() {
        return (int)InvokeDynamicSupport.bootstrap("getTransactionId", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getTransactionId(), 0, this);
    }

    public byte[] getRawData() {
        return InvokeDynamicSupport.bootstrap("getRawData", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getRawData(), 0, this);
    }

    public WifiP2pDevice getSrcDevice() {
        return InvokeDynamicSupport.bootstrap("getSrcDevice", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$getSrcDevice(), 0, this);
    }

    public void setSrcDevice(WifiP2pDevice wifiP2pDevice) {
        InvokeDynamicSupport.bootstrap("setSrcDevice", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$setSrcDevice(android.net.wifi.p2p.WifiP2pDevice ), 0, this, wifiP2pDevice);
    }

    public static List<WifiP2pServiceResponse> newInstance(String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$newInstance(java.lang.String byte[] ), 0, (String)string2, (byte[])byArray);
    }

    private static byte[] hexStr2Bin(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("hexStr2Bin", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$hexStr2Bin(java.lang.String ), 0, (String)string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$equals(java.lang.Object ), 0, this, object);
    }

    private boolean equals(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$equals(java.lang.Object java.lang.Object ), 0, this, object, object2);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pServiceResponse.class);
    }

    public /* synthetic */ WifiP2pServiceResponse() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pServiceResponse)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Status
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int SUCCESS = 0;
        public static int SERVICE_PROTOCOL_NOT_AVAILABLE = 1;
        public static int REQUESTED_INFORMATION_NOT_AVAILABLE = 2;
        public static int BAD_REQUEST = 3;

        private static final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_Status$toString(int status) {
            switch (status) {
                case 0: {
                    return "SUCCESS";
                }
                case 1: {
                    return "SERVICE_PROTOCOL_NOT_AVAILABLE";
                }
                case 2: {
                    return "REQUESTED_INFORMATION_NOT_AVAILABLE";
                }
                case 3: {
                    return "BAD_REQUEST";
                }
            }
            return "UNKNOWN";
        }

        private void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_Status$__constructor__() {
        }

        public static String toString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("toString", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_Status$toString(int ), 0, (int)n);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_Status$__constructor__();
        }

        private Status() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceResponse_Status$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Status)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

