/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.TransactionTooLargeException;
import android.util.Log;
import com.android.internal.os.IDropBoxManagerService;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DropBoxManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DropBoxManager";
    private Context mContext;
    private IDropBoxManagerService mService;
    public static int IS_EMPTY = 1;
    public static int IS_TEXT = 2;
    public static int IS_GZIPPED = 4;
    private static int HAS_BYTE_ARRAY = 8;
    public static String ACTION_DROPBOX_ENTRY_ADDED = "android.intent.action.DROPBOX_ENTRY_ADDED";
    public static String EXTRA_TAG = "tag";
    public static String EXTRA_TIME = "time";

    private void $$robo$$android_os_DropBoxManager$__constructor__(Context context, IDropBoxManagerService service) {
        this.mContext = context;
        this.mService = service;
    }

    private void $$robo$$android_os_DropBoxManager$__constructor__() {
        this.mContext = null;
        this.mService = null;
    }

    private final void $$robo$$android_os_DropBoxManager$addText(String tag, String data) {
        try {
            this.mService.add(new Entry(tag, 0L, data));
        }
        catch (RemoteException e) {
            if (e instanceof TransactionTooLargeException && this.mContext.getApplicationInfo().targetSdkVersion < 24) {
                Log.e("DropBoxManager", "App sent too much data, so it was ignored", e);
                return;
            }
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_DropBoxManager$addData(String tag, byte[] data, int flags) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        try {
            this.mService.add(new Entry(tag, 0L, data, flags));
        }
        catch (RemoteException e) {
            if (e instanceof TransactionTooLargeException && this.mContext.getApplicationInfo().targetSdkVersion < 24) {
                Log.e("DropBoxManager", "App sent too much data, so it was ignored", e);
                return;
            }
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_DropBoxManager$addFile(String tag, File file, int flags) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        try (Entry entry = new Entry(tag, 0L, file, flags);){
            this.mService.add(entry);
        }
    }

    private final boolean $$robo$$android_os_DropBoxManager$isTagEnabled(String tag) {
        try {
            return this.mService.isTagEnabled(tag);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final Entry $$robo$$android_os_DropBoxManager$getNextEntry(String tag, long msec) {
        try {
            return this.mService.getNextEntry(tag, msec);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(Context context, IDropBoxManagerService iDropBoxManagerService) {
        this.$$robo$$android_os_DropBoxManager$__constructor__(context, iDropBoxManagerService);
    }

    public DropBoxManager(Context context, IDropBoxManagerService iDropBoxManagerService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_DropBoxManager$__constructor__(android.content.Context com.android.internal.os.IDropBoxManagerService ), 0, this, context, iDropBoxManagerService);
    }

    private void __constructor__() {
        this.$$robo$$android_os_DropBoxManager$__constructor__();
    }

    protected DropBoxManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_DropBoxManager$__constructor__(), 0, this);
    }

    public void addText(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("addText", $$robo$$android_os_DropBoxManager$addText(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void addData(String string2, byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("addData", $$robo$$android_os_DropBoxManager$addData(java.lang.String byte[] int ), 0, this, string2, byArray, n);
    }

    public void addFile(String string2, File file, int n) throws IOException {
        InvokeDynamicSupport.bootstrap("addFile", $$robo$$android_os_DropBoxManager$addFile(java.lang.String java.io.File int ), 0, this, string2, file, n);
    }

    public boolean isTagEnabled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTagEnabled", $$robo$$android_os_DropBoxManager$isTagEnabled(java.lang.String ), 0, this, string2);
    }

    public Entry getNextEntry(String string2, long l) {
        return InvokeDynamicSupport.bootstrap("getNextEntry", $$robo$$android_os_DropBoxManager$getNextEntry(java.lang.String long ), 0, this, string2, l);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DropBoxManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Entry
    implements Parcelable,
    Closeable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mTag;
        private long mTimeMillis;
        private byte[] mData;
        private ParcelFileDescriptor mFileDescriptor;
        private int mFlags;
        public static Parcelable.Creator<Entry> CREATOR;

        private void $$robo$$android_os_DropBoxManager_Entry$__constructor__(String tag, long millis) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = null;
            this.mFlags = 1;
        }

        private void $$robo$$android_os_DropBoxManager_Entry$__constructor__(String tag, long millis, String text) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if (text == null) {
                throw new NullPointerException("text == null");
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = text.getBytes();
            this.mFileDescriptor = null;
            this.mFlags = 2;
        }

        private void $$robo$$android_os_DropBoxManager_Entry$__constructor__(String tag, long millis, byte[] data, int flags) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0 != (data == null)) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = data;
            this.mFileDescriptor = null;
            this.mFlags = flags;
        }

        private void $$robo$$android_os_DropBoxManager_Entry$__constructor__(String tag, long millis, ParcelFileDescriptor data, int flags) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0 != (data == null)) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = data;
            this.mFlags = flags;
        }

        private void $$robo$$android_os_DropBoxManager_Entry$__constructor__(String tag, long millis, File data, int flags) throws IOException {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = ParcelFileDescriptor.open(data, 0x10000000);
            this.mFlags = flags;
        }

        private final void $$robo$$android_os_DropBoxManager_Entry$close() {
            try {
                if (this.mFileDescriptor != null) {
                    this.mFileDescriptor.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private final String $$robo$$android_os_DropBoxManager_Entry$getTag() {
            return this.mTag;
        }

        private final long $$robo$$android_os_DropBoxManager_Entry$getTimeMillis() {
            return this.mTimeMillis;
        }

        private final int $$robo$$android_os_DropBoxManager_Entry$getFlags() {
            return this.mFlags & 0xFFFFFFFB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_os_DropBoxManager_Entry$getText(int maxBytes) {
            String string2;
            if ((this.mFlags & 2) == 0) {
                return null;
            }
            if (this.mData != null) {
                return new String(this.mData, 0, Math.min(maxBytes, this.mData.length));
            }
            InputStream is = null;
            try {
                is = this.getInputStream();
                if (is == null) {
                    String string3 = null;
                    return string3;
                }
                byte[] buf = new byte[maxBytes];
                int readBytes = 0;
                int n = 0;
                while (n >= 0 && (readBytes += n) < maxBytes) {
                    n = is.read(buf, readBytes, maxBytes - readBytes);
                }
                string2 = new String(buf, 0, readBytes);
            }
            catch (IOException e) {
                String string4 = null;
                return string4;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return string2;
        }

        private final InputStream $$robo$$android_os_DropBoxManager_Entry$getInputStream() throws IOException {
            InputStream is;
            if (this.mData != null) {
                is = new ByteArrayInputStream(this.mData);
            } else if (this.mFileDescriptor != null) {
                is = new ParcelFileDescriptor.AutoCloseInputStream(this.mFileDescriptor);
            } else {
                return null;
            }
            return (this.mFlags & 4) != 0 ? new GZIPInputStream(is) : is;
        }

        private final int $$robo$$android_os_DropBoxManager_Entry$describeContents() {
            return this.mFileDescriptor != null ? 1 : 0;
        }

        private final void $$robo$$android_os_DropBoxManager_Entry$writeToParcel(Parcel out, int flags) {
            out.writeString(this.mTag);
            out.writeLong(this.mTimeMillis);
            if (this.mFileDescriptor != null) {
                out.writeInt(this.mFlags & 0xFFFFFFF7);
                this.mFileDescriptor.writeToParcel(out, flags);
            } else {
                out.writeInt(this.mFlags | 8);
                out.writeByteArray(this.mData);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_DropBoxManager_Entry_1$__constructor__() {
                }

                private final Entry[] $$robo$$android_os_DropBoxManager_Entry_1$newArray(int size) {
                    return new Entry[size];
                }

                private final Entry $$robo$$android_os_DropBoxManager_Entry_1$createFromParcel(Parcel in) {
                    String tag = in.readString();
                    long millis = in.readLong();
                    int flags = in.readInt();
                    if ((flags & 8) != 0) {
                        return new Entry(tag, millis, in.createByteArray(), flags & 0xFFFFFFF7);
                    }
                    ParcelFileDescriptor pfd = ParcelFileDescriptor.CREATOR.createFromParcel(in);
                    return new Entry(tag, millis, pfd, flags);
                }

                private void __constructor__() {
                    this.$$robo$$android_os_DropBoxManager_Entry_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_DropBoxManager_Entry_1$__constructor__(), 0, this);
                }

                public Entry[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_DropBoxManager_Entry_1$newArray(int ), 0, this, n);
                }

                public Entry createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_DropBoxManager_Entry_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(String string2, long l) {
            this.$$robo$$android_os_DropBoxManager_Entry$__constructor__(string2, l);
        }

        public Entry(String string2, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_DropBoxManager_Entry$__constructor__(java.lang.String long ), 0, this, string2, l);
        }

        private void __constructor__(String string2, long l, String string3) {
            this.$$robo$$android_os_DropBoxManager_Entry$__constructor__(string2, l, string3);
        }

        public Entry(String string2, long l, String string3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_DropBoxManager_Entry$__constructor__(java.lang.String long java.lang.String ), 0, this, string2, l, string3);
        }

        private void __constructor__(String string2, long l, byte[] byArray, int n) {
            this.$$robo$$android_os_DropBoxManager_Entry$__constructor__(string2, l, byArray, n);
        }

        public Entry(String string2, long l, byte[] byArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_DropBoxManager_Entry$__constructor__(java.lang.String long byte[] int ), 0, this, string2, l, byArray, n);
        }

        private void __constructor__(String string2, long l, ParcelFileDescriptor parcelFileDescriptor, int n) {
            this.$$robo$$android_os_DropBoxManager_Entry$__constructor__(string2, l, parcelFileDescriptor, n);
        }

        public Entry(String string2, long l, ParcelFileDescriptor parcelFileDescriptor, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_DropBoxManager_Entry$__constructor__(java.lang.String long android.os.ParcelFileDescriptor int ), 0, this, string2, l, parcelFileDescriptor, n);
        }

        private void __constructor__(String string2, long l, File file, int n) throws IOException {
            this.$$robo$$android_os_DropBoxManager_Entry$__constructor__(string2, l, file, n);
        }

        public Entry(String string2, long l, File file, int n) throws IOException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_DropBoxManager_Entry$__constructor__(java.lang.String long java.io.File int ), 0, this, string2, l, file, n);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_DropBoxManager_Entry$close(), 0, this);
        }

        public String getTag() {
            return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_os_DropBoxManager_Entry$getTag(), 0, this);
        }

        public long getTimeMillis() {
            return (long)InvokeDynamicSupport.bootstrap("getTimeMillis", $$robo$$android_os_DropBoxManager_Entry$getTimeMillis(), 0, this);
        }

        public int getFlags() {
            return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_os_DropBoxManager_Entry$getFlags(), 0, this);
        }

        public String getText(int n) {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_os_DropBoxManager_Entry$getText(int ), 0, this, n);
        }

        public InputStream getInputStream() throws IOException {
            return InvokeDynamicSupport.bootstrap("getInputStream", $$robo$$android_os_DropBoxManager_Entry$getInputStream(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_DropBoxManager_Entry$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_DropBoxManager_Entry$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(Entry.class);
        }

        public /* synthetic */ Entry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

