/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.icu.util.ULocale;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LocaleList
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Locale[] mList;
    private String mStringRepresentation;
    private static Locale[] sEmptyList;
    private static LocaleList sEmptyLocaleList;
    public static Parcelable.Creator<LocaleList> CREATOR;
    private static String STRING_EN_XA = "en-XA";
    private static String STRING_AR_XB = "ar-XB";
    private static Locale LOCALE_EN_XA;
    private static Locale LOCALE_AR_XB;
    private static int NUM_PSEUDO_LOCALES = 2;
    private static Locale EN_LATN;
    private static Object sLock;
    @GuardedBy(value="sLock")
    private static LocaleList sLastExplicitlySetLocaleList;
    @GuardedBy(value="sLock")
    private static LocaleList sDefaultLocaleList;
    @GuardedBy(value="sLock")
    private static LocaleList sDefaultAdjustedLocaleList;
    @GuardedBy(value="sLock")
    private static Locale sLastDefaultLocale;

    private final Locale $$robo$$android_os_LocaleList$get(int index) {
        return 0 <= index && index < this.mList.length ? this.mList[index] : null;
    }

    private final boolean $$robo$$android_os_LocaleList$isEmpty() {
        return this.mList.length == 0;
    }

    private final int $$robo$$android_os_LocaleList$size() {
        return this.mList.length;
    }

    private final int $$robo$$android_os_LocaleList$indexOf(Locale locale) {
        for (int i = 0; i < this.mList.length; ++i) {
            if (!this.mList[i].equals(locale)) continue;
            return i;
        }
        return -1;
    }

    private final boolean $$robo$$android_os_LocaleList$equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LocaleList)) {
            return false;
        }
        Locale[] otherList = ((LocaleList)other).mList;
        if (this.mList.length != otherList.length) {
            return false;
        }
        for (int i = 0; i < this.mList.length; ++i) {
            if (this.mList[i].equals(otherList[i])) continue;
            return false;
        }
        return true;
    }

    private final int $$robo$$android_os_LocaleList$hashCode() {
        int result = 1;
        for (int i = 0; i < this.mList.length; ++i) {
            result = 31 * result + this.mList[i].hashCode();
        }
        return result;
    }

    private final String $$robo$$android_os_LocaleList$toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.mList.length; ++i) {
            sb.append(this.mList[i]);
            if (i >= this.mList.length - 1) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }

    private final int $$robo$$android_os_LocaleList$describeContents() {
        return 0;
    }

    private final void $$robo$$android_os_LocaleList$writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeString(this.mStringRepresentation);
    }

    private final void $$robo$$android_os_LocaleList$writeToProto(ProtoOutputStream protoOutputStream, long fieldId) {
        for (int i = 0; i < this.mList.length; ++i) {
            Locale locale = this.mList[i];
            long token = protoOutputStream.start(fieldId);
            protoOutputStream.write(0x10900000001L, locale.getLanguage());
            protoOutputStream.write(1138166333442L, locale.getCountry());
            protoOutputStream.write(1138166333443L, locale.getVariant());
            protoOutputStream.end(token);
        }
    }

    private final String $$robo$$android_os_LocaleList$toLanguageTags() {
        return this.mStringRepresentation;
    }

    private void $$robo$$android_os_LocaleList$__constructor__(Locale ... list) {
        if (list.length == 0) {
            this.mList = sEmptyList;
            this.mStringRepresentation = "";
        } else {
            Locale[] localeList = new Locale[list.length];
            HashSet<Locale> seenLocales = new HashSet<Locale>();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                Locale localeClone;
                Locale l = list[i];
                if (l == null) {
                    throw new NullPointerException("list[" + i + "] is null");
                }
                if (seenLocales.contains(l)) {
                    throw new IllegalArgumentException("list[" + i + "] is a repetition");
                }
                localeList[i] = localeClone = (Locale)l.clone();
                sb.append(localeClone.toLanguageTag());
                if (i < list.length - 1) {
                    sb.append(',');
                }
                seenLocales.add(localeClone);
            }
            this.mList = localeList;
            this.mStringRepresentation = sb.toString();
        }
    }

    private void $$robo$$android_os_LocaleList$__constructor__(Locale topLocale, LocaleList otherLocales) {
        int i;
        if (topLocale == null) {
            throw new NullPointerException("topLocale is null");
        }
        int inputLength = otherLocales == null ? 0 : otherLocales.mList.length;
        int topLocaleIndex = -1;
        for (int i2 = 0; i2 < inputLength; ++i2) {
            if (!topLocale.equals(otherLocales.mList[i2])) continue;
            topLocaleIndex = i2;
            break;
        }
        int outputLength = inputLength + (topLocaleIndex == -1 ? 1 : 0);
        Locale[] localeList = new Locale[outputLength];
        localeList[0] = (Locale)topLocale.clone();
        if (topLocaleIndex == -1) {
            for (i = 0; i < inputLength; ++i) {
                localeList[i + 1] = (Locale)otherLocales.mList[i].clone();
            }
        } else {
            for (i = 0; i < topLocaleIndex; ++i) {
                localeList[i + 1] = (Locale)otherLocales.mList[i].clone();
            }
            for (i = topLocaleIndex + 1; i < inputLength; ++i) {
                localeList[i] = (Locale)otherLocales.mList[i].clone();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (int i3 = 0; i3 < outputLength; ++i3) {
            sb.append(localeList[i3].toLanguageTag());
            if (i3 >= outputLength - 1) continue;
            sb.append(',');
        }
        this.mList = localeList;
        this.mStringRepresentation = sb.toString();
    }

    private static final LocaleList $$robo$$android_os_LocaleList$getEmptyLocaleList() {
        return sEmptyLocaleList;
    }

    private static final LocaleList $$robo$$android_os_LocaleList$forLanguageTags(String list) {
        if (list == null || list.equals("")) {
            return LocaleList.getEmptyLocaleList();
        }
        String[] tags = list.split(",");
        Locale[] localeArray = new Locale[tags.length];
        for (int i = 0; i < localeArray.length; ++i) {
            localeArray[i] = Locale.forLanguageTag(tags[i]);
        }
        return new LocaleList(localeArray);
    }

    private static final String $$robo$$android_os_LocaleList$getLikelyScript(Locale locale) {
        String script = locale.getScript();
        if (!script.isEmpty()) {
            return script;
        }
        return ULocale.addLikelySubtags(ULocale.forLocale(locale)).getScript();
    }

    private static final boolean $$robo$$android_os_LocaleList$isPseudoLocale(String locale) {
        return "en-XA".equals(locale) || "ar-XB".equals(locale);
    }

    private static final boolean $$robo$$android_os_LocaleList$isPseudoLocale(Locale locale) {
        return LOCALE_EN_XA.equals(locale) || LOCALE_AR_XB.equals(locale);
    }

    private static final int $$robo$$android_os_LocaleList$matchScore(Locale supported, Locale desired) {
        if (supported.equals(desired)) {
            return 1;
        }
        if (!supported.getLanguage().equals(desired.getLanguage())) {
            return 0;
        }
        if (LocaleList.isPseudoLocale(supported) || LocaleList.isPseudoLocale(desired)) {
            return 0;
        }
        String supportedScr = LocaleList.getLikelyScript(supported);
        if (supportedScr.isEmpty()) {
            String supportedRegion = supported.getCountry();
            return supportedRegion.isEmpty() || supportedRegion.equals(desired.getCountry()) ? 1 : 0;
        }
        String desiredScr = LocaleList.getLikelyScript(desired);
        return supportedScr.equals(desiredScr) ? 1 : 0;
    }

    private final int $$robo$$android_os_LocaleList$findFirstMatchIndex(Locale supportedLocale) {
        for (int idx = 0; idx < this.mList.length; ++idx) {
            int score = LocaleList.matchScore(supportedLocale, this.mList[idx]);
            if (score <= 0) continue;
            return idx;
        }
        return Integer.MAX_VALUE;
    }

    private final int $$robo$$android_os_LocaleList$computeFirstMatchIndex(Collection<String> supportedLocales, boolean assumeEnglishIsSupported) {
        if (this.mList.length == 1) {
            return 0;
        }
        if (this.mList.length == 0) {
            return -1;
        }
        int bestIndex = Integer.MAX_VALUE;
        if (assumeEnglishIsSupported) {
            int idx = this.findFirstMatchIndex(EN_LATN);
            if (idx == 0) {
                return 0;
            }
            if (idx < bestIndex) {
                bestIndex = idx;
            }
        }
        for (String languageTag : supportedLocales) {
            Locale supportedLocale = Locale.forLanguageTag(languageTag);
            int idx = this.findFirstMatchIndex(supportedLocale);
            if (idx == 0) {
                return 0;
            }
            if (idx >= bestIndex) continue;
            bestIndex = idx;
        }
        if (bestIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return bestIndex;
    }

    private final Locale $$robo$$android_os_LocaleList$computeFirstMatch(Collection<String> supportedLocales, boolean assumeEnglishIsSupported) {
        int bestIndex = this.computeFirstMatchIndex(supportedLocales, assumeEnglishIsSupported);
        return bestIndex == -1 ? null : this.mList[bestIndex];
    }

    private final Locale $$robo$$android_os_LocaleList$getFirstMatch(String[] supportedLocales) {
        return this.computeFirstMatch(Arrays.asList(supportedLocales), false);
    }

    private final int $$robo$$android_os_LocaleList$getFirstMatchIndex(String[] supportedLocales) {
        return this.computeFirstMatchIndex(Arrays.asList(supportedLocales), false);
    }

    private final Locale $$robo$$android_os_LocaleList$getFirstMatchWithEnglishSupported(String[] supportedLocales) {
        return this.computeFirstMatch(Arrays.asList(supportedLocales), true);
    }

    private final int $$robo$$android_os_LocaleList$getFirstMatchIndexWithEnglishSupported(Collection<String> supportedLocales) {
        return this.computeFirstMatchIndex(supportedLocales, true);
    }

    private final int $$robo$$android_os_LocaleList$getFirstMatchIndexWithEnglishSupported(String[] supportedLocales) {
        return this.getFirstMatchIndexWithEnglishSupported(Arrays.asList(supportedLocales));
    }

    private static final boolean $$robo$$android_os_LocaleList$isPseudoLocalesOnly(String[] supportedLocales) {
        if (supportedLocales == null) {
            return true;
        }
        if (supportedLocales.length > 3) {
            return false;
        }
        for (String locale : supportedLocales) {
            if (locale.isEmpty() || LocaleList.isPseudoLocale(locale)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LocaleList $$robo$$android_os_LocaleList$getDefault() {
        Locale defaultLocale = Locale.getDefault();
        Object object = sLock;
        synchronized (object) {
            if (!defaultLocale.equals(sLastDefaultLocale)) {
                sLastDefaultLocale = defaultLocale;
                if (sDefaultLocaleList != null && defaultLocale.equals(sDefaultLocaleList.get(0))) {
                    return sDefaultLocaleList;
                }
                sDefaultAdjustedLocaleList = sDefaultLocaleList = new LocaleList(defaultLocale, sLastExplicitlySetLocaleList);
            }
            return sDefaultLocaleList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LocaleList $$robo$$android_os_LocaleList$getAdjustedDefault() {
        LocaleList.getDefault();
        Object object = sLock;
        synchronized (object) {
            return sDefaultAdjustedLocaleList;
        }
    }

    private static final void $$robo$$android_os_LocaleList$setDefault(LocaleList locales) {
        LocaleList.setDefault(locales, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_LocaleList$setDefault(LocaleList locales, int localeIndex) {
        if (locales == null) {
            throw new NullPointerException("locales is null");
        }
        if (locales.isEmpty()) {
            throw new IllegalArgumentException("locales is empty");
        }
        Object object = sLock;
        synchronized (object) {
            sLastDefaultLocale = locales.get(localeIndex);
            Locale.setDefault(sLastDefaultLocale);
            sLastExplicitlySetLocaleList = locales;
            sDefaultLocaleList = locales;
            sDefaultAdjustedLocaleList = localeIndex == 0 ? sDefaultLocaleList : new LocaleList(sLastDefaultLocale, sDefaultLocaleList);
        }
    }

    static void __staticInitializer__() {
        sEmptyList = new Locale[0];
        sEmptyLocaleList = new LocaleList(new Locale[0]);
        CREATOR = new Parcelable.Creator<LocaleList>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_LocaleList_1$__constructor__() {
            }

            private final LocaleList $$robo$$android_os_LocaleList_1$createFromParcel(Parcel source) {
                return LocaleList.forLanguageTags(source.readString());
            }

            private final LocaleList[] $$robo$$android_os_LocaleList_1$newArray(int size) {
                return new LocaleList[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_LocaleList_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_LocaleList_1$__constructor__(), 0, this);
            }

            @Override
            public LocaleList createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_LocaleList_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public LocaleList[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_LocaleList_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        LOCALE_EN_XA = new Locale("en", "XA");
        LOCALE_AR_XB = new Locale("ar", "XB");
        EN_LATN = Locale.forLanguageTag("en-Latn");
        sLock = new Object();
        sLastExplicitlySetLocaleList = null;
        sDefaultLocaleList = null;
        sDefaultAdjustedLocaleList = null;
        sLastDefaultLocale = null;
    }

    public Locale get(int n) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_os_LocaleList$get(int ), 0, this, n);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_os_LocaleList$isEmpty(), 0, this);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_os_LocaleList$size(), 0, this);
    }

    public int indexOf(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$android_os_LocaleList$indexOf(java.util.Locale ), 0, this, locale);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_LocaleList$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_LocaleList$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_LocaleList$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_LocaleList$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_LocaleList$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_os_LocaleList$writeToProto(android.util.proto.ProtoOutputStream long ), 0, this, protoOutputStream, l);
    }

    public String toLanguageTags() {
        return InvokeDynamicSupport.bootstrap("toLanguageTags", $$robo$$android_os_LocaleList$toLanguageTags(), 0, this);
    }

    private void __constructor__(Locale ... localeArray) {
        this.$$robo$$android_os_LocaleList$__constructor__(localeArray);
    }

    public LocaleList(Locale ... localeArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_LocaleList$__constructor__(java.util.Locale[] ), 0, this, localeArray);
    }

    private void __constructor__(Locale locale, LocaleList localeList) {
        this.$$robo$$android_os_LocaleList$__constructor__(locale, localeList);
    }

    public LocaleList(Locale locale, LocaleList localeList) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_LocaleList$__constructor__(java.util.Locale android.os.LocaleList ), 0, this, locale, localeList);
    }

    public static LocaleList getEmptyLocaleList() {
        return InvokeDynamicSupport.bootstrapStatic("getEmptyLocaleList", $$robo$$android_os_LocaleList$getEmptyLocaleList(), 0);
    }

    public static LocaleList forLanguageTags(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("forLanguageTags", $$robo$$android_os_LocaleList$forLanguageTags(java.lang.String ), 0, (String)string2);
    }

    private static String getLikelyScript(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getLikelyScript", $$robo$$android_os_LocaleList$getLikelyScript(java.util.Locale ), 0, (Locale)locale);
    }

    private static boolean isPseudoLocale(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPseudoLocale", $$robo$$android_os_LocaleList$isPseudoLocale(java.lang.String ), 0, (String)string2);
    }

    public static boolean isPseudoLocale(Locale locale) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPseudoLocale", $$robo$$android_os_LocaleList$isPseudoLocale(java.util.Locale ), 0, (Locale)locale);
    }

    private static int matchScore(Locale locale, Locale locale2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("matchScore", $$robo$$android_os_LocaleList$matchScore(java.util.Locale java.util.Locale ), 0, (Locale)locale, (Locale)locale2);
    }

    private int findFirstMatchIndex(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrap("findFirstMatchIndex", $$robo$$android_os_LocaleList$findFirstMatchIndex(java.util.Locale ), 0, this, locale);
    }

    private int computeFirstMatchIndex(Collection<String> collection, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("computeFirstMatchIndex", $$robo$$android_os_LocaleList$computeFirstMatchIndex(java.util.Collection<java.lang.String> boolean ), 0, this, collection, bl);
    }

    private Locale computeFirstMatch(Collection<String> collection, boolean bl) {
        return InvokeDynamicSupport.bootstrap("computeFirstMatch", $$robo$$android_os_LocaleList$computeFirstMatch(java.util.Collection<java.lang.String> boolean ), 0, this, collection, bl);
    }

    public Locale getFirstMatch(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("getFirstMatch", $$robo$$android_os_LocaleList$getFirstMatch(java.lang.String[] ), 0, this, stringArray);
    }

    public int getFirstMatchIndex(String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("getFirstMatchIndex", $$robo$$android_os_LocaleList$getFirstMatchIndex(java.lang.String[] ), 0, this, stringArray);
    }

    public Locale getFirstMatchWithEnglishSupported(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("getFirstMatchWithEnglishSupported", $$robo$$android_os_LocaleList$getFirstMatchWithEnglishSupported(java.lang.String[] ), 0, this, stringArray);
    }

    public int getFirstMatchIndexWithEnglishSupported(Collection<String> collection) {
        return (int)InvokeDynamicSupport.bootstrap("getFirstMatchIndexWithEnglishSupported", $$robo$$android_os_LocaleList$getFirstMatchIndexWithEnglishSupported(java.util.Collection<java.lang.String> ), 0, this, collection);
    }

    public int getFirstMatchIndexWithEnglishSupported(String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("getFirstMatchIndexWithEnglishSupported", $$robo$$android_os_LocaleList$getFirstMatchIndexWithEnglishSupported(java.lang.String[] ), 0, this, stringArray);
    }

    public static boolean isPseudoLocalesOnly(String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPseudoLocalesOnly", $$robo$$android_os_LocaleList$isPseudoLocalesOnly(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static LocaleList getDefault() {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_os_LocaleList$getDefault(), 0);
    }

    public static LocaleList getAdjustedDefault() {
        return InvokeDynamicSupport.bootstrapStatic("getAdjustedDefault", $$robo$$android_os_LocaleList$getAdjustedDefault(), 0);
    }

    public static void setDefault(LocaleList localeList) {
        InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_os_LocaleList$setDefault(android.os.LocaleList ), 0, (LocaleList)localeList);
    }

    public static void setDefault(LocaleList localeList, int n) {
        InvokeDynamicSupport.bootstrapStatic("setDefault", $$robo$$android_os_LocaleList$setDefault(android.os.LocaleList int ), 0, (LocaleList)localeList, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(LocaleList.class);
    }

    public /* synthetic */ LocaleList() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

