/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.IPowerManager;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Trace;
import android.os.WorkSource;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PowerManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PowerManager";
    public static int PARTIAL_WAKE_LOCK = 1;
    @Deprecated
    public static int SCREEN_DIM_WAKE_LOCK = 6;
    @Deprecated
    public static int SCREEN_BRIGHT_WAKE_LOCK = 10;
    @Deprecated
    public static int FULL_WAKE_LOCK = 26;
    public static int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    public static int DOZE_WAKE_LOCK = 64;
    public static int DRAW_WAKE_LOCK = 128;
    public static int WAKE_LOCK_LEVEL_MASK = 65535;
    public static int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
    public static int ON_AFTER_RELEASE = 0x20000000;
    public static int UNIMPORTANT_FOR_LOGGING = 0x40000000;
    public static int RELEASE_FLAG_WAIT_FOR_NO_PROXIMITY = 1;
    public static int RELEASE_FLAG_TIMEOUT = 65536;
    public static int BRIGHTNESS_ON = 255;
    public static int BRIGHTNESS_OFF = 0;
    public static int BRIGHTNESS_DEFAULT = -1;
    @SystemApi
    public static int USER_ACTIVITY_EVENT_OTHER = 0;
    @SystemApi
    public static int USER_ACTIVITY_EVENT_BUTTON = 1;
    @SystemApi
    public static int USER_ACTIVITY_EVENT_TOUCH = 2;
    @SystemApi
    public static int USER_ACTIVITY_EVENT_ACCESSIBILITY = 3;
    @SystemApi
    public static int USER_ACTIVITY_FLAG_NO_CHANGE_LIGHTS = 1;
    @SystemApi
    public static int USER_ACTIVITY_FLAG_INDIRECT = 2;
    public static int GO_TO_SLEEP_REASON_APPLICATION = 0;
    public static int GO_TO_SLEEP_REASON_DEVICE_ADMIN = 1;
    public static int GO_TO_SLEEP_REASON_TIMEOUT = 2;
    public static int GO_TO_SLEEP_REASON_LID_SWITCH = 3;
    public static int GO_TO_SLEEP_REASON_POWER_BUTTON = 4;
    public static int GO_TO_SLEEP_REASON_HDMI = 5;
    public static int GO_TO_SLEEP_REASON_SLEEP_BUTTON = 6;
    public static int GO_TO_SLEEP_REASON_ACCESSIBILITY = 7;
    public static int GO_TO_SLEEP_FLAG_NO_DOZE = 1;
    public static String REBOOT_RECOVERY = "recovery";
    public static String REBOOT_RECOVERY_UPDATE = "recovery-update";
    public static String REBOOT_REQUESTED_BY_DEVICE_OWNER = "deviceowner";
    public static String REBOOT_SAFE_MODE = "safemode";
    public static String REBOOT_QUIESCENT = "quiescent";
    public static String SHUTDOWN_USER_REQUESTED = "userrequested";
    public static String SHUTDOWN_BATTERY_THERMAL_STATE = "thermal,battery";
    public static String SHUTDOWN_LOW_BATTERY = "battery";
    public static int SHUTDOWN_REASON_UNKNOWN = 0;
    public static int SHUTDOWN_REASON_SHUTDOWN = 1;
    public static int SHUTDOWN_REASON_REBOOT = 2;
    public static int SHUTDOWN_REASON_USER_REQUESTED = 3;
    public static int SHUTDOWN_REASON_THERMAL_SHUTDOWN = 4;
    public static int SHUTDOWN_REASON_LOW_BATTERY = 5;
    public static int SHUTDOWN_REASON_BATTERY_THERMAL = 6;
    public static int LOCATION_MODE_NO_CHANGE = 0;
    public static int LOCATION_MODE_GPS_DISABLED_WHEN_SCREEN_OFF = 1;
    public static int LOCATION_MODE_ALL_DISABLED_WHEN_SCREEN_OFF = 2;
    public static int LOCATION_MODE_FOREGROUND_ONLY = 3;
    Context mContext;
    IPowerManager mService;
    Handler mHandler;
    IDeviceIdleController mIDeviceIdleController;
    public static String ACTION_POWER_SAVE_MODE_CHANGED = "android.os.action.POWER_SAVE_MODE_CHANGED";
    public static String ACTION_POWER_SAVE_MODE_CHANGED_INTERNAL = "android.os.action.POWER_SAVE_MODE_CHANGED_INTERNAL";
    public static String ACTION_DEVICE_IDLE_MODE_CHANGED = "android.os.action.DEVICE_IDLE_MODE_CHANGED";
    public static String ACTION_LIGHT_DEVICE_IDLE_MODE_CHANGED = "android.os.action.LIGHT_DEVICE_IDLE_MODE_CHANGED";
    public static String ACTION_POWER_SAVE_WHITELIST_CHANGED = "android.os.action.POWER_SAVE_WHITELIST_CHANGED";
    public static String ACTION_POWER_SAVE_TEMP_WHITELIST_CHANGED = "android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED";
    public static String ACTION_POWER_SAVE_MODE_CHANGING = "android.os.action.POWER_SAVE_MODE_CHANGING";
    public static String EXTRA_POWER_SAVE_MODE = "mode";
    @SystemApi
    @Deprecated
    public static String ACTION_SCREEN_BRIGHTNESS_BOOST_CHANGED = "android.os.action.SCREEN_BRIGHTNESS_BOOST_CHANGED";

    private void $$robo$$android_os_PowerManager$__constructor__(Context context, IPowerManager service, Handler handler) {
        this.mContext = context;
        this.mService = service;
        this.mHandler = handler;
    }

    private final int $$robo$$android_os_PowerManager$getMinimumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694862);
    }

    private final int $$robo$$android_os_PowerManager$getMaximumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694861);
    }

    private final int $$robo$$android_os_PowerManager$getDefaultScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694860);
    }

    private final int $$robo$$android_os_PowerManager$getMinimumScreenBrightnessForVrSetting() {
        return this.mContext.getResources().getInteger(17694859);
    }

    private final int $$robo$$android_os_PowerManager$getMaximumScreenBrightnessForVrSetting() {
        return this.mContext.getResources().getInteger(17694858);
    }

    private final int $$robo$$android_os_PowerManager$getDefaultScreenBrightnessForVrSetting() {
        return this.mContext.getResources().getInteger(17694857);
    }

    private final WakeLock $$robo$$android_os_PowerManager$newWakeLock(int levelAndFlags, String tag) {
        PowerManager.validateWakeLockParameters(levelAndFlags, tag);
        return new WakeLock(this, levelAndFlags, tag, this.mContext.getOpPackageName());
    }

    private static final void $$robo$$android_os_PowerManager$validateWakeLockParameters(int levelAndFlags, String tag) {
        switch (levelAndFlags & 0xFFFF) {
            case 1: 
            case 6: 
            case 10: 
            case 26: 
            case 32: 
            case 64: 
            case 128: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Must specify a valid wake lock level.");
            }
        }
        if (tag == null) {
            throw new IllegalArgumentException("The tag must not be null.");
        }
    }

    @Deprecated
    private final void $$robo$$android_os_PowerManager$userActivity(long when, boolean noChangeLights) {
        this.userActivity(when, 0, noChangeLights ? 1 : 0);
    }

    @SystemApi
    private final void $$robo$$android_os_PowerManager$userActivity(long when, int event, int flags) {
        try {
            this.mService.userActivity(when, event, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_PowerManager$goToSleep(long time) {
        this.goToSleep(time, 0, 0);
    }

    private final void $$robo$$android_os_PowerManager$goToSleep(long time, int reason, int flags) {
        try {
            this.mService.goToSleep(time, reason, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_PowerManager$wakeUp(long time) {
        try {
            this.mService.wakeUp(time, "wakeUp", this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_PowerManager$wakeUp(long time, String reason) {
        try {
            this.mService.wakeUp(time, reason, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_PowerManager$nap(long time) {
        try {
            this.mService.nap(time);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_PowerManager$boostScreenBrightness(long time) {
        try {
            this.mService.boostScreenBrightness(time);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    private final boolean $$robo$$android_os_PowerManager$isScreenBrightnessBoosted() {
        return false;
    }

    private final boolean $$robo$$android_os_PowerManager$isWakeLockLevelSupported(int level) {
        try {
            return this.mService.isWakeLockLevelSupported(level);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    private final boolean $$robo$$android_os_PowerManager$isScreenOn() {
        return this.isInteractive();
    }

    private final boolean $$robo$$android_os_PowerManager$isInteractive() {
        try {
            return this.mService.isInteractive();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_PowerManager$reboot(String reason) {
        try {
            this.mService.reboot(false, reason, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_PowerManager$rebootSafeMode() {
        try {
            this.mService.rebootSafeMode(false, true);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_PowerManager$isPowerSaveMode() {
        try {
            return this.mService.isPowerSaveMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_PowerManager$setPowerSaveMode(boolean mode) {
        try {
            return this.mService.setPowerSaveMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final PowerSaveState $$robo$$android_os_PowerManager$getPowerSaveState(int serviceType) {
        try {
            return this.mService.getPowerSaveState(serviceType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_os_PowerManager$getLocationPowerSaveMode() {
        PowerSaveState powerSaveState = this.getPowerSaveState(1);
        if (!powerSaveState.globalBatterySaverEnabled) {
            return 0;
        }
        return powerSaveState.gpsMode;
    }

    private final boolean $$robo$$android_os_PowerManager$isDeviceIdleMode() {
        try {
            return this.mService.isDeviceIdleMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_PowerManager$isLightDeviceIdleMode() {
        try {
            return this.mService.isLightDeviceIdleMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_PowerManager$isIgnoringBatteryOptimizations(String packageName) {
        PowerManager powerManager = this;
        synchronized (powerManager) {
            if (this.mIDeviceIdleController == null) {
                this.mIDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
            }
        }
        try {
            return this.mIDeviceIdleController.isPowerSaveWhitelistApp(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_os_PowerManager$shutdown(boolean confirm, String reason, boolean wait) {
        try {
            this.mService.shutdown(confirm, reason, wait);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final boolean $$robo$$android_os_PowerManager$isSustainedPerformanceModeSupported() {
        return this.mContext.getResources().getBoolean(17957048);
    }

    private final void $$robo$$android_os_PowerManager$setDozeAfterScreenOff(boolean dozeAfterScreenOf) {
        try {
            this.mService.setDozeAfterScreenOff(dozeAfterScreenOf);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private final int $$robo$$android_os_PowerManager$getLastShutdownReason() {
        try {
            return this.mService.getLastShutdownReason();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void __constructor__(Context context, IPowerManager iPowerManager, Handler handler) {
        this.$$robo$$android_os_PowerManager$__constructor__(context, iPowerManager, handler);
    }

    public PowerManager(Context context, IPowerManager iPowerManager, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_PowerManager$__constructor__(android.content.Context android.os.IPowerManager android.os.Handler ), 0, this, context, iPowerManager, handler);
    }

    public int getMinimumScreenBrightnessSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumScreenBrightnessSetting", $$robo$$android_os_PowerManager$getMinimumScreenBrightnessSetting(), 0, this);
    }

    public int getMaximumScreenBrightnessSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumScreenBrightnessSetting", $$robo$$android_os_PowerManager$getMaximumScreenBrightnessSetting(), 0, this);
    }

    public int getDefaultScreenBrightnessSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultScreenBrightnessSetting", $$robo$$android_os_PowerManager$getDefaultScreenBrightnessSetting(), 0, this);
    }

    public int getMinimumScreenBrightnessForVrSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumScreenBrightnessForVrSetting", $$robo$$android_os_PowerManager$getMinimumScreenBrightnessForVrSetting(), 0, this);
    }

    public int getMaximumScreenBrightnessForVrSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumScreenBrightnessForVrSetting", $$robo$$android_os_PowerManager$getMaximumScreenBrightnessForVrSetting(), 0, this);
    }

    public int getDefaultScreenBrightnessForVrSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultScreenBrightnessForVrSetting", $$robo$$android_os_PowerManager$getDefaultScreenBrightnessForVrSetting(), 0, this);
    }

    public WakeLock newWakeLock(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("newWakeLock", $$robo$$android_os_PowerManager$newWakeLock(int java.lang.String ), 0, this, n, string2);
    }

    public static void validateWakeLockParameters(int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("validateWakeLockParameters", $$robo$$android_os_PowerManager$validateWakeLockParameters(int java.lang.String ), 0, (int)n, (String)string2);
    }

    @Deprecated
    public void userActivity(long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("userActivity", $$robo$$android_os_PowerManager$userActivity(long boolean ), 0, this, l, bl);
    }

    @SystemApi
    public void userActivity(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrap("userActivity", $$robo$$android_os_PowerManager$userActivity(long int int ), 0, this, l, n, n2);
    }

    public void goToSleep(long l) {
        InvokeDynamicSupport.bootstrap("goToSleep", $$robo$$android_os_PowerManager$goToSleep(long ), 0, this, l);
    }

    public void goToSleep(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrap("goToSleep", $$robo$$android_os_PowerManager$goToSleep(long int int ), 0, this, l, n, n2);
    }

    public void wakeUp(long l) {
        InvokeDynamicSupport.bootstrap("wakeUp", $$robo$$android_os_PowerManager$wakeUp(long ), 0, this, l);
    }

    public void wakeUp(long l, String string2) {
        InvokeDynamicSupport.bootstrap("wakeUp", $$robo$$android_os_PowerManager$wakeUp(long java.lang.String ), 0, this, l, string2);
    }

    public void nap(long l) {
        InvokeDynamicSupport.bootstrap("nap", $$robo$$android_os_PowerManager$nap(long ), 0, this, l);
    }

    public void boostScreenBrightness(long l) {
        InvokeDynamicSupport.bootstrap("boostScreenBrightness", $$robo$$android_os_PowerManager$boostScreenBrightness(long ), 0, this, l);
    }

    @SystemApi
    @Deprecated
    public boolean isScreenBrightnessBoosted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScreenBrightnessBoosted", $$robo$$android_os_PowerManager$isScreenBrightnessBoosted(), 0, this);
    }

    public boolean isWakeLockLevelSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWakeLockLevelSupported", $$robo$$android_os_PowerManager$isWakeLockLevelSupported(int ), 0, this, n);
    }

    @Deprecated
    public boolean isScreenOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScreenOn", $$robo$$android_os_PowerManager$isScreenOn(), 0, this);
    }

    public boolean isInteractive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInteractive", $$robo$$android_os_PowerManager$isInteractive(), 0, this);
    }

    public void reboot(String string2) {
        InvokeDynamicSupport.bootstrap("reboot", $$robo$$android_os_PowerManager$reboot(java.lang.String ), 0, this, string2);
    }

    public void rebootSafeMode() {
        InvokeDynamicSupport.bootstrap("rebootSafeMode", $$robo$$android_os_PowerManager$rebootSafeMode(), 0, this);
    }

    public boolean isPowerSaveMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPowerSaveMode", $$robo$$android_os_PowerManager$isPowerSaveMode(), 0, this);
    }

    public boolean setPowerSaveMode(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPowerSaveMode", $$robo$$android_os_PowerManager$setPowerSaveMode(boolean ), 0, this, bl);
    }

    public PowerSaveState getPowerSaveState(int n) {
        return InvokeDynamicSupport.bootstrap("getPowerSaveState", $$robo$$android_os_PowerManager$getPowerSaveState(int ), 0, this, n);
    }

    public int getLocationPowerSaveMode() {
        return (int)InvokeDynamicSupport.bootstrap("getLocationPowerSaveMode", $$robo$$android_os_PowerManager$getLocationPowerSaveMode(), 0, this);
    }

    public boolean isDeviceIdleMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDeviceIdleMode", $$robo$$android_os_PowerManager$isDeviceIdleMode(), 0, this);
    }

    public boolean isLightDeviceIdleMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLightDeviceIdleMode", $$robo$$android_os_PowerManager$isLightDeviceIdleMode(), 0, this);
    }

    public boolean isIgnoringBatteryOptimizations(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isIgnoringBatteryOptimizations", $$robo$$android_os_PowerManager$isIgnoringBatteryOptimizations(java.lang.String ), 0, this, string2);
    }

    public void shutdown(boolean bl, String string2, boolean bl2) {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_os_PowerManager$shutdown(boolean java.lang.String boolean ), 0, this, bl, string2, bl2);
    }

    public boolean isSustainedPerformanceModeSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSustainedPerformanceModeSupported", $$robo$$android_os_PowerManager$isSustainedPerformanceModeSupported(), 0, this);
    }

    public void setDozeAfterScreenOff(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDozeAfterScreenOff", $$robo$$android_os_PowerManager$setDozeAfterScreenOff(boolean ), 0, this, bl);
    }

    public int getLastShutdownReason() {
        return (int)InvokeDynamicSupport.bootstrap("getLastShutdownReason", $$robo$$android_os_PowerManager$getLastShutdownReason(), 0, this);
    }

    public /* synthetic */ PowerManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PowerManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class WakeLock
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mFlags;
        private String mTag;
        private String mPackageName;
        private IBinder mToken;
        private int mInternalCount;
        private int mExternalCount;
        private boolean mRefCounted;
        private boolean mHeld;
        private WorkSource mWorkSource;
        private String mHistoryTag;
        private String mTraceName;
        private Runnable mReleaser;
        /* synthetic */ PowerManager this$0;

        private void $$robo$$android_os_PowerManager_WakeLock$__constructor__(PowerManager this$0, int flags, String tag, String packageName) {
            this.mRefCounted = true;
            this.mReleaser = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ WakeLock this$1;

                private void $$robo$$android_os_PowerManager_WakeLock_1$__constructor__(WakeLock this$1) {
                }

                private final void $$robo$$android_os_PowerManager_WakeLock_1$run() {
                    this.this$1.release(65536);
                }

                private void __constructor__(WakeLock wakeLock) {
                    this.$$robo$$android_os_PowerManager_WakeLock_1$__constructor__(wakeLock);
                }
                {
                    this.this$1 = wakeLock;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_PowerManager_WakeLock_1$__constructor__(android.os.PowerManager$WakeLock ), 0, this, wakeLock);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_PowerManager_WakeLock_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mFlags = flags;
            this.mTag = tag;
            this.mPackageName = packageName;
            this.mToken = new Binder();
            this.mTraceName = "WakeLock (" + this.mTag + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$finalize() throws Throwable {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mHeld) {
                    Log.wtf("PowerManager", "WakeLock finalized while still held: " + this.mTag);
                    Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                    try {
                        this.this$0.mService.releaseWakeLock(this.mToken, 0);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$setReferenceCounted(boolean value) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.mRefCounted = value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$acquire() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$acquire(long timeout) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
                this.this$0.mHandler.postDelayed(this.mReleaser, timeout);
            }
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$acquireLocked() {
            ++this.mInternalCount;
            ++this.mExternalCount;
            if (!this.mRefCounted || this.mInternalCount == 1) {
                this.this$0.mHandler.removeCallbacks(this.mReleaser);
                Trace.asyncTraceBegin(131072L, this.mTraceName, 0);
                try {
                    this.this$0.mService.acquireWakeLock(this.mToken, this.mFlags, this.mTag, this.mPackageName, this.mWorkSource, this.mHistoryTag);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mHeld = true;
            }
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$release() {
            this.release(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$release(int flags) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mInternalCount > 0) {
                    --this.mInternalCount;
                }
                if ((flags & 0x10000) == 0) {
                    --this.mExternalCount;
                }
                if (!this.mRefCounted || this.mInternalCount == 0) {
                    this.this$0.mHandler.removeCallbacks(this.mReleaser);
                    if (this.mHeld) {
                        Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                        try {
                            this.this$0.mService.releaseWakeLock(this.mToken, flags);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                        this.mHeld = false;
                    }
                }
                if (this.mRefCounted && this.mExternalCount < 0) {
                    throw new RuntimeException("WakeLock under-locked " + this.mTag);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_os_PowerManager_WakeLock$isHeld() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$setWorkSource(WorkSource ws) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                boolean changed;
                if (ws != null && ws.isEmpty()) {
                    ws = null;
                }
                if (ws == null) {
                    changed = this.mWorkSource != null;
                    this.mWorkSource = null;
                } else if (this.mWorkSource == null) {
                    changed = true;
                    this.mWorkSource = new WorkSource(ws);
                } else {
                    boolean bl = changed = !this.mWorkSource.equals(ws);
                    if (changed) {
                        this.mWorkSource.set(ws);
                    }
                }
                if (changed && this.mHeld) {
                    try {
                        this.this$0.mService.updateWakeLockWorkSource(this.mToken, this.mWorkSource, this.mHistoryTag);
                    }
                    catch (RemoteException e) {
                        throw e.rethrowFromSystemServer();
                    }
                }
            }
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$setTag(String tag) {
            this.mTag = tag;
        }

        private final String $$robo$$android_os_PowerManager_WakeLock$getTag() {
            return this.mTag;
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$setHistoryTag(String tag) {
            this.mHistoryTag = tag;
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$setUnimportantForLogging(boolean state) {
            this.mFlags = state ? (this.mFlags |= 0x40000000) : (this.mFlags &= 0xBFFFFFFF);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_os_PowerManager_WakeLock$toString() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return "WakeLock{" + Integer.toHexString(System.identityHashCode(this)) + " held=" + this.mHeld + ", refCount=" + this.mInternalCount + "}";
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$writeToProto(ProtoOutputStream proto, long fieldId) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                long token = proto.start(fieldId);
                proto.write(0x10900000001L, this.mTag);
                proto.write(1138166333442L, this.mPackageName);
                proto.write(1133871366147L, this.mHeld);
                proto.write(1120986464260L, this.mInternalCount);
                if (this.mWorkSource != null) {
                    this.mWorkSource.writeToProto(proto, 1146756268037L);
                }
                proto.end(token);
            }
        }

        private final Runnable $$robo$$android_os_PowerManager_WakeLock$wrap(Runnable r) {
            this.acquire();
            return () -> {
                try {
                    r.run();
                }
                finally {
                    this.release();
                }
            };
        }

        private void __constructor__(PowerManager powerManager, int n, String string2, String string3) {
            this.$$robo$$android_os_PowerManager_WakeLock$__constructor__(powerManager, n, string2, string3);
        }

        WakeLock(PowerManager powerManager, int n, String string2, String string3) {
            this.this$0 = powerManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_PowerManager_WakeLock$__constructor__(android.os.PowerManager int java.lang.String java.lang.String ), 0, this, powerManager, n, string2, string3);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_PowerManager_WakeLock$finalize(), 0, this);
        }

        public void setReferenceCounted(boolean bl) {
            InvokeDynamicSupport.bootstrap("setReferenceCounted", $$robo$$android_os_PowerManager_WakeLock$setReferenceCounted(boolean ), 0, this, bl);
        }

        public void acquire() {
            InvokeDynamicSupport.bootstrap("acquire", $$robo$$android_os_PowerManager_WakeLock$acquire(), 0, this);
        }

        public void acquire(long l) {
            InvokeDynamicSupport.bootstrap("acquire", $$robo$$android_os_PowerManager_WakeLock$acquire(long ), 0, this, l);
        }

        private void acquireLocked() {
            InvokeDynamicSupport.bootstrap("acquireLocked", $$robo$$android_os_PowerManager_WakeLock$acquireLocked(), 0, this);
        }

        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_os_PowerManager_WakeLock$release(), 0, this);
        }

        public void release(int n) {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_os_PowerManager_WakeLock$release(int ), 0, this, n);
        }

        public boolean isHeld() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHeld", $$robo$$android_os_PowerManager_WakeLock$isHeld(), 0, this);
        }

        public void setWorkSource(WorkSource workSource) {
            InvokeDynamicSupport.bootstrap("setWorkSource", $$robo$$android_os_PowerManager_WakeLock$setWorkSource(android.os.WorkSource ), 0, this, workSource);
        }

        public void setTag(String string2) {
            InvokeDynamicSupport.bootstrap("setTag", $$robo$$android_os_PowerManager_WakeLock$setTag(java.lang.String ), 0, this, string2);
        }

        public String getTag() {
            return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_os_PowerManager_WakeLock$getTag(), 0, this);
        }

        public void setHistoryTag(String string2) {
            InvokeDynamicSupport.bootstrap("setHistoryTag", $$robo$$android_os_PowerManager_WakeLock$setHistoryTag(java.lang.String ), 0, this, string2);
        }

        public void setUnimportantForLogging(boolean bl) {
            InvokeDynamicSupport.bootstrap("setUnimportantForLogging", $$robo$$android_os_PowerManager_WakeLock$setUnimportantForLogging(boolean ), 0, this, bl);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_PowerManager_WakeLock$toString(), 0, this);
        }

        public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
            InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_os_PowerManager_WakeLock$writeToProto(android.util.proto.ProtoOutputStream long ), 0, this, protoOutputStream, l);
        }

        public Runnable wrap(Runnable runnable) {
            return InvokeDynamicSupport.bootstrap("wrap", $$robo$$android_os_PowerManager_WakeLock$wrap(java.lang.Runnable ), 0, this, runnable);
        }

        public /* synthetic */ WakeLock() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WakeLock)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocationPowerSaveMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceType {
        public static final int NULL = 0;
        public static final int GPS = 1;
        public static final int VIBRATION = 2;
        public static final int ANIMATION = 3;
        public static final int FULL_BACKUP = 4;
        public static final int KEYVALUE_BACKUP = 5;
        public static final int NETWORK_FIREWALL = 6;
        public static final int SCREEN_BRIGHTNESS = 7;
        public static final int SOUND = 8;
        public static final int BATTERY_STATS = 9;
        public static final int DATA_SAVER = 10;
        public static final int AOD = 14;
        public static final int FORCE_ALL_APPS_STANDBY = 11;
        public static final int FORCE_BACKGROUND_CHECK = 12;
        public static final int OPTIONAL_SENSORS = 13;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShutdownReason {
    }
}

