/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import com.android.internal.util.FastPrintWriter;
import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ShellCommand
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "ShellCommand";
    static boolean DEBUG = false;
    private Binder mTarget;
    private FileDescriptor mIn;
    private FileDescriptor mOut;
    private FileDescriptor mErr;
    private String[] mArgs;
    private ShellCallback mShellCallback;
    private ResultReceiver mResultReceiver;
    private String mCmd;
    private int mArgPos;
    private String mCurArgData;
    private FileInputStream mFileIn;
    private FileOutputStream mFileOut;
    private FileOutputStream mFileErr;
    private FastPrintWriter mOutPrintWriter;
    private FastPrintWriter mErrPrintWriter;
    private InputStream mInputStream;

    private void $$robo$$android_os_ShellCommand$__constructor__() {
    }

    private final void $$robo$$android_os_ShellCommand$init(Binder target, FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, int firstArgPos) {
        this.mTarget = target;
        this.mIn = in;
        this.mOut = out;
        this.mErr = err;
        this.mArgs = args;
        this.mShellCallback = callback;
        this.mResultReceiver = null;
        this.mCmd = null;
        this.mArgPos = firstArgPos;
        this.mCurArgData = null;
        this.mFileIn = null;
        this.mFileOut = null;
        this.mFileErr = null;
        this.mOutPrintWriter = null;
        this.mErrPrintWriter = null;
        this.mInputStream = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_os_ShellCommand$exec(Binder target, FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        int start;
        String cmd;
        if (args != null && args.length > 0) {
            cmd = args[0];
            start = 1;
        } else {
            cmd = null;
            start = 0;
        }
        this.init(target, in, out, err, args, callback, start);
        this.mCmd = cmd;
        this.mResultReceiver = resultReceiver;
        int res = -1;
        try {
            res = this.onCommand(this.mCmd);
        }
        catch (SecurityException e) {
            PrintWriter eout = this.getErrPrintWriter();
            eout.println("Security exception: " + e.getMessage());
            eout.println();
            e.printStackTrace(eout);
        }
        catch (Throwable e) {
            PrintWriter eout = this.getErrPrintWriter();
            eout.println();
            eout.println("Exception occurred while executing:");
            e.printStackTrace(eout);
        }
        finally {
            if (this.mOutPrintWriter != null) {
                this.mOutPrintWriter.flush();
            }
            if (this.mErrPrintWriter != null) {
                this.mErrPrintWriter.flush();
            }
            if (this.mResultReceiver != null) {
                this.mResultReceiver.send(res, null);
            }
        }
        return res;
    }

    private final ResultReceiver $$robo$$android_os_ShellCommand$adoptResultReceiver() {
        ResultReceiver rr = this.mResultReceiver;
        this.mResultReceiver = null;
        return rr;
    }

    private final FileDescriptor $$robo$$android_os_ShellCommand$getOutFileDescriptor() {
        return this.mOut;
    }

    private final OutputStream $$robo$$android_os_ShellCommand$getRawOutputStream() {
        if (this.mFileOut == null) {
            this.mFileOut = new FileOutputStream(this.mOut);
        }
        return this.mFileOut;
    }

    private final PrintWriter $$robo$$android_os_ShellCommand$getOutPrintWriter() {
        if (this.mOutPrintWriter == null) {
            this.mOutPrintWriter = new FastPrintWriter(this.getRawOutputStream());
        }
        return this.mOutPrintWriter;
    }

    private final FileDescriptor $$robo$$android_os_ShellCommand$getErrFileDescriptor() {
        return this.mErr;
    }

    private final OutputStream $$robo$$android_os_ShellCommand$getRawErrorStream() {
        if (this.mFileErr == null) {
            this.mFileErr = new FileOutputStream(this.mErr);
        }
        return this.mFileErr;
    }

    private final PrintWriter $$robo$$android_os_ShellCommand$getErrPrintWriter() {
        if (this.mErr == null) {
            return this.getOutPrintWriter();
        }
        if (this.mErrPrintWriter == null) {
            this.mErrPrintWriter = new FastPrintWriter(this.getRawErrorStream());
        }
        return this.mErrPrintWriter;
    }

    private final FileDescriptor $$robo$$android_os_ShellCommand$getInFileDescriptor() {
        return this.mIn;
    }

    private final InputStream $$robo$$android_os_ShellCommand$getRawInputStream() {
        if (this.mFileIn == null) {
            this.mFileIn = new FileInputStream(this.mIn);
        }
        return this.mFileIn;
    }

    private final InputStream $$robo$$android_os_ShellCommand$getBufferedInputStream() {
        if (this.mInputStream == null) {
            this.mInputStream = new BufferedInputStream(this.getRawInputStream());
        }
        return this.mInputStream;
    }

    private final ParcelFileDescriptor $$robo$$android_os_ShellCommand$openFileForSystem(String path, String mode) {
        try {
            ParcelFileDescriptor pfd = this.getShellCallback().openFile(path, "u:r:system_server:s0", mode);
            if (pfd != null) {
                return pfd;
            }
        }
        catch (RuntimeException e) {
            this.getErrPrintWriter().println("Failure opening file: " + e.getMessage());
        }
        this.getErrPrintWriter().println("Error: Unable to open file: " + path);
        this.getErrPrintWriter().println("Consider using a file under /data/local/tmp/");
        return null;
    }

    private final String $$robo$$android_os_ShellCommand$getNextOption() {
        if (this.mCurArgData != null) {
            String prev = this.mArgs[this.mArgPos - 1];
            throw new IllegalArgumentException("No argument expected after \"" + prev + "\"");
        }
        if (this.mArgPos >= this.mArgs.length) {
            return null;
        }
        String arg = this.mArgs[this.mArgPos];
        if (!arg.startsWith("-")) {
            return null;
        }
        ++this.mArgPos;
        if (arg.equals("--")) {
            return null;
        }
        if (arg.length() > 1 && arg.charAt(1) != '-') {
            if (arg.length() > 2) {
                this.mCurArgData = arg.substring(2);
                return arg.substring(0, 2);
            }
            this.mCurArgData = null;
            return arg;
        }
        this.mCurArgData = null;
        return arg;
    }

    private final String $$robo$$android_os_ShellCommand$getNextArg() {
        if (this.mCurArgData != null) {
            String arg = this.mCurArgData;
            this.mCurArgData = null;
            return arg;
        }
        if (this.mArgPos < this.mArgs.length) {
            return this.mArgs[this.mArgPos++];
        }
        return null;
    }

    private final String $$robo$$android_os_ShellCommand$peekNextArg() {
        if (this.mCurArgData != null) {
            return this.mCurArgData;
        }
        if (this.mArgPos < this.mArgs.length) {
            return this.mArgs[this.mArgPos];
        }
        return null;
    }

    private final String $$robo$$android_os_ShellCommand$getNextArgRequired() {
        String arg = this.getNextArg();
        if (arg == null) {
            String prev = this.mArgs[this.mArgPos - 1];
            throw new IllegalArgumentException("Argument expected after \"" + prev + "\"");
        }
        return arg;
    }

    private final ShellCallback $$robo$$android_os_ShellCommand$getShellCallback() {
        return this.mShellCallback;
    }

    private final int $$robo$$android_os_ShellCommand$handleDefaultCommands(String cmd) {
        if ("dump".equals(cmd)) {
            String[] newArgs = new String[this.mArgs.length - 1];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArgs, (int)1, (Object)newArgs, (int)0, (int)(this.mArgs.length - 1));
            this.mTarget.doDump(this.mOut, this.getOutPrintWriter(), newArgs);
            return 0;
        }
        if (cmd == null || "help".equals(cmd) || "-h".equals(cmd)) {
            this.onHelp();
        } else {
            this.getOutPrintWriter().println("Unknown command: " + cmd);
        }
        return -1;
    }

    public abstract int onCommand(String var1);

    public abstract void onHelp();

    private void __constructor__() {
        this.$$robo$$android_os_ShellCommand$__constructor__();
    }

    public ShellCommand() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ShellCommand$__constructor__(), 0, this);
    }

    public void init(Binder binder, FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, FileDescriptor fileDescriptor3, String[] stringArray, ShellCallback shellCallback, int n) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_os_ShellCommand$init(android.os.Binder java.io.FileDescriptor java.io.FileDescriptor java.io.FileDescriptor java.lang.String[] android.os.ShellCallback int ), 0, this, binder, fileDescriptor, fileDescriptor2, fileDescriptor3, stringArray, shellCallback, n);
    }

    public int exec(Binder binder, FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, FileDescriptor fileDescriptor3, String[] stringArray, ShellCallback shellCallback, ResultReceiver resultReceiver) {
        return (int)InvokeDynamicSupport.bootstrap("exec", $$robo$$android_os_ShellCommand$exec(android.os.Binder java.io.FileDescriptor java.io.FileDescriptor java.io.FileDescriptor java.lang.String[] android.os.ShellCallback android.os.ResultReceiver ), 0, this, binder, fileDescriptor, fileDescriptor2, fileDescriptor3, stringArray, shellCallback, resultReceiver);
    }

    public ResultReceiver adoptResultReceiver() {
        return InvokeDynamicSupport.bootstrap("adoptResultReceiver", $$robo$$android_os_ShellCommand$adoptResultReceiver(), 0, this);
    }

    public FileDescriptor getOutFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getOutFileDescriptor", $$robo$$android_os_ShellCommand$getOutFileDescriptor(), 0, this);
    }

    public OutputStream getRawOutputStream() {
        return InvokeDynamicSupport.bootstrap("getRawOutputStream", $$robo$$android_os_ShellCommand$getRawOutputStream(), 0, this);
    }

    public PrintWriter getOutPrintWriter() {
        return InvokeDynamicSupport.bootstrap("getOutPrintWriter", $$robo$$android_os_ShellCommand$getOutPrintWriter(), 0, this);
    }

    public FileDescriptor getErrFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getErrFileDescriptor", $$robo$$android_os_ShellCommand$getErrFileDescriptor(), 0, this);
    }

    public OutputStream getRawErrorStream() {
        return InvokeDynamicSupport.bootstrap("getRawErrorStream", $$robo$$android_os_ShellCommand$getRawErrorStream(), 0, this);
    }

    public PrintWriter getErrPrintWriter() {
        return InvokeDynamicSupport.bootstrap("getErrPrintWriter", $$robo$$android_os_ShellCommand$getErrPrintWriter(), 0, this);
    }

    public FileDescriptor getInFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getInFileDescriptor", $$robo$$android_os_ShellCommand$getInFileDescriptor(), 0, this);
    }

    public InputStream getRawInputStream() {
        return InvokeDynamicSupport.bootstrap("getRawInputStream", $$robo$$android_os_ShellCommand$getRawInputStream(), 0, this);
    }

    public InputStream getBufferedInputStream() {
        return InvokeDynamicSupport.bootstrap("getBufferedInputStream", $$robo$$android_os_ShellCommand$getBufferedInputStream(), 0, this);
    }

    public ParcelFileDescriptor openFileForSystem(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("openFileForSystem", $$robo$$android_os_ShellCommand$openFileForSystem(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String getNextOption() {
        return InvokeDynamicSupport.bootstrap("getNextOption", $$robo$$android_os_ShellCommand$getNextOption(), 0, this);
    }

    public String getNextArg() {
        return InvokeDynamicSupport.bootstrap("getNextArg", $$robo$$android_os_ShellCommand$getNextArg(), 0, this);
    }

    public String peekNextArg() {
        return InvokeDynamicSupport.bootstrap("peekNextArg", $$robo$$android_os_ShellCommand$peekNextArg(), 0, this);
    }

    public String getNextArgRequired() {
        return InvokeDynamicSupport.bootstrap("getNextArgRequired", $$robo$$android_os_ShellCommand$getNextArgRequired(), 0, this);
    }

    public ShellCallback getShellCallback() {
        return InvokeDynamicSupport.bootstrap("getShellCallback", $$robo$$android_os_ShellCommand$getShellCallback(), 0, this);
    }

    public int handleDefaultCommands(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("handleDefaultCommands", $$robo$$android_os_ShellCommand$handleDefaultCommands(java.lang.String ), 0, this, string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShellCommand)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

