/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.app.ActivityThread;
import android.app.IActivityManager;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.DeadObjectException;
import android.os.FileUriExposedException;
import android.os.Handler;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.NetworkOnMainThreadException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.strictmode.CleartextNetworkViolation;
import android.os.strictmode.ContentUriWithoutPermissionViolation;
import android.os.strictmode.CustomViolation;
import android.os.strictmode.DiskReadViolation;
import android.os.strictmode.DiskWriteViolation;
import android.os.strictmode.FileUriExposedViolation;
import android.os.strictmode.InstanceCountViolation;
import android.os.strictmode.IntentReceiverLeakedViolation;
import android.os.strictmode.LeakedClosableViolation;
import android.os.strictmode.NetworkViolation;
import android.os.strictmode.NonSdkApiUsedViolation;
import android.os.strictmode.ResourceMismatchViolation;
import android.os.strictmode.ServiceConnectionLeakedViolation;
import android.os.strictmode.SqliteObjectLeakedViolation;
import android.os.strictmode.UnbufferedIoViolation;
import android.os.strictmode.UntaggedSocketViolation;
import android.os.strictmode.Violation;
import android.os.strictmode.WebViewMethodCalledOnWrongThreadViolation;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Printer;
import android.util.Singleton;
import android.view.IWindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.RuntimeInit;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.HexDump;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import dalvik.system.VMDebug;
import dalvik.system.VMRuntime;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class StrictMode
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "StrictMode";
    private static boolean LOG_V;
    public static String DISABLE_PROPERTY = "persist.sys.strictmode.disable";
    public static String VISUAL_PROPERTY = "persist.sys.strictmode.visual";
    private static String CLEARTEXT_PROPERTY = "persist.sys.strictmode.clear";
    private static boolean DISABLE = false;
    private static long MIN_VM_INTERVAL_MS = 1000L;
    private static long MIN_LOG_INTERVAL_MS = 1000L;
    private static long MIN_DIALOG_INTERVAL_MS = 30000L;
    private static int MAX_SPAN_TAGS = 20;
    private static int MAX_OFFENSES_PER_LOOP = 10;
    public static int DETECT_DISK_WRITE = 1;
    public static int DETECT_DISK_READ = 2;
    public static int DETECT_NETWORK = 4;
    public static int DETECT_CUSTOM = 8;
    public static int DETECT_RESOURCE_MISMATCH = 16;
    public static int DETECT_UNBUFFERED_IO = 32;
    private static int ALL_THREAD_DETECT_BITS = 63;
    public static int DETECT_VM_CURSOR_LEAKS = 256;
    public static int DETECT_VM_CLOSABLE_LEAKS = 512;
    public static int DETECT_VM_ACTIVITY_LEAKS = 1024;
    public static int DETECT_VM_INSTANCE_LEAKS = 2048;
    public static int DETECT_VM_REGISTRATION_LEAKS = 4096;
    public static int DETECT_VM_FILE_URI_EXPOSURE = 8192;
    public static int DETECT_VM_CLEARTEXT_NETWORK = 16384;
    public static int DETECT_VM_CONTENT_URI_WITHOUT_PERMISSION = 32768;
    public static int DETECT_VM_UNTAGGED_SOCKET = Integer.MIN_VALUE;
    public static int DETECT_VM_NON_SDK_API_USAGE = 0x40000000;
    private static int ALL_VM_DETECT_BITS = -1073676544;
    public static int PENALTY_LOG = 65536;
    public static int PENALTY_DIALOG = 131072;
    public static int PENALTY_DEATH = 262144;
    public static int PENALTY_FLASH = 0x100000;
    public static int PENALTY_DROPBOX = 0x200000;
    public static int PENALTY_GATHER = 0x400000;
    public static int PENALTY_DEATH_ON_NETWORK = 0x1000000;
    public static int PENALTY_DEATH_ON_CLEARTEXT_NETWORK = 0x2000000;
    public static int PENALTY_DEATH_ON_FILE_URI_EXPOSURE = 0x4000000;
    private static int THREAD_PENALTY_MASK = 0x1770000;
    private static int VM_PENALTY_MASK = 103088128;
    public static int NETWORK_POLICY_ACCEPT = 0;
    public static int NETWORK_POLICY_LOG = 1;
    public static int NETWORK_POLICY_REJECT = 2;
    private static HashMap<Class, Integer> EMPTY_CLASS_LIMIT_MAP;
    private static volatile VmPolicy sVmPolicy;
    private static ViolationLogger LOGCAT_LOGGER;
    private static volatile ViolationLogger sLogger;
    private static ThreadLocal<OnThreadViolationListener> sThreadViolationListener;
    private static ThreadLocal<Executor> sThreadViolationExecutor;
    private static AtomicInteger sDropboxCallsInFlight;
    private static Consumer<String> sNonSdkApiUsageConsumer;
    private static ThreadLocal<ArrayList<ViolationInfo>> gatheredViolations;
    private static ThreadLocal<ArrayList<ViolationInfo>> violationsBeingTimed;
    private static ThreadLocal<Handler> THREAD_HANDLER;
    private static ThreadLocal<AndroidBlockGuardPolicy> THREAD_ANDROID_POLICY;
    private static long sLastInstanceCountCheckMillis;
    private static boolean sIsIdlerRegistered;
    private static MessageQueue.IdleHandler sProcessIdleHandler;
    public static String CLEARTEXT_DETECTED_MSG = "Detected cleartext network traffic from UID ";
    private static HashMap<Integer, Long> sLastVmViolationTime;
    private static Span NO_OP_SPAN;
    private static ThreadLocal<ThreadSpanState> sThisThreadSpanState;
    private static Singleton<IWindowManager> sWindowManager;
    @GuardedBy(value="StrictMode.class")
    private static HashMap<Class, Integer> sExpectedActivityInstanceCount;

    private static final void $$robo$$android_os_StrictMode$setViolationLogger(ViolationLogger listener) {
        if (listener == null) {
            listener = LOGCAT_LOGGER;
        }
        sLogger = listener;
    }

    private void $$robo$$android_os_StrictMode$__constructor__() {
    }

    private static final void $$robo$$android_os_StrictMode$setThreadPolicy(ThreadPolicy policy) {
        StrictMode.setThreadPolicyMask(policy.mask);
        sThreadViolationListener.set(policy.mListener);
        sThreadViolationExecutor.set(policy.mCallbackExecutor);
    }

    private static final void $$robo$$android_os_StrictMode$setThreadPolicyMask(int policyMask) {
        StrictMode.setBlockGuardPolicy(policyMask);
        Binder.setThreadStrictModePolicy(policyMask);
    }

    private static final void $$robo$$android_os_StrictMode$setBlockGuardPolicy(int policyMask) {
        AndroidBlockGuardPolicy androidPolicy;
        if (policyMask == 0) {
            BlockGuard.setThreadPolicy(BlockGuard.LAX_POLICY);
            return;
        }
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (policy instanceof AndroidBlockGuardPolicy) {
            androidPolicy = (AndroidBlockGuardPolicy)policy;
        } else {
            androidPolicy = THREAD_ANDROID_POLICY.get();
            BlockGuard.setThreadPolicy(androidPolicy);
        }
        androidPolicy.setPolicyMask(policyMask);
    }

    private static final void $$robo$$android_os_StrictMode$setCloseGuardEnabled(boolean enabled) {
        if (!(CloseGuard.getReporter() instanceof AndroidCloseGuardReporter)) {
            CloseGuard.setReporter(new AndroidCloseGuardReporter());
        }
        CloseGuard.setEnabled(enabled);
    }

    private static final int $$robo$$android_os_StrictMode$getThreadPolicyMask() {
        return BlockGuard.getThreadPolicy().getPolicyMask();
    }

    private static final ThreadPolicy $$robo$$android_os_StrictMode$getThreadPolicy() {
        return new ThreadPolicy(StrictMode.getThreadPolicyMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    private static final ThreadPolicy $$robo$$android_os_StrictMode$allowThreadDiskWrites() {
        return new ThreadPolicy(StrictMode.allowThreadDiskWritesMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    private static final int $$robo$$android_os_StrictMode$allowThreadDiskWritesMask() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFC;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return oldPolicyMask;
    }

    private static final ThreadPolicy $$robo$$android_os_StrictMode$allowThreadDiskReads() {
        return new ThreadPolicy(StrictMode.allowThreadDiskReadsMask(), sThreadViolationListener.get(), sThreadViolationExecutor.get());
    }

    private static final int $$robo$$android_os_StrictMode$allowThreadDiskReadsMask() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFD;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return oldPolicyMask;
    }

    private static final ThreadPolicy $$robo$$android_os_StrictMode$allowThreadViolations() {
        ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        StrictMode.setThreadPolicyMask(0);
        return oldPolicy;
    }

    private static final VmPolicy $$robo$$android_os_StrictMode$allowVmViolations() {
        VmPolicy oldPolicy = StrictMode.getVmPolicy();
        sVmPolicy = VmPolicy.LAX;
        return oldPolicy;
    }

    private static final boolean $$robo$$android_os_StrictMode$isBundledSystemApp(ApplicationInfo ai) {
        if (ai == null || ai.packageName == null) {
            return true;
        }
        if (ai.isSystemApp()) {
            if (ai.packageName.equals("com.android.vending") || ai.packageName.equals("com.android.chrome")) {
                return false;
            }
            if (ai.packageName.equals("com.android.phone")) {
                return false;
            }
            if (ai.packageName.equals("android") || ai.packageName.startsWith("android.") || ai.packageName.startsWith("com.android.")) {
                return true;
            }
        }
        return false;
    }

    private static final void $$robo$$android_os_StrictMode$initThreadDefaults(ApplicationInfo ai) {
        int targetSdkVersion;
        ThreadPolicy.Builder builder = new ThreadPolicy.Builder();
        int n = targetSdkVersion = ai != null ? ai.targetSdkVersion : 10000;
        if (targetSdkVersion >= 11) {
            builder.detectNetwork();
            builder.penaltyDeathOnNetwork();
        }
        if (!Build.IS_USER && !SystemProperties.getBoolean("persist.sys.strictmode.disable", false)) {
            if (Build.IS_USERDEBUG) {
                if (StrictMode.isBundledSystemApp(ai)) {
                    builder.detectAll();
                    builder.penaltyDropBox();
                    if (SystemProperties.getBoolean("persist.sys.strictmode.visual", false)) {
                        builder.penaltyFlashScreen();
                    }
                }
            } else if (Build.IS_ENG && StrictMode.isBundledSystemApp(ai)) {
                builder.detectAll();
                builder.penaltyDropBox();
                builder.penaltyLog();
                builder.penaltyFlashScreen();
            }
        }
        StrictMode.setThreadPolicy(builder.build());
    }

    private static final void $$robo$$android_os_StrictMode$initVmDefaults(ApplicationInfo ai) {
        int targetSdkVersion;
        VmPolicy.Builder builder = new VmPolicy.Builder();
        int n = targetSdkVersion = ai != null ? ai.targetSdkVersion : 10000;
        if (targetSdkVersion >= 24) {
            builder.detectFileUriExposure();
            builder.penaltyDeathOnFileUriExposure();
        }
        if (!Build.IS_USER && !SystemProperties.getBoolean("persist.sys.strictmode.disable", false)) {
            if (Build.IS_USERDEBUG) {
                if (StrictMode.isBundledSystemApp(ai)) {
                    builder.detectAll();
                    builder.permitActivityLeaks();
                    builder.penaltyDropBox();
                }
            } else if (Build.IS_ENG && StrictMode.isBundledSystemApp(ai)) {
                builder.detectAll();
                builder.penaltyDropBox();
                builder.penaltyLog();
            }
        }
        StrictMode.setVmPolicy(builder.build());
    }

    private static final void $$robo$$android_os_StrictMode$enableDeathOnFileUriExposure() {
        sVmPolicy = new VmPolicy(StrictMode.sVmPolicy.mask | 0x2000 | 0x4000000, StrictMode.sVmPolicy.classInstanceLimit, StrictMode.sVmPolicy.mListener, StrictMode.sVmPolicy.mCallbackExecutor);
    }

    private static final void $$robo$$android_os_StrictMode$disableDeathOnFileUriExposure() {
        sVmPolicy = new VmPolicy(StrictMode.sVmPolicy.mask & 0xFBFFDFFF, StrictMode.sVmPolicy.classInstanceLimit, StrictMode.sVmPolicy.mListener, StrictMode.sVmPolicy.mCallbackExecutor);
    }

    private static final int $$robo$$android_os_StrictMode$parsePolicyFromMessage(String message) {
        if (message == null || !message.startsWith("policy=")) {
            return 0;
        }
        int spaceIndex = message.indexOf(32);
        if (spaceIndex == -1) {
            return 0;
        }
        String policyString = message.substring(7, spaceIndex);
        try {
            return Integer.parseInt(policyString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static final boolean $$robo$$android_os_StrictMode$tooManyViolationsThisLoop() {
        return violationsBeingTimed.get().size() >= 10;
    }

    private static final void $$robo$$android_os_StrictMode$dropboxViolationAsync(int violationMaskSubset, ViolationInfo info) {
        int outstanding = sDropboxCallsInFlight.incrementAndGet();
        if (outstanding > 20) {
            sDropboxCallsInFlight.decrementAndGet();
            return;
        }
        if (LOG_V) {
            Log.d("StrictMode", "Dropboxing async; in-flight=" + outstanding);
        }
        BackgroundThread.getHandler().post(() -> {
            StrictMode.handleApplicationStrictModeViolation(violationMaskSubset, info);
            int outstandingInner = sDropboxCallsInFlight.decrementAndGet();
            if (LOG_V) {
                Log.d("StrictMode", "Dropbox complete; in-flight=" + outstandingInner);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$handleApplicationStrictModeViolation(int violationMaskSubset, ViolationInfo info) {
        int oldMask = StrictMode.getThreadPolicyMask();
        try {
            StrictMode.setThreadPolicyMask(0);
            IActivityManager am = ActivityManager.getService();
            if (am == null) {
                Log.w("StrictMode", "No activity manager; failed to Dropbox violation.");
            } else {
                am.handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
            }
        }
        catch (RemoteException e) {
            if (e instanceof DeadObjectException) {
            } else {
                Log.e("StrictMode", "RemoteException handling StrictMode violation", e);
            }
        }
        finally {
            StrictMode.setThreadPolicyMask(oldMask);
        }
    }

    private static final boolean $$robo$$android_os_StrictMode$hasGatheredViolations() {
        return gatheredViolations.get() != null;
    }

    private static final void $$robo$$android_os_StrictMode$clearGatheredViolations() {
        gatheredViolations.set(null);
    }

    private static final void $$robo$$android_os_StrictMode$conditionallyCheckInstanceCounts() {
        VmPolicy policy = StrictMode.getVmPolicy();
        int policySize = policy.classInstanceLimit.size();
        if (policySize == 0) {
            return;
        }
        System.gc();
        System.runFinalization();
        System.gc();
        Class[] classes = policy.classInstanceLimit.keySet().toArray(new Class[policySize]);
        long[] instanceCounts = VMDebug.countInstancesOfClasses(classes, false);
        for (int i = 0; i < classes.length; ++i) {
            long instances = instanceCounts[i];
            Class klass = classes[i];
            int limit = policy.classInstanceLimit.get(klass);
            if (instances <= (long)limit) continue;
            StrictMode.onVmPolicyViolation(new InstanceCountViolation(klass, instances, limit));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$setVmPolicy(VmPolicy policy) {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            INetworkManagementService netd;
            sVmPolicy = policy;
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
            Looper looper = Looper.getMainLooper();
            if (looper != null) {
                MessageQueue mq = looper.mQueue;
                if (policy.classInstanceLimit.size() == 0 || (StrictMode.sVmPolicy.mask & 0x6250000) == 0) {
                    mq.removeIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = false;
                } else if (!sIsIdlerRegistered) {
                    mq.addIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = true;
                }
            }
            int networkPolicy = 0;
            if ((StrictMode.sVmPolicy.mask & 0x4000) != 0) {
                networkPolicy = (StrictMode.sVmPolicy.mask & 0x40000) != 0 || (StrictMode.sVmPolicy.mask & 0x2000000) != 0 ? 2 : 1;
            }
            if ((netd = INetworkManagementService.Stub.asInterface(ServiceManager.getService("network_management"))) != null) {
                try {
                    netd.setUidCleartextNetworkPolicy(Process.myUid(), networkPolicy);
                }
                catch (RemoteException remoteException) {}
            } else if (networkPolicy != 0) {
                Log.w("StrictMode", "Dropping requested network policy due to missing service!");
            }
            if ((StrictMode.sVmPolicy.mask & 0x40000000) != 0) {
                VMRuntime.setNonSdkApiUsageConsumer(sNonSdkApiUsageConsumer);
                VMRuntime.setDedupeHiddenApiWarnings(false);
            } else {
                VMRuntime.setNonSdkApiUsageConsumer(null);
                VMRuntime.setDedupeHiddenApiWarnings(true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final VmPolicy $$robo$$android_os_StrictMode$getVmPolicy() {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVmPolicy;
        }
    }

    private static final void $$robo$$android_os_StrictMode$enableDefaults() {
        StrictMode.setThreadPolicy(new ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy(new VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    private static final boolean $$robo$$android_os_StrictMode$vmSqliteObjectLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x100) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmClosableObjectLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x200) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmRegistrationLeaksEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x1000) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmFileUriExposureEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x2000) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmCleartextNetworkEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x4000) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmContentUriWithoutPermissionEnabled() {
        return (StrictMode.sVmPolicy.mask & 0x8000) != 0;
    }

    private static final boolean $$robo$$android_os_StrictMode$vmUntaggedSocketEnabled() {
        return (StrictMode.sVmPolicy.mask & Integer.MIN_VALUE) != 0;
    }

    private static final void $$robo$$android_os_StrictMode$onSqliteObjectLeaked(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(new SqliteObjectLeakedViolation(message, originStack));
    }

    private static final void $$robo$$android_os_StrictMode$onWebViewMethodCalledOnWrongThread(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new WebViewMethodCalledOnWrongThreadViolation(originStack));
    }

    private static final void $$robo$$android_os_StrictMode$onIntentReceiverLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new IntentReceiverLeakedViolation(originStack));
    }

    private static final void $$robo$$android_os_StrictMode$onServiceConnectionLeaked(Throwable originStack) {
        StrictMode.onVmPolicyViolation(new ServiceConnectionLeakedViolation(originStack));
    }

    private static final void $$robo$$android_os_StrictMode$onFileUriExposed(Uri uri, String location) {
        String message = uri + " exposed beyond app through " + location;
        if ((StrictMode.sVmPolicy.mask & 0x4000000) != 0) {
            throw new FileUriExposedException(message);
        }
        StrictMode.onVmPolicyViolation(new FileUriExposedViolation(message));
    }

    private static final void $$robo$$android_os_StrictMode$onContentUriWithoutPermission(Uri uri, String location) {
        StrictMode.onVmPolicyViolation(new ContentUriWithoutPermissionViolation(uri, location));
    }

    private static final void $$robo$$android_os_StrictMode$onCleartextNetworkDetected(byte[] firstPacket) {
        byte[] rawAddr = null;
        if (firstPacket != null) {
            if (firstPacket.length >= 20 && (firstPacket[0] & 0xF0) == 64) {
                rawAddr = new byte[4];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])firstPacket, (int)16, (byte[])rawAddr, (int)0, (int)4);
            } else if (firstPacket.length >= 40 && (firstPacket[0] & 0xF0) == 96) {
                rawAddr = new byte[16];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])firstPacket, (int)24, (byte[])rawAddr, (int)0, (int)16);
            }
        }
        int uid = Process.myUid();
        String msg = "Detected cleartext network traffic from UID " + uid;
        if (rawAddr != null) {
            try {
                msg = msg + " to " + InetAddress.getByAddress(rawAddr);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        msg = msg + HexDump.dumpHexString(firstPacket).trim() + " ";
        boolean forceDeath = (StrictMode.sVmPolicy.mask & 0x2000000) != 0;
        StrictMode.onVmPolicyViolation(new CleartextNetworkViolation(msg), forceDeath);
    }

    private static final void $$robo$$android_os_StrictMode$onUntaggedSocket() {
        StrictMode.onVmPolicyViolation(new UntaggedSocketViolation());
    }

    private static final void $$robo$$android_os_StrictMode$onVmPolicyViolation(Violation originStack) {
        StrictMode.onVmPolicyViolation(originStack, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$onVmPolicyViolation(Violation violation, boolean forceDeath) {
        boolean penaltyDropbox = (StrictMode.sVmPolicy.mask & 0x200000) != 0;
        boolean penaltyDeath = (StrictMode.sVmPolicy.mask & 0x40000) != 0 || forceDeath;
        boolean penaltyLog = (StrictMode.sVmPolicy.mask & 0x10000) != 0;
        ViolationInfo info = new ViolationInfo(violation, StrictMode.sVmPolicy.mask);
        info.numAnimationsRunning = 0;
        info.tags = null;
        info.broadcastIntentAction = null;
        Integer fingerprint = info.hashCode();
        long now = SystemClock.uptimeMillis();
        long timeSinceLastViolationMillis = Long.MAX_VALUE;
        HashMap<Integer, Long> hashMap = sLastVmViolationTime;
        synchronized (hashMap) {
            if (sLastVmViolationTime.containsKey(fingerprint)) {
                long lastViolationTime = sLastVmViolationTime.get(fingerprint);
                timeSinceLastViolationMillis = now - lastViolationTime;
            }
            if (timeSinceLastViolationMillis > 1000L) {
                sLastVmViolationTime.put(fingerprint, now);
            }
        }
        if (timeSinceLastViolationMillis <= 1000L) {
            return;
        }
        if (penaltyLog && sLogger != null && timeSinceLastViolationMillis > 1000L) {
            sLogger.log(info);
        }
        int violationMaskSubset = 0x200000 | 0xC000FF00 & StrictMode.sVmPolicy.mask;
        if (penaltyDropbox) {
            if (penaltyDeath) {
                StrictMode.handleApplicationStrictModeViolation(violationMaskSubset, info);
            } else {
                StrictMode.dropboxViolationAsync(violationMaskSubset, info);
            }
        }
        if (penaltyDeath) {
            System.err.println("StrictMode VmPolicy violation with POLICY_DEATH; shutting down.");
            Process.killProcess(Process.myPid());
            System.exit(10);
        }
        if (StrictMode.sVmPolicy.mListener != null && StrictMode.sVmPolicy.mCallbackExecutor != null) {
            OnVmViolationListener listener = StrictMode.sVmPolicy.mListener;
            try {
                StrictMode.sVmPolicy.mCallbackExecutor.execute(() -> {
                    VmPolicy oldPolicy = StrictMode.allowVmViolations();
                    try {
                        listener.onVmViolation(violation);
                    }
                    finally {
                        StrictMode.setVmPolicy(oldPolicy);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                Log.e("StrictMode", "VmPolicy penaltyCallback failed", e);
            }
        }
    }

    private static final void $$robo$$android_os_StrictMode$writeGatheredViolationsToParcel(Parcel p) {
        ArrayList<ViolationInfo> violations = gatheredViolations.get();
        if (violations == null) {
            p.writeInt(0);
        } else {
            int size = Math.min(violations.size(), 3);
            p.writeInt(size);
            for (int i = 0; i < size; ++i) {
                violations.get(i).writeToParcel(p, 0);
            }
        }
        gatheredViolations.set(null);
    }

    private static final void $$robo$$android_os_StrictMode$readAndHandleBinderCallViolations(Parcel p) {
        Throwable localCallSite = new Throwable();
        int policyMask = StrictMode.getThreadPolicyMask();
        boolean currentlyGathering = (policyMask & 0x400000) != 0;
        int size = p.readInt();
        for (int i = 0; i < size; ++i) {
            ViolationInfo info = new ViolationInfo(p, !currentlyGathering);
            info.addLocalStack(localCallSite);
            BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
            if (!(policy instanceof AndroidBlockGuardPolicy)) continue;
            ((AndroidBlockGuardPolicy)policy).handleViolationWithTimingAttempt(info);
        }
    }

    private static final void $$robo$$android_os_StrictMode$onBinderStrictModePolicyChange(int newPolicy) {
        StrictMode.setBlockGuardPolicy(newPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Span $$robo$$android_os_StrictMode$enterCriticalSpan(String name) {
        if (Build.IS_USER) {
            return NO_OP_SPAN;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        ThreadSpanState state = sThisThreadSpanState.get();
        Span span = null;
        ThreadSpanState threadSpanState = state;
        synchronized (threadSpanState) {
            if (state.mFreeListHead != null) {
                span = state.mFreeListHead;
                state.mFreeListHead = span.mNext;
                --state.mFreeListSize;
            } else {
                span = new Span(state);
            }
            span.mName = name;
            span.mCreateMillis = SystemClock.uptimeMillis();
            span.mNext = state.mActiveHead;
            span.mPrev = null;
            state.mActiveHead = span;
            ++state.mActiveSize;
            if (span.mNext != null) {
                span.mNext.mPrev = span;
            }
            if (LOG_V) {
                Log.d("StrictMode", "Span enter=" + name + "; size=" + state.mActiveSize);
            }
        }
        return span;
    }

    private static final void $$robo$$android_os_StrictMode$noteSlowCall(String name) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onCustomSlowCall(name);
    }

    private static final void $$robo$$android_os_StrictMode$noteResourceMismatch(Object tag) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onResourceMismatch(tag);
    }

    private static final void $$robo$$android_os_StrictMode$noteUnbufferedIO() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onUnbufferedIO();
    }

    private static final void $$robo$$android_os_StrictMode$noteDiskRead() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onReadFromDisk();
    }

    private static final void $$robo$$android_os_StrictMode$noteDiskWrite() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        policy.onWriteToDisk();
    }

    private static final Object $$robo$$android_os_StrictMode$trackActivity(Object instance) {
        return new InstanceTracker(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$incrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            if ((StrictMode.sVmPolicy.mask & 0x400) == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            Integer newExpected = expected == null ? 1 : expected + 1;
            sExpectedActivityInstanceCount.put(klass, newExpected);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_StrictMode$decrementExpectedActivityCount(Class klass) {
        if (klass == null) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            int newExpected;
            if ((StrictMode.sVmPolicy.mask & 0x400) == 0) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            int n = newExpected = expected == null || expected == 0 ? 0 : expected - 1;
            if (newExpected == 0) {
                sExpectedActivityInstanceCount.remove(klass);
            } else {
                sExpectedActivityInstanceCount.put(klass, newExpected);
            }
            int limit = newExpected + 1;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            int actual = InstanceTracker.getInstanceCount(klass);
            if (actual <= limit) {
                return;
            }
            System.gc();
            System.runFinalization();
            System.gc();
            long instances = VMDebug.countInstancesOfClass(klass, false);
            if (instances > (long)limit) {
                StrictMode.onVmPolicyViolation(new InstanceCountViolation(klass, instances, limit));
            }
            return;
        }
    }

    static void __staticInitializer__() {
        LOG_V = Log.isLoggable("StrictMode", 2);
        EMPTY_CLASS_LIMIT_MAP = new HashMap();
        sVmPolicy = VmPolicy.LAX;
        sLogger = LOGCAT_LOGGER = info -> {
            String msg = info.durationMillis != -1 ? "StrictMode policy violation; ~duration=" + info.durationMillis + " ms:" : "StrictMode policy violation:";
            Log.d("StrictMode", msg + " " + info.getStackTrace());
        };
        sThreadViolationListener = new ThreadLocal();
        sThreadViolationExecutor = new ThreadLocal();
        sDropboxCallsInFlight = new AtomicInteger(0);
        sNonSdkApiUsageConsumer = message -> StrictMode.onVmPolicyViolation(new NonSdkApiUsedViolation((String)message));
        gatheredViolations = new ThreadLocal<ArrayList<ViolationInfo>>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_1$__constructor__() {
            }

            private final ArrayList<ViolationInfo> $$robo$$android_os_StrictMode_1$initialValue() {
                return null;
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_1$__constructor__(), 0, this);
            }

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_1$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        violationsBeingTimed = new ThreadLocal<ArrayList<ViolationInfo>>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_2$__constructor__() {
            }

            private final ArrayList<ViolationInfo> $$robo$$android_os_StrictMode_2$initialValue() {
                return new ArrayList<ViolationInfo>();
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_2$__constructor__(), 0, this);
            }

            @Override
            protected ArrayList<ViolationInfo> initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_2$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        THREAD_HANDLER = new ThreadLocal<Handler>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_3$__constructor__() {
            }

            private final Handler $$robo$$android_os_StrictMode_3$initialValue() {
                return new Handler();
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_3$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_3$__constructor__(), 0, this);
            }

            @Override
            protected Handler initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_3$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        THREAD_ANDROID_POLICY = new ThreadLocal<AndroidBlockGuardPolicy>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_4$__constructor__() {
            }

            private final AndroidBlockGuardPolicy $$robo$$android_os_StrictMode_4$initialValue() {
                return new AndroidBlockGuardPolicy(0);
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_4$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_4$__constructor__(), 0, this);
            }

            @Override
            protected AndroidBlockGuardPolicy initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_4$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sLastInstanceCountCheckMillis = 0L;
        sIsIdlerRegistered = false;
        sProcessIdleHandler = new MessageQueue.IdleHandler(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_5$__constructor__() {
            }

            private final boolean $$robo$$android_os_StrictMode_5$queueIdle() {
                long now = SystemClock.uptimeMillis();
                if (now - sLastInstanceCountCheckMillis > 30000L) {
                    sLastInstanceCountCheckMillis = now;
                    StrictMode.conditionallyCheckInstanceCounts();
                }
                return true;
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_5$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_5$__constructor__(), 0, this);
            }

            @Override
            public boolean queueIdle() {
                return (boolean)InvokeDynamicSupport.bootstrap("queueIdle", $$robo$$android_os_StrictMode_5$queueIdle(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sLastVmViolationTime = new HashMap();
        NO_OP_SPAN = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_6$__constructor__() {
            }

            private final void $$robo$$android_os_StrictMode_6$finish() {
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_6$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_6$__constructor__(), 0, this);
            }

            @Override
            public void finish() {
                InvokeDynamicSupport.bootstrap("finish", $$robo$$android_os_StrictMode_6$finish(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sThisThreadSpanState = new ThreadLocal<ThreadSpanState>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_7$__constructor__() {
            }

            private final ThreadSpanState $$robo$$android_os_StrictMode_7$initialValue() {
                return new ThreadSpanState();
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_7$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_7$__constructor__(), 0, this);
            }

            @Override
            protected ThreadSpanState initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_os_StrictMode_7$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sWindowManager = new Singleton<IWindowManager>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_StrictMode_8$__constructor__() {
            }

            private final IWindowManager $$robo$$android_os_StrictMode_8$create() {
                return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_8$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_8$__constructor__(), 0, this);
            }

            @Override
            protected IWindowManager create() {
                return InvokeDynamicSupport.bootstrap("create", $$robo$$android_os_StrictMode_8$create(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sExpectedActivityInstanceCount = new HashMap();
    }

    public static void setViolationLogger(ViolationLogger violationLogger) {
        InvokeDynamicSupport.bootstrapStatic("setViolationLogger", $$robo$$android_os_StrictMode$setViolationLogger(android.os.StrictMode$ViolationLogger ), 0, (ViolationLogger)violationLogger);
    }

    private void __constructor__() {
        this.$$robo$$android_os_StrictMode$__constructor__();
    }

    private StrictMode() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode$__constructor__(), 0, this);
    }

    public static void setThreadPolicy(ThreadPolicy threadPolicy) {
        InvokeDynamicSupport.bootstrapStatic("setThreadPolicy", $$robo$$android_os_StrictMode$setThreadPolicy(android.os.StrictMode$ThreadPolicy ), 0, (ThreadPolicy)threadPolicy);
    }

    public static void setThreadPolicyMask(int n) {
        InvokeDynamicSupport.bootstrapStatic("setThreadPolicyMask", $$robo$$android_os_StrictMode$setThreadPolicyMask(int ), 0, (int)n);
    }

    private static void setBlockGuardPolicy(int n) {
        InvokeDynamicSupport.bootstrapStatic("setBlockGuardPolicy", $$robo$$android_os_StrictMode$setBlockGuardPolicy(int ), 0, (int)n);
    }

    private static void setCloseGuardEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setCloseGuardEnabled", $$robo$$android_os_StrictMode$setCloseGuardEnabled(boolean ), 0, (boolean)bl);
    }

    public static int getThreadPolicyMask() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadPolicyMask", $$robo$$android_os_StrictMode$getThreadPolicyMask(), 0);
    }

    public static ThreadPolicy getThreadPolicy() {
        return InvokeDynamicSupport.bootstrapStatic("getThreadPolicy", $$robo$$android_os_StrictMode$getThreadPolicy(), 0);
    }

    public static ThreadPolicy allowThreadDiskWrites() {
        return InvokeDynamicSupport.bootstrapStatic("allowThreadDiskWrites", $$robo$$android_os_StrictMode$allowThreadDiskWrites(), 0);
    }

    public static int allowThreadDiskWritesMask() {
        return (int)InvokeDynamicSupport.bootstrapStatic("allowThreadDiskWritesMask", $$robo$$android_os_StrictMode$allowThreadDiskWritesMask(), 0);
    }

    public static ThreadPolicy allowThreadDiskReads() {
        return InvokeDynamicSupport.bootstrapStatic("allowThreadDiskReads", $$robo$$android_os_StrictMode$allowThreadDiskReads(), 0);
    }

    public static int allowThreadDiskReadsMask() {
        return (int)InvokeDynamicSupport.bootstrapStatic("allowThreadDiskReadsMask", $$robo$$android_os_StrictMode$allowThreadDiskReadsMask(), 0);
    }

    private static ThreadPolicy allowThreadViolations() {
        return InvokeDynamicSupport.bootstrapStatic("allowThreadViolations", $$robo$$android_os_StrictMode$allowThreadViolations(), 0);
    }

    private static VmPolicy allowVmViolations() {
        return InvokeDynamicSupport.bootstrapStatic("allowVmViolations", $$robo$$android_os_StrictMode$allowVmViolations(), 0);
    }

    public static boolean isBundledSystemApp(ApplicationInfo applicationInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isBundledSystemApp", $$robo$$android_os_StrictMode$isBundledSystemApp(android.content.pm.ApplicationInfo ), 0, (ApplicationInfo)applicationInfo);
    }

    public static void initThreadDefaults(ApplicationInfo applicationInfo) {
        InvokeDynamicSupport.bootstrapStatic("initThreadDefaults", $$robo$$android_os_StrictMode$initThreadDefaults(android.content.pm.ApplicationInfo ), 0, (ApplicationInfo)applicationInfo);
    }

    public static void initVmDefaults(ApplicationInfo applicationInfo) {
        InvokeDynamicSupport.bootstrapStatic("initVmDefaults", $$robo$$android_os_StrictMode$initVmDefaults(android.content.pm.ApplicationInfo ), 0, (ApplicationInfo)applicationInfo);
    }

    public static void enableDeathOnFileUriExposure() {
        InvokeDynamicSupport.bootstrapStatic("enableDeathOnFileUriExposure", $$robo$$android_os_StrictMode$enableDeathOnFileUriExposure(), 0);
    }

    public static void disableDeathOnFileUriExposure() {
        InvokeDynamicSupport.bootstrapStatic("disableDeathOnFileUriExposure", $$robo$$android_os_StrictMode$disableDeathOnFileUriExposure(), 0);
    }

    private static int parsePolicyFromMessage(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("parsePolicyFromMessage", $$robo$$android_os_StrictMode$parsePolicyFromMessage(java.lang.String ), 0, (String)string2);
    }

    private static boolean tooManyViolationsThisLoop() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("tooManyViolationsThisLoop", $$robo$$android_os_StrictMode$tooManyViolationsThisLoop(), 0);
    }

    private static void dropboxViolationAsync(int n, ViolationInfo violationInfo) {
        InvokeDynamicSupport.bootstrapStatic("dropboxViolationAsync", $$robo$$android_os_StrictMode$dropboxViolationAsync(int android.os.StrictMode$ViolationInfo ), 0, (int)n, (ViolationInfo)violationInfo);
    }

    private static void handleApplicationStrictModeViolation(int n, ViolationInfo violationInfo) {
        InvokeDynamicSupport.bootstrapStatic("handleApplicationStrictModeViolation", $$robo$$android_os_StrictMode$handleApplicationStrictModeViolation(int android.os.StrictMode$ViolationInfo ), 0, (int)n, (ViolationInfo)violationInfo);
    }

    static boolean hasGatheredViolations() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasGatheredViolations", $$robo$$android_os_StrictMode$hasGatheredViolations(), 0);
    }

    static void clearGatheredViolations() {
        InvokeDynamicSupport.bootstrapStatic("clearGatheredViolations", $$robo$$android_os_StrictMode$clearGatheredViolations(), 0);
    }

    public static void conditionallyCheckInstanceCounts() {
        InvokeDynamicSupport.bootstrapStatic("conditionallyCheckInstanceCounts", $$robo$$android_os_StrictMode$conditionallyCheckInstanceCounts(), 0);
    }

    public static void setVmPolicy(VmPolicy vmPolicy) {
        InvokeDynamicSupport.bootstrapStatic("setVmPolicy", $$robo$$android_os_StrictMode$setVmPolicy(android.os.StrictMode$VmPolicy ), 0, (VmPolicy)vmPolicy);
    }

    public static VmPolicy getVmPolicy() {
        return InvokeDynamicSupport.bootstrapStatic("getVmPolicy", $$robo$$android_os_StrictMode$getVmPolicy(), 0);
    }

    public static void enableDefaults() {
        InvokeDynamicSupport.bootstrapStatic("enableDefaults", $$robo$$android_os_StrictMode$enableDefaults(), 0);
    }

    public static boolean vmSqliteObjectLeaksEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmSqliteObjectLeaksEnabled", $$robo$$android_os_StrictMode$vmSqliteObjectLeaksEnabled(), 0);
    }

    public static boolean vmClosableObjectLeaksEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmClosableObjectLeaksEnabled", $$robo$$android_os_StrictMode$vmClosableObjectLeaksEnabled(), 0);
    }

    public static boolean vmRegistrationLeaksEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmRegistrationLeaksEnabled", $$robo$$android_os_StrictMode$vmRegistrationLeaksEnabled(), 0);
    }

    public static boolean vmFileUriExposureEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmFileUriExposureEnabled", $$robo$$android_os_StrictMode$vmFileUriExposureEnabled(), 0);
    }

    public static boolean vmCleartextNetworkEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmCleartextNetworkEnabled", $$robo$$android_os_StrictMode$vmCleartextNetworkEnabled(), 0);
    }

    public static boolean vmContentUriWithoutPermissionEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmContentUriWithoutPermissionEnabled", $$robo$$android_os_StrictMode$vmContentUriWithoutPermissionEnabled(), 0);
    }

    public static boolean vmUntaggedSocketEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("vmUntaggedSocketEnabled", $$robo$$android_os_StrictMode$vmUntaggedSocketEnabled(), 0);
    }

    public static void onSqliteObjectLeaked(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onSqliteObjectLeaked", $$robo$$android_os_StrictMode$onSqliteObjectLeaked(java.lang.String java.lang.Throwable ), 0, (String)string2, (Throwable)throwable);
    }

    public static void onWebViewMethodCalledOnWrongThread(Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onWebViewMethodCalledOnWrongThread", $$robo$$android_os_StrictMode$onWebViewMethodCalledOnWrongThread(java.lang.Throwable ), 0, (Throwable)throwable);
    }

    public static void onIntentReceiverLeaked(Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onIntentReceiverLeaked", $$robo$$android_os_StrictMode$onIntentReceiverLeaked(java.lang.Throwable ), 0, (Throwable)throwable);
    }

    public static void onServiceConnectionLeaked(Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("onServiceConnectionLeaked", $$robo$$android_os_StrictMode$onServiceConnectionLeaked(java.lang.Throwable ), 0, (Throwable)throwable);
    }

    public static void onFileUriExposed(Uri uri, String string2) {
        InvokeDynamicSupport.bootstrapStatic("onFileUriExposed", $$robo$$android_os_StrictMode$onFileUriExposed(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public static void onContentUriWithoutPermission(Uri uri, String string2) {
        InvokeDynamicSupport.bootstrapStatic("onContentUriWithoutPermission", $$robo$$android_os_StrictMode$onContentUriWithoutPermission(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public static void onCleartextNetworkDetected(byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("onCleartextNetworkDetected", $$robo$$android_os_StrictMode$onCleartextNetworkDetected(byte[] ), 0, (byte[])byArray);
    }

    public static void onUntaggedSocket() {
        InvokeDynamicSupport.bootstrapStatic("onUntaggedSocket", $$robo$$android_os_StrictMode$onUntaggedSocket(), 0);
    }

    public static void onVmPolicyViolation(Violation violation) {
        InvokeDynamicSupport.bootstrapStatic("onVmPolicyViolation", $$robo$$android_os_StrictMode$onVmPolicyViolation(android.os.strictmode.Violation ), 0, (Violation)violation);
    }

    public static void onVmPolicyViolation(Violation violation, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("onVmPolicyViolation", $$robo$$android_os_StrictMode$onVmPolicyViolation(android.os.strictmode.Violation boolean ), 0, (Violation)violation, (boolean)bl);
    }

    static void writeGatheredViolationsToParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("writeGatheredViolationsToParcel", $$robo$$android_os_StrictMode$writeGatheredViolationsToParcel(android.os.Parcel ), 0, (Parcel)parcel);
    }

    static void readAndHandleBinderCallViolations(Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("readAndHandleBinderCallViolations", $$robo$$android_os_StrictMode$readAndHandleBinderCallViolations(android.os.Parcel ), 0, (Parcel)parcel);
    }

    private static void onBinderStrictModePolicyChange(int n) {
        InvokeDynamicSupport.bootstrapStatic("onBinderStrictModePolicyChange", $$robo$$android_os_StrictMode$onBinderStrictModePolicyChange(int ), 0, (int)n);
    }

    public static Span enterCriticalSpan(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("enterCriticalSpan", $$robo$$android_os_StrictMode$enterCriticalSpan(java.lang.String ), 0, (String)string2);
    }

    public static void noteSlowCall(String string2) {
        InvokeDynamicSupport.bootstrapStatic("noteSlowCall", $$robo$$android_os_StrictMode$noteSlowCall(java.lang.String ), 0, (String)string2);
    }

    public static void noteResourceMismatch(Object object) {
        InvokeDynamicSupport.bootstrapStatic("noteResourceMismatch", $$robo$$android_os_StrictMode$noteResourceMismatch(java.lang.Object ), 0, (Object)object);
    }

    public static void noteUnbufferedIO() {
        InvokeDynamicSupport.bootstrapStatic("noteUnbufferedIO", $$robo$$android_os_StrictMode$noteUnbufferedIO(), 0);
    }

    public static void noteDiskRead() {
        InvokeDynamicSupport.bootstrapStatic("noteDiskRead", $$robo$$android_os_StrictMode$noteDiskRead(), 0);
    }

    public static void noteDiskWrite() {
        InvokeDynamicSupport.bootstrapStatic("noteDiskWrite", $$robo$$android_os_StrictMode$noteDiskWrite(), 0);
    }

    public static Object trackActivity(Object object) {
        return InvokeDynamicSupport.bootstrapStatic("trackActivity", $$robo$$android_os_StrictMode$trackActivity(java.lang.Object ), 0, (Object)object);
    }

    public static void incrementExpectedActivityCount(Class clazz) {
        InvokeDynamicSupport.bootstrapStatic("incrementExpectedActivityCount", $$robo$$android_os_StrictMode$incrementExpectedActivityCount(java.lang.Class ), 0, (Class)clazz);
    }

    public static void decrementExpectedActivityCount(Class clazz) {
        InvokeDynamicSupport.bootstrapStatic("decrementExpectedActivityCount", $$robo$$android_os_StrictMode$decrementExpectedActivityCount(java.lang.Class ), 0, (Class)clazz);
    }

    static {
        RobolectricInternals.classInitializing(StrictMode.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictMode)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class InstanceTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static HashMap<Class<?>, Integer> sInstanceCounts;
        private Class<?> mKlass;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void $$robo$$android_os_StrictMode_InstanceTracker$__constructor__(Object instance) {
            this.mKlass = instance.getClass();
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(this.mKlass);
                int newValue = value != null ? value + 1 : 1;
                sInstanceCounts.put(this.mKlass, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_StrictMode_InstanceTracker$finalize() throws Throwable {
            try {
                HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
                synchronized (hashMap) {
                    Integer value = sInstanceCounts.get(this.mKlass);
                    if (value != null) {
                        int newValue = value - 1;
                        if (newValue > 0) {
                            sInstanceCounts.put(this.mKlass, newValue);
                        } else {
                            sInstanceCounts.remove(this.mKlass);
                        }
                    }
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final int $$robo$$android_os_StrictMode_InstanceTracker$getInstanceCount(Class<?> klass) {
            HashMap<Class<?>, Integer> hashMap = sInstanceCounts;
            synchronized (hashMap) {
                Integer value = sInstanceCounts.get(klass);
                return value != null ? value : 0;
            }
        }

        static void __staticInitializer__() {
            sInstanceCounts = new HashMap();
        }

        private void __constructor__(Object object) {
            this.$$robo$$android_os_StrictMode_InstanceTracker$__constructor__(object);
        }

        public InstanceTracker(Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_InstanceTracker$__constructor__(java.lang.Object ), 0, this, object);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_StrictMode_InstanceTracker$finalize(), 0, this);
        }

        public static int getInstanceCount(Class<?> clazz) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getInstanceCount", $$robo$$android_os_StrictMode_InstanceTracker$getInstanceCount(java.lang.Class<?> ), 0, clazz);
        }

        static {
            RobolectricInternals.classInitializing(InstanceTracker.class);
        }

        public /* synthetic */ InstanceTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstanceTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ViolationInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Violation mViolation;
        private Deque<StackTraceElement[]> mBinderStack;
        private String mStackTrace;
        private int mPolicy;
        public int durationMillis;
        public int numAnimationsRunning;
        public String[] tags;
        public int violationNumThisLoop;
        public long violationUptimeMillis;
        public String broadcastIntentAction;
        public long numInstances;
        public static Parcelable.Creator<ViolationInfo> CREATOR;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(Violation tr, int policy) {
            this.mBinderStack = new ArrayDeque<StackTraceElement[]>();
            this.durationMillis = -1;
            this.numAnimationsRunning = 0;
            this.numInstances = -1L;
            this.mViolation = tr;
            this.mPolicy = policy;
            this.violationUptimeMillis = SystemClock.uptimeMillis();
            this.numAnimationsRunning = ValueAnimator.getCurrentAnimationsCount();
            Intent broadcastIntent = ActivityThread.getIntentBeingBroadcast();
            if (broadcastIntent != null) {
                this.broadcastIntentAction = broadcastIntent.getAction();
            }
            ThreadSpanState state = (ThreadSpanState)sThisThreadSpanState.get();
            if (tr instanceof InstanceCountViolation) {
                this.numInstances = ((InstanceCountViolation)tr).getNumberOfInstances();
            }
            ThreadSpanState threadSpanState = state;
            synchronized (threadSpanState) {
                int spanActiveCount = state.mActiveSize;
                if (spanActiveCount > 20) {
                    spanActiveCount = 20;
                }
                if (spanActiveCount != 0) {
                    this.tags = new String[spanActiveCount];
                    Span iter = state.mActiveHead;
                    for (int index = 0; iter != null && index < spanActiveCount; ++index) {
                        this.tags[index] = iter.mName;
                        iter = iter.mNext;
                    }
                }
            }
        }

        private final String $$robo$$android_os_StrictMode_ViolationInfo$getStackTrace() {
            if (this.mStackTrace == null) {
                StringWriter sw = new StringWriter();
                FastPrintWriter pw = new FastPrintWriter(sw, false, 256);
                this.mViolation.printStackTrace(pw);
                for (StackTraceElement[] traces : this.mBinderStack) {
                    pw.append("# via Binder call with stack:\n");
                    for (StackTraceElement traceElement : traces) {
                        pw.append("\tat ");
                        pw.append(traceElement.toString());
                        pw.append('\n');
                    }
                }
                ((PrintWriter)pw).flush();
                ((PrintWriter)pw).close();
                this.mStackTrace = sw.toString();
            }
            return this.mStackTrace;
        }

        private final String $$robo$$android_os_StrictMode_ViolationInfo$getViolationDetails() {
            return this.mViolation.getMessage();
        }

        private final int $$robo$$android_os_StrictMode_ViolationInfo$getPolicyMask() {
            return this.mPolicy;
        }

        private final boolean $$robo$$android_os_StrictMode_ViolationInfo$penaltyEnabled(int p) {
            return (this.mPolicy & p) != 0;
        }

        private final void $$robo$$android_os_StrictMode_ViolationInfo$addLocalStack(Throwable t) {
            this.mBinderStack.addFirst(t.getStackTrace());
        }

        private final int $$robo$$android_os_StrictMode_ViolationInfo$getViolationBit() {
            if (this.mViolation instanceof DiskWriteViolation) {
                return 1;
            }
            if (this.mViolation instanceof DiskReadViolation) {
                return 2;
            }
            if (this.mViolation instanceof NetworkViolation) {
                return 4;
            }
            if (this.mViolation instanceof CustomViolation) {
                return 8;
            }
            if (this.mViolation instanceof ResourceMismatchViolation) {
                return 16;
            }
            if (this.mViolation instanceof UnbufferedIoViolation) {
                return 32;
            }
            if (this.mViolation instanceof SqliteObjectLeakedViolation) {
                return 256;
            }
            if (this.mViolation instanceof LeakedClosableViolation) {
                return 512;
            }
            if (this.mViolation instanceof InstanceCountViolation) {
                return 2048;
            }
            if (this.mViolation instanceof IntentReceiverLeakedViolation) {
                return 4096;
            }
            if (this.mViolation instanceof ServiceConnectionLeakedViolation) {
                return 4096;
            }
            if (this.mViolation instanceof FileUriExposedViolation) {
                return 8192;
            }
            if (this.mViolation instanceof CleartextNetworkViolation) {
                return 16384;
            }
            if (this.mViolation instanceof ContentUriWithoutPermissionViolation) {
                return 32768;
            }
            if (this.mViolation instanceof UntaggedSocketViolation) {
                return Integer.MIN_VALUE;
            }
            if (this.mViolation instanceof NonSdkApiUsedViolation) {
                return 0x40000000;
            }
            throw new IllegalStateException("missing violation bit");
        }

        private final int $$robo$$android_os_StrictMode_ViolationInfo$hashCode() {
            int result = 17;
            if (this.mViolation != null) {
                result = 37 * result + this.mViolation.hashCode();
            }
            if (this.numAnimationsRunning != 0) {
                result *= 37;
            }
            if (this.broadcastIntentAction != null) {
                result = 37 * result + this.broadcastIntentAction.hashCode();
            }
            if (this.tags != null) {
                for (String tag : this.tags) {
                    result = 37 * result + tag.hashCode();
                }
            }
            return result;
        }

        private void $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(Parcel in) {
        }

        private void $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(Parcel in, boolean unsetGatheringBit) {
            this.mBinderStack = new ArrayDeque<StackTraceElement[]>();
            this.durationMillis = -1;
            this.numAnimationsRunning = 0;
            this.numInstances = -1L;
            this.mViolation = (Violation)in.readSerializable();
            int binderStackSize = in.readInt();
            for (int i = 0; i < binderStackSize; ++i) {
                StackTraceElement[] traceElements = new StackTraceElement[in.readInt()];
                for (int j = 0; j < traceElements.length; ++j) {
                    StackTraceElement element;
                    traceElements[j] = element = new StackTraceElement(in.readString(), in.readString(), in.readString(), in.readInt());
                }
                this.mBinderStack.add(traceElements);
            }
            int rawPolicy = in.readInt();
            this.mPolicy = unsetGatheringBit ? rawPolicy & 0xFFBFFFFF : rawPolicy;
            this.durationMillis = in.readInt();
            this.violationNumThisLoop = in.readInt();
            this.numAnimationsRunning = in.readInt();
            this.violationUptimeMillis = in.readLong();
            this.numInstances = in.readLong();
            this.broadcastIntentAction = in.readString();
            this.tags = in.readStringArray();
        }

        private final void $$robo$$android_os_StrictMode_ViolationInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeSerializable(this.mViolation);
            dest.writeInt(this.mBinderStack.size());
            for (StackTraceElement[] traceElements : this.mBinderStack) {
                dest.writeInt(traceElements.length);
                for (StackTraceElement element : traceElements) {
                    dest.writeString(element.getClassName());
                    dest.writeString(element.getMethodName());
                    dest.writeString(element.getFileName());
                    dest.writeInt(element.getLineNumber());
                }
            }
            int start = dest.dataPosition();
            dest.writeInt(this.mPolicy);
            dest.writeInt(this.durationMillis);
            dest.writeInt(this.violationNumThisLoop);
            dest.writeInt(this.numAnimationsRunning);
            dest.writeLong(this.violationUptimeMillis);
            dest.writeLong(this.numInstances);
            dest.writeString(this.broadcastIntentAction);
            dest.writeStringArray(this.tags);
            int total = dest.dataPosition() - start;
        }

        private final void $$robo$$android_os_StrictMode_ViolationInfo$dump(Printer pw, String prefix) {
            pw.println(prefix + "stackTrace: " + this.getStackTrace());
            pw.println(prefix + "policy: " + this.mPolicy);
            if (this.durationMillis != -1) {
                pw.println(prefix + "durationMillis: " + this.durationMillis);
            }
            if (this.numInstances != -1L) {
                pw.println(prefix + "numInstances: " + this.numInstances);
            }
            if (this.violationNumThisLoop != 0) {
                pw.println(prefix + "violationNumThisLoop: " + this.violationNumThisLoop);
            }
            if (this.numAnimationsRunning != 0) {
                pw.println(prefix + "numAnimationsRunning: " + this.numAnimationsRunning);
            }
            pw.println(prefix + "violationUptimeMillis: " + this.violationUptimeMillis);
            if (this.broadcastIntentAction != null) {
                pw.println(prefix + "broadcastIntentAction: " + this.broadcastIntentAction);
            }
            if (this.tags != null) {
                int index = 0;
                for (String tag : this.tags) {
                    pw.println(prefix + "tag[" + index++ + "]: " + tag);
                }
            }
        }

        private final int $$robo$$android_os_StrictMode_ViolationInfo$describeContents() {
            return 0;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ViolationInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_StrictMode_ViolationInfo_1$__constructor__() {
                }

                private final ViolationInfo $$robo$$android_os_StrictMode_ViolationInfo_1$createFromParcel(Parcel in) {
                    return new ViolationInfo(in);
                }

                private final ViolationInfo[] $$robo$$android_os_StrictMode_ViolationInfo_1$newArray(int size) {
                    return new ViolationInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_StrictMode_ViolationInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo_1$__constructor__(), 0, this);
                }

                @Override
                public ViolationInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_StrictMode_ViolationInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ViolationInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_StrictMode_ViolationInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Violation violation, int n) {
            this.$$robo$$android_os_StrictMode_ViolationInfo$__constructor__(violation, n);
        }

        ViolationInfo(Violation violation, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(android.os.strictmode.Violation int ), 0, this, violation, n);
        }

        public String getStackTrace() {
            return InvokeDynamicSupport.bootstrap("getStackTrace", $$robo$$android_os_StrictMode_ViolationInfo$getStackTrace(), 0, this);
        }

        public String getViolationDetails() {
            return InvokeDynamicSupport.bootstrap("getViolationDetails", $$robo$$android_os_StrictMode_ViolationInfo$getViolationDetails(), 0, this);
        }

        public int getPolicyMask() {
            return (int)InvokeDynamicSupport.bootstrap("getPolicyMask", $$robo$$android_os_StrictMode_ViolationInfo$getPolicyMask(), 0, this);
        }

        boolean penaltyEnabled(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("penaltyEnabled", $$robo$$android_os_StrictMode_ViolationInfo$penaltyEnabled(int ), 0, this, n);
        }

        void addLocalStack(Throwable throwable) {
            InvokeDynamicSupport.bootstrap("addLocalStack", $$robo$$android_os_StrictMode_ViolationInfo$addLocalStack(java.lang.Throwable ), 0, this, throwable);
        }

        public int getViolationBit() {
            return (int)InvokeDynamicSupport.bootstrap("getViolationBit", $$robo$$android_os_StrictMode_ViolationInfo$getViolationBit(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_StrictMode_ViolationInfo$hashCode(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_StrictMode_ViolationInfo$__constructor__(parcel);
        }

        public ViolationInfo(Parcel parcel) {
            this(parcel, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(Parcel parcel, boolean bl) {
            this.$$robo$$android_os_StrictMode_ViolationInfo$__constructor__(parcel, bl);
        }

        public ViolationInfo(Parcel parcel, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ViolationInfo$__constructor__(android.os.Parcel boolean ), 0, this, parcel, bl);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_StrictMode_ViolationInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void dump(Printer printer, String string2) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_StrictMode_ViolationInfo$dump(android.util.Printer java.lang.String ), 0, this, printer, string2);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_StrictMode_ViolationInfo$describeContents(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ViolationInfo.class);
        }

        public /* synthetic */ ViolationInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViolationInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ThreadSpanState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Span mActiveHead;
        public int mActiveSize;
        public Span mFreeListHead;
        public int mFreeListSize;

        private void $$robo$$android_os_StrictMode_ThreadSpanState$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_ThreadSpanState$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_os_StrictMode_ThreadSpanState$__constructor__();
        }

        private ThreadSpanState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadSpanState$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_os_StrictMode_ThreadSpanState$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadSpanState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Span
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mName;
        private long mCreateMillis;
        private Span mNext;
        private Span mPrev;
        private ThreadSpanState mContainerState;

        private void $$robo$$android_os_StrictMode_Span$__constructor__(ThreadSpanState threadState) {
            this.mContainerState = threadState;
        }

        private void $$robo$$android_os_StrictMode_Span$__constructor__() {
            this.mContainerState = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_StrictMode_Span$finish() {
            ThreadSpanState state;
            ThreadSpanState threadSpanState = state = this.mContainerState;
            synchronized (threadSpanState) {
                if (this.mName == null) {
                    return;
                }
                if (this.mPrev != null) {
                    this.mPrev.mNext = this.mNext;
                }
                if (this.mNext != null) {
                    this.mNext.mPrev = this.mPrev;
                }
                if (state.mActiveHead == this) {
                    state.mActiveHead = this.mNext;
                }
                --state.mActiveSize;
                if (LOG_V) {
                    Log.d("StrictMode", "Span finished=" + this.mName + "; size=" + state.mActiveSize);
                }
                this.mCreateMillis = -1L;
                this.mName = null;
                this.mPrev = null;
                this.mNext = null;
                if (state.mFreeListSize < 5) {
                    this.mNext = state.mFreeListHead;
                    state.mFreeListHead = this;
                    ++state.mFreeListSize;
                }
            }
        }

        private void __constructor__(ThreadSpanState threadSpanState) {
            this.$$robo$$android_os_StrictMode_Span$__constructor__(threadSpanState);
        }

        Span(ThreadSpanState threadSpanState) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_Span$__constructor__(android.os.StrictMode$ThreadSpanState ), 0, this, threadSpanState);
        }

        private void __constructor__() {
            this.$$robo$$android_os_StrictMode_Span$__constructor__();
        }

        protected Span() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_Span$__constructor__(), 0, this);
        }

        public void finish() {
            InvokeDynamicSupport.bootstrap("finish", $$robo$$android_os_StrictMode_Span$finish(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Span)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AndroidCloseGuardReporter
    implements CloseGuard.Reporter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__() {
        }

        private final void $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$report(String message, Throwable allocationSite) {
            StrictMode.onVmPolicyViolation(new LeakedClosableViolation(message, allocationSite));
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__();
        }

        private AndroidCloseGuardReporter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__(), 0, this);
        }

        @Override
        public void report(String string2, Throwable throwable) {
            InvokeDynamicSupport.bootstrap("report", $$robo$$android_os_StrictMode_AndroidCloseGuardReporter$report(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_os_StrictMode_AndroidCloseGuardReporter$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidCloseGuardReporter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AndroidBlockGuardPolicy
    implements BlockGuard.Policy,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mPolicyMask;
        private ArrayMap<Integer, Long> mLastViolationTime;

        private void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$__constructor__(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        private final String $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$toString() {
            return "AndroidBlockGuardPolicy; mPolicyMask=" + this.mPolicyMask;
        }

        private final int $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$getPolicyMask() {
            return this.mPolicyMask;
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onWriteToDisk() {
            if ((this.mPolicyMask & 1) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new DiskWriteViolation());
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onCustomSlowCall(String name) {
            if ((this.mPolicyMask & 8) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new CustomViolation(name));
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onResourceMismatch(Object tag) {
            if ((this.mPolicyMask & 0x10) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new ResourceMismatchViolation(tag));
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onUnbufferedIO() {
            if ((this.mPolicyMask & 0x20) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new UnbufferedIoViolation());
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onReadFromDisk() {
            if ((this.mPolicyMask & 2) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new DiskReadViolation());
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onNetwork() {
            if ((this.mPolicyMask & 4) == 0) {
                return;
            }
            if ((this.mPolicyMask & 0x1000000) != 0) {
                throw new NetworkOnMainThreadException();
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            this.startHandlingViolationException(new NetworkViolation());
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$setPolicyMask(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$startHandlingViolationException(Violation e) {
            ViolationInfo info = new ViolationInfo(e, this.mPolicyMask);
            info.violationUptimeMillis = SystemClock.uptimeMillis();
            this.handleViolationWithTimingAttempt(info);
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$handleViolationWithTimingAttempt(ViolationInfo info) {
            IWindowManager windowManager;
            Looper looper = Looper.myLooper();
            if (looper == null || (info.mPolicy & 0x1770000) == 262144) {
                info.durationMillis = -1;
                this.onThreadPolicyViolation(info);
                return;
            }
            ArrayList records = (ArrayList)violationsBeingTimed.get();
            if (records.size() >= 10) {
                return;
            }
            records.add(info);
            if (records.size() > 1) {
                return;
            }
            IWindowManager iWindowManager = windowManager = info.penaltyEnabled(0x100000) ? (IWindowManager)sWindowManager.get() : null;
            if (windowManager != null) {
                try {
                    windowManager.showStrictModeViolation(true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            ((Handler)THREAD_HANDLER.get()).postAtFrontOfQueue(() -> {
                long loopFinishTime = SystemClock.uptimeMillis();
                if (windowManager != null) {
                    try {
                        windowManager.showStrictModeViolation(false);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                for (int n = 0; n < records.size(); ++n) {
                    ViolationInfo v = (ViolationInfo)records.get(n);
                    v.violationNumThisLoop = n + 1;
                    v.durationMillis = (int)(loopFinishTime - v.violationUptimeMillis);
                    this.onThreadPolicyViolation(v);
                }
                records.clear();
            });
        }

        private final void $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onThreadPolicyViolation(ViolationInfo info) {
            long timeSinceLastViolationMillis;
            if (LOG_V) {
                Log.d("StrictMode", "onThreadPolicyViolation; policy=" + info.mPolicy);
            }
            if (info.penaltyEnabled(0x400000)) {
                ArrayList<ViolationInfo> violations = (ArrayList<ViolationInfo>)gatheredViolations.get();
                if (violations == null) {
                    violations = new ArrayList<ViolationInfo>(1);
                    gatheredViolations.set(violations);
                }
                for (ViolationInfo previous : violations) {
                    if (!info.getStackTrace().equals(previous.getStackTrace())) continue;
                    return;
                }
                violations.add(info);
                return;
            }
            Integer crashFingerprint = info.hashCode();
            long lastViolationTime = 0L;
            if (this.mLastViolationTime != null) {
                Long vtime = this.mLastViolationTime.get(crashFingerprint);
                if (vtime != null) {
                    lastViolationTime = vtime;
                }
            } else {
                this.mLastViolationTime = new ArrayMap(1);
            }
            long now = SystemClock.uptimeMillis();
            this.mLastViolationTime.put(crashFingerprint, now);
            long l = timeSinceLastViolationMillis = lastViolationTime == 0L ? Long.MAX_VALUE : now - lastViolationTime;
            if (info.penaltyEnabled(65536) && timeSinceLastViolationMillis > 1000L) {
                sLogger.log(info);
            }
            Violation violation = info.mViolation;
            int violationMaskSubset = 0;
            if (info.penaltyEnabled(131072) && timeSinceLastViolationMillis > 30000L) {
                violationMaskSubset |= 0x20000;
            }
            if (info.penaltyEnabled(0x200000) && lastViolationTime == 0L) {
                violationMaskSubset |= 0x200000;
            }
            if (violationMaskSubset != 0) {
                boolean justDropBox;
                violationMaskSubset |= info.getViolationBit();
                boolean bl = justDropBox = (info.mPolicy & 0x1770000) == 0x200000;
                if (justDropBox) {
                    StrictMode.dropboxViolationAsync(violationMaskSubset, info);
                } else {
                    StrictMode.handleApplicationStrictModeViolation(violationMaskSubset, info);
                }
            }
            if ((info.getPolicyMask() & 0x40000) != 0) {
                throw new RuntimeException("StrictMode ThreadPolicy violation", violation);
            }
            OnThreadViolationListener listener = (OnThreadViolationListener)sThreadViolationListener.get();
            Executor executor = (Executor)sThreadViolationExecutor.get();
            if (listener != null && executor != null) {
                try {
                    executor.execute(() -> {
                        ThreadPolicy oldPolicy = StrictMode.allowThreadViolations();
                        try {
                            listener.onThreadViolation(violation);
                        }
                        finally {
                            StrictMode.setThreadPolicy(oldPolicy);
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    Log.e("StrictMode", "ThreadPolicy penaltyCallback failed", e);
                }
            }
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$__constructor__(n);
        }

        public AndroidBlockGuardPolicy(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$__constructor__(int ), 0, this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$toString(), 0, this);
        }

        @Override
        public int getPolicyMask() {
            return (int)InvokeDynamicSupport.bootstrap("getPolicyMask", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$getPolicyMask(), 0, this);
        }

        @Override
        public void onWriteToDisk() {
            InvokeDynamicSupport.bootstrap("onWriteToDisk", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onWriteToDisk(), 0, this);
        }

        void onCustomSlowCall(String string2) {
            InvokeDynamicSupport.bootstrap("onCustomSlowCall", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onCustomSlowCall(java.lang.String ), 0, this, string2);
        }

        void onResourceMismatch(Object object) {
            InvokeDynamicSupport.bootstrap("onResourceMismatch", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onResourceMismatch(java.lang.Object ), 0, this, object);
        }

        @Override
        public void onUnbufferedIO() {
            InvokeDynamicSupport.bootstrap("onUnbufferedIO", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onUnbufferedIO(), 0, this);
        }

        @Override
        public void onReadFromDisk() {
            InvokeDynamicSupport.bootstrap("onReadFromDisk", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onReadFromDisk(), 0, this);
        }

        @Override
        public void onNetwork() {
            InvokeDynamicSupport.bootstrap("onNetwork", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onNetwork(), 0, this);
        }

        public void setPolicyMask(int n) {
            InvokeDynamicSupport.bootstrap("setPolicyMask", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$setPolicyMask(int ), 0, this, n);
        }

        void startHandlingViolationException(Violation violation) {
            InvokeDynamicSupport.bootstrap("startHandlingViolationException", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$startHandlingViolationException(android.os.strictmode.Violation ), 0, this, violation);
        }

        void handleViolationWithTimingAttempt(ViolationInfo violationInfo) {
            InvokeDynamicSupport.bootstrap("handleViolationWithTimingAttempt", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$handleViolationWithTimingAttempt(android.os.StrictMode$ViolationInfo ), 0, this, violationInfo);
        }

        void onThreadPolicyViolation(ViolationInfo violationInfo) {
            InvokeDynamicSupport.bootstrap("onThreadPolicyViolation", $$robo$$android_os_StrictMode_AndroidBlockGuardPolicy$onThreadPolicyViolation(android.os.StrictMode$ViolationInfo ), 0, this, violationInfo);
        }

        public /* synthetic */ AndroidBlockGuardPolicy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidBlockGuardPolicy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class VmPolicy
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static VmPolicy LAX;
        int mask;
        OnVmViolationListener mListener;
        Executor mCallbackExecutor;
        HashMap<Class, Integer> classInstanceLimit;

        private void $$robo$$android_os_StrictMode_VmPolicy$__constructor__(int mask, HashMap<Class, Integer> classInstanceLimit, OnVmViolationListener listener, Executor executor) {
            if (classInstanceLimit == null) {
                throw new NullPointerException("classInstanceLimit == null");
            }
            this.mask = mask;
            this.classInstanceLimit = classInstanceLimit;
            this.mListener = listener;
            this.mCallbackExecutor = executor;
        }

        private final String $$robo$$android_os_StrictMode_VmPolicy$toString() {
            return "[StrictMode.VmPolicy; mask=" + this.mask + "]";
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_VmPolicy$__constructor__(int x0, HashMap x1, OnVmViolationListener x2, Executor x3, 1 x4) {
        }

        static void __staticInitializer__() {
            LAX = new VmPolicy(0, EMPTY_CLASS_LIMIT_MAP, null, null);
        }

        private void __constructor__(int n, HashMap<Class, Integer> hashMap, OnVmViolationListener onVmViolationListener, Executor executor) {
            this.$$robo$$android_os_StrictMode_VmPolicy$__constructor__(n, hashMap, onVmViolationListener, executor);
        }

        private VmPolicy(int n, HashMap<Class, Integer> hashMap, OnVmViolationListener onVmViolationListener, Executor executor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_VmPolicy$__constructor__(int java.util.HashMap<java.lang.Class, java.lang.Integer> android.os.StrictMode$OnVmViolationListener java.util.concurrent.Executor ), 0, this, n, hashMap, onVmViolationListener, executor);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_StrictMode_VmPolicy$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, HashMap hashMap, OnVmViolationListener onVmViolationListener, Executor executor, 1 var5_5) {
            this.$$robo$$android_os_StrictMode_VmPolicy$__constructor__(n, hashMap, onVmViolationListener, executor, var5_5);
        }

        static {
            RobolectricInternals.classInitializing(VmPolicy.class);
        }

        public /* synthetic */ VmPolicy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VmPolicy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private int mMask;
            private OnVmViolationListener mListener;
            private Executor mExecutor;
            private HashMap<Class, Integer> mClassInstanceLimit;
            private boolean mClassInstanceLimitNeedCow;

            private void $$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__() {
                this.mClassInstanceLimitNeedCow = false;
                this.mMask = 0;
            }

            private void $$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__(VmPolicy base) {
                this.mClassInstanceLimitNeedCow = false;
                this.mMask = base.mask;
                this.mClassInstanceLimitNeedCow = true;
                this.mClassInstanceLimit = base.classInstanceLimit;
                this.mListener = base.mListener;
                this.mExecutor = base.mCallbackExecutor;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$setClassInstanceLimit(Class klass, int instanceLimit) {
                if (klass == null) {
                    throw new NullPointerException("klass == null");
                }
                if (this.mClassInstanceLimitNeedCow) {
                    if (this.mClassInstanceLimit.containsKey(klass) && this.mClassInstanceLimit.get(klass) == instanceLimit) {
                        return this;
                    }
                    this.mClassInstanceLimitNeedCow = false;
                    this.mClassInstanceLimit = (HashMap)this.mClassInstanceLimit.clone();
                } else if (this.mClassInstanceLimit == null) {
                    this.mClassInstanceLimit = new HashMap();
                }
                this.mMask |= 0x800;
                this.mClassInstanceLimit.put(klass, instanceLimit);
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectActivityLeaks() {
                return this.enable(1024);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$permitActivityLeaks() {
                return this.disable(1024);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectNonSdkApiUsage() {
                return this.enable(0x40000000);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$permitNonSdkApiUsage() {
                return this.disable(0x40000000);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectAll() {
                this.detectLeakedSqlLiteObjects();
                int targetSdk = VMRuntime.getRuntime().getTargetSdkVersion();
                if (targetSdk >= 11) {
                    this.detectActivityLeaks();
                    this.detectLeakedClosableObjects();
                }
                if (targetSdk >= 16) {
                    this.detectLeakedRegistrationObjects();
                }
                if (targetSdk >= 18) {
                    this.detectFileUriExposure();
                }
                if (targetSdk >= 23 && SystemProperties.getBoolean("persist.sys.strictmode.clear", false)) {
                    this.detectCleartextNetwork();
                }
                if (targetSdk >= 26) {
                    this.detectContentUriWithoutPermission();
                    this.detectUntaggedSockets();
                }
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedSqlLiteObjects() {
                return this.enable(256);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedClosableObjects() {
                return this.enable(512);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedRegistrationObjects() {
                return this.enable(4096);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectFileUriExposure() {
                return this.enable(8192);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectCleartextNetwork() {
                return this.enable(16384);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectContentUriWithoutPermission() {
                return this.enable(32768);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$detectUntaggedSockets() {
                return this.enable(Integer.MIN_VALUE);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$permitUntaggedSockets() {
                return this.disable(Integer.MIN_VALUE);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeath() {
                return this.enable(262144);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeathOnCleartextNetwork() {
                return this.enable(0x2000000);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeathOnFileUriExposure() {
                return this.enable(0x4000000);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyLog() {
                return this.enable(65536);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDropBox() {
                return this.enable(0x200000);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyListener(Executor executor, OnVmViolationListener listener) {
                if (executor == null) {
                    throw new NullPointerException("executor must not be null");
                }
                this.mListener = listener;
                this.mExecutor = executor;
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyListener(OnVmViolationListener listener, Executor executor) {
                return this.penaltyListener(executor, listener);
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_VmPolicy_Builder$disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            private final VmPolicy $$robo$$android_os_StrictMode_VmPolicy_Builder$build() {
                if (this.mListener == null && this.mMask != 0 && (this.mMask & 0x270000) == 0) {
                    this.penaltyLog();
                }
                return new VmPolicy(this.mMask, this.mClassInstanceLimit != null ? this.mClassInstanceLimit : EMPTY_CLASS_LIMIT_MAP, this.mListener, this.mExecutor);
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__(), 0, this);
            }

            private void __constructor__(VmPolicy vmPolicy) {
                this.$$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__(vmPolicy);
            }

            public Builder(VmPolicy vmPolicy) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_VmPolicy_Builder$__constructor__(android.os.StrictMode$VmPolicy ), 0, this, vmPolicy);
            }

            public Builder setClassInstanceLimit(Class clazz, int n) {
                return InvokeDynamicSupport.bootstrap("setClassInstanceLimit", $$robo$$android_os_StrictMode_VmPolicy_Builder$setClassInstanceLimit(java.lang.Class int ), 0, this, clazz, n);
            }

            public Builder detectActivityLeaks() {
                return InvokeDynamicSupport.bootstrap("detectActivityLeaks", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectActivityLeaks(), 0, this);
            }

            public Builder permitActivityLeaks() {
                return InvokeDynamicSupport.bootstrap("permitActivityLeaks", $$robo$$android_os_StrictMode_VmPolicy_Builder$permitActivityLeaks(), 0, this);
            }

            public Builder detectNonSdkApiUsage() {
                return InvokeDynamicSupport.bootstrap("detectNonSdkApiUsage", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectNonSdkApiUsage(), 0, this);
            }

            public Builder permitNonSdkApiUsage() {
                return InvokeDynamicSupport.bootstrap("permitNonSdkApiUsage", $$robo$$android_os_StrictMode_VmPolicy_Builder$permitNonSdkApiUsage(), 0, this);
            }

            public Builder detectAll() {
                return InvokeDynamicSupport.bootstrap("detectAll", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectAll(), 0, this);
            }

            public Builder detectLeakedSqlLiteObjects() {
                return InvokeDynamicSupport.bootstrap("detectLeakedSqlLiteObjects", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedSqlLiteObjects(), 0, this);
            }

            public Builder detectLeakedClosableObjects() {
                return InvokeDynamicSupport.bootstrap("detectLeakedClosableObjects", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedClosableObjects(), 0, this);
            }

            public Builder detectLeakedRegistrationObjects() {
                return InvokeDynamicSupport.bootstrap("detectLeakedRegistrationObjects", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectLeakedRegistrationObjects(), 0, this);
            }

            public Builder detectFileUriExposure() {
                return InvokeDynamicSupport.bootstrap("detectFileUriExposure", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectFileUriExposure(), 0, this);
            }

            public Builder detectCleartextNetwork() {
                return InvokeDynamicSupport.bootstrap("detectCleartextNetwork", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectCleartextNetwork(), 0, this);
            }

            public Builder detectContentUriWithoutPermission() {
                return InvokeDynamicSupport.bootstrap("detectContentUriWithoutPermission", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectContentUriWithoutPermission(), 0, this);
            }

            public Builder detectUntaggedSockets() {
                return InvokeDynamicSupport.bootstrap("detectUntaggedSockets", $$robo$$android_os_StrictMode_VmPolicy_Builder$detectUntaggedSockets(), 0, this);
            }

            public Builder permitUntaggedSockets() {
                return InvokeDynamicSupport.bootstrap("permitUntaggedSockets", $$robo$$android_os_StrictMode_VmPolicy_Builder$permitUntaggedSockets(), 0, this);
            }

            public Builder penaltyDeath() {
                return InvokeDynamicSupport.bootstrap("penaltyDeath", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeath(), 0, this);
            }

            public Builder penaltyDeathOnCleartextNetwork() {
                return InvokeDynamicSupport.bootstrap("penaltyDeathOnCleartextNetwork", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeathOnCleartextNetwork(), 0, this);
            }

            public Builder penaltyDeathOnFileUriExposure() {
                return InvokeDynamicSupport.bootstrap("penaltyDeathOnFileUriExposure", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDeathOnFileUriExposure(), 0, this);
            }

            public Builder penaltyLog() {
                return InvokeDynamicSupport.bootstrap("penaltyLog", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyLog(), 0, this);
            }

            public Builder penaltyDropBox() {
                return InvokeDynamicSupport.bootstrap("penaltyDropBox", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyDropBox(), 0, this);
            }

            public Builder penaltyListener(Executor executor, OnVmViolationListener onVmViolationListener) {
                return InvokeDynamicSupport.bootstrap("penaltyListener", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyListener(java.util.concurrent.Executor android.os.StrictMode$OnVmViolationListener ), 0, this, executor, onVmViolationListener);
            }

            public Builder penaltyListener(OnVmViolationListener onVmViolationListener, Executor executor) {
                return InvokeDynamicSupport.bootstrap("penaltyListener", $$robo$$android_os_StrictMode_VmPolicy_Builder$penaltyListener(android.os.StrictMode$OnVmViolationListener java.util.concurrent.Executor ), 0, this, onVmViolationListener, executor);
            }

            private Builder enable(int n) {
                return InvokeDynamicSupport.bootstrap("enable", $$robo$$android_os_StrictMode_VmPolicy_Builder$enable(int ), 0, this, n);
            }

            Builder disable(int n) {
                return InvokeDynamicSupport.bootstrap("disable", $$robo$$android_os_StrictMode_VmPolicy_Builder$disable(int ), 0, this, n);
            }

            public VmPolicy build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_os_StrictMode_VmPolicy_Builder$build(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ThreadPolicy
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static ThreadPolicy LAX;
        int mask;
        OnThreadViolationListener mListener;
        Executor mCallbackExecutor;

        private void $$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(int mask, OnThreadViolationListener listener, Executor executor) {
            this.mask = mask;
            this.mListener = listener;
            this.mCallbackExecutor = executor;
        }

        private final String $$robo$$android_os_StrictMode_ThreadPolicy$toString() {
            return "[StrictMode.ThreadPolicy; mask=" + this.mask + "]";
        }

        private /* synthetic */ void $$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(int x0, OnThreadViolationListener x1, Executor x2, 1 x3) {
        }

        static void __staticInitializer__() {
            LAX = new ThreadPolicy(0, null, null);
        }

        private void __constructor__(int n, OnThreadViolationListener onThreadViolationListener, Executor executor) {
            this.$$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(n, onThreadViolationListener, executor);
        }

        private ThreadPolicy(int n, OnThreadViolationListener onThreadViolationListener, Executor executor) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(int android.os.StrictMode$OnThreadViolationListener java.util.concurrent.Executor ), 0, this, n, onThreadViolationListener, executor);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_StrictMode_ThreadPolicy$toString(), 0, this);
        }

        private /* synthetic */ void __constructor__(int n, OnThreadViolationListener onThreadViolationListener, Executor executor, 1 var4_4) {
            this.$$robo$$android_os_StrictMode_ThreadPolicy$__constructor__(n, onThreadViolationListener, executor, var4_4);
        }

        static {
            RobolectricInternals.classInitializing(ThreadPolicy.class);
        }

        public /* synthetic */ ThreadPolicy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadPolicy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class Builder
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private int mMask;
            private OnThreadViolationListener mListener;
            private Executor mExecutor;

            private void $$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__() {
                this.mMask = 0;
                this.mMask = 0;
            }

            private void $$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__(ThreadPolicy policy) {
                this.mMask = 0;
                this.mMask = policy.mask;
                this.mListener = policy.mListener;
                this.mExecutor = policy.mCallbackExecutor;
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectAll() {
                this.detectDiskReads();
                this.detectDiskWrites();
                this.detectNetwork();
                int targetSdk = VMRuntime.getRuntime().getTargetSdkVersion();
                if (targetSdk >= 11) {
                    this.detectCustomSlowCalls();
                }
                if (targetSdk >= 23) {
                    this.detectResourceMismatches();
                }
                if (targetSdk >= 26) {
                    this.detectUnbufferedIo();
                }
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitAll() {
                return this.disable(63);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectNetwork() {
                return this.enable(4);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitNetwork() {
                return this.disable(4);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectDiskReads() {
                return this.enable(2);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitDiskReads() {
                return this.disable(2);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectCustomSlowCalls() {
                return this.enable(8);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitCustomSlowCalls() {
                return this.disable(8);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitResourceMismatches() {
                return this.disable(16);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectUnbufferedIo() {
                return this.enable(32);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitUnbufferedIo() {
                return this.disable(32);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectResourceMismatches() {
                return this.enable(16);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectDiskWrites() {
                return this.enable(1);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitDiskWrites() {
                return this.disable(1);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDialog() {
                return this.enable(131072);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDeath() {
                return this.enable(262144);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDeathOnNetwork() {
                return this.enable(0x1000000);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyFlashScreen() {
                return this.enable(0x100000);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyLog() {
                return this.enable(65536);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDropBox() {
                return this.enable(0x200000);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyListener(Executor executor, OnThreadViolationListener listener) {
                if (executor == null) {
                    throw new NullPointerException("executor must not be null");
                }
                this.mListener = listener;
                this.mExecutor = executor;
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyListener(OnThreadViolationListener listener, Executor executor) {
                return this.penaltyListener(executor, listener);
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            private final Builder $$robo$$android_os_StrictMode_ThreadPolicy_Builder$disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            private final ThreadPolicy $$robo$$android_os_StrictMode_ThreadPolicy_Builder$build() {
                if (this.mListener == null && this.mMask != 0 && (this.mMask & 0x270000) == 0) {
                    this.penaltyLog();
                }
                return new ThreadPolicy(this.mMask, this.mListener, this.mExecutor);
            }

            private void __constructor__() {
                this.$$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__();
            }

            public Builder() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__(), 0, this);
            }

            private void __constructor__(ThreadPolicy threadPolicy) {
                this.$$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__(threadPolicy);
            }

            public Builder(ThreadPolicy threadPolicy) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$__constructor__(android.os.StrictMode$ThreadPolicy ), 0, this, threadPolicy);
            }

            public Builder detectAll() {
                return InvokeDynamicSupport.bootstrap("detectAll", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectAll(), 0, this);
            }

            public Builder permitAll() {
                return InvokeDynamicSupport.bootstrap("permitAll", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitAll(), 0, this);
            }

            public Builder detectNetwork() {
                return InvokeDynamicSupport.bootstrap("detectNetwork", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectNetwork(), 0, this);
            }

            public Builder permitNetwork() {
                return InvokeDynamicSupport.bootstrap("permitNetwork", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitNetwork(), 0, this);
            }

            public Builder detectDiskReads() {
                return InvokeDynamicSupport.bootstrap("detectDiskReads", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectDiskReads(), 0, this);
            }

            public Builder permitDiskReads() {
                return InvokeDynamicSupport.bootstrap("permitDiskReads", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitDiskReads(), 0, this);
            }

            public Builder detectCustomSlowCalls() {
                return InvokeDynamicSupport.bootstrap("detectCustomSlowCalls", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectCustomSlowCalls(), 0, this);
            }

            public Builder permitCustomSlowCalls() {
                return InvokeDynamicSupport.bootstrap("permitCustomSlowCalls", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitCustomSlowCalls(), 0, this);
            }

            public Builder permitResourceMismatches() {
                return InvokeDynamicSupport.bootstrap("permitResourceMismatches", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitResourceMismatches(), 0, this);
            }

            public Builder detectUnbufferedIo() {
                return InvokeDynamicSupport.bootstrap("detectUnbufferedIo", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectUnbufferedIo(), 0, this);
            }

            public Builder permitUnbufferedIo() {
                return InvokeDynamicSupport.bootstrap("permitUnbufferedIo", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitUnbufferedIo(), 0, this);
            }

            public Builder detectResourceMismatches() {
                return InvokeDynamicSupport.bootstrap("detectResourceMismatches", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectResourceMismatches(), 0, this);
            }

            public Builder detectDiskWrites() {
                return InvokeDynamicSupport.bootstrap("detectDiskWrites", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$detectDiskWrites(), 0, this);
            }

            public Builder permitDiskWrites() {
                return InvokeDynamicSupport.bootstrap("permitDiskWrites", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$permitDiskWrites(), 0, this);
            }

            public Builder penaltyDialog() {
                return InvokeDynamicSupport.bootstrap("penaltyDialog", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDialog(), 0, this);
            }

            public Builder penaltyDeath() {
                return InvokeDynamicSupport.bootstrap("penaltyDeath", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDeath(), 0, this);
            }

            public Builder penaltyDeathOnNetwork() {
                return InvokeDynamicSupport.bootstrap("penaltyDeathOnNetwork", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDeathOnNetwork(), 0, this);
            }

            public Builder penaltyFlashScreen() {
                return InvokeDynamicSupport.bootstrap("penaltyFlashScreen", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyFlashScreen(), 0, this);
            }

            public Builder penaltyLog() {
                return InvokeDynamicSupport.bootstrap("penaltyLog", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyLog(), 0, this);
            }

            public Builder penaltyDropBox() {
                return InvokeDynamicSupport.bootstrap("penaltyDropBox", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyDropBox(), 0, this);
            }

            public Builder penaltyListener(Executor executor, OnThreadViolationListener onThreadViolationListener) {
                return InvokeDynamicSupport.bootstrap("penaltyListener", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyListener(java.util.concurrent.Executor android.os.StrictMode$OnThreadViolationListener ), 0, this, executor, onThreadViolationListener);
            }

            public Builder penaltyListener(OnThreadViolationListener onThreadViolationListener, Executor executor) {
                return InvokeDynamicSupport.bootstrap("penaltyListener", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$penaltyListener(android.os.StrictMode$OnThreadViolationListener java.util.concurrent.Executor ), 0, this, onThreadViolationListener, executor);
            }

            private Builder enable(int n) {
                return InvokeDynamicSupport.bootstrap("enable", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$enable(int ), 0, this, n);
            }

            private Builder disable(int n) {
                return InvokeDynamicSupport.bootstrap("disable", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$disable(int ), 0, this, n);
            }

            public ThreadPolicy build() {
                return InvokeDynamicSupport.bootstrap("build", $$robo$$android_os_StrictMode_ThreadPolicy_Builder$build(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static interface OnVmViolationListener
    extends InstrumentedInterface {
        public void onVmViolation(Violation var1);
    }

    public static interface OnThreadViolationListener
    extends InstrumentedInterface {
        public void onThreadViolation(Violation var1);
    }

    public static interface ViolationLogger
    extends InstrumentedInterface {
        public void log(ViolationInfo var1);
    }
}

