/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.pm.IPackageMoveObserver;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IVoldTaskListener;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.storage.DiskInfo;
import android.os.storage.IObbActionListener;
import android.os.storage.IStorageEventListener;
import android.os.storage.IStorageShutdownObserver;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.os.storage.VolumeRecord;
import com.android.internal.os.AppFuseMount;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IStorageManager
extends IInterface,
InstrumentedInterface {
    public void registerListener(IStorageEventListener var1) throws RemoteException;

    public void unregisterListener(IStorageEventListener var1) throws RemoteException;

    public void shutdown(IStorageShutdownObserver var1) throws RemoteException;

    public void mountObb(String var1, String var2, String var3, IObbActionListener var4, int var5) throws RemoteException;

    public void unmountObb(String var1, boolean var2, IObbActionListener var3, int var4) throws RemoteException;

    public boolean isObbMounted(String var1) throws RemoteException;

    public String getMountedObbPath(String var1) throws RemoteException;

    public int decryptStorage(String var1) throws RemoteException;

    public int encryptStorage(int var1, String var2) throws RemoteException;

    public int changeEncryptionPassword(int var1, String var2) throws RemoteException;

    public StorageVolume[] getVolumeList(int var1, String var2, int var3) throws RemoteException;

    public int getEncryptionState() throws RemoteException;

    public int verifyEncryptionPassword(String var1) throws RemoteException;

    public void mkdirs(String var1, String var2) throws RemoteException;

    public int getPasswordType() throws RemoteException;

    public String getPassword() throws RemoteException;

    public void clearPassword() throws RemoteException;

    public void setField(String var1, String var2) throws RemoteException;

    public String getField(String var1) throws RemoteException;

    public long lastMaintenance() throws RemoteException;

    public void runMaintenance() throws RemoteException;

    public DiskInfo[] getDisks() throws RemoteException;

    public VolumeInfo[] getVolumes(int var1) throws RemoteException;

    public VolumeRecord[] getVolumeRecords(int var1) throws RemoteException;

    public void mount(String var1) throws RemoteException;

    public void unmount(String var1) throws RemoteException;

    public void format(String var1) throws RemoteException;

    public void partitionPublic(String var1) throws RemoteException;

    public void partitionPrivate(String var1) throws RemoteException;

    public void partitionMixed(String var1, int var2) throws RemoteException;

    public void setVolumeNickname(String var1, String var2) throws RemoteException;

    public void setVolumeUserFlags(String var1, int var2, int var3) throws RemoteException;

    public void forgetVolume(String var1) throws RemoteException;

    public void forgetAllVolumes() throws RemoteException;

    public String getPrimaryStorageUuid() throws RemoteException;

    public void setPrimaryStorageUuid(String var1, IPackageMoveObserver var2) throws RemoteException;

    public void benchmark(String var1, IVoldTaskListener var2) throws RemoteException;

    public void setDebugFlags(int var1, int var2) throws RemoteException;

    public void createUserKey(int var1, int var2, boolean var3) throws RemoteException;

    public void destroyUserKey(int var1) throws RemoteException;

    public void unlockUserKey(int var1, int var2, byte[] var3, byte[] var4) throws RemoteException;

    public void lockUserKey(int var1) throws RemoteException;

    public boolean isUserKeyUnlocked(int var1) throws RemoteException;

    public void prepareUserStorage(String var1, int var2, int var3, int var4) throws RemoteException;

    public void destroyUserStorage(String var1, int var2, int var3) throws RemoteException;

    public boolean isConvertibleToFBE() throws RemoteException;

    public void addUserKeyAuth(int var1, int var2, byte[] var3, byte[] var4) throws RemoteException;

    public void fixateNewestUserKeyAuth(int var1) throws RemoteException;

    public void fstrim(int var1, IVoldTaskListener var2) throws RemoteException;

    public AppFuseMount mountProxyFileDescriptorBridge() throws RemoteException;

    public ParcelFileDescriptor openProxyFileDescriptor(int var1, int var2, int var3) throws RemoteException;

    public long getCacheQuotaBytes(String var1, int var2) throws RemoteException;

    public long getCacheSizeBytes(String var1, int var2) throws RemoteException;

    public long getAllocatableBytes(String var1, int var2, String var3) throws RemoteException;

    public void allocateBytes(String var1, long var2, int var4, String var5) throws RemoteException;

    public void runIdleMaintenance() throws RemoteException;

    public void abortIdleMaintenance() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStorageManager,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.os.storage.IStorageManager";
        static int TRANSACTION_registerListener = 1;
        static int TRANSACTION_unregisterListener = 2;
        static int TRANSACTION_shutdown = 20;
        static int TRANSACTION_mountObb = 22;
        static int TRANSACTION_unmountObb = 23;
        static int TRANSACTION_isObbMounted = 24;
        static int TRANSACTION_getMountedObbPath = 25;
        static int TRANSACTION_decryptStorage = 27;
        static int TRANSACTION_encryptStorage = 28;
        static int TRANSACTION_changeEncryptionPassword = 29;
        static int TRANSACTION_getVolumeList = 30;
        static int TRANSACTION_getEncryptionState = 32;
        static int TRANSACTION_verifyEncryptionPassword = 33;
        static int TRANSACTION_mkdirs = 35;
        static int TRANSACTION_getPasswordType = 36;
        static int TRANSACTION_getPassword = 37;
        static int TRANSACTION_clearPassword = 38;
        static int TRANSACTION_setField = 39;
        static int TRANSACTION_getField = 40;
        static int TRANSACTION_lastMaintenance = 42;
        static int TRANSACTION_runMaintenance = 43;
        static int TRANSACTION_getDisks = 45;
        static int TRANSACTION_getVolumes = 46;
        static int TRANSACTION_getVolumeRecords = 47;
        static int TRANSACTION_mount = 48;
        static int TRANSACTION_unmount = 49;
        static int TRANSACTION_format = 50;
        static int TRANSACTION_partitionPublic = 51;
        static int TRANSACTION_partitionPrivate = 52;
        static int TRANSACTION_partitionMixed = 53;
        static int TRANSACTION_setVolumeNickname = 54;
        static int TRANSACTION_setVolumeUserFlags = 55;
        static int TRANSACTION_forgetVolume = 56;
        static int TRANSACTION_forgetAllVolumes = 57;
        static int TRANSACTION_getPrimaryStorageUuid = 58;
        static int TRANSACTION_setPrimaryStorageUuid = 59;
        static int TRANSACTION_benchmark = 60;
        static int TRANSACTION_setDebugFlags = 61;
        static int TRANSACTION_createUserKey = 62;
        static int TRANSACTION_destroyUserKey = 63;
        static int TRANSACTION_unlockUserKey = 64;
        static int TRANSACTION_lockUserKey = 65;
        static int TRANSACTION_isUserKeyUnlocked = 66;
        static int TRANSACTION_prepareUserStorage = 67;
        static int TRANSACTION_destroyUserStorage = 68;
        static int TRANSACTION_isConvertibleToFBE = 69;
        static int TRANSACTION_addUserKeyAuth = 71;
        static int TRANSACTION_fixateNewestUserKeyAuth = 72;
        static int TRANSACTION_fstrim = 73;
        static int TRANSACTION_mountProxyFileDescriptorBridge = 74;
        static int TRANSACTION_openProxyFileDescriptor = 75;
        static int TRANSACTION_getCacheQuotaBytes = 76;
        static int TRANSACTION_getCacheSizeBytes = 77;
        static int TRANSACTION_getAllocatableBytes = 78;
        static int TRANSACTION_allocateBytes = 79;
        static int TRANSACTION_runIdleMaintenance = 80;
        static int TRANSACTION_abortIdleMaintenance = 81;

        private void $$robo$$android_os_storage_IStorageManager_Stub$__constructor__() {
            this.attachInterface(this, "android.os.storage.IStorageManager");
        }

        private static final IStorageManager $$robo$$android_os_storage_IStorageManager_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.os.storage.IStorageManager");
            if (iin != null && iin instanceof IStorageManager) {
                return (IStorageManager)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_os_storage_IStorageManager_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_os_storage_IStorageManager_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = "android.os.storage.IStorageManager";
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IStorageEventListener _arg0 = IStorageEventListener.Stub.asInterface(data.readStrongBinder());
                    this.registerListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IStorageEventListener _arg0 = IStorageEventListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    IStorageShutdownObserver _arg0 = IStorageShutdownObserver.Stub.asInterface(data.readStrongBinder());
                    this.shutdown(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    IObbActionListener _arg3 = IObbActionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg4 = data.readInt();
                    this.mountObb(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    IObbActionListener _arg2 = IObbActionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    this.unmountObb(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isObbMounted(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.getMountedObbPath(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.decryptStorage(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _result = this.encryptStorage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _result = this.changeEncryptionPassword(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    Parcelable[] _result = this.getVolumeList(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    int _result = this.getEncryptionState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.verifyEncryptionPassword(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.mkdirs(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    int _result = this.getPasswordType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    String _result = this.getPassword();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    this.clearPassword();
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.setField(_arg0, _arg1);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.getField(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    long _result = this.lastMaintenance();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    this.runMaintenance();
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    Parcelable[] _result = this.getDisks();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Parcelable[] _result = this.getVolumes(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    Parcelable[] _result = this.getVolumeRecords(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.mount(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.unmount(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.format(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.partitionPublic(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.partitionPrivate(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.partitionMixed(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.setVolumeNickname(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setVolumeUserFlags(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.forgetVolume(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    this.forgetAllVolumes();
                    reply.writeNoException();
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    String _result = this.getPrimaryStorageUuid();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IPackageMoveObserver _arg1 = IPackageMoveObserver.Stub.asInterface(data.readStrongBinder());
                    this.setPrimaryStorageUuid(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IVoldTaskListener _arg1 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    this.benchmark(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.setDebugFlags(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.createUserKey(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.destroyUserKey(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    byte[] _arg3 = data.createByteArray();
                    this.unlockUserKey(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.lockUserKey(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isUserKeyUnlocked(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 67: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.prepareUserStorage(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 68: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.destroyUserStorage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 69: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isConvertibleToFBE();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 71: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    byte[] _arg3 = data.createByteArray();
                    this.addUserKeyAuth(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 72: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.fixateNewestUserKeyAuth(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 73: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IVoldTaskListener _arg1 = IVoldTaskListener.Stub.asInterface(data.readStrongBinder());
                    this.fstrim(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 74: {
                    data.enforceInterface(descriptor);
                    AppFuseMount _result = this.mountProxyFileDescriptorBridge();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 75: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    ParcelFileDescriptor _result = this.openProxyFileDescriptor(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 76: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    long _result = this.getCacheQuotaBytes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 77: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    long _result = this.getCacheSizeBytes(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 78: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    long _result = this.getAllocatableBytes(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 79: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    this.allocateBytes(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 80: {
                    data.enforceInterface(descriptor);
                    this.runIdleMaintenance();
                    reply.writeNoException();
                    return true;
                }
                case 81: {
                    data.enforceInterface(descriptor);
                    this.abortIdleMaintenance();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_os_storage_IStorageManager_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_IStorageManager_Stub$__constructor__(), 0, this);
        }

        public static IStorageManager asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_os_storage_IStorageManager_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_os_storage_IStorageManager_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_os_storage_IStorageManager_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IStorageManager,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_os_storage_IStorageManager_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getInterfaceDescriptor() {
                return "android.os.storage.IStorageManager";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$registerListener(IStorageEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$unregisterListener(IStorageEventListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$shutdown(IStorageShutdownObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$mountObb(String rawPath, String canonicalPath, String key, IObbActionListener token, int nonce) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(rawPath);
                    _data.writeString(canonicalPath);
                    _data.writeString(key);
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    _data.writeInt(nonce);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$unmountObb(String rawPath, boolean force, IObbActionListener token, int nonce) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(rawPath);
                    _data.writeInt(force ? 1 : 0);
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    _data.writeInt(nonce);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_os_storage_IStorageManager_Stub_Proxy$isObbMounted(String rawPath) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(rawPath);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getMountedObbPath(String rawPath) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(rawPath);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IStorageManager_Stub_Proxy$decryptStorage(String password) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(password);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IStorageManager_Stub_Proxy$encryptStorage(int type, String password) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(type);
                    _data.writeString(password);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IStorageManager_Stub_Proxy$changeEncryptionPassword(int type, String password) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(type);
                    _data.writeString(password);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final StorageVolume[] $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getVolumeList(int uid, String packageName, int flags) throws RemoteException {
                StorageVolume[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(StorageVolume.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getEncryptionState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IStorageManager_Stub_Proxy$verifyEncryptionPassword(String password) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(password);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$mkdirs(String callingPkg, String path) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(callingPkg);
                    _data.writeString(path);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getPasswordType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getPassword() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$clearPassword() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(38, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setField(String field, String contents) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(field);
                    _data.writeString(contents);
                    this.mRemote.transact(39, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getField(String field) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(field);
                    this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final long $$robo$$android_os_storage_IStorageManager_Stub_Proxy$lastMaintenance() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$runMaintenance() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final DiskInfo[] $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getDisks() throws RemoteException {
                DiskInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(DiskInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final VolumeInfo[] $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getVolumes(int flags) throws RemoteException {
                VolumeInfo[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(flags);
                    this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(VolumeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final VolumeRecord[] $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getVolumeRecords(int flags) throws RemoteException {
                VolumeRecord[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(flags);
                    this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(VolumeRecord.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$mount(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volId);
                    this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$unmount(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volId);
                    this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$format(String volId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volId);
                    this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$partitionPublic(String diskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(diskId);
                    this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$partitionPrivate(String diskId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(diskId);
                    this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$partitionMixed(String diskId, int ratio) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(diskId);
                    _data.writeInt(ratio);
                    this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setVolumeNickname(String fsUuid, String nickname) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(fsUuid);
                    _data.writeString(nickname);
                    this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setVolumeUserFlags(String fsUuid, int flags, int mask) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(fsUuid);
                    _data.writeInt(flags);
                    _data.writeInt(mask);
                    this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$forgetVolume(String fsUuid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(fsUuid);
                    this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$forgetAllVolumes() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getPrimaryStorageUuid() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setPrimaryStorageUuid(String volumeUuid, IPackageMoveObserver callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volumeUuid);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$benchmark(String volId, IVoldTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volId);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setDebugFlags(int flags, int mask) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(flags);
                    _data.writeInt(mask);
                    this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$createUserKey(int userId, int serialNumber, boolean ephemeral) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeInt(ephemeral ? 1 : 0);
                    this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$destroyUserKey(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$unlockUserKey(int userId, int serialNumber, byte[] token, byte[] secret) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeByteArray(token);
                    _data.writeByteArray(secret);
                    this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$lockUserKey(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_os_storage_IStorageManager_Stub_Proxy$isUserKeyUnlocked(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$prepareUserStorage(String volumeUuid, int userId, int serialNumber, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volumeUuid);
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeInt(flags);
                    this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$destroyUserStorage(String volumeUuid, int userId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volumeUuid);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_os_storage_IStorageManager_Stub_Proxy$isConvertibleToFBE() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(69, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$addUserKeyAuth(int userId, int serialNumber, byte[] token, byte[] secret) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(userId);
                    _data.writeInt(serialNumber);
                    _data.writeByteArray(token);
                    _data.writeByteArray(secret);
                    this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$fixateNewestUserKeyAuth(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(userId);
                    this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$fstrim(int flags, IVoldTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(flags);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final AppFuseMount $$robo$$android_os_storage_IStorageManager_Stub_Proxy$mountProxyFileDescriptorBridge() throws RemoteException {
                AppFuseMount _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? AppFuseMount.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final ParcelFileDescriptor $$robo$$android_os_storage_IStorageManager_Stub_Proxy$openProxyFileDescriptor(int mountPointId, int fileId, int mode) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeInt(mountPointId);
                    _data.writeInt(fileId);
                    _data.writeInt(mode);
                    this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? ParcelFileDescriptor.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final long $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getCacheQuotaBytes(String volumeUuid, int uid) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volumeUuid);
                    _data.writeInt(uid);
                    this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final long $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getCacheSizeBytes(String volumeUuid, int uid) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volumeUuid);
                    _data.writeInt(uid);
                    this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final long $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getAllocatableBytes(String volumeUuid, int flags, String callingPackage) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volumeUuid);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$allocateBytes(String volumeUuid, long bytes, int flags, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    _data.writeString(volumeUuid);
                    _data.writeLong(bytes);
                    _data.writeInt(flags);
                    _data.writeString(callingPackage);
                    this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$runIdleMaintenance() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private final void $$robo$$android_os_storage_IStorageManager_Stub_Proxy$abortIdleMaintenance() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.os.storage.IStorageManager");
                    this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_os_storage_IStorageManager_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public void registerListener(IStorageEventListener iStorageEventListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$registerListener(android.os.storage.IStorageEventListener ), 0, this, iStorageEventListener);
            }

            @Override
            public void unregisterListener(IStorageEventListener iStorageEventListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterListener", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$unregisterListener(android.os.storage.IStorageEventListener ), 0, this, iStorageEventListener);
            }

            @Override
            public void shutdown(IStorageShutdownObserver iStorageShutdownObserver) throws RemoteException {
                InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$shutdown(android.os.storage.IStorageShutdownObserver ), 0, this, iStorageShutdownObserver);
            }

            @Override
            public void mountObb(String string2, String string3, String string4, IObbActionListener iObbActionListener, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("mountObb", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$mountObb(java.lang.String java.lang.String java.lang.String android.os.storage.IObbActionListener int ), 0, this, string2, string3, string4, iObbActionListener, n);
            }

            @Override
            public void unmountObb(String string2, boolean bl, IObbActionListener iObbActionListener, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unmountObb", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$unmountObb(java.lang.String boolean android.os.storage.IObbActionListener int ), 0, this, string2, bl, iObbActionListener, n);
            }

            @Override
            public boolean isObbMounted(String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isObbMounted", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$isObbMounted(java.lang.String ), 0, this, string2);
            }

            @Override
            public String getMountedObbPath(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getMountedObbPath", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getMountedObbPath(java.lang.String ), 0, this, string2);
            }

            @Override
            public int decryptStorage(String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("decryptStorage", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$decryptStorage(java.lang.String ), 0, this, string2);
            }

            @Override
            public int encryptStorage(int n, String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("encryptStorage", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$encryptStorage(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public int changeEncryptionPassword(int n, String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("changeEncryptionPassword", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$changeEncryptionPassword(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public StorageVolume[] getVolumeList(int n, String string2, int n2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getVolumeList", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getVolumeList(int java.lang.String int ), 0, this, n, string2, n2);
            }

            @Override
            public int getEncryptionState() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getEncryptionState", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getEncryptionState(), 0, this);
            }

            @Override
            public int verifyEncryptionPassword(String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("verifyEncryptionPassword", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$verifyEncryptionPassword(java.lang.String ), 0, this, string2);
            }

            @Override
            public void mkdirs(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("mkdirs", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$mkdirs(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public int getPasswordType() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getPasswordType", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getPasswordType(), 0, this);
            }

            @Override
            public String getPassword() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getPassword", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getPassword(), 0, this);
            }

            @Override
            public void clearPassword() throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearPassword", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$clearPassword(), 0, this);
            }

            @Override
            public void setField(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setField", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setField(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public String getField(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getField", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getField(java.lang.String ), 0, this, string2);
            }

            @Override
            public long lastMaintenance() throws RemoteException {
                return (long)InvokeDynamicSupport.bootstrap("lastMaintenance", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$lastMaintenance(), 0, this);
            }

            @Override
            public void runMaintenance() throws RemoteException {
                InvokeDynamicSupport.bootstrap("runMaintenance", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$runMaintenance(), 0, this);
            }

            @Override
            public DiskInfo[] getDisks() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDisks", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getDisks(), 0, this);
            }

            @Override
            public VolumeInfo[] getVolumes(int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getVolumes", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getVolumes(int ), 0, this, n);
            }

            @Override
            public VolumeRecord[] getVolumeRecords(int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getVolumeRecords", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getVolumeRecords(int ), 0, this, n);
            }

            @Override
            public void mount(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("mount", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$mount(java.lang.String ), 0, this, string2);
            }

            @Override
            public void unmount(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unmount", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$unmount(java.lang.String ), 0, this, string2);
            }

            @Override
            public void format(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("format", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$format(java.lang.String ), 0, this, string2);
            }

            @Override
            public void partitionPublic(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("partitionPublic", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$partitionPublic(java.lang.String ), 0, this, string2);
            }

            @Override
            public void partitionPrivate(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("partitionPrivate", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$partitionPrivate(java.lang.String ), 0, this, string2);
            }

            @Override
            public void partitionMixed(String string2, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("partitionMixed", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$partitionMixed(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void setVolumeNickname(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setVolumeNickname", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setVolumeNickname(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void setVolumeUserFlags(String string2, int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setVolumeUserFlags", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setVolumeUserFlags(java.lang.String int int ), 0, this, string2, n, n2);
            }

            @Override
            public void forgetVolume(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("forgetVolume", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$forgetVolume(java.lang.String ), 0, this, string2);
            }

            @Override
            public void forgetAllVolumes() throws RemoteException {
                InvokeDynamicSupport.bootstrap("forgetAllVolumes", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$forgetAllVolumes(), 0, this);
            }

            @Override
            public String getPrimaryStorageUuid() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getPrimaryStorageUuid", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getPrimaryStorageUuid(), 0, this);
            }

            @Override
            public void setPrimaryStorageUuid(String string2, IPackageMoveObserver iPackageMoveObserver) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setPrimaryStorageUuid", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setPrimaryStorageUuid(java.lang.String android.content.pm.IPackageMoveObserver ), 0, this, string2, iPackageMoveObserver);
            }

            @Override
            public void benchmark(String string2, IVoldTaskListener iVoldTaskListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("benchmark", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$benchmark(java.lang.String android.os.IVoldTaskListener ), 0, this, string2, iVoldTaskListener);
            }

            @Override
            public void setDebugFlags(int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setDebugFlags", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$setDebugFlags(int int ), 0, this, n, n2);
            }

            @Override
            public void createUserKey(int n, int n2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("createUserKey", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$createUserKey(int int boolean ), 0, this, n, n2, bl);
            }

            @Override
            public void destroyUserKey(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("destroyUserKey", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$destroyUserKey(int ), 0, this, n);
            }

            @Override
            public void unlockUserKey(int n, int n2, byte[] byArray, byte[] byArray2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unlockUserKey", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$unlockUserKey(int int byte[] byte[] ), 0, this, n, n2, byArray, byArray2);
            }

            @Override
            public void lockUserKey(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("lockUserKey", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$lockUserKey(int ), 0, this, n);
            }

            @Override
            public boolean isUserKeyUnlocked(int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isUserKeyUnlocked", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$isUserKeyUnlocked(int ), 0, this, n);
            }

            @Override
            public void prepareUserStorage(String string2, int n, int n2, int n3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("prepareUserStorage", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$prepareUserStorage(java.lang.String int int int ), 0, this, string2, n, n2, n3);
            }

            @Override
            public void destroyUserStorage(String string2, int n, int n2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("destroyUserStorage", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$destroyUserStorage(java.lang.String int int ), 0, this, string2, n, n2);
            }

            @Override
            public boolean isConvertibleToFBE() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isConvertibleToFBE", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$isConvertibleToFBE(), 0, this);
            }

            @Override
            public void addUserKeyAuth(int n, int n2, byte[] byArray, byte[] byArray2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addUserKeyAuth", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$addUserKeyAuth(int int byte[] byte[] ), 0, this, n, n2, byArray, byArray2);
            }

            @Override
            public void fixateNewestUserKeyAuth(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("fixateNewestUserKeyAuth", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$fixateNewestUserKeyAuth(int ), 0, this, n);
            }

            @Override
            public void fstrim(int n, IVoldTaskListener iVoldTaskListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("fstrim", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$fstrim(int android.os.IVoldTaskListener ), 0, this, n, iVoldTaskListener);
            }

            @Override
            public AppFuseMount mountProxyFileDescriptorBridge() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("mountProxyFileDescriptorBridge", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$mountProxyFileDescriptorBridge(), 0, this);
            }

            @Override
            public ParcelFileDescriptor openProxyFileDescriptor(int n, int n2, int n3) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("openProxyFileDescriptor", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$openProxyFileDescriptor(int int int ), 0, this, n, n2, n3);
            }

            @Override
            public long getCacheQuotaBytes(String string2, int n) throws RemoteException {
                return (long)InvokeDynamicSupport.bootstrap("getCacheQuotaBytes", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getCacheQuotaBytes(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public long getCacheSizeBytes(String string2, int n) throws RemoteException {
                return (long)InvokeDynamicSupport.bootstrap("getCacheSizeBytes", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getCacheSizeBytes(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public long getAllocatableBytes(String string2, int n, String string3) throws RemoteException {
                return (long)InvokeDynamicSupport.bootstrap("getAllocatableBytes", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$getAllocatableBytes(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
            }

            @Override
            public void allocateBytes(String string2, long l, int n, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("allocateBytes", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$allocateBytes(java.lang.String long int java.lang.String ), 0, this, string2, l, n, string3);
            }

            @Override
            public void runIdleMaintenance() throws RemoteException {
                InvokeDynamicSupport.bootstrap("runIdleMaintenance", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$runIdleMaintenance(), 0, this);
            }

            @Override
            public void abortIdleMaintenance() throws RemoteException {
                InvokeDynamicSupport.bootstrap("abortIdleMaintenance", $$robo$$android_os_storage_IStorageManager_Stub_Proxy$abortIdleMaintenance(), 0, this);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

