/*
 * Decompiled with CFR 0.152.
 */
package android.privacy.internal.rappor;

import android.privacy.DifferentialPrivacyEncoder;
import android.privacy.internal.rappor.RapporConfig;
import com.google.android.rappor.Encoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RapporEncoder
implements DifferentialPrivacyEncoder,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static byte[] INSECURE_SECRET;
    private static SecureRandom sSecureRandom;
    private RapporConfig mConfig;
    private Encoder mEncoder;
    private boolean mIsSecure;

    private void $$robo$$android_privacy_internal_rappor_RapporEncoder$__constructor__(RapporConfig config, boolean secureEncoder, byte[] userSecret) {
        Random random;
        this.mConfig = config;
        this.mIsSecure = secureEncoder;
        if (secureEncoder) {
            random = sSecureRandom;
        } else {
            random = new Random(this.getInsecureSeed(config.mEncoderId));
            userSecret = INSECURE_SECRET;
        }
        this.mEncoder = new Encoder(random, null, null, userSecret, config.mEncoderId, config.mNumBits, config.mProbabilityF, config.mProbabilityP, config.mProbabilityQ, config.mNumCohorts, config.mNumBloomHashes);
    }

    private final long $$robo$$android_privacy_internal_rappor_RapporEncoder$getInsecureSeed(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] bytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return ByteBuffer.wrap(bytes).getLong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"Unable generate insecure seed");
        }
    }

    private static final RapporEncoder $$robo$$android_privacy_internal_rappor_RapporEncoder$createEncoder(RapporConfig config, byte[] userSecret) {
        return new RapporEncoder(config, true, userSecret);
    }

    private static final RapporEncoder $$robo$$android_privacy_internal_rappor_RapporEncoder$createInsecureEncoderForTest(RapporConfig config) {
        return new RapporEncoder(config, false, null);
    }

    private final byte[] $$robo$$android_privacy_internal_rappor_RapporEncoder$encodeString(String original) {
        return this.mEncoder.encodeString(original);
    }

    private final byte[] $$robo$$android_privacy_internal_rappor_RapporEncoder$encodeBoolean(boolean original) {
        return this.mEncoder.encodeBoolean(original);
    }

    private final byte[] $$robo$$android_privacy_internal_rappor_RapporEncoder$encodeBits(byte[] bits) {
        return this.mEncoder.encodeBits(bits);
    }

    private final RapporConfig $$robo$$android_privacy_internal_rappor_RapporEncoder$getConfig() {
        return this.mConfig;
    }

    private final boolean $$robo$$android_privacy_internal_rappor_RapporEncoder$isInsecureEncoderForTest() {
        return !this.mIsSecure;
    }

    static void __staticInitializer__() {
        INSECURE_SECRET = new byte[]{-41, 104, -103, -109, -108, 19, 83, 84, -2, -48, 126, 84, -2, -48, 126, 84, -41, 104, -103, -109, -108, 19, 83, 84, -2, -48, 126, 84, -2, -48, 126, 84, -41, 104, -103, -109, -108, 19, 83, 84, -2, -48, 126, 84, -2, -48, 126, 84};
        sSecureRandom = new SecureRandom();
    }

    private void __constructor__(RapporConfig rapporConfig, boolean bl, byte[] byArray) {
        this.$$robo$$android_privacy_internal_rappor_RapporEncoder$__constructor__(rapporConfig, bl, byArray);
    }

    private RapporEncoder(RapporConfig rapporConfig, boolean bl, byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_privacy_internal_rappor_RapporEncoder$__constructor__(android.privacy.internal.rappor.RapporConfig boolean byte[] ), 0, this, rapporConfig, bl, byArray);
    }

    private long getInsecureSeed(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("getInsecureSeed", $$robo$$android_privacy_internal_rappor_RapporEncoder$getInsecureSeed(java.lang.String ), 0, this, string2);
    }

    public static RapporEncoder createEncoder(RapporConfig rapporConfig, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createEncoder", $$robo$$android_privacy_internal_rappor_RapporEncoder$createEncoder(android.privacy.internal.rappor.RapporConfig byte[] ), 0, (RapporConfig)rapporConfig, (byte[])byArray);
    }

    public static RapporEncoder createInsecureEncoderForTest(RapporConfig rapporConfig) {
        return InvokeDynamicSupport.bootstrapStatic("createInsecureEncoderForTest", $$robo$$android_privacy_internal_rappor_RapporEncoder$createInsecureEncoderForTest(android.privacy.internal.rappor.RapporConfig ), 0, (RapporConfig)rapporConfig);
    }

    @Override
    public byte[] encodeString(String string2) {
        return InvokeDynamicSupport.bootstrap("encodeString", $$robo$$android_privacy_internal_rappor_RapporEncoder$encodeString(java.lang.String ), 0, this, string2);
    }

    @Override
    public byte[] encodeBoolean(boolean bl) {
        return InvokeDynamicSupport.bootstrap("encodeBoolean", $$robo$$android_privacy_internal_rappor_RapporEncoder$encodeBoolean(boolean ), 0, this, bl);
    }

    @Override
    public byte[] encodeBits(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("encodeBits", $$robo$$android_privacy_internal_rappor_RapporEncoder$encodeBits(byte[] ), 0, this, byArray);
    }

    @Override
    public RapporConfig getConfig() {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_privacy_internal_rappor_RapporEncoder$getConfig(), 0, this);
    }

    @Override
    public boolean isInsecureEncoderForTest() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInsecureEncoderForTest", $$robo$$android_privacy_internal_rappor_RapporEncoder$isInsecureEncoderForTest(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(RapporEncoder.class);
    }

    public /* synthetic */ RapporEncoder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RapporEncoder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

