/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.graphics.Typeface;
import android.graphics.fonts.FontVariationAxis;
import android.net.Uri;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelFileDescriptor;
import android.provider.BaseColumns;
import android.provider.FontRequest;
import android.util.Log;
import android.util.LruCache;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FontsContract
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FontsContract";
    private static Object sLock;
    @GuardedBy(value="sLock")
    private static Handler sHandler;
    @GuardedBy(value="sLock")
    private static HandlerThread sThread;
    @GuardedBy(value="sLock")
    private static Set<String> sInQueueSet;
    private static volatile Context sContext;
    private static LruCache<String, Typeface> sTypefaceCache;
    private static int THREAD_RENEWAL_THRESHOLD_MS = 10000;
    private static long SYNC_FONT_FETCH_TIMEOUT_MS = 500L;
    private static Runnable sReplaceDispatcherThreadRunnable;
    private static Comparator<byte[]> sByteArrayComparator;

    private void $$robo$$android_provider_FontsContract$__constructor__() {
    }

    private static final void $$robo$$android_provider_FontsContract$setApplicationContextForResources(Context context) {
        sContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Typeface $$robo$$android_provider_FontsContract$getFontSync(FontRequest request) {
        String id2 = request.getIdentifier();
        Typeface cachedTypeface = sTypefaceCache.get(id2);
        if (cachedTypeface != null) {
            return cachedTypeface;
        }
        Object object = sLock;
        synchronized (object) {
            if (sHandler == null) {
                sThread = new HandlerThread("fonts", 10);
                sThread.start();
                sHandler = new Handler(sThread.getLooper());
            }
            ReentrantLock lock = new ReentrantLock();
            Condition cond = lock.newCondition();
            AtomicReference holder = new AtomicReference();
            AtomicBoolean waiting = new AtomicBoolean(true);
            AtomicBoolean timeout = new AtomicBoolean(false);
            sHandler.post(() -> {
                try {
                    FontFamilyResult result = FontsContract.fetchFonts(sContext, null, request);
                    if (result.getStatusCode() == 0) {
                        Typeface typeface = FontsContract.buildTypeface(sContext, null, result.getFonts());
                        if (typeface != null) {
                            sTypefaceCache.put(id2, typeface);
                        }
                        holder.set(typeface);
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                lock.lock();
                try {
                    if (!timeout.get()) {
                        waiting.set(false);
                        cond.signal();
                    }
                }
                finally {
                    lock.unlock();
                }
            });
            sHandler.removeCallbacks(sReplaceDispatcherThreadRunnable);
            sHandler.postDelayed(sReplaceDispatcherThreadRunnable, 10000L);
            long remaining = TimeUnit.MILLISECONDS.toNanos(500L);
            lock.lock();
            try {
                if (!waiting.get()) {
                    Typeface typeface = (Typeface)holder.get();
                    return typeface;
                }
                do {
                    try {
                        remaining = cond.awaitNanos(remaining);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (waiting.get()) continue;
                    Typeface typeface = (Typeface)holder.get();
                    return typeface;
                } while (remaining > 0L);
                timeout.set(true);
                Log.w("FontsContract", "Remote font fetch timed out: " + request.getProviderAuthority() + "/" + request.getQuery());
                Typeface typeface = null;
                return typeface;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static final void $$robo$$android_provider_FontsContract$requestFonts(Context context, FontRequest request, Handler handler, CancellationSignal cancellationSignal, FontRequestCallback callback) {
        Handler callerThreadHandler = new Handler();
        Typeface cachedTypeface = sTypefaceCache.get(request.getIdentifier());
        if (cachedTypeface != null) {
            callerThreadHandler.post(() -> callback.onTypefaceRetrieved(cachedTypeface));
            return;
        }
        handler.post(() -> {
            FontFamilyResult result;
            try {
                result = FontsContract.fetchFonts(context, cancellationSignal, request);
            }
            catch (PackageManager.NameNotFoundException e) {
                callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-1));
                return;
            }
            Typeface anotherCachedTypeface = sTypefaceCache.get(request.getIdentifier());
            if (anotherCachedTypeface != null) {
                callerThreadHandler.post(() -> callback.onTypefaceRetrieved(anotherCachedTypeface));
                return;
            }
            if (result.getStatusCode() != 0) {
                switch (result.getStatusCode()) {
                    case 1: {
                        callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-2));
                        return;
                    }
                    case 2: {
                        callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-3));
                        return;
                    }
                }
                callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-3));
                return;
            }
            FontInfo[] fonts = result.getFonts();
            if (fonts == null || fonts.length == 0) {
                callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(1));
                return;
            }
            for (FontInfo font : fonts) {
                if (font.getResultCode() == 0) continue;
                int resultCode = font.getResultCode();
                if (resultCode < 0) {
                    callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-3));
                } else {
                    callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(resultCode));
                }
                return;
            }
            Typeface typeface = FontsContract.buildTypeface(context, cancellationSignal, fonts);
            if (typeface == null) {
                callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-3));
                return;
            }
            sTypefaceCache.put(request.getIdentifier(), typeface);
            callerThreadHandler.post(() -> callback.onTypefaceRetrieved(typeface));
        });
    }

    private static final FontFamilyResult $$robo$$android_provider_FontsContract$fetchFonts(Context context, CancellationSignal cancellationSignal, FontRequest request) throws PackageManager.NameNotFoundException {
        if (context.isRestricted()) {
            return new FontFamilyResult(3, null);
        }
        ProviderInfo providerInfo = FontsContract.getProvider(context.getPackageManager(), request);
        if (providerInfo == null) {
            return new FontFamilyResult(1, null);
        }
        try {
            FontInfo[] fonts = FontsContract.getFontFromProvider(context, request, providerInfo.authority, cancellationSignal);
            return new FontFamilyResult(0, fonts);
        }
        catch (IllegalArgumentException e) {
            return new FontFamilyResult(2, null);
        }
    }

    private static final Typeface $$robo$$android_provider_FontsContract$buildTypeface(Context context, CancellationSignal cancellationSignal, FontInfo[] fonts) {
        if (context.isRestricted()) {
            return null;
        }
        Map<Uri, ByteBuffer> uriBuffer = FontsContract.prepareFontData(context, fonts, cancellationSignal);
        if (uriBuffer.isEmpty()) {
            return null;
        }
        return new Typeface.Builder(fonts, uriBuffer).build();
    }

    private static final Map<Uri, ByteBuffer> $$robo$$android_provider_FontsContract$prepareFontData(Context context, FontInfo[] fonts, CancellationSignal cancellationSignal) {
        HashMap<Uri, MappedByteBuffer> out = new HashMap<Uri, MappedByteBuffer>();
        ContentResolver resolver = context.getContentResolver();
        for (FontInfo font : fonts) {
            MappedByteBuffer buffer;
            Uri uri;
            block16: {
                if (font.getResultCode() != 0 || out.containsKey(uri = font.getUri())) continue;
                buffer = null;
                try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(uri, "r", cancellationSignal);){
                    if (pfd == null) break block16;
                    try (FileInputStream fis = new FileInputStream(pfd.getFileDescriptor());){
                        FileChannel fileChannel = fis.getChannel();
                        long size = fileChannel.size();
                        buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            out.put(uri, buffer);
        }
        return Collections.unmodifiableMap(out);
    }

    @VisibleForTesting
    private static final ProviderInfo $$robo$$android_provider_FontsContract$getProvider(PackageManager packageManager, FontRequest request) throws PackageManager.NameNotFoundException {
        String providerAuthority = request.getProviderAuthority();
        ProviderInfo info = packageManager.resolveContentProvider(providerAuthority, 0);
        if (info == null) {
            throw new PackageManager.NameNotFoundException("No package found for authority: " + providerAuthority);
        }
        if (!info.packageName.equals(request.getProviderPackage())) {
            throw new PackageManager.NameNotFoundException("Found content provider " + providerAuthority + ", but package was not " + request.getProviderPackage());
        }
        if (info.applicationInfo.isSystemApp()) {
            return info;
        }
        PackageInfo packageInfo = packageManager.getPackageInfo(info.packageName, 64);
        List<byte[]> signatures = FontsContract.convertToByteArrayList(packageInfo.signatures);
        Collections.sort(signatures, sByteArrayComparator);
        List<List<byte[]>> requestCertificatesList = request.getCertificates();
        for (int i = 0; i < requestCertificatesList.size(); ++i) {
            ArrayList<byte[]> requestSignatures = new ArrayList<byte[]>((Collection)requestCertificatesList.get(i));
            Collections.sort(requestSignatures, sByteArrayComparator);
            if (!FontsContract.equalsByteArrayList(signatures, requestSignatures)) continue;
            return info;
        }
        return null;
    }

    private static final boolean $$robo$$android_provider_FontsContract$equalsByteArrayList(List<byte[]> signatures, List<byte[]> requestSignatures) {
        if (signatures.size() != requestSignatures.size()) {
            return false;
        }
        for (int i = 0; i < signatures.size(); ++i) {
            if (Arrays.equals(signatures.get(i), requestSignatures.get(i))) continue;
            return false;
        }
        return true;
    }

    private static final List<byte[]> $$robo$$android_provider_FontsContract$convertToByteArrayList(Signature[] signatures) {
        ArrayList<byte[]> shas = new ArrayList<byte[]>();
        for (int i = 0; i < signatures.length; ++i) {
            shas.add(signatures[i].toByteArray());
        }
        return shas;
    }

    @VisibleForTesting
    private static final FontInfo[] $$robo$$android_provider_FontsContract$getFontFromProvider(Context context, FontRequest request, String authority, CancellationSignal cancellationSignal) {
        ArrayList<FontInfo> result = new ArrayList<FontInfo>();
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        Uri fileBaseUri = new Uri.Builder().scheme("content").authority(authority).appendPath("file").build();
        try (Cursor cursor = context.getContentResolver().query(uri, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{request.getQuery()}, null, cancellationSignal);){
            if (cursor != null && cursor.getCount() > 0) {
                int resultCodeColumnIndex = cursor.getColumnIndex("result_code");
                result = new ArrayList();
                int idColumnIndex = cursor.getColumnIndexOrThrow("_id");
                int fileIdColumnIndex = cursor.getColumnIndex("file_id");
                int ttcIndexColumnIndex = cursor.getColumnIndex("font_ttc_index");
                int vsColumnIndex = cursor.getColumnIndex("font_variation_settings");
                int weightColumnIndex = cursor.getColumnIndex("font_weight");
                int italicColumnIndex = cursor.getColumnIndex("font_italic");
                while (cursor.moveToNext()) {
                    boolean italic;
                    int weight;
                    Uri fileUri;
                    long id2;
                    String variationSettings;
                    int resultCode = resultCodeColumnIndex != -1 ? cursor.getInt(resultCodeColumnIndex) : 0;
                    int ttcIndex = ttcIndexColumnIndex != -1 ? cursor.getInt(ttcIndexColumnIndex) : 0;
                    String string2 = variationSettings = vsColumnIndex != -1 ? cursor.getString(vsColumnIndex) : null;
                    if (fileIdColumnIndex == -1) {
                        id2 = cursor.getLong(idColumnIndex);
                        fileUri = ContentUris.withAppendedId(uri, id2);
                    } else {
                        id2 = cursor.getLong(fileIdColumnIndex);
                        fileUri = ContentUris.withAppendedId(fileBaseUri, id2);
                    }
                    if (weightColumnIndex != -1 && italicColumnIndex != -1) {
                        weight = cursor.getInt(weightColumnIndex);
                        italic = cursor.getInt(italicColumnIndex) == 1;
                    } else {
                        weight = 400;
                        italic = false;
                    }
                    FontVariationAxis[] axes = FontVariationAxis.fromFontVariationSettings(variationSettings);
                    result.add(new FontInfo(fileUri, ttcIndex, axes, weight, italic, resultCode));
                }
            }
        }
        return result.toArray(new FontInfo[0]);
    }

    static void __staticInitializer__() {
        sLock = new Object();
        sTypefaceCache = new LruCache(16);
        sReplaceDispatcherThreadRunnable = new Runnable(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_provider_FontsContract_1$__constructor__() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_provider_FontsContract_1$run() {
                Object object = sLock;
                synchronized (object) {
                    if (sThread != null) {
                        sThread.quitSafely();
                        sThread = null;
                        sHandler = null;
                    }
                }
            }

            private void __constructor__() {
                this.$$robo$$android_provider_FontsContract_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_FontsContract_1$__constructor__(), 0, this);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_provider_FontsContract_1$run(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sByteArrayComparator = (l, r) -> {
            if (((byte[])l).length != ((byte[])r).length) {
                return ((byte[])l).length - ((byte[])r).length;
            }
            for (int i = 0; i < ((byte[])l).length; ++i) {
                if (l[i] == r[i]) continue;
                return l[i] - r[i];
            }
            return 0;
        };
    }

    private void __constructor__() {
        this.$$robo$$android_provider_FontsContract$__constructor__();
    }

    private FontsContract() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_FontsContract$__constructor__(), 0, this);
    }

    public static void setApplicationContextForResources(Context context) {
        InvokeDynamicSupport.bootstrapStatic("setApplicationContextForResources", $$robo$$android_provider_FontsContract$setApplicationContextForResources(android.content.Context ), 0, (Context)context);
    }

    public static Typeface getFontSync(FontRequest fontRequest) {
        return InvokeDynamicSupport.bootstrapStatic("getFontSync", $$robo$$android_provider_FontsContract$getFontSync(android.provider.FontRequest ), 0, (FontRequest)fontRequest);
    }

    public static void requestFonts(Context context, FontRequest fontRequest, Handler handler, CancellationSignal cancellationSignal, FontRequestCallback fontRequestCallback) {
        InvokeDynamicSupport.bootstrapStatic("requestFonts", $$robo$$android_provider_FontsContract$requestFonts(android.content.Context android.provider.FontRequest android.os.Handler android.os.CancellationSignal android.provider.FontsContract$FontRequestCallback ), 0, (Context)context, (FontRequest)fontRequest, (Handler)handler, (CancellationSignal)cancellationSignal, (FontRequestCallback)fontRequestCallback);
    }

    public static FontFamilyResult fetchFonts(Context context, CancellationSignal cancellationSignal, FontRequest fontRequest) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("fetchFonts", $$robo$$android_provider_FontsContract$fetchFonts(android.content.Context android.os.CancellationSignal android.provider.FontRequest ), 0, (Context)context, (CancellationSignal)cancellationSignal, (FontRequest)fontRequest);
    }

    public static Typeface buildTypeface(Context context, CancellationSignal cancellationSignal, FontInfo[] fontInfoArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildTypeface", $$robo$$android_provider_FontsContract$buildTypeface(android.content.Context android.os.CancellationSignal android.provider.FontsContract$FontInfo[] ), 0, (Context)context, (CancellationSignal)cancellationSignal, (FontInfo[])fontInfoArray);
    }

    private static Map<Uri, ByteBuffer> prepareFontData(Context context, FontInfo[] fontInfoArray, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrapStatic("prepareFontData", $$robo$$android_provider_FontsContract$prepareFontData(android.content.Context android.provider.FontsContract$FontInfo[] android.os.CancellationSignal ), 0, (Context)context, (FontInfo[])fontInfoArray, (CancellationSignal)cancellationSignal);
    }

    public static ProviderInfo getProvider(PackageManager packageManager, FontRequest fontRequest) throws PackageManager.NameNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getProvider", $$robo$$android_provider_FontsContract$getProvider(android.content.pm.PackageManager android.provider.FontRequest ), 0, (PackageManager)packageManager, (FontRequest)fontRequest);
    }

    private static boolean equalsByteArrayList(List<byte[]> list, List<byte[]> list2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equalsByteArrayList", $$robo$$android_provider_FontsContract$equalsByteArrayList(java.util.List<byte[]> java.util.List<byte[]> ), 0, list, list2);
    }

    private static List<byte[]> convertToByteArrayList(Signature[] signatureArray) {
        return InvokeDynamicSupport.bootstrapStatic("convertToByteArrayList", $$robo$$android_provider_FontsContract$convertToByteArrayList(android.content.pm.Signature[] ), 0, (Signature[])signatureArray);
    }

    public static FontInfo[] getFontFromProvider(Context context, FontRequest fontRequest, String string2, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrapStatic("getFontFromProvider", $$robo$$android_provider_FontsContract$getFontFromProvider(android.content.Context android.provider.FontRequest java.lang.String android.os.CancellationSignal ), 0, (Context)context, (FontRequest)fontRequest, (String)string2, (CancellationSignal)cancellationSignal);
    }

    static {
        RobolectricInternals.classInitializing(FontsContract.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontsContract)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class FontRequestCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int FAIL_REASON_PROVIDER_NOT_FOUND = -1;
        public static int FAIL_REASON_WRONG_CERTIFICATES = -2;
        public static int FAIL_REASON_FONT_LOAD_ERROR = -3;
        public static int FAIL_REASON_FONT_NOT_FOUND = 1;
        public static int FAIL_REASON_FONT_UNAVAILABLE = 2;
        public static int FAIL_REASON_MALFORMED_QUERY = 3;

        private void $$robo$$android_provider_FontsContract_FontRequestCallback$__constructor__() {
        }

        private final void $$robo$$android_provider_FontsContract_FontRequestCallback$onTypefaceRetrieved(Typeface typeface) {
        }

        private final void $$robo$$android_provider_FontsContract_FontRequestCallback$onTypefaceRequestFailed(int reason) {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_FontsContract_FontRequestCallback$__constructor__();
        }

        public FontRequestCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_FontsContract_FontRequestCallback$__constructor__(), 0, this);
        }

        public void onTypefaceRetrieved(Typeface typeface) {
            InvokeDynamicSupport.bootstrap("onTypefaceRetrieved", $$robo$$android_provider_FontsContract_FontRequestCallback$onTypefaceRetrieved(android.graphics.Typeface ), 0, this, typeface);
        }

        public void onTypefaceRequestFailed(int n) {
            InvokeDynamicSupport.bootstrap("onTypefaceRequestFailed", $$robo$$android_provider_FontsContract_FontRequestCallback$onTypefaceRequestFailed(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontRequestCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface FontRequestFailReason {
        }
    }

    public static class FontFamilyResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int STATUS_OK = 0;
        public static int STATUS_WRONG_CERTIFICATES = 1;
        public static int STATUS_UNEXPECTED_DATA_PROVIDED = 2;
        public static int STATUS_REJECTED = 3;
        private int mStatusCode;
        private FontInfo[] mFonts;

        private void $$robo$$android_provider_FontsContract_FontFamilyResult$__constructor__(int statusCode, FontInfo[] fonts) {
            this.mStatusCode = statusCode;
            this.mFonts = fonts;
        }

        private final int $$robo$$android_provider_FontsContract_FontFamilyResult$getStatusCode() {
            return this.mStatusCode;
        }

        private final FontInfo[] $$robo$$android_provider_FontsContract_FontFamilyResult$getFonts() {
            return this.mFonts;
        }

        private void __constructor__(int n, FontInfo[] fontInfoArray) {
            this.$$robo$$android_provider_FontsContract_FontFamilyResult$__constructor__(n, fontInfoArray);
        }

        public FontFamilyResult(int n, FontInfo[] fontInfoArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_FontsContract_FontFamilyResult$__constructor__(int android.provider.FontsContract$FontInfo[] ), 0, this, n, fontInfoArray);
        }

        public int getStatusCode() {
            return (int)InvokeDynamicSupport.bootstrap("getStatusCode", $$robo$$android_provider_FontsContract_FontFamilyResult$getStatusCode(), 0, this);
        }

        public FontInfo[] getFonts() {
            return InvokeDynamicSupport.bootstrap("getFonts", $$robo$$android_provider_FontsContract_FontFamilyResult$getFonts(), 0, this);
        }

        public /* synthetic */ FontFamilyResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontFamilyResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface FontResultStatus {
        }
    }

    public static class FontInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Uri mUri;
        private int mTtcIndex;
        private FontVariationAxis[] mAxes;
        private int mWeight;
        private boolean mItalic;
        private int mResultCode;

        private void $$robo$$android_provider_FontsContract_FontInfo$__constructor__(Uri uri, int ttcIndex, FontVariationAxis[] axes, int weight, boolean italic, int resultCode) {
            this.mUri = Preconditions.checkNotNull(uri);
            this.mTtcIndex = ttcIndex;
            this.mAxes = axes;
            this.mWeight = weight;
            this.mItalic = italic;
            this.mResultCode = resultCode;
        }

        private final Uri $$robo$$android_provider_FontsContract_FontInfo$getUri() {
            return this.mUri;
        }

        private final int $$robo$$android_provider_FontsContract_FontInfo$getTtcIndex() {
            return this.mTtcIndex;
        }

        private final FontVariationAxis[] $$robo$$android_provider_FontsContract_FontInfo$getAxes() {
            return this.mAxes;
        }

        private final int $$robo$$android_provider_FontsContract_FontInfo$getWeight() {
            return this.mWeight;
        }

        private final boolean $$robo$$android_provider_FontsContract_FontInfo$isItalic() {
            return this.mItalic;
        }

        private final int $$robo$$android_provider_FontsContract_FontInfo$getResultCode() {
            return this.mResultCode;
        }

        private void __constructor__(Uri uri, int n, FontVariationAxis[] fontVariationAxisArray, int n2, boolean bl, int n3) {
            this.$$robo$$android_provider_FontsContract_FontInfo$__constructor__(uri, n, fontVariationAxisArray, n2, bl, n3);
        }

        public FontInfo(Uri uri, int n, FontVariationAxis[] fontVariationAxisArray, int n2, boolean bl, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_FontsContract_FontInfo$__constructor__(android.net.Uri int android.graphics.fonts.FontVariationAxis[] int boolean int ), 0, this, uri, n, fontVariationAxisArray, n2, bl, n3);
        }

        public Uri getUri() {
            return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_provider_FontsContract_FontInfo$getUri(), 0, this);
        }

        public int getTtcIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getTtcIndex", $$robo$$android_provider_FontsContract_FontInfo$getTtcIndex(), 0, this);
        }

        public FontVariationAxis[] getAxes() {
            return InvokeDynamicSupport.bootstrap("getAxes", $$robo$$android_provider_FontsContract_FontInfo$getAxes(), 0, this);
        }

        public int getWeight() {
            return (int)InvokeDynamicSupport.bootstrap("getWeight", $$robo$$android_provider_FontsContract_FontInfo$getWeight(), 0, this);
        }

        public boolean isItalic() {
            return (boolean)InvokeDynamicSupport.bootstrap("isItalic", $$robo$$android_provider_FontsContract_FontInfo$isItalic(), 0, this);
        }

        public int getResultCode() {
            return (int)InvokeDynamicSupport.bootstrap("getResultCode", $$robo$$android_provider_FontsContract_FontInfo$getResultCode(), 0, this);
        }

        public /* synthetic */ FontInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Columns
    implements BaseColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String FILE_ID = "file_id";
        public static String TTC_INDEX = "font_ttc_index";
        public static String VARIATION_SETTINGS = "font_variation_settings";
        public static String WEIGHT = "font_weight";
        public static String ITALIC = "font_italic";
        public static String RESULT_CODE = "result_code";
        public static int RESULT_CODE_OK = 0;
        public static int RESULT_CODE_FONT_NOT_FOUND = 1;
        public static int RESULT_CODE_FONT_UNAVAILABLE = 2;
        public static int RESULT_CODE_MALFORMED_QUERY = 3;

        private void $$robo$$android_provider_FontsContract_Columns$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_FontsContract_Columns$__constructor__();
        }

        private Columns() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_FontsContract_Columns$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Columns)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

