/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Element
extends BaseObj
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    int mSize;
    Element[] mElements;
    String[] mElementNames;
    int[] mArraySizes;
    int[] mOffsetInBytes;
    int[] mVisibleElementMap;
    DataType mType;
    DataKind mKind;
    boolean mNormalized;
    int mVectorSize;

    private final void $$robo$$android_renderscript_Element$updateVisibleSubElements() {
        int ct;
        if (this.mElements == null) {
            return;
        }
        int noPaddingFieldCount = 0;
        int fieldCount = this.mElementNames.length;
        for (ct = 0; ct < fieldCount; ++ct) {
            if (this.mElementNames[ct].charAt(0) == '#') continue;
            ++noPaddingFieldCount;
        }
        this.mVisibleElementMap = new int[noPaddingFieldCount];
        int ctNoPadding = 0;
        for (ct = 0; ct < fieldCount; ++ct) {
            if (this.mElementNames[ct].charAt(0) == '#') continue;
            this.mVisibleElementMap[ctNoPadding++] = ct;
        }
    }

    private final int $$robo$$android_renderscript_Element$getBytesSize() {
        return this.mSize;
    }

    private final int $$robo$$android_renderscript_Element$getVectorSize() {
        return this.mVectorSize;
    }

    private final boolean $$robo$$android_renderscript_Element$isComplex() {
        if (this.mElements == null) {
            return false;
        }
        for (int ct = 0; ct < this.mElements.length; ++ct) {
            if (this.mElements[ct].mElements == null) continue;
            return true;
        }
        return false;
    }

    private final int $$robo$$android_renderscript_Element$getSubElementCount() {
        if (this.mVisibleElementMap == null) {
            return 0;
        }
        return this.mVisibleElementMap.length;
    }

    private final Element $$robo$$android_renderscript_Element$getSubElement(int index) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (index < 0 || index >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mElements[this.mVisibleElementMap[index]];
    }

    private final String $$robo$$android_renderscript_Element$getSubElementName(int index) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (index < 0 || index >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mElementNames[this.mVisibleElementMap[index]];
    }

    private final int $$robo$$android_renderscript_Element$getSubElementArraySize(int index) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (index < 0 || index >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mArraySizes[this.mVisibleElementMap[index]];
    }

    private final int $$robo$$android_renderscript_Element$getSubElementOffsetBytes(int index) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (index < 0 || index >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mOffsetInBytes[this.mVisibleElementMap[index]];
    }

    private final DataType $$robo$$android_renderscript_Element$getDataType() {
        return this.mType;
    }

    private final DataKind $$robo$$android_renderscript_Element$getDataKind() {
        return this.mKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$BOOLEAN(RenderScript rs) {
        if (rs.mElement_BOOLEAN == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_BOOLEAN == null) {
                    rs.mElement_BOOLEAN = Element.createUser(rs, DataType.BOOLEAN);
                }
            }
        }
        return rs.mElement_BOOLEAN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U8(RenderScript rs) {
        if (rs.mElement_U8 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_U8 == null) {
                    rs.mElement_U8 = Element.createUser(rs, DataType.UNSIGNED_8);
                }
            }
        }
        return rs.mElement_U8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I8(RenderScript rs) {
        if (rs.mElement_I8 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_I8 == null) {
                    rs.mElement_I8 = Element.createUser(rs, DataType.SIGNED_8);
                }
            }
        }
        return rs.mElement_I8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U16(RenderScript rs) {
        if (rs.mElement_U16 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_U16 == null) {
                    rs.mElement_U16 = Element.createUser(rs, DataType.UNSIGNED_16);
                }
            }
        }
        return rs.mElement_U16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I16(RenderScript rs) {
        if (rs.mElement_I16 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_I16 == null) {
                    rs.mElement_I16 = Element.createUser(rs, DataType.SIGNED_16);
                }
            }
        }
        return rs.mElement_I16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U32(RenderScript rs) {
        if (rs.mElement_U32 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_U32 == null) {
                    rs.mElement_U32 = Element.createUser(rs, DataType.UNSIGNED_32);
                }
            }
        }
        return rs.mElement_U32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I32(RenderScript rs) {
        if (rs.mElement_I32 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_I32 == null) {
                    rs.mElement_I32 = Element.createUser(rs, DataType.SIGNED_32);
                }
            }
        }
        return rs.mElement_I32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U64(RenderScript rs) {
        if (rs.mElement_U64 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_U64 == null) {
                    rs.mElement_U64 = Element.createUser(rs, DataType.UNSIGNED_64);
                }
            }
        }
        return rs.mElement_U64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I64(RenderScript rs) {
        if (rs.mElement_I64 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_I64 == null) {
                    rs.mElement_I64 = Element.createUser(rs, DataType.SIGNED_64);
                }
            }
        }
        return rs.mElement_I64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F16(RenderScript rs) {
        if (rs.mElement_F16 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_F16 == null) {
                    rs.mElement_F16 = Element.createUser(rs, DataType.FLOAT_16);
                }
            }
        }
        return rs.mElement_F16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F32(RenderScript rs) {
        if (rs.mElement_F32 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_F32 == null) {
                    rs.mElement_F32 = Element.createUser(rs, DataType.FLOAT_32);
                }
            }
        }
        return rs.mElement_F32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F64(RenderScript rs) {
        if (rs.mElement_F64 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_F64 == null) {
                    rs.mElement_F64 = Element.createUser(rs, DataType.FLOAT_64);
                }
            }
        }
        return rs.mElement_F64;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$ELEMENT(RenderScript rs) {
        if (rs.mElement_ELEMENT == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ELEMENT == null) {
                    rs.mElement_ELEMENT = Element.createUser(rs, DataType.RS_ELEMENT);
                }
            }
        }
        return rs.mElement_ELEMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$TYPE(RenderScript rs) {
        if (rs.mElement_TYPE == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_TYPE == null) {
                    rs.mElement_TYPE = Element.createUser(rs, DataType.RS_TYPE);
                }
            }
        }
        return rs.mElement_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$ALLOCATION(RenderScript rs) {
        if (rs.mElement_ALLOCATION == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ALLOCATION == null) {
                    rs.mElement_ALLOCATION = Element.createUser(rs, DataType.RS_ALLOCATION);
                }
            }
        }
        return rs.mElement_ALLOCATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$SAMPLER(RenderScript rs) {
        if (rs.mElement_SAMPLER == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SAMPLER == null) {
                    rs.mElement_SAMPLER = Element.createUser(rs, DataType.RS_SAMPLER);
                }
            }
        }
        return rs.mElement_SAMPLER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$SCRIPT(RenderScript rs) {
        if (rs.mElement_SCRIPT == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SCRIPT == null) {
                    rs.mElement_SCRIPT = Element.createUser(rs, DataType.RS_SCRIPT);
                }
            }
        }
        return rs.mElement_SCRIPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$MESH(RenderScript rs) {
        if (rs.mElement_MESH == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_MESH == null) {
                    rs.mElement_MESH = Element.createUser(rs, DataType.RS_MESH);
                }
            }
        }
        return rs.mElement_MESH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$PROGRAM_FRAGMENT(RenderScript rs) {
        if (rs.mElement_PROGRAM_FRAGMENT == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_PROGRAM_FRAGMENT == null) {
                    rs.mElement_PROGRAM_FRAGMENT = Element.createUser(rs, DataType.RS_PROGRAM_FRAGMENT);
                }
            }
        }
        return rs.mElement_PROGRAM_FRAGMENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$PROGRAM_VERTEX(RenderScript rs) {
        if (rs.mElement_PROGRAM_VERTEX == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_PROGRAM_VERTEX == null) {
                    rs.mElement_PROGRAM_VERTEX = Element.createUser(rs, DataType.RS_PROGRAM_VERTEX);
                }
            }
        }
        return rs.mElement_PROGRAM_VERTEX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$PROGRAM_RASTER(RenderScript rs) {
        if (rs.mElement_PROGRAM_RASTER == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_PROGRAM_RASTER == null) {
                    rs.mElement_PROGRAM_RASTER = Element.createUser(rs, DataType.RS_PROGRAM_RASTER);
                }
            }
        }
        return rs.mElement_PROGRAM_RASTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$PROGRAM_STORE(RenderScript rs) {
        if (rs.mElement_PROGRAM_STORE == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_PROGRAM_STORE == null) {
                    rs.mElement_PROGRAM_STORE = Element.createUser(rs, DataType.RS_PROGRAM_STORE);
                }
            }
        }
        return rs.mElement_PROGRAM_STORE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$FONT(RenderScript rs) {
        if (rs.mElement_FONT == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_FONT == null) {
                    rs.mElement_FONT = Element.createUser(rs, DataType.RS_FONT);
                }
            }
        }
        return rs.mElement_FONT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$A_8(RenderScript rs) {
        if (rs.mElement_A_8 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_A_8 == null) {
                    rs.mElement_A_8 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_A);
                }
            }
        }
        return rs.mElement_A_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$RGB_565(RenderScript rs) {
        if (rs.mElement_RGB_565 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGB_565 == null) {
                    rs.mElement_RGB_565 = Element.createPixel(rs, DataType.UNSIGNED_5_6_5, DataKind.PIXEL_RGB);
                }
            }
        }
        return rs.mElement_RGB_565;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$RGB_888(RenderScript rs) {
        if (rs.mElement_RGB_888 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGB_888 == null) {
                    rs.mElement_RGB_888 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_RGB);
                }
            }
        }
        return rs.mElement_RGB_888;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$RGBA_5551(RenderScript rs) {
        if (rs.mElement_RGBA_5551 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGBA_5551 == null) {
                    rs.mElement_RGBA_5551 = Element.createPixel(rs, DataType.UNSIGNED_5_5_5_1, DataKind.PIXEL_RGBA);
                }
            }
        }
        return rs.mElement_RGBA_5551;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$RGBA_4444(RenderScript rs) {
        if (rs.mElement_RGBA_4444 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGBA_4444 == null) {
                    rs.mElement_RGBA_4444 = Element.createPixel(rs, DataType.UNSIGNED_4_4_4_4, DataKind.PIXEL_RGBA);
                }
            }
        }
        return rs.mElement_RGBA_4444;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$RGBA_8888(RenderScript rs) {
        if (rs.mElement_RGBA_8888 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_RGBA_8888 == null) {
                    rs.mElement_RGBA_8888 = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_RGBA);
                }
            }
        }
        return rs.mElement_RGBA_8888;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F16_2(RenderScript rs) {
        if (rs.mElement_HALF_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_HALF_2 == null) {
                    rs.mElement_HALF_2 = Element.createVector(rs, DataType.FLOAT_16, 2);
                }
            }
        }
        return rs.mElement_HALF_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F16_3(RenderScript rs) {
        if (rs.mElement_HALF_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_HALF_3 == null) {
                    rs.mElement_HALF_3 = Element.createVector(rs, DataType.FLOAT_16, 3);
                }
            }
        }
        return rs.mElement_HALF_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F16_4(RenderScript rs) {
        if (rs.mElement_HALF_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_HALF_4 == null) {
                    rs.mElement_HALF_4 = Element.createVector(rs, DataType.FLOAT_16, 4);
                }
            }
        }
        return rs.mElement_HALF_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F32_2(RenderScript rs) {
        if (rs.mElement_FLOAT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_FLOAT_2 == null) {
                    rs.mElement_FLOAT_2 = Element.createVector(rs, DataType.FLOAT_32, 2);
                }
            }
        }
        return rs.mElement_FLOAT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F32_3(RenderScript rs) {
        if (rs.mElement_FLOAT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_FLOAT_3 == null) {
                    rs.mElement_FLOAT_3 = Element.createVector(rs, DataType.FLOAT_32, 3);
                }
            }
        }
        return rs.mElement_FLOAT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F32_4(RenderScript rs) {
        if (rs.mElement_FLOAT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_FLOAT_4 == null) {
                    rs.mElement_FLOAT_4 = Element.createVector(rs, DataType.FLOAT_32, 4);
                }
            }
        }
        return rs.mElement_FLOAT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F64_2(RenderScript rs) {
        if (rs.mElement_DOUBLE_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_DOUBLE_2 == null) {
                    rs.mElement_DOUBLE_2 = Element.createVector(rs, DataType.FLOAT_64, 2);
                }
            }
        }
        return rs.mElement_DOUBLE_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F64_3(RenderScript rs) {
        if (rs.mElement_DOUBLE_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_DOUBLE_3 == null) {
                    rs.mElement_DOUBLE_3 = Element.createVector(rs, DataType.FLOAT_64, 3);
                }
            }
        }
        return rs.mElement_DOUBLE_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$F64_4(RenderScript rs) {
        if (rs.mElement_DOUBLE_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_DOUBLE_4 == null) {
                    rs.mElement_DOUBLE_4 = Element.createVector(rs, DataType.FLOAT_64, 4);
                }
            }
        }
        return rs.mElement_DOUBLE_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U8_2(RenderScript rs) {
        if (rs.mElement_UCHAR_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UCHAR_2 == null) {
                    rs.mElement_UCHAR_2 = Element.createVector(rs, DataType.UNSIGNED_8, 2);
                }
            }
        }
        return rs.mElement_UCHAR_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U8_3(RenderScript rs) {
        if (rs.mElement_UCHAR_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UCHAR_3 == null) {
                    rs.mElement_UCHAR_3 = Element.createVector(rs, DataType.UNSIGNED_8, 3);
                }
            }
        }
        return rs.mElement_UCHAR_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U8_4(RenderScript rs) {
        if (rs.mElement_UCHAR_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UCHAR_4 == null) {
                    rs.mElement_UCHAR_4 = Element.createVector(rs, DataType.UNSIGNED_8, 4);
                }
            }
        }
        return rs.mElement_UCHAR_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I8_2(RenderScript rs) {
        if (rs.mElement_CHAR_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_CHAR_2 == null) {
                    rs.mElement_CHAR_2 = Element.createVector(rs, DataType.SIGNED_8, 2);
                }
            }
        }
        return rs.mElement_CHAR_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I8_3(RenderScript rs) {
        if (rs.mElement_CHAR_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_CHAR_3 == null) {
                    rs.mElement_CHAR_3 = Element.createVector(rs, DataType.SIGNED_8, 3);
                }
            }
        }
        return rs.mElement_CHAR_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I8_4(RenderScript rs) {
        if (rs.mElement_CHAR_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_CHAR_4 == null) {
                    rs.mElement_CHAR_4 = Element.createVector(rs, DataType.SIGNED_8, 4);
                }
            }
        }
        return rs.mElement_CHAR_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U16_2(RenderScript rs) {
        if (rs.mElement_USHORT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_USHORT_2 == null) {
                    rs.mElement_USHORT_2 = Element.createVector(rs, DataType.UNSIGNED_16, 2);
                }
            }
        }
        return rs.mElement_USHORT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U16_3(RenderScript rs) {
        if (rs.mElement_USHORT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_USHORT_3 == null) {
                    rs.mElement_USHORT_3 = Element.createVector(rs, DataType.UNSIGNED_16, 3);
                }
            }
        }
        return rs.mElement_USHORT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U16_4(RenderScript rs) {
        if (rs.mElement_USHORT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_USHORT_4 == null) {
                    rs.mElement_USHORT_4 = Element.createVector(rs, DataType.UNSIGNED_16, 4);
                }
            }
        }
        return rs.mElement_USHORT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I16_2(RenderScript rs) {
        if (rs.mElement_SHORT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SHORT_2 == null) {
                    rs.mElement_SHORT_2 = Element.createVector(rs, DataType.SIGNED_16, 2);
                }
            }
        }
        return rs.mElement_SHORT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I16_3(RenderScript rs) {
        if (rs.mElement_SHORT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SHORT_3 == null) {
                    rs.mElement_SHORT_3 = Element.createVector(rs, DataType.SIGNED_16, 3);
                }
            }
        }
        return rs.mElement_SHORT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I16_4(RenderScript rs) {
        if (rs.mElement_SHORT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_SHORT_4 == null) {
                    rs.mElement_SHORT_4 = Element.createVector(rs, DataType.SIGNED_16, 4);
                }
            }
        }
        return rs.mElement_SHORT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U32_2(RenderScript rs) {
        if (rs.mElement_UINT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UINT_2 == null) {
                    rs.mElement_UINT_2 = Element.createVector(rs, DataType.UNSIGNED_32, 2);
                }
            }
        }
        return rs.mElement_UINT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U32_3(RenderScript rs) {
        if (rs.mElement_UINT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UINT_3 == null) {
                    rs.mElement_UINT_3 = Element.createVector(rs, DataType.UNSIGNED_32, 3);
                }
            }
        }
        return rs.mElement_UINT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U32_4(RenderScript rs) {
        if (rs.mElement_UINT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_UINT_4 == null) {
                    rs.mElement_UINT_4 = Element.createVector(rs, DataType.UNSIGNED_32, 4);
                }
            }
        }
        return rs.mElement_UINT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I32_2(RenderScript rs) {
        if (rs.mElement_INT_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_INT_2 == null) {
                    rs.mElement_INT_2 = Element.createVector(rs, DataType.SIGNED_32, 2);
                }
            }
        }
        return rs.mElement_INT_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I32_3(RenderScript rs) {
        if (rs.mElement_INT_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_INT_3 == null) {
                    rs.mElement_INT_3 = Element.createVector(rs, DataType.SIGNED_32, 3);
                }
            }
        }
        return rs.mElement_INT_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I32_4(RenderScript rs) {
        if (rs.mElement_INT_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_INT_4 == null) {
                    rs.mElement_INT_4 = Element.createVector(rs, DataType.SIGNED_32, 4);
                }
            }
        }
        return rs.mElement_INT_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U64_2(RenderScript rs) {
        if (rs.mElement_ULONG_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ULONG_2 == null) {
                    rs.mElement_ULONG_2 = Element.createVector(rs, DataType.UNSIGNED_64, 2);
                }
            }
        }
        return rs.mElement_ULONG_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U64_3(RenderScript rs) {
        if (rs.mElement_ULONG_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ULONG_3 == null) {
                    rs.mElement_ULONG_3 = Element.createVector(rs, DataType.UNSIGNED_64, 3);
                }
            }
        }
        return rs.mElement_ULONG_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$U64_4(RenderScript rs) {
        if (rs.mElement_ULONG_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_ULONG_4 == null) {
                    rs.mElement_ULONG_4 = Element.createVector(rs, DataType.UNSIGNED_64, 4);
                }
            }
        }
        return rs.mElement_ULONG_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I64_2(RenderScript rs) {
        if (rs.mElement_LONG_2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_LONG_2 == null) {
                    rs.mElement_LONG_2 = Element.createVector(rs, DataType.SIGNED_64, 2);
                }
            }
        }
        return rs.mElement_LONG_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I64_3(RenderScript rs) {
        if (rs.mElement_LONG_3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_LONG_3 == null) {
                    rs.mElement_LONG_3 = Element.createVector(rs, DataType.SIGNED_64, 3);
                }
            }
        }
        return rs.mElement_LONG_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$I64_4(RenderScript rs) {
        if (rs.mElement_LONG_4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_LONG_4 == null) {
                    rs.mElement_LONG_4 = Element.createVector(rs, DataType.SIGNED_64, 4);
                }
            }
        }
        return rs.mElement_LONG_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$YUV(RenderScript rs) {
        if (rs.mElement_YUV == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_YUV == null) {
                    rs.mElement_YUV = Element.createPixel(rs, DataType.UNSIGNED_8, DataKind.PIXEL_YUV);
                }
            }
        }
        return rs.mElement_YUV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$MATRIX_4X4(RenderScript rs) {
        if (rs.mElement_MATRIX_4X4 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_MATRIX_4X4 == null) {
                    rs.mElement_MATRIX_4X4 = Element.createUser(rs, DataType.MATRIX_4X4);
                }
            }
        }
        return rs.mElement_MATRIX_4X4;
    }

    private static final Element $$robo$$android_renderscript_Element$MATRIX4X4(RenderScript rs) {
        return Element.MATRIX_4X4(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$MATRIX_3X3(RenderScript rs) {
        if (rs.mElement_MATRIX_3X3 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_MATRIX_3X3 == null) {
                    rs.mElement_MATRIX_3X3 = Element.createUser(rs, DataType.MATRIX_3X3);
                }
            }
        }
        return rs.mElement_MATRIX_3X3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element $$robo$$android_renderscript_Element$MATRIX_2X2(RenderScript rs) {
        if (rs.mElement_MATRIX_2X2 == null) {
            RenderScript renderScript = rs;
            synchronized (renderScript) {
                if (rs.mElement_MATRIX_2X2 == null) {
                    rs.mElement_MATRIX_2X2 = Element.createUser(rs, DataType.MATRIX_2X2);
                }
            }
        }
        return rs.mElement_MATRIX_2X2;
    }

    private void $$robo$$android_renderscript_Element$__constructor__(long id2, RenderScript rs, Element[] e, String[] n, int[] as) {
        this.mSize = 0;
        this.mVectorSize = 1;
        this.mElements = e;
        this.mElementNames = n;
        this.mArraySizes = as;
        this.mType = DataType.NONE;
        this.mKind = DataKind.USER;
        this.mOffsetInBytes = new int[this.mElements.length];
        for (int ct = 0; ct < this.mElements.length; ++ct) {
            this.mOffsetInBytes[ct] = this.mSize;
            this.mSize += this.mElements[ct].mSize * this.mArraySizes[ct];
        }
        this.updateVisibleSubElements();
    }

    private void $$robo$$android_renderscript_Element$__constructor__(long id2, RenderScript rs, DataType dt, DataKind dk, boolean norm, int size) {
        this.mSize = dt != DataType.UNSIGNED_5_6_5 && dt != DataType.UNSIGNED_4_4_4_4 && dt != DataType.UNSIGNED_5_5_5_1 ? (size == 3 ? dt.mSize * 4 : dt.mSize * size) : dt.mSize;
        this.mType = dt;
        this.mKind = dk;
        this.mNormalized = norm;
        this.mVectorSize = size;
    }

    private void $$robo$$android_renderscript_Element$__constructor__(long id2, RenderScript rs) {
    }

    private final void $$robo$$android_renderscript_Element$updateFromNative() {
        super.updateFromNative();
        int[] dataBuffer = new int[5];
        this.mRS.nElementGetNativeData(this.getID(this.mRS), dataBuffer);
        this.mNormalized = dataBuffer[2] == 1;
        this.mVectorSize = dataBuffer[3];
        this.mSize = 0;
        for (DataType dataType : DataType.values()) {
            if (dataType.mID != dataBuffer[0]) continue;
            this.mType = dataType;
            this.mSize = this.mType.mSize * this.mVectorSize;
        }
        for (Enum enum_ : DataKind.values()) {
            if (((DataKind)enum_).mID != dataBuffer[1]) continue;
            this.mKind = enum_;
        }
        int numSubElements = dataBuffer[4];
        if (numSubElements > 0) {
            this.mElements = new Element[numSubElements];
            this.mElementNames = new String[numSubElements];
            this.mArraySizes = new int[numSubElements];
            this.mOffsetInBytes = new int[numSubElements];
            long[] subElementIds = new long[numSubElements];
            this.mRS.nElementGetSubElements(this.getID(this.mRS), subElementIds, this.mElementNames, this.mArraySizes);
            for (int i = 0; i < numSubElements; ++i) {
                this.mElements[i] = new Element(subElementIds[i], this.mRS);
                this.mElements[i].updateFromNative();
                this.mOffsetInBytes[i] = this.mSize;
                this.mSize += this.mElements[i].mSize * this.mArraySizes[i];
            }
        }
        this.updateVisibleSubElements();
    }

    private static final Element $$robo$$android_renderscript_Element$createUser(RenderScript rs, DataType dt) {
        DataKind dk = DataKind.USER;
        boolean norm = false;
        int vecSize = 1;
        long id2 = rs.nElementCreate(dt.mID, dk.mID, norm, vecSize);
        return new Element(id2, rs, dt, dk, norm, vecSize);
    }

    private static final Element $$robo$$android_renderscript_Element$createVector(RenderScript rs, DataType dt, int size) {
        if (size < 2 || size > 4) {
            throw new RSIllegalArgumentException("Vector size out of range 2-4.");
        }
        switch (1.$SwitchMap$android$renderscript$Element$DataType[dt.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                DataKind dk = DataKind.USER;
                boolean norm = false;
                long id2 = rs.nElementCreate(dt.mID, dk.mID, norm, size);
                return new Element(id2, rs, dt, dk, norm, size);
            }
        }
        throw new RSIllegalArgumentException("Cannot create vector of non-primitive type.");
    }

    private static final Element $$robo$$android_renderscript_Element$createPixel(RenderScript rs, DataType dt, DataKind dk) {
        if (dk != DataKind.PIXEL_L && dk != DataKind.PIXEL_A && dk != DataKind.PIXEL_LA && dk != DataKind.PIXEL_RGB && dk != DataKind.PIXEL_RGBA && dk != DataKind.PIXEL_DEPTH && dk != DataKind.PIXEL_YUV) {
            throw new RSIllegalArgumentException("Unsupported DataKind");
        }
        if (dt != DataType.UNSIGNED_8 && dt != DataType.UNSIGNED_16 && dt != DataType.UNSIGNED_5_6_5 && dt != DataType.UNSIGNED_4_4_4_4 && dt != DataType.UNSIGNED_5_5_5_1) {
            throw new RSIllegalArgumentException("Unsupported DataType");
        }
        if (dt == DataType.UNSIGNED_5_6_5 && dk != DataKind.PIXEL_RGB) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_5_5_5_1 && dk != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_4_4_4_4 && dk != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dt == DataType.UNSIGNED_16 && dk != DataKind.PIXEL_DEPTH) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        int size = 1;
        switch (1.$SwitchMap$android$renderscript$Element$DataKind[dk.ordinal()]) {
            case 1: {
                size = 2;
                break;
            }
            case 2: {
                size = 3;
                break;
            }
            case 3: {
                size = 4;
                break;
            }
            case 4: {
                size = 2;
            }
        }
        boolean norm = true;
        long id2 = rs.nElementCreate(dt.mID, dk.mID, norm, size);
        return new Element(id2, rs, dt, dk, norm, size);
    }

    private final boolean $$robo$$android_renderscript_Element$isCompatible(Element e) {
        if (this.equals(e)) {
            return true;
        }
        return this.mSize == e.mSize && this.mType != DataType.NONE && this.mType == e.mType && this.mVectorSize == e.mVectorSize;
    }

    private void updateVisibleSubElements() {
        InvokeDynamicSupport.bootstrap("updateVisibleSubElements", $$robo$$android_renderscript_Element$updateVisibleSubElements(), 0, this);
    }

    public int getBytesSize() {
        return (int)InvokeDynamicSupport.bootstrap("getBytesSize", $$robo$$android_renderscript_Element$getBytesSize(), 0, this);
    }

    public int getVectorSize() {
        return (int)InvokeDynamicSupport.bootstrap("getVectorSize", $$robo$$android_renderscript_Element$getVectorSize(), 0, this);
    }

    public boolean isComplex() {
        return (boolean)InvokeDynamicSupport.bootstrap("isComplex", $$robo$$android_renderscript_Element$isComplex(), 0, this);
    }

    public int getSubElementCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSubElementCount", $$robo$$android_renderscript_Element$getSubElementCount(), 0, this);
    }

    public Element getSubElement(int n) {
        return InvokeDynamicSupport.bootstrap("getSubElement", $$robo$$android_renderscript_Element$getSubElement(int ), 0, this, n);
    }

    public String getSubElementName(int n) {
        return InvokeDynamicSupport.bootstrap("getSubElementName", $$robo$$android_renderscript_Element$getSubElementName(int ), 0, this, n);
    }

    public int getSubElementArraySize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSubElementArraySize", $$robo$$android_renderscript_Element$getSubElementArraySize(int ), 0, this, n);
    }

    public int getSubElementOffsetBytes(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSubElementOffsetBytes", $$robo$$android_renderscript_Element$getSubElementOffsetBytes(int ), 0, this, n);
    }

    public DataType getDataType() {
        return InvokeDynamicSupport.bootstrap("getDataType", $$robo$$android_renderscript_Element$getDataType(), 0, this);
    }

    public DataKind getDataKind() {
        return InvokeDynamicSupport.bootstrap("getDataKind", $$robo$$android_renderscript_Element$getDataKind(), 0, this);
    }

    public static Element BOOLEAN(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("BOOLEAN", $$robo$$android_renderscript_Element$BOOLEAN(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U8(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U8", $$robo$$android_renderscript_Element$U8(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I8(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I8", $$robo$$android_renderscript_Element$I8(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U16(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U16", $$robo$$android_renderscript_Element$U16(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I16(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I16", $$robo$$android_renderscript_Element$I16(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U32(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U32", $$robo$$android_renderscript_Element$U32(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I32(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I32", $$robo$$android_renderscript_Element$I32(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U64(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U64", $$robo$$android_renderscript_Element$U64(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I64(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I64", $$robo$$android_renderscript_Element$I64(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F16(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F16", $$robo$$android_renderscript_Element$F16(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F32(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F32", $$robo$$android_renderscript_Element$F32(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F64(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F64", $$robo$$android_renderscript_Element$F64(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element ELEMENT(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("ELEMENT", $$robo$$android_renderscript_Element$ELEMENT(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element TYPE(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("TYPE", $$robo$$android_renderscript_Element$TYPE(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element ALLOCATION(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("ALLOCATION", $$robo$$android_renderscript_Element$ALLOCATION(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element SAMPLER(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("SAMPLER", $$robo$$android_renderscript_Element$SAMPLER(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element SCRIPT(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("SCRIPT", $$robo$$android_renderscript_Element$SCRIPT(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element MESH(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("MESH", $$robo$$android_renderscript_Element$MESH(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element PROGRAM_FRAGMENT(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("PROGRAM_FRAGMENT", $$robo$$android_renderscript_Element$PROGRAM_FRAGMENT(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element PROGRAM_VERTEX(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("PROGRAM_VERTEX", $$robo$$android_renderscript_Element$PROGRAM_VERTEX(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element PROGRAM_RASTER(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("PROGRAM_RASTER", $$robo$$android_renderscript_Element$PROGRAM_RASTER(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element PROGRAM_STORE(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("PROGRAM_STORE", $$robo$$android_renderscript_Element$PROGRAM_STORE(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element FONT(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("FONT", $$robo$$android_renderscript_Element$FONT(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element A_8(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("A_8", $$robo$$android_renderscript_Element$A_8(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element RGB_565(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("RGB_565", $$robo$$android_renderscript_Element$RGB_565(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element RGB_888(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("RGB_888", $$robo$$android_renderscript_Element$RGB_888(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element RGBA_5551(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("RGBA_5551", $$robo$$android_renderscript_Element$RGBA_5551(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element RGBA_4444(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("RGBA_4444", $$robo$$android_renderscript_Element$RGBA_4444(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element RGBA_8888(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("RGBA_8888", $$robo$$android_renderscript_Element$RGBA_8888(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F16_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F16_2", $$robo$$android_renderscript_Element$F16_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F16_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F16_3", $$robo$$android_renderscript_Element$F16_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F16_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F16_4", $$robo$$android_renderscript_Element$F16_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F32_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F32_2", $$robo$$android_renderscript_Element$F32_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F32_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F32_3", $$robo$$android_renderscript_Element$F32_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F32_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F32_4", $$robo$$android_renderscript_Element$F32_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F64_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F64_2", $$robo$$android_renderscript_Element$F64_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F64_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F64_3", $$robo$$android_renderscript_Element$F64_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element F64_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("F64_4", $$robo$$android_renderscript_Element$F64_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U8_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U8_2", $$robo$$android_renderscript_Element$U8_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U8_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U8_3", $$robo$$android_renderscript_Element$U8_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U8_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U8_4", $$robo$$android_renderscript_Element$U8_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I8_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I8_2", $$robo$$android_renderscript_Element$I8_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I8_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I8_3", $$robo$$android_renderscript_Element$I8_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I8_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I8_4", $$robo$$android_renderscript_Element$I8_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U16_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U16_2", $$robo$$android_renderscript_Element$U16_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U16_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U16_3", $$robo$$android_renderscript_Element$U16_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U16_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U16_4", $$robo$$android_renderscript_Element$U16_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I16_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I16_2", $$robo$$android_renderscript_Element$I16_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I16_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I16_3", $$robo$$android_renderscript_Element$I16_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I16_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I16_4", $$robo$$android_renderscript_Element$I16_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U32_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U32_2", $$robo$$android_renderscript_Element$U32_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U32_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U32_3", $$robo$$android_renderscript_Element$U32_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U32_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U32_4", $$robo$$android_renderscript_Element$U32_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I32_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I32_2", $$robo$$android_renderscript_Element$I32_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I32_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I32_3", $$robo$$android_renderscript_Element$I32_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I32_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I32_4", $$robo$$android_renderscript_Element$I32_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U64_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U64_2", $$robo$$android_renderscript_Element$U64_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U64_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U64_3", $$robo$$android_renderscript_Element$U64_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element U64_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("U64_4", $$robo$$android_renderscript_Element$U64_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I64_2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I64_2", $$robo$$android_renderscript_Element$I64_2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I64_3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I64_3", $$robo$$android_renderscript_Element$I64_3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element I64_4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("I64_4", $$robo$$android_renderscript_Element$I64_4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element YUV(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("YUV", $$robo$$android_renderscript_Element$YUV(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element MATRIX_4X4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("MATRIX_4X4", $$robo$$android_renderscript_Element$MATRIX_4X4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element MATRIX4X4(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("MATRIX4X4", $$robo$$android_renderscript_Element$MATRIX4X4(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element MATRIX_3X3(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("MATRIX_3X3", $$robo$$android_renderscript_Element$MATRIX_3X3(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    public static Element MATRIX_2X2(RenderScript renderScript) {
        return InvokeDynamicSupport.bootstrapStatic("MATRIX_2X2", $$robo$$android_renderscript_Element$MATRIX_2X2(android.renderscript.RenderScript ), 0, (RenderScript)renderScript);
    }

    private void __constructor__(long l, RenderScript renderScript, Element[] elementArray, String[] stringArray, int[] nArray) {
        this.$$robo$$android_renderscript_Element$__constructor__(l, renderScript, elementArray, stringArray, nArray);
    }

    Element(long l, RenderScript renderScript, Element[] elementArray, String[] stringArray, int[] nArray) {
        super(l, renderScript);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Element$__constructor__(long android.renderscript.RenderScript android.renderscript.Element[] java.lang.String[] int[] ), 0, this, l, renderScript, elementArray, stringArray, nArray);
    }

    private void __constructor__(long l, RenderScript renderScript, DataType dataType, DataKind dataKind, boolean bl, int n) {
        this.$$robo$$android_renderscript_Element$__constructor__(l, renderScript, dataType, dataKind, bl, n);
    }

    Element(long l, RenderScript renderScript, DataType dataType, DataKind dataKind, boolean bl, int n) {
        super(l, renderScript);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Element$__constructor__(long android.renderscript.RenderScript android.renderscript.Element$DataType android.renderscript.Element$DataKind boolean int ), 0, this, l, renderScript, dataType, dataKind, bl, n);
    }

    private void __constructor__(long l, RenderScript renderScript) {
        this.$$robo$$android_renderscript_Element$__constructor__(l, renderScript);
    }

    Element(long l, RenderScript renderScript) {
        super(l, renderScript);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Element$__constructor__(long android.renderscript.RenderScript ), 0, this, l, renderScript);
    }

    @Override
    void updateFromNative() {
        InvokeDynamicSupport.bootstrap("updateFromNative", $$robo$$android_renderscript_Element$updateFromNative(), 0, this);
    }

    static Element createUser(RenderScript renderScript, DataType dataType) {
        return InvokeDynamicSupport.bootstrapStatic("createUser", $$robo$$android_renderscript_Element$createUser(android.renderscript.RenderScript android.renderscript.Element$DataType ), 0, (RenderScript)renderScript, (DataType)dataType);
    }

    public static Element createVector(RenderScript renderScript, DataType dataType, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createVector", $$robo$$android_renderscript_Element$createVector(android.renderscript.RenderScript android.renderscript.Element$DataType int ), 0, (RenderScript)renderScript, (DataType)dataType, (int)n);
    }

    public static Element createPixel(RenderScript renderScript, DataType dataType, DataKind dataKind) {
        return InvokeDynamicSupport.bootstrapStatic("createPixel", $$robo$$android_renderscript_Element$createPixel(android.renderscript.RenderScript android.renderscript.Element$DataType android.renderscript.Element$DataKind ), 0, (RenderScript)renderScript, (DataType)dataType, (DataKind)dataKind);
    }

    public boolean isCompatible(Element element) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCompatible", $$robo$$android_renderscript_Element$isCompatible(android.renderscript.Element ), 0, this, element);
    }

    public /* synthetic */ Element() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Element)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        RenderScript mRS;
        Element[] mElements;
        String[] mElementNames;
        int[] mArraySizes;
        int mCount;
        int mSkipPadding;

        private void $$robo$$android_renderscript_Element_Builder$__constructor__(RenderScript rs) {
            this.mRS = rs;
            this.mCount = 0;
            this.mElements = new Element[8];
            this.mElementNames = new String[8];
            this.mArraySizes = new int[8];
        }

        private final Builder $$robo$$android_renderscript_Element_Builder$add(Element element, String name, int arraySize) {
            if (arraySize < 1) {
                throw new RSIllegalArgumentException("Array size cannot be less than 1.");
            }
            if (this.mSkipPadding != 0 && name.startsWith("#padding_")) {
                this.mSkipPadding = 0;
                return this;
            }
            this.mSkipPadding = element.mVectorSize == 3 ? 1 : 0;
            if (this.mCount == this.mElements.length) {
                Element[] e = new Element[this.mCount + 8];
                String[] s = new String[this.mCount + 8];
                int[] as = new int[this.mCount + 8];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mElements, (int)0, (Object)e, (int)0, (int)this.mCount);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mElementNames, (int)0, (Object)s, (int)0, (int)this.mCount);
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArraySizes, (int)0, (Object)as, (int)0, (int)this.mCount);
                this.mElements = e;
                this.mElementNames = s;
                this.mArraySizes = as;
            }
            this.mElements[this.mCount] = element;
            this.mElementNames[this.mCount] = name;
            this.mArraySizes[this.mCount] = arraySize;
            ++this.mCount;
            return this;
        }

        private final Builder $$robo$$android_renderscript_Element_Builder$add(Element element, String name) {
            return this.add(element, name, 1);
        }

        private final Element $$robo$$android_renderscript_Element_Builder$create() {
            this.mRS.validate();
            Element[] ein = new Element[this.mCount];
            String[] sin = new String[this.mCount];
            int[] asin = new int[this.mCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mElements, (int)0, (Object)ein, (int)0, (int)this.mCount);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mElementNames, (int)0, (Object)sin, (int)0, (int)this.mCount);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mArraySizes, (int)0, (Object)asin, (int)0, (int)this.mCount);
            long[] ids = new long[ein.length];
            for (int ct = 0; ct < ein.length; ++ct) {
                ids[ct] = ein[ct].getID(this.mRS);
            }
            long id2 = this.mRS.nElementCreate2(ids, sin, asin);
            return new Element(id2, this.mRS, ein, sin, asin);
        }

        private void __constructor__(RenderScript renderScript) {
            this.$$robo$$android_renderscript_Element_Builder$__constructor__(renderScript);
        }

        public Builder(RenderScript renderScript) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Element_Builder$__constructor__(android.renderscript.RenderScript ), 0, this, renderScript);
        }

        public Builder add(Element element, String string2, int n) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_renderscript_Element_Builder$add(android.renderscript.Element java.lang.String int ), 0, this, element, string2, n);
        }

        public Builder add(Element element, String string2) {
            return InvokeDynamicSupport.bootstrap("add", $$robo$$android_renderscript_Element_Builder$add(android.renderscript.Element java.lang.String ), 0, this, element, string2);
        }

        public Element create() {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$android_renderscript_Element_Builder$create(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DataKind
    extends Enum<DataKind> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ DataKind USER;
        public static /* enum */ DataKind PIXEL_L;
        public static /* enum */ DataKind PIXEL_A;
        public static /* enum */ DataKind PIXEL_LA;
        public static /* enum */ DataKind PIXEL_RGB;
        public static /* enum */ DataKind PIXEL_RGBA;
        public static /* enum */ DataKind PIXEL_DEPTH;
        public static /* enum */ DataKind PIXEL_YUV;
        int mID;
        private static /* synthetic */ DataKind[] $VALUES;

        private static final DataKind[] $$robo$$android_renderscript_Element_DataKind$values() {
            return (DataKind[])$VALUES.clone();
        }

        private static final DataKind $$robo$$android_renderscript_Element_DataKind$valueOf(String name) {
            return Enum.valueOf(DataKind.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_Element_DataKind$__constructor__(String string2, int n, int id2) {
            this.mID = id2;
        }

        static void __staticInitializer__() {
            USER = new DataKind(0);
            PIXEL_L = new DataKind(7);
            PIXEL_A = new DataKind(8);
            PIXEL_LA = new DataKind(9);
            PIXEL_RGB = new DataKind(10);
            PIXEL_RGBA = new DataKind(11);
            PIXEL_DEPTH = new DataKind(12);
            PIXEL_YUV = new DataKind(13);
            $VALUES = new DataKind[]{USER, PIXEL_L, PIXEL_A, PIXEL_LA, PIXEL_RGB, PIXEL_RGBA, PIXEL_DEPTH, PIXEL_YUV};
        }

        public static DataKind[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_renderscript_Element_DataKind$values(), 0);
        }

        public static DataKind valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_renderscript_Element_DataKind$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_renderscript_Element_DataKind$__constructor__(string2, n, n2);
        }

        private DataKind(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Element_DataKind$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(DataKind.class);
        }

        public /* synthetic */ DataKind() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataKind)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class DataType
    extends Enum<DataType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ DataType NONE;
        public static /* enum */ DataType FLOAT_16;
        public static /* enum */ DataType FLOAT_32;
        public static /* enum */ DataType FLOAT_64;
        public static /* enum */ DataType SIGNED_8;
        public static /* enum */ DataType SIGNED_16;
        public static /* enum */ DataType SIGNED_32;
        public static /* enum */ DataType SIGNED_64;
        public static /* enum */ DataType UNSIGNED_8;
        public static /* enum */ DataType UNSIGNED_16;
        public static /* enum */ DataType UNSIGNED_32;
        public static /* enum */ DataType UNSIGNED_64;
        public static /* enum */ DataType BOOLEAN;
        public static /* enum */ DataType UNSIGNED_5_6_5;
        public static /* enum */ DataType UNSIGNED_5_5_5_1;
        public static /* enum */ DataType UNSIGNED_4_4_4_4;
        public static /* enum */ DataType MATRIX_4X4;
        public static /* enum */ DataType MATRIX_3X3;
        public static /* enum */ DataType MATRIX_2X2;
        public static /* enum */ DataType RS_ELEMENT;
        public static /* enum */ DataType RS_TYPE;
        public static /* enum */ DataType RS_ALLOCATION;
        public static /* enum */ DataType RS_SAMPLER;
        public static /* enum */ DataType RS_SCRIPT;
        public static /* enum */ DataType RS_MESH;
        public static /* enum */ DataType RS_PROGRAM_FRAGMENT;
        public static /* enum */ DataType RS_PROGRAM_VERTEX;
        public static /* enum */ DataType RS_PROGRAM_RASTER;
        public static /* enum */ DataType RS_PROGRAM_STORE;
        public static /* enum */ DataType RS_FONT;
        int mID;
        int mSize;
        private static /* synthetic */ DataType[] $VALUES;

        private static final DataType[] $$robo$$android_renderscript_Element_DataType$values() {
            return (DataType[])$VALUES.clone();
        }

        private static final DataType $$robo$$android_renderscript_Element_DataType$valueOf(String name) {
            return Enum.valueOf(DataType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_Element_DataType$__constructor__(String string2, int n, int id2, int size) {
            this.mID = id2;
            this.mSize = size;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_Element_DataType$__constructor__(String string2, int n, int id2) {
            this.mID = id2;
            this.mSize = 4;
            if (RenderScript.sPointerSize == 8) {
                this.mSize = 32;
            }
        }

        static void __staticInitializer__() {
            NONE = new DataType(0, 0);
            FLOAT_16 = new DataType(1, 2);
            FLOAT_32 = new DataType(2, 4);
            FLOAT_64 = new DataType(3, 8);
            SIGNED_8 = new DataType(4, 1);
            SIGNED_16 = new DataType(5, 2);
            SIGNED_32 = new DataType(6, 4);
            SIGNED_64 = new DataType(7, 8);
            UNSIGNED_8 = new DataType(8, 1);
            UNSIGNED_16 = new DataType(9, 2);
            UNSIGNED_32 = new DataType(10, 4);
            UNSIGNED_64 = new DataType(11, 8);
            BOOLEAN = new DataType(12, 1);
            UNSIGNED_5_6_5 = new DataType(13, 2);
            UNSIGNED_5_5_5_1 = new DataType(14, 2);
            UNSIGNED_4_4_4_4 = new DataType(15, 2);
            MATRIX_4X4 = new DataType(16, 64);
            MATRIX_3X3 = new DataType(17, 36);
            MATRIX_2X2 = new DataType(18, 16);
            RS_ELEMENT = new DataType(1000);
            RS_TYPE = new DataType(1001);
            RS_ALLOCATION = new DataType(1002);
            RS_SAMPLER = new DataType(1003);
            RS_SCRIPT = new DataType(1004);
            RS_MESH = new DataType(1005);
            RS_PROGRAM_FRAGMENT = new DataType(1006);
            RS_PROGRAM_VERTEX = new DataType(1007);
            RS_PROGRAM_RASTER = new DataType(1008);
            RS_PROGRAM_STORE = new DataType(1009);
            RS_FONT = new DataType(1010);
            $VALUES = new DataType[]{NONE, FLOAT_16, FLOAT_32, FLOAT_64, SIGNED_8, SIGNED_16, SIGNED_32, SIGNED_64, UNSIGNED_8, UNSIGNED_16, UNSIGNED_32, UNSIGNED_64, BOOLEAN, UNSIGNED_5_6_5, UNSIGNED_5_5_5_1, UNSIGNED_4_4_4_4, MATRIX_4X4, MATRIX_3X3, MATRIX_2X2, RS_ELEMENT, RS_TYPE, RS_ALLOCATION, RS_SAMPLER, RS_SCRIPT, RS_MESH, RS_PROGRAM_FRAGMENT, RS_PROGRAM_VERTEX, RS_PROGRAM_RASTER, RS_PROGRAM_STORE, RS_FONT};
        }

        public static DataType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_renderscript_Element_DataType$values(), 0);
        }

        public static DataType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_renderscript_Element_DataType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2, int n3) {
            this.$$robo$$android_renderscript_Element_DataType$__constructor__(string2, n, n2, n3);
        }

        private DataType(int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Element_DataType$__constructor__(java.lang.String int int int ), 0, this, string2, n, n2, n3);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_renderscript_Element_DataType$__constructor__(string2, n, n2);
        }

        private DataType(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Element_DataType$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(DataType.class);
        }

        public /* synthetic */ DataType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DataType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

