/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Vector;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Mesh
extends BaseObj
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    Allocation[] mVertexBuffers;
    Allocation[] mIndexBuffers;
    Primitive[] mPrimitives;

    private void $$robo$$android_renderscript_Mesh$__constructor__(long id2, RenderScript rs) {
        this.guard.open("destroy");
    }

    private final int $$robo$$android_renderscript_Mesh$getVertexAllocationCount() {
        if (this.mVertexBuffers == null) {
            return 0;
        }
        return this.mVertexBuffers.length;
    }

    private final Allocation $$robo$$android_renderscript_Mesh$getVertexAllocation(int slot) {
        return this.mVertexBuffers[slot];
    }

    private final int $$robo$$android_renderscript_Mesh$getPrimitiveCount() {
        if (this.mIndexBuffers == null) {
            return 0;
        }
        return this.mIndexBuffers.length;
    }

    private final Allocation $$robo$$android_renderscript_Mesh$getIndexSetAllocation(int slot) {
        return this.mIndexBuffers[slot];
    }

    private final Primitive $$robo$$android_renderscript_Mesh$getPrimitive(int slot) {
        return this.mPrimitives[slot];
    }

    private final void $$robo$$android_renderscript_Mesh$updateFromNative() {
        int i;
        super.updateFromNative();
        int vtxCount = this.mRS.nMeshGetVertexBufferCount(this.getID(this.mRS));
        int idxCount = this.mRS.nMeshGetIndexCount(this.getID(this.mRS));
        long[] vtxIDs = new long[vtxCount];
        long[] idxIDs = new long[idxCount];
        int[] primitives = new int[idxCount];
        this.mRS.nMeshGetVertices(this.getID(this.mRS), vtxIDs, vtxCount);
        this.mRS.nMeshGetIndices(this.getID(this.mRS), idxIDs, primitives, idxCount);
        this.mVertexBuffers = new Allocation[vtxCount];
        this.mIndexBuffers = new Allocation[idxCount];
        this.mPrimitives = new Primitive[idxCount];
        for (i = 0; i < vtxCount; ++i) {
            if (vtxIDs[i] == 0L) continue;
            this.mVertexBuffers[i] = new Allocation(vtxIDs[i], this.mRS, null, 1);
            this.mVertexBuffers[i].updateFromNative();
        }
        for (i = 0; i < idxCount; ++i) {
            if (idxIDs[i] != 0L) {
                this.mIndexBuffers[i] = new Allocation(idxIDs[i], this.mRS, null, 1);
                this.mIndexBuffers[i].updateFromNative();
            }
            this.mPrimitives[i] = Primitive.values()[primitives[i]];
        }
    }

    private void __constructor__(long l, RenderScript renderScript) {
        this.$$robo$$android_renderscript_Mesh$__constructor__(l, renderScript);
    }

    Mesh(long l, RenderScript renderScript) {
        super(l, renderScript);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Mesh$__constructor__(long android.renderscript.RenderScript ), 0, this, l, renderScript);
    }

    public int getVertexAllocationCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVertexAllocationCount", $$robo$$android_renderscript_Mesh$getVertexAllocationCount(), 0, this);
    }

    public Allocation getVertexAllocation(int n) {
        return InvokeDynamicSupport.bootstrap("getVertexAllocation", $$robo$$android_renderscript_Mesh$getVertexAllocation(int ), 0, this, n);
    }

    public int getPrimitiveCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPrimitiveCount", $$robo$$android_renderscript_Mesh$getPrimitiveCount(), 0, this);
    }

    public Allocation getIndexSetAllocation(int n) {
        return InvokeDynamicSupport.bootstrap("getIndexSetAllocation", $$robo$$android_renderscript_Mesh$getIndexSetAllocation(int ), 0, this, n);
    }

    public Primitive getPrimitive(int n) {
        return InvokeDynamicSupport.bootstrap("getPrimitive", $$robo$$android_renderscript_Mesh$getPrimitive(int ), 0, this, n);
    }

    @Override
    void updateFromNative() {
        InvokeDynamicSupport.bootstrap("updateFromNative", $$robo$$android_renderscript_Mesh$updateFromNative(), 0, this);
    }

    public /* synthetic */ Mesh() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Mesh)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TriangleMeshBuilder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float[] mVtxData;
        int mVtxCount;
        int mMaxIndex;
        short[] mIndexData;
        int mIndexCount;
        RenderScript mRS;
        Element mElement;
        float mNX;
        float mNY;
        float mNZ;
        float mS0;
        float mT0;
        float mR;
        float mG;
        float mB;
        float mA;
        int mVtxSize;
        int mFlags;
        public static int COLOR = 1;
        public static int NORMAL = 2;
        public static int TEXTURE_0 = 256;

        private void $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$__constructor__(RenderScript rs, int vtxSize, int flags) {
            this.mNX = 0.0f;
            this.mNY = 0.0f;
            this.mNZ = -1.0f;
            this.mS0 = 0.0f;
            this.mT0 = 0.0f;
            this.mR = 1.0f;
            this.mG = 1.0f;
            this.mB = 1.0f;
            this.mA = 1.0f;
            this.mRS = rs;
            this.mVtxCount = 0;
            this.mMaxIndex = 0;
            this.mIndexCount = 0;
            this.mVtxData = new float[128];
            this.mIndexData = new short[128];
            this.mVtxSize = vtxSize;
            this.mFlags = flags;
            if (vtxSize < 2 || vtxSize > 3) {
                throw new IllegalArgumentException("Vertex size out of range.");
            }
        }

        private final void $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$makeSpace(int count) {
            if (this.mVtxCount + count >= this.mVtxData.length) {
                float[] t = new float[this.mVtxData.length * 2];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mVtxData, (int)0, (Object)t, (int)0, (int)this.mVtxData.length);
                this.mVtxData = t;
            }
        }

        private final void $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$latch() {
            if ((this.mFlags & 1) != 0) {
                this.makeSpace(4);
                this.mVtxData[this.mVtxCount++] = this.mR;
                this.mVtxData[this.mVtxCount++] = this.mG;
                this.mVtxData[this.mVtxCount++] = this.mB;
                this.mVtxData[this.mVtxCount++] = this.mA;
            }
            if ((this.mFlags & 0x100) != 0) {
                this.makeSpace(2);
                this.mVtxData[this.mVtxCount++] = this.mS0;
                this.mVtxData[this.mVtxCount++] = this.mT0;
            }
            if ((this.mFlags & 2) != 0) {
                this.makeSpace(4);
                this.mVtxData[this.mVtxCount++] = this.mNX;
                this.mVtxData[this.mVtxCount++] = this.mNY;
                this.mVtxData[this.mVtxCount++] = this.mNZ;
                this.mVtxData[this.mVtxCount++] = 0.0f;
            }
            ++this.mMaxIndex;
        }

        private final TriangleMeshBuilder $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$addVertex(float x, float y) {
            if (this.mVtxSize != 2) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(2);
            this.mVtxData[this.mVtxCount++] = x;
            this.mVtxData[this.mVtxCount++] = y;
            this.latch();
            return this;
        }

        private final TriangleMeshBuilder $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$addVertex(float x, float y, float z) {
            if (this.mVtxSize != 3) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.makeSpace(4);
            this.mVtxData[this.mVtxCount++] = x;
            this.mVtxData[this.mVtxCount++] = y;
            this.mVtxData[this.mVtxCount++] = z;
            this.mVtxData[this.mVtxCount++] = 1.0f;
            this.latch();
            return this;
        }

        private final TriangleMeshBuilder $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$setTexture(float s, float t) {
            if ((this.mFlags & 0x100) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mS0 = s;
            this.mT0 = t;
            return this;
        }

        private final TriangleMeshBuilder $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$setNormal(float x, float y, float z) {
            if ((this.mFlags & 2) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mNX = x;
            this.mNY = y;
            this.mNZ = z;
            return this;
        }

        private final TriangleMeshBuilder $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$setColor(float r, float g, float b, float a) {
            if ((this.mFlags & 1) == 0) {
                throw new IllegalStateException("add mistmatch with declared components.");
            }
            this.mR = r;
            this.mG = g;
            this.mB = b;
            this.mA = a;
            return this;
        }

        private final TriangleMeshBuilder $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$addTriangle(int idx1, int idx2, int idx3) {
            if (idx1 >= this.mMaxIndex || idx1 < 0 || idx2 >= this.mMaxIndex || idx2 < 0 || idx3 >= this.mMaxIndex || idx3 < 0) {
                throw new IllegalStateException("Index provided greater than vertex count.");
            }
            if (this.mIndexCount + 3 >= this.mIndexData.length) {
                short[] t = new short[this.mIndexData.length * 2];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mIndexData, (int)0, (Object)t, (int)0, (int)this.mIndexData.length);
                this.mIndexData = t;
            }
            this.mIndexData[this.mIndexCount++] = (short)idx1;
            this.mIndexData[this.mIndexCount++] = (short)idx2;
            this.mIndexData[this.mIndexCount++] = (short)idx3;
            return this;
        }

        private final Mesh $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$create(boolean uploadToBufferObject) {
            Element.Builder b = new Element.Builder(this.mRS);
            b.add(Element.createVector(this.mRS, Element.DataType.FLOAT_32, this.mVtxSize), "position");
            if ((this.mFlags & 1) != 0) {
                b.add(Element.F32_4(this.mRS), "color");
            }
            if ((this.mFlags & 0x100) != 0) {
                b.add(Element.F32_2(this.mRS), "texture0");
            }
            if ((this.mFlags & 2) != 0) {
                b.add(Element.F32_3(this.mRS), "normal");
            }
            this.mElement = b.create();
            int usage = 1;
            if (uploadToBufferObject) {
                usage |= 4;
            }
            Builder smb = new Builder(this.mRS, usage);
            smb.addVertexType(this.mElement, this.mMaxIndex);
            smb.addIndexSetType(Element.U16(this.mRS), this.mIndexCount, Primitive.TRIANGLE);
            Mesh sm = smb.create();
            sm.getVertexAllocation(0).copy1DRangeFromUnchecked(0, this.mMaxIndex, this.mVtxData);
            if (uploadToBufferObject) {
                sm.getVertexAllocation(0).syncAll(1);
            }
            sm.getIndexSetAllocation(0).copy1DRangeFromUnchecked(0, this.mIndexCount, this.mIndexData);
            if (uploadToBufferObject) {
                sm.getIndexSetAllocation(0).syncAll(1);
            }
            return sm;
        }

        private void __constructor__(RenderScript renderScript, int n, int n2) {
            this.$$robo$$android_renderscript_Mesh_TriangleMeshBuilder$__constructor__(renderScript, n, n2);
        }

        public TriangleMeshBuilder(RenderScript renderScript, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$__constructor__(android.renderscript.RenderScript int int ), 0, this, renderScript, n, n2);
        }

        private void makeSpace(int n) {
            InvokeDynamicSupport.bootstrap("makeSpace", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$makeSpace(int ), 0, this, n);
        }

        private void latch() {
            InvokeDynamicSupport.bootstrap("latch", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$latch(), 0, this);
        }

        public TriangleMeshBuilder addVertex(float f, float f2) {
            return InvokeDynamicSupport.bootstrap("addVertex", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$addVertex(float float ), 0, this, f, f2);
        }

        public TriangleMeshBuilder addVertex(float f, float f2, float f3) {
            return InvokeDynamicSupport.bootstrap("addVertex", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$addVertex(float float float ), 0, this, f, f2, f3);
        }

        public TriangleMeshBuilder setTexture(float f, float f2) {
            return InvokeDynamicSupport.bootstrap("setTexture", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$setTexture(float float ), 0, this, f, f2);
        }

        public TriangleMeshBuilder setNormal(float f, float f2, float f3) {
            return InvokeDynamicSupport.bootstrap("setNormal", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$setNormal(float float float ), 0, this, f, f2, f3);
        }

        public TriangleMeshBuilder setColor(float f, float f2, float f3, float f4) {
            return InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$setColor(float float float float ), 0, this, f, f2, f3, f4);
        }

        public TriangleMeshBuilder addTriangle(int n, int n2, int n3) {
            return InvokeDynamicSupport.bootstrap("addTriangle", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$addTriangle(int int int ), 0, this, n, n2, n3);
        }

        public Mesh create(boolean bl) {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$android_renderscript_Mesh_TriangleMeshBuilder$create(boolean ), 0, this, bl);
        }

        public /* synthetic */ TriangleMeshBuilder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TriangleMeshBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AllocationBuilder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        RenderScript mRS;
        int mVertexTypeCount;
        Entry[] mVertexTypes;
        Vector mIndexTypes;

        private void $$robo$$android_renderscript_Mesh_AllocationBuilder$__constructor__(RenderScript rs) {
            this.mRS = rs;
            this.mVertexTypeCount = 0;
            this.mVertexTypes = new Entry[16];
            this.mIndexTypes = new Vector();
        }

        private final int $$robo$$android_renderscript_Mesh_AllocationBuilder$getCurrentVertexTypeIndex() {
            return this.mVertexTypeCount - 1;
        }

        private final int $$robo$$android_renderscript_Mesh_AllocationBuilder$getCurrentIndexSetIndex() {
            return this.mIndexTypes.size() - 1;
        }

        private final AllocationBuilder $$robo$$android_renderscript_Mesh_AllocationBuilder$addVertexAllocation(Allocation a) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            this.mVertexTypes[this.mVertexTypeCount] = new Entry(this);
            this.mVertexTypes[this.mVertexTypeCount].a = a;
            ++this.mVertexTypeCount;
            return this;
        }

        private final AllocationBuilder $$robo$$android_renderscript_Mesh_AllocationBuilder$addIndexSetAllocation(Allocation a, Primitive p) {
            Entry indexType = new Entry(this);
            indexType.a = a;
            indexType.prim = p;
            this.mIndexTypes.addElement(indexType);
            return this;
        }

        private final AllocationBuilder $$robo$$android_renderscript_Mesh_AllocationBuilder$addIndexSetType(Primitive p) {
            Entry indexType = new Entry(this);
            indexType.a = null;
            indexType.prim = p;
            this.mIndexTypes.addElement(indexType);
            return this;
        }

        private final Mesh $$robo$$android_renderscript_Mesh_AllocationBuilder$create() {
            Entry entry;
            int ct;
            this.mRS.validate();
            long[] vtx = new long[this.mVertexTypeCount];
            long[] idx = new long[this.mIndexTypes.size()];
            int[] prim = new int[this.mIndexTypes.size()];
            Allocation[] indexBuffers = new Allocation[this.mIndexTypes.size()];
            Primitive[] primitives = new Primitive[this.mIndexTypes.size()];
            Allocation[] vertexBuffers = new Allocation[this.mVertexTypeCount];
            for (ct = 0; ct < this.mVertexTypeCount; ++ct) {
                entry = this.mVertexTypes[ct];
                vertexBuffers[ct] = entry.a;
                vtx[ct] = entry.a.getID(this.mRS);
            }
            for (ct = 0; ct < this.mIndexTypes.size(); ++ct) {
                entry = (Entry)this.mIndexTypes.elementAt(ct);
                long allocID = entry.a == null ? 0L : entry.a.getID(this.mRS);
                indexBuffers[ct] = entry.a;
                primitives[ct] = entry.prim;
                idx[ct] = allocID;
                prim[ct] = entry.prim.mID;
            }
            long id2 = this.mRS.nMeshCreate(vtx, idx, prim);
            Mesh newMesh = new Mesh(id2, this.mRS);
            newMesh.mVertexBuffers = vertexBuffers;
            newMesh.mIndexBuffers = indexBuffers;
            newMesh.mPrimitives = primitives;
            return newMesh;
        }

        private void __constructor__(RenderScript renderScript) {
            this.$$robo$$android_renderscript_Mesh_AllocationBuilder$__constructor__(renderScript);
        }

        public AllocationBuilder(RenderScript renderScript) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Mesh_AllocationBuilder$__constructor__(android.renderscript.RenderScript ), 0, this, renderScript);
        }

        public int getCurrentVertexTypeIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentVertexTypeIndex", $$robo$$android_renderscript_Mesh_AllocationBuilder$getCurrentVertexTypeIndex(), 0, this);
        }

        public int getCurrentIndexSetIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentIndexSetIndex", $$robo$$android_renderscript_Mesh_AllocationBuilder$getCurrentIndexSetIndex(), 0, this);
        }

        public AllocationBuilder addVertexAllocation(Allocation allocation) throws IllegalStateException {
            return InvokeDynamicSupport.bootstrap("addVertexAllocation", $$robo$$android_renderscript_Mesh_AllocationBuilder$addVertexAllocation(android.renderscript.Allocation ), 0, this, allocation);
        }

        public AllocationBuilder addIndexSetAllocation(Allocation allocation, Primitive primitive) {
            return InvokeDynamicSupport.bootstrap("addIndexSetAllocation", $$robo$$android_renderscript_Mesh_AllocationBuilder$addIndexSetAllocation(android.renderscript.Allocation android.renderscript.Mesh$Primitive ), 0, this, allocation, primitive);
        }

        public AllocationBuilder addIndexSetType(Primitive primitive) {
            return InvokeDynamicSupport.bootstrap("addIndexSetType", $$robo$$android_renderscript_Mesh_AllocationBuilder$addIndexSetType(android.renderscript.Mesh$Primitive ), 0, this, primitive);
        }

        public Mesh create() {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$android_renderscript_Mesh_AllocationBuilder$create(), 0, this);
        }

        public /* synthetic */ AllocationBuilder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AllocationBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class Entry
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            Allocation a;
            Primitive prim;
            /* synthetic */ AllocationBuilder this$0;

            private void $$robo$$android_renderscript_Mesh_AllocationBuilder_Entry$__constructor__(AllocationBuilder this$0) {
            }

            private void __constructor__(AllocationBuilder allocationBuilder) {
                this.$$robo$$android_renderscript_Mesh_AllocationBuilder_Entry$__constructor__(allocationBuilder);
            }

            Entry(AllocationBuilder allocationBuilder) {
                this.this$0 = allocationBuilder;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Mesh_AllocationBuilder_Entry$__constructor__(android.renderscript.Mesh$AllocationBuilder ), 0, this, allocationBuilder);
            }

            public /* synthetic */ Entry() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        RenderScript mRS;
        int mUsage;
        int mVertexTypeCount;
        Entry[] mVertexTypes;
        Vector mIndexTypes;

        private void $$robo$$android_renderscript_Mesh_Builder$__constructor__(RenderScript rs, int usage) {
            this.mRS = rs;
            this.mUsage = usage;
            this.mVertexTypeCount = 0;
            this.mVertexTypes = new Entry[16];
            this.mIndexTypes = new Vector();
        }

        private final int $$robo$$android_renderscript_Mesh_Builder$getCurrentVertexTypeIndex() {
            return this.mVertexTypeCount - 1;
        }

        private final int $$robo$$android_renderscript_Mesh_Builder$getCurrentIndexSetIndex() {
            return this.mIndexTypes.size() - 1;
        }

        private final Builder $$robo$$android_renderscript_Mesh_Builder$addVertexType(Type t) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            this.mVertexTypes[this.mVertexTypeCount] = new Entry(this);
            this.mVertexTypes[this.mVertexTypeCount].t = t;
            this.mVertexTypes[this.mVertexTypeCount].e = null;
            ++this.mVertexTypeCount;
            return this;
        }

        private final Builder $$robo$$android_renderscript_Mesh_Builder$addVertexType(Element e, int size) throws IllegalStateException {
            if (this.mVertexTypeCount >= this.mVertexTypes.length) {
                throw new IllegalStateException("Max vertex types exceeded.");
            }
            this.mVertexTypes[this.mVertexTypeCount] = new Entry(this);
            this.mVertexTypes[this.mVertexTypeCount].t = null;
            this.mVertexTypes[this.mVertexTypeCount].e = e;
            this.mVertexTypes[this.mVertexTypeCount].size = size;
            ++this.mVertexTypeCount;
            return this;
        }

        private final Builder $$robo$$android_renderscript_Mesh_Builder$addIndexSetType(Type t, Primitive p) {
            Entry indexType = new Entry(this);
            indexType.t = t;
            indexType.e = null;
            indexType.size = 0;
            indexType.prim = p;
            this.mIndexTypes.addElement(indexType);
            return this;
        }

        private final Builder $$robo$$android_renderscript_Mesh_Builder$addIndexSetType(Primitive p) {
            Entry indexType = new Entry(this);
            indexType.t = null;
            indexType.e = null;
            indexType.size = 0;
            indexType.prim = p;
            this.mIndexTypes.addElement(indexType);
            return this;
        }

        private final Builder $$robo$$android_renderscript_Mesh_Builder$addIndexSetType(Element e, int size, Primitive p) {
            Entry indexType = new Entry(this);
            indexType.t = null;
            indexType.e = e;
            indexType.size = size;
            indexType.prim = p;
            this.mIndexTypes.addElement(indexType);
            return this;
        }

        private final Type $$robo$$android_renderscript_Mesh_Builder$newType(Element e, int size) {
            Type.Builder tb = new Type.Builder(this.mRS, e);
            tb.setX(size);
            return tb.create();
        }

        private final Mesh $$robo$$android_renderscript_Mesh_Builder$create() {
            Entry entry;
            Allocation alloc;
            int ct;
            this.mRS.validate();
            long[] vtx = new long[this.mVertexTypeCount];
            long[] idx = new long[this.mIndexTypes.size()];
            int[] prim = new int[this.mIndexTypes.size()];
            Allocation[] vertexBuffers = new Allocation[this.mVertexTypeCount];
            Allocation[] indexBuffers = new Allocation[this.mIndexTypes.size()];
            Primitive[] primitives = new Primitive[this.mIndexTypes.size()];
            for (ct = 0; ct < this.mVertexTypeCount; ++ct) {
                alloc = null;
                entry = this.mVertexTypes[ct];
                if (entry.t != null) {
                    alloc = Allocation.createTyped(this.mRS, entry.t, this.mUsage);
                } else if (entry.e != null) {
                    alloc = Allocation.createSized(this.mRS, entry.e, entry.size, this.mUsage);
                } else {
                    throw new IllegalStateException("Builder corrupt, no valid element in entry.");
                }
                vertexBuffers[ct] = alloc;
                vtx[ct] = alloc.getID(this.mRS);
            }
            for (ct = 0; ct < this.mIndexTypes.size(); ++ct) {
                alloc = null;
                entry = (Entry)this.mIndexTypes.elementAt(ct);
                if (entry.t != null) {
                    alloc = Allocation.createTyped(this.mRS, entry.t, this.mUsage);
                } else if (entry.e != null) {
                    alloc = Allocation.createSized(this.mRS, entry.e, entry.size, this.mUsage);
                } else {
                    throw new IllegalStateException("Builder corrupt, no valid element in entry.");
                }
                long allocID = alloc == null ? 0L : alloc.getID(this.mRS);
                indexBuffers[ct] = alloc;
                primitives[ct] = entry.prim;
                idx[ct] = allocID;
                prim[ct] = entry.prim.mID;
            }
            long id2 = this.mRS.nMeshCreate(vtx, idx, prim);
            Mesh newMesh = new Mesh(id2, this.mRS);
            newMesh.mVertexBuffers = vertexBuffers;
            newMesh.mIndexBuffers = indexBuffers;
            newMesh.mPrimitives = primitives;
            return newMesh;
        }

        private void __constructor__(RenderScript renderScript, int n) {
            this.$$robo$$android_renderscript_Mesh_Builder$__constructor__(renderScript, n);
        }

        public Builder(RenderScript renderScript, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Mesh_Builder$__constructor__(android.renderscript.RenderScript int ), 0, this, renderScript, n);
        }

        public int getCurrentVertexTypeIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentVertexTypeIndex", $$robo$$android_renderscript_Mesh_Builder$getCurrentVertexTypeIndex(), 0, this);
        }

        public int getCurrentIndexSetIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentIndexSetIndex", $$robo$$android_renderscript_Mesh_Builder$getCurrentIndexSetIndex(), 0, this);
        }

        public Builder addVertexType(Type type) throws IllegalStateException {
            return InvokeDynamicSupport.bootstrap("addVertexType", $$robo$$android_renderscript_Mesh_Builder$addVertexType(android.renderscript.Type ), 0, this, type);
        }

        public Builder addVertexType(Element element, int n) throws IllegalStateException {
            return InvokeDynamicSupport.bootstrap("addVertexType", $$robo$$android_renderscript_Mesh_Builder$addVertexType(android.renderscript.Element int ), 0, this, element, n);
        }

        public Builder addIndexSetType(Type type, Primitive primitive) {
            return InvokeDynamicSupport.bootstrap("addIndexSetType", $$robo$$android_renderscript_Mesh_Builder$addIndexSetType(android.renderscript.Type android.renderscript.Mesh$Primitive ), 0, this, type, primitive);
        }

        public Builder addIndexSetType(Primitive primitive) {
            return InvokeDynamicSupport.bootstrap("addIndexSetType", $$robo$$android_renderscript_Mesh_Builder$addIndexSetType(android.renderscript.Mesh$Primitive ), 0, this, primitive);
        }

        public Builder addIndexSetType(Element element, int n, Primitive primitive) {
            return InvokeDynamicSupport.bootstrap("addIndexSetType", $$robo$$android_renderscript_Mesh_Builder$addIndexSetType(android.renderscript.Element int android.renderscript.Mesh$Primitive ), 0, this, element, n, primitive);
        }

        Type newType(Element element, int n) {
            return InvokeDynamicSupport.bootstrap("newType", $$robo$$android_renderscript_Mesh_Builder$newType(android.renderscript.Element int ), 0, this, element, n);
        }

        public Mesh create() {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$android_renderscript_Mesh_Builder$create(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public class Entry
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            Type t;
            Element e;
            int size;
            Primitive prim;
            int usage;
            /* synthetic */ Builder this$0;

            private void $$robo$$android_renderscript_Mesh_Builder_Entry$__constructor__(Builder this$0) {
            }

            private void __constructor__(Builder builder) {
                this.$$robo$$android_renderscript_Mesh_Builder_Entry$__constructor__(builder);
            }

            Entry(Builder builder) {
                this.this$0 = builder;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Mesh_Builder_Entry$__constructor__(android.renderscript.Mesh$Builder ), 0, this, builder);
            }

            public /* synthetic */ Entry() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Primitive
    extends Enum<Primitive> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Primitive POINT;
        public static /* enum */ Primitive LINE;
        public static /* enum */ Primitive LINE_STRIP;
        public static /* enum */ Primitive TRIANGLE;
        public static /* enum */ Primitive TRIANGLE_STRIP;
        public static /* enum */ Primitive TRIANGLE_FAN;
        int mID;
        private static /* synthetic */ Primitive[] $VALUES;

        private static final Primitive[] $$robo$$android_renderscript_Mesh_Primitive$values() {
            return (Primitive[])$VALUES.clone();
        }

        private static final Primitive $$robo$$android_renderscript_Mesh_Primitive$valueOf(String name) {
            return Enum.valueOf(Primitive.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_Mesh_Primitive$__constructor__(String string2, int n, int id2) {
            this.mID = id2;
        }

        static void __staticInitializer__() {
            POINT = new Primitive(0);
            LINE = new Primitive(1);
            LINE_STRIP = new Primitive(2);
            TRIANGLE = new Primitive(3);
            TRIANGLE_STRIP = new Primitive(4);
            TRIANGLE_FAN = new Primitive(5);
            $VALUES = new Primitive[]{POINT, LINE, LINE_STRIP, TRIANGLE, TRIANGLE_STRIP, TRIANGLE_FAN};
        }

        public static Primitive[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_renderscript_Mesh_Primitive$values(), 0);
        }

        public static Primitive valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_renderscript_Mesh_Primitive$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_renderscript_Mesh_Primitive$__constructor__(string2, n, n2);
        }

        private Primitive(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Mesh_Primitive$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(Primitive.class);
        }

        public /* synthetic */ Primitive() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Primitive)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

