/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.ContentResolver;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.provider.Settings;
import android.security.ConfirmationAlreadyPresentingException;
import android.security.ConfirmationCallback;
import android.security.ConfirmationNotAvailableException;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ConfirmationPrompt
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ConfirmationPrompt";
    private CharSequence mPromptText;
    private byte[] mExtraData;
    private ConfirmationCallback mCallback;
    private Executor mExecutor;
    private Context mContext;
    private KeyStore mKeyStore;
    private IBinder mCallbackBinder;
    private static int UI_OPTION_ACCESSIBILITY_INVERTED_FLAG = 1;
    private static int UI_OPTION_ACCESSIBILITY_MAGNIFIED_FLAG = 2;

    private final void $$robo$$android_security_ConfirmationPrompt$doCallback(int responseCode, byte[] dataThatWasConfirmed, ConfirmationCallback callback) {
        switch (responseCode) {
            case 0: {
                callback.onConfirmed(dataThatWasConfirmed);
                break;
            }
            case 1: {
                callback.onDismissed();
                break;
            }
            case 2: {
                callback.onCanceled();
                break;
            }
            case 5: {
                callback.onError(new Exception("System error returned by ConfirmationUI."));
                break;
            }
            default: {
                callback.onError(new Exception("Unexpected responseCode=" + responseCode + " from onConfirmtionPromptCompleted() callback."));
            }
        }
    }

    private void $$robo$$android_security_ConfirmationPrompt$__constructor__(Context context, CharSequence promptText, byte[] extraData) {
        this.mKeyStore = KeyStore.getInstance();
        this.mCallbackBinder = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ConfirmationPrompt this$0;

            private void $$robo$$android_security_ConfirmationPrompt_1$__constructor__(ConfirmationPrompt this$0) {
            }

            private final void $$robo$$android_security_ConfirmationPrompt_1$onConfirmationPromptCompleted(int responseCode, byte[] dataThatWasConfirmed) throws RemoteException {
                if (this.this$0.mCallback != null) {
                    ConfirmationCallback callback = this.this$0.mCallback;
                    Executor executor = this.this$0.mExecutor;
                    this.this$0.mCallback = null;
                    this.this$0.mExecutor = null;
                    if (executor == null) {
                        this.this$0.doCallback(responseCode, dataThatWasConfirmed, callback);
                    } else {
                        executor.execute(new Runnable(this, responseCode, dataThatWasConfirmed, callback){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ int val$responseCode;
                            /* synthetic */ byte[] val$dataThatWasConfirmed;
                            /* synthetic */ ConfirmationCallback val$callback;
                            /* synthetic */ 1 this$1;

                            private void $$robo$$android_security_ConfirmationPrompt_1_1$__constructor__(1 this$1, int n, byte[] byArray, ConfirmationCallback confirmationCallback) {
                            }

                            private final void $$robo$$android_security_ConfirmationPrompt_1_1$run() {
                                this.this$1.this$0.doCallback(this.val$responseCode, this.val$dataThatWasConfirmed, this.val$callback);
                            }

                            private void __constructor__(1 var1_1, int n, byte[] byArray, ConfirmationCallback confirmationCallback) {
                                this.$$robo$$android_security_ConfirmationPrompt_1_1$__constructor__(var1_1, n, byArray, confirmationCallback);
                            }
                            {
                                this.this$1 = var1_1;
                                this.val$responseCode = n;
                                this.val$dataThatWasConfirmed = byArray;
                                this.val$callback = confirmationCallback;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_ConfirmationPrompt_1_1$__constructor__(android.security.ConfirmationPrompt$1 int byte[] android.security.ConfirmationCallback ), 0, this, var1_1, n, byArray, confirmationCallback);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$android_security_ConfirmationPrompt_1_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        });
                    }
                }
            }

            private void __constructor__(ConfirmationPrompt confirmationPrompt) {
                this.$$robo$$android_security_ConfirmationPrompt_1$__constructor__(confirmationPrompt);
            }
            {
                this.this$0 = confirmationPrompt;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_ConfirmationPrompt_1$__constructor__(android.security.ConfirmationPrompt ), 0, this, confirmationPrompt);
            }

            @Override
            public void onConfirmationPromptCompleted(int n, byte[] byArray) throws RemoteException {
                InvokeDynamicSupport.bootstrap("onConfirmationPromptCompleted", $$robo$$android_security_ConfirmationPrompt_1$onConfirmationPromptCompleted(int byte[] ), 0, this, n, byArray);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mPromptText = promptText;
        this.mExtraData = extraData;
    }

    private final int $$robo$$android_security_ConfirmationPrompt$getUiOptionsAsFlags() {
        int uiOptionsAsFlags = 0;
        try {
            float fontScale;
            ContentResolver contentResolver = this.mContext.getContentResolver();
            int inversionEnabled = Settings.Secure.getInt(contentResolver, "accessibility_display_inversion_enabled");
            if (inversionEnabled == 1) {
                uiOptionsAsFlags |= 1;
            }
            if ((double)(fontScale = Settings.System.getFloat(contentResolver, "font_scale")) > 1.0) {
                uiOptionsAsFlags |= 2;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            Log.w("ConfirmationPrompt", "Unexpected SettingNotFoundException");
        }
        return uiOptionsAsFlags;
    }

    private static final boolean $$robo$$android_security_ConfirmationPrompt$isAccessibilityServiceRunning(Context context) {
        boolean serviceRunning = false;
        try {
            ContentResolver contentResolver = context.getContentResolver();
            int a11yEnabled = Settings.Secure.getInt(contentResolver, "accessibility_enabled");
            if (a11yEnabled == 1) {
                serviceRunning = true;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            Log.w("ConfirmationPrompt", "Unexpected SettingNotFoundException");
            e.printStackTrace();
        }
        return serviceRunning;
    }

    private final void $$robo$$android_security_ConfirmationPrompt$presentPrompt(Executor executor, ConfirmationCallback callback) throws ConfirmationAlreadyPresentingException, ConfirmationNotAvailableException {
        if (this.mCallback != null) {
            throw new ConfirmationAlreadyPresentingException();
        }
        if (ConfirmationPrompt.isAccessibilityServiceRunning(this.mContext)) {
            throw new ConfirmationNotAvailableException();
        }
        this.mCallback = callback;
        this.mExecutor = executor;
        int uiOptionsAsFlags = this.getUiOptionsAsFlags();
        String locale = Locale.getDefault().toLanguageTag();
        int responseCode = this.mKeyStore.presentConfirmationPrompt(this.mCallbackBinder, this.mPromptText.toString(), this.mExtraData, locale, uiOptionsAsFlags);
        switch (responseCode) {
            case 0: {
                return;
            }
            case 3: {
                throw new ConfirmationAlreadyPresentingException();
            }
            case 6: {
                throw new ConfirmationNotAvailableException();
            }
            case 65536: {
                throw new IllegalArgumentException();
            }
        }
        Log.w("ConfirmationPrompt", "Unexpected responseCode=" + responseCode + " from presentConfirmationPrompt() call.");
        throw new IllegalArgumentException();
    }

    private final void $$robo$$android_security_ConfirmationPrompt$cancelPrompt() {
        int responseCode = this.mKeyStore.cancelConfirmationPrompt(this.mCallbackBinder);
        if (responseCode == 0) {
            return;
        }
        if (responseCode == 3) {
            throw new IllegalStateException();
        }
        Log.w("ConfirmationPrompt", "Unexpected responseCode=" + responseCode + " from cancelConfirmationPrompt() call.");
        throw new IllegalStateException();
    }

    private static final boolean $$robo$$android_security_ConfirmationPrompt$isSupported(Context context) {
        if (ConfirmationPrompt.isAccessibilityServiceRunning(context)) {
            return false;
        }
        return KeyStore.getInstance().isConfirmationPromptSupported();
    }

    private /* synthetic */ void $$robo$$android_security_ConfirmationPrompt$__constructor__(Context x0, CharSequence x1, byte[] x2, 1 x3) {
    }

    private void doCallback(int n, byte[] byArray, ConfirmationCallback confirmationCallback) {
        InvokeDynamicSupport.bootstrap("doCallback", $$robo$$android_security_ConfirmationPrompt$doCallback(int byte[] android.security.ConfirmationCallback ), 0, this, n, byArray, confirmationCallback);
    }

    private void __constructor__(Context context, CharSequence charSequence, byte[] byArray) {
        this.$$robo$$android_security_ConfirmationPrompt$__constructor__(context, charSequence, byArray);
    }

    private ConfirmationPrompt(Context context, CharSequence charSequence, byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_ConfirmationPrompt$__constructor__(android.content.Context java.lang.CharSequence byte[] ), 0, this, context, charSequence, byArray);
    }

    private int getUiOptionsAsFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getUiOptionsAsFlags", $$robo$$android_security_ConfirmationPrompt$getUiOptionsAsFlags(), 0, this);
    }

    private static boolean isAccessibilityServiceRunning(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAccessibilityServiceRunning", $$robo$$android_security_ConfirmationPrompt$isAccessibilityServiceRunning(android.content.Context ), 0, (Context)context);
    }

    public void presentPrompt(Executor executor, ConfirmationCallback confirmationCallback) throws ConfirmationAlreadyPresentingException, ConfirmationNotAvailableException {
        InvokeDynamicSupport.bootstrap("presentPrompt", $$robo$$android_security_ConfirmationPrompt$presentPrompt(java.util.concurrent.Executor android.security.ConfirmationCallback ), 0, this, executor, confirmationCallback);
    }

    public void cancelPrompt() {
        InvokeDynamicSupport.bootstrap("cancelPrompt", $$robo$$android_security_ConfirmationPrompt$cancelPrompt(), 0, this);
    }

    public static boolean isSupported(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSupported", $$robo$$android_security_ConfirmationPrompt$isSupported(android.content.Context ), 0, (Context)context);
    }

    private /* synthetic */ void __constructor__(Context context, CharSequence charSequence, byte[] byArray, 1 var4_4) {
        this.$$robo$$android_security_ConfirmationPrompt$__constructor__(context, charSequence, byArray, var4_4);
    }

    public /* synthetic */ ConfirmationPrompt() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConfirmationPrompt)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private CharSequence mPromptText;
        private byte[] mExtraData;

        private void $$robo$$android_security_ConfirmationPrompt_Builder$__constructor__(Context context) {
            this.mContext = context;
        }

        private final Builder $$robo$$android_security_ConfirmationPrompt_Builder$setPromptText(CharSequence promptText) {
            this.mPromptText = promptText;
            return this;
        }

        private final Builder $$robo$$android_security_ConfirmationPrompt_Builder$setExtraData(byte[] extraData) {
            this.mExtraData = extraData;
            return this;
        }

        private final ConfirmationPrompt $$robo$$android_security_ConfirmationPrompt_Builder$build() {
            if (TextUtils.isEmpty(this.mPromptText)) {
                throw new IllegalArgumentException("prompt text must be set and non-empty");
            }
            if (this.mExtraData == null) {
                throw new IllegalArgumentException("extraData must be set");
            }
            return new ConfirmationPrompt(this.mContext, this.mPromptText, this.mExtraData);
        }

        private void __constructor__(Context context) {
            this.$$robo$$android_security_ConfirmationPrompt_Builder$__constructor__(context);
        }

        public Builder(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_ConfirmationPrompt_Builder$__constructor__(android.content.Context ), 0, this, context);
        }

        public Builder setPromptText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setPromptText", $$robo$$android_security_ConfirmationPrompt_Builder$setPromptText(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder setExtraData(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setExtraData", $$robo$$android_security_ConfirmationPrompt_Builder$setExtraData(byte[] ), 0, this, byArray);
        }

        public ConfirmationPrompt build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_security_ConfirmationPrompt_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

