/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keymaster.KeymasterArguments;
import android.security.keystore.AndroidKeyStoreCipherSpiBase;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.ArrayUtils;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AndroidKeyStore3DESCipherSpi
extends AndroidKeyStoreCipherSpiBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int BLOCK_SIZE_BYTES = 8;
    private int mKeymasterBlockMode;
    private int mKeymasterPadding;
    private boolean mIvRequired;
    private byte[] mIv;
    private boolean mIvHasBeenUsed;

    private void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$__constructor__(int keymasterBlockMode, int keymasterPadding, boolean ivRequired) {
        this.mKeymasterBlockMode = keymasterBlockMode;
        this.mKeymasterPadding = keymasterPadding;
        this.mIvRequired = ivRequired;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$initKey(int i, Key key) throws InvalidKeyException {
        if (!(key instanceof AndroidKeyStoreSecretKey)) {
            throw new InvalidKeyException("Unsupported key: " + (key != null ? key.getClass().getName() : "null"));
        }
        if (!"DESede".equalsIgnoreCase(key.getAlgorithm())) {
            throw new InvalidKeyException("Unsupported key algorithm: " + key.getAlgorithm() + ". Only " + "DESede" + " supported");
        }
        this.setKey((AndroidKeyStoreSecretKey)key);
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$engineGetBlockSize() {
        return 8;
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$engineGetOutputSize(int inputLen) {
        return inputLen + 24;
    }

    private final byte[] $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$engineGetIV() {
        return ArrayUtils.cloneIfNotEmpty(this.mIv);
    }

    private final AlgorithmParameters $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$engineGetParameters() {
        if (!this.mIvRequired) {
            return null;
        }
        if (this.mIv != null && this.mIv.length > 0) {
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance("DESede");
                params.init(new IvParameterSpec(this.mIv));
                return params;
            }
            catch (NoSuchAlgorithmException e) {
                throw new ProviderException("Failed to obtain 3DES AlgorithmParameters", e);
            }
            catch (InvalidParameterSpecException e) {
                throw new ProviderException("Failed to initialize 3DES AlgorithmParameters with an IV", e);
            }
        }
        return null;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$initAlgorithmSpecificParameters() throws InvalidKeyException {
        if (!this.mIvRequired) {
            return;
        }
        if (!this.isEncrypting()) {
            throw new InvalidKeyException("IV required when decrypting. Use IvParameterSpec or AlgorithmParameters to provide it.");
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!this.mIvRequired) {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unsupported parameters: " + params);
            }
            return;
        }
        if (params == null) {
            if (!this.isEncrypting()) {
                throw new InvalidAlgorithmParameterException("IvParameterSpec must be provided when decrypting");
            }
            return;
        }
        if (!(params instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only IvParameterSpec supported");
        }
        this.mIv = ((IvParameterSpec)params).getIV();
        if (this.mIv == null) {
            throw new InvalidAlgorithmParameterException("Null IV in IvParameterSpec");
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        IvParameterSpec ivSpec;
        if (!this.mIvRequired) {
            if (params != null) {
                throw new InvalidAlgorithmParameterException("Unsupported parameters: " + params);
            }
            return;
        }
        if (params == null) {
            if (!this.isEncrypting()) {
                throw new InvalidAlgorithmParameterException("IV required when decrypting. Use IvParameterSpec or AlgorithmParameters to provide it.");
            }
            return;
        }
        if (!"DESede".equalsIgnoreCase(params.getAlgorithm())) {
            throw new InvalidAlgorithmParameterException("Unsupported AlgorithmParameters algorithm: " + params.getAlgorithm() + ". Supported: DESede");
        }
        try {
            ivSpec = params.getParameterSpec(IvParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            if (!this.isEncrypting()) {
                throw new InvalidAlgorithmParameterException("IV required when decrypting, but not found in parameters: " + params, e);
            }
            this.mIv = null;
            return;
        }
        this.mIv = ivSpec.getIV();
        if (this.mIv == null) {
            throw new InvalidAlgorithmParameterException("Null IV in AlgorithmParameters");
        }
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$getAdditionalEntropyAmountForBegin() {
        if (this.mIvRequired && this.mIv == null && this.isEncrypting()) {
            return 8;
        }
        return 0;
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$getAdditionalEntropyAmountForFinish() {
        return 0;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
        if (this.isEncrypting() && this.mIvRequired && this.mIvHasBeenUsed) {
            throw new IllegalStateException("IV has already been used. Reusing IV in encryption mode violates security best practices.");
        }
        keymasterArgs.addEnum(0x10000002, 33);
        keymasterArgs.addEnum(0x20000004, this.mKeymasterBlockMode);
        keymasterArgs.addEnum(0x20000006, this.mKeymasterPadding);
        if (this.mIvRequired && this.mIv != null) {
            keymasterArgs.addBytes(-1879047191, this.mIv);
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArgs) {
        this.mIvHasBeenUsed = true;
        byte[] returnedIv = keymasterArgs.getBytes(-1879047191, null);
        if (returnedIv != null && returnedIv.length == 0) {
            returnedIv = null;
        }
        if (this.mIvRequired) {
            if (this.mIv == null) {
                this.mIv = returnedIv;
            } else if (returnedIv != null && !Arrays.equals(returnedIv, this.mIv)) {
                throw new ProviderException("IV in use differs from provided IV");
            }
        } else if (returnedIv != null) {
            throw new ProviderException("IV in use despite IV not being used by this transformation");
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$resetAll() {
        this.mIv = null;
        this.mIvHasBeenUsed = false;
        super.resetAll();
    }

    private void __constructor__(int n, int n2, boolean bl) {
        this.$$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$__constructor__(n, n2, bl);
    }

    AndroidKeyStore3DESCipherSpi(int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$__constructor__(int int boolean ), 0, this, n, n2, bl);
    }

    @Override
    protected void initKey(int n, Key key) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("initKey", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$initKey(int java.security.Key ), 0, this, n, key);
    }

    @Override
    protected int engineGetBlockSize() {
        return (int)InvokeDynamicSupport.bootstrap("engineGetBlockSize", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$engineGetBlockSize(), 0, this);
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return (int)InvokeDynamicSupport.bootstrap("engineGetOutputSize", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$engineGetOutputSize(int ), 0, this, n);
    }

    @Override
    protected byte[] engineGetIV() {
        return InvokeDynamicSupport.bootstrap("engineGetIV", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$engineGetIV(), 0, this);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return InvokeDynamicSupport.bootstrap("engineGetParameters", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$engineGetParameters(), 0, this);
    }

    @Override
    protected void initAlgorithmSpecificParameters() throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$initAlgorithmSpecificParameters(), 0, this);
    }

    @Override
    protected void initAlgorithmSpecificParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$initAlgorithmSpecificParameters(java.security.spec.AlgorithmParameterSpec ), 0, this, algorithmParameterSpec);
    }

    @Override
    protected void initAlgorithmSpecificParameters(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$initAlgorithmSpecificParameters(java.security.AlgorithmParameters ), 0, this, algorithmParameters);
    }

    @Override
    protected int getAdditionalEntropyAmountForBegin() {
        return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForBegin", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$getAdditionalEntropyAmountForBegin(), 0, this);
    }

    @Override
    protected int getAdditionalEntropyAmountForFinish() {
        return (int)InvokeDynamicSupport.bootstrap("getAdditionalEntropyAmountForFinish", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$getAdditionalEntropyAmountForFinish(), 0, this);
    }

    @Override
    protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("addAlgorithmSpecificParametersToBegin", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$addAlgorithmSpecificParametersToBegin(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
    }

    @Override
    protected void loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("loadAlgorithmSpecificParametersFromBeginResult", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$loadAlgorithmSpecificParametersFromBeginResult(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
    }

    @Override
    protected void resetAll() {
        InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi$resetAll(), 0, this);
    }

    public /* synthetic */ AndroidKeyStore3DESCipherSpi() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStore3DESCipherSpi)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class CBC
    extends AndroidKeyStore3DESCipherSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC$__constructor__(int keymasterPadding) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC$__constructor__(n);
        }

        protected CBC(int n) {
            super(2, n, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ CBC() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CBC)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class PKCS7Padding
        extends CBC
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC_PKCS7Padding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC_PKCS7Padding$__constructor__();
            }

            public PKCS7Padding() {
                super(64);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC_PKCS7Padding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PKCS7Padding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class NoPadding
        extends CBC
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC_NoPadding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC_NoPadding$__constructor__();
            }

            public NoPadding() {
                super(1);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_CBC_NoPadding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPadding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class ECB
    extends AndroidKeyStore3DESCipherSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB$__constructor__(int keymasterPadding) {
        }

        private void __constructor__(int n) {
            this.$$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB$__constructor__(n);
        }

        protected ECB(int n) {
            super(1, n, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ ECB() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ECB)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class PKCS7Padding
        extends ECB
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB_PKCS7Padding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB_PKCS7Padding$__constructor__();
            }

            public PKCS7Padding() {
                super(64);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB_PKCS7Padding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PKCS7Padding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public static class NoPadding
        extends ECB
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB_NoPadding$__constructor__() {
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB_NoPadding$__constructor__();
            }

            public NoPadding() {
                super(1);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStore3DESCipherSpi_ECB_NoPadding$__constructor__(), 0, this);
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoPadding)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

