/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.Parcel;
import android.os.Parcelable;
import android.security.keystore.KeyGenParameterSpec;
import com.google.errorprone.annotations.DoNotMock;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ParcelableKeyGenParameterSpec
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int ALGORITHM_PARAMETER_SPEC_NONE = 1;
    private static int ALGORITHM_PARAMETER_SPEC_RSA = 2;
    private static int ALGORITHM_PARAMETER_SPEC_EC = 3;
    private KeyGenParameterSpec mSpec;
    public static Parcelable.Creator<ParcelableKeyGenParameterSpec> CREATOR;

    private void $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$__constructor__(KeyGenParameterSpec spec) {
        this.mSpec = spec;
    }

    private final int $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$describeContents() {
        return 0;
    }

    private static final void $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$writeOptionalDate(Parcel out, Date date) {
        if (date != null) {
            out.writeBoolean(true);
            out.writeLong(date.getTime());
        } else {
            out.writeBoolean(false);
        }
    }

    private final void $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$writeToParcel(Parcel out, int flags) {
        out.writeString(this.mSpec.getKeystoreAlias());
        out.writeInt(this.mSpec.getPurposes());
        out.writeInt(this.mSpec.getUid());
        out.writeInt(this.mSpec.getKeySize());
        AlgorithmParameterSpec algoSpec = this.mSpec.getAlgorithmParameterSpec();
        if (algoSpec == null) {
            out.writeInt(1);
        } else if (algoSpec instanceof RSAKeyGenParameterSpec) {
            RSAKeyGenParameterSpec rsaSpec = (RSAKeyGenParameterSpec)algoSpec;
            out.writeInt(2);
            out.writeInt(rsaSpec.getKeysize());
            out.writeByteArray(rsaSpec.getPublicExponent().toByteArray());
        } else if (algoSpec instanceof ECGenParameterSpec) {
            ECGenParameterSpec ecSpec = (ECGenParameterSpec)algoSpec;
            out.writeInt(3);
            out.writeString(ecSpec.getName());
        } else {
            throw new IllegalArgumentException(String.format("Unknown algorithm parameter spec: %s", algoSpec.getClass()));
        }
        out.writeByteArray(this.mSpec.getCertificateSubject().getEncoded());
        out.writeByteArray(this.mSpec.getCertificateSerialNumber().toByteArray());
        out.writeLong(this.mSpec.getCertificateNotBefore().getTime());
        out.writeLong(this.mSpec.getCertificateNotAfter().getTime());
        ParcelableKeyGenParameterSpec.writeOptionalDate(out, this.mSpec.getKeyValidityStart());
        ParcelableKeyGenParameterSpec.writeOptionalDate(out, this.mSpec.getKeyValidityForOriginationEnd());
        ParcelableKeyGenParameterSpec.writeOptionalDate(out, this.mSpec.getKeyValidityForConsumptionEnd());
        if (this.mSpec.isDigestsSpecified()) {
            out.writeStringArray(this.mSpec.getDigests());
        } else {
            out.writeStringArray(null);
        }
        out.writeStringArray(this.mSpec.getEncryptionPaddings());
        out.writeStringArray(this.mSpec.getSignaturePaddings());
        out.writeStringArray(this.mSpec.getBlockModes());
        out.writeBoolean(this.mSpec.isRandomizedEncryptionRequired());
        out.writeBoolean(this.mSpec.isUserAuthenticationRequired());
        out.writeInt(this.mSpec.getUserAuthenticationValidityDurationSeconds());
        out.writeBoolean(this.mSpec.isUserPresenceRequired());
        out.writeByteArray(this.mSpec.getAttestationChallenge());
        out.writeBoolean(this.mSpec.isUniqueIdIncluded());
        out.writeBoolean(this.mSpec.isUserAuthenticationValidWhileOnBody());
        out.writeBoolean(this.mSpec.isInvalidatedByBiometricEnrollment());
        out.writeBoolean(this.mSpec.isStrongBoxBacked());
        out.writeBoolean(this.mSpec.isUserConfirmationRequired());
        out.writeBoolean(this.mSpec.isUnlockedDeviceRequired());
    }

    private static final Date $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$readDateOrNull(Parcel in) {
        boolean hasDate = in.readBoolean();
        if (hasDate) {
            return new Date(in.readLong());
        }
        return null;
    }

    private void $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$__constructor__(Parcel in) {
        String keystoreAlias = in.readString();
        int purposes = in.readInt();
        int uid = in.readInt();
        int keySize = in.readInt();
        int keySpecType = in.readInt();
        AlgorithmParameterSpec algorithmSpec = null;
        if (keySpecType == 1) {
            algorithmSpec = null;
        } else if (keySpecType == 2) {
            int rsaKeySize = in.readInt();
            BigInteger publicExponent = new BigInteger(in.createByteArray());
            algorithmSpec = new RSAKeyGenParameterSpec(rsaKeySize, publicExponent);
        } else if (keySpecType == 3) {
            String stdName = in.readString();
            algorithmSpec = new ECGenParameterSpec(stdName);
        } else {
            throw new IllegalArgumentException(String.format("Unknown algorithm parameter spec: %d", keySpecType));
        }
        X500Principal certificateSubject = new X500Principal(in.createByteArray());
        BigInteger certificateSerialNumber = new BigInteger(in.createByteArray());
        Date certificateNotBefore = new Date(in.readLong());
        Date certificateNotAfter = new Date(in.readLong());
        Date keyValidityStartDate = ParcelableKeyGenParameterSpec.readDateOrNull(in);
        Date keyValidityForOriginationEnd = ParcelableKeyGenParameterSpec.readDateOrNull(in);
        Date keyValidityForConsumptionEnd = ParcelableKeyGenParameterSpec.readDateOrNull(in);
        String[] digests = in.createStringArray();
        String[] encryptionPaddings = in.createStringArray();
        String[] signaturePaddings = in.createStringArray();
        String[] blockModes = in.createStringArray();
        boolean randomizedEncryptionRequired = in.readBoolean();
        boolean userAuthenticationRequired = in.readBoolean();
        int userAuthenticationValidityDurationSeconds = in.readInt();
        boolean userPresenceRequired = in.readBoolean();
        byte[] attestationChallenge = in.createByteArray();
        boolean uniqueIdIncluded = in.readBoolean();
        boolean userAuthenticationValidWhileOnBody = in.readBoolean();
        boolean invalidatedByBiometricEnrollment = in.readBoolean();
        boolean isStrongBoxBacked = in.readBoolean();
        boolean userConfirmationRequired = in.readBoolean();
        boolean unlockedDeviceRequired = in.readBoolean();
        this.mSpec = new KeyGenParameterSpec(keystoreAlias, uid, keySize, algorithmSpec, certificateSubject, certificateSerialNumber, certificateNotBefore, certificateNotAfter, keyValidityStartDate, keyValidityForOriginationEnd, keyValidityForConsumptionEnd, purposes, digests, encryptionPaddings, signaturePaddings, blockModes, randomizedEncryptionRequired, userAuthenticationRequired, userAuthenticationValidityDurationSeconds, userPresenceRequired, attestationChallenge, uniqueIdIncluded, userAuthenticationValidWhileOnBody, invalidatedByBiometricEnrollment, isStrongBoxBacked, userConfirmationRequired, unlockedDeviceRequired);
    }

    private final KeyGenParameterSpec $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$getSpec() {
        return this.mSpec;
    }

    private /* synthetic */ void $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ParcelableKeyGenParameterSpec>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec_1$__constructor__() {
            }

            private final ParcelableKeyGenParameterSpec $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec_1$createFromParcel(Parcel in) {
                return new ParcelableKeyGenParameterSpec(in);
            }

            private final ParcelableKeyGenParameterSpec[] $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec_1$newArray(int size) {
                return new ParcelableKeyGenParameterSpec[size];
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_ParcelableKeyGenParameterSpec_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec_1$__constructor__(), 0, this);
            }

            @Override
            public ParcelableKeyGenParameterSpec createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ParcelableKeyGenParameterSpec[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(KeyGenParameterSpec keyGenParameterSpec) {
        this.$$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$__constructor__(keyGenParameterSpec);
    }

    public ParcelableKeyGenParameterSpec(KeyGenParameterSpec keyGenParameterSpec) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$__constructor__(android.security.keystore.KeyGenParameterSpec ), 0, this, keyGenParameterSpec);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$describeContents(), 0, this);
    }

    private static void writeOptionalDate(Parcel parcel, Date date) {
        InvokeDynamicSupport.bootstrapStatic("writeOptionalDate", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$writeOptionalDate(android.os.Parcel java.util.Date ), 0, (Parcel)parcel, (Date)date);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static Date readDateOrNull(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readDateOrNull", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$readDateOrNull(android.os.Parcel ), 0, (Parcel)parcel);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$__constructor__(parcel);
    }

    private ParcelableKeyGenParameterSpec(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public KeyGenParameterSpec getSpec() {
        return InvokeDynamicSupport.bootstrap("getSpec", $$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$getSpec(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_security_keystore_ParcelableKeyGenParameterSpec$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(ParcelableKeyGenParameterSpec.class);
    }

    public /* synthetic */ ParcelableKeyGenParameterSpec() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableKeyGenParameterSpec)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

