/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.security.keystore.recovery.DecryptionFailedException;
import android.security.keystore.recovery.InternalRecoveryServiceException;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.RecoveryCertPath;
import android.security.keystore.recovery.RecoveryController;
import android.security.keystore.recovery.SessionExpiredException;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.util.ArrayMap;
import android.util.Log;
import java.security.Key;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class RecoverySession
implements AutoCloseable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RecoverySession";
    private static int SESSION_ID_LENGTH_BYTES = 16;
    private String mSessionId;
    private RecoveryController mRecoveryController;

    private void $$robo$$android_security_keystore_recovery_RecoverySession$__constructor__(RecoveryController recoveryController, String sessionId) {
        this.mRecoveryController = recoveryController;
        this.mSessionId = sessionId;
    }

    private static final RecoverySession $$robo$$android_security_keystore_recovery_RecoverySession$newInstance(RecoveryController recoveryController) {
        return new RecoverySession(recoveryController, RecoverySession.newSessionId());
    }

    private static final String $$robo$$android_security_keystore_recovery_RecoverySession$newSessionId() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] sessionId = new byte[16];
        secureRandom.nextBytes(sessionId);
        StringBuilder sb = new StringBuilder();
        for (byte b : sessionId) {
            sb.append(Byte.toHexString((byte)b, (boolean)false));
        }
        return sb.toString();
    }

    @Deprecated
    private final byte[] $$robo$$android_security_keystore_recovery_RecoverySession$start(byte[] verifierPublicKey, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws CertificateException, InternalRecoveryServiceException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    private final byte[] $$robo$$android_security_keystore_recovery_RecoverySession$start(CertPath verifierCertPath, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws CertificateException, InternalRecoveryServiceException {
        throw new UnsupportedOperationException();
    }

    private final byte[] $$robo$$android_security_keystore_recovery_RecoverySession$start(String rootCertificateAlias, CertPath verifierCertPath, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws CertificateException, InternalRecoveryServiceException {
        RecoveryCertPath recoveryCertPath = RecoveryCertPath.createRecoveryCertPath(verifierCertPath);
        try {
            byte[] recoveryClaim = this.mRecoveryController.getBinder().startRecoverySessionWithCertPath(this.mSessionId, rootCertificateAlias, recoveryCertPath, vaultParams, vaultChallenge, secrets);
            return recoveryClaim;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 25 || e.errorCode == 28) {
                throw new CertificateException("Invalid certificate for recovery session", e);
            }
            throw this.mRecoveryController.wrapUnexpectedServiceSpecificException(e);
        }
    }

    @Deprecated
    private final Map<String, byte[]> $$robo$$android_security_keystore_recovery_RecoverySession$recoverKeys(byte[] recoveryKeyBlob, List<WrappedApplicationKey> applicationKeys) throws SessionExpiredException, DecryptionFailedException, InternalRecoveryServiceException {
        throw new UnsupportedOperationException();
    }

    private final Map<String, Key> $$robo$$android_security_keystore_recovery_RecoverySession$recoverKeyChainSnapshot(byte[] recoveryKeyBlob, List<WrappedApplicationKey> applicationKeys) throws SessionExpiredException, DecryptionFailedException, InternalRecoveryServiceException {
        try {
            Map grantAliases = this.mRecoveryController.getBinder().recoverKeyChainSnapshot(this.mSessionId, recoveryKeyBlob, applicationKeys);
            return this.getKeysFromGrants(grantAliases);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 26) {
                throw new DecryptionFailedException(e.getMessage());
            }
            if (e.errorCode == 24) {
                throw new SessionExpiredException(e.getMessage());
            }
            throw this.mRecoveryController.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final Map<String, Key> $$robo$$android_security_keystore_recovery_RecoverySession$getKeysFromGrants(Map<String, String> grantAliases) throws InternalRecoveryServiceException {
        ArrayMap<String, Key> keysByAlias = new ArrayMap<String, Key>(grantAliases.size());
        for (String alias : grantAliases.keySet()) {
            Key key;
            String grantAlias = grantAliases.get(alias);
            try {
                key = this.mRecoveryController.getKeyFromGrant(grantAlias);
            }
            catch (UnrecoverableKeyException e) {
                throw new InternalRecoveryServiceException(String.format(Locale.US, "Failed to get key '%s' from grant '%s'", alias, grantAlias), e);
            }
            keysByAlias.put(alias, key);
        }
        return keysByAlias;
    }

    private final String $$robo$$android_security_keystore_recovery_RecoverySession$getSessionId() {
        return this.mSessionId;
    }

    private final void $$robo$$android_security_keystore_recovery_RecoverySession$close() {
        try {
            this.mRecoveryController.getBinder().closeSession(this.mSessionId);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e("RecoverySession", "Unexpected error trying to close session", e);
        }
    }

    private void __constructor__(RecoveryController recoveryController, String string2) {
        this.$$robo$$android_security_keystore_recovery_RecoverySession$__constructor__(recoveryController, string2);
    }

    private RecoverySession(RecoveryController recoveryController, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_recovery_RecoverySession$__constructor__(android.security.keystore.recovery.RecoveryController java.lang.String ), 0, this, recoveryController, string2);
    }

    static RecoverySession newInstance(RecoveryController recoveryController) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_security_keystore_recovery_RecoverySession$newInstance(android.security.keystore.recovery.RecoveryController ), 0, (RecoveryController)recoveryController);
    }

    private static String newSessionId() {
        return InvokeDynamicSupport.bootstrapStatic("newSessionId", $$robo$$android_security_keystore_recovery_RecoverySession$newSessionId(), 0);
    }

    @Deprecated
    public byte[] start(byte[] byArray, byte[] byArray2, byte[] byArray3, List<KeyChainProtectionParams> list) throws CertificateException, InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("start", $$robo$$android_security_keystore_recovery_RecoverySession$start(byte[] byte[] byte[] java.util.List<android.security.keystore.recovery.KeyChainProtectionParams> ), 0, this, byArray, byArray2, byArray3, list);
    }

    @Deprecated
    public byte[] start(CertPath certPath, byte[] byArray, byte[] byArray2, List<KeyChainProtectionParams> list) throws CertificateException, InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("start", $$robo$$android_security_keystore_recovery_RecoverySession$start(java.security.cert.CertPath byte[] byte[] java.util.List<android.security.keystore.recovery.KeyChainProtectionParams> ), 0, this, certPath, byArray, byArray2, list);
    }

    public byte[] start(String string2, CertPath certPath, byte[] byArray, byte[] byArray2, List<KeyChainProtectionParams> list) throws CertificateException, InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("start", $$robo$$android_security_keystore_recovery_RecoverySession$start(java.lang.String java.security.cert.CertPath byte[] byte[] java.util.List<android.security.keystore.recovery.KeyChainProtectionParams> ), 0, this, string2, certPath, byArray, byArray2, list);
    }

    @Deprecated
    public Map<String, byte[]> recoverKeys(byte[] byArray, List<WrappedApplicationKey> list) throws SessionExpiredException, DecryptionFailedException, InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("recoverKeys", $$robo$$android_security_keystore_recovery_RecoverySession$recoverKeys(byte[] java.util.List<android.security.keystore.recovery.WrappedApplicationKey> ), 0, this, byArray, list);
    }

    public Map<String, Key> recoverKeyChainSnapshot(byte[] byArray, List<WrappedApplicationKey> list) throws SessionExpiredException, DecryptionFailedException, InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("recoverKeyChainSnapshot", $$robo$$android_security_keystore_recovery_RecoverySession$recoverKeyChainSnapshot(byte[] java.util.List<android.security.keystore.recovery.WrappedApplicationKey> ), 0, this, byArray, list);
    }

    private Map<String, Key> getKeysFromGrants(Map<String, String> map) throws InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("getKeysFromGrants", $$robo$$android_security_keystore_recovery_RecoverySession$getKeysFromGrants(java.util.Map<java.lang.String, java.lang.String> ), 0, this, map);
    }

    String getSessionId() {
        return InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_security_keystore_recovery_RecoverySession$getSessionId(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_security_keystore_recovery_RecoverySession$close(), 0, this);
    }

    public /* synthetic */ RecoverySession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecoverySession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

