/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.icu.text.DateFormat;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalTransformation;
import android.service.autofill.Transformation;
import android.service.autofill.ValueFinder;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DateTransformation
extends InternalTransformation
implements Transformation,
Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DateTransformation";
    private AutofillId mFieldId;
    private DateFormat mDateFormat;
    public static Parcelable.Creator<DateTransformation> CREATOR;

    private void $$robo$$android_service_autofill_DateTransformation$__constructor__(AutofillId id2, DateFormat dateFormat) {
        this.mFieldId = Preconditions.checkNotNull(id2);
        this.mDateFormat = Preconditions.checkNotNull(dateFormat);
    }

    private final void $$robo$$android_service_autofill_DateTransformation$apply(ValueFinder finder, RemoteViews parentTemplate, int childViewId) throws Exception {
        AutofillValue value = finder.findRawValueByAutofillId(this.mFieldId);
        if (value == null) {
            Log.w("DateTransformation", "No value for id " + this.mFieldId);
            return;
        }
        if (!value.isDate()) {
            Log.w("DateTransformation", "Value for " + this.mFieldId + " is not date: " + value);
            return;
        }
        try {
            Date date = new Date(value.getDateValue());
            String transformed = this.mDateFormat.format(date);
            if (Helper.sDebug) {
                Log.d("DateTransformation", "Transformed " + date + " to " + transformed);
            }
            parentTemplate.setCharSequence(childViewId, "setText", transformed);
        }
        catch (Exception e) {
            Log.w("DateTransformation", "Could not apply " + this.mDateFormat + " to " + value + ": " + e);
        }
    }

    private final String $$robo$$android_service_autofill_DateTransformation$toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "DateTransformation: [id=" + this.mFieldId + ", format=" + this.mDateFormat + "]";
    }

    private final int $$robo$$android_service_autofill_DateTransformation$describeContents() {
        return 0;
    }

    private final void $$robo$$android_service_autofill_DateTransformation$writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mFieldId, flags);
        parcel.writeSerializable(this.mDateFormat);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<DateTransformation>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_autofill_DateTransformation_1$__constructor__() {
            }

            private final DateTransformation $$robo$$android_service_autofill_DateTransformation_1$createFromParcel(Parcel parcel) {
                return new DateTransformation((AutofillId)parcel.readParcelable(null), (DateFormat)parcel.readSerializable());
            }

            private final DateTransformation[] $$robo$$android_service_autofill_DateTransformation_1$newArray(int size) {
                return new DateTransformation[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_autofill_DateTransformation_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_DateTransformation_1$__constructor__(), 0, this);
            }

            @Override
            public DateTransformation createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_autofill_DateTransformation_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public DateTransformation[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_autofill_DateTransformation_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(AutofillId autofillId, DateFormat dateFormat) {
        this.$$robo$$android_service_autofill_DateTransformation$__constructor__(autofillId, dateFormat);
    }

    public DateTransformation(AutofillId autofillId, DateFormat dateFormat) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_DateTransformation$__constructor__(android.view.autofill.AutofillId android.icu.text.DateFormat ), 0, this, autofillId, dateFormat);
    }

    @Override
    public void apply(ValueFinder valueFinder, RemoteViews remoteViews, int n) throws Exception {
        InvokeDynamicSupport.bootstrap("apply", $$robo$$android_service_autofill_DateTransformation$apply(android.service.autofill.ValueFinder android.widget.RemoteViews int ), 0, this, valueFinder, remoteViews, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_autofill_DateTransformation$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_autofill_DateTransformation$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_autofill_DateTransformation$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(DateTransformation.class);
    }

    public /* synthetic */ DateTransformation() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateTransformation)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

