/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.icu.text.DateFormat;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalSanitizer;
import android.service.autofill.Sanitizer;
import android.util.Log;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DateValueSanitizer
extends InternalSanitizer
implements Sanitizer,
Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DateValueSanitizer";
    private DateFormat mDateFormat;
    public static Parcelable.Creator<DateValueSanitizer> CREATOR;

    private void $$robo$$android_service_autofill_DateValueSanitizer$__constructor__(DateFormat dateFormat) {
        this.mDateFormat = Preconditions.checkNotNull(dateFormat);
    }

    private final AutofillValue $$robo$$android_service_autofill_DateValueSanitizer$sanitize(AutofillValue value) {
        if (value == null) {
            Log.w("DateValueSanitizer", "sanitize() called with null value");
            return null;
        }
        if (!value.isDate()) {
            if (Helper.sDebug) {
                Log.d("DateValueSanitizer", value + " is not a date");
            }
            return null;
        }
        try {
            Date date = new Date(value.getDateValue());
            String converted = this.mDateFormat.format(date);
            if (Helper.sDebug) {
                Log.d("DateValueSanitizer", "Transformed " + date + " to " + converted);
            }
            Date sanitized = this.mDateFormat.parse(converted);
            if (Helper.sDebug) {
                Log.d("DateValueSanitizer", "Sanitized to " + sanitized);
            }
            return AutofillValue.forDate(sanitized.getTime());
        }
        catch (Exception e) {
            Log.w("DateValueSanitizer", "Could not apply " + this.mDateFormat + " to " + value + ": " + e);
            return null;
        }
    }

    private final String $$robo$$android_service_autofill_DateValueSanitizer$toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "DateValueSanitizer: [dateFormat=" + this.mDateFormat + "]";
    }

    private final int $$robo$$android_service_autofill_DateValueSanitizer$describeContents() {
        return 0;
    }

    private final void $$robo$$android_service_autofill_DateValueSanitizer$writeToParcel(Parcel parcel, int flags) {
        parcel.writeSerializable(this.mDateFormat);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<DateValueSanitizer>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_autofill_DateValueSanitizer_1$__constructor__() {
            }

            private final DateValueSanitizer $$robo$$android_service_autofill_DateValueSanitizer_1$createFromParcel(Parcel parcel) {
                return new DateValueSanitizer((DateFormat)parcel.readSerializable());
            }

            private final DateValueSanitizer[] $$robo$$android_service_autofill_DateValueSanitizer_1$newArray(int size) {
                return new DateValueSanitizer[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_autofill_DateValueSanitizer_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_DateValueSanitizer_1$__constructor__(), 0, this);
            }

            @Override
            public DateValueSanitizer createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_autofill_DateValueSanitizer_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public DateValueSanitizer[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_autofill_DateValueSanitizer_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(DateFormat dateFormat) {
        this.$$robo$$android_service_autofill_DateValueSanitizer$__constructor__(dateFormat);
    }

    public DateValueSanitizer(DateFormat dateFormat) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_DateValueSanitizer$__constructor__(android.icu.text.DateFormat ), 0, this, dateFormat);
    }

    @Override
    public AutofillValue sanitize(AutofillValue autofillValue) {
        return InvokeDynamicSupport.bootstrap("sanitize", $$robo$$android_service_autofill_DateValueSanitizer$sanitize(android.view.autofill.AutofillValue ), 0, this, autofillValue);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_autofill_DateValueSanitizer$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_autofill_DateValueSanitizer$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_autofill_DateValueSanitizer$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(DateValueSanitizer.class);
    }

    public /* synthetic */ DateValueSanitizer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DateValueSanitizer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

