/*
 * Decompiled with CFR 0.152.
 */
package android.service.dreams;

import android.app.Service;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.dreams.IDreamManager;
import android.service.dreams.IDreamService;
import android.util.MathUtils;
import android.util.Slog;
import android.view.ActionMode;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.accessibility.AccessibilityEvent;
import com.android.internal.policy.PhoneWindow;
import com.android.internal.util.DumpUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DreamService
extends Service
implements Window.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    public static String DREAM_SERVICE = "dreams";
    public static String SERVICE_INTERFACE = "android.service.dreams.DreamService";
    public static String DREAM_META_DATA = "android.service.dream";
    private IDreamManager mSandman;
    private Handler mHandler;
    private IBinder mWindowToken;
    private Window mWindow;
    private boolean mInteractive;
    private boolean mLowProfile;
    private boolean mFullscreen;
    private boolean mScreenBright;
    private boolean mStarted;
    private boolean mWaking;
    private boolean mFinished;
    private boolean mCanDoze;
    private boolean mDozing;
    private boolean mWindowless;
    private int mDozeScreenState;
    private int mDozeScreenBrightness;
    private boolean mDebug;

    private void $$robo$$android_service_dreams_DreamService$__constructor__() {
        this.TAG = DreamService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
        this.mHandler = new Handler();
        this.mLowProfile = true;
        this.mScreenBright = true;
        this.mDozeScreenState = 0;
        this.mDozeScreenBrightness = -1;
        this.mDebug = false;
        this.mSandman = IDreamManager.Stub.asInterface(ServiceManager.getService("dreams"));
    }

    private final void $$robo$$android_service_dreams_DreamService$setDebug(boolean dbg) {
        this.mDebug = dbg;
    }

    private final boolean $$robo$$android_service_dreams_DreamService$dispatchKeyEvent(KeyEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on keyEvent");
            }
            this.wakeUp();
            return true;
        }
        if (event.getKeyCode() == 4) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on back key");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchKeyEvent(event);
    }

    private final boolean $$robo$$android_service_dreams_DreamService$dispatchKeyShortcutEvent(KeyEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on keyShortcutEvent");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchKeyShortcutEvent(event);
    }

    private final boolean $$robo$$android_service_dreams_DreamService$dispatchTouchEvent(MotionEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on touchEvent");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchTouchEvent(event);
    }

    private final boolean $$robo$$android_service_dreams_DreamService$dispatchTrackballEvent(MotionEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on trackballEvent");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchTrackballEvent(event);
    }

    private final boolean $$robo$$android_service_dreams_DreamService$dispatchGenericMotionEvent(MotionEvent event) {
        if (!this.mInteractive) {
            if (this.mDebug) {
                Slog.v(this.TAG, "Waking up on genericMotionEvent");
            }
            this.wakeUp();
            return true;
        }
        return this.mWindow.superDispatchGenericMotionEvent(event);
    }

    private final boolean $$robo$$android_service_dreams_DreamService$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return false;
    }

    private final View $$robo$$android_service_dreams_DreamService$onCreatePanelView(int featureId) {
        return null;
    }

    private final boolean $$robo$$android_service_dreams_DreamService$onCreatePanelMenu(int featureId, Menu menu2) {
        return false;
    }

    private final boolean $$robo$$android_service_dreams_DreamService$onPreparePanel(int featureId, View view, Menu menu2) {
        return false;
    }

    private final boolean $$robo$$android_service_dreams_DreamService$onMenuOpened(int featureId, Menu menu2) {
        return false;
    }

    private final boolean $$robo$$android_service_dreams_DreamService$onMenuItemSelected(int featureId, MenuItem item) {
        return false;
    }

    private final void $$robo$$android_service_dreams_DreamService$onWindowAttributesChanged(WindowManager.LayoutParams attrs) {
    }

    private final void $$robo$$android_service_dreams_DreamService$onContentChanged() {
    }

    private final void $$robo$$android_service_dreams_DreamService$onWindowFocusChanged(boolean hasFocus) {
    }

    private final void $$robo$$android_service_dreams_DreamService$onAttachedToWindow() {
    }

    private final void $$robo$$android_service_dreams_DreamService$onDetachedFromWindow() {
    }

    private final void $$robo$$android_service_dreams_DreamService$onPanelClosed(int featureId, Menu menu2) {
    }

    private final boolean $$robo$$android_service_dreams_DreamService$onSearchRequested(SearchEvent event) {
        return this.onSearchRequested();
    }

    private final boolean $$robo$$android_service_dreams_DreamService$onSearchRequested() {
        return false;
    }

    private final ActionMode $$robo$$android_service_dreams_DreamService$onWindowStartingActionMode(ActionMode.Callback callback) {
        return null;
    }

    private final ActionMode $$robo$$android_service_dreams_DreamService$onWindowStartingActionMode(ActionMode.Callback callback, int type) {
        return null;
    }

    private final void $$robo$$android_service_dreams_DreamService$onActionModeStarted(ActionMode mode) {
    }

    private final void $$robo$$android_service_dreams_DreamService$onActionModeFinished(ActionMode mode) {
    }

    private final WindowManager $$robo$$android_service_dreams_DreamService$getWindowManager() {
        return this.mWindow != null ? this.mWindow.getWindowManager() : null;
    }

    private final Window $$robo$$android_service_dreams_DreamService$getWindow() {
        return this.mWindow;
    }

    private final void $$robo$$android_service_dreams_DreamService$setContentView(int layoutResID) {
        this.getWindow().setContentView(layoutResID);
    }

    private final void $$robo$$android_service_dreams_DreamService$setContentView(View view) {
        this.getWindow().setContentView(view);
    }

    private final void $$robo$$android_service_dreams_DreamService$setContentView(View view, ViewGroup.LayoutParams params) {
        this.getWindow().setContentView(view, params);
    }

    private final void $$robo$$android_service_dreams_DreamService$addContentView(View view, ViewGroup.LayoutParams params) {
        this.getWindow().addContentView(view, params);
    }

    private final <T extends View> T $$robo$$android_service_dreams_DreamService$findViewById(int id2) {
        return this.getWindow().findViewById(id2);
    }

    private final <T extends View> T $$robo$$android_service_dreams_DreamService$requireViewById(int id2) {
        T view = this.findViewById(id2);
        if (view == null) {
            throw new IllegalArgumentException("ID does not reference a View inside this DreamService");
        }
        return view;
    }

    private final void $$robo$$android_service_dreams_DreamService$setInteractive(boolean interactive) {
        this.mInteractive = interactive;
    }

    private final boolean $$robo$$android_service_dreams_DreamService$isInteractive() {
        return this.mInteractive;
    }

    private final void $$robo$$android_service_dreams_DreamService$setLowProfile(boolean lowProfile) {
        if (this.mLowProfile != lowProfile) {
            this.mLowProfile = lowProfile;
            int flag = 1;
            this.applySystemUiVisibilityFlags(this.mLowProfile ? flag : 0, flag);
        }
    }

    private final boolean $$robo$$android_service_dreams_DreamService$isLowProfile() {
        return this.getSystemUiVisibilityFlagValue(1, this.mLowProfile);
    }

    private final void $$robo$$android_service_dreams_DreamService$setFullscreen(boolean fullscreen) {
        if (this.mFullscreen != fullscreen) {
            this.mFullscreen = fullscreen;
            int flag = 1024;
            this.applyWindowFlags(this.mFullscreen ? flag : 0, flag);
        }
    }

    private final boolean $$robo$$android_service_dreams_DreamService$isFullscreen() {
        return this.mFullscreen;
    }

    private final void $$robo$$android_service_dreams_DreamService$setScreenBright(boolean screenBright) {
        if (this.mScreenBright != screenBright) {
            this.mScreenBright = screenBright;
            int flag = 128;
            this.applyWindowFlags(this.mScreenBright ? flag : 0, flag);
        }
    }

    private final boolean $$robo$$android_service_dreams_DreamService$isScreenBright() {
        return this.getWindowFlagValue(128, this.mScreenBright);
    }

    private final void $$robo$$android_service_dreams_DreamService$setWindowless(boolean windowless) {
        this.mWindowless = windowless;
    }

    private final boolean $$robo$$android_service_dreams_DreamService$isWindowless() {
        return this.mWindowless;
    }

    private final boolean $$robo$$android_service_dreams_DreamService$canDoze() {
        return this.mCanDoze;
    }

    private final void $$robo$$android_service_dreams_DreamService$startDozing() {
        if (this.mCanDoze && !this.mDozing) {
            this.mDozing = true;
            this.updateDoze();
        }
    }

    private final void $$robo$$android_service_dreams_DreamService$updateDoze() {
        if (this.mWindowToken == null) {
            Slog.w(this.TAG, "Updating doze without a window token.");
            return;
        }
        if (this.mDozing) {
            try {
                this.mSandman.startDozing(this.mWindowToken, this.mDozeScreenState, this.mDozeScreenBrightness);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$android_service_dreams_DreamService$stopDozing() {
        if (this.mDozing) {
            this.mDozing = false;
            try {
                this.mSandman.stopDozing(this.mWindowToken);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final boolean $$robo$$android_service_dreams_DreamService$isDozing() {
        return this.mDozing;
    }

    private final int $$robo$$android_service_dreams_DreamService$getDozeScreenState() {
        return this.mDozeScreenState;
    }

    private final void $$robo$$android_service_dreams_DreamService$setDozeScreenState(int state) {
        if (this.mDozeScreenState != state) {
            this.mDozeScreenState = state;
            this.updateDoze();
        }
    }

    private final int $$robo$$android_service_dreams_DreamService$getDozeScreenBrightness() {
        return this.mDozeScreenBrightness;
    }

    private final void $$robo$$android_service_dreams_DreamService$setDozeScreenBrightness(int brightness) {
        if (brightness != -1) {
            brightness = DreamService.clampAbsoluteBrightness(brightness);
        }
        if (this.mDozeScreenBrightness != brightness) {
            this.mDozeScreenBrightness = brightness;
            this.updateDoze();
        }
    }

    private final void $$robo$$android_service_dreams_DreamService$onCreate() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onCreate()");
        }
        super.onCreate();
    }

    private final void $$robo$$android_service_dreams_DreamService$onDreamingStarted() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDreamingStarted()");
        }
    }

    private final void $$robo$$android_service_dreams_DreamService$onDreamingStopped() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDreamingStopped()");
        }
    }

    private final void $$robo$$android_service_dreams_DreamService$onWakeUp() {
        this.finish();
    }

    private final IBinder $$robo$$android_service_dreams_DreamService$onBind(Intent intent) {
        if (this.mDebug) {
            Slog.v(this.TAG, "onBind() intent = " + intent);
        }
        return new DreamServiceWrapper(this);
    }

    private final void $$robo$$android_service_dreams_DreamService$finish() {
        if (this.mDebug) {
            Slog.v(this.TAG, "finish(): mFinished=" + this.mFinished);
        }
        if (!this.mFinished) {
            this.mFinished = true;
            if (this.mWindowToken == null) {
                Slog.w(this.TAG, "Finish was called before the dream was attached.");
            } else {
                try {
                    this.mSandman.finishSelf(this.mWindowToken, true);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.stopSelf();
        }
    }

    private final void $$robo$$android_service_dreams_DreamService$wakeUp() {
        this.wakeUp(false);
    }

    private final void $$robo$$android_service_dreams_DreamService$wakeUp(boolean fromSystem) {
        if (this.mDebug) {
            Slog.v(this.TAG, "wakeUp(): fromSystem=" + fromSystem + ", mWaking=" + this.mWaking + ", mFinished=" + this.mFinished);
        }
        if (!this.mWaking && !this.mFinished) {
            this.mWaking = true;
            this.onWakeUp();
            if (!fromSystem && !this.mFinished) {
                if (this.mWindowToken == null) {
                    Slog.w(this.TAG, "WakeUp was called before the dream was attached.");
                } else {
                    try {
                        this.mSandman.finishSelf(this.mWindowToken, false);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final void $$robo$$android_service_dreams_DreamService$onDestroy() {
        if (this.mDebug) {
            Slog.v(this.TAG, "onDestroy()");
        }
        this.detach();
        super.onDestroy();
    }

    private final void $$robo$$android_service_dreams_DreamService$detach() {
        if (this.mStarted) {
            if (this.mDebug) {
                Slog.v(this.TAG, "detach(): Calling onDreamingStopped()");
            }
            this.mStarted = false;
            this.onDreamingStopped();
        }
        if (this.mWindow != null) {
            if (this.mDebug) {
                Slog.v(this.TAG, "detach(): Removing window from window manager");
            }
            this.mWindow.getWindowManager().removeViewImmediate(this.mWindow.getDecorView());
            this.mWindow = null;
        }
        if (this.mWindowToken != null) {
            WindowManagerGlobal.getInstance().closeAll(this.mWindowToken, this.getClass().getName(), "Dream");
            this.mWindowToken = null;
            this.mCanDoze = false;
        }
    }

    private final void $$robo$$android_service_dreams_DreamService$attach(IBinder windowToken, boolean canDoze, IRemoteCallback started) {
        if (this.mWindowToken != null) {
            Slog.e(this.TAG, "attach() called when already attached with token=" + this.mWindowToken);
            return;
        }
        if (this.mFinished || this.mWaking) {
            Slog.w(this.TAG, "attach() called after dream already finished");
            try {
                this.mSandman.finishSelf(windowToken, true);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        this.mWindowToken = windowToken;
        this.mCanDoze = canDoze;
        if (this.mWindowless && !this.mCanDoze) {
            throw new IllegalStateException("Only doze dreams can be windowless");
        }
        if (!this.mWindowless) {
            this.mWindow = new PhoneWindow(this);
            this.mWindow.setCallback(this);
            this.mWindow.requestFeature(1);
            this.mWindow.setBackgroundDrawable(new ColorDrawable(-16777216));
            this.mWindow.setFormat(-1);
            if (this.mDebug) {
                Slog.v(this.TAG, String.format("Attaching window token: %s to window of type %s", windowToken, 2023));
            }
            WindowManager.LayoutParams lp = this.mWindow.getAttributes();
            lp.type = 2023;
            lp.token = windowToken;
            lp.windowAnimations = 16974574;
            lp.flags = lp.flags | (0x490101 | (this.mFullscreen ? 1024 : 0) | (this.mScreenBright ? 128 : 0));
            this.mWindow.setAttributes(lp);
            this.mWindow.clearFlags(Integer.MIN_VALUE);
            this.mWindow.setWindowManager(null, windowToken, "dream", true);
            this.applySystemUiVisibilityFlags(this.mLowProfile ? 1 : 0, 1);
            try {
                this.getWindowManager().addView(this.mWindow.getDecorView(), this.mWindow.getAttributes());
            }
            catch (WindowManager.BadTokenException ex) {
                Slog.i(this.TAG, "attach() called after window token already removed, dream will finish soon");
                this.mWindow = null;
                return;
            }
        }
        this.mHandler.post(new Runnable(this, started){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ IRemoteCallback val$started;
            /* synthetic */ DreamService this$0;

            private void $$robo$$android_service_dreams_DreamService_1$__constructor__(DreamService this$0, IRemoteCallback iRemoteCallback) {
            }

            private final void $$robo$$android_service_dreams_DreamService_1$run() {
                if (this.this$0.mWindow != null || this.this$0.mWindowless) {
                    if (this.this$0.mDebug) {
                        Slog.v(this.this$0.TAG, "Calling onDreamingStarted()");
                    }
                    this.this$0.mStarted = true;
                    try {
                        this.this$0.onDreamingStarted();
                    }
                    finally {
                        try {
                            this.val$started.sendResult(null);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                    }
                }
            }

            private void __constructor__(DreamService dreamService, IRemoteCallback iRemoteCallback) {
                this.$$robo$$android_service_dreams_DreamService_1$__constructor__(dreamService, iRemoteCallback);
            }
            {
                this.this$0 = dreamService;
                this.val$started = iRemoteCallback;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_dreams_DreamService_1$__constructor__(android.service.dreams.DreamService android.os.IRemoteCallback ), 0, this, dreamService, iRemoteCallback);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_dreams_DreamService_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final boolean $$robo$$android_service_dreams_DreamService$getWindowFlagValue(int flag, boolean defaultValue) {
        return this.mWindow == null ? defaultValue : (this.mWindow.getAttributes().flags & flag) != 0;
    }

    private final void $$robo$$android_service_dreams_DreamService$applyWindowFlags(int flags, int mask) {
        if (this.mWindow != null) {
            WindowManager.LayoutParams lp = this.mWindow.getAttributes();
            lp.flags = this.applyFlags(lp.flags, flags, mask);
            this.mWindow.setAttributes(lp);
            this.mWindow.getWindowManager().updateViewLayout(this.mWindow.getDecorView(), lp);
        }
    }

    private final boolean $$robo$$android_service_dreams_DreamService$getSystemUiVisibilityFlagValue(int flag, boolean defaultValue) {
        View v;
        View view = v = this.mWindow == null ? null : this.mWindow.getDecorView();
        return v == null ? defaultValue : (v.getSystemUiVisibility() & flag) != 0;
    }

    private final void $$robo$$android_service_dreams_DreamService$applySystemUiVisibilityFlags(int flags, int mask) {
        View v;
        View view = v = this.mWindow == null ? null : this.mWindow.getDecorView();
        if (v != null) {
            v.setSystemUiVisibility(this.applyFlags(v.getSystemUiVisibility(), flags, mask));
        }
    }

    private final int $$robo$$android_service_dreams_DreamService$applyFlags(int oldFlags, int flags, int mask) {
        return oldFlags & ~mask | flags & mask;
    }

    private final void $$robo$$android_service_dreams_DreamService$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        DumpUtils.dumpAsync(this.mHandler, new DumpUtils.Dump(this, fd, args){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FileDescriptor val$fd;
            /* synthetic */ String[] val$args;
            /* synthetic */ DreamService this$0;

            private void $$robo$$android_service_dreams_DreamService_2$__constructor__(DreamService this$0, FileDescriptor fileDescriptor, String[] stringArray) {
            }

            private final void $$robo$$android_service_dreams_DreamService_2$dump(PrintWriter pw, String prefix) {
                this.this$0.dumpOnHandler(this.val$fd, pw, this.val$args);
            }

            private void __constructor__(DreamService dreamService, FileDescriptor fileDescriptor, String[] stringArray) {
                this.$$robo$$android_service_dreams_DreamService_2$__constructor__(dreamService, fileDescriptor, stringArray);
            }
            {
                this.this$0 = dreamService;
                this.val$fd = fileDescriptor;
                this.val$args = stringArray;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_dreams_DreamService_2$__constructor__(android.service.dreams.DreamService java.io.FileDescriptor java.lang.String[] ), 0, this, dreamService, fileDescriptor, stringArray);
            }

            @Override
            public void dump(PrintWriter printWriter, String string2) {
                InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_dreams_DreamService_2$dump(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, pw, "", 1000L);
    }

    private final void $$robo$$android_service_dreams_DreamService$dumpOnHandler(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.print(this.TAG + ": ");
        if (this.mWindowToken == null) {
            pw.println("stopped");
        } else {
            pw.println("running (token=" + this.mWindowToken + ")");
        }
        pw.println("  window: " + this.mWindow);
        pw.print("  flags:");
        if (this.isInteractive()) {
            pw.print(" interactive");
        }
        if (this.isLowProfile()) {
            pw.print(" lowprofile");
        }
        if (this.isFullscreen()) {
            pw.print(" fullscreen");
        }
        if (this.isScreenBright()) {
            pw.print(" bright");
        }
        if (this.isWindowless()) {
            pw.print(" windowless");
        }
        if (this.isDozing()) {
            pw.print(" dozing");
        } else if (this.canDoze()) {
            pw.print(" candoze");
        }
        pw.println();
        if (this.canDoze()) {
            pw.println("  doze screen state: " + Display.stateToString(this.mDozeScreenState));
            pw.println("  doze screen brightness: " + this.mDozeScreenBrightness);
        }
    }

    private static final int $$robo$$android_service_dreams_DreamService$clampAbsoluteBrightness(int value) {
        return MathUtils.constrain(value, 0, 255);
    }

    private void __constructor__() {
        this.$$robo$$android_service_dreams_DreamService$__constructor__();
    }

    public DreamService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_dreams_DreamService$__constructor__(), 0, this);
    }

    public void setDebug(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDebug", $$robo$$android_service_dreams_DreamService$setDebug(boolean ), 0, this, bl);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_service_dreams_DreamService$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyShortcutEvent", $$robo$$android_service_dreams_DreamService$dispatchKeyShortcutEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_service_dreams_DreamService$dispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchTrackballEvent", $$robo$$android_service_dreams_DreamService$dispatchTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchGenericMotionEvent", $$robo$$android_service_dreams_DreamService$dispatchGenericMotionEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_service_dreams_DreamService$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public View onCreatePanelView(int n) {
        return InvokeDynamicSupport.bootstrap("onCreatePanelView", $$robo$$android_service_dreams_DreamService$onCreatePanelView(int ), 0, this, n);
    }

    @Override
    public boolean onCreatePanelMenu(int n, Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onCreatePanelMenu", $$robo$$android_service_dreams_DreamService$onCreatePanelMenu(int android.view.Menu ), 0, this, n, menu2);
    }

    @Override
    public boolean onPreparePanel(int n, View view, Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onPreparePanel", $$robo$$android_service_dreams_DreamService$onPreparePanel(int android.view.View android.view.Menu ), 0, this, n, view, menu2);
    }

    @Override
    public boolean onMenuOpened(int n, Menu menu2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onMenuOpened", $$robo$$android_service_dreams_DreamService$onMenuOpened(int android.view.Menu ), 0, this, n, menu2);
    }

    @Override
    public boolean onMenuItemSelected(int n, MenuItem menuItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("onMenuItemSelected", $$robo$$android_service_dreams_DreamService$onMenuItemSelected(int android.view.MenuItem ), 0, this, n, menuItem);
    }

    @Override
    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("onWindowAttributesChanged", $$robo$$android_service_dreams_DreamService$onWindowAttributesChanged(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    public void onContentChanged() {
        InvokeDynamicSupport.bootstrap("onContentChanged", $$robo$$android_service_dreams_DreamService$onContentChanged(), 0, this);
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onWindowFocusChanged", $$robo$$android_service_dreams_DreamService$onWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_service_dreams_DreamService$onAttachedToWindow(), 0, this);
    }

    @Override
    public void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_service_dreams_DreamService$onDetachedFromWindow(), 0, this);
    }

    @Override
    public void onPanelClosed(int n, Menu menu2) {
        InvokeDynamicSupport.bootstrap("onPanelClosed", $$robo$$android_service_dreams_DreamService$onPanelClosed(int android.view.Menu ), 0, this, n, menu2);
    }

    @Override
    public boolean onSearchRequested(SearchEvent searchEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onSearchRequested", $$robo$$android_service_dreams_DreamService$onSearchRequested(android.view.SearchEvent ), 0, this, searchEvent);
    }

    @Override
    public boolean onSearchRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("onSearchRequested", $$robo$$android_service_dreams_DreamService$onSearchRequested(), 0, this);
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        return InvokeDynamicSupport.bootstrap("onWindowStartingActionMode", $$robo$$android_service_dreams_DreamService$onWindowStartingActionMode(android.view.ActionMode$Callback ), 0, this, callback);
    }

    @Override
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int n) {
        return InvokeDynamicSupport.bootstrap("onWindowStartingActionMode", $$robo$$android_service_dreams_DreamService$onWindowStartingActionMode(android.view.ActionMode$Callback int ), 0, this, callback, n);
    }

    @Override
    public void onActionModeStarted(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("onActionModeStarted", $$robo$$android_service_dreams_DreamService$onActionModeStarted(android.view.ActionMode ), 0, this, actionMode);
    }

    @Override
    public void onActionModeFinished(ActionMode actionMode) {
        InvokeDynamicSupport.bootstrap("onActionModeFinished", $$robo$$android_service_dreams_DreamService$onActionModeFinished(android.view.ActionMode ), 0, this, actionMode);
    }

    public WindowManager getWindowManager() {
        return InvokeDynamicSupport.bootstrap("getWindowManager", $$robo$$android_service_dreams_DreamService$getWindowManager(), 0, this);
    }

    public Window getWindow() {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_service_dreams_DreamService$getWindow(), 0, this);
    }

    public void setContentView(int n) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$android_service_dreams_DreamService$setContentView(int ), 0, this, n);
    }

    public void setContentView(View view) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$android_service_dreams_DreamService$setContentView(android.view.View ), 0, this, view);
    }

    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$android_service_dreams_DreamService$setContentView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addContentView", $$robo$$android_service_dreams_DreamService$addContentView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    public <T extends View> T findViewById(int n) {
        return (T)InvokeDynamicSupport.bootstrap("findViewById", $$robo$$android_service_dreams_DreamService$findViewById(int ), 0, this, n);
    }

    public <T extends View> T requireViewById(int n) {
        return (T)InvokeDynamicSupport.bootstrap("requireViewById", $$robo$$android_service_dreams_DreamService$requireViewById(int ), 0, this, n);
    }

    public void setInteractive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInteractive", $$robo$$android_service_dreams_DreamService$setInteractive(boolean ), 0, this, bl);
    }

    public boolean isInteractive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInteractive", $$robo$$android_service_dreams_DreamService$isInteractive(), 0, this);
    }

    public void setLowProfile(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLowProfile", $$robo$$android_service_dreams_DreamService$setLowProfile(boolean ), 0, this, bl);
    }

    public boolean isLowProfile() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLowProfile", $$robo$$android_service_dreams_DreamService$isLowProfile(), 0, this);
    }

    public void setFullscreen(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFullscreen", $$robo$$android_service_dreams_DreamService$setFullscreen(boolean ), 0, this, bl);
    }

    public boolean isFullscreen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFullscreen", $$robo$$android_service_dreams_DreamService$isFullscreen(), 0, this);
    }

    public void setScreenBright(boolean bl) {
        InvokeDynamicSupport.bootstrap("setScreenBright", $$robo$$android_service_dreams_DreamService$setScreenBright(boolean ), 0, this, bl);
    }

    public boolean isScreenBright() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScreenBright", $$robo$$android_service_dreams_DreamService$isScreenBright(), 0, this);
    }

    public void setWindowless(boolean bl) {
        InvokeDynamicSupport.bootstrap("setWindowless", $$robo$$android_service_dreams_DreamService$setWindowless(boolean ), 0, this, bl);
    }

    public boolean isWindowless() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWindowless", $$robo$$android_service_dreams_DreamService$isWindowless(), 0, this);
    }

    public boolean canDoze() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDoze", $$robo$$android_service_dreams_DreamService$canDoze(), 0, this);
    }

    public void startDozing() {
        InvokeDynamicSupport.bootstrap("startDozing", $$robo$$android_service_dreams_DreamService$startDozing(), 0, this);
    }

    private void updateDoze() {
        InvokeDynamicSupport.bootstrap("updateDoze", $$robo$$android_service_dreams_DreamService$updateDoze(), 0, this);
    }

    public void stopDozing() {
        InvokeDynamicSupport.bootstrap("stopDozing", $$robo$$android_service_dreams_DreamService$stopDozing(), 0, this);
    }

    public boolean isDozing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDozing", $$robo$$android_service_dreams_DreamService$isDozing(), 0, this);
    }

    public int getDozeScreenState() {
        return (int)InvokeDynamicSupport.bootstrap("getDozeScreenState", $$robo$$android_service_dreams_DreamService$getDozeScreenState(), 0, this);
    }

    public void setDozeScreenState(int n) {
        InvokeDynamicSupport.bootstrap("setDozeScreenState", $$robo$$android_service_dreams_DreamService$setDozeScreenState(int ), 0, this, n);
    }

    public int getDozeScreenBrightness() {
        return (int)InvokeDynamicSupport.bootstrap("getDozeScreenBrightness", $$robo$$android_service_dreams_DreamService$getDozeScreenBrightness(), 0, this);
    }

    public void setDozeScreenBrightness(int n) {
        InvokeDynamicSupport.bootstrap("setDozeScreenBrightness", $$robo$$android_service_dreams_DreamService$setDozeScreenBrightness(int ), 0, this, n);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_service_dreams_DreamService$onCreate(), 0, this);
    }

    public void onDreamingStarted() {
        InvokeDynamicSupport.bootstrap("onDreamingStarted", $$robo$$android_service_dreams_DreamService$onDreamingStarted(), 0, this);
    }

    public void onDreamingStopped() {
        InvokeDynamicSupport.bootstrap("onDreamingStopped", $$robo$$android_service_dreams_DreamService$onDreamingStopped(), 0, this);
    }

    public void onWakeUp() {
        InvokeDynamicSupport.bootstrap("onWakeUp", $$robo$$android_service_dreams_DreamService$onWakeUp(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_dreams_DreamService$onBind(android.content.Intent ), 0, this, intent);
    }

    public void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_service_dreams_DreamService$finish(), 0, this);
    }

    public void wakeUp() {
        InvokeDynamicSupport.bootstrap("wakeUp", $$robo$$android_service_dreams_DreamService$wakeUp(), 0, this);
    }

    private void wakeUp(boolean bl) {
        InvokeDynamicSupport.bootstrap("wakeUp", $$robo$$android_service_dreams_DreamService$wakeUp(boolean ), 0, this, bl);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_service_dreams_DreamService$onDestroy(), 0, this);
    }

    private void detach() {
        InvokeDynamicSupport.bootstrap("detach", $$robo$$android_service_dreams_DreamService$detach(), 0, this);
    }

    private void attach(IBinder iBinder, boolean bl, IRemoteCallback iRemoteCallback) {
        InvokeDynamicSupport.bootstrap("attach", $$robo$$android_service_dreams_DreamService$attach(android.os.IBinder boolean android.os.IRemoteCallback ), 0, this, iBinder, bl, iRemoteCallback);
    }

    private boolean getWindowFlagValue(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getWindowFlagValue", $$robo$$android_service_dreams_DreamService$getWindowFlagValue(int boolean ), 0, this, n, bl);
    }

    private void applyWindowFlags(int n, int n2) {
        InvokeDynamicSupport.bootstrap("applyWindowFlags", $$robo$$android_service_dreams_DreamService$applyWindowFlags(int int ), 0, this, n, n2);
    }

    private boolean getSystemUiVisibilityFlagValue(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getSystemUiVisibilityFlagValue", $$robo$$android_service_dreams_DreamService$getSystemUiVisibilityFlagValue(int boolean ), 0, this, n, bl);
    }

    private void applySystemUiVisibilityFlags(int n, int n2) {
        InvokeDynamicSupport.bootstrap("applySystemUiVisibilityFlags", $$robo$$android_service_dreams_DreamService$applySystemUiVisibilityFlags(int int ), 0, this, n, n2);
    }

    private int applyFlags(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("applyFlags", $$robo$$android_service_dreams_DreamService$applyFlags(int int int ), 0, this, n, n2, n3);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_dreams_DreamService$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    protected void dumpOnHandler(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dumpOnHandler", $$robo$$android_service_dreams_DreamService$dumpOnHandler(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    private static int clampAbsoluteBrightness(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("clampAbsoluteBrightness", $$robo$$android_service_dreams_DreamService$clampAbsoluteBrightness(int ), 0, (int)n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DreamService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class DreamServiceWrapper
    extends IDreamService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ DreamService this$0;

        private void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$__constructor__(DreamService dreamService) {
        }

        private final void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$attach(IBinder windowToken, boolean canDoze, IRemoteCallback started) {
            this.this$0.mHandler.post(new Runnable(this, windowToken, canDoze, started){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IBinder val$windowToken;
                /* synthetic */ boolean val$canDoze;
                /* synthetic */ IRemoteCallback val$started;
                /* synthetic */ DreamServiceWrapper this$1;

                private void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_1$__constructor__(DreamServiceWrapper this$1, IBinder iBinder, boolean bl, IRemoteCallback iRemoteCallback) {
                }

                private final void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_1$run() {
                    this.this$1.this$0.attach(this.val$windowToken, this.val$canDoze, this.val$started);
                }

                private void __constructor__(DreamServiceWrapper dreamServiceWrapper, IBinder iBinder, boolean bl, IRemoteCallback iRemoteCallback) {
                    this.$$robo$$android_service_dreams_DreamService_DreamServiceWrapper_1$__constructor__(dreamServiceWrapper, iBinder, bl, iRemoteCallback);
                }
                {
                    this.this$1 = dreamServiceWrapper;
                    this.val$windowToken = iBinder;
                    this.val$canDoze = bl;
                    this.val$started = iRemoteCallback;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_1$__constructor__(android.service.dreams.DreamService$DreamServiceWrapper android.os.IBinder boolean android.os.IRemoteCallback ), 0, this, dreamServiceWrapper, iBinder, bl, iRemoteCallback);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$detach() {
            this.this$0.mHandler.post(new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ DreamServiceWrapper this$1;

                private void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_2$__constructor__(DreamServiceWrapper this$1) {
                }

                private final void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_2$run() {
                    this.this$1.this$0.detach();
                }

                private void __constructor__(DreamServiceWrapper dreamServiceWrapper) {
                    this.$$robo$$android_service_dreams_DreamService_DreamServiceWrapper_2$__constructor__(dreamServiceWrapper);
                }
                {
                    this.this$1 = dreamServiceWrapper;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_2$__constructor__(android.service.dreams.DreamService$DreamServiceWrapper ), 0, this, dreamServiceWrapper);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$wakeUp() {
            this.this$0.mHandler.post(new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ DreamServiceWrapper this$1;

                private void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_3$__constructor__(DreamServiceWrapper this$1) {
                }

                private final void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_3$run() {
                    this.this$1.this$0.wakeUp(true);
                }

                private void __constructor__(DreamServiceWrapper dreamServiceWrapper) {
                    this.$$robo$$android_service_dreams_DreamService_DreamServiceWrapper_3$__constructor__(dreamServiceWrapper);
                }
                {
                    this.this$1 = dreamServiceWrapper;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_3$__constructor__(android.service.dreams.DreamService$DreamServiceWrapper ), 0, this, dreamServiceWrapper);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private /* synthetic */ void $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$__constructor__(DreamService x0, 1 x1) {
        }

        private void __constructor__(DreamService dreamService) {
            this.$$robo$$android_service_dreams_DreamService_DreamServiceWrapper$__constructor__(dreamService);
        }

        private DreamServiceWrapper(DreamService dreamService) {
            this.this$0 = dreamService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$__constructor__(android.service.dreams.DreamService ), 0, this, dreamService);
        }

        @Override
        public void attach(IBinder iBinder, boolean bl, IRemoteCallback iRemoteCallback) {
            InvokeDynamicSupport.bootstrap("attach", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$attach(android.os.IBinder boolean android.os.IRemoteCallback ), 0, this, iBinder, bl, iRemoteCallback);
        }

        @Override
        public void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$detach(), 0, this);
        }

        @Override
        public void wakeUp() {
            InvokeDynamicSupport.bootstrap("wakeUp", $$robo$$android_service_dreams_DreamService_DreamServiceWrapper$wakeUp(), 0, this);
        }

        private /* synthetic */ void __constructor__(DreamService dreamService, 1 var2_2) {
            this.$$robo$$android_service_dreams_DreamService_DreamServiceWrapper$__constructor__(dreamService, var2_2);
        }

        public /* synthetic */ DreamServiceWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DreamServiceWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

