/*
 * Decompiled with CFR 0.152.
 */
package android.service.euicc;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.carrier.CarrierIdentifier;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class EuiccProfileInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int POLICY_RULE_DO_NOT_DISABLE = 1;
    public static int POLICY_RULE_DO_NOT_DELETE = 2;
    public static int POLICY_RULE_DELETE_AFTER_DISABLING = 4;
    public static int PROFILE_CLASS_TESTING = 0;
    public static int PROFILE_CLASS_PROVISIONING = 1;
    public static int PROFILE_CLASS_OPERATIONAL = 2;
    public static int PROFILE_CLASS_UNSET = -1;
    public static int PROFILE_STATE_DISABLED = 0;
    public static int PROFILE_STATE_ENABLED = 1;
    public static int PROFILE_STATE_UNSET = -1;
    private String mIccid;
    private String mNickname;
    private String mServiceProviderName;
    private String mProfileName;
    private int mProfileClass;
    private int mState;
    private CarrierIdentifier mCarrierIdentifier;
    private int mPolicyRules;
    private UiccAccessRule[] mAccessRules;
    public static Parcelable.Creator<EuiccProfileInfo> CREATOR;

    @Deprecated
    private void $$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(String iccid, UiccAccessRule[] accessRules, String nickname) {
        if (!TextUtils.isDigitsOnly(iccid)) {
            throw new IllegalArgumentException("iccid contains invalid characters: " + iccid);
        }
        this.mIccid = iccid;
        this.mAccessRules = accessRules;
        this.mNickname = nickname;
        this.mServiceProviderName = null;
        this.mProfileName = null;
        this.mProfileClass = -1;
        this.mState = -1;
        this.mCarrierIdentifier = null;
        this.mPolicyRules = 0;
    }

    private void $$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(Parcel in) {
        this.mIccid = in.readString();
        this.mNickname = in.readString();
        this.mServiceProviderName = in.readString();
        this.mProfileName = in.readString();
        this.mProfileClass = in.readInt();
        this.mState = in.readInt();
        byte exist = in.readByte();
        this.mCarrierIdentifier = exist == 1 ? CarrierIdentifier.CREATOR.createFromParcel(in) : null;
        this.mPolicyRules = in.readInt();
        this.mAccessRules = in.createTypedArray(UiccAccessRule.CREATOR);
    }

    private final void $$robo$$android_service_euicc_EuiccProfileInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mIccid);
        dest.writeString(this.mNickname);
        dest.writeString(this.mServiceProviderName);
        dest.writeString(this.mProfileName);
        dest.writeInt(this.mProfileClass);
        dest.writeInt(this.mState);
        if (this.mCarrierIdentifier != null) {
            dest.writeByte((byte)1);
            this.mCarrierIdentifier.writeToParcel(dest, flags);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeInt(this.mPolicyRules);
        dest.writeTypedArray(this.mAccessRules, flags);
    }

    private final int $$robo$$android_service_euicc_EuiccProfileInfo$describeContents() {
        return 0;
    }

    private void $$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(String iccid, String nickname, String serviceProviderName, String profileName, int profileClass, int state, CarrierIdentifier carrierIdentifier, int policyRules, List<UiccAccessRule> accessRules) {
        this.mIccid = iccid;
        this.mNickname = nickname;
        this.mServiceProviderName = serviceProviderName;
        this.mProfileName = profileName;
        this.mProfileClass = profileClass;
        this.mState = state;
        this.mCarrierIdentifier = carrierIdentifier;
        this.mPolicyRules = policyRules;
        this.mAccessRules = accessRules != null && accessRules.size() > 0 ? accessRules.toArray(new UiccAccessRule[accessRules.size()]) : null;
    }

    private final String $$robo$$android_service_euicc_EuiccProfileInfo$getIccid() {
        return this.mIccid;
    }

    private final List<UiccAccessRule> $$robo$$android_service_euicc_EuiccProfileInfo$getUiccAccessRules() {
        if (this.mAccessRules == null) {
            return null;
        }
        return Arrays.asList(this.mAccessRules);
    }

    private final String $$robo$$android_service_euicc_EuiccProfileInfo$getNickname() {
        return this.mNickname;
    }

    private final String $$robo$$android_service_euicc_EuiccProfileInfo$getServiceProviderName() {
        return this.mServiceProviderName;
    }

    private final String $$robo$$android_service_euicc_EuiccProfileInfo$getProfileName() {
        return this.mProfileName;
    }

    private final int $$robo$$android_service_euicc_EuiccProfileInfo$getProfileClass() {
        return this.mProfileClass;
    }

    private final int $$robo$$android_service_euicc_EuiccProfileInfo$getState() {
        return this.mState;
    }

    private final CarrierIdentifier $$robo$$android_service_euicc_EuiccProfileInfo$getCarrierIdentifier() {
        return this.mCarrierIdentifier;
    }

    private final int $$robo$$android_service_euicc_EuiccProfileInfo$getPolicyRules() {
        return this.mPolicyRules;
    }

    private final boolean $$robo$$android_service_euicc_EuiccProfileInfo$hasPolicyRules() {
        return this.mPolicyRules != 0;
    }

    private final boolean $$robo$$android_service_euicc_EuiccProfileInfo$hasPolicyRule(int policy) {
        return (this.mPolicyRules & policy) != 0;
    }

    private final boolean $$robo$$android_service_euicc_EuiccProfileInfo$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EuiccProfileInfo that = (EuiccProfileInfo)obj;
        return Objects.equals(this.mIccid, that.mIccid) && Objects.equals(this.mNickname, that.mNickname) && Objects.equals(this.mServiceProviderName, that.mServiceProviderName) && Objects.equals(this.mProfileName, that.mProfileName) && this.mProfileClass == that.mProfileClass && this.mState == that.mState && Objects.equals(this.mCarrierIdentifier, that.mCarrierIdentifier) && this.mPolicyRules == that.mPolicyRules && Arrays.equals(this.mAccessRules, that.mAccessRules);
    }

    private final int $$robo$$android_service_euicc_EuiccProfileInfo$hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.mIccid);
        result = 31 * result + Objects.hashCode(this.mNickname);
        result = 31 * result + Objects.hashCode(this.mServiceProviderName);
        result = 31 * result + Objects.hashCode(this.mProfileName);
        result = 31 * result + this.mProfileClass;
        result = 31 * result + this.mState;
        result = 31 * result + Objects.hashCode(this.mCarrierIdentifier);
        result = 31 * result + this.mPolicyRules;
        result = 31 * result + Arrays.hashCode(this.mAccessRules);
        return result;
    }

    private final String $$robo$$android_service_euicc_EuiccProfileInfo$toString() {
        return "EuiccProfileInfo (nickname=" + this.mNickname + ", serviceProviderName=" + this.mServiceProviderName + ", profileName=" + this.mProfileName + ", profileClass=" + this.mProfileClass + ", state=" + this.mState + ", CarrierIdentifier=" + this.mCarrierIdentifier + ", policyRules=" + this.mPolicyRules + ", accessRules=" + Arrays.toString(this.mAccessRules) + ")";
    }

    private /* synthetic */ void $$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(Parcel x0, 1 x1) {
    }

    private /* synthetic */ void $$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(String x0, String x1, String x2, String x3, int x4, int x5, CarrierIdentifier x6, int x7, List x8, 1 x9) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<EuiccProfileInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_euicc_EuiccProfileInfo_1$__constructor__() {
            }

            private final EuiccProfileInfo $$robo$$android_service_euicc_EuiccProfileInfo_1$createFromParcel(Parcel in) {
                return new EuiccProfileInfo(in);
            }

            private final EuiccProfileInfo[] $$robo$$android_service_euicc_EuiccProfileInfo_1$newArray(int size) {
                return new EuiccProfileInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_euicc_EuiccProfileInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_euicc_EuiccProfileInfo_1$__constructor__(), 0, this);
            }

            @Override
            public EuiccProfileInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_euicc_EuiccProfileInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public EuiccProfileInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_euicc_EuiccProfileInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(String string2, UiccAccessRule[] uiccAccessRuleArray, String string3) {
        this.$$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(string2, uiccAccessRuleArray, string3);
    }

    public EuiccProfileInfo(String string2, UiccAccessRule[] uiccAccessRuleArray, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(java.lang.String android.telephony.UiccAccessRule[] java.lang.String ), 0, this, string2, uiccAccessRuleArray, string3);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(parcel);
    }

    private EuiccProfileInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_euicc_EuiccProfileInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_euicc_EuiccProfileInfo$describeContents(), 0, this);
    }

    private void __constructor__(String string2, String string3, String string4, String string5, int n, int n2, CarrierIdentifier carrierIdentifier, int n3, List<UiccAccessRule> list) {
        this.$$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(string2, string3, string4, string5, n, n2, carrierIdentifier, n3, list);
    }

    private EuiccProfileInfo(String string2, String string3, String string4, String string5, int n, int n2, CarrierIdentifier carrierIdentifier, int n3, List<UiccAccessRule> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(java.lang.String java.lang.String java.lang.String java.lang.String int int android.service.carrier.CarrierIdentifier int java.util.List<android.telephony.UiccAccessRule> ), 0, this, string2, string3, string4, string5, n, n2, carrierIdentifier, n3, list);
    }

    public String getIccid() {
        return InvokeDynamicSupport.bootstrap("getIccid", $$robo$$android_service_euicc_EuiccProfileInfo$getIccid(), 0, this);
    }

    public List<UiccAccessRule> getUiccAccessRules() {
        return InvokeDynamicSupport.bootstrap("getUiccAccessRules", $$robo$$android_service_euicc_EuiccProfileInfo$getUiccAccessRules(), 0, this);
    }

    public String getNickname() {
        return InvokeDynamicSupport.bootstrap("getNickname", $$robo$$android_service_euicc_EuiccProfileInfo$getNickname(), 0, this);
    }

    public String getServiceProviderName() {
        return InvokeDynamicSupport.bootstrap("getServiceProviderName", $$robo$$android_service_euicc_EuiccProfileInfo$getServiceProviderName(), 0, this);
    }

    public String getProfileName() {
        return InvokeDynamicSupport.bootstrap("getProfileName", $$robo$$android_service_euicc_EuiccProfileInfo$getProfileName(), 0, this);
    }

    public int getProfileClass() {
        return (int)InvokeDynamicSupport.bootstrap("getProfileClass", $$robo$$android_service_euicc_EuiccProfileInfo$getProfileClass(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_service_euicc_EuiccProfileInfo$getState(), 0, this);
    }

    public CarrierIdentifier getCarrierIdentifier() {
        return InvokeDynamicSupport.bootstrap("getCarrierIdentifier", $$robo$$android_service_euicc_EuiccProfileInfo$getCarrierIdentifier(), 0, this);
    }

    public int getPolicyRules() {
        return (int)InvokeDynamicSupport.bootstrap("getPolicyRules", $$robo$$android_service_euicc_EuiccProfileInfo$getPolicyRules(), 0, this);
    }

    public boolean hasPolicyRules() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPolicyRules", $$robo$$android_service_euicc_EuiccProfileInfo$hasPolicyRules(), 0, this);
    }

    public boolean hasPolicyRule(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPolicyRule", $$robo$$android_service_euicc_EuiccProfileInfo$hasPolicyRule(int ), 0, this, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_service_euicc_EuiccProfileInfo$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_service_euicc_EuiccProfileInfo$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_euicc_EuiccProfileInfo$toString(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(parcel, var2_2);
    }

    private /* synthetic */ void __constructor__(String string2, String string3, String string4, String string5, int n, int n2, CarrierIdentifier carrierIdentifier, int n3, List list, 1 var10_10) {
        this.$$robo$$android_service_euicc_EuiccProfileInfo$__constructor__(string2, string3, string4, string5, n, n2, carrierIdentifier, n3, list, var10_10);
    }

    static {
        RobolectricInternals.classInitializing(EuiccProfileInfo.class);
    }

    public /* synthetic */ EuiccProfileInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EuiccProfileInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mIccid;
        private List<UiccAccessRule> mAccessRules;
        private String mNickname;
        private String mServiceProviderName;
        private String mProfileName;
        private int mProfileClass;
        private int mState;
        private CarrierIdentifier mCarrierIdentifier;
        private int mPolicyRules;

        private void $$robo$$android_service_euicc_EuiccProfileInfo_Builder$__constructor__(String value) {
            if (!TextUtils.isDigitsOnly(value)) {
                throw new IllegalArgumentException("iccid contains invalid characters: " + value);
            }
            this.mIccid = value;
        }

        private void $$robo$$android_service_euicc_EuiccProfileInfo_Builder$__constructor__(EuiccProfileInfo baseProfile) {
            this.mIccid = baseProfile.mIccid;
            this.mNickname = baseProfile.mNickname;
            this.mServiceProviderName = baseProfile.mServiceProviderName;
            this.mProfileName = baseProfile.mProfileName;
            this.mProfileClass = baseProfile.mProfileClass;
            this.mState = baseProfile.mState;
            this.mCarrierIdentifier = baseProfile.mCarrierIdentifier;
            this.mPolicyRules = baseProfile.mPolicyRules;
            this.mAccessRules = Arrays.asList(baseProfile.mAccessRules);
        }

        private final EuiccProfileInfo $$robo$$android_service_euicc_EuiccProfileInfo_Builder$build() {
            if (this.mIccid == null) {
                throw new IllegalStateException("ICCID must be set for a profile.");
            }
            return new EuiccProfileInfo(this.mIccid, this.mNickname, this.mServiceProviderName, this.mProfileName, this.mProfileClass, this.mState, this.mCarrierIdentifier, this.mPolicyRules, this.mAccessRules);
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setIccid(String value) {
            if (!TextUtils.isDigitsOnly(value)) {
                throw new IllegalArgumentException("iccid contains invalid characters: " + value);
            }
            this.mIccid = value;
            return this;
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setNickname(String value) {
            this.mNickname = value;
            return this;
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setServiceProviderName(String value) {
            this.mServiceProviderName = value;
            return this;
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setProfileName(String value) {
            this.mProfileName = value;
            return this;
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setProfileClass(int value) {
            this.mProfileClass = value;
            return this;
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setState(int value) {
            this.mState = value;
            return this;
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setCarrierIdentifier(CarrierIdentifier value) {
            this.mCarrierIdentifier = value;
            return this;
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setPolicyRules(int value) {
            this.mPolicyRules = value;
            return this;
        }

        private final Builder $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setUiccAccessRule(List<UiccAccessRule> value) {
            this.mAccessRules = value;
            return this;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_service_euicc_EuiccProfileInfo_Builder$__constructor__(string2);
        }

        public Builder(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$__constructor__(java.lang.String ), 0, this, string2);
        }

        private void __constructor__(EuiccProfileInfo euiccProfileInfo) {
            this.$$robo$$android_service_euicc_EuiccProfileInfo_Builder$__constructor__(euiccProfileInfo);
        }

        public Builder(EuiccProfileInfo euiccProfileInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$__constructor__(android.service.euicc.EuiccProfileInfo ), 0, this, euiccProfileInfo);
        }

        public EuiccProfileInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$build(), 0, this);
        }

        public Builder setIccid(String string2) {
            return InvokeDynamicSupport.bootstrap("setIccid", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setIccid(java.lang.String ), 0, this, string2);
        }

        public Builder setNickname(String string2) {
            return InvokeDynamicSupport.bootstrap("setNickname", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setNickname(java.lang.String ), 0, this, string2);
        }

        public Builder setServiceProviderName(String string2) {
            return InvokeDynamicSupport.bootstrap("setServiceProviderName", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setServiceProviderName(java.lang.String ), 0, this, string2);
        }

        public Builder setProfileName(String string2) {
            return InvokeDynamicSupport.bootstrap("setProfileName", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setProfileName(java.lang.String ), 0, this, string2);
        }

        public Builder setProfileClass(int n) {
            return InvokeDynamicSupport.bootstrap("setProfileClass", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setProfileClass(int ), 0, this, n);
        }

        public Builder setState(int n) {
            return InvokeDynamicSupport.bootstrap("setState", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setState(int ), 0, this, n);
        }

        public Builder setCarrierIdentifier(CarrierIdentifier carrierIdentifier) {
            return InvokeDynamicSupport.bootstrap("setCarrierIdentifier", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setCarrierIdentifier(android.service.carrier.CarrierIdentifier ), 0, this, carrierIdentifier);
        }

        public Builder setPolicyRules(int n) {
            return InvokeDynamicSupport.bootstrap("setPolicyRules", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setPolicyRules(int ), 0, this, n);
        }

        public Builder setUiccAccessRule(List<UiccAccessRule> list) {
            return InvokeDynamicSupport.bootstrap("setUiccAccessRule", $$robo$$android_service_euicc_EuiccProfileInfo_Builder$setUiccAccessRule(java.util.List<android.telephony.UiccAccessRule> ), 0, this, list);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileClass {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PolicyRule {
    }
}

