/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.notification.Adjustment;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationListenerService;
import android.service.notification.NotificationStats;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public abstract class NotificationAssistantService
extends NotificationListenerService
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NotificationAssistants";
    public static String SERVICE_INTERFACE = "android.service.notification.NotificationAssistantService";
    protected Handler mHandler;

    private void $$robo$$android_service_notification_NotificationAssistantService$__constructor__() {
    }

    private final void $$robo$$android_service_notification_NotificationAssistantService$attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(this, this.getContext().getMainLooper());
    }

    private final IBinder $$robo$$android_service_notification_NotificationAssistantService$onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationAssistantServiceWrapper(this);
        }
        return this.mWrapper;
    }

    public abstract void onNotificationSnoozedUntilContext(StatusBarNotification var1, String var2);

    public abstract Adjustment onNotificationEnqueued(StatusBarNotification var1);

    private final void $$robo$$android_service_notification_NotificationAssistantService$onNotificationRemoved(StatusBarNotification sbn, NotificationListenerService.RankingMap rankingMap, NotificationStats stats, int reason) {
        this.onNotificationRemoved(sbn, rankingMap, reason);
    }

    private final void $$robo$$android_service_notification_NotificationAssistantService$adjustNotification(Adjustment adjustment) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().applyAdjustmentFromAssistant(this.mWrapper, adjustment);
        }
        catch (RemoteException ex) {
            Log.v("NotificationAssistants", "Unable to contact notification manager", ex);
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_service_notification_NotificationAssistantService$adjustNotifications(List<Adjustment> adjustments) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().applyAdjustmentsFromAssistant(this.mWrapper, adjustments);
        }
        catch (RemoteException ex) {
            Log.v("NotificationAssistants", "Unable to contact notification manager", ex);
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_service_notification_NotificationAssistantService$unsnoozeNotification(String key) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().unsnoozeNotificationFromAssistant(this.mWrapper, key);
        }
        catch (RemoteException ex) {
            Log.v("NotificationAssistants", "Unable to contact notification manager", ex);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_service_notification_NotificationAssistantService$__constructor__();
    }

    public NotificationAssistantService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationAssistantService$__constructor__(), 0, this);
    }

    @Override
    protected void attachBaseContext(Context context) {
        InvokeDynamicSupport.bootstrap("attachBaseContext", $$robo$$android_service_notification_NotificationAssistantService$attachBaseContext(android.content.Context ), 0, this, context);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_notification_NotificationAssistantService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public void onNotificationRemoved(StatusBarNotification statusBarNotification, NotificationListenerService.RankingMap rankingMap, NotificationStats notificationStats, int n) {
        InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationAssistantService$onNotificationRemoved(android.service.notification.StatusBarNotification android.service.notification.NotificationListenerService$RankingMap android.service.notification.NotificationStats int ), 0, this, statusBarNotification, rankingMap, notificationStats, n);
    }

    public void adjustNotification(Adjustment adjustment) {
        InvokeDynamicSupport.bootstrap("adjustNotification", $$robo$$android_service_notification_NotificationAssistantService$adjustNotification(android.service.notification.Adjustment ), 0, this, adjustment);
    }

    public void adjustNotifications(List<Adjustment> list) {
        InvokeDynamicSupport.bootstrap("adjustNotifications", $$robo$$android_service_notification_NotificationAssistantService$adjustNotifications(java.util.List<android.service.notification.Adjustment> ), 0, this, list);
    }

    public void unsnoozeNotification(String string2) {
        InvokeDynamicSupport.bootstrap("unsnoozeNotification", $$robo$$android_service_notification_NotificationAssistantService$unsnoozeNotification(java.lang.String ), 0, this, string2);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationAssistantService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MSG_ON_NOTIFICATION_ENQUEUED = 1;
        public static int MSG_ON_NOTIFICATION_SNOOZED = 2;
        /* synthetic */ NotificationAssistantService this$0;

        private void $$robo$$android_service_notification_NotificationAssistantService_MyHandler$__constructor__(NotificationAssistantService notificationAssistantService, Looper looper) {
        }

        private final void $$robo$$android_service_notification_NotificationAssistantService_MyHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    args.recycle();
                    Adjustment adjustment = this.this$0.onNotificationEnqueued(sbn);
                    if (adjustment == null) break;
                    if (!this.this$0.isBound()) {
                        return;
                    }
                    try {
                        this.this$0.getNotificationInterface().applyEnqueuedAdjustmentFromAssistant(this.this$0.mWrapper, adjustment);
                        break;
                    }
                    catch (RemoteException ex) {
                        Log.v("NotificationAssistants", "Unable to contact notification manager", ex);
                        throw ex.rethrowFromSystemServer();
                    }
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    String snoozeCriterionId = (String)args.arg2;
                    args.recycle();
                    this.this$0.onNotificationSnoozedUntilContext(sbn, snoozeCriterionId);
                    break;
                }
            }
        }

        private void __constructor__(NotificationAssistantService notificationAssistantService, Looper looper) {
            this.$$robo$$android_service_notification_NotificationAssistantService_MyHandler$__constructor__(notificationAssistantService, looper);
        }

        public MyHandler(NotificationAssistantService notificationAssistantService, Looper looper) {
            this.this$0 = notificationAssistantService;
            super(looper, null, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationAssistantService_MyHandler$__constructor__(android.service.notification.NotificationAssistantService android.os.Looper ), 0, this, notificationAssistantService, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_service_notification_NotificationAssistantService_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NotificationAssistantServiceWrapper
    extends NotificationListenerService.NotificationListenerWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NotificationAssistantService this$0;

        private void $$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$__constructor__(NotificationAssistantService notificationAssistantService) {
        }

        private final void $$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$onNotificationEnqueued(IStatusBarNotificationHolder sbnHolder) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w("NotificationAssistants", "onNotificationEnqueued: Error receiving StatusBarNotification", e);
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = sbn;
            this.this$0.mHandler.obtainMessage(1, args).sendToTarget();
        }

        private final void $$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$onNotificationSnoozedUntilContext(IStatusBarNotificationHolder sbnHolder, String snoozeCriterionId) throws RemoteException {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w("NotificationAssistants", "onNotificationSnoozed: Error receiving StatusBarNotification", e);
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = sbn;
            args.arg2 = snoozeCriterionId;
            this.this$0.mHandler.obtainMessage(2, args).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$__constructor__(NotificationAssistantService x0, 1 x1) {
        }

        private void __constructor__(NotificationAssistantService notificationAssistantService) {
            this.$$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$__constructor__(notificationAssistantService);
        }

        private NotificationAssistantServiceWrapper(NotificationAssistantService notificationAssistantService) {
            this.this$0 = notificationAssistantService;
            super(notificationAssistantService);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$__constructor__(android.service.notification.NotificationAssistantService ), 0, this, notificationAssistantService);
        }

        @Override
        public void onNotificationEnqueued(IStatusBarNotificationHolder iStatusBarNotificationHolder) {
            InvokeDynamicSupport.bootstrap("onNotificationEnqueued", $$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$onNotificationEnqueued(android.service.notification.IStatusBarNotificationHolder ), 0, this, iStatusBarNotificationHolder);
        }

        @Override
        public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder iStatusBarNotificationHolder, String string2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onNotificationSnoozedUntilContext", $$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$onNotificationSnoozedUntilContext(android.service.notification.IStatusBarNotificationHolder java.lang.String ), 0, this, iStatusBarNotificationHolder, string2);
        }

        private /* synthetic */ void __constructor__(NotificationAssistantService notificationAssistantService, 1 var2_2) {
            this.$$robo$$android_service_notification_NotificationAssistantService_NotificationAssistantServiceWrapper$__constructor__(notificationAssistantService, var2_2);
        }

        public /* synthetic */ NotificationAssistantServiceWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationAssistantServiceWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

