/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.SystemApi;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.Person;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.NotificationStats;
import android.service.notification.SnoozeCriterion;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.widget.RemoteViews;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class NotificationListenerService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    public static int INTERRUPTION_FILTER_ALL = 1;
    public static int INTERRUPTION_FILTER_PRIORITY = 2;
    public static int INTERRUPTION_FILTER_NONE = 3;
    public static int INTERRUPTION_FILTER_ALARMS = 4;
    public static int INTERRUPTION_FILTER_UNKNOWN = 0;
    public static int HINT_HOST_DISABLE_EFFECTS = 1;
    public static int HINT_HOST_DISABLE_NOTIFICATION_EFFECTS = 2;
    public static int HINT_HOST_DISABLE_CALL_EFFECTS = 4;
    @Deprecated
    public static int SUPPRESSED_EFFECT_SCREEN_OFF = 1;
    @Deprecated
    public static int SUPPRESSED_EFFECT_SCREEN_ON = 2;
    public static int REASON_CLICK = 1;
    public static int REASON_CANCEL = 2;
    public static int REASON_CANCEL_ALL = 3;
    public static int REASON_ERROR = 4;
    public static int REASON_PACKAGE_CHANGED = 5;
    public static int REASON_USER_STOPPED = 6;
    public static int REASON_PACKAGE_BANNED = 7;
    public static int REASON_APP_CANCEL = 8;
    public static int REASON_APP_CANCEL_ALL = 9;
    public static int REASON_LISTENER_CANCEL = 10;
    public static int REASON_LISTENER_CANCEL_ALL = 11;
    public static int REASON_GROUP_SUMMARY_CANCELED = 12;
    public static int REASON_GROUP_OPTIMIZATION = 13;
    public static int REASON_PACKAGE_SUSPENDED = 14;
    public static int REASON_PROFILE_TURNED_OFF = 15;
    public static int REASON_UNAUTOBUNDLED = 16;
    public static int REASON_CHANNEL_BANNED = 17;
    public static int REASON_SNOOZED = 18;
    public static int REASON_TIMEOUT = 19;
    @SystemApi
    public static int TRIM_FULL = 0;
    @SystemApi
    public static int TRIM_LIGHT = 1;
    public static int NOTIFICATION_CHANNEL_OR_GROUP_ADDED = 1;
    public static int NOTIFICATION_CHANNEL_OR_GROUP_UPDATED = 2;
    public static int NOTIFICATION_CHANNEL_OR_GROUP_DELETED = 3;
    private Object mLock;
    private Handler mHandler;
    protected NotificationListenerWrapper mWrapper;
    private boolean isConnected;
    @GuardedBy(value="mLock")
    private RankingMap mRankingMap;
    protected INotificationManager mNoMan;
    protected int mCurrentUser;
    protected Context mSystemContext;
    public static String SERVICE_INTERFACE = "android.service.notification.NotificationListenerService";

    private void $$robo$$android_service_notification_NotificationListenerService$__constructor__() {
        this.TAG = this.getClass().getSimpleName();
        this.mLock = new Object();
        this.mWrapper = null;
        this.isConnected = false;
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(this, this.getMainLooper());
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationPosted(StatusBarNotification sbn) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationPosted(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationPosted(sbn);
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(StatusBarNotification sbn) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationRemoved(sbn);
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap, int reason) {
        this.onNotificationRemoved(sbn, rankingMap);
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap, NotificationStats stats, int reason) {
        this.onNotificationRemoved(sbn, rankingMap, reason);
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onListenerConnected() {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onListenerDisconnected() {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationRankingUpdate(RankingMap rankingMap) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onListenerHintsChanged(int hints) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationChannelModified(String pkg, UserHandle user, NotificationChannel channel, int modificationType) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationChannelGroupModified(String pkg, UserHandle user, NotificationChannelGroup group, int modificationType) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onInterruptionFilterChanged(int interruptionFilter) {
    }

    private final INotificationManager $$robo$$android_service_notification_NotificationListenerService$getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    @Deprecated
    private final void $$robo$$android_service_notification_NotificationListenerService$cancelNotification(String pkg, String tag, int id2) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationFromListener(this.mWrapper, pkg, tag, id2);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$cancelNotification(String key) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, new String[]{key});
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$cancelAllNotifications() {
        this.cancelNotifications(null);
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$cancelNotifications(String[] keys) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, keys);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    @SystemApi
    private final void $$robo$$android_service_notification_NotificationListenerService$snoozeNotification(String key, String snoozeCriterionId) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().snoozeNotificationUntilContextFromListener(this.mWrapper, key, snoozeCriterionId);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$snoozeNotification(String key, long durationMs) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().snoozeNotificationUntilFromListener(this.mWrapper, key, durationMs);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$setNotificationsShown(String[] keys) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setNotificationsShownFromListener(this.mWrapper, keys);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$updateNotificationChannel(String pkg, UserHandle user, NotificationChannel channel) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().updateNotificationChannelFromPrivilegedListener(this.mWrapper, pkg, user, channel);
        }
        catch (RemoteException e) {
            Log.v(this.TAG, "Unable to contact notification manager", e);
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<NotificationChannel> $$robo$$android_service_notification_NotificationListenerService$getNotificationChannels(String pkg, UserHandle user) {
        if (!this.isBound()) {
            return null;
        }
        try {
            return this.getNotificationInterface().getNotificationChannelsFromPrivilegedListener(this.mWrapper, pkg, user).getList();
        }
        catch (RemoteException e) {
            Log.v(this.TAG, "Unable to contact notification manager", e);
            throw e.rethrowFromSystemServer();
        }
    }

    private final List<NotificationChannelGroup> $$robo$$android_service_notification_NotificationListenerService$getNotificationChannelGroups(String pkg, UserHandle user) {
        if (!this.isBound()) {
            return null;
        }
        try {
            return this.getNotificationInterface().getNotificationChannelGroupsFromPrivilegedListener(this.mWrapper, pkg, user).getList();
        }
        catch (RemoteException e) {
            Log.v(this.TAG, "Unable to contact notification manager", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    private final void $$robo$$android_service_notification_NotificationListenerService$setOnNotificationPostedTrim(int trim) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setOnNotificationPostedTrimFromListener(this.mWrapper, trim);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications() {
        StatusBarNotification[] activeNotifications = this.getActiveNotifications(null, 0);
        return activeNotifications != null ? activeNotifications : new StatusBarNotification[]{};
    }

    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getSnoozedNotifications() {
        try {
            ParceledListSlice parceledList = this.getNotificationInterface().getSnoozedNotificationsFromListener(this.mWrapper, 0);
            return this.cleanUpNotificationList(parceledList);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return null;
        }
    }

    @SystemApi
    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(int trim) {
        StatusBarNotification[] activeNotifications = this.getActiveNotifications(null, trim);
        return activeNotifications != null ? activeNotifications : new StatusBarNotification[]{};
    }

    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(String[] keys) {
        StatusBarNotification[] activeNotifications = this.getActiveNotifications(keys, 0);
        return activeNotifications != null ? activeNotifications : new StatusBarNotification[]{};
    }

    @SystemApi
    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(String[] keys, int trim) {
        if (!this.isBound()) {
            return null;
        }
        try {
            ParceledListSlice parceledList = this.getNotificationInterface().getActiveNotificationsFromListener(this.mWrapper, keys, trim);
            return this.cleanUpNotificationList(parceledList);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return null;
        }
    }

    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$cleanUpNotificationList(ParceledListSlice<StatusBarNotification> parceledList) {
        if (parceledList == null || parceledList.getList() == null) {
            return new StatusBarNotification[0];
        }
        List list = parceledList.getList();
        ArrayList<StatusBarNotification> corruptNotifications = null;
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            StatusBarNotification sbn = (StatusBarNotification)list.get(i);
            Notification notification = sbn.getNotification();
            try {
                this.createLegacyIconExtras(notification);
                this.maybePopulateRemoteViews(notification);
                this.maybePopulatePeople(notification);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (corruptNotifications == null) {
                    corruptNotifications = new ArrayList<StatusBarNotification>(N);
                }
                corruptNotifications.add(sbn);
                Log.w(this.TAG, "get(Active/Snoozed)Notifications: can't rebuild notification from " + sbn.getPackageName());
            }
        }
        if (corruptNotifications != null) {
            list.removeAll(corruptNotifications);
        }
        return list.toArray(new StatusBarNotification[list.size()]);
    }

    private final int $$robo$$android_service_notification_NotificationListenerService$getCurrentListenerHints() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getHintsFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    private final int $$robo$$android_service_notification_NotificationListenerService$getCurrentInterruptionFilter() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getInterruptionFilterFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$requestListenerHints(int hints) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestHintsFromListener(this.mWrapper, hints);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$requestInterruptionFilter(int interruptionFilter) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestInterruptionFilterFromListener(this.mWrapper, interruptionFilter);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RankingMap $$robo$$android_service_notification_NotificationListenerService$getCurrentRanking() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRankingMap;
        }
    }

    private final IBinder $$robo$$android_service_notification_NotificationListenerService$onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationListenerWrapper(this);
        }
        return this.mWrapper;
    }

    private final boolean $$robo$$android_service_notification_NotificationListenerService$isBound() {
        if (this.mWrapper == null) {
            Log.w(this.TAG, "Notification listener service not yet bound.");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onDestroy() {
        this.onListenerDisconnected();
        super.onDestroy();
    }

    @SystemApi
    private final void $$robo$$android_service_notification_NotificationListenerService$registerAsSystemService(Context context, ComponentName componentName, int currentUser) throws RemoteException {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationListenerWrapper(this);
        }
        this.mSystemContext = context;
        INotificationManager noMan = this.getNotificationInterface();
        this.mHandler = new MyHandler(this, context.getMainLooper());
        this.mCurrentUser = currentUser;
        noMan.registerListener(this.mWrapper, componentName, currentUser);
    }

    @SystemApi
    private final void $$robo$$android_service_notification_NotificationListenerService$unregisterAsSystemService() throws RemoteException {
        if (this.mWrapper != null) {
            INotificationManager noMan = this.getNotificationInterface();
            noMan.unregisterListener(this.mWrapper, this.mCurrentUser);
        }
    }

    private static final void $$robo$$android_service_notification_NotificationListenerService$requestRebind(ComponentName componentName) {
        INotificationManager noMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        try {
            noMan.requestBindListener(componentName);
        }
        catch (RemoteException ex) {
            throw ex.rethrowFromSystemServer();
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$requestUnbind() {
        if (this.mWrapper != null) {
            INotificationManager noMan = this.getNotificationInterface();
            try {
                noMan.requestUnbindListener(this.mWrapper);
                this.isConnected = false;
            }
            catch (RemoteException ex) {
                throw ex.rethrowFromSystemServer();
            }
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$createLegacyIconExtras(Notification n) {
        Drawable d;
        Icon smallIcon = n.getSmallIcon();
        Icon largeIcon = n.getLargeIcon();
        if (smallIcon != null && smallIcon.getType() == 2) {
            n.extras.putInt("android.icon", smallIcon.getResId());
            n.icon = smallIcon.getResId();
        }
        if (largeIcon != null && (d = largeIcon.loadDrawable(this.getContext())) != null && d instanceof BitmapDrawable) {
            Bitmap largeIconBits = ((BitmapDrawable)d).getBitmap();
            n.extras.putParcelable("android.largeIcon", largeIconBits);
            n.largeIcon = largeIconBits;
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$maybePopulateRemoteViews(Notification notification) {
        if (this.getContext().getApplicationInfo().targetSdkVersion < 24) {
            Notification.Builder builder = Notification.Builder.recoverBuilder(this.getContext(), notification);
            RemoteViews content = builder.createContentView();
            RemoteViews big = builder.createBigContentView();
            RemoteViews headsUp = builder.createHeadsUpContentView();
            notification.contentView = content;
            notification.bigContentView = big;
            notification.headsUpContentView = headsUp;
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$maybePopulatePeople(Notification notification) {
        ArrayList people;
        if (this.getContext().getApplicationInfo().targetSdkVersion < 28 && (people = notification.extras.getParcelableArrayList("android.people.list")) != null && people.isEmpty()) {
            int size = people.size();
            String[] peopleArray = new String[size];
            for (int i = 0; i < size; ++i) {
                Person person = (Person)people.get(i);
                peopleArray[i] = person.resolveToLegacyUri();
            }
            notification.extras.putStringArray("android.people", peopleArray);
        }
    }

    @GuardedBy(value="mLock")
    private final void $$robo$$android_service_notification_NotificationListenerService$applyUpdateLocked(NotificationRankingUpdate update) {
        this.mRankingMap = new RankingMap(update);
    }

    private final Context $$robo$$android_service_notification_NotificationListenerService$getContext() {
        if (this.mSystemContext != null) {
            return this.mSystemContext;
        }
        return this;
    }

    private void __constructor__() {
        this.$$robo$$android_service_notification_NotificationListenerService$__constructor__();
    }

    public NotificationListenerService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService$__constructor__(), 0, this);
    }

    @Override
    protected void attachBaseContext(Context context) {
        InvokeDynamicSupport.bootstrap("attachBaseContext", $$robo$$android_service_notification_NotificationListenerService$attachBaseContext(android.content.Context ), 0, this, context);
    }

    public void onNotificationPosted(StatusBarNotification statusBarNotification) {
        InvokeDynamicSupport.bootstrap("onNotificationPosted", $$robo$$android_service_notification_NotificationListenerService$onNotificationPosted(android.service.notification.StatusBarNotification ), 0, this, statusBarNotification);
    }

    public void onNotificationPosted(StatusBarNotification statusBarNotification, RankingMap rankingMap) {
        InvokeDynamicSupport.bootstrap("onNotificationPosted", $$robo$$android_service_notification_NotificationListenerService$onNotificationPosted(android.service.notification.StatusBarNotification android.service.notification.NotificationListenerService$RankingMap ), 0, this, statusBarNotification, rankingMap);
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification) {
        InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(android.service.notification.StatusBarNotification ), 0, this, statusBarNotification);
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification, RankingMap rankingMap) {
        InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(android.service.notification.StatusBarNotification android.service.notification.NotificationListenerService$RankingMap ), 0, this, statusBarNotification, rankingMap);
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification, RankingMap rankingMap, int n) {
        InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(android.service.notification.StatusBarNotification android.service.notification.NotificationListenerService$RankingMap int ), 0, this, statusBarNotification, rankingMap, n);
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification, RankingMap rankingMap, NotificationStats notificationStats, int n) {
        InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(android.service.notification.StatusBarNotification android.service.notification.NotificationListenerService$RankingMap android.service.notification.NotificationStats int ), 0, this, statusBarNotification, rankingMap, notificationStats, n);
    }

    public void onListenerConnected() {
        InvokeDynamicSupport.bootstrap("onListenerConnected", $$robo$$android_service_notification_NotificationListenerService$onListenerConnected(), 0, this);
    }

    public void onListenerDisconnected() {
        InvokeDynamicSupport.bootstrap("onListenerDisconnected", $$robo$$android_service_notification_NotificationListenerService$onListenerDisconnected(), 0, this);
    }

    public void onNotificationRankingUpdate(RankingMap rankingMap) {
        InvokeDynamicSupport.bootstrap("onNotificationRankingUpdate", $$robo$$android_service_notification_NotificationListenerService$onNotificationRankingUpdate(android.service.notification.NotificationListenerService$RankingMap ), 0, this, rankingMap);
    }

    public void onListenerHintsChanged(int n) {
        InvokeDynamicSupport.bootstrap("onListenerHintsChanged", $$robo$$android_service_notification_NotificationListenerService$onListenerHintsChanged(int ), 0, this, n);
    }

    public void onNotificationChannelModified(String string2, UserHandle userHandle, NotificationChannel notificationChannel, int n) {
        InvokeDynamicSupport.bootstrap("onNotificationChannelModified", $$robo$$android_service_notification_NotificationListenerService$onNotificationChannelModified(java.lang.String android.os.UserHandle android.app.NotificationChannel int ), 0, this, string2, userHandle, notificationChannel, n);
    }

    public void onNotificationChannelGroupModified(String string2, UserHandle userHandle, NotificationChannelGroup notificationChannelGroup, int n) {
        InvokeDynamicSupport.bootstrap("onNotificationChannelGroupModified", $$robo$$android_service_notification_NotificationListenerService$onNotificationChannelGroupModified(java.lang.String android.os.UserHandle android.app.NotificationChannelGroup int ), 0, this, string2, userHandle, notificationChannelGroup, n);
    }

    public void onInterruptionFilterChanged(int n) {
        InvokeDynamicSupport.bootstrap("onInterruptionFilterChanged", $$robo$$android_service_notification_NotificationListenerService$onInterruptionFilterChanged(int ), 0, this, n);
    }

    protected INotificationManager getNotificationInterface() {
        return InvokeDynamicSupport.bootstrap("getNotificationInterface", $$robo$$android_service_notification_NotificationListenerService$getNotificationInterface(), 0, this);
    }

    @Deprecated
    public void cancelNotification(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("cancelNotification", $$robo$$android_service_notification_NotificationListenerService$cancelNotification(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    public void cancelNotification(String string2) {
        InvokeDynamicSupport.bootstrap("cancelNotification", $$robo$$android_service_notification_NotificationListenerService$cancelNotification(java.lang.String ), 0, this, string2);
    }

    public void cancelAllNotifications() {
        InvokeDynamicSupport.bootstrap("cancelAllNotifications", $$robo$$android_service_notification_NotificationListenerService$cancelAllNotifications(), 0, this);
    }

    public void cancelNotifications(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("cancelNotifications", $$robo$$android_service_notification_NotificationListenerService$cancelNotifications(java.lang.String[] ), 0, this, stringArray);
    }

    @SystemApi
    public void snoozeNotification(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("snoozeNotification", $$robo$$android_service_notification_NotificationListenerService$snoozeNotification(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void snoozeNotification(String string2, long l) {
        InvokeDynamicSupport.bootstrap("snoozeNotification", $$robo$$android_service_notification_NotificationListenerService$snoozeNotification(java.lang.String long ), 0, this, string2, l);
    }

    public void setNotificationsShown(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setNotificationsShown", $$robo$$android_service_notification_NotificationListenerService$setNotificationsShown(java.lang.String[] ), 0, this, stringArray);
    }

    public void updateNotificationChannel(String string2, UserHandle userHandle, NotificationChannel notificationChannel) {
        InvokeDynamicSupport.bootstrap("updateNotificationChannel", $$robo$$android_service_notification_NotificationListenerService$updateNotificationChannel(java.lang.String android.os.UserHandle android.app.NotificationChannel ), 0, this, string2, userHandle, notificationChannel);
    }

    public List<NotificationChannel> getNotificationChannels(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getNotificationChannels", $$robo$$android_service_notification_NotificationListenerService$getNotificationChannels(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public List<NotificationChannelGroup> getNotificationChannelGroups(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getNotificationChannelGroups", $$robo$$android_service_notification_NotificationListenerService$getNotificationChannelGroups(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    @SystemApi
    public void setOnNotificationPostedTrim(int n) {
        InvokeDynamicSupport.bootstrap("setOnNotificationPostedTrim", $$robo$$android_service_notification_NotificationListenerService$setOnNotificationPostedTrim(int ), 0, this, n);
    }

    public StatusBarNotification[] getActiveNotifications() {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(), 0, this);
    }

    public StatusBarNotification[] getSnoozedNotifications() {
        return InvokeDynamicSupport.bootstrap("getSnoozedNotifications", $$robo$$android_service_notification_NotificationListenerService$getSnoozedNotifications(), 0, this);
    }

    @SystemApi
    public StatusBarNotification[] getActiveNotifications(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(int ), 0, this, n);
    }

    public StatusBarNotification[] getActiveNotifications(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(java.lang.String[] ), 0, this, stringArray);
    }

    @SystemApi
    public StatusBarNotification[] getActiveNotifications(String[] stringArray, int n) {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(java.lang.String[] int ), 0, this, stringArray, n);
    }

    private StatusBarNotification[] cleanUpNotificationList(ParceledListSlice<StatusBarNotification> parceledListSlice) {
        return InvokeDynamicSupport.bootstrap("cleanUpNotificationList", $$robo$$android_service_notification_NotificationListenerService$cleanUpNotificationList(android.content.pm.ParceledListSlice<android.service.notification.StatusBarNotification> ), 0, this, parceledListSlice);
    }

    public int getCurrentListenerHints() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentListenerHints", $$robo$$android_service_notification_NotificationListenerService$getCurrentListenerHints(), 0, this);
    }

    public int getCurrentInterruptionFilter() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentInterruptionFilter", $$robo$$android_service_notification_NotificationListenerService$getCurrentInterruptionFilter(), 0, this);
    }

    public void requestListenerHints(int n) {
        InvokeDynamicSupport.bootstrap("requestListenerHints", $$robo$$android_service_notification_NotificationListenerService$requestListenerHints(int ), 0, this, n);
    }

    public void requestInterruptionFilter(int n) {
        InvokeDynamicSupport.bootstrap("requestInterruptionFilter", $$robo$$android_service_notification_NotificationListenerService$requestInterruptionFilter(int ), 0, this, n);
    }

    public RankingMap getCurrentRanking() {
        return InvokeDynamicSupport.bootstrap("getCurrentRanking", $$robo$$android_service_notification_NotificationListenerService$getCurrentRanking(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_notification_NotificationListenerService$onBind(android.content.Intent ), 0, this, intent);
    }

    protected boolean isBound() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBound", $$robo$$android_service_notification_NotificationListenerService$isBound(), 0, this);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_service_notification_NotificationListenerService$onDestroy(), 0, this);
    }

    @SystemApi
    public void registerAsSystemService(Context context, ComponentName componentName, int n) throws RemoteException {
        InvokeDynamicSupport.bootstrap("registerAsSystemService", $$robo$$android_service_notification_NotificationListenerService$registerAsSystemService(android.content.Context android.content.ComponentName int ), 0, this, context, componentName, n);
    }

    @SystemApi
    public void unregisterAsSystemService() throws RemoteException {
        InvokeDynamicSupport.bootstrap("unregisterAsSystemService", $$robo$$android_service_notification_NotificationListenerService$unregisterAsSystemService(), 0, this);
    }

    public static void requestRebind(ComponentName componentName) {
        InvokeDynamicSupport.bootstrapStatic("requestRebind", $$robo$$android_service_notification_NotificationListenerService$requestRebind(android.content.ComponentName ), 0, (ComponentName)componentName);
    }

    public void requestUnbind() {
        InvokeDynamicSupport.bootstrap("requestUnbind", $$robo$$android_service_notification_NotificationListenerService$requestUnbind(), 0, this);
    }

    private void createLegacyIconExtras(Notification notification) {
        InvokeDynamicSupport.bootstrap("createLegacyIconExtras", $$robo$$android_service_notification_NotificationListenerService$createLegacyIconExtras(android.app.Notification ), 0, this, notification);
    }

    private void maybePopulateRemoteViews(Notification notification) {
        InvokeDynamicSupport.bootstrap("maybePopulateRemoteViews", $$robo$$android_service_notification_NotificationListenerService$maybePopulateRemoteViews(android.app.Notification ), 0, this, notification);
    }

    private void maybePopulatePeople(Notification notification) {
        InvokeDynamicSupport.bootstrap("maybePopulatePeople", $$robo$$android_service_notification_NotificationListenerService$maybePopulatePeople(android.app.Notification ), 0, this, notification);
    }

    public void applyUpdateLocked(NotificationRankingUpdate notificationRankingUpdate) {
        InvokeDynamicSupport.bootstrap("applyUpdateLocked", $$robo$$android_service_notification_NotificationListenerService$applyUpdateLocked(android.service.notification.NotificationRankingUpdate ), 0, this, notificationRankingUpdate);
    }

    protected Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_service_notification_NotificationListenerService$getContext(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationListenerService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MyHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MSG_ON_NOTIFICATION_POSTED = 1;
        public static int MSG_ON_NOTIFICATION_REMOVED = 2;
        public static int MSG_ON_LISTENER_CONNECTED = 3;
        public static int MSG_ON_NOTIFICATION_RANKING_UPDATE = 4;
        public static int MSG_ON_LISTENER_HINTS_CHANGED = 5;
        public static int MSG_ON_INTERRUPTION_FILTER_CHANGED = 6;
        public static int MSG_ON_NOTIFICATION_CHANNEL_MODIFIED = 7;
        public static int MSG_ON_NOTIFICATION_CHANNEL_GROUP_MODIFIED = 8;
        /* synthetic */ NotificationListenerService this$0;

        private void $$robo$$android_service_notification_NotificationListenerService_MyHandler$__constructor__(NotificationListenerService notificationListenerService, Looper looper) {
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_MyHandler$handleMessage(Message msg) {
            if (!this.this$0.isConnected) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    RankingMap rankingMap = (RankingMap)args.arg2;
                    args.recycle();
                    this.this$0.onNotificationPosted(sbn, rankingMap);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    RankingMap rankingMap = (RankingMap)args.arg2;
                    int reason = (Integer)args.arg3;
                    NotificationStats stats = (NotificationStats)args.arg4;
                    args.recycle();
                    this.this$0.onNotificationRemoved(sbn, rankingMap, stats, reason);
                    break;
                }
                case 3: {
                    this.this$0.onListenerConnected();
                    break;
                }
                case 4: {
                    RankingMap rankingMap = (RankingMap)msg.obj;
                    this.this$0.onNotificationRankingUpdate(rankingMap);
                    break;
                }
                case 5: {
                    int hints = msg.arg1;
                    this.this$0.onListenerHintsChanged(hints);
                    break;
                }
                case 6: {
                    int interruptionFilter = msg.arg1;
                    this.this$0.onInterruptionFilterChanged(interruptionFilter);
                    break;
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String pkgName = (String)args.arg1;
                    UserHandle user = (UserHandle)args.arg2;
                    NotificationChannel channel = (NotificationChannel)args.arg3;
                    int modificationType = (Integer)args.arg4;
                    this.this$0.onNotificationChannelModified(pkgName, user, channel, modificationType);
                    break;
                }
                case 8: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String pkgName = (String)args.arg1;
                    UserHandle user = (UserHandle)args.arg2;
                    NotificationChannelGroup group = (NotificationChannelGroup)args.arg3;
                    int modificationType = (Integer)args.arg4;
                    this.this$0.onNotificationChannelGroupModified(pkgName, user, group, modificationType);
                }
            }
        }

        private void __constructor__(NotificationListenerService notificationListenerService, Looper looper) {
            this.$$robo$$android_service_notification_NotificationListenerService_MyHandler$__constructor__(notificationListenerService, looper);
        }

        public MyHandler(NotificationListenerService notificationListenerService, Looper looper) {
            this.this$0 = notificationListenerService;
            super(looper, null, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_MyHandler$__constructor__(android.service.notification.NotificationListenerService android.os.Looper ), 0, this, notificationListenerService, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_service_notification_NotificationListenerService_MyHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ MyHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RankingMap
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private NotificationRankingUpdate mRankingUpdate;
        private ArrayMap<String, Integer> mRanks;
        private ArraySet<Object> mIntercepted;
        private ArrayMap<String, Integer> mVisibilityOverrides;
        private ArrayMap<String, Integer> mSuppressedVisualEffects;
        private ArrayMap<String, Integer> mImportance;
        private ArrayMap<String, String> mImportanceExplanation;
        private ArrayMap<String, String> mOverrideGroupKeys;
        private ArrayMap<String, NotificationChannel> mChannels;
        private ArrayMap<String, ArrayList<String>> mOverridePeople;
        private ArrayMap<String, ArrayList<SnoozeCriterion>> mSnoozeCriteria;
        private ArrayMap<String, Boolean> mShowBadge;
        private ArrayMap<String, Integer> mUserSentiment;
        private ArrayMap<String, Boolean> mHidden;
        public static Parcelable.Creator<RankingMap> CREATOR;

        private void $$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(NotificationRankingUpdate rankingUpdate) {
            this.mRankingUpdate = rankingUpdate;
        }

        private final String[] $$robo$$android_service_notification_NotificationListenerService_RankingMap$getOrderedKeys() {
            return this.mRankingUpdate.getOrderedKeys();
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_RankingMap$getRanking(String key, Ranking outRanking) {
            int rank = this.getRank(key);
            outRanking.populate(key, rank, !this.isIntercepted(key), this.getVisibilityOverride(key), this.getSuppressedVisualEffects(key), this.getImportance(key), this.getImportanceExplanation(key), this.getOverrideGroupKey(key), this.getChannel(key), this.getOverridePeople(key), this.getSnoozeCriteria(key), this.getShowBadge(key), this.getUserSentiment(key), this.getHidden(key));
            return rank >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$getRank(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mRanks == null) {
                    this.buildRanksLocked();
                }
            }
            Integer rank = this.mRanks.get(key);
            return rank != null ? rank : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_service_notification_NotificationListenerService_RankingMap$isIntercepted(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mIntercepted == null) {
                    this.buildInterceptedSetLocked();
                }
            }
            return this.mIntercepted.contains(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$getVisibilityOverride(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mVisibilityOverrides == null) {
                    this.buildVisibilityOverridesLocked();
                }
            }
            Integer override = this.mVisibilityOverrides.get(key);
            if (override == null) {
                return -1000;
            }
            return override;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$getSuppressedVisualEffects(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mSuppressedVisualEffects == null) {
                    this.buildSuppressedVisualEffectsLocked();
                }
            }
            Integer suppressed = this.mSuppressedVisualEffects.get(key);
            if (suppressed == null) {
                return 0;
            }
            return suppressed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$getImportance(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mImportance == null) {
                    this.buildImportanceLocked();
                }
            }
            Integer importance = this.mImportance.get(key);
            if (importance == null) {
                return 3;
            }
            return importance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_service_notification_NotificationListenerService_RankingMap$getImportanceExplanation(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mImportanceExplanation == null) {
                    this.buildImportanceExplanationLocked();
                }
            }
            return this.mImportanceExplanation.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_service_notification_NotificationListenerService_RankingMap$getOverrideGroupKey(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mOverrideGroupKeys == null) {
                    this.buildOverrideGroupKeys();
                }
            }
            return this.mOverrideGroupKeys.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final NotificationChannel $$robo$$android_service_notification_NotificationListenerService_RankingMap$getChannel(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mChannels == null) {
                    this.buildChannelsLocked();
                }
            }
            return this.mChannels.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ArrayList<String> $$robo$$android_service_notification_NotificationListenerService_RankingMap$getOverridePeople(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mOverridePeople == null) {
                    this.buildOverridePeopleLocked();
                }
            }
            return this.mOverridePeople.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ArrayList<SnoozeCriterion> $$robo$$android_service_notification_NotificationListenerService_RankingMap$getSnoozeCriteria(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mSnoozeCriteria == null) {
                    this.buildSnoozeCriteriaLocked();
                }
            }
            return this.mSnoozeCriteria.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_service_notification_NotificationListenerService_RankingMap$getShowBadge(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mShowBadge == null) {
                    this.buildShowBadgeLocked();
                }
            }
            Boolean showBadge = this.mShowBadge.get(key);
            return showBadge == null ? false : showBadge;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$getUserSentiment(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mUserSentiment == null) {
                    this.buildUserSentimentLocked();
                }
            }
            Integer userSentiment = this.mUserSentiment.get(key);
            return userSentiment == null ? 0 : userSentiment;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_service_notification_NotificationListenerService_RankingMap$getHidden(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mHidden == null) {
                    this.buildHiddenLocked();
                }
            }
            Boolean hidden = this.mHidden.get(key);
            return hidden == null ? false : hidden;
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildRanksLocked() {
            String[] orderedKeys = this.mRankingUpdate.getOrderedKeys();
            this.mRanks = new ArrayMap(orderedKeys.length);
            for (int i = 0; i < orderedKeys.length; ++i) {
                String key = orderedKeys[i];
                this.mRanks.put(key, i);
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildInterceptedSetLocked() {
            String[] dndInterceptedKeys = this.mRankingUpdate.getInterceptedKeys();
            this.mIntercepted = new ArraySet(dndInterceptedKeys.length);
            Collections.addAll(this.mIntercepted, dndInterceptedKeys);
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildVisibilityOverridesLocked() {
            Bundle visibilityBundle = this.mRankingUpdate.getVisibilityOverrides();
            this.mVisibilityOverrides = new ArrayMap(visibilityBundle.size());
            for (String key : visibilityBundle.keySet()) {
                this.mVisibilityOverrides.put(key, visibilityBundle.getInt(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildSuppressedVisualEffectsLocked() {
            Bundle suppressedBundle = this.mRankingUpdate.getSuppressedVisualEffects();
            this.mSuppressedVisualEffects = new ArrayMap(suppressedBundle.size());
            for (String key : suppressedBundle.keySet()) {
                this.mSuppressedVisualEffects.put(key, suppressedBundle.getInt(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildImportanceLocked() {
            String[] orderedKeys = this.mRankingUpdate.getOrderedKeys();
            int[] importance = this.mRankingUpdate.getImportance();
            this.mImportance = new ArrayMap(orderedKeys.length);
            for (int i = 0; i < orderedKeys.length; ++i) {
                String key = orderedKeys[i];
                this.mImportance.put(key, importance[i]);
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildImportanceExplanationLocked() {
            Bundle explanationBundle = this.mRankingUpdate.getImportanceExplanation();
            this.mImportanceExplanation = new ArrayMap(explanationBundle.size());
            for (String key : explanationBundle.keySet()) {
                this.mImportanceExplanation.put(key, explanationBundle.getString(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildOverrideGroupKeys() {
            Bundle overrideGroupKeys = this.mRankingUpdate.getOverrideGroupKeys();
            this.mOverrideGroupKeys = new ArrayMap(overrideGroupKeys.size());
            for (String key : overrideGroupKeys.keySet()) {
                this.mOverrideGroupKeys.put(key, overrideGroupKeys.getString(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildChannelsLocked() {
            Bundle channels = this.mRankingUpdate.getChannels();
            this.mChannels = new ArrayMap(channels.size());
            for (String key : channels.keySet()) {
                this.mChannels.put(key, (NotificationChannel)channels.getParcelable(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildOverridePeopleLocked() {
            Bundle overridePeople = this.mRankingUpdate.getOverridePeople();
            this.mOverridePeople = new ArrayMap(overridePeople.size());
            for (String key : overridePeople.keySet()) {
                this.mOverridePeople.put(key, overridePeople.getStringArrayList(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildSnoozeCriteriaLocked() {
            Bundle snoozeCriteria = this.mRankingUpdate.getSnoozeCriteria();
            this.mSnoozeCriteria = new ArrayMap(snoozeCriteria.size());
            for (String key : snoozeCriteria.keySet()) {
                this.mSnoozeCriteria.put(key, snoozeCriteria.getParcelableArrayList(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildShowBadgeLocked() {
            Bundle showBadge = this.mRankingUpdate.getShowBadge();
            this.mShowBadge = new ArrayMap(showBadge.size());
            for (String key : showBadge.keySet()) {
                this.mShowBadge.put(key, showBadge.getBoolean(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildUserSentimentLocked() {
            Bundle userSentiment = this.mRankingUpdate.getUserSentiment();
            this.mUserSentiment = new ArrayMap(userSentiment.size());
            for (String key : userSentiment.keySet()) {
                this.mUserSentiment.put(key, userSentiment.getInt(key));
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildHiddenLocked() {
            Bundle hidden = this.mRankingUpdate.getHidden();
            this.mHidden = new ArrayMap(hidden.size());
            for (String key : hidden.keySet()) {
                this.mHidden.put(key, hidden.getBoolean(key));
            }
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$describeContents() {
            return 0;
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mRankingUpdate, flags);
        }

        private /* synthetic */ void $$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(NotificationRankingUpdate x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RankingMap>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$__constructor__() {
                }

                private final RankingMap $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$createFromParcel(Parcel source) {
                    NotificationRankingUpdate rankingUpdate = (NotificationRankingUpdate)source.readParcelable(null);
                    return new RankingMap(rankingUpdate);
                }

                private final RankingMap[] $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$newArray(int size) {
                    return new RankingMap[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_service_notification_NotificationListenerService_RankingMap_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$__constructor__(), 0, this);
                }

                @Override
                public RankingMap createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RankingMap[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(NotificationRankingUpdate notificationRankingUpdate) {
            this.$$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(notificationRankingUpdate);
        }

        private RankingMap(NotificationRankingUpdate notificationRankingUpdate) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(android.service.notification.NotificationRankingUpdate ), 0, this, notificationRankingUpdate);
        }

        public String[] getOrderedKeys() {
            return InvokeDynamicSupport.bootstrap("getOrderedKeys", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getOrderedKeys(), 0, this);
        }

        public boolean getRanking(String string2, Ranking ranking) {
            return (boolean)InvokeDynamicSupport.bootstrap("getRanking", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getRanking(java.lang.String android.service.notification.NotificationListenerService$Ranking ), 0, this, string2, ranking);
        }

        private int getRank(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getRank", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getRank(java.lang.String ), 0, this, string2);
        }

        private boolean isIntercepted(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isIntercepted", $$robo$$android_service_notification_NotificationListenerService_RankingMap$isIntercepted(java.lang.String ), 0, this, string2);
        }

        private int getVisibilityOverride(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getVisibilityOverride", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getVisibilityOverride(java.lang.String ), 0, this, string2);
        }

        private int getSuppressedVisualEffects(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getSuppressedVisualEffects", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getSuppressedVisualEffects(java.lang.String ), 0, this, string2);
        }

        private int getImportance(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getImportance", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getImportance(java.lang.String ), 0, this, string2);
        }

        private String getImportanceExplanation(String string2) {
            return InvokeDynamicSupport.bootstrap("getImportanceExplanation", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getImportanceExplanation(java.lang.String ), 0, this, string2);
        }

        private String getOverrideGroupKey(String string2) {
            return InvokeDynamicSupport.bootstrap("getOverrideGroupKey", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getOverrideGroupKey(java.lang.String ), 0, this, string2);
        }

        private NotificationChannel getChannel(String string2) {
            return InvokeDynamicSupport.bootstrap("getChannel", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getChannel(java.lang.String ), 0, this, string2);
        }

        private ArrayList<String> getOverridePeople(String string2) {
            return InvokeDynamicSupport.bootstrap("getOverridePeople", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getOverridePeople(java.lang.String ), 0, this, string2);
        }

        private ArrayList<SnoozeCriterion> getSnoozeCriteria(String string2) {
            return InvokeDynamicSupport.bootstrap("getSnoozeCriteria", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getSnoozeCriteria(java.lang.String ), 0, this, string2);
        }

        private boolean getShowBadge(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("getShowBadge", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getShowBadge(java.lang.String ), 0, this, string2);
        }

        private int getUserSentiment(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getUserSentiment", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getUserSentiment(java.lang.String ), 0, this, string2);
        }

        private boolean getHidden(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("getHidden", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getHidden(java.lang.String ), 0, this, string2);
        }

        private void buildRanksLocked() {
            InvokeDynamicSupport.bootstrap("buildRanksLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildRanksLocked(), 0, this);
        }

        private void buildInterceptedSetLocked() {
            InvokeDynamicSupport.bootstrap("buildInterceptedSetLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildInterceptedSetLocked(), 0, this);
        }

        private void buildVisibilityOverridesLocked() {
            InvokeDynamicSupport.bootstrap("buildVisibilityOverridesLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildVisibilityOverridesLocked(), 0, this);
        }

        private void buildSuppressedVisualEffectsLocked() {
            InvokeDynamicSupport.bootstrap("buildSuppressedVisualEffectsLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildSuppressedVisualEffectsLocked(), 0, this);
        }

        private void buildImportanceLocked() {
            InvokeDynamicSupport.bootstrap("buildImportanceLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildImportanceLocked(), 0, this);
        }

        private void buildImportanceExplanationLocked() {
            InvokeDynamicSupport.bootstrap("buildImportanceExplanationLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildImportanceExplanationLocked(), 0, this);
        }

        private void buildOverrideGroupKeys() {
            InvokeDynamicSupport.bootstrap("buildOverrideGroupKeys", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildOverrideGroupKeys(), 0, this);
        }

        private void buildChannelsLocked() {
            InvokeDynamicSupport.bootstrap("buildChannelsLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildChannelsLocked(), 0, this);
        }

        private void buildOverridePeopleLocked() {
            InvokeDynamicSupport.bootstrap("buildOverridePeopleLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildOverridePeopleLocked(), 0, this);
        }

        private void buildSnoozeCriteriaLocked() {
            InvokeDynamicSupport.bootstrap("buildSnoozeCriteriaLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildSnoozeCriteriaLocked(), 0, this);
        }

        private void buildShowBadgeLocked() {
            InvokeDynamicSupport.bootstrap("buildShowBadgeLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildShowBadgeLocked(), 0, this);
        }

        private void buildUserSentimentLocked() {
            InvokeDynamicSupport.bootstrap("buildUserSentimentLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildUserSentimentLocked(), 0, this);
        }

        private void buildHiddenLocked() {
            InvokeDynamicSupport.bootstrap("buildHiddenLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildHiddenLocked(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_notification_NotificationListenerService_RankingMap$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_notification_NotificationListenerService_RankingMap$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(NotificationRankingUpdate notificationRankingUpdate, 1 var2_2) {
            this.$$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(notificationRankingUpdate, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RankingMap.class);
        }

        public /* synthetic */ RankingMap() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RankingMap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Ranking
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int VISIBILITY_NO_OVERRIDE = -1000;
        public static int USER_SENTIMENT_NEGATIVE = -1;
        public static int USER_SENTIMENT_NEUTRAL = 0;
        public static int USER_SENTIMENT_POSITIVE = 1;
        private String mKey;
        private int mRank;
        private boolean mIsAmbient;
        private boolean mMatchesInterruptionFilter;
        private int mVisibilityOverride;
        private int mSuppressedVisualEffects;
        private int mImportance;
        private CharSequence mImportanceExplanation;
        private String mOverrideGroupKey;
        private NotificationChannel mChannel;
        private ArrayList<String> mOverridePeople;
        private ArrayList<SnoozeCriterion> mSnoozeCriteria;
        private boolean mShowBadge;
        private int mUserSentiment;
        private boolean mHidden;

        private void $$robo$$android_service_notification_NotificationListenerService_Ranking$__constructor__() {
            this.mRank = -1;
            this.mUserSentiment = 0;
        }

        private final String $$robo$$android_service_notification_NotificationListenerService_Ranking$getKey() {
            return this.mKey;
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_Ranking$getRank() {
            return this.mRank;
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_Ranking$isAmbient() {
            return this.mIsAmbient;
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_Ranking$getVisibilityOverride() {
            return this.mVisibilityOverride;
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_Ranking$getSuppressedVisualEffects() {
            return this.mSuppressedVisualEffects;
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_Ranking$matchesInterruptionFilter() {
            return this.mMatchesInterruptionFilter;
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_Ranking$getImportance() {
            return this.mImportance;
        }

        private final CharSequence $$robo$$android_service_notification_NotificationListenerService_Ranking$getImportanceExplanation() {
            return this.mImportanceExplanation;
        }

        private final String $$robo$$android_service_notification_NotificationListenerService_Ranking$getOverrideGroupKey() {
            return this.mOverrideGroupKey;
        }

        private final NotificationChannel $$robo$$android_service_notification_NotificationListenerService_Ranking$getChannel() {
            return this.mChannel;
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_Ranking$getUserSentiment() {
            return this.mUserSentiment;
        }

        @SystemApi
        private final List<String> $$robo$$android_service_notification_NotificationListenerService_Ranking$getAdditionalPeople() {
            return this.mOverridePeople;
        }

        @SystemApi
        private final List<SnoozeCriterion> $$robo$$android_service_notification_NotificationListenerService_Ranking$getSnoozeCriteria() {
            return this.mSnoozeCriteria;
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_Ranking$canShowBadge() {
            return this.mShowBadge;
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_Ranking$isSuspended() {
            return this.mHidden;
        }

        @VisibleForTesting
        private final void $$robo$$android_service_notification_NotificationListenerService_Ranking$populate(String key, int rank, boolean matchesInterruptionFilter, int visibilityOverride, int suppressedVisualEffects, int importance, CharSequence explanation, String overrideGroupKey, NotificationChannel channel, ArrayList<String> overridePeople, ArrayList<SnoozeCriterion> snoozeCriteria, boolean showBadge, int userSentiment, boolean hidden) {
            this.mKey = key;
            this.mRank = rank;
            this.mIsAmbient = importance < 2;
            this.mMatchesInterruptionFilter = matchesInterruptionFilter;
            this.mVisibilityOverride = visibilityOverride;
            this.mSuppressedVisualEffects = suppressedVisualEffects;
            this.mImportance = importance;
            this.mImportanceExplanation = explanation;
            this.mOverrideGroupKey = overrideGroupKey;
            this.mChannel = channel;
            this.mOverridePeople = overridePeople;
            this.mSnoozeCriteria = snoozeCriteria;
            this.mShowBadge = showBadge;
            this.mUserSentiment = userSentiment;
            this.mHidden = hidden;
        }

        private static final String $$robo$$android_service_notification_NotificationListenerService_Ranking$importanceToString(int importance) {
            switch (importance) {
                case -1000: {
                    return "UNSPECIFIED";
                }
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return "MIN";
                }
                case 2: {
                    return "LOW";
                }
                case 3: {
                    return "DEFAULT";
                }
                case 4: 
                case 5: {
                    return "HIGH";
                }
            }
            return "UNKNOWN(" + String.valueOf(importance) + ")";
        }

        private void __constructor__() {
            this.$$robo$$android_service_notification_NotificationListenerService_Ranking$__constructor__();
        }

        public Ranking() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_Ranking$__constructor__(), 0, this);
        }

        public String getKey() {
            return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_service_notification_NotificationListenerService_Ranking$getKey(), 0, this);
        }

        public int getRank() {
            return (int)InvokeDynamicSupport.bootstrap("getRank", $$robo$$android_service_notification_NotificationListenerService_Ranking$getRank(), 0, this);
        }

        public boolean isAmbient() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAmbient", $$robo$$android_service_notification_NotificationListenerService_Ranking$isAmbient(), 0, this);
        }

        public int getVisibilityOverride() {
            return (int)InvokeDynamicSupport.bootstrap("getVisibilityOverride", $$robo$$android_service_notification_NotificationListenerService_Ranking$getVisibilityOverride(), 0, this);
        }

        public int getSuppressedVisualEffects() {
            return (int)InvokeDynamicSupport.bootstrap("getSuppressedVisualEffects", $$robo$$android_service_notification_NotificationListenerService_Ranking$getSuppressedVisualEffects(), 0, this);
        }

        public boolean matchesInterruptionFilter() {
            return (boolean)InvokeDynamicSupport.bootstrap("matchesInterruptionFilter", $$robo$$android_service_notification_NotificationListenerService_Ranking$matchesInterruptionFilter(), 0, this);
        }

        public int getImportance() {
            return (int)InvokeDynamicSupport.bootstrap("getImportance", $$robo$$android_service_notification_NotificationListenerService_Ranking$getImportance(), 0, this);
        }

        public CharSequence getImportanceExplanation() {
            return InvokeDynamicSupport.bootstrap("getImportanceExplanation", $$robo$$android_service_notification_NotificationListenerService_Ranking$getImportanceExplanation(), 0, this);
        }

        public String getOverrideGroupKey() {
            return InvokeDynamicSupport.bootstrap("getOverrideGroupKey", $$robo$$android_service_notification_NotificationListenerService_Ranking$getOverrideGroupKey(), 0, this);
        }

        public NotificationChannel getChannel() {
            return InvokeDynamicSupport.bootstrap("getChannel", $$robo$$android_service_notification_NotificationListenerService_Ranking$getChannel(), 0, this);
        }

        public int getUserSentiment() {
            return (int)InvokeDynamicSupport.bootstrap("getUserSentiment", $$robo$$android_service_notification_NotificationListenerService_Ranking$getUserSentiment(), 0, this);
        }

        @SystemApi
        public List<String> getAdditionalPeople() {
            return InvokeDynamicSupport.bootstrap("getAdditionalPeople", $$robo$$android_service_notification_NotificationListenerService_Ranking$getAdditionalPeople(), 0, this);
        }

        @SystemApi
        public List<SnoozeCriterion> getSnoozeCriteria() {
            return InvokeDynamicSupport.bootstrap("getSnoozeCriteria", $$robo$$android_service_notification_NotificationListenerService_Ranking$getSnoozeCriteria(), 0, this);
        }

        public boolean canShowBadge() {
            return (boolean)InvokeDynamicSupport.bootstrap("canShowBadge", $$robo$$android_service_notification_NotificationListenerService_Ranking$canShowBadge(), 0, this);
        }

        public boolean isSuspended() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSuspended", $$robo$$android_service_notification_NotificationListenerService_Ranking$isSuspended(), 0, this);
        }

        public void populate(String string2, int n, boolean bl, int n2, int n3, int n4, CharSequence charSequence, String string3, NotificationChannel notificationChannel, ArrayList<String> arrayList, ArrayList<SnoozeCriterion> arrayList2, boolean bl2, int n5, boolean bl3) {
            InvokeDynamicSupport.bootstrap("populate", $$robo$$android_service_notification_NotificationListenerService_Ranking$populate(java.lang.String int boolean int int int java.lang.CharSequence java.lang.String android.app.NotificationChannel java.util.ArrayList<java.lang.String> java.util.ArrayList<android.service.notification.SnoozeCriterion> boolean int boolean ), 0, this, string2, n, bl, n2, n3, n4, charSequence, string3, notificationChannel, arrayList, arrayList2, bl2, n5, bl3);
        }

        public static String importanceToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("importanceToString", $$robo$$android_service_notification_NotificationListenerService_Ranking$importanceToString(int ), 0, (int)n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ranking)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface UserSentiment {
        }
    }

    protected class NotificationListenerWrapper
    extends INotificationListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NotificationListenerService this$0;

        private void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$__constructor__(NotificationListenerService this$0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationPosted(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(this.this$0.TAG, "onNotificationPosted: Error receiving StatusBarNotification", e);
                return;
            }
            try {
                this.this$0.createLegacyIconExtras(sbn.getNotification());
                this.this$0.maybePopulateRemoteViews(sbn.getNotification());
                this.this$0.maybePopulatePeople(sbn.getNotification());
            }
            catch (IllegalArgumentException e) {
                Log.w(this.this$0.TAG, "onNotificationPosted: can't rebuild notification from " + sbn.getPackageName());
                sbn = null;
            }
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.applyUpdateLocked(update);
                if (sbn != null) {
                    SomeArgs args = SomeArgs.obtain();
                    args.arg1 = sbn;
                    args.arg2 = this.this$0.mRankingMap;
                    this.this$0.mHandler.obtainMessage(1, args).sendToTarget();
                } else {
                    this.this$0.mHandler.obtainMessage(4, this.this$0.mRankingMap).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationRemoved(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update, NotificationStats stats, int reason) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(this.this$0.TAG, "onNotificationRemoved: Error receiving StatusBarNotification", e);
                return;
            }
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.applyUpdateLocked(update);
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = sbn;
                args.arg2 = this.this$0.mRankingMap;
                args.arg3 = reason;
                args.arg4 = stats;
                this.this$0.mHandler.obtainMessage(2, args).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onListenerConnected(NotificationRankingUpdate update) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.applyUpdateLocked(update);
            }
            this.this$0.isConnected = true;
            this.this$0.mHandler.obtainMessage(3).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.applyUpdateLocked(update);
                this.this$0.mHandler.obtainMessage(4, this.this$0.mRankingMap).sendToTarget();
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onListenerHintsChanged(int hints) throws RemoteException {
            this.this$0.mHandler.obtainMessage(5, hints, 0).sendToTarget();
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
            this.this$0.mHandler.obtainMessage(6, interruptionFilter, 0).sendToTarget();
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationEnqueued(IStatusBarNotificationHolder notificationHolder) throws RemoteException {
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationSnoozedUntilContext(IStatusBarNotificationHolder notificationHolder, String snoozeCriterionId) throws RemoteException {
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationChannelModification(String pkgName, UserHandle user, NotificationChannel channel, int modificationType) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = pkgName;
            args.arg2 = user;
            args.arg3 = channel;
            args.arg4 = modificationType;
            this.this$0.mHandler.obtainMessage(7, args).sendToTarget();
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationChannelGroupModification(String pkgName, UserHandle user, NotificationChannelGroup group, int modificationType) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = pkgName;
            args.arg2 = user;
            args.arg3 = group;
            args.arg4 = modificationType;
            this.this$0.mHandler.obtainMessage(8, args).sendToTarget();
        }

        private void __constructor__(NotificationListenerService notificationListenerService) {
            this.$$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$__constructor__(notificationListenerService);
        }

        protected NotificationListenerWrapper(NotificationListenerService notificationListenerService) {
            this.this$0 = notificationListenerService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$__constructor__(android.service.notification.NotificationListenerService ), 0, this, notificationListenerService);
        }

        @Override
        public void onNotificationPosted(IStatusBarNotificationHolder iStatusBarNotificationHolder, NotificationRankingUpdate notificationRankingUpdate) {
            InvokeDynamicSupport.bootstrap("onNotificationPosted", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationPosted(android.service.notification.IStatusBarNotificationHolder android.service.notification.NotificationRankingUpdate ), 0, this, iStatusBarNotificationHolder, notificationRankingUpdate);
        }

        @Override
        public void onNotificationRemoved(IStatusBarNotificationHolder iStatusBarNotificationHolder, NotificationRankingUpdate notificationRankingUpdate, NotificationStats notificationStats, int n) {
            InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationRemoved(android.service.notification.IStatusBarNotificationHolder android.service.notification.NotificationRankingUpdate android.service.notification.NotificationStats int ), 0, this, iStatusBarNotificationHolder, notificationRankingUpdate, notificationStats, n);
        }

        @Override
        public void onListenerConnected(NotificationRankingUpdate notificationRankingUpdate) {
            InvokeDynamicSupport.bootstrap("onListenerConnected", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onListenerConnected(android.service.notification.NotificationRankingUpdate ), 0, this, notificationRankingUpdate);
        }

        @Override
        public void onNotificationRankingUpdate(NotificationRankingUpdate notificationRankingUpdate) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onNotificationRankingUpdate", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationRankingUpdate(android.service.notification.NotificationRankingUpdate ), 0, this, notificationRankingUpdate);
        }

        @Override
        public void onListenerHintsChanged(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onListenerHintsChanged", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onListenerHintsChanged(int ), 0, this, n);
        }

        @Override
        public void onInterruptionFilterChanged(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onInterruptionFilterChanged", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onInterruptionFilterChanged(int ), 0, this, n);
        }

        @Override
        public void onNotificationEnqueued(IStatusBarNotificationHolder iStatusBarNotificationHolder) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onNotificationEnqueued", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationEnqueued(android.service.notification.IStatusBarNotificationHolder ), 0, this, iStatusBarNotificationHolder);
        }

        @Override
        public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder iStatusBarNotificationHolder, String string2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onNotificationSnoozedUntilContext", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationSnoozedUntilContext(android.service.notification.IStatusBarNotificationHolder java.lang.String ), 0, this, iStatusBarNotificationHolder, string2);
        }

        @Override
        public void onNotificationChannelModification(String string2, UserHandle userHandle, NotificationChannel notificationChannel, int n) {
            InvokeDynamicSupport.bootstrap("onNotificationChannelModification", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationChannelModification(java.lang.String android.os.UserHandle android.app.NotificationChannel int ), 0, this, string2, userHandle, notificationChannel, n);
        }

        @Override
        public void onNotificationChannelGroupModification(String string2, UserHandle userHandle, NotificationChannelGroup notificationChannelGroup, int n) {
            InvokeDynamicSupport.bootstrap("onNotificationChannelGroupModification", $$robo$$android_service_notification_NotificationListenerService_NotificationListenerWrapper$onNotificationChannelGroupModification(java.lang.String android.os.UserHandle android.app.NotificationChannelGroup int ), 0, this, string2, userHandle, notificationChannelGroup, n);
        }

        public /* synthetic */ NotificationListenerWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationListenerWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChannelOrGroupModificationTypes {
    }
}

