/*
 * Decompiled with CFR 0.152.
 */
package android.service.wallpaper;

import android.app.Service;
import android.app.WallpaperColors;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.service.wallpaper.IWallpaperConnection;
import android.service.wallpaper.IWallpaperEngine;
import android.service.wallpaper.IWallpaperService;
import android.util.Log;
import android.util.MergedConfiguration;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.R;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.HandlerCaller;
import com.android.internal.view.BaseIWindow;
import com.android.internal.view.BaseSurfaceHolder;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class WallpaperService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String SERVICE_INTERFACE = "android.service.wallpaper.WallpaperService";
    public static String SERVICE_META_DATA = "android.service.wallpaper";
    static String TAG = "WallpaperService";
    static boolean DEBUG = false;
    private static int DO_ATTACH = 10;
    private static int DO_DETACH = 20;
    private static int DO_SET_DESIRED_SIZE = 30;
    private static int DO_SET_DISPLAY_PADDING = 40;
    private static int DO_IN_AMBIENT_MODE = 50;
    private static int MSG_UPDATE_SURFACE = 10000;
    private static int MSG_VISIBILITY_CHANGED = 10010;
    private static int MSG_WALLPAPER_OFFSETS = 10020;
    private static int MSG_WALLPAPER_COMMAND = 10025;
    private static int MSG_WINDOW_RESIZED = 10030;
    private static int MSG_WINDOW_MOVED = 10035;
    private static int MSG_TOUCH_EVENT = 10040;
    private static int MSG_REQUEST_WALLPAPER_COLORS = 10050;
    private static int NOTIFY_COLORS_RATE_LIMIT_MS = 1000;
    private ArrayList<Engine> mActiveEngines;

    private void $$robo$$android_service_wallpaper_WallpaperService$__constructor__() {
        this.mActiveEngines = new ArrayList();
    }

    private final void $$robo$$android_service_wallpaper_WallpaperService$onCreate() {
        super.onCreate();
    }

    private final void $$robo$$android_service_wallpaper_WallpaperService$onDestroy() {
        super.onDestroy();
        for (int i = 0; i < this.mActiveEngines.size(); ++i) {
            this.mActiveEngines.get(i).detach();
        }
        this.mActiveEngines.clear();
    }

    private final IBinder $$robo$$android_service_wallpaper_WallpaperService$onBind(Intent intent) {
        return new IWallpaperServiceWrapper(this, this);
    }

    public abstract Engine onCreateEngine();

    private final void $$robo$$android_service_wallpaper_WallpaperService$dump(FileDescriptor fd, PrintWriter out, String[] args) {
        out.print("State of wallpaper ");
        out.print(this);
        out.println(":");
        for (int i = 0; i < this.mActiveEngines.size(); ++i) {
            Engine engine = this.mActiveEngines.get(i);
            out.print("  Engine ");
            out.print(engine);
            out.println(":");
            engine.dump("    ", fd, out, args);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_service_wallpaper_WallpaperService$__constructor__();
    }

    public WallpaperService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService$__constructor__(), 0, this);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_service_wallpaper_WallpaperService$onCreate(), 0, this);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_service_wallpaper_WallpaperService$onDestroy(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_wallpaper_WallpaperService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_wallpaper_WallpaperService$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallpaperService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class IWallpaperServiceWrapper
    extends IWallpaperService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WallpaperService mTarget;
        /* synthetic */ WallpaperService this$0;

        private void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperServiceWrapper$__constructor__(WallpaperService this$0, WallpaperService context) {
            this.mTarget = context;
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperServiceWrapper$attach(IWallpaperConnection conn, IBinder windowToken, int windowType, boolean isPreview, int reqWidth, int reqHeight, Rect padding) {
            new IWallpaperEngineWrapper(this.this$0, this.mTarget, conn, windowToken, windowType, isPreview, reqWidth, reqHeight, padding);
        }

        private void __constructor__(WallpaperService wallpaperService, WallpaperService wallpaperService2) {
            this.$$robo$$android_service_wallpaper_WallpaperService_IWallpaperServiceWrapper$__constructor__(wallpaperService, wallpaperService2);
        }

        public IWallpaperServiceWrapper(WallpaperService wallpaperService, WallpaperService wallpaperService2) {
            this.this$0 = wallpaperService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperServiceWrapper$__constructor__(android.service.wallpaper.WallpaperService android.service.wallpaper.WallpaperService ), 0, this, wallpaperService, wallpaperService2);
        }

        @Override
        public void attach(IWallpaperConnection iWallpaperConnection, IBinder iBinder, int n, boolean bl, int n2, int n3, Rect rect) {
            InvokeDynamicSupport.bootstrap("attach", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperServiceWrapper$attach(android.service.wallpaper.IWallpaperConnection android.os.IBinder int boolean int int android.graphics.Rect ), 0, this, iWallpaperConnection, iBinder, n, bl, n2, n3, rect);
        }

        public /* synthetic */ IWallpaperServiceWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IWallpaperServiceWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class IWallpaperEngineWrapper
    extends IWallpaperEngine.Stub
    implements HandlerCaller.Callback,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private HandlerCaller mCaller;
        IWallpaperConnection mConnection;
        IBinder mWindowToken;
        int mWindowType;
        boolean mIsPreview;
        boolean mShownReported;
        int mReqWidth;
        int mReqHeight;
        Rect mDisplayPadding;
        Engine mEngine;
        /* synthetic */ WallpaperService this$0;

        private void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$__constructor__(WallpaperService this$0, WallpaperService context, IWallpaperConnection conn, IBinder windowToken, int windowType, boolean isPreview, int reqWidth, int reqHeight, Rect padding) {
            this.mDisplayPadding = new Rect();
            this.mCaller = new HandlerCaller(context, context.getMainLooper(), this, true);
            this.mConnection = conn;
            this.mWindowToken = windowToken;
            this.mWindowType = windowType;
            this.mIsPreview = isPreview;
            this.mReqWidth = reqWidth;
            this.mReqHeight = reqHeight;
            this.mDisplayPadding.set(padding);
            Message msg = this.mCaller.obtainMessage(10);
            this.mCaller.sendMessage(msg);
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$setDesiredSize(int width, int height) {
            Message msg = this.mCaller.obtainMessageII(30, width, height);
            this.mCaller.sendMessage(msg);
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$setDisplayPadding(Rect padding) {
            Message msg = this.mCaller.obtainMessageO(40, padding);
            this.mCaller.sendMessage(msg);
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$setVisibility(boolean visible) {
            Message msg = this.mCaller.obtainMessageI(10010, visible ? 1 : 0);
            this.mCaller.sendMessage(msg);
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$setInAmbientMode(boolean inAmbientDisplay, boolean animated) throws RemoteException {
            Message msg = this.mCaller.obtainMessageII(50, inAmbientDisplay ? 1 : 0, animated ? 1 : 0);
            this.mCaller.sendMessage(msg);
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$dispatchPointer(MotionEvent event) {
            if (this.mEngine != null) {
                this.mEngine.dispatchPointer(event);
            } else {
                event.recycle();
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras) {
            if (this.mEngine != null) {
                this.mEngine.mWindow.dispatchWallpaperCommand(action, x, y, z, extras, false);
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$reportShown() {
            if (!this.mShownReported) {
                this.mShownReported = true;
                try {
                    this.mConnection.engineShown(this);
                }
                catch (RemoteException e) {
                    Log.w("WallpaperService", "Wallpaper host disappeared", e);
                    return;
                }
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$requestWallpaperColors() {
            Message msg = this.mCaller.obtainMessage(10050);
            this.mCaller.sendMessage(msg);
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$destroy() {
            Message msg = this.mCaller.obtainMessage(20);
            this.mCaller.sendMessage(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$executeMessage(Message message) {
            switch (message.what) {
                case 10: {
                    Engine engine;
                    try {
                        this.mConnection.attachEngine(this);
                    }
                    catch (RemoteException e) {
                        Log.w("WallpaperService", "Wallpaper host disappeared", e);
                        return;
                    }
                    this.mEngine = engine = this.this$0.onCreateEngine();
                    this.this$0.mActiveEngines.add(engine);
                    engine.attach(this);
                    return;
                }
                case 20: {
                    this.this$0.mActiveEngines.remove(this.mEngine);
                    this.mEngine.detach();
                    return;
                }
                case 30: {
                    this.mEngine.doDesiredSizeChanged(message.arg1, message.arg2);
                    return;
                }
                case 40: {
                    this.mEngine.doDisplayPaddingChanged((Rect)message.obj);
                    return;
                }
                case 50: {
                    this.mEngine.doAmbientModeChanged(message.arg1 != 0, message.arg2 != 0);
                    return;
                }
                case 10000: {
                    this.mEngine.updateSurface(true, false, false);
                    break;
                }
                case 10010: {
                    this.mEngine.doVisibilityChanged(message.arg1 != 0);
                    break;
                }
                case 10020: {
                    this.mEngine.doOffsetsChanged(true);
                    break;
                }
                case 10025: {
                    WallpaperCommand cmd = (WallpaperCommand)message.obj;
                    this.mEngine.doCommand(cmd);
                    break;
                }
                case 10030: {
                    boolean reportDraw = message.arg1 != 0;
                    this.mEngine.mOutsets.set((Rect)message.obj);
                    this.mEngine.updateSurface(true, false, reportDraw);
                    this.mEngine.doOffsetsChanged(true);
                    break;
                }
                case 10035: {
                    break;
                }
                case 10040: {
                    boolean skip = false;
                    MotionEvent ev = (MotionEvent)message.obj;
                    if (ev.getAction() == 2) {
                        Object object = this.mEngine.mLock;
                        synchronized (object) {
                            if (this.mEngine.mPendingMove == ev) {
                                this.mEngine.mPendingMove = null;
                            } else {
                                skip = true;
                            }
                        }
                    }
                    if (!skip) {
                        this.mEngine.onTouchEvent(ev);
                    }
                    ev.recycle();
                    break;
                }
                case 10050: {
                    if (this.mConnection == null) break;
                    try {
                        this.mConnection.onWallpaperColorsChanged(this.mEngine.onComputeColors());
                    }
                    catch (RemoteException remoteException) {}
                    break;
                }
                default: {
                    Log.w("WallpaperService", "Unknown message type " + message.what);
                }
            }
        }

        private void __constructor__(WallpaperService wallpaperService, WallpaperService wallpaperService2, IWallpaperConnection iWallpaperConnection, IBinder iBinder, int n, boolean bl, int n2, int n3, Rect rect) {
            this.$$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$__constructor__(wallpaperService, wallpaperService2, iWallpaperConnection, iBinder, n, bl, n2, n3, rect);
        }

        IWallpaperEngineWrapper(WallpaperService wallpaperService, WallpaperService wallpaperService2, IWallpaperConnection iWallpaperConnection, IBinder iBinder, int n, boolean bl, int n2, int n3, Rect rect) {
            this.this$0 = wallpaperService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$__constructor__(android.service.wallpaper.WallpaperService android.service.wallpaper.WallpaperService android.service.wallpaper.IWallpaperConnection android.os.IBinder int boolean int int android.graphics.Rect ), 0, this, wallpaperService, wallpaperService2, iWallpaperConnection, iBinder, n, bl, n2, n3, rect);
        }

        @Override
        public void setDesiredSize(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setDesiredSize", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$setDesiredSize(int int ), 0, this, n, n2);
        }

        @Override
        public void setDisplayPadding(Rect rect) {
            InvokeDynamicSupport.bootstrap("setDisplayPadding", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$setDisplayPadding(android.graphics.Rect ), 0, this, rect);
        }

        @Override
        public void setVisibility(boolean bl) {
            InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$setVisibility(boolean ), 0, this, bl);
        }

        @Override
        public void setInAmbientMode(boolean bl, boolean bl2) throws RemoteException {
            InvokeDynamicSupport.bootstrap("setInAmbientMode", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$setInAmbientMode(boolean boolean ), 0, this, bl, bl2);
        }

        @Override
        public void dispatchPointer(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("dispatchPointer", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$dispatchPointer(android.view.MotionEvent ), 0, this, motionEvent);
        }

        @Override
        public void dispatchWallpaperCommand(String string2, int n, int n2, int n3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("dispatchWallpaperCommand", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$dispatchWallpaperCommand(java.lang.String int int int android.os.Bundle ), 0, this, string2, n, n2, n3, bundle);
        }

        public void reportShown() {
            InvokeDynamicSupport.bootstrap("reportShown", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$reportShown(), 0, this);
        }

        @Override
        public void requestWallpaperColors() {
            InvokeDynamicSupport.bootstrap("requestWallpaperColors", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$requestWallpaperColors(), 0, this);
        }

        @Override
        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$destroy(), 0, this);
        }

        @Override
        public void executeMessage(Message message) {
            InvokeDynamicSupport.bootstrap("executeMessage", $$robo$$android_service_wallpaper_WallpaperService_IWallpaperEngineWrapper$executeMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ IWallpaperEngineWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IWallpaperEngineWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class Engine
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        IWallpaperEngineWrapper mIWallpaperEngine;
        HandlerCaller mCaller;
        IWallpaperConnection mConnection;
        IBinder mWindowToken;
        boolean mInitializing;
        boolean mVisible;
        boolean mReportedVisible;
        boolean mDestroyed;
        boolean mCreated;
        boolean mSurfaceCreated;
        boolean mIsCreating;
        boolean mDrawingAllowed;
        boolean mOffsetsChanged;
        boolean mFixedSizeAllowed;
        int mWidth;
        int mHeight;
        int mFormat;
        int mType;
        int mCurWidth;
        int mCurHeight;
        int mWindowFlags;
        int mWindowPrivateFlags;
        int mCurWindowFlags;
        int mCurWindowPrivateFlags;
        Rect mVisibleInsets;
        Rect mWinFrame;
        Rect mOverscanInsets;
        Rect mContentInsets;
        Rect mStableInsets;
        Rect mOutsets;
        Rect mDispatchedOverscanInsets;
        Rect mDispatchedContentInsets;
        Rect mDispatchedStableInsets;
        Rect mDispatchedOutsets;
        Rect mFinalSystemInsets;
        Rect mFinalStableInsets;
        Rect mBackdropFrame;
        DisplayCutout.ParcelableWrapper mDisplayCutout;
        DisplayCutout mDispatchedDisplayCutout;
        MergedConfiguration mMergedConfiguration;
        WindowManager.LayoutParams mLayout;
        IWindowSession mSession;
        InputChannel mInputChannel;
        Object mLock;
        boolean mOffsetMessageEnqueued;
        float mPendingXOffset;
        float mPendingYOffset;
        float mPendingXOffsetStep;
        float mPendingYOffsetStep;
        boolean mPendingSync;
        MotionEvent mPendingMove;
        boolean mIsInAmbientMode;
        private long mLastColorInvalidation;
        private Runnable mNotifyColorsChanged;
        private Supplier<Long> mClockFunction;
        private Handler mHandler;
        DisplayManager mDisplayManager;
        Display mDisplay;
        private int mDisplayState;
        BaseSurfaceHolder mSurfaceHolder;
        WallpaperInputEventReceiver mInputEventReceiver;
        BaseIWindow mWindow;
        private DisplayManager.DisplayListener mDisplayListener;
        /* synthetic */ WallpaperService this$0;

        private void $$robo$$android_service_wallpaper_WallpaperService_Engine$__constructor__(WallpaperService this$0) {
        }

        @VisibleForTesting
        private void $$robo$$android_service_wallpaper_WallpaperService_Engine$__constructor__(WallpaperService this$0, Supplier<Long> clockFunction, Handler handler) {
            this.mInitializing = true;
            this.mWindowFlags = 16;
            this.mWindowPrivateFlags = 4;
            this.mCurWindowFlags = this.mWindowFlags;
            this.mCurWindowPrivateFlags = this.mWindowPrivateFlags;
            this.mVisibleInsets = new Rect();
            this.mWinFrame = new Rect();
            this.mOverscanInsets = new Rect();
            this.mContentInsets = new Rect();
            this.mStableInsets = new Rect();
            this.mOutsets = new Rect();
            this.mDispatchedOverscanInsets = new Rect();
            this.mDispatchedContentInsets = new Rect();
            this.mDispatchedStableInsets = new Rect();
            this.mDispatchedOutsets = new Rect();
            this.mFinalSystemInsets = new Rect();
            this.mFinalStableInsets = new Rect();
            this.mBackdropFrame = new Rect();
            this.mDisplayCutout = new DisplayCutout.ParcelableWrapper();
            this.mDispatchedDisplayCutout = DisplayCutout.NO_CUTOUT;
            this.mMergedConfiguration = new MergedConfiguration();
            this.mLayout = new WindowManager.LayoutParams();
            this.mLock = new Object();
            this.mNotifyColorsChanged = this::notifyColorsChanged;
            this.mSurfaceHolder = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Engine this$1;

                private void $$robo$$android_service_wallpaper_WallpaperService_Engine_1$__constructor__(Engine this$1) {
                    this.mRequestedFormat = 2;
                }

                private final boolean $$robo$$android_service_wallpaper_WallpaperService_Engine_1$onAllowLockCanvas() {
                    return this.this$1.mDrawingAllowed;
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_1$onRelayoutContainer() {
                    Message msg = this.this$1.mCaller.obtainMessage(10000);
                    this.this$1.mCaller.sendMessage(msg);
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_1$onUpdateSurface() {
                    Message msg = this.this$1.mCaller.obtainMessage(10000);
                    this.this$1.mCaller.sendMessage(msg);
                }

                private final boolean $$robo$$android_service_wallpaper_WallpaperService_Engine_1$isCreating() {
                    return this.this$1.mIsCreating;
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_1$setFixedSize(int width, int height) {
                    if (!this.this$1.mFixedSizeAllowed) {
                        throw new UnsupportedOperationException("Wallpapers currently only support sizing from layout");
                    }
                    super.setFixedSize(width, height);
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_1$setKeepScreenOn(boolean screenOn) {
                    throw new UnsupportedOperationException("Wallpapers do not support keep screen on");
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_1$prepareToDraw() {
                    if (this.this$1.mDisplayState == 3 || this.this$1.mDisplayState == 4) {
                        try {
                            this.this$1.mSession.pokeDrawLock(this.this$1.mWindow);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }

                private final Canvas $$robo$$android_service_wallpaper_WallpaperService_Engine_1$lockCanvas() {
                    this.prepareToDraw();
                    return super.lockCanvas();
                }

                private final Canvas $$robo$$android_service_wallpaper_WallpaperService_Engine_1$lockCanvas(Rect dirty) {
                    this.prepareToDraw();
                    return super.lockCanvas(dirty);
                }

                private final Canvas $$robo$$android_service_wallpaper_WallpaperService_Engine_1$lockHardwareCanvas() {
                    this.prepareToDraw();
                    return super.lockHardwareCanvas();
                }

                private void __constructor__(Engine engine) {
                    this.$$robo$$android_service_wallpaper_WallpaperService_Engine_1$__constructor__(engine);
                }
                {
                    this.this$1 = engine;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$__constructor__(android.service.wallpaper.WallpaperService$Engine ), 0, this, engine);
                }

                @Override
                public boolean onAllowLockCanvas() {
                    return (boolean)InvokeDynamicSupport.bootstrap("onAllowLockCanvas", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$onAllowLockCanvas(), 0, this);
                }

                @Override
                public void onRelayoutContainer() {
                    InvokeDynamicSupport.bootstrap("onRelayoutContainer", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$onRelayoutContainer(), 0, this);
                }

                @Override
                public void onUpdateSurface() {
                    InvokeDynamicSupport.bootstrap("onUpdateSurface", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$onUpdateSurface(), 0, this);
                }

                @Override
                public boolean isCreating() {
                    return (boolean)InvokeDynamicSupport.bootstrap("isCreating", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$isCreating(), 0, this);
                }

                @Override
                public void setFixedSize(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("setFixedSize", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$setFixedSize(int int ), 0, this, n, n2);
                }

                @Override
                public void setKeepScreenOn(boolean bl) {
                    InvokeDynamicSupport.bootstrap("setKeepScreenOn", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$setKeepScreenOn(boolean ), 0, this, bl);
                }

                private void prepareToDraw() {
                    InvokeDynamicSupport.bootstrap("prepareToDraw", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$prepareToDraw(), 0, this);
                }

                @Override
                public Canvas lockCanvas() {
                    return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$lockCanvas(), 0, this);
                }

                @Override
                public Canvas lockCanvas(Rect rect) {
                    return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$lockCanvas(android.graphics.Rect ), 0, this, rect);
                }

                @Override
                public Canvas lockHardwareCanvas() {
                    return InvokeDynamicSupport.bootstrap("lockHardwareCanvas", $$robo$$android_service_wallpaper_WallpaperService_Engine_1$lockHardwareCanvas(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mWindow = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Engine this$1;

                private void $$robo$$android_service_wallpaper_WallpaperService_Engine_2$__constructor__(Engine this$1) {
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_2$resized(Rect frame, Rect overscanInsets, Rect contentInsets, Rect visibleInsets, Rect stableInsets, Rect outsets, boolean reportDraw, MergedConfiguration mergedConfiguration, Rect backDropRect, boolean forceLayout, boolean alwaysConsumeNavBar, int displayId, DisplayCutout.ParcelableWrapper displayCutout) {
                    Message msg = this.this$1.mCaller.obtainMessageIO(10030, reportDraw ? 1 : 0, outsets);
                    this.this$1.mCaller.sendMessage(msg);
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_2$moved(int newX, int newY) {
                    Message msg = this.this$1.mCaller.obtainMessageII(10035, newX, newY);
                    this.this$1.mCaller.sendMessage(msg);
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_2$dispatchAppVisibility(boolean visible) {
                    if (!this.this$1.mIWallpaperEngine.mIsPreview) {
                        Message msg = this.this$1.mCaller.obtainMessageI(10010, visible ? 1 : 0);
                        this.this$1.mCaller.sendMessage(msg);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_2$dispatchWallpaperOffsets(float x, float y, float xStep, float yStep, boolean sync) {
                    Object object = this.this$1.mLock;
                    synchronized (object) {
                        this.this$1.mPendingXOffset = x;
                        this.this$1.mPendingYOffset = y;
                        this.this$1.mPendingXOffsetStep = xStep;
                        this.this$1.mPendingYOffsetStep = yStep;
                        if (sync) {
                            this.this$1.mPendingSync = true;
                        }
                        if (!this.this$1.mOffsetMessageEnqueued) {
                            this.this$1.mOffsetMessageEnqueued = true;
                            Message msg = this.this$1.mCaller.obtainMessage(10020);
                            this.this$1.mCaller.sendMessage(msg);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_2$dispatchWallpaperCommand(String action, int x, int y, int z, Bundle extras, boolean sync) {
                    Object object = this.this$1.mLock;
                    synchronized (object) {
                        WallpaperCommand cmd = new WallpaperCommand();
                        cmd.action = action;
                        cmd.x = x;
                        cmd.y = y;
                        cmd.z = z;
                        cmd.extras = extras;
                        cmd.sync = sync;
                        Message msg = this.this$1.mCaller.obtainMessage(10025);
                        msg.obj = cmd;
                        this.this$1.mCaller.sendMessage(msg);
                    }
                }

                private void __constructor__(Engine engine) {
                    this.$$robo$$android_service_wallpaper_WallpaperService_Engine_2$__constructor__(engine);
                }
                {
                    this.this$1 = engine;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_Engine_2$__constructor__(android.service.wallpaper.WallpaperService$Engine ), 0, this, engine);
                }

                @Override
                public void resized(Rect rect, Rect rect2, Rect rect3, Rect rect4, Rect rect5, Rect rect6, boolean bl, MergedConfiguration mergedConfiguration, Rect rect7, boolean bl2, boolean bl3, int n, DisplayCutout.ParcelableWrapper parcelableWrapper) {
                    InvokeDynamicSupport.bootstrap("resized", $$robo$$android_service_wallpaper_WallpaperService_Engine_2$resized(android.graphics.Rect android.graphics.Rect android.graphics.Rect android.graphics.Rect android.graphics.Rect android.graphics.Rect boolean android.util.MergedConfiguration android.graphics.Rect boolean boolean int android.view.DisplayCutout$ParcelableWrapper ), 0, this, rect, rect2, rect3, rect4, rect5, rect6, bl, mergedConfiguration, rect7, bl2, bl3, n, parcelableWrapper);
                }

                @Override
                public void moved(int n, int n2) {
                    InvokeDynamicSupport.bootstrap("moved", $$robo$$android_service_wallpaper_WallpaperService_Engine_2$moved(int int ), 0, this, n, n2);
                }

                @Override
                public void dispatchAppVisibility(boolean bl) {
                    InvokeDynamicSupport.bootstrap("dispatchAppVisibility", $$robo$$android_service_wallpaper_WallpaperService_Engine_2$dispatchAppVisibility(boolean ), 0, this, bl);
                }

                @Override
                public void dispatchWallpaperOffsets(float f, float f2, float f3, float f4, boolean bl) {
                    InvokeDynamicSupport.bootstrap("dispatchWallpaperOffsets", $$robo$$android_service_wallpaper_WallpaperService_Engine_2$dispatchWallpaperOffsets(float float float float boolean ), 0, this, f, f2, f3, f4, bl);
                }

                @Override
                public void dispatchWallpaperCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
                    InvokeDynamicSupport.bootstrap("dispatchWallpaperCommand", $$robo$$android_service_wallpaper_WallpaperService_Engine_2$dispatchWallpaperCommand(java.lang.String int int int android.os.Bundle boolean ), 0, this, string2, n, n2, n3, bundle, bl);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mDisplayListener = new DisplayManager.DisplayListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Engine this$1;

                private void $$robo$$android_service_wallpaper_WallpaperService_Engine_3$__constructor__(Engine this$1) {
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_3$onDisplayChanged(int displayId) {
                    if (this.this$1.mDisplay.getDisplayId() == displayId) {
                        this.this$1.reportVisibility();
                    }
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_3$onDisplayRemoved(int displayId) {
                }

                private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_3$onDisplayAdded(int displayId) {
                }

                private void __constructor__(Engine engine) {
                    this.$$robo$$android_service_wallpaper_WallpaperService_Engine_3$__constructor__(engine);
                }
                {
                    this.this$1 = engine;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_Engine_3$__constructor__(android.service.wallpaper.WallpaperService$Engine ), 0, this, engine);
                }

                @Override
                public void onDisplayChanged(int n) {
                    InvokeDynamicSupport.bootstrap("onDisplayChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine_3$onDisplayChanged(int ), 0, this, n);
                }

                @Override
                public void onDisplayRemoved(int n) {
                    InvokeDynamicSupport.bootstrap("onDisplayRemoved", $$robo$$android_service_wallpaper_WallpaperService_Engine_3$onDisplayRemoved(int ), 0, this, n);
                }

                @Override
                public void onDisplayAdded(int n) {
                    InvokeDynamicSupport.bootstrap("onDisplayAdded", $$robo$$android_service_wallpaper_WallpaperService_Engine_3$onDisplayAdded(int ), 0, this, n);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mClockFunction = clockFunction;
            this.mHandler = handler;
        }

        private final SurfaceHolder $$robo$$android_service_wallpaper_WallpaperService_Engine$getSurfaceHolder() {
            return this.mSurfaceHolder;
        }

        private final int $$robo$$android_service_wallpaper_WallpaperService_Engine$getDesiredMinimumWidth() {
            return this.mIWallpaperEngine.mReqWidth;
        }

        private final int $$robo$$android_service_wallpaper_WallpaperService_Engine$getDesiredMinimumHeight() {
            return this.mIWallpaperEngine.mReqHeight;
        }

        private final boolean $$robo$$android_service_wallpaper_WallpaperService_Engine$isVisible() {
            return this.mReportedVisible;
        }

        private final boolean $$robo$$android_service_wallpaper_WallpaperService_Engine$isPreview() {
            return this.mIWallpaperEngine.mIsPreview;
        }

        private final boolean $$robo$$android_service_wallpaper_WallpaperService_Engine$isInAmbientMode() {
            return this.mIsInAmbientMode;
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$setTouchEventsEnabled(boolean enabled) {
            int n = this.mWindowFlags = enabled ? this.mWindowFlags & 0xFFFFFFEF : this.mWindowFlags | 0x10;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$setOffsetNotificationsEnabled(boolean enabled) {
            int n = this.mWindowPrivateFlags = enabled ? this.mWindowPrivateFlags | 4 : this.mWindowPrivateFlags & 0xFFFFFFFB;
            if (this.mCreated) {
                this.updateSurface(false, false, false);
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$setFixedSizeAllowed(boolean allowed) {
            this.mFixedSizeAllowed = allowed;
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onCreate(SurfaceHolder surfaceHolder) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onDestroy() {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onVisibilityChanged(boolean visible) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onApplyWindowInsets(WindowInsets insets) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onTouchEvent(MotionEvent event) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
        }

        private final Bundle $$robo$$android_service_wallpaper_WallpaperService_Engine$onCommand(String action, int x, int y, int z, Bundle extras, boolean resultRequested) {
            return null;
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onAmbientModeChanged(boolean inAmbientMode, boolean animated) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onDesiredSizeChanged(int desiredWidth, int desiredHeight) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onSurfaceRedrawNeeded(SurfaceHolder holder) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onSurfaceCreated(SurfaceHolder holder) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$onSurfaceDestroyed(SurfaceHolder holder) {
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$notifyColorsChanged() {
            long now = this.mClockFunction.get();
            if (now - this.mLastColorInvalidation < 1000L) {
                Log.w("WallpaperService", "This call has been deferred. You should only call notifyColorsChanged() once every 1.0 seconds.");
                if (!this.mHandler.hasCallbacks(this.mNotifyColorsChanged)) {
                    this.mHandler.postDelayed(this.mNotifyColorsChanged, 1000L);
                }
                return;
            }
            this.mLastColorInvalidation = now;
            this.mHandler.removeCallbacks(this.mNotifyColorsChanged);
            try {
                WallpaperColors newColors = this.onComputeColors();
                if (this.mConnection != null) {
                    this.mConnection.onWallpaperColorsChanged(newColors);
                } else {
                    Log.w("WallpaperService", "Can't notify system because wallpaper connection was not established.");
                }
            }
            catch (RemoteException e) {
                Log.w("WallpaperService", "Can't notify system because wallpaper connection was lost.", e);
            }
        }

        private final WallpaperColors $$robo$$android_service_wallpaper_WallpaperService_Engine$onComputeColors() {
            return null;
        }

        @VisibleForTesting
        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$setCreated(boolean created) {
            this.mCreated = created;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$dump(String prefix, FileDescriptor fd, PrintWriter out, String[] args) {
            out.print(prefix);
            out.print("mInitializing=");
            out.print(this.mInitializing);
            out.print(" mDestroyed=");
            out.println(this.mDestroyed);
            out.print(prefix);
            out.print("mVisible=");
            out.print(this.mVisible);
            out.print(" mReportedVisible=");
            out.println(this.mReportedVisible);
            out.print(prefix);
            out.print("mDisplay=");
            out.println(this.mDisplay);
            out.print(prefix);
            out.print("mCreated=");
            out.print(this.mCreated);
            out.print(" mSurfaceCreated=");
            out.print(this.mSurfaceCreated);
            out.print(" mIsCreating=");
            out.print(this.mIsCreating);
            out.print(" mDrawingAllowed=");
            out.println(this.mDrawingAllowed);
            out.print(prefix);
            out.print("mWidth=");
            out.print(this.mWidth);
            out.print(" mCurWidth=");
            out.print(this.mCurWidth);
            out.print(" mHeight=");
            out.print(this.mHeight);
            out.print(" mCurHeight=");
            out.println(this.mCurHeight);
            out.print(prefix);
            out.print("mType=");
            out.print(this.mType);
            out.print(" mWindowFlags=");
            out.print(this.mWindowFlags);
            out.print(" mCurWindowFlags=");
            out.println(this.mCurWindowFlags);
            out.print(prefix);
            out.print("mWindowPrivateFlags=");
            out.print(this.mWindowPrivateFlags);
            out.print(" mCurWindowPrivateFlags=");
            out.println(this.mCurWindowPrivateFlags);
            out.print(prefix);
            out.print("mVisibleInsets=");
            out.print(this.mVisibleInsets.toShortString());
            out.print(" mWinFrame=");
            out.print(this.mWinFrame.toShortString());
            out.print(" mContentInsets=");
            out.println(this.mContentInsets.toShortString());
            out.print(prefix);
            out.print("mConfiguration=");
            out.println(this.mMergedConfiguration.getMergedConfiguration());
            out.print(prefix);
            out.print("mLayout=");
            out.println(this.mLayout);
            Object object = this.mLock;
            synchronized (object) {
                out.print(prefix);
                out.print("mPendingXOffset=");
                out.print(this.mPendingXOffset);
                out.print(" mPendingXOffset=");
                out.println(this.mPendingXOffset);
                out.print(prefix);
                out.print("mPendingXOffsetStep=");
                out.print(this.mPendingXOffsetStep);
                out.print(" mPendingXOffsetStep=");
                out.println(this.mPendingXOffsetStep);
                out.print(prefix);
                out.print("mOffsetMessageEnqueued=");
                out.print(this.mOffsetMessageEnqueued);
                out.print(" mPendingSync=");
                out.println(this.mPendingSync);
                if (this.mPendingMove != null) {
                    out.print(prefix);
                    out.print("mPendingMove=");
                    out.println(this.mPendingMove);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$dispatchPointer(MotionEvent event) {
            if (event.isTouchEvent()) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mPendingMove = event.getAction() == 2 ? event : null;
                }
                Message msg = this.mCaller.obtainMessageO(10040, event);
                this.mCaller.sendMessage(msg);
            } else {
                event.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$updateSurface(boolean forceRelayout, boolean forceReport, boolean redrawNeeded) {
            boolean flagsChanged;
            if (this.mDestroyed) {
                Log.w("WallpaperService", "Ignoring updateSurface: destroyed");
            }
            boolean fixedSize = false;
            int myWidth = this.mSurfaceHolder.getRequestedWidth();
            if (myWidth <= 0) {
                myWidth = -1;
            } else {
                fixedSize = true;
            }
            int myHeight = this.mSurfaceHolder.getRequestedHeight();
            if (myHeight <= 0) {
                myHeight = -1;
            } else {
                fixedSize = true;
            }
            boolean creating = !this.mCreated;
            boolean surfaceCreating = !this.mSurfaceCreated;
            boolean formatChanged = this.mFormat != this.mSurfaceHolder.getRequestedFormat();
            boolean sizeChanged = this.mWidth != myWidth || this.mHeight != myHeight;
            boolean insetsChanged = !this.mCreated;
            boolean typeChanged = this.mType != this.mSurfaceHolder.getRequestedType();
            boolean bl = flagsChanged = this.mCurWindowFlags != this.mWindowFlags || this.mCurWindowPrivateFlags != this.mWindowPrivateFlags;
            if (forceRelayout || creating || surfaceCreating || formatChanged || sizeChanged || typeChanged || flagsChanged || redrawNeeded || !this.mIWallpaperEngine.mShownReported) {
                try {
                    this.mWidth = myWidth;
                    this.mHeight = myHeight;
                    this.mFormat = this.mSurfaceHolder.getRequestedFormat();
                    this.mType = this.mSurfaceHolder.getRequestedType();
                    this.mLayout.x = 0;
                    this.mLayout.y = 0;
                    this.mLayout.width = myWidth;
                    this.mLayout.height = myHeight;
                    this.mLayout.format = this.mFormat;
                    this.mCurWindowFlags = this.mWindowFlags;
                    this.mLayout.flags = this.mWindowFlags | 0x200 | 0x10000 | 0x100 | 8;
                    this.mCurWindowPrivateFlags = this.mWindowPrivateFlags;
                    this.mLayout.privateFlags = this.mWindowPrivateFlags;
                    this.mLayout.memoryType = this.mType;
                    this.mLayout.token = this.mWindowToken;
                    if (!this.mCreated) {
                        TypedArray windowStyle = this.this$0.obtainStyledAttributes(R.styleable.Window);
                        windowStyle.recycle();
                        this.mLayout.type = this.mIWallpaperEngine.mWindowType;
                        this.mLayout.gravity = 0x800033;
                        this.mLayout.setTitle(this.this$0.getClass().getName());
                        this.mLayout.windowAnimations = 16974600;
                        this.mInputChannel = new InputChannel();
                        if (this.mSession.addToDisplay(this.mWindow, this.mWindow.mSeq, this.mLayout, 0, 0, this.mWinFrame, this.mContentInsets, this.mStableInsets, this.mOutsets, this.mDisplayCutout, this.mInputChannel) < 0) {
                            Log.w("WallpaperService", "Failed to add window while updating wallpaper surface.");
                            return;
                        }
                        this.mCreated = true;
                        this.mInputEventReceiver = new WallpaperInputEventReceiver(this, this.mInputChannel, Looper.myLooper());
                    }
                    this.mSurfaceHolder.mSurfaceLock.lock();
                    this.mDrawingAllowed = true;
                    if (!fixedSize) {
                        this.mLayout.surfaceInsets.set(this.mIWallpaperEngine.mDisplayPadding);
                        this.mLayout.surfaceInsets.left += this.mOutsets.left;
                        this.mLayout.surfaceInsets.top += this.mOutsets.top;
                        this.mLayout.surfaceInsets.right += this.mOutsets.right;
                        this.mLayout.surfaceInsets.bottom += this.mOutsets.bottom;
                    } else {
                        this.mLayout.surfaceInsets.set(0, 0, 0, 0);
                    }
                    int relayoutResult = this.mSession.relayout(this.mWindow, this.mWindow.mSeq, this.mLayout, this.mWidth, this.mHeight, 0, 0, -1L, this.mWinFrame, this.mOverscanInsets, this.mContentInsets, this.mVisibleInsets, this.mStableInsets, this.mOutsets, this.mBackdropFrame, this.mDisplayCutout, this.mMergedConfiguration, this.mSurfaceHolder.mSurface);
                    int w = this.mWinFrame.width();
                    int h = this.mWinFrame.height();
                    if (!fixedSize) {
                        Rect padding = this.mIWallpaperEngine.mDisplayPadding;
                        w += padding.left + padding.right + this.mOutsets.left + this.mOutsets.right;
                        h += padding.top + padding.bottom + this.mOutsets.top + this.mOutsets.bottom;
                        this.mOverscanInsets.left += padding.left;
                        this.mOverscanInsets.top += padding.top;
                        this.mOverscanInsets.right += padding.right;
                        this.mOverscanInsets.bottom += padding.bottom;
                        this.mContentInsets.left += padding.left;
                        this.mContentInsets.top += padding.top;
                        this.mContentInsets.right += padding.right;
                        this.mContentInsets.bottom += padding.bottom;
                        this.mStableInsets.left += padding.left;
                        this.mStableInsets.top += padding.top;
                        this.mStableInsets.right += padding.right;
                        this.mStableInsets.bottom += padding.bottom;
                        this.mDisplayCutout.set(this.mDisplayCutout.get().inset(-padding.left, -padding.top, -padding.right, -padding.bottom));
                    }
                    if (this.mCurWidth != w) {
                        sizeChanged = true;
                        this.mCurWidth = w;
                    }
                    if (this.mCurHeight != h) {
                        sizeChanged = true;
                        this.mCurHeight = h;
                    }
                    insetsChanged |= !this.mDispatchedOverscanInsets.equals(this.mOverscanInsets);
                    insetsChanged |= !this.mDispatchedContentInsets.equals(this.mContentInsets);
                    insetsChanged |= !this.mDispatchedStableInsets.equals(this.mStableInsets);
                    insetsChanged |= !this.mDispatchedOutsets.equals(this.mOutsets);
                    insetsChanged |= !this.mDispatchedDisplayCutout.equals(this.mDisplayCutout.get());
                    this.mSurfaceHolder.setSurfaceFrameSize(w, h);
                    this.mSurfaceHolder.mSurfaceLock.unlock();
                    if (!this.mSurfaceHolder.mSurface.isValid()) {
                        this.reportSurfaceDestroyed();
                        return;
                    }
                    boolean didSurface = false;
                    try {
                        SurfaceHolder.Callback[] callbacks;
                        this.mSurfaceHolder.ungetCallbacks();
                        if (surfaceCreating) {
                            this.mIsCreating = true;
                            didSurface = true;
                            this.onSurfaceCreated(this.mSurfaceHolder);
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    c.surfaceCreated(this.mSurfaceHolder);
                                }
                            }
                        }
                        redrawNeeded |= creating || (relayoutResult & 2) != 0;
                        if (forceReport || creating || surfaceCreating || formatChanged || sizeChanged) {
                            didSurface = true;
                            this.onSurfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    c.surfaceChanged(this.mSurfaceHolder, this.mFormat, this.mCurWidth, this.mCurHeight);
                                }
                            }
                        }
                        if (insetsChanged) {
                            this.mDispatchedOverscanInsets.set(this.mOverscanInsets);
                            this.mDispatchedOverscanInsets.left += this.mOutsets.left;
                            this.mDispatchedOverscanInsets.top += this.mOutsets.top;
                            this.mDispatchedOverscanInsets.right += this.mOutsets.right;
                            this.mDispatchedOverscanInsets.bottom += this.mOutsets.bottom;
                            this.mDispatchedContentInsets.set(this.mContentInsets);
                            this.mDispatchedStableInsets.set(this.mStableInsets);
                            this.mDispatchedOutsets.set(this.mOutsets);
                            this.mDispatchedDisplayCutout = this.mDisplayCutout.get();
                            this.mFinalSystemInsets.set(this.mDispatchedOverscanInsets);
                            this.mFinalStableInsets.set(this.mDispatchedStableInsets);
                            WindowInsets insets = new WindowInsets(this.mFinalSystemInsets, null, this.mFinalStableInsets, this.this$0.getResources().getConfiguration().isScreenRound(), false, this.mDispatchedDisplayCutout);
                            this.onApplyWindowInsets(insets);
                        }
                        if (redrawNeeded) {
                            this.onSurfaceRedrawNeeded(this.mSurfaceHolder);
                            callbacks = this.mSurfaceHolder.getCallbacks();
                            if (callbacks != null) {
                                for (SurfaceHolder.Callback c : callbacks) {
                                    if (!(c instanceof SurfaceHolder.Callback2)) continue;
                                    ((SurfaceHolder.Callback2)c).surfaceRedrawNeeded(this.mSurfaceHolder);
                                }
                            }
                        }
                        if (didSurface && !this.mReportedVisible) {
                            if (this.mIsCreating) {
                                this.onVisibilityChanged(true);
                            }
                            this.onVisibilityChanged(false);
                        }
                    }
                    finally {
                        this.mIsCreating = false;
                        this.mSurfaceCreated = true;
                        if (redrawNeeded) {
                            this.mSession.finishDrawing(this.mWindow);
                        }
                        this.mIWallpaperEngine.reportShown();
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$attach(IWallpaperEngineWrapper wrapper) {
            if (this.mDestroyed) {
                return;
            }
            this.mIWallpaperEngine = wrapper;
            this.mCaller = wrapper.mCaller;
            this.mConnection = wrapper.mConnection;
            this.mWindowToken = wrapper.mWindowToken;
            this.mSurfaceHolder.setSizeFromLayout();
            this.mInitializing = true;
            this.mSession = WindowManagerGlobal.getWindowSession();
            this.mWindow.setSession(this.mSession);
            this.mLayout.packageName = this.this$0.getPackageName();
            this.mDisplayManager = (DisplayManager)this.this$0.getSystemService("display");
            this.mDisplayManager.registerDisplayListener(this.mDisplayListener, this.mCaller.getHandler());
            this.mDisplay = this.mDisplayManager.getDisplay(0);
            this.mDisplayState = this.mDisplay.getState();
            this.onCreate(this.mSurfaceHolder);
            this.mInitializing = false;
            this.mReportedVisible = false;
            this.updateSurface(false, false, false);
        }

        @VisibleForTesting
        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$doAmbientModeChanged(boolean inAmbientMode, boolean animated) {
            if (!this.mDestroyed) {
                this.mIsInAmbientMode = inAmbientMode;
                if (this.mCreated) {
                    this.onAmbientModeChanged(inAmbientMode, animated);
                }
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$doDesiredSizeChanged(int desiredWidth, int desiredHeight) {
            if (!this.mDestroyed) {
                this.mIWallpaperEngine.mReqWidth = desiredWidth;
                this.mIWallpaperEngine.mReqHeight = desiredHeight;
                this.onDesiredSizeChanged(desiredWidth, desiredHeight);
                this.doOffsetsChanged(true);
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$doDisplayPaddingChanged(Rect padding) {
            if (!this.mDestroyed && !this.mIWallpaperEngine.mDisplayPadding.equals(padding)) {
                this.mIWallpaperEngine.mDisplayPadding.set(padding);
                this.updateSurface(true, false, false);
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$doVisibilityChanged(boolean visible) {
            if (!this.mDestroyed) {
                this.mVisible = visible;
                this.reportVisibility();
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$reportVisibility() {
            if (!this.mDestroyed) {
                boolean visible;
                this.mDisplayState = this.mDisplay == null ? 0 : this.mDisplay.getState();
                boolean bl = visible = this.mVisible && this.mDisplayState != 1;
                if (this.mReportedVisible != visible) {
                    this.mReportedVisible = visible;
                    if (visible) {
                        this.doOffsetsChanged(false);
                        this.updateSurface(false, false, false);
                    }
                    this.onVisibilityChanged(visible);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$doOffsetsChanged(boolean always) {
            boolean sync;
            float yOffsetStep;
            float xOffsetStep;
            float yOffset;
            float xOffset;
            if (this.mDestroyed) {
                return;
            }
            if (!always && !this.mOffsetsChanged) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                xOffset = this.mPendingXOffset;
                yOffset = this.mPendingYOffset;
                xOffsetStep = this.mPendingXOffsetStep;
                yOffsetStep = this.mPendingYOffsetStep;
                sync = this.mPendingSync;
                this.mPendingSync = false;
                this.mOffsetMessageEnqueued = false;
            }
            if (this.mSurfaceCreated) {
                if (this.mReportedVisible) {
                    int availw = this.mIWallpaperEngine.mReqWidth - this.mCurWidth;
                    int xPixels = availw > 0 ? -((int)((float)availw * xOffset + 0.5f)) : 0;
                    int availh = this.mIWallpaperEngine.mReqHeight - this.mCurHeight;
                    int yPixels = availh > 0 ? -((int)((float)availh * yOffset + 0.5f)) : 0;
                    this.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixels, yPixels);
                } else {
                    this.mOffsetsChanged = true;
                }
            }
            if (sync) {
                try {
                    this.mSession.wallpaperOffsetsComplete(this.mWindow.asBinder());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$doCommand(WallpaperCommand cmd) {
            Bundle result = !this.mDestroyed ? this.onCommand(cmd.action, cmd.x, cmd.y, cmd.z, cmd.extras, cmd.sync) : null;
            if (cmd.sync) {
                try {
                    this.mSession.wallpaperCommandComplete(this.mWindow.asBinder(), result);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$reportSurfaceDestroyed() {
            if (this.mSurfaceCreated) {
                this.mSurfaceCreated = false;
                this.mSurfaceHolder.ungetCallbacks();
                SurfaceHolder.Callback[] callbacks = this.mSurfaceHolder.getCallbacks();
                if (callbacks != null) {
                    for (SurfaceHolder.Callback c : callbacks) {
                        c.surfaceDestroyed(this.mSurfaceHolder);
                    }
                }
                this.onSurfaceDestroyed(this.mSurfaceHolder);
            }
        }

        private final void $$robo$$android_service_wallpaper_WallpaperService_Engine$detach() {
            if (this.mDestroyed) {
                return;
            }
            this.mDestroyed = true;
            if (this.mDisplayManager != null) {
                this.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
            }
            if (this.mVisible) {
                this.mVisible = false;
                this.onVisibilityChanged(false);
            }
            this.reportSurfaceDestroyed();
            this.onDestroy();
            if (this.mCreated) {
                try {
                    if (this.mInputEventReceiver != null) {
                        this.mInputEventReceiver.dispose();
                        this.mInputEventReceiver = null;
                    }
                    this.mSession.remove(this.mWindow);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mSurfaceHolder.mSurface.release();
                this.mCreated = false;
                if (this.mInputChannel != null) {
                    this.mInputChannel.dispose();
                    this.mInputChannel = null;
                }
            }
        }

        private void __constructor__(WallpaperService wallpaperService) {
            this.$$robo$$android_service_wallpaper_WallpaperService_Engine$__constructor__(wallpaperService);
        }

        public Engine(WallpaperService wallpaperService) {
            this(wallpaperService, SystemClock::elapsedRealtime, Handler.getMain());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_Engine$__constructor__(android.service.wallpaper.WallpaperService ), 0, this, wallpaperService);
        }

        private void __constructor__(WallpaperService wallpaperService, Supplier<Long> supplier, Handler handler) {
            this.$$robo$$android_service_wallpaper_WallpaperService_Engine$__constructor__(wallpaperService, supplier, handler);
        }

        public Engine(WallpaperService wallpaperService, Supplier<Long> supplier, Handler handler) {
            this.this$0 = wallpaperService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_Engine$__constructor__(android.service.wallpaper.WallpaperService java.util.function.Supplier<java.lang.Long> android.os.Handler ), 0, this, wallpaperService, supplier, handler);
        }

        public SurfaceHolder getSurfaceHolder() {
            return InvokeDynamicSupport.bootstrap("getSurfaceHolder", $$robo$$android_service_wallpaper_WallpaperService_Engine$getSurfaceHolder(), 0, this);
        }

        public int getDesiredMinimumWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getDesiredMinimumWidth", $$robo$$android_service_wallpaper_WallpaperService_Engine$getDesiredMinimumWidth(), 0, this);
        }

        public int getDesiredMinimumHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getDesiredMinimumHeight", $$robo$$android_service_wallpaper_WallpaperService_Engine$getDesiredMinimumHeight(), 0, this);
        }

        public boolean isVisible() {
            return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_service_wallpaper_WallpaperService_Engine$isVisible(), 0, this);
        }

        public boolean isPreview() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPreview", $$robo$$android_service_wallpaper_WallpaperService_Engine$isPreview(), 0, this);
        }

        public boolean isInAmbientMode() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInAmbientMode", $$robo$$android_service_wallpaper_WallpaperService_Engine$isInAmbientMode(), 0, this);
        }

        public void setTouchEventsEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setTouchEventsEnabled", $$robo$$android_service_wallpaper_WallpaperService_Engine$setTouchEventsEnabled(boolean ), 0, this, bl);
        }

        public void setOffsetNotificationsEnabled(boolean bl) {
            InvokeDynamicSupport.bootstrap("setOffsetNotificationsEnabled", $$robo$$android_service_wallpaper_WallpaperService_Engine$setOffsetNotificationsEnabled(boolean ), 0, this, bl);
        }

        public void setFixedSizeAllowed(boolean bl) {
            InvokeDynamicSupport.bootstrap("setFixedSizeAllowed", $$robo$$android_service_wallpaper_WallpaperService_Engine$setFixedSizeAllowed(boolean ), 0, this, bl);
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_service_wallpaper_WallpaperService_Engine$onCreate(android.view.SurfaceHolder ), 0, this, surfaceHolder);
        }

        public void onDestroy() {
            InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_service_wallpaper_WallpaperService_Engine$onDestroy(), 0, this);
        }

        public void onVisibilityChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$onVisibilityChanged(boolean ), 0, this, bl);
        }

        public void onApplyWindowInsets(WindowInsets windowInsets) {
            InvokeDynamicSupport.bootstrap("onApplyWindowInsets", $$robo$$android_service_wallpaper_WallpaperService_Engine$onApplyWindowInsets(android.view.WindowInsets ), 0, this, windowInsets);
        }

        public void onTouchEvent(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_service_wallpaper_WallpaperService_Engine$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
        }

        public void onOffsetsChanged(float f, float f2, float f3, float f4, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onOffsetsChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$onOffsetsChanged(float float float float int int ), 0, this, f, f2, f3, f4, n, n2);
        }

        public Bundle onCommand(String string2, int n, int n2, int n3, Bundle bundle, boolean bl) {
            return InvokeDynamicSupport.bootstrap("onCommand", $$robo$$android_service_wallpaper_WallpaperService_Engine$onCommand(java.lang.String int int int android.os.Bundle boolean ), 0, this, string2, n, n2, n3, bundle, bl);
        }

        public void onAmbientModeChanged(boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("onAmbientModeChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$onAmbientModeChanged(boolean boolean ), 0, this, bl, bl2);
        }

        public void onDesiredSizeChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onDesiredSizeChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$onDesiredSizeChanged(int int ), 0, this, n, n2);
        }

        public void onSurfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onSurfaceChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$onSurfaceChanged(android.view.SurfaceHolder int int int ), 0, this, surfaceHolder, n, n2, n3);
        }

        public void onSurfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
            InvokeDynamicSupport.bootstrap("onSurfaceRedrawNeeded", $$robo$$android_service_wallpaper_WallpaperService_Engine$onSurfaceRedrawNeeded(android.view.SurfaceHolder ), 0, this, surfaceHolder);
        }

        public void onSurfaceCreated(SurfaceHolder surfaceHolder) {
            InvokeDynamicSupport.bootstrap("onSurfaceCreated", $$robo$$android_service_wallpaper_WallpaperService_Engine$onSurfaceCreated(android.view.SurfaceHolder ), 0, this, surfaceHolder);
        }

        public void onSurfaceDestroyed(SurfaceHolder surfaceHolder) {
            InvokeDynamicSupport.bootstrap("onSurfaceDestroyed", $$robo$$android_service_wallpaper_WallpaperService_Engine$onSurfaceDestroyed(android.view.SurfaceHolder ), 0, this, surfaceHolder);
        }

        public void notifyColorsChanged() {
            InvokeDynamicSupport.bootstrap("notifyColorsChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$notifyColorsChanged(), 0, this);
        }

        public WallpaperColors onComputeColors() {
            return InvokeDynamicSupport.bootstrap("onComputeColors", $$robo$$android_service_wallpaper_WallpaperService_Engine$onComputeColors(), 0, this);
        }

        public void setCreated(boolean bl) {
            InvokeDynamicSupport.bootstrap("setCreated", $$robo$$android_service_wallpaper_WallpaperService_Engine$setCreated(boolean ), 0, this, bl);
        }

        protected void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_wallpaper_WallpaperService_Engine$dump(java.lang.String java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, string2, fileDescriptor, printWriter, stringArray);
        }

        private void dispatchPointer(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("dispatchPointer", $$robo$$android_service_wallpaper_WallpaperService_Engine$dispatchPointer(android.view.MotionEvent ), 0, this, motionEvent);
        }

        void updateSurface(boolean bl, boolean bl2, boolean bl3) {
            InvokeDynamicSupport.bootstrap("updateSurface", $$robo$$android_service_wallpaper_WallpaperService_Engine$updateSurface(boolean boolean boolean ), 0, this, bl, bl2, bl3);
        }

        void attach(IWallpaperEngineWrapper iWallpaperEngineWrapper) {
            InvokeDynamicSupport.bootstrap("attach", $$robo$$android_service_wallpaper_WallpaperService_Engine$attach(android.service.wallpaper.WallpaperService$IWallpaperEngineWrapper ), 0, this, iWallpaperEngineWrapper);
        }

        public void doAmbientModeChanged(boolean bl, boolean bl2) {
            InvokeDynamicSupport.bootstrap("doAmbientModeChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$doAmbientModeChanged(boolean boolean ), 0, this, bl, bl2);
        }

        void doDesiredSizeChanged(int n, int n2) {
            InvokeDynamicSupport.bootstrap("doDesiredSizeChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$doDesiredSizeChanged(int int ), 0, this, n, n2);
        }

        void doDisplayPaddingChanged(Rect rect) {
            InvokeDynamicSupport.bootstrap("doDisplayPaddingChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$doDisplayPaddingChanged(android.graphics.Rect ), 0, this, rect);
        }

        void doVisibilityChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("doVisibilityChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$doVisibilityChanged(boolean ), 0, this, bl);
        }

        void reportVisibility() {
            InvokeDynamicSupport.bootstrap("reportVisibility", $$robo$$android_service_wallpaper_WallpaperService_Engine$reportVisibility(), 0, this);
        }

        void doOffsetsChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("doOffsetsChanged", $$robo$$android_service_wallpaper_WallpaperService_Engine$doOffsetsChanged(boolean ), 0, this, bl);
        }

        void doCommand(WallpaperCommand wallpaperCommand) {
            InvokeDynamicSupport.bootstrap("doCommand", $$robo$$android_service_wallpaper_WallpaperService_Engine$doCommand(android.service.wallpaper.WallpaperService$WallpaperCommand ), 0, this, wallpaperCommand);
        }

        void reportSurfaceDestroyed() {
            InvokeDynamicSupport.bootstrap("reportSurfaceDestroyed", $$robo$$android_service_wallpaper_WallpaperService_Engine$reportSurfaceDestroyed(), 0, this);
        }

        void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$android_service_wallpaper_WallpaperService_Engine$detach(), 0, this);
        }

        public /* synthetic */ Engine() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Engine)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public final class WallpaperInputEventReceiver
        extends InputEventReceiver
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Engine this$1;

            private void $$robo$$android_service_wallpaper_WallpaperService_Engine_WallpaperInputEventReceiver$__constructor__(Engine this$1, InputChannel inputChannel, Looper looper) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_service_wallpaper_WallpaperService_Engine_WallpaperInputEventReceiver$onInputEvent(InputEvent event, int displayId) {
                boolean handled = false;
                try {
                    if (event instanceof MotionEvent && (event.getSource() & 2) != 0) {
                        MotionEvent dup = MotionEvent.obtainNoHistory((MotionEvent)event);
                        this.this$1.dispatchPointer(dup);
                        handled = true;
                    }
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }

            private void __constructor__(Engine engine, InputChannel inputChannel, Looper looper) {
                this.$$robo$$android_service_wallpaper_WallpaperService_Engine_WallpaperInputEventReceiver$__constructor__(engine, inputChannel, looper);
            }

            public WallpaperInputEventReceiver(Engine engine, InputChannel inputChannel, Looper looper) {
                this.this$1 = engine;
                super(inputChannel, looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_Engine_WallpaperInputEventReceiver$__constructor__(android.service.wallpaper.WallpaperService$Engine android.view.InputChannel android.os.Looper ), 0, this, engine, inputChannel, looper);
            }

            @Override
            public void onInputEvent(InputEvent inputEvent, int n) {
                InvokeDynamicSupport.bootstrap("onInputEvent", $$robo$$android_service_wallpaper_WallpaperService_Engine_WallpaperInputEventReceiver$onInputEvent(android.view.InputEvent int ), 0, this, inputEvent, n);
            }

            public /* synthetic */ WallpaperInputEventReceiver() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallpaperInputEventReceiver)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class WallpaperCommand
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String action;
        int x;
        int y;
        int z;
        Bundle extras;
        boolean sync;

        private void $$robo$$android_service_wallpaper_WallpaperService_WallpaperCommand$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_service_wallpaper_WallpaperService_WallpaperCommand$__constructor__();
        }

        WallpaperCommand() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_wallpaper_WallpaperService_WallpaperCommand$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WallpaperCommand)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

