/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.app.Service;
import android.content.Intent;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.AudioPlaybackQueueItem;
import android.speech.tts.EventLogger;
import android.speech.tts.FileSynthesisCallback;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.PlaybackSynthesisCallback;
import android.speech.tts.SilencePlaybackQueueItem;
import android.speech.tts.SynthesisCallback;
import android.speech.tts.SynthesisRequest;
import android.speech.tts.TextToSpeech;
import android.speech.tts.TtsEngines;
import android.speech.tts.Voice;
import android.text.TextUtils;
import android.util.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class TextToSpeechService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = false;
    private static String TAG = "TextToSpeechService";
    private static String SYNTH_THREAD_NAME = "SynthThread";
    private SynthHandler mSynthHandler;
    private AudioPlaybackHandler mAudioPlaybackHandler;
    private TtsEngines mEngineHelper;
    private CallbackMap mCallbacks;
    private String mPackageName;
    private Object mVoicesInfoLock;
    private ITextToSpeechService.Stub mBinder;

    private void $$robo$$android_speech_tts_TextToSpeechService$__constructor__() {
        this.mVoicesInfoLock = new Object();
        this.mBinder = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeechService this$0;

            private void $$robo$$android_speech_tts_TextToSpeechService_1$__constructor__(TextToSpeechService this$0) {
            }

            private final int $$robo$$android_speech_tts_TextToSpeechService_1$speak(IBinder caller, CharSequence text, int queueMode, Bundle params, String utteranceId) {
                if (!this.checkNonNull(caller, text, params)) {
                    return -1;
                }
                SynthesisSpeechItem item = new SynthesisSpeechItem(this.this$0, caller, Binder.getCallingUid(), Binder.getCallingPid(), params, utteranceId, text);
                return this.this$0.mSynthHandler.enqueueSpeechItem(queueMode, item);
            }

            private final int $$robo$$android_speech_tts_TextToSpeechService_1$synthesizeToFileDescriptor(IBinder caller, CharSequence text, ParcelFileDescriptor fileDescriptor, Bundle params, String utteranceId) {
                if (!this.checkNonNull(caller, text, fileDescriptor, params)) {
                    return -1;
                }
                ParcelFileDescriptor sameFileDescriptor = ParcelFileDescriptor.adoptFd(fileDescriptor.detachFd());
                SynthesisToFileOutputStreamSpeechItem item = new SynthesisToFileOutputStreamSpeechItem(this.this$0, caller, Binder.getCallingUid(), Binder.getCallingPid(), params, utteranceId, text, new ParcelFileDescriptor.AutoCloseOutputStream(sameFileDescriptor));
                return this.this$0.mSynthHandler.enqueueSpeechItem(1, item);
            }

            private final int $$robo$$android_speech_tts_TextToSpeechService_1$playAudio(IBinder caller, Uri audioUri, int queueMode, Bundle params, String utteranceId) {
                if (!this.checkNonNull(caller, audioUri, params)) {
                    return -1;
                }
                AudioSpeechItem item = new AudioSpeechItem(this.this$0, caller, Binder.getCallingUid(), Binder.getCallingPid(), params, utteranceId, audioUri);
                return this.this$0.mSynthHandler.enqueueSpeechItem(queueMode, item);
            }

            private final int $$robo$$android_speech_tts_TextToSpeechService_1$playSilence(IBinder caller, long duration, int queueMode, String utteranceId) {
                if (!this.checkNonNull(caller)) {
                    return -1;
                }
                SilenceSpeechItem item = new SilenceSpeechItem(this.this$0, caller, Binder.getCallingUid(), Binder.getCallingPid(), utteranceId, duration);
                return this.this$0.mSynthHandler.enqueueSpeechItem(queueMode, item);
            }

            private final boolean $$robo$$android_speech_tts_TextToSpeechService_1$isSpeaking() {
                return this.this$0.mSynthHandler.isSpeaking() || this.this$0.mAudioPlaybackHandler.isSpeaking();
            }

            private final int $$robo$$android_speech_tts_TextToSpeechService_1$stop(IBinder caller) {
                if (!this.checkNonNull(caller)) {
                    return -1;
                }
                return this.this$0.mSynthHandler.stopForApp(caller);
            }

            private final String[] $$robo$$android_speech_tts_TextToSpeechService_1$getLanguage() {
                return this.this$0.onGetLanguage();
            }

            private final String[] $$robo$$android_speech_tts_TextToSpeechService_1$getClientDefaultLanguage() {
                return this.this$0.getSettingsLocale();
            }

            private final int $$robo$$android_speech_tts_TextToSpeechService_1$isLanguageAvailable(String lang, String country, String variant) {
                if (!this.checkNonNull(lang)) {
                    return -1;
                }
                return this.this$0.onIsLanguageAvailable(lang, country, variant);
            }

            private final String[] $$robo$$android_speech_tts_TextToSpeechService_1$getFeaturesForLanguage(String lang, String country, String variant) {
                Set<String> features = this.this$0.onGetFeaturesForLanguage(lang, country, variant);
                String[] featuresArray = null;
                if (features != null) {
                    featuresArray = new String[features.size()];
                    features.toArray(featuresArray);
                } else {
                    featuresArray = new String[]{};
                }
                return featuresArray;
            }

            private final int $$robo$$android_speech_tts_TextToSpeechService_1$loadLanguage(IBinder caller, String lang, String country, String variant) {
                if (!this.checkNonNull(lang)) {
                    return -1;
                }
                int retVal = this.this$0.onIsLanguageAvailable(lang, country, variant);
                if (retVal == 0 || retVal == 1 || retVal == 2) {
                    LoadLanguageItem item = new LoadLanguageItem(this.this$0, caller, Binder.getCallingUid(), Binder.getCallingPid(), lang, country, variant);
                    if (this.this$0.mSynthHandler.enqueueSpeechItem(1, item) != 0) {
                        return -1;
                    }
                }
                return retVal;
            }

            private final List<Voice> $$robo$$android_speech_tts_TextToSpeechService_1$getVoices() {
                return this.this$0.onGetVoices();
            }

            private final int $$robo$$android_speech_tts_TextToSpeechService_1$loadVoice(IBinder caller, String voiceName) {
                if (!this.checkNonNull(voiceName)) {
                    return -1;
                }
                int retVal = this.this$0.onIsValidVoiceName(voiceName);
                if (retVal == 0) {
                    LoadVoiceItem item = new LoadVoiceItem(this.this$0, caller, Binder.getCallingUid(), Binder.getCallingPid(), voiceName);
                    if (this.this$0.mSynthHandler.enqueueSpeechItem(1, item) != 0) {
                        return -1;
                    }
                }
                return retVal;
            }

            private final String $$robo$$android_speech_tts_TextToSpeechService_1$getDefaultVoiceNameFor(String lang, String country, String variant) {
                if (!this.checkNonNull(lang)) {
                    return null;
                }
                int retVal = this.this$0.onIsLanguageAvailable(lang, country, variant);
                if (retVal == 0 || retVal == 1 || retVal == 2) {
                    return this.this$0.onGetDefaultVoiceNameFor(lang, country, variant);
                }
                return null;
            }

            private final void $$robo$$android_speech_tts_TextToSpeechService_1$setCallback(IBinder caller, ITextToSpeechCallback cb) {
                if (!this.checkNonNull(caller)) {
                    return;
                }
                this.this$0.mCallbacks.setCallback(caller, cb);
            }

            private final String $$robo$$android_speech_tts_TextToSpeechService_1$intern(String in) {
                return in.intern();
            }

            private final boolean $$robo$$android_speech_tts_TextToSpeechService_1$checkNonNull(Object ... args) {
                for (Object o : args) {
                    if (o != null) continue;
                    return false;
                }
                return true;
            }

            private void __constructor__(TextToSpeechService textToSpeechService) {
                this.$$robo$$android_speech_tts_TextToSpeechService_1$__constructor__(textToSpeechService);
            }
            {
                this.this$0 = textToSpeechService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_1$__constructor__(android.speech.tts.TextToSpeechService ), 0, this, textToSpeechService);
            }

            @Override
            public int speak(IBinder iBinder, CharSequence charSequence, int n, Bundle bundle, String string2) {
                return (int)InvokeDynamicSupport.bootstrap("speak", $$robo$$android_speech_tts_TextToSpeechService_1$speak(android.os.IBinder java.lang.CharSequence int android.os.Bundle java.lang.String ), 0, this, iBinder, charSequence, n, bundle, string2);
            }

            @Override
            public int synthesizeToFileDescriptor(IBinder iBinder, CharSequence charSequence, ParcelFileDescriptor parcelFileDescriptor, Bundle bundle, String string2) {
                return (int)InvokeDynamicSupport.bootstrap("synthesizeToFileDescriptor", $$robo$$android_speech_tts_TextToSpeechService_1$synthesizeToFileDescriptor(android.os.IBinder java.lang.CharSequence android.os.ParcelFileDescriptor android.os.Bundle java.lang.String ), 0, this, iBinder, charSequence, parcelFileDescriptor, bundle, string2);
            }

            @Override
            public int playAudio(IBinder iBinder, Uri uri, int n, Bundle bundle, String string2) {
                return (int)InvokeDynamicSupport.bootstrap("playAudio", $$robo$$android_speech_tts_TextToSpeechService_1$playAudio(android.os.IBinder android.net.Uri int android.os.Bundle java.lang.String ), 0, this, iBinder, uri, n, bundle, string2);
            }

            @Override
            public int playSilence(IBinder iBinder, long l, int n, String string2) {
                return (int)InvokeDynamicSupport.bootstrap("playSilence", $$robo$$android_speech_tts_TextToSpeechService_1$playSilence(android.os.IBinder long int java.lang.String ), 0, this, iBinder, l, n, string2);
            }

            @Override
            public boolean isSpeaking() {
                return (boolean)InvokeDynamicSupport.bootstrap("isSpeaking", $$robo$$android_speech_tts_TextToSpeechService_1$isSpeaking(), 0, this);
            }

            @Override
            public int stop(IBinder iBinder) {
                return (int)InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_TextToSpeechService_1$stop(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public String[] getLanguage() {
                return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_speech_tts_TextToSpeechService_1$getLanguage(), 0, this);
            }

            @Override
            public String[] getClientDefaultLanguage() {
                return InvokeDynamicSupport.bootstrap("getClientDefaultLanguage", $$robo$$android_speech_tts_TextToSpeechService_1$getClientDefaultLanguage(), 0, this);
            }

            @Override
            public int isLanguageAvailable(String string2, String string3, String string4) {
                return (int)InvokeDynamicSupport.bootstrap("isLanguageAvailable", $$robo$$android_speech_tts_TextToSpeechService_1$isLanguageAvailable(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
            }

            @Override
            public String[] getFeaturesForLanguage(String string2, String string3, String string4) {
                return InvokeDynamicSupport.bootstrap("getFeaturesForLanguage", $$robo$$android_speech_tts_TextToSpeechService_1$getFeaturesForLanguage(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
            }

            @Override
            public int loadLanguage(IBinder iBinder, String string2, String string3, String string4) {
                return (int)InvokeDynamicSupport.bootstrap("loadLanguage", $$robo$$android_speech_tts_TextToSpeechService_1$loadLanguage(android.os.IBinder java.lang.String java.lang.String java.lang.String ), 0, this, iBinder, string2, string3, string4);
            }

            @Override
            public List<Voice> getVoices() {
                return InvokeDynamicSupport.bootstrap("getVoices", $$robo$$android_speech_tts_TextToSpeechService_1$getVoices(), 0, this);
            }

            @Override
            public int loadVoice(IBinder iBinder, String string2) {
                return (int)InvokeDynamicSupport.bootstrap("loadVoice", $$robo$$android_speech_tts_TextToSpeechService_1$loadVoice(android.os.IBinder java.lang.String ), 0, this, iBinder, string2);
            }

            @Override
            public String getDefaultVoiceNameFor(String string2, String string3, String string4) {
                return InvokeDynamicSupport.bootstrap("getDefaultVoiceNameFor", $$robo$$android_speech_tts_TextToSpeechService_1$getDefaultVoiceNameFor(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
            }

            @Override
            public void setCallback(IBinder iBinder, ITextToSpeechCallback iTextToSpeechCallback) {
                InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_speech_tts_TextToSpeechService_1$setCallback(android.os.IBinder android.speech.tts.ITextToSpeechCallback ), 0, this, iBinder, iTextToSpeechCallback);
            }

            private String intern(String string2) {
                return InvokeDynamicSupport.bootstrap("intern", $$robo$$android_speech_tts_TextToSpeechService_1$intern(java.lang.String ), 0, this, string2);
            }

            private boolean checkNonNull(Object ... objectArray) {
                return (boolean)InvokeDynamicSupport.bootstrap("checkNonNull", $$robo$$android_speech_tts_TextToSpeechService_1$checkNonNull(java.lang.Object[] ), 0, this, objectArray);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_speech_tts_TextToSpeechService$onCreate() {
        super.onCreate();
        SynthThread synthThread = new SynthThread(this);
        synthThread.start();
        this.mSynthHandler = new SynthHandler(this, synthThread.getLooper());
        this.mAudioPlaybackHandler = new AudioPlaybackHandler();
        this.mAudioPlaybackHandler.start();
        this.mEngineHelper = new TtsEngines(this);
        this.mCallbacks = new CallbackMap(this);
        this.mPackageName = this.getApplicationInfo().packageName;
        String[] defaultLocale = this.getSettingsLocale();
        this.onLoadLanguage(defaultLocale[0], defaultLocale[1], defaultLocale[2]);
    }

    private final void $$robo$$android_speech_tts_TextToSpeechService$onDestroy() {
        this.mSynthHandler.quit();
        this.mAudioPlaybackHandler.quit();
        this.mCallbacks.kill();
        super.onDestroy();
    }

    protected abstract int onIsLanguageAvailable(String var1, String var2, String var3);

    protected abstract String[] onGetLanguage();

    protected abstract int onLoadLanguage(String var1, String var2, String var3);

    protected abstract void onStop();

    protected abstract void onSynthesizeText(SynthesisRequest var1, SynthesisCallback var2);

    private final Set<String> $$robo$$android_speech_tts_TextToSpeechService$onGetFeaturesForLanguage(String lang, String country, String variant) {
        return new HashSet<String>();
    }

    private final int $$robo$$android_speech_tts_TextToSpeechService$getExpectedLanguageAvailableStatus(Locale locale) {
        int expectedStatus = 2;
        if (locale.getVariant().isEmpty()) {
            expectedStatus = locale.getCountry().isEmpty() ? 0 : 1;
        }
        return expectedStatus;
    }

    private final List<Voice> $$robo$$android_speech_tts_TextToSpeechService$onGetVoices() {
        ArrayList<Voice> voices = new ArrayList<Voice>();
        for (Locale locale : Locale.getAvailableLocales()) {
            int expectedStatus = this.getExpectedLanguageAvailableStatus(locale);
            try {
                int localeStatus = this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
                if (localeStatus != expectedStatus) {
                }
            }
            catch (MissingResourceException e) {}
            continue;
            Set<String> features = this.onGetFeaturesForLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            String voiceName = this.onGetDefaultVoiceNameFor(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            voices.add(new Voice(voiceName, locale, 300, 300, false, features));
        }
        return voices;
    }

    private final String $$robo$$android_speech_tts_TextToSpeechService$onGetDefaultVoiceNameFor(String lang, String country, String variant) {
        int localeStatus = this.onIsLanguageAvailable(lang, country, variant);
        Locale iso3Locale = null;
        switch (localeStatus) {
            case 0: {
                iso3Locale = new Locale(lang);
                break;
            }
            case 1: {
                iso3Locale = new Locale(lang, country);
                break;
            }
            case 2: {
                iso3Locale = new Locale(lang, country, variant);
                break;
            }
            default: {
                return null;
            }
        }
        Locale properLocale = TtsEngines.normalizeTTSLocale(iso3Locale);
        String voiceName = properLocale.toLanguageTag();
        if (this.onIsValidVoiceName(voiceName) == 0) {
            return voiceName;
        }
        return null;
    }

    private final int $$robo$$android_speech_tts_TextToSpeechService$onLoadVoice(String voiceName) {
        Locale locale = Locale.forLanguageTag(voiceName);
        if (locale == null) {
            return -1;
        }
        int expectedStatus = this.getExpectedLanguageAvailableStatus(locale);
        try {
            int localeStatus = this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            if (localeStatus != expectedStatus) {
                return -1;
            }
            this.onLoadLanguage(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            return 0;
        }
        catch (MissingResourceException e) {
            return -1;
        }
    }

    private final int $$robo$$android_speech_tts_TextToSpeechService$onIsValidVoiceName(String voiceName) {
        Locale locale = Locale.forLanguageTag(voiceName);
        if (locale == null) {
            return -1;
        }
        int expectedStatus = this.getExpectedLanguageAvailableStatus(locale);
        try {
            int localeStatus = this.onIsLanguageAvailable(locale.getISO3Language(), locale.getISO3Country(), locale.getVariant());
            if (localeStatus != expectedStatus) {
                return -1;
            }
            return 0;
        }
        catch (MissingResourceException e) {
            return -1;
        }
    }

    private final int $$robo$$android_speech_tts_TextToSpeechService$getDefaultSpeechRate() {
        return this.getSecureSettingInt("tts_default_rate", 100);
    }

    private final int $$robo$$android_speech_tts_TextToSpeechService$getDefaultPitch() {
        return this.getSecureSettingInt("tts_default_pitch", 100);
    }

    private final String[] $$robo$$android_speech_tts_TextToSpeechService$getSettingsLocale() {
        Locale locale = this.mEngineHelper.getLocalePrefForEngine(this.mPackageName);
        return TtsEngines.toOldLocaleStringFormat(locale);
    }

    private final int $$robo$$android_speech_tts_TextToSpeechService$getSecureSettingInt(String name, int defaultValue) {
        return Settings.Secure.getInt(this.getContentResolver(), name, defaultValue);
    }

    private final IBinder $$robo$$android_speech_tts_TextToSpeechService$onBind(Intent intent) {
        if ("android.intent.action.TTS_SERVICE".equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    private void __constructor__() {
        this.$$robo$$android_speech_tts_TextToSpeechService$__constructor__();
    }

    public TextToSpeechService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService$__constructor__(), 0, this);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_speech_tts_TextToSpeechService$onCreate(), 0, this);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_speech_tts_TextToSpeechService$onDestroy(), 0, this);
    }

    protected Set<String> onGetFeaturesForLanguage(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrap("onGetFeaturesForLanguage", $$robo$$android_speech_tts_TextToSpeechService$onGetFeaturesForLanguage(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    private int getExpectedLanguageAvailableStatus(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrap("getExpectedLanguageAvailableStatus", $$robo$$android_speech_tts_TextToSpeechService$getExpectedLanguageAvailableStatus(java.util.Locale ), 0, this, locale);
    }

    public List<Voice> onGetVoices() {
        return InvokeDynamicSupport.bootstrap("onGetVoices", $$robo$$android_speech_tts_TextToSpeechService$onGetVoices(), 0, this);
    }

    public String onGetDefaultVoiceNameFor(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrap("onGetDefaultVoiceNameFor", $$robo$$android_speech_tts_TextToSpeechService$onGetDefaultVoiceNameFor(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public int onLoadVoice(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("onLoadVoice", $$robo$$android_speech_tts_TextToSpeechService$onLoadVoice(java.lang.String ), 0, this, string2);
    }

    public int onIsValidVoiceName(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("onIsValidVoiceName", $$robo$$android_speech_tts_TextToSpeechService$onIsValidVoiceName(java.lang.String ), 0, this, string2);
    }

    private int getDefaultSpeechRate() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultSpeechRate", $$robo$$android_speech_tts_TextToSpeechService$getDefaultSpeechRate(), 0, this);
    }

    private int getDefaultPitch() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultPitch", $$robo$$android_speech_tts_TextToSpeechService$getDefaultPitch(), 0, this);
    }

    private String[] getSettingsLocale() {
        return InvokeDynamicSupport.bootstrap("getSettingsLocale", $$robo$$android_speech_tts_TextToSpeechService$getSettingsLocale(), 0, this);
    }

    private int getSecureSettingInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSecureSettingInt", $$robo$$android_speech_tts_TextToSpeechService$getSecureSettingInt(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_speech_tts_TextToSpeechService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextToSpeechService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CallbackMap
    extends RemoteCallbackList<ITextToSpeechCallback> {
        public transient /* synthetic */ Object __robo_data__;
        private HashMap<IBinder, ITextToSpeechCallback> mCallerToCallback;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$__constructor__(TextToSpeechService textToSpeechService) {
            this.mCallerToCallback = new HashMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$setCallback(IBinder caller, ITextToSpeechCallback cb) {
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                ITextToSpeechCallback old;
                if (cb != null) {
                    this.register(cb, caller);
                    old = this.mCallerToCallback.put(caller, cb);
                } else {
                    old = this.mCallerToCallback.remove(caller);
                }
                if (old != null && old != cb) {
                    this.unregister(old);
                }
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnStop(Object callerIdentity, String utteranceId, boolean started) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onStop(utteranceId, started);
            }
            catch (RemoteException e) {
                Log.e("TextToSpeechService", "Callback onStop failed: " + e);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnSuccess(Object callerIdentity, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onSuccess(utteranceId);
            }
            catch (RemoteException e) {
                Log.e("TextToSpeechService", "Callback onDone failed: " + e);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnStart(Object callerIdentity, String utteranceId) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onStart(utteranceId);
            }
            catch (RemoteException e) {
                Log.e("TextToSpeechService", "Callback onStart failed: " + e);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnError(Object callerIdentity, String utteranceId, int errorCode) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onError(utteranceId, errorCode);
            }
            catch (RemoteException e) {
                Log.e("TextToSpeechService", "Callback onError failed: " + e);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnBeginSynthesis(Object callerIdentity, String utteranceId, int sampleRateInHz, int audioFormat, int channelCount) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onBeginSynthesis(utteranceId, sampleRateInHz, audioFormat, channelCount);
            }
            catch (RemoteException e) {
                Log.e("TextToSpeechService", "Callback dispatchOnBeginSynthesis(String, int, int, int) failed: " + e);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnAudioAvailable(Object callerIdentity, String utteranceId, byte[] buffer) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onAudioAvailable(utteranceId, buffer);
            }
            catch (RemoteException e) {
                Log.e("TextToSpeechService", "Callback dispatchOnAudioAvailable(String, byte[]) failed: " + e);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnRangeStart(Object callerIdentity, String utteranceId, int start, int end, int frame) {
            ITextToSpeechCallback cb = this.getCallbackFor(callerIdentity);
            if (cb == null) {
                return;
            }
            try {
                cb.onRangeStart(utteranceId, start, end, frame);
            }
            catch (RemoteException e) {
                Log.e("TextToSpeechService", "Callback dispatchOnRangeStart(String, int, int, int) failed: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$onCallbackDied(ITextToSpeechCallback callback, Object cookie) {
            IBinder caller = (IBinder)cookie;
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                this.mCallerToCallback.remove(caller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$kill() {
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                this.mCallerToCallback.clear();
                super.kill();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ITextToSpeechCallback $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$getCallbackFor(Object caller) {
            ITextToSpeechCallback cb;
            IBinder asBinder = (IBinder)caller;
            HashMap<IBinder, ITextToSpeechCallback> hashMap = this.mCallerToCallback;
            synchronized (hashMap) {
                cb = this.mCallerToCallback.get(asBinder);
            }
            return cb;
        }

        private /* synthetic */ void $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$__constructor__(TextToSpeechService x0, 1 x1) {
        }

        private void __constructor__(TextToSpeechService textToSpeechService) {
            this.$$robo$$android_speech_tts_TextToSpeechService_CallbackMap$__constructor__(textToSpeechService);
        }

        private CallbackMap(TextToSpeechService textToSpeechService) {
            this.this$0 = textToSpeechService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$__constructor__(android.speech.tts.TextToSpeechService ), 0, this, textToSpeechService);
        }

        public void setCallback(IBinder iBinder, ITextToSpeechCallback iTextToSpeechCallback) {
            InvokeDynamicSupport.bootstrap("setCallback", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$setCallback(android.os.IBinder android.speech.tts.ITextToSpeechCallback ), 0, this, iBinder, iTextToSpeechCallback);
        }

        public void dispatchOnStop(Object object, String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("dispatchOnStop", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnStop(java.lang.Object java.lang.String boolean ), 0, this, object, string2, bl);
        }

        public void dispatchOnSuccess(Object object, String string2) {
            InvokeDynamicSupport.bootstrap("dispatchOnSuccess", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnSuccess(java.lang.Object java.lang.String ), 0, this, object, string2);
        }

        public void dispatchOnStart(Object object, String string2) {
            InvokeDynamicSupport.bootstrap("dispatchOnStart", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnStart(java.lang.Object java.lang.String ), 0, this, object, string2);
        }

        public void dispatchOnError(Object object, String string2, int n) {
            InvokeDynamicSupport.bootstrap("dispatchOnError", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnError(java.lang.Object java.lang.String int ), 0, this, object, string2, n);
        }

        public void dispatchOnBeginSynthesis(Object object, String string2, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("dispatchOnBeginSynthesis", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnBeginSynthesis(java.lang.Object java.lang.String int int int ), 0, this, object, string2, n, n2, n3);
        }

        public void dispatchOnAudioAvailable(Object object, String string2, byte[] byArray) {
            InvokeDynamicSupport.bootstrap("dispatchOnAudioAvailable", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnAudioAvailable(java.lang.Object java.lang.String byte[] ), 0, this, object, string2, byArray);
        }

        public void dispatchOnRangeStart(Object object, String string2, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("dispatchOnRangeStart", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$dispatchOnRangeStart(java.lang.Object java.lang.String int int int ), 0, this, object, string2, n, n2, n3);
        }

        @Override
        public void onCallbackDied(ITextToSpeechCallback iTextToSpeechCallback, Object object) {
            InvokeDynamicSupport.bootstrap("onCallbackDied", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$onCallbackDied(android.speech.tts.ITextToSpeechCallback java.lang.Object ), 0, this, iTextToSpeechCallback, object);
        }

        @Override
        public void kill() {
            InvokeDynamicSupport.bootstrap("kill", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$kill(), 0, this);
        }

        private ITextToSpeechCallback getCallbackFor(Object object) {
            return InvokeDynamicSupport.bootstrap("getCallbackFor", $$robo$$android_speech_tts_TextToSpeechService_CallbackMap$getCallbackFor(java.lang.Object ), 0, this, object);
        }

        private /* synthetic */ void __constructor__(TextToSpeechService textToSpeechService, 1 var2_2) {
            this.$$robo$$android_speech_tts_TextToSpeechService_CallbackMap$__constructor__(textToSpeechService, var2_2);
        }

        public /* synthetic */ CallbackMap() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallbackMap)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class LoadVoiceItem
    extends SpeechItem
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mVoiceName;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$__constructor__(TextToSpeechService textToSpeechService, Object callerIdentity, int callerUid, int callerPid, String voiceName) {
            this.mVoiceName = voiceName;
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$isValid() {
            return true;
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$playImpl() {
            this.this$0.onLoadVoice(this.mVoiceName);
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$stopImpl() {
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2, String string2) {
            this.$$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$__constructor__(textToSpeechService, object, n, n2, string2);
        }

        public LoadVoiceItem(TextToSpeechService textToSpeechService, Object object, int n, int n2, String string2) {
            this.this$0 = textToSpeechService;
            super(textToSpeechService, object, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int java.lang.String ), 0, this, textToSpeechService, object, n, n2, string2);
        }

        @Override
        public boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$isValid(), 0, this);
        }

        @Override
        protected void playImpl() {
            InvokeDynamicSupport.bootstrap("playImpl", $$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$playImpl(), 0, this);
        }

        @Override
        protected void stopImpl() {
            InvokeDynamicSupport.bootstrap("stopImpl", $$robo$$android_speech_tts_TextToSpeechService_LoadVoiceItem$stopImpl(), 0, this);
        }

        public /* synthetic */ LoadVoiceItem() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadVoiceItem)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class LoadLanguageItem
    extends SpeechItem
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mLanguage;
        private String mCountry;
        private String mVariant;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$__constructor__(TextToSpeechService textToSpeechService, Object callerIdentity, int callerUid, int callerPid, String language, String country, String variant) {
            this.mLanguage = language;
            this.mCountry = country;
            this.mVariant = variant;
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$isValid() {
            return true;
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$playImpl() {
            this.this$0.onLoadLanguage(this.mLanguage, this.mCountry, this.mVariant);
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$stopImpl() {
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2, String string2, String string3, String string4) {
            this.$$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$__constructor__(textToSpeechService, object, n, n2, string2, string3, string4);
        }

        public LoadLanguageItem(TextToSpeechService textToSpeechService, Object object, int n, int n2, String string2, String string3, String string4) {
            this.this$0 = textToSpeechService;
            super(textToSpeechService, object, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int java.lang.String java.lang.String java.lang.String ), 0, this, textToSpeechService, object, n, n2, string2, string3, string4);
        }

        @Override
        public boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$isValid(), 0, this);
        }

        @Override
        protected void playImpl() {
            InvokeDynamicSupport.bootstrap("playImpl", $$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$playImpl(), 0, this);
        }

        @Override
        protected void stopImpl() {
            InvokeDynamicSupport.bootstrap("stopImpl", $$robo$$android_speech_tts_TextToSpeechService_LoadLanguageItem$stopImpl(), 0, this);
        }

        public /* synthetic */ LoadLanguageItem() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadLanguageItem)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SilenceSpeechItem
    extends UtteranceSpeechItem
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mDuration;
        private String mUtteranceId;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$__constructor__(TextToSpeechService textToSpeechService, Object callerIdentity, int callerUid, int callerPid, String utteranceId, long duration) {
            this.mUtteranceId = utteranceId;
            this.mDuration = duration;
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$isValid() {
            return true;
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$playImpl() {
            this.this$0.mAudioPlaybackHandler.enqueue(new SilencePlaybackQueueItem(this, this.getCallerIdentity(), this.mDuration));
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$stopImpl() {
        }

        private final String $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$getUtteranceId() {
            return this.mUtteranceId;
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2, String string2, long l) {
            this.$$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$__constructor__(textToSpeechService, object, n, n2, string2, l);
        }

        public SilenceSpeechItem(TextToSpeechService textToSpeechService, Object object, int n, int n2, String string2, long l) {
            this.this$0 = textToSpeechService;
            super(textToSpeechService, object, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int java.lang.String long ), 0, this, textToSpeechService, object, n, n2, string2, l);
        }

        @Override
        public boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$isValid(), 0, this);
        }

        @Override
        protected void playImpl() {
            InvokeDynamicSupport.bootstrap("playImpl", $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$playImpl(), 0, this);
        }

        @Override
        protected void stopImpl() {
            InvokeDynamicSupport.bootstrap("stopImpl", $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$stopImpl(), 0, this);
        }

        @Override
        public String getUtteranceId() {
            return InvokeDynamicSupport.bootstrap("getUtteranceId", $$robo$$android_speech_tts_TextToSpeechService_SilenceSpeechItem$getUtteranceId(), 0, this);
        }

        public /* synthetic */ SilenceSpeechItem() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SilenceSpeechItem)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class AudioSpeechItem
    extends UtteranceSpeechItemWithParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AudioPlaybackQueueItem mItem;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$__constructor__(TextToSpeechService textToSpeechService, Object callerIdentity, int callerUid, int callerPid, Bundle params, String utteranceId, Uri uri) {
            this.mItem = new AudioPlaybackQueueItem(this, this.getCallerIdentity(), textToSpeechService, uri, this.getAudioParams());
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$isValid() {
            return true;
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$playImpl() {
            this.this$0.mAudioPlaybackHandler.enqueue(this.mItem);
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$stopImpl() {
        }

        private final String $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$getUtteranceId() {
            return this.getStringParam(this.mParams, "utteranceId", null);
        }

        private final AudioOutputParams $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$getAudioParams() {
            return AudioOutputParams.createFromParamsBundle(this.mParams, false);
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2, Bundle bundle, String string2, Uri uri) {
            this.$$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$__constructor__(textToSpeechService, object, n, n2, bundle, string2, uri);
        }

        public AudioSpeechItem(TextToSpeechService textToSpeechService, Object object, int n, int n2, Bundle bundle, String string2, Uri uri) {
            this.this$0 = textToSpeechService;
            super(textToSpeechService, object, n, n2, bundle, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int android.os.Bundle java.lang.String android.net.Uri ), 0, this, textToSpeechService, object, n, n2, bundle, string2, uri);
        }

        @Override
        public boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$isValid(), 0, this);
        }

        @Override
        protected void playImpl() {
            InvokeDynamicSupport.bootstrap("playImpl", $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$playImpl(), 0, this);
        }

        @Override
        protected void stopImpl() {
            InvokeDynamicSupport.bootstrap("stopImpl", $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$stopImpl(), 0, this);
        }

        @Override
        public String getUtteranceId() {
            return InvokeDynamicSupport.bootstrap("getUtteranceId", $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$getUtteranceId(), 0, this);
        }

        @Override
        AudioOutputParams getAudioParams() {
            return InvokeDynamicSupport.bootstrap("getAudioParams", $$robo$$android_speech_tts_TextToSpeechService_AudioSpeechItem$getAudioParams(), 0, this);
        }

        public /* synthetic */ AudioSpeechItem() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioSpeechItem)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SynthesisToFileOutputStreamSpeechItem
    extends SynthesisSpeechItem
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private FileOutputStream mFileOutputStream;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_SynthesisToFileOutputStreamSpeechItem$__constructor__(TextToSpeechService textToSpeechService, Object callerIdentity, int callerUid, int callerPid, Bundle params, String utteranceId, CharSequence text, FileOutputStream fileOutputStream) {
            this.mFileOutputStream = fileOutputStream;
        }

        private final AbstractSynthesisCallback $$robo$$android_speech_tts_TextToSpeechService_SynthesisToFileOutputStreamSpeechItem$createSynthesisCallback() {
            return new FileSynthesisCallback(this.mFileOutputStream.getChannel(), this, false);
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthesisToFileOutputStreamSpeechItem$playImpl() {
            this.dispatchOnStart();
            super.playImpl();
            try {
                this.mFileOutputStream.close();
            }
            catch (IOException e) {
                Log.w("TextToSpeechService", "Failed to close output file", e);
            }
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2, Bundle bundle, String string2, CharSequence charSequence, FileOutputStream fileOutputStream) {
            this.$$robo$$android_speech_tts_TextToSpeechService_SynthesisToFileOutputStreamSpeechItem$__constructor__(textToSpeechService, object, n, n2, bundle, string2, charSequence, fileOutputStream);
        }

        public SynthesisToFileOutputStreamSpeechItem(TextToSpeechService textToSpeechService, Object object, int n, int n2, Bundle bundle, String string2, CharSequence charSequence, FileOutputStream fileOutputStream) {
            this.this$0 = textToSpeechService;
            super(textToSpeechService, object, n, n2, bundle, string2, charSequence);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SynthesisToFileOutputStreamSpeechItem$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int android.os.Bundle java.lang.String java.lang.CharSequence java.io.FileOutputStream ), 0, this, textToSpeechService, object, n, n2, bundle, string2, charSequence, fileOutputStream);
        }

        @Override
        protected AbstractSynthesisCallback createSynthesisCallback() {
            return InvokeDynamicSupport.bootstrap("createSynthesisCallback", $$robo$$android_speech_tts_TextToSpeechService_SynthesisToFileOutputStreamSpeechItem$createSynthesisCallback(), 0, this);
        }

        @Override
        protected void playImpl() {
            InvokeDynamicSupport.bootstrap("playImpl", $$robo$$android_speech_tts_TextToSpeechService_SynthesisToFileOutputStreamSpeechItem$playImpl(), 0, this);
        }

        public /* synthetic */ SynthesisToFileOutputStreamSpeechItem() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SynthesisToFileOutputStreamSpeechItem)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class SynthesisSpeechItem
    extends UtteranceSpeechItemWithParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mText;
        private SynthesisRequest mSynthesisRequest;
        private String[] mDefaultLocale;
        private AbstractSynthesisCallback mSynthesisCallback;
        private EventLogger mEventLogger;
        private int mCallerUid;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$__constructor__(TextToSpeechService this$0, Object callerIdentity, int callerUid, int callerPid, Bundle params, String utteranceId, CharSequence text) {
            this.mText = text;
            this.mCallerUid = callerUid;
            this.mSynthesisRequest = new SynthesisRequest(this.mText, this.mParams);
            this.mDefaultLocale = this$0.getSettingsLocale();
            this.setRequestParams(this.mSynthesisRequest);
            this.mEventLogger = new EventLogger(this.mSynthesisRequest, callerUid, callerPid, this$0.mPackageName);
        }

        private final CharSequence $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getText() {
            return this.mText;
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$isValid() {
            if (this.mText == null) {
                Log.e("TextToSpeechService", "null synthesis text");
                return false;
            }
            if (this.mText.length() >= TextToSpeech.getMaxSpeechInputLength()) {
                Log.w("TextToSpeechService", "Text too long: " + this.mText.length() + " chars");
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$playImpl() {
            AbstractSynthesisCallback synthesisCallback;
            this.mEventLogger.onRequestProcessingStart();
            SynthesisSpeechItem synthesisSpeechItem = this;
            synchronized (synthesisSpeechItem) {
                if (this.isStopped()) {
                    return;
                }
                synthesisCallback = this.mSynthesisCallback = this.createSynthesisCallback();
            }
            this.this$0.onSynthesizeText(this.mSynthesisRequest, synthesisCallback);
            if (synthesisCallback.hasStarted() && !synthesisCallback.hasFinished()) {
                synthesisCallback.done();
            }
        }

        private final AbstractSynthesisCallback $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$createSynthesisCallback() {
            return new PlaybackSynthesisCallback(this.getAudioParams(), this.this$0.mAudioPlaybackHandler, this, this.getCallerIdentity(), this.mEventLogger, false);
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$setRequestParams(SynthesisRequest request) {
            String voiceName = this.getVoiceName();
            request.setLanguage(this.getLanguage(), this.getCountry(), this.getVariant());
            if (!TextUtils.isEmpty(voiceName)) {
                request.setVoiceName(this.getVoiceName());
            }
            request.setSpeechRate(this.getSpeechRate());
            request.setCallerUid(this.mCallerUid);
            request.setPitch(this.getPitch());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$stopImpl() {
            AbstractSynthesisCallback synthesisCallback;
            SynthesisSpeechItem synthesisSpeechItem = this;
            synchronized (synthesisSpeechItem) {
                synthesisCallback = this.mSynthesisCallback;
            }
            if (synthesisCallback != null) {
                synthesisCallback.stop();
                this.this$0.onStop();
            } else {
                this.dispatchOnStop();
            }
        }

        private final String $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getCountry() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[1];
            }
            return this.getStringParam(this.mParams, "country", "");
        }

        private final String $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getVariant() {
            if (!this.hasLanguage()) {
                return this.mDefaultLocale[2];
            }
            return this.getStringParam(this.mParams, "variant", "");
        }

        private final String $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getLanguage() {
            return this.getStringParam(this.mParams, "language", this.mDefaultLocale[0]);
        }

        private final String $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getVoiceName() {
            return this.getStringParam(this.mParams, "voiceName", "");
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2, Bundle bundle, String string2, CharSequence charSequence) {
            this.$$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$__constructor__(textToSpeechService, object, n, n2, bundle, string2, charSequence);
        }

        public SynthesisSpeechItem(TextToSpeechService textToSpeechService, Object object, int n, int n2, Bundle bundle, String string2, CharSequence charSequence) {
            this.this$0 = textToSpeechService;
            super(textToSpeechService, object, n, n2, bundle, string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int android.os.Bundle java.lang.String java.lang.CharSequence ), 0, this, textToSpeechService, object, n, n2, bundle, string2, charSequence);
        }

        public CharSequence getText() {
            return InvokeDynamicSupport.bootstrap("getText", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getText(), 0, this);
        }

        @Override
        public boolean isValid() {
            return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$isValid(), 0, this);
        }

        @Override
        protected void playImpl() {
            InvokeDynamicSupport.bootstrap("playImpl", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$playImpl(), 0, this);
        }

        protected AbstractSynthesisCallback createSynthesisCallback() {
            return InvokeDynamicSupport.bootstrap("createSynthesisCallback", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$createSynthesisCallback(), 0, this);
        }

        private void setRequestParams(SynthesisRequest synthesisRequest) {
            InvokeDynamicSupport.bootstrap("setRequestParams", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$setRequestParams(android.speech.tts.SynthesisRequest ), 0, this, synthesisRequest);
        }

        @Override
        protected void stopImpl() {
            InvokeDynamicSupport.bootstrap("stopImpl", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$stopImpl(), 0, this);
        }

        private String getCountry() {
            return InvokeDynamicSupport.bootstrap("getCountry", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getCountry(), 0, this);
        }

        private String getVariant() {
            return InvokeDynamicSupport.bootstrap("getVariant", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getVariant(), 0, this);
        }

        public String getLanguage() {
            return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getLanguage(), 0, this);
        }

        public String getVoiceName() {
            return InvokeDynamicSupport.bootstrap("getVoiceName", $$robo$$android_speech_tts_TextToSpeechService_SynthesisSpeechItem$getVoiceName(), 0, this);
        }

        public /* synthetic */ SynthesisSpeechItem() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SynthesisSpeechItem)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private abstract class UtteranceSpeechItemWithParams
    extends UtteranceSpeechItem
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected Bundle mParams;
        protected String mUtteranceId;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$__constructor__(TextToSpeechService textToSpeechService, Object callerIdentity, int callerUid, int callerPid, Bundle params, String utteranceId) {
            this.mParams = params;
            this.mUtteranceId = utteranceId;
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$hasLanguage() {
            return !TextUtils.isEmpty(this.getStringParam(this.mParams, "language", null));
        }

        private final int $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$getSpeechRate() {
            return this.getIntParam(this.mParams, "rate", this.this$0.getDefaultSpeechRate());
        }

        private final int $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$getPitch() {
            return this.getIntParam(this.mParams, "pitch", this.this$0.getDefaultPitch());
        }

        private final String $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$getUtteranceId() {
            return this.mUtteranceId;
        }

        private final AudioOutputParams $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$getAudioParams() {
            return AudioOutputParams.createFromParamsBundle(this.mParams, true);
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2, Bundle bundle, String string2) {
            this.$$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$__constructor__(textToSpeechService, object, n, n2, bundle, string2);
        }

        UtteranceSpeechItemWithParams(TextToSpeechService textToSpeechService, Object object, int n, int n2, Bundle bundle, String string2) {
            this.this$0 = textToSpeechService;
            super(textToSpeechService, object, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int android.os.Bundle java.lang.String ), 0, this, textToSpeechService, object, n, n2, bundle, string2);
        }

        boolean hasLanguage() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasLanguage", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$hasLanguage(), 0, this);
        }

        int getSpeechRate() {
            return (int)InvokeDynamicSupport.bootstrap("getSpeechRate", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$getSpeechRate(), 0, this);
        }

        int getPitch() {
            return (int)InvokeDynamicSupport.bootstrap("getPitch", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$getPitch(), 0, this);
        }

        @Override
        public String getUtteranceId() {
            return InvokeDynamicSupport.bootstrap("getUtteranceId", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$getUtteranceId(), 0, this);
        }

        AudioOutputParams getAudioParams() {
            return InvokeDynamicSupport.bootstrap("getAudioParams", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItemWithParams$getAudioParams(), 0, this);
        }

        public /* synthetic */ UtteranceSpeechItemWithParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UtteranceSpeechItemWithParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private abstract class UtteranceSpeechItem
    extends SpeechItem
    implements UtteranceProgressDispatcher,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$__constructor__(TextToSpeechService textToSpeechService, Object caller, int callerUid, int callerPid) {
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnSuccess() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                this.this$0.mCallbacks.dispatchOnSuccess(this.getCallerIdentity(), utteranceId);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnStop() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                this.this$0.mCallbacks.dispatchOnStop(this.getCallerIdentity(), utteranceId, this.isStarted());
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnStart() {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                this.this$0.mCallbacks.dispatchOnStart(this.getCallerIdentity(), utteranceId);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnError(int errorCode) {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                this.this$0.mCallbacks.dispatchOnError(this.getCallerIdentity(), utteranceId, errorCode);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnBeginSynthesis(int sampleRateInHz, int audioFormat, int channelCount) {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                this.this$0.mCallbacks.dispatchOnBeginSynthesis(this.getCallerIdentity(), utteranceId, sampleRateInHz, audioFormat, channelCount);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnAudioAvailable(byte[] audio) {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                this.this$0.mCallbacks.dispatchOnAudioAvailable(this.getCallerIdentity(), utteranceId, audio);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnRangeStart(int start, int end, int frame) {
            String utteranceId = this.getUtteranceId();
            if (utteranceId != null) {
                this.this$0.mCallbacks.dispatchOnRangeStart(this.getCallerIdentity(), utteranceId, start, end, frame);
            }
        }

        public abstract String getUtteranceId();

        private final String $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$getStringParam(Bundle params, String key, String defaultValue) {
            return params == null ? defaultValue : params.getString(key, defaultValue);
        }

        private final int $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$getIntParam(Bundle params, String key, int defaultValue) {
            return params == null ? defaultValue : params.getInt(key, defaultValue);
        }

        private final float $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$getFloatParam(Bundle params, String key, float defaultValue) {
            return params == null ? defaultValue : params.getFloat(key, defaultValue);
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2) {
            this.$$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$__constructor__(textToSpeechService, object, n, n2);
        }

        public UtteranceSpeechItem(TextToSpeechService textToSpeechService, Object object, int n, int n2) {
            this.this$0 = textToSpeechService;
            super(textToSpeechService, object, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int ), 0, this, textToSpeechService, object, n, n2);
        }

        @Override
        public void dispatchOnSuccess() {
            InvokeDynamicSupport.bootstrap("dispatchOnSuccess", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnSuccess(), 0, this);
        }

        @Override
        public void dispatchOnStop() {
            InvokeDynamicSupport.bootstrap("dispatchOnStop", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnStop(), 0, this);
        }

        @Override
        public void dispatchOnStart() {
            InvokeDynamicSupport.bootstrap("dispatchOnStart", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnStart(), 0, this);
        }

        @Override
        public void dispatchOnError(int n) {
            InvokeDynamicSupport.bootstrap("dispatchOnError", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnError(int ), 0, this, n);
        }

        @Override
        public void dispatchOnBeginSynthesis(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("dispatchOnBeginSynthesis", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnBeginSynthesis(int int int ), 0, this, n, n2, n3);
        }

        @Override
        public void dispatchOnAudioAvailable(byte[] byArray) {
            InvokeDynamicSupport.bootstrap("dispatchOnAudioAvailable", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnAudioAvailable(byte[] ), 0, this, byArray);
        }

        @Override
        public void dispatchOnRangeStart(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("dispatchOnRangeStart", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$dispatchOnRangeStart(int int int ), 0, this, n, n2, n3);
        }

        String getStringParam(Bundle bundle, String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getStringParam", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$getStringParam(android.os.Bundle java.lang.String java.lang.String ), 0, this, bundle, string2, string3);
        }

        int getIntParam(Bundle bundle, String string2, int n) {
            return (int)InvokeDynamicSupport.bootstrap("getIntParam", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$getIntParam(android.os.Bundle java.lang.String int ), 0, this, bundle, string2, n);
        }

        float getFloatParam(Bundle bundle, String string2, float f) {
            return (float)InvokeDynamicSupport.bootstrap("getFloatParam", $$robo$$android_speech_tts_TextToSpeechService_UtteranceSpeechItem$getFloatParam(android.os.Bundle java.lang.String float ), 0, this, bundle, string2, f);
        }

        public /* synthetic */ UtteranceSpeechItem() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UtteranceSpeechItem)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private abstract class SpeechItem
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Object mCallerIdentity;
        private int mCallerUid;
        private int mCallerPid;
        private boolean mStarted;
        private boolean mStopped;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$__constructor__(TextToSpeechService textToSpeechService, Object caller, int callerUid, int callerPid) {
            this.mStarted = false;
            this.mStopped = false;
            this.mCallerIdentity = caller;
            this.mCallerUid = callerUid;
            this.mCallerPid = callerPid;
        }

        private final Object $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$getCallerIdentity() {
            return this.mCallerIdentity;
        }

        private final int $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$getCallerUid() {
            return this.mCallerUid;
        }

        private final int $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$getCallerPid() {
            return this.mCallerPid;
        }

        public abstract boolean isValid();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$play() {
            SpeechItem speechItem = this;
            synchronized (speechItem) {
                if (this.mStarted) {
                    throw new IllegalStateException("play() called twice");
                }
                this.mStarted = true;
            }
            this.playImpl();
        }

        protected abstract void playImpl();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$stop() {
            SpeechItem speechItem = this;
            synchronized (speechItem) {
                if (this.mStopped) {
                    throw new IllegalStateException("stop() called twice");
                }
                this.mStopped = true;
            }
            this.stopImpl();
        }

        protected abstract void stopImpl();

        private final synchronized boolean $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$isStopped() {
            return this.mStopped;
        }

        private final synchronized boolean $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$isStarted() {
            return this.mStarted;
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Object object, int n, int n2) {
            this.$$robo$$android_speech_tts_TextToSpeechService_SpeechItem$__constructor__(textToSpeechService, object, n, n2);
        }

        public SpeechItem(TextToSpeechService textToSpeechService, Object object, int n, int n2) {
            this.this$0 = textToSpeechService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$__constructor__(android.speech.tts.TextToSpeechService java.lang.Object int int ), 0, this, textToSpeechService, object, n, n2);
        }

        public Object getCallerIdentity() {
            return InvokeDynamicSupport.bootstrap("getCallerIdentity", $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$getCallerIdentity(), 0, this);
        }

        public int getCallerUid() {
            return (int)InvokeDynamicSupport.bootstrap("getCallerUid", $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$getCallerUid(), 0, this);
        }

        public int getCallerPid() {
            return (int)InvokeDynamicSupport.bootstrap("getCallerPid", $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$getCallerPid(), 0, this);
        }

        public void play() {
            InvokeDynamicSupport.bootstrap("play", $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$play(), 0, this);
        }

        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$stop(), 0, this);
        }

        protected synchronized boolean isStopped() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStopped", $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$isStopped(), 0, this);
        }

        protected synchronized boolean isStarted() {
            return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_speech_tts_TextToSpeechService_SpeechItem$isStarted(), 0, this);
        }

        public /* synthetic */ SpeechItem() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpeechItem)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AudioOutputParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int mSessionId;
        public float mVolume;
        public float mPan;
        public AudioAttributes mAudioAttributes;

        private void $$robo$$android_speech_tts_TextToSpeechService_AudioOutputParams$__constructor__() {
            this.mSessionId = 0;
            this.mVolume = 1.0f;
            this.mPan = 0.0f;
            this.mAudioAttributes = null;
        }

        private void $$robo$$android_speech_tts_TextToSpeechService_AudioOutputParams$__constructor__(int sessionId, float volume, float pan, AudioAttributes audioAttributes) {
            this.mSessionId = sessionId;
            this.mVolume = volume;
            this.mPan = pan;
            this.mAudioAttributes = audioAttributes;
        }

        private static final AudioOutputParams $$robo$$android_speech_tts_TextToSpeechService_AudioOutputParams$createFromParamsBundle(Bundle paramsBundle, boolean isSpeech) {
            if (paramsBundle == null) {
                return new AudioOutputParams();
            }
            AudioAttributes audioAttributes = (AudioAttributes)paramsBundle.getParcelable("audioAttributes");
            if (audioAttributes == null) {
                int streamType = paramsBundle.getInt("streamType", 3);
                audioAttributes = new AudioAttributes.Builder().setLegacyStreamType(streamType).setContentType(isSpeech ? 1 : 4).build();
            }
            return new AudioOutputParams(paramsBundle.getInt("sessionId", 0), paramsBundle.getFloat("volume", 1.0f), paramsBundle.getFloat("pan", 0.0f), audioAttributes);
        }

        private void __constructor__() {
            this.$$robo$$android_speech_tts_TextToSpeechService_AudioOutputParams$__constructor__();
        }

        AudioOutputParams() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_AudioOutputParams$__constructor__(), 0, this);
        }

        private void __constructor__(int n, float f, float f2, AudioAttributes audioAttributes) {
            this.$$robo$$android_speech_tts_TextToSpeechService_AudioOutputParams$__constructor__(n, f, f2, audioAttributes);
        }

        AudioOutputParams(int n, float f, float f2, AudioAttributes audioAttributes) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_AudioOutputParams$__constructor__(int float float android.media.AudioAttributes ), 0, this, n, f, f2, audioAttributes);
        }

        static AudioOutputParams createFromParamsBundle(Bundle bundle, boolean bl) {
            return InvokeDynamicSupport.bootstrapStatic("createFromParamsBundle", $$robo$$android_speech_tts_TextToSpeechService_AudioOutputParams$createFromParamsBundle(android.os.Bundle boolean ), 0, (Bundle)bundle, (boolean)bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioOutputParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface UtteranceProgressDispatcher
    extends InstrumentedInterface {
        public void dispatchOnStop();

        public void dispatchOnSuccess();

        public void dispatchOnStart();

        public void dispatchOnError(int var1);

        public void dispatchOnBeginSynthesis(int var1, int var2, int var3);

        public void dispatchOnAudioAvailable(byte[] var1);

        public void dispatchOnRangeStart(int var1, int var2, int var3);
    }

    private class SynthHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SpeechItem mCurrentSpeechItem;
        private List<Object> mFlushedObjects;
        private int mFlushAll;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$__constructor__(TextToSpeechService textToSpeechService, Looper looper) {
            this.mCurrentSpeechItem = null;
            this.mFlushedObjects = new ArrayList<Object>();
            this.mFlushAll = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$startFlushingSpeechItems(Object callerIdentity) {
            List<Object> list = this.mFlushedObjects;
            synchronized (list) {
                if (callerIdentity == null) {
                    ++this.mFlushAll;
                } else {
                    this.mFlushedObjects.add(callerIdentity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$endFlushingSpeechItems(Object callerIdentity) {
            List<Object> list = this.mFlushedObjects;
            synchronized (list) {
                if (callerIdentity == null) {
                    --this.mFlushAll;
                } else {
                    this.mFlushedObjects.remove(callerIdentity);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$isFlushed(SpeechItem speechItem) {
            List<Object> list = this.mFlushedObjects;
            synchronized (list) {
                return this.mFlushAll > 0 || this.mFlushedObjects.contains(speechItem.getCallerIdentity());
            }
        }

        private final synchronized SpeechItem $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$getCurrentSpeechItem() {
            return this.mCurrentSpeechItem;
        }

        private final synchronized boolean $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$setCurrentSpeechItem(SpeechItem speechItem) {
            if (speechItem != null && this.isFlushed(speechItem)) {
                return false;
            }
            this.mCurrentSpeechItem = speechItem;
            return true;
        }

        private final synchronized SpeechItem $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$removeCurrentSpeechItem() {
            SpeechItem current = this.mCurrentSpeechItem;
            this.mCurrentSpeechItem = null;
            return current;
        }

        private final synchronized SpeechItem $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$maybeRemoveCurrentSpeechItem(Object callerIdentity) {
            if (this.mCurrentSpeechItem != null && this.mCurrentSpeechItem.getCallerIdentity() == callerIdentity) {
                SpeechItem current = this.mCurrentSpeechItem;
                this.mCurrentSpeechItem = null;
                return current;
            }
            return null;
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$isSpeaking() {
            return this.getCurrentSpeechItem() != null;
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$quit() {
            this.getLooper().quit();
            SpeechItem current = this.removeCurrentSpeechItem();
            if (current != null) {
                current.stop();
            }
        }

        private final int $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$enqueueSpeechItem(int queueMode, SpeechItem speechItem) {
            UtteranceProgressDispatcher utterenceProgress = null;
            if (speechItem instanceof UtteranceProgressDispatcher) {
                utterenceProgress = (UtteranceProgressDispatcher)((Object)speechItem);
            }
            if (!speechItem.isValid()) {
                if (utterenceProgress != null) {
                    utterenceProgress.dispatchOnError(-8);
                }
                return -1;
            }
            if (queueMode == 0) {
                this.stopForApp(speechItem.getCallerIdentity());
            } else if (queueMode == 2) {
                this.stopAll();
            }
            Runnable runnable = new Runnable(this, speechItem){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SpeechItem val$speechItem;
                /* synthetic */ SynthHandler this$1;

                private void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_1$__constructor__(SynthHandler this$1, SpeechItem speechItem) {
                }

                private final void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_1$run() {
                    if (this.this$1.setCurrentSpeechItem(this.val$speechItem)) {
                        this.val$speechItem.play();
                        this.this$1.removeCurrentSpeechItem();
                    } else {
                        this.val$speechItem.stop();
                    }
                }

                private void __constructor__(SynthHandler synthHandler, SpeechItem speechItem) {
                    this.$$robo$$android_speech_tts_TextToSpeechService_SynthHandler_1$__constructor__(synthHandler, speechItem);
                }
                {
                    this.this$1 = synthHandler;
                    this.val$speechItem = speechItem;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_1$__constructor__(android.speech.tts.TextToSpeechService$SynthHandler android.speech.tts.TextToSpeechService$SpeechItem ), 0, this, synthHandler, speechItem);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            Message msg = Message.obtain((Handler)this, runnable);
            msg.obj = speechItem.getCallerIdentity();
            if (this.sendMessage(msg)) {
                return 0;
            }
            Log.w("TextToSpeechService", "SynthThread has quit");
            if (utterenceProgress != null) {
                utterenceProgress.dispatchOnError(-4);
            }
            return -1;
        }

        private final int $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$stopForApp(Object callerIdentity) {
            if (callerIdentity == null) {
                return -1;
            }
            this.startFlushingSpeechItems(callerIdentity);
            SpeechItem current = this.maybeRemoveCurrentSpeechItem(callerIdentity);
            if (current != null) {
                current.stop();
            }
            this.this$0.mAudioPlaybackHandler.stopForApp(callerIdentity);
            Runnable runnable = new Runnable(this, callerIdentity){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Object val$callerIdentity;
                /* synthetic */ SynthHandler this$1;

                private void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_2$__constructor__(SynthHandler this$1, Object object) {
                }

                private final void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_2$run() {
                    this.this$1.endFlushingSpeechItems(this.val$callerIdentity);
                }

                private void __constructor__(SynthHandler synthHandler, Object object) {
                    this.$$robo$$android_speech_tts_TextToSpeechService_SynthHandler_2$__constructor__(synthHandler, object);
                }
                {
                    this.this$1 = synthHandler;
                    this.val$callerIdentity = object;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_2$__constructor__(android.speech.tts.TextToSpeechService$SynthHandler java.lang.Object ), 0, this, synthHandler, object);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.sendMessage(Message.obtain((Handler)this, runnable));
            return 0;
        }

        private final int $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$stopAll() {
            this.startFlushingSpeechItems(null);
            SpeechItem current = this.removeCurrentSpeechItem();
            if (current != null) {
                current.stop();
            }
            this.this$0.mAudioPlaybackHandler.stop();
            Runnable runnable = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ SynthHandler this$1;

                private void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_3$__constructor__(SynthHandler this$1) {
                }

                private final void $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_3$run() {
                    this.this$1.endFlushingSpeechItems(null);
                }

                private void __constructor__(SynthHandler synthHandler) {
                    this.$$robo$$android_speech_tts_TextToSpeechService_SynthHandler_3$__constructor__(synthHandler);
                }
                {
                    this.this$1 = synthHandler;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_3$__constructor__(android.speech.tts.TextToSpeechService$SynthHandler ), 0, this, synthHandler);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.sendMessage(Message.obtain((Handler)this, runnable));
            return 0;
        }

        private void __constructor__(TextToSpeechService textToSpeechService, Looper looper) {
            this.$$robo$$android_speech_tts_TextToSpeechService_SynthHandler$__constructor__(textToSpeechService, looper);
        }

        public SynthHandler(TextToSpeechService textToSpeechService, Looper looper) {
            this.this$0 = textToSpeechService;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$__constructor__(android.speech.tts.TextToSpeechService android.os.Looper ), 0, this, textToSpeechService, looper);
        }

        private void startFlushingSpeechItems(Object object) {
            InvokeDynamicSupport.bootstrap("startFlushingSpeechItems", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$startFlushingSpeechItems(java.lang.Object ), 0, this, object);
        }

        private void endFlushingSpeechItems(Object object) {
            InvokeDynamicSupport.bootstrap("endFlushingSpeechItems", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$endFlushingSpeechItems(java.lang.Object ), 0, this, object);
        }

        private boolean isFlushed(SpeechItem speechItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFlushed", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$isFlushed(android.speech.tts.TextToSpeechService$SpeechItem ), 0, this, speechItem);
        }

        private synchronized SpeechItem getCurrentSpeechItem() {
            return InvokeDynamicSupport.bootstrap("getCurrentSpeechItem", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$getCurrentSpeechItem(), 0, this);
        }

        private synchronized boolean setCurrentSpeechItem(SpeechItem speechItem) {
            return (boolean)InvokeDynamicSupport.bootstrap("setCurrentSpeechItem", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$setCurrentSpeechItem(android.speech.tts.TextToSpeechService$SpeechItem ), 0, this, speechItem);
        }

        private synchronized SpeechItem removeCurrentSpeechItem() {
            return InvokeDynamicSupport.bootstrap("removeCurrentSpeechItem", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$removeCurrentSpeechItem(), 0, this);
        }

        private synchronized SpeechItem maybeRemoveCurrentSpeechItem(Object object) {
            return InvokeDynamicSupport.bootstrap("maybeRemoveCurrentSpeechItem", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$maybeRemoveCurrentSpeechItem(java.lang.Object ), 0, this, object);
        }

        public boolean isSpeaking() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSpeaking", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$isSpeaking(), 0, this);
        }

        public void quit() {
            InvokeDynamicSupport.bootstrap("quit", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$quit(), 0, this);
        }

        public int enqueueSpeechItem(int n, SpeechItem speechItem) {
            return (int)InvokeDynamicSupport.bootstrap("enqueueSpeechItem", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$enqueueSpeechItem(int android.speech.tts.TextToSpeechService$SpeechItem ), 0, this, n, speechItem);
        }

        public int stopForApp(Object object) {
            return (int)InvokeDynamicSupport.bootstrap("stopForApp", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$stopForApp(java.lang.Object ), 0, this, object);
        }

        public int stopAll() {
            return (int)InvokeDynamicSupport.bootstrap("stopAll", $$robo$$android_speech_tts_TextToSpeechService_SynthHandler$stopAll(), 0, this);
        }

        public /* synthetic */ SynthHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SynthHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SynthThread
    extends HandlerThread
    implements MessageQueue.IdleHandler,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mFirstIdle;
        /* synthetic */ TextToSpeechService this$0;

        private void $$robo$$android_speech_tts_TextToSpeechService_SynthThread$__constructor__(TextToSpeechService textToSpeechService) {
            this.mFirstIdle = true;
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthThread$onLooperPrepared() {
            this.getLooper().getQueue().addIdleHandler(this);
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeechService_SynthThread$queueIdle() {
            if (this.mFirstIdle) {
                this.mFirstIdle = false;
            } else {
                this.broadcastTtsQueueProcessingCompleted();
            }
            return true;
        }

        private final void $$robo$$android_speech_tts_TextToSpeechService_SynthThread$broadcastTtsQueueProcessingCompleted() {
            Intent i = new Intent("android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED");
            this.this$0.sendBroadcast(i);
        }

        private void __constructor__(TextToSpeechService textToSpeechService) {
            this.$$robo$$android_speech_tts_TextToSpeechService_SynthThread$__constructor__(textToSpeechService);
        }

        public SynthThread(TextToSpeechService textToSpeechService) {
            this.this$0 = textToSpeechService;
            super("SynthThread", 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeechService_SynthThread$__constructor__(android.speech.tts.TextToSpeechService ), 0, this, textToSpeechService);
        }

        @Override
        protected void onLooperPrepared() {
            InvokeDynamicSupport.bootstrap("onLooperPrepared", $$robo$$android_speech_tts_TextToSpeechService_SynthThread$onLooperPrepared(), 0, this);
        }

        @Override
        public boolean queueIdle() {
            return (boolean)InvokeDynamicSupport.bootstrap("queueIdle", $$robo$$android_speech_tts_TextToSpeechService_SynthThread$queueIdle(), 0, this);
        }

        private void broadcastTtsQueueProcessingCompleted() {
            InvokeDynamicSupport.bootstrap("broadcastTtsQueueProcessingCompleted", $$robo$$android_speech_tts_TextToSpeechService_SynthThread$broadcastTtsQueueProcessingCompleted(), 0, this);
        }

        public /* synthetic */ SynthThread() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SynthThread)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

