/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.AudioState;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CallAudioState
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ROUTE_EARPIECE = 1;
    public static int ROUTE_BLUETOOTH = 2;
    public static int ROUTE_WIRED_HEADSET = 4;
    public static int ROUTE_SPEAKER = 8;
    public static int ROUTE_WIRED_OR_EARPIECE = 5;
    public static int ROUTE_ALL = 15;
    private boolean isMuted;
    private int route;
    private int supportedRouteMask;
    private BluetoothDevice activeBluetoothDevice;
    private Collection<BluetoothDevice> supportedBluetoothDevices;
    public static Parcelable.Creator<CallAudioState> CREATOR;

    private void $$robo$$android_telecom_CallAudioState$__constructor__(boolean muted, int route, int supportedRouteMask) {
    }

    private void $$robo$$android_telecom_CallAudioState$__constructor__(boolean isMuted, int route, int supportedRouteMask, BluetoothDevice activeBluetoothDevice, Collection<BluetoothDevice> supportedBluetoothDevices) {
        this.isMuted = isMuted;
        this.route = route;
        this.supportedRouteMask = supportedRouteMask;
        this.activeBluetoothDevice = activeBluetoothDevice;
        this.supportedBluetoothDevices = supportedBluetoothDevices;
    }

    private void $$robo$$android_telecom_CallAudioState$__constructor__(CallAudioState state) {
        this.isMuted = state.isMuted();
        this.route = state.getRoute();
        this.supportedRouteMask = state.getSupportedRouteMask();
        this.activeBluetoothDevice = state.activeBluetoothDevice;
        this.supportedBluetoothDevices = state.getSupportedBluetoothDevices();
    }

    private void $$robo$$android_telecom_CallAudioState$__constructor__(AudioState state) {
        this.isMuted = state.isMuted();
        this.route = state.getRoute();
        this.supportedRouteMask = state.getSupportedRouteMask();
        this.activeBluetoothDevice = null;
        this.supportedBluetoothDevices = Collections.emptyList();
    }

    private final boolean $$robo$$android_telecom_CallAudioState$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAudioState)) {
            return false;
        }
        CallAudioState state = (CallAudioState)obj;
        if (this.supportedBluetoothDevices.size() != state.supportedBluetoothDevices.size()) {
            return false;
        }
        for (BluetoothDevice device : this.supportedBluetoothDevices) {
            if (state.supportedBluetoothDevices.contains(device)) continue;
            return false;
        }
        return Objects.equals(this.activeBluetoothDevice, state.activeBluetoothDevice) && this.isMuted() == state.isMuted() && this.getRoute() == state.getRoute() && this.getSupportedRouteMask() == state.getSupportedRouteMask();
    }

    private final String $$robo$$android_telecom_CallAudioState$toString() {
        String bluetoothDeviceList = this.supportedBluetoothDevices.stream().map(BluetoothDevice::getAddress).collect(Collectors.joining(", "));
        return String.format(Locale.US, "[AudioState isMuted: %b, route: %s, supportedRouteMask: %s, activeBluetoothDevice: [%s], supportedBluetoothDevices: [%s]]", this.isMuted, CallAudioState.audioRouteToString(this.route), CallAudioState.audioRouteToString(this.supportedRouteMask), this.activeBluetoothDevice, bluetoothDeviceList);
    }

    private final boolean $$robo$$android_telecom_CallAudioState$isMuted() {
        return this.isMuted;
    }

    private final int $$robo$$android_telecom_CallAudioState$getRoute() {
        return this.route;
    }

    private final int $$robo$$android_telecom_CallAudioState$getSupportedRouteMask() {
        return this.supportedRouteMask;
    }

    private final BluetoothDevice $$robo$$android_telecom_CallAudioState$getActiveBluetoothDevice() {
        return this.activeBluetoothDevice;
    }

    private final Collection<BluetoothDevice> $$robo$$android_telecom_CallAudioState$getSupportedBluetoothDevices() {
        return this.supportedBluetoothDevices;
    }

    private static final String $$robo$$android_telecom_CallAudioState$audioRouteToString(int route) {
        if (route == 0 || (route & 0xFFFFFFF0) != 0) {
            return "UNKNOWN";
        }
        StringBuffer buffer = new StringBuffer();
        if ((route & 1) == 1) {
            CallAudioState.listAppend(buffer, "EARPIECE");
        }
        if ((route & 2) == 2) {
            CallAudioState.listAppend(buffer, "BLUETOOTH");
        }
        if ((route & 4) == 4) {
            CallAudioState.listAppend(buffer, "WIRED_HEADSET");
        }
        if ((route & 8) == 8) {
            CallAudioState.listAppend(buffer, "SPEAKER");
        }
        return buffer.toString();
    }

    private final int $$robo$$android_telecom_CallAudioState$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telecom_CallAudioState$writeToParcel(Parcel destination, int flags) {
        destination.writeByte((byte)(this.isMuted ? 1 : 0));
        destination.writeInt(this.route);
        destination.writeInt(this.supportedRouteMask);
        destination.writeParcelable(this.activeBluetoothDevice, 0);
        destination.writeParcelableList(new ArrayList<BluetoothDevice>(this.supportedBluetoothDevices), 0);
    }

    private static final void $$robo$$android_telecom_CallAudioState$listAppend(StringBuffer buffer, String str) {
        if (buffer.length() > 0) {
            buffer.append(", ");
        }
        buffer.append(str);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<CallAudioState>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telecom_CallAudioState_1$__constructor__() {
            }

            private final CallAudioState $$robo$$android_telecom_CallAudioState_1$createFromParcel(Parcel source) {
                boolean isMuted = source.readByte() != 0;
                int route = source.readInt();
                int supportedRouteMask = source.readInt();
                BluetoothDevice activeBluetoothDevice = (BluetoothDevice)source.readParcelable(ClassLoader.getSystemClassLoader());
                ArrayList<BluetoothDevice> supportedBluetoothDevices = new ArrayList<BluetoothDevice>();
                source.readParcelableList(supportedBluetoothDevices, ClassLoader.getSystemClassLoader());
                return new CallAudioState(isMuted, route, supportedRouteMask, activeBluetoothDevice, supportedBluetoothDevices);
            }

            private final CallAudioState[] $$robo$$android_telecom_CallAudioState_1$newArray(int size) {
                return new CallAudioState[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telecom_CallAudioState_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_CallAudioState_1$__constructor__(), 0, this);
            }

            @Override
            public CallAudioState createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telecom_CallAudioState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public CallAudioState[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telecom_CallAudioState_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(boolean bl, int n, int n2) {
        this.$$robo$$android_telecom_CallAudioState$__constructor__(bl, n, n2);
    }

    public CallAudioState(boolean bl, int n, int n2) {
        this(bl, n, n2, null, Collections.emptyList());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_CallAudioState$__constructor__(boolean int int ), 0, this, bl, n, n2);
    }

    private void __constructor__(boolean bl, int n, int n2, BluetoothDevice bluetoothDevice, Collection<BluetoothDevice> collection) {
        this.$$robo$$android_telecom_CallAudioState$__constructor__(bl, n, n2, bluetoothDevice, collection);
    }

    public CallAudioState(boolean bl, int n, int n2, BluetoothDevice bluetoothDevice, Collection<BluetoothDevice> collection) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_CallAudioState$__constructor__(boolean int int android.bluetooth.BluetoothDevice java.util.Collection<android.bluetooth.BluetoothDevice> ), 0, this, bl, n, n2, bluetoothDevice, collection);
    }

    private void __constructor__(CallAudioState callAudioState) {
        this.$$robo$$android_telecom_CallAudioState$__constructor__(callAudioState);
    }

    public CallAudioState(CallAudioState callAudioState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_CallAudioState$__constructor__(android.telecom.CallAudioState ), 0, this, callAudioState);
    }

    private void __constructor__(AudioState audioState) {
        this.$$robo$$android_telecom_CallAudioState$__constructor__(audioState);
    }

    public CallAudioState(AudioState audioState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_CallAudioState$__constructor__(android.telecom.AudioState ), 0, this, audioState);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telecom_CallAudioState$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telecom_CallAudioState$toString(), 0, this);
    }

    public boolean isMuted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMuted", $$robo$$android_telecom_CallAudioState$isMuted(), 0, this);
    }

    public int getRoute() {
        return (int)InvokeDynamicSupport.bootstrap("getRoute", $$robo$$android_telecom_CallAudioState$getRoute(), 0, this);
    }

    public int getSupportedRouteMask() {
        return (int)InvokeDynamicSupport.bootstrap("getSupportedRouteMask", $$robo$$android_telecom_CallAudioState$getSupportedRouteMask(), 0, this);
    }

    public BluetoothDevice getActiveBluetoothDevice() {
        return InvokeDynamicSupport.bootstrap("getActiveBluetoothDevice", $$robo$$android_telecom_CallAudioState$getActiveBluetoothDevice(), 0, this);
    }

    public Collection<BluetoothDevice> getSupportedBluetoothDevices() {
        return InvokeDynamicSupport.bootstrap("getSupportedBluetoothDevices", $$robo$$android_telecom_CallAudioState$getSupportedBluetoothDevices(), 0, this);
    }

    public static String audioRouteToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("audioRouteToString", $$robo$$android_telecom_CallAudioState$audioRouteToString(int ), 0, (int)n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telecom_CallAudioState$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telecom_CallAudioState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static void listAppend(StringBuffer stringBuffer, String string2) {
        InvokeDynamicSupport.bootstrapStatic("listAppend", $$robo$$android_telecom_CallAudioState$listAppend(java.lang.StringBuffer java.lang.String ), 0, (StringBuffer)stringBuffer, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(CallAudioState.class);
    }

    public /* synthetic */ CallAudioState() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallAudioState)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallAudioRoute {
    }
}

