/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.provider.Settings;
import android.telecom.Log;
import android.telecom.Logging.Session;
import android.util.Base64;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SessionManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static long SESSION_ID_ROLLOVER_THRESHOLD = 262144L;
    private static long DEFAULT_SESSION_TIMEOUT_MS = 30000L;
    private static String LOGGING_TAG = "Logging";
    private static String TIMEOUTS_PREFIX = "telecom.";
    private int sCodeEntryCounter;
    private Context mContext;
    @VisibleForTesting
    public ConcurrentHashMap<Integer, Session> mSessionMapper;
    @VisibleForTesting
    public Runnable mCleanStaleSessions;
    private Handler mSessionCleanupHandler;
    @VisibleForTesting
    public ICurrentThreadId mCurrentThreadId;
    private ISessionCleanupTimeoutMs mSessionCleanupTimeoutMs;
    private List<ISessionListener> mSessionListeners;

    private final void $$robo$$android_telecom_Logging_SessionManager$setContext(Context context) {
        this.mContext = context;
    }

    private void $$robo$$android_telecom_Logging_SessionManager$__constructor__() {
        this.sCodeEntryCounter = 0;
        this.mSessionMapper = new ConcurrentHashMap(100);
        this.mCleanStaleSessions = () -> this.cleanupStaleSessions(this.getSessionCleanupTimeoutMs());
        this.mSessionCleanupHandler = new Handler(Looper.getMainLooper());
        this.mCurrentThreadId = Process::myTid;
        this.mSessionCleanupTimeoutMs = () -> {
            if (this.mContext == null) {
                return 30000L;
            }
            return this.getCleanupTimeout(this.mContext);
        };
        this.mSessionListeners = new ArrayList<ISessionListener>();
    }

    private final long $$robo$$android_telecom_Logging_SessionManager$getSessionCleanupTimeoutMs() {
        return this.mSessionCleanupTimeoutMs.get();
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$resetStaleSessionTimer() {
        this.mSessionCleanupHandler.removeCallbacksAndMessages(null);
        if (this.mCleanStaleSessions != null) {
            this.mSessionCleanupHandler.postDelayed(this.mCleanStaleSessions, this.getSessionCleanupTimeoutMs());
        }
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$startSession(Session.Info info, String shortMethodName, String callerIdentification) {
        if (info == null) {
            this.startSession(shortMethodName, callerIdentification);
        } else {
            this.startExternalSession(info, shortMethodName);
        }
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$startSession(String shortMethodName, String callerIdentification) {
        this.resetStaleSessionTimer();
        int threadId = this.getCallingThreadId();
        Session activeSession = this.mSessionMapper.get(threadId);
        if (activeSession != null) {
            Session childSession = this.createSubsession(true);
            this.continueSession(childSession, shortMethodName);
            return;
        }
        Log.d("Logging", "START_SESSION", new Object[0]);
        Session newSession = new Session(this.getNextSessionID(), shortMethodName, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), false, callerIdentification);
        this.mSessionMapper.put(threadId, newSession);
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$startExternalSession(Session.Info sessionInfo, String shortMethodName) {
        if (sessionInfo == null) {
            return;
        }
        int threadId = this.getCallingThreadId();
        Session threadSession = this.mSessionMapper.get(threadId);
        if (threadSession != null) {
            Log.w("Logging", "trying to start an external session with a session already active.", new Object[0]);
            return;
        }
        Log.d("Logging", "START_EXTERNAL_SESSION", new Object[0]);
        Session externalSession = new Session("E-" + sessionInfo.sessionId, sessionInfo.methodPath, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), false, null);
        externalSession.setIsExternal(true);
        externalSession.markSessionCompleted(-1L);
        this.mSessionMapper.put(threadId, externalSession);
        Session childSession = this.createSubsession();
        this.continueSession(childSession, shortMethodName);
    }

    private final Session $$robo$$android_telecom_Logging_SessionManager$createSubsession() {
        return this.createSubsession(false);
    }

    private final synchronized Session $$robo$$android_telecom_Logging_SessionManager$createSubsession(boolean isStartedFromActiveSession) {
        int threadId = this.getCallingThreadId();
        Session threadSession = this.mSessionMapper.get(threadId);
        if (threadSession == null) {
            Log.d("Logging", "Log.createSubsession was called with no session active.", new Object[0]);
            return null;
        }
        Session newSubsession = new Session(threadSession.getNextChildId(), threadSession.getShortMethodName(), (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), isStartedFromActiveSession, null);
        threadSession.addChild(newSubsession);
        newSubsession.setParentSession(threadSession);
        if (!isStartedFromActiveSession) {
            Log.v("Logging", "CREATE_SUBSESSION " + newSubsession.toString(), new Object[0]);
        } else {
            Log.v("Logging", "CREATE_SUBSESSION (Invisible subsession)", new Object[0]);
        }
        return newSubsession;
    }

    private final synchronized Session.Info $$robo$$android_telecom_Logging_SessionManager$getExternalSession() {
        int threadId = this.getCallingThreadId();
        Session threadSession = this.mSessionMapper.get(threadId);
        if (threadSession == null) {
            Log.d("Logging", "Log.getExternalSession was called with no session active.", new Object[0]);
            return null;
        }
        return threadSession.getInfo();
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$cancelSubsession(Session subsession) {
        if (subsession == null) {
            return;
        }
        subsession.markSessionCompleted(-1L);
        this.endParentSessions(subsession);
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$continueSession(Session subsession, String shortMethodName) {
        if (subsession == null) {
            return;
        }
        this.resetStaleSessionTimer();
        subsession.setShortMethodName(shortMethodName);
        subsession.setExecutionStartTimeMs((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        Session parentSession = subsession.getParentSession();
        if (parentSession == null) {
            Log.i("Logging", "Log.continueSession was called with no session active for method " + shortMethodName, new Object[0]);
            return;
        }
        this.mSessionMapper.put(this.getCallingThreadId(), subsession);
        if (!subsession.isStartedFromActiveSession()) {
            Log.v("Logging", "CONTINUE_SUBSESSION", new Object[0]);
        } else {
            Log.v("Logging", "CONTINUE_SUBSESSION (Invisible Subsession) with Method " + shortMethodName, new Object[0]);
        }
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$endSession() {
        int threadId = this.getCallingThreadId();
        Session completedSession = this.mSessionMapper.get(threadId);
        if (completedSession == null) {
            Log.w("Logging", "Log.endSession was called with no session active.", new Object[0]);
            return;
        }
        completedSession.markSessionCompleted((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        if (!completedSession.isStartedFromActiveSession()) {
            Log.v("Logging", "END_SUBSESSION (dur: " + completedSession.getLocalExecutionTime() + " mS)", new Object[0]);
        } else {
            Log.v("Logging", "END_SUBSESSION (Invisible Subsession) (dur: " + completedSession.getLocalExecutionTime() + " ms)", new Object[0]);
        }
        Session parentSession = completedSession.getParentSession();
        this.mSessionMapper.remove(threadId);
        this.endParentSessions(completedSession);
        if (parentSession != null && !parentSession.isSessionCompleted() && completedSession.isStartedFromActiveSession()) {
            this.mSessionMapper.put(threadId, parentSession);
        }
    }

    private final void $$robo$$android_telecom_Logging_SessionManager$endParentSessions(Session subsession) {
        if (!subsession.isSessionCompleted() || subsession.getChildSessions().size() != 0) {
            return;
        }
        Session parentSession = subsession.getParentSession();
        if (parentSession != null) {
            subsession.setParentSession(null);
            parentSession.removeChild(subsession);
            if (parentSession.isExternal()) {
                reference var3_3 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - subsession.getExecutionStartTimeMilliseconds();
                this.notifySessionCompleteListeners(subsession.getShortMethodName(), (long)var3_3);
            }
            this.endParentSessions(parentSession);
        } else {
            reference var3_4 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - subsession.getExecutionStartTimeMilliseconds();
            Log.d("Logging", "END_SESSION (dur: " + (long)var3_4 + " ms): " + subsession.toString(), new Object[0]);
            if (!subsession.isExternal()) {
                this.notifySessionCompleteListeners(subsession.getShortMethodName(), (long)var3_4);
            }
        }
    }

    private final void $$robo$$android_telecom_Logging_SessionManager$notifySessionCompleteListeners(String methodName, long sessionTimeMs) {
        for (ISessionListener l : this.mSessionListeners) {
            l.sessionComplete(methodName, sessionTimeMs);
        }
    }

    private final String $$robo$$android_telecom_Logging_SessionManager$getSessionId() {
        Session currentSession = this.mSessionMapper.get(this.getCallingThreadId());
        return currentSession != null ? currentSession.toString() : "";
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$registerSessionListener(ISessionListener l) {
        if (l != null) {
            this.mSessionListeners.add(l);
        }
    }

    private final synchronized String $$robo$$android_telecom_Logging_SessionManager$getNextSessionID() {
        Integer nextId;
        if ((long)(nextId = Integer.valueOf(this.sCodeEntryCounter++)).intValue() >= 262144L) {
            this.restartSessionCounter();
            nextId = this.sCodeEntryCounter++;
        }
        return this.getBase64Encoding(nextId);
    }

    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$restartSessionCounter() {
        this.sCodeEntryCounter = 0;
    }

    private final String $$robo$$android_telecom_Logging_SessionManager$getBase64Encoding(int number) {
        byte[] idByteArray = ByteBuffer.allocate(4).putInt(number).array();
        idByteArray = Arrays.copyOfRange(idByteArray, 2, 4);
        return Base64.encodeToString(idByteArray, 3);
    }

    private final int $$robo$$android_telecom_Logging_SessionManager$getCallingThreadId() {
        return this.mCurrentThreadId.get();
    }

    @VisibleForTesting
    private final synchronized void $$robo$$android_telecom_Logging_SessionManager$cleanupStaleSessions(long timeoutMs) {
        String logMessage = "Stale Sessions Cleaned:\n";
        boolean isSessionsStale = false;
        CallSite currentTimeMs = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        Iterator<Map.Entry<Integer, Session>> it = this.mSessionMapper.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Session> entry = it.next();
            Session session = entry.getValue();
            if (currentTimeMs - session.getExecutionStartTimeMilliseconds() <= timeoutMs) continue;
            it.remove();
            logMessage = logMessage + session.printFullSessionTree() + "\n";
            isSessionsStale = true;
        }
        if (isSessionsStale) {
            Log.w("Logging", logMessage, new Object[0]);
        } else {
            Log.v("Logging", "No stale logging sessions needed to be cleaned...", new Object[0]);
        }
    }

    private final long $$robo$$android_telecom_Logging_SessionManager$getCleanupTimeout(Context context) {
        return Settings.Secure.getLong(context.getContentResolver(), "telecom.stale_session_cleanup_timeout_millis", 30000L);
    }

    public void setContext(Context context) {
        InvokeDynamicSupport.bootstrap("setContext", $$robo$$android_telecom_Logging_SessionManager$setContext(android.content.Context ), 0, this, context);
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_Logging_SessionManager$__constructor__();
    }

    public SessionManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_SessionManager$__constructor__(), 0, this);
    }

    private long getSessionCleanupTimeoutMs() {
        return (long)InvokeDynamicSupport.bootstrap("getSessionCleanupTimeoutMs", $$robo$$android_telecom_Logging_SessionManager$getSessionCleanupTimeoutMs(), 0, this);
    }

    private synchronized void resetStaleSessionTimer() {
        InvokeDynamicSupport.bootstrap("resetStaleSessionTimer", $$robo$$android_telecom_Logging_SessionManager$resetStaleSessionTimer(), 0, this);
    }

    public synchronized void startSession(Session.Info info, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("startSession", $$robo$$android_telecom_Logging_SessionManager$startSession(android.telecom.Logging.Session$Info java.lang.String java.lang.String ), 0, this, info, string2, string3);
    }

    public synchronized void startSession(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("startSession", $$robo$$android_telecom_Logging_SessionManager$startSession(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public synchronized void startExternalSession(Session.Info info, String string2) {
        InvokeDynamicSupport.bootstrap("startExternalSession", $$robo$$android_telecom_Logging_SessionManager$startExternalSession(android.telecom.Logging.Session$Info java.lang.String ), 0, this, info, string2);
    }

    public Session createSubsession() {
        return InvokeDynamicSupport.bootstrap("createSubsession", $$robo$$android_telecom_Logging_SessionManager$createSubsession(), 0, this);
    }

    private synchronized Session createSubsession(boolean bl) {
        return InvokeDynamicSupport.bootstrap("createSubsession", $$robo$$android_telecom_Logging_SessionManager$createSubsession(boolean ), 0, this, bl);
    }

    public synchronized Session.Info getExternalSession() {
        return InvokeDynamicSupport.bootstrap("getExternalSession", $$robo$$android_telecom_Logging_SessionManager$getExternalSession(), 0, this);
    }

    public synchronized void cancelSubsession(Session session) {
        InvokeDynamicSupport.bootstrap("cancelSubsession", $$robo$$android_telecom_Logging_SessionManager$cancelSubsession(android.telecom.Logging.Session ), 0, this, session);
    }

    public synchronized void continueSession(Session session, String string2) {
        InvokeDynamicSupport.bootstrap("continueSession", $$robo$$android_telecom_Logging_SessionManager$continueSession(android.telecom.Logging.Session java.lang.String ), 0, this, session, string2);
    }

    public synchronized void endSession() {
        InvokeDynamicSupport.bootstrap("endSession", $$robo$$android_telecom_Logging_SessionManager$endSession(), 0, this);
    }

    private void endParentSessions(Session session) {
        InvokeDynamicSupport.bootstrap("endParentSessions", $$robo$$android_telecom_Logging_SessionManager$endParentSessions(android.telecom.Logging.Session ), 0, this, session);
    }

    private void notifySessionCompleteListeners(String string2, long l) {
        InvokeDynamicSupport.bootstrap("notifySessionCompleteListeners", $$robo$$android_telecom_Logging_SessionManager$notifySessionCompleteListeners(java.lang.String long ), 0, this, string2, l);
    }

    public String getSessionId() {
        return InvokeDynamicSupport.bootstrap("getSessionId", $$robo$$android_telecom_Logging_SessionManager$getSessionId(), 0, this);
    }

    public synchronized void registerSessionListener(ISessionListener iSessionListener) {
        InvokeDynamicSupport.bootstrap("registerSessionListener", $$robo$$android_telecom_Logging_SessionManager$registerSessionListener(android.telecom.Logging.SessionManager$ISessionListener ), 0, this, iSessionListener);
    }

    private synchronized String getNextSessionID() {
        return InvokeDynamicSupport.bootstrap("getNextSessionID", $$robo$$android_telecom_Logging_SessionManager$getNextSessionID(), 0, this);
    }

    private synchronized void restartSessionCounter() {
        InvokeDynamicSupport.bootstrap("restartSessionCounter", $$robo$$android_telecom_Logging_SessionManager$restartSessionCounter(), 0, this);
    }

    private String getBase64Encoding(int n) {
        return InvokeDynamicSupport.bootstrap("getBase64Encoding", $$robo$$android_telecom_Logging_SessionManager$getBase64Encoding(int ), 0, this, n);
    }

    private int getCallingThreadId() {
        return (int)InvokeDynamicSupport.bootstrap("getCallingThreadId", $$robo$$android_telecom_Logging_SessionManager$getCallingThreadId(), 0, this);
    }

    public synchronized void cleanupStaleSessions(long l) {
        InvokeDynamicSupport.bootstrap("cleanupStaleSessions", $$robo$$android_telecom_Logging_SessionManager$cleanupStaleSessions(long ), 0, this, l);
    }

    private long getCleanupTimeout(Context context) {
        return (long)InvokeDynamicSupport.bootstrap("getCleanupTimeout", $$robo$$android_telecom_Logging_SessionManager$getCleanupTimeout(android.content.Context ), 0, this, context);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ISessionIdQueryHandler
    extends InstrumentedInterface {
        public String getSessionId();
    }

    public static interface ISessionListener
    extends InstrumentedInterface {
        public void sessionComplete(String var1, long var2);
    }

    public static interface ICurrentThreadId
    extends InstrumentedInterface {
        public int get();
    }

    private static interface ISessionCleanupTimeoutMs
    extends InstrumentedInterface {
        public long get();
    }
}

