/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.UserInfo;
import android.location.LocationManager;
import android.os.Binder;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LocationAccessPolicy
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;

    private void $$robo$$android_telephony_LocationAccessPolicy$__constructor__() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_telephony_LocationAccessPolicy$canAccessCellLocation(Context context, String pkgName, int uid, int pid, boolean throwOnDeniedPermission) throws SecurityException {
        Trace.beginSection("TelephonyLohcationCheck");
        try {
            if (uid == 1001) {
                boolean bl = true;
                return bl;
            }
            if (throwOnDeniedPermission) {
                context.enforcePermission("android.permission.ACCESS_COARSE_LOCATION", pid, uid, "canAccessCellLocation");
            } else if (context.checkPermission("android.permission.ACCESS_COARSE_LOCATION", pid, uid) == -1) {
                boolean bl = false;
                return bl;
            }
            int opCode = AppOpsManager.permissionToOpCode("android.permission.ACCESS_COARSE_LOCATION");
            if (opCode != -1 && context.getSystemService(AppOpsManager.class).noteOpNoThrow(opCode, uid, pkgName) != 0) {
                boolean bl = false;
                return bl;
            }
            if (!LocationAccessPolicy.isLocationModeEnabled(context, UserHandle.getUserId(uid))) {
                boolean bl = false;
                return bl;
            }
            boolean bl = LocationAccessPolicy.isCurrentProfile(context, uid) || LocationAccessPolicy.checkInteractAcrossUsersFull(context);
            return bl;
        }
        finally {
            Trace.endSection();
        }
    }

    private static final boolean $$robo$$android_telephony_LocationAccessPolicy$isLocationModeEnabled(Context context, int userId) {
        LocationManager locationManager = context.getSystemService(LocationManager.class);
        if (locationManager == null) {
            Log.w(LOG_TAG, "Couldn't get location manager, denying location access");
            return false;
        }
        return locationManager.isLocationEnabledForUser(UserHandle.of(userId));
    }

    private static final boolean $$robo$$android_telephony_LocationAccessPolicy$checkInteractAcrossUsersFull(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_telephony_LocationAccessPolicy$isCurrentProfile(Context context, int uid) {
        long token = Binder.clearCallingIdentity();
        try {
            int currentUser = ActivityManager.getCurrentUser();
            int callingUserId = UserHandle.getUserId(uid);
            if (callingUserId == currentUser) {
                boolean bl = true;
                return bl;
            }
            List<UserInfo> userProfiles = context.getSystemService(UserManager.class).getProfiles(currentUser);
            for (UserInfo user : userProfiles) {
                if (user.id != callingUserId) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    static void __staticInitializer__() {
        LOG_TAG = LocationAccessPolicy.class.getSimpleName();
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_LocationAccessPolicy$__constructor__();
    }

    public LocationAccessPolicy() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_LocationAccessPolicy$__constructor__(), 0, this);
    }

    public static boolean canAccessCellLocation(Context context, String string2, int n, int n2, boolean bl) throws SecurityException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canAccessCellLocation", $$robo$$android_telephony_LocationAccessPolicy$canAccessCellLocation(android.content.Context java.lang.String int int boolean ), 0, (Context)context, (String)string2, (int)n, (int)n2, (boolean)bl);
    }

    private static boolean isLocationModeEnabled(Context context, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLocationModeEnabled", $$robo$$android_telephony_LocationAccessPolicy$isLocationModeEnabled(android.content.Context int ), 0, (Context)context, (int)n);
    }

    private static boolean checkInteractAcrossUsersFull(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkInteractAcrossUsersFull", $$robo$$android_telephony_LocationAccessPolicy$checkInteractAcrossUsersFull(android.content.Context ), 0, (Context)context);
    }

    private static boolean isCurrentProfile(Context context, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCurrentProfile", $$robo$$android_telephony_LocationAccessPolicy$isCurrentProfile(android.content.Context int ), 0, (Context)context, (int)n);
    }

    static {
        RobolectricInternals.classInitializing(LocationAccessPolicy.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocationAccessPolicy)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

