/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellIdentity;
import android.telephony.DataSpecificRegistrationStates;
import android.telephony.TelephonyManager;
import android.telephony.VoiceSpecificRegistrationStates;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkRegistrationState
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int DOMAIN_CS = 1;
    public static int DOMAIN_PS = 2;
    public static int REG_STATE_NOT_REG_NOT_SEARCHING = 0;
    public static int REG_STATE_HOME = 1;
    public static int REG_STATE_NOT_REG_SEARCHING = 2;
    public static int REG_STATE_DENIED = 3;
    public static int REG_STATE_UNKNOWN = 4;
    public static int REG_STATE_ROAMING = 5;
    public static int SERVICE_TYPE_VOICE = 1;
    public static int SERVICE_TYPE_DATA = 2;
    public static int SERVICE_TYPE_SMS = 3;
    public static int SERVICE_TYPE_VIDEO = 4;
    public static int SERVICE_TYPE_EMERGENCY = 5;
    private int mTransportType;
    private int mDomain;
    private int mRegState;
    private int mAccessNetworkTechnology;
    private int mReasonForDenial;
    private boolean mEmergencyOnly;
    private int[] mAvailableServices;
    private CellIdentity mCellIdentity;
    private VoiceSpecificRegistrationStates mVoiceSpecificStates;
    private DataSpecificRegistrationStates mDataSpecificStates;
    public static Parcelable.Creator<NetworkRegistrationState> CREATOR;

    private void $$robo$$android_telephony_NetworkRegistrationState$__constructor__(int transportType, int domain, int regState, int accessNetworkTechnology, int reasonForDenial, boolean emergencyOnly, int[] availableServices, CellIdentity cellIdentity) {
        this.mTransportType = transportType;
        this.mDomain = domain;
        this.mRegState = regState;
        this.mAccessNetworkTechnology = accessNetworkTechnology;
        this.mReasonForDenial = reasonForDenial;
        this.mAvailableServices = availableServices;
        this.mCellIdentity = cellIdentity;
        this.mEmergencyOnly = emergencyOnly;
    }

    private void $$robo$$android_telephony_NetworkRegistrationState$__constructor__(int transportType, int domain, int regState, int accessNetworkTechnology, int reasonForDenial, boolean emergencyOnly, int[] availableServices, CellIdentity cellIdentity, boolean cssSupported, int roamingIndicator, int systemIsInPrl, int defaultRoamingIndicator) {
        this.mVoiceSpecificStates = new VoiceSpecificRegistrationStates(cssSupported, roamingIndicator, systemIsInPrl, defaultRoamingIndicator);
    }

    private void $$robo$$android_telephony_NetworkRegistrationState$__constructor__(int transportType, int domain, int regState, int accessNetworkTechnology, int reasonForDenial, boolean emergencyOnly, int[] availableServices, CellIdentity cellIdentity, int maxDataCalls) {
        this.mDataSpecificStates = new DataSpecificRegistrationStates(maxDataCalls);
    }

    private void $$robo$$android_telephony_NetworkRegistrationState$__constructor__(Parcel source) {
        this.mTransportType = source.readInt();
        this.mDomain = source.readInt();
        this.mRegState = source.readInt();
        this.mAccessNetworkTechnology = source.readInt();
        this.mReasonForDenial = source.readInt();
        this.mEmergencyOnly = source.readBoolean();
        this.mAvailableServices = source.createIntArray();
        this.mCellIdentity = (CellIdentity)source.readParcelable(CellIdentity.class.getClassLoader());
        this.mVoiceSpecificStates = (VoiceSpecificRegistrationStates)source.readParcelable(VoiceSpecificRegistrationStates.class.getClassLoader());
        this.mDataSpecificStates = (DataSpecificRegistrationStates)source.readParcelable(DataSpecificRegistrationStates.class.getClassLoader());
    }

    private final int $$robo$$android_telephony_NetworkRegistrationState$getTransportType() {
        return this.mTransportType;
    }

    private final int $$robo$$android_telephony_NetworkRegistrationState$getDomain() {
        return this.mDomain;
    }

    private final int $$robo$$android_telephony_NetworkRegistrationState$getRegState() {
        return this.mRegState;
    }

    private final boolean $$robo$$android_telephony_NetworkRegistrationState$isEmergencyEnabled() {
        return this.mEmergencyOnly;
    }

    private final int[] $$robo$$android_telephony_NetworkRegistrationState$getAvailableServices() {
        return this.mAvailableServices;
    }

    private final int $$robo$$android_telephony_NetworkRegistrationState$getAccessNetworkTechnology() {
        return this.mAccessNetworkTechnology;
    }

    private final int $$robo$$android_telephony_NetworkRegistrationState$getReasonForDenial() {
        return this.mReasonForDenial;
    }

    private final CellIdentity $$robo$$android_telephony_NetworkRegistrationState$getCellIdentity() {
        return this.mCellIdentity;
    }

    private final VoiceSpecificRegistrationStates $$robo$$android_telephony_NetworkRegistrationState$getVoiceSpecificStates() {
        return this.mVoiceSpecificStates;
    }

    private final DataSpecificRegistrationStates $$robo$$android_telephony_NetworkRegistrationState$getDataSpecificStates() {
        return this.mDataSpecificStates;
    }

    private final int $$robo$$android_telephony_NetworkRegistrationState$describeContents() {
        return 0;
    }

    private static final String $$robo$$android_telephony_NetworkRegistrationState$regStateToString(int regState) {
        switch (regState) {
            case 0: {
                return "NOT_REG_NOT_SEARCHING";
            }
            case 1: {
                return "HOME";
            }
            case 2: {
                return "NOT_REG_SEARCHING";
            }
            case 3: {
                return "DENIED";
            }
            case 4: {
                return "UNKNOWN";
            }
            case 5: {
                return "ROAMING";
            }
        }
        return "Unknown reg state " + regState;
    }

    private final String $$robo$$android_telephony_NetworkRegistrationState$toString() {
        return "NetworkRegistrationState{" + "transportType=" + this.mTransportType + " domain=" + (this.mDomain == 1 ? "CS" : "PS") + " regState=" + NetworkRegistrationState.regStateToString(this.mRegState) + " accessNetworkTechnology=" + TelephonyManager.getNetworkTypeName(this.mAccessNetworkTechnology) + " reasonForDenial=" + this.mReasonForDenial + " emergencyEnabled=" + this.mEmergencyOnly + " supportedServices=" + this.mAvailableServices + " cellIdentity=" + this.mCellIdentity + " voiceSpecificStates=" + this.mVoiceSpecificStates + " dataSpecificStates=" + this.mDataSpecificStates + "}";
    }

    private final int $$robo$$android_telephony_NetworkRegistrationState$hashCode() {
        return Objects.hash(this.mTransportType, this.mDomain, this.mRegState, this.mAccessNetworkTechnology, this.mReasonForDenial, this.mEmergencyOnly, this.mAvailableServices, this.mCellIdentity, this.mVoiceSpecificStates, this.mDataSpecificStates);
    }

    private final boolean $$robo$$android_telephony_NetworkRegistrationState$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof NetworkRegistrationState)) {
            return false;
        }
        NetworkRegistrationState other = (NetworkRegistrationState)o;
        return this.mTransportType == other.mTransportType && this.mDomain == other.mDomain && this.mRegState == other.mRegState && this.mAccessNetworkTechnology == other.mAccessNetworkTechnology && this.mReasonForDenial == other.mReasonForDenial && this.mEmergencyOnly == other.mEmergencyOnly && (this.mAvailableServices == other.mAvailableServices || Arrays.equals(this.mAvailableServices, other.mAvailableServices)) && NetworkRegistrationState.equals(this.mCellIdentity, other.mCellIdentity) && NetworkRegistrationState.equals(this.mVoiceSpecificStates, other.mVoiceSpecificStates) && NetworkRegistrationState.equals(this.mDataSpecificStates, other.mDataSpecificStates);
    }

    private final void $$robo$$android_telephony_NetworkRegistrationState$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTransportType);
        dest.writeInt(this.mDomain);
        dest.writeInt(this.mRegState);
        dest.writeInt(this.mAccessNetworkTechnology);
        dest.writeInt(this.mReasonForDenial);
        dest.writeBoolean(this.mEmergencyOnly);
        dest.writeIntArray(this.mAvailableServices);
        dest.writeParcelable(this.mCellIdentity, 0);
        dest.writeParcelable(this.mVoiceSpecificStates, 0);
        dest.writeParcelable(this.mDataSpecificStates, 0);
    }

    private static final boolean $$robo$$android_telephony_NetworkRegistrationState$equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<NetworkRegistrationState>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_NetworkRegistrationState_1$__constructor__() {
            }

            private final NetworkRegistrationState $$robo$$android_telephony_NetworkRegistrationState_1$createFromParcel(Parcel source) {
                return new NetworkRegistrationState(source);
            }

            private final NetworkRegistrationState[] $$robo$$android_telephony_NetworkRegistrationState_1$newArray(int size) {
                return new NetworkRegistrationState[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_NetworkRegistrationState_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkRegistrationState_1$__constructor__(), 0, this);
            }

            @Override
            public NetworkRegistrationState createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_NetworkRegistrationState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NetworkRegistrationState[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_NetworkRegistrationState_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, boolean bl, int[] nArray, CellIdentity cellIdentity) {
        this.$$robo$$android_telephony_NetworkRegistrationState$__constructor__(n, n2, n3, n4, n5, bl, nArray, cellIdentity);
    }

    public NetworkRegistrationState(int n, int n2, int n3, int n4, int n5, boolean bl, int[] nArray, CellIdentity cellIdentity) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkRegistrationState$__constructor__(int int int int int boolean int[] android.telephony.CellIdentity ), 0, this, n, n2, n3, n4, n5, bl, nArray, cellIdentity);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, boolean bl, int[] nArray, CellIdentity cellIdentity, boolean bl2, int n6, int n7, int n8) {
        this.$$robo$$android_telephony_NetworkRegistrationState$__constructor__(n, n2, n3, n4, n5, bl, nArray, cellIdentity, bl2, n6, n7, n8);
    }

    public NetworkRegistrationState(int n, int n2, int n3, int n4, int n5, boolean bl, int[] nArray, CellIdentity cellIdentity, boolean bl2, int n6, int n7, int n8) {
        this(n, n2, n3, n4, n5, bl, nArray, cellIdentity);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkRegistrationState$__constructor__(int int int int int boolean int[] android.telephony.CellIdentity boolean int int int ), 0, this, n, n2, n3, n4, n5, bl, nArray, cellIdentity, bl2, n6, n7, n8);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, boolean bl, int[] nArray, CellIdentity cellIdentity, int n6) {
        this.$$robo$$android_telephony_NetworkRegistrationState$__constructor__(n, n2, n3, n4, n5, bl, nArray, cellIdentity, n6);
    }

    public NetworkRegistrationState(int n, int n2, int n3, int n4, int n5, boolean bl, int[] nArray, CellIdentity cellIdentity, int n6) {
        this(n, n2, n3, n4, n5, bl, nArray, cellIdentity);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkRegistrationState$__constructor__(int int int int int boolean int[] android.telephony.CellIdentity int ), 0, this, n, n2, n3, n4, n5, bl, nArray, cellIdentity, n6);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_NetworkRegistrationState$__constructor__(parcel);
    }

    protected NetworkRegistrationState(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkRegistrationState$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public int getTransportType() {
        return (int)InvokeDynamicSupport.bootstrap("getTransportType", $$robo$$android_telephony_NetworkRegistrationState$getTransportType(), 0, this);
    }

    public int getDomain() {
        return (int)InvokeDynamicSupport.bootstrap("getDomain", $$robo$$android_telephony_NetworkRegistrationState$getDomain(), 0, this);
    }

    public int getRegState() {
        return (int)InvokeDynamicSupport.bootstrap("getRegState", $$robo$$android_telephony_NetworkRegistrationState$getRegState(), 0, this);
    }

    public boolean isEmergencyEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergencyEnabled", $$robo$$android_telephony_NetworkRegistrationState$isEmergencyEnabled(), 0, this);
    }

    public int[] getAvailableServices() {
        return InvokeDynamicSupport.bootstrap("getAvailableServices", $$robo$$android_telephony_NetworkRegistrationState$getAvailableServices(), 0, this);
    }

    public int getAccessNetworkTechnology() {
        return (int)InvokeDynamicSupport.bootstrap("getAccessNetworkTechnology", $$robo$$android_telephony_NetworkRegistrationState$getAccessNetworkTechnology(), 0, this);
    }

    public int getReasonForDenial() {
        return (int)InvokeDynamicSupport.bootstrap("getReasonForDenial", $$robo$$android_telephony_NetworkRegistrationState$getReasonForDenial(), 0, this);
    }

    public CellIdentity getCellIdentity() {
        return InvokeDynamicSupport.bootstrap("getCellIdentity", $$robo$$android_telephony_NetworkRegistrationState$getCellIdentity(), 0, this);
    }

    public VoiceSpecificRegistrationStates getVoiceSpecificStates() {
        return InvokeDynamicSupport.bootstrap("getVoiceSpecificStates", $$robo$$android_telephony_NetworkRegistrationState$getVoiceSpecificStates(), 0, this);
    }

    public DataSpecificRegistrationStates getDataSpecificStates() {
        return InvokeDynamicSupport.bootstrap("getDataSpecificStates", $$robo$$android_telephony_NetworkRegistrationState$getDataSpecificStates(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_NetworkRegistrationState$describeContents(), 0, this);
    }

    private static String regStateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("regStateToString", $$robo$$android_telephony_NetworkRegistrationState$regStateToString(int ), 0, (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_NetworkRegistrationState$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_NetworkRegistrationState$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_NetworkRegistrationState$equals(java.lang.Object ), 0, this, object);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_NetworkRegistrationState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static boolean equals(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equals", $$robo$$android_telephony_NetworkRegistrationState$equals(java.lang.Object java.lang.Object ), 0, (Object)object, (Object)object2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkRegistrationState.class);
    }

    public /* synthetic */ NetworkRegistrationState() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkRegistrationState)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ServiceType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Domain {
    }
}

