/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.INetworkService;
import android.telephony.INetworkServiceCallback;
import android.telephony.NetworkServiceCallback;
import android.telephony.Rlog;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class NetworkService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    public static String NETWORK_SERVICE_INTERFACE = "android.telephony.NetworkService";
    public static String NETWORK_SERVICE_EXTRA_SLOT_ID = "android.telephony.extra.SLOT_ID";
    private static int NETWORK_SERVICE_CREATE_NETWORK_SERVICE_PROVIDER = 1;
    private static int NETWORK_SERVICE_REMOVE_NETWORK_SERVICE_PROVIDER = 2;
    private static int NETWORK_SERVICE_REMOVE_ALL_NETWORK_SERVICE_PROVIDERS = 3;
    private static int NETWORK_SERVICE_GET_REGISTRATION_STATE = 4;
    private static int NETWORK_SERVICE_REGISTER_FOR_STATE_CHANGE = 5;
    private static int NETWORK_SERVICE_UNREGISTER_FOR_STATE_CHANGE = 6;
    private static int NETWORK_SERVICE_INDICATION_NETWORK_STATE_CHANGED = 7;
    private HandlerThread mHandlerThread;
    private NetworkServiceHandler mHandler;
    private SparseArray<NetworkServiceProvider> mServiceMap;
    @VisibleForTesting
    public INetworkServiceWrapper mBinder;

    private void $$robo$$android_telephony_NetworkService$__constructor__() {
        this.TAG = NetworkService.class.getSimpleName();
        this.mServiceMap = new SparseArray();
        this.mBinder = new INetworkServiceWrapper(this);
        this.mHandlerThread = new HandlerThread(this.TAG);
        this.mHandlerThread.start();
        this.mHandler = new NetworkServiceHandler(this, this.mHandlerThread.getLooper());
        this.log("network service created");
    }

    protected abstract NetworkServiceProvider createNetworkServiceProvider(int var1);

    private final IBinder $$robo$$android_telephony_NetworkService$onBind(Intent intent) {
        if (intent == null || !"android.telephony.NetworkService".equals(intent.getAction())) {
            this.loge("Unexpected intent " + intent);
            return null;
        }
        return this.mBinder;
    }

    private final boolean $$robo$$android_telephony_NetworkService$onUnbind(Intent intent) {
        this.mHandler.obtainMessage(3, 0, 0, null).sendToTarget();
        return false;
    }

    private final void $$robo$$android_telephony_NetworkService$onDestroy() {
        this.mHandlerThread.quit();
    }

    private final void $$robo$$android_telephony_NetworkService$log(String s) {
        Rlog.d(this.TAG, s);
    }

    private final void $$robo$$android_telephony_NetworkService$loge(String s) {
        Rlog.e(this.TAG, s);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_NetworkService$__constructor__();
    }

    public NetworkService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkService$__constructor__(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_telephony_NetworkService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public boolean onUnbind(Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onUnbind", $$robo$$android_telephony_NetworkService$onUnbind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_telephony_NetworkService$onDestroy(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$android_telephony_NetworkService$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$android_telephony_NetworkService$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class INetworkServiceWrapper
    extends INetworkService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NetworkService this$0;

        private void $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$__constructor__(NetworkService networkService) {
        }

        private final void $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$createNetworkServiceProvider(int slotId) {
            this.this$0.mHandler.obtainMessage(1, slotId, 0, null).sendToTarget();
        }

        private final void $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$removeNetworkServiceProvider(int slotId) {
            this.this$0.mHandler.obtainMessage(2, slotId, 0, null).sendToTarget();
        }

        private final void $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$getNetworkRegistrationState(int slotId, int domain, INetworkServiceCallback callback) {
            this.this$0.mHandler.obtainMessage(4, slotId, domain, callback).sendToTarget();
        }

        private final void $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$registerForNetworkRegistrationStateChanged(int slotId, INetworkServiceCallback callback) {
            this.this$0.mHandler.obtainMessage(5, slotId, 0, callback).sendToTarget();
        }

        private final void $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$unregisterForNetworkRegistrationStateChanged(int slotId, INetworkServiceCallback callback) {
            this.this$0.mHandler.obtainMessage(6, slotId, 0, callback).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$__constructor__(NetworkService x0, 1 x1) {
        }

        private void __constructor__(NetworkService networkService) {
            this.$$robo$$android_telephony_NetworkService_INetworkServiceWrapper$__constructor__(networkService);
        }

        private INetworkServiceWrapper(NetworkService networkService) {
            this.this$0 = networkService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$__constructor__(android.telephony.NetworkService ), 0, this, networkService);
        }

        @Override
        public void createNetworkServiceProvider(int n) {
            InvokeDynamicSupport.bootstrap("createNetworkServiceProvider", $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$createNetworkServiceProvider(int ), 0, this, n);
        }

        @Override
        public void removeNetworkServiceProvider(int n) {
            InvokeDynamicSupport.bootstrap("removeNetworkServiceProvider", $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$removeNetworkServiceProvider(int ), 0, this, n);
        }

        @Override
        public void getNetworkRegistrationState(int n, int n2, INetworkServiceCallback iNetworkServiceCallback) {
            InvokeDynamicSupport.bootstrap("getNetworkRegistrationState", $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$getNetworkRegistrationState(int int android.telephony.INetworkServiceCallback ), 0, this, n, n2, iNetworkServiceCallback);
        }

        @Override
        public void registerForNetworkRegistrationStateChanged(int n, INetworkServiceCallback iNetworkServiceCallback) {
            InvokeDynamicSupport.bootstrap("registerForNetworkRegistrationStateChanged", $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$registerForNetworkRegistrationStateChanged(int android.telephony.INetworkServiceCallback ), 0, this, n, iNetworkServiceCallback);
        }

        @Override
        public void unregisterForNetworkRegistrationStateChanged(int n, INetworkServiceCallback iNetworkServiceCallback) {
            InvokeDynamicSupport.bootstrap("unregisterForNetworkRegistrationStateChanged", $$robo$$android_telephony_NetworkService_INetworkServiceWrapper$unregisterForNetworkRegistrationStateChanged(int android.telephony.INetworkServiceCallback ), 0, this, n, iNetworkServiceCallback);
        }

        private /* synthetic */ void __constructor__(NetworkService networkService, 1 var2_2) {
            this.$$robo$$android_telephony_NetworkService_INetworkServiceWrapper$__constructor__(networkService, var2_2);
        }

        public /* synthetic */ INetworkServiceWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (INetworkServiceWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class NetworkServiceHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NetworkService this$0;

        private void $$robo$$android_telephony_NetworkService_NetworkServiceHandler$__constructor__(NetworkService networkService, Looper looper) {
        }

        private final void $$robo$$android_telephony_NetworkService_NetworkServiceHandler$handleMessage(Message message) {
            int slotId = message.arg1;
            INetworkServiceCallback callback = (INetworkServiceCallback)message.obj;
            NetworkServiceProvider serviceProvider = (NetworkServiceProvider)this.this$0.mServiceMap.get(slotId);
            switch (message.what) {
                case 1: {
                    if (serviceProvider != null) break;
                    this.this$0.mServiceMap.put(slotId, this.this$0.createNetworkServiceProvider(slotId));
                    break;
                }
                case 2: {
                    if (serviceProvider == null) break;
                    serviceProvider.onDestroy();
                    this.this$0.mServiceMap.remove(slotId);
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.this$0.mServiceMap.size(); ++i) {
                        serviceProvider = (NetworkServiceProvider)this.this$0.mServiceMap.get(i);
                        if (serviceProvider == null) continue;
                        serviceProvider.onDestroy();
                    }
                    this.this$0.mServiceMap.clear();
                    break;
                }
                case 4: {
                    if (serviceProvider == null) break;
                    int domainId = message.arg2;
                    serviceProvider.getNetworkRegistrationState(domainId, new NetworkServiceCallback(callback));
                    break;
                }
                case 5: {
                    if (serviceProvider == null) break;
                    serviceProvider.registerForStateChanged(callback);
                    break;
                }
                case 6: {
                    if (serviceProvider == null) break;
                    serviceProvider.unregisterForStateChanged(callback);
                    break;
                }
                case 7: {
                    if (serviceProvider == null) break;
                    serviceProvider.notifyStateChangedToCallbacks();
                    break;
                }
            }
        }

        private void __constructor__(NetworkService networkService, Looper looper) {
            this.$$robo$$android_telephony_NetworkService_NetworkServiceHandler$__constructor__(networkService, looper);
        }

        NetworkServiceHandler(NetworkService networkService, Looper looper) {
            this.this$0 = networkService;
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkService_NetworkServiceHandler$__constructor__(android.telephony.NetworkService android.os.Looper ), 0, this, networkService, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telephony_NetworkService_NetworkServiceHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ NetworkServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class NetworkServiceProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSlotId;
        private List<INetworkServiceCallback> mNetworkRegistrationStateChangedCallbacks;
        /* synthetic */ NetworkService this$0;

        private void $$robo$$android_telephony_NetworkService_NetworkServiceProvider$__constructor__(NetworkService this$0, int slotId) {
            this.mNetworkRegistrationStateChangedCallbacks = new ArrayList<INetworkServiceCallback>();
            this.mSlotId = slotId;
        }

        private final int $$robo$$android_telephony_NetworkService_NetworkServiceProvider$getSlotId() {
            return this.mSlotId;
        }

        private final void $$robo$$android_telephony_NetworkService_NetworkServiceProvider$getNetworkRegistrationState(int domain, NetworkServiceCallback callback) {
            callback.onGetNetworkRegistrationStateComplete(1, null);
        }

        private final void $$robo$$android_telephony_NetworkService_NetworkServiceProvider$notifyNetworkRegistrationStateChanged() {
            this.this$0.mHandler.obtainMessage(7, this.mSlotId, 0, null).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_telephony_NetworkService_NetworkServiceProvider$registerForStateChanged(INetworkServiceCallback callback) {
            List<INetworkServiceCallback> list = this.mNetworkRegistrationStateChangedCallbacks;
            synchronized (list) {
                this.mNetworkRegistrationStateChangedCallbacks.add(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_telephony_NetworkService_NetworkServiceProvider$unregisterForStateChanged(INetworkServiceCallback callback) {
            List<INetworkServiceCallback> list = this.mNetworkRegistrationStateChangedCallbacks;
            synchronized (list) {
                this.mNetworkRegistrationStateChangedCallbacks.remove(callback);
            }
        }

        private final void $$robo$$android_telephony_NetworkService_NetworkServiceProvider$notifyStateChangedToCallbacks() {
            for (INetworkServiceCallback callback : this.mNetworkRegistrationStateChangedCallbacks) {
                try {
                    callback.onNetworkStateChanged();
                }
                catch (RemoteException remoteException) {}
            }
        }

        private final void $$robo$$android_telephony_NetworkService_NetworkServiceProvider$onDestroy() {
            this.mNetworkRegistrationStateChangedCallbacks.clear();
        }

        private void __constructor__(NetworkService networkService, int n) {
            this.$$robo$$android_telephony_NetworkService_NetworkServiceProvider$__constructor__(networkService, n);
        }

        public NetworkServiceProvider(NetworkService networkService, int n) {
            this.this$0 = networkService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_NetworkService_NetworkServiceProvider$__constructor__(android.telephony.NetworkService int ), 0, this, networkService, n);
        }

        public int getSlotId() {
            return (int)InvokeDynamicSupport.bootstrap("getSlotId", $$robo$$android_telephony_NetworkService_NetworkServiceProvider$getSlotId(), 0, this);
        }

        public void getNetworkRegistrationState(int n, NetworkServiceCallback networkServiceCallback) {
            InvokeDynamicSupport.bootstrap("getNetworkRegistrationState", $$robo$$android_telephony_NetworkService_NetworkServiceProvider$getNetworkRegistrationState(int android.telephony.NetworkServiceCallback ), 0, this, n, networkServiceCallback);
        }

        public void notifyNetworkRegistrationStateChanged() {
            InvokeDynamicSupport.bootstrap("notifyNetworkRegistrationStateChanged", $$robo$$android_telephony_NetworkService_NetworkServiceProvider$notifyNetworkRegistrationStateChanged(), 0, this);
        }

        private void registerForStateChanged(INetworkServiceCallback iNetworkServiceCallback) {
            InvokeDynamicSupport.bootstrap("registerForStateChanged", $$robo$$android_telephony_NetworkService_NetworkServiceProvider$registerForStateChanged(android.telephony.INetworkServiceCallback ), 0, this, iNetworkServiceCallback);
        }

        private void unregisterForStateChanged(INetworkServiceCallback iNetworkServiceCallback) {
            InvokeDynamicSupport.bootstrap("unregisterForStateChanged", $$robo$$android_telephony_NetworkService_NetworkServiceProvider$unregisterForStateChanged(android.telephony.INetworkServiceCallback ), 0, this, iNetworkServiceCallback);
        }

        private void notifyStateChangedToCallbacks() {
            InvokeDynamicSupport.bootstrap("notifyStateChangedToCallbacks", $$robo$$android_telephony_NetworkService_NetworkServiceProvider$notifyStateChangedToCallbacks(), 0, this);
        }

        protected void onDestroy() {
            InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_telephony_NetworkService_NetworkServiceProvider$onDestroy(), 0, this);
        }

        public /* synthetic */ NetworkServiceProvider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkServiceProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

