/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.telephony.RILConstants;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RadioAccessFamily
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int RAF_UNKNOWN = 1;
    public static int RAF_GSM = 65536;
    public static int RAF_GPRS = 2;
    public static int RAF_EDGE = 4;
    public static int RAF_IS95A = 16;
    public static int RAF_IS95B = 32;
    public static int RAF_1xRTT = 64;
    public static int RAF_EVDO_0 = 128;
    public static int RAF_EVDO_A = 256;
    public static int RAF_EVDO_B = 4096;
    public static int RAF_EHRPD = 8192;
    public static int RAF_HSUPA = 1024;
    public static int RAF_HSDPA = 512;
    public static int RAF_HSPA = 2048;
    public static int RAF_HSPAP = 32768;
    public static int RAF_UMTS = 8;
    public static int RAF_TD_SCDMA = 131072;
    public static int RAF_LTE = 16384;
    public static int RAF_LTE_CA = 524288;
    private static int GSM = 65542;
    private static int CDMA = 112;
    private static int EVDO = 12672;
    private static int HS = 36352;
    private static int WCDMA = 36360;
    private static int LTE = 540672;
    private int mPhoneId;
    private int mRadioAccessFamily;
    public static Parcelable.Creator<RadioAccessFamily> CREATOR;

    private void $$robo$$android_telephony_RadioAccessFamily$__constructor__(int phoneId, int radioAccessFamily) {
        this.mPhoneId = phoneId;
        this.mRadioAccessFamily = radioAccessFamily;
    }

    private final int $$robo$$android_telephony_RadioAccessFamily$getPhoneId() {
        return this.mPhoneId;
    }

    private final int $$robo$$android_telephony_RadioAccessFamily$getRadioAccessFamily() {
        return this.mRadioAccessFamily;
    }

    private final String $$robo$$android_telephony_RadioAccessFamily$toString() {
        String ret = "{ mPhoneId = " + this.mPhoneId + ", mRadioAccessFamily = " + this.mRadioAccessFamily + "}";
        return ret;
    }

    private final int $$robo$$android_telephony_RadioAccessFamily$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telephony_RadioAccessFamily$writeToParcel(Parcel outParcel, int flags) {
        outParcel.writeInt(this.mPhoneId);
        outParcel.writeInt(this.mRadioAccessFamily);
    }

    private static final int $$robo$$android_telephony_RadioAccessFamily$getRafFromNetworkType(int type) {
        int raf;
        switch (type) {
            case 0: {
                raf = 101902;
                break;
            }
            case 1: {
                raf = 65542;
                break;
            }
            case 2: {
                raf = 36360;
                break;
            }
            case 3: {
                raf = 101902;
                break;
            }
            case 4: {
                raf = 12784;
                break;
            }
            case 8: {
                raf = 553456;
                break;
            }
            case 9: {
                raf = 642574;
                break;
            }
            case 10: {
                raf = 655358;
                break;
            }
            case 11: {
                raf = 540672;
                break;
            }
            case 12: {
                raf = 577032;
                break;
            }
            case 5: {
                raf = 112;
                break;
            }
            case 6: {
                raf = 12672;
                break;
            }
            case 7: {
                raf = 114686;
                break;
            }
            case 13: {
                raf = 131072;
                break;
            }
            case 14: {
                raf = 167432;
                break;
            }
            case 15: {
                raf = 671744;
                break;
            }
            case 16: {
                raf = 196614;
                break;
            }
            case 17: {
                raf = 737286;
                break;
            }
            case 18: {
                raf = 232974;
                break;
            }
            case 19: {
                raf = 708104;
                break;
            }
            case 20: {
                raf = 773646;
                break;
            }
            case 21: {
                raf = 245758;
                break;
            }
            case 22: {
                raf = 786430;
                break;
            }
            default: {
                raf = 1;
            }
        }
        return raf;
    }

    private static final int $$robo$$android_telephony_RadioAccessFamily$getAdjustedRaf(int raf) {
        raf = (0x10006 & raf) > 0 ? 0x10006 | raf : raf;
        raf = (0x8E08 & raf) > 0 ? 0x8E08 | raf : raf;
        raf = (0x70 & raf) > 0 ? 0x70 | raf : raf;
        raf = (0x3180 & raf) > 0 ? 0x3180 | raf : raf;
        raf = (0x84000 & raf) > 0 ? 0x84000 | raf : raf;
        return raf;
    }

    private static final int $$robo$$android_telephony_RadioAccessFamily$getHighestRafCapability(int raf) {
        if ((0x84000 & raf) > 0) {
            return 3;
        }
        if ((0xBF80 | 0x8E08 & raf) > 0) {
            return 2;
        }
        if ((0x10006 | 0x70 & raf) > 0) {
            return 1;
        }
        return 0;
    }

    private static final int $$robo$$android_telephony_RadioAccessFamily$getNetworkTypeFromRaf(int raf) {
        int type;
        raf = RadioAccessFamily.getAdjustedRaf(raf);
        switch (raf) {
            case 101902: {
                type = 0;
                break;
            }
            case 65542: {
                type = 1;
                break;
            }
            case 36360: {
                type = 2;
                break;
            }
            case 12784: {
                type = 4;
                break;
            }
            case 553456: {
                type = 8;
                break;
            }
            case 642574: {
                type = 9;
                break;
            }
            case 655358: {
                type = 10;
                break;
            }
            case 540672: {
                type = 11;
                break;
            }
            case 577032: {
                type = 12;
                break;
            }
            case 112: {
                type = 5;
                break;
            }
            case 12672: {
                type = 6;
                break;
            }
            case 114686: {
                type = 7;
                break;
            }
            case 131072: {
                type = 13;
                break;
            }
            case 167432: {
                type = 14;
                break;
            }
            case 671744: {
                type = 15;
                break;
            }
            case 196614: {
                type = 16;
                break;
            }
            case 737286: {
                type = 17;
                break;
            }
            case 232974: {
                type = 18;
                break;
            }
            case 708104: {
                type = 19;
                break;
            }
            case 773646: {
                type = 20;
                break;
            }
            case 245758: {
                type = 21;
                break;
            }
            case 786430: {
                type = 22;
                break;
            }
            default: {
                type = RILConstants.PREFERRED_NETWORK_MODE;
            }
        }
        return type;
    }

    private static final int $$robo$$android_telephony_RadioAccessFamily$singleRafTypeFromString(String rafString) {
        switch (rafString) {
            case "GPRS": {
                return 2;
            }
            case "EDGE": {
                return 4;
            }
            case "UMTS": {
                return 8;
            }
            case "IS95A": {
                return 16;
            }
            case "IS95B": {
                return 32;
            }
            case "1XRTT": {
                return 64;
            }
            case "EVDO_0": {
                return 128;
            }
            case "EVDO_A": {
                return 256;
            }
            case "HSDPA": {
                return 512;
            }
            case "HSUPA": {
                return 1024;
            }
            case "HSPA": {
                return 2048;
            }
            case "EVDO_B": {
                return 4096;
            }
            case "EHRPD": {
                return 8192;
            }
            case "LTE": {
                return 16384;
            }
            case "HSPAP": {
                return 32768;
            }
            case "GSM": {
                return 65536;
            }
            case "TD_SCDMA": {
                return 131072;
            }
            case "HS": {
                return 36352;
            }
            case "CDMA": {
                return 112;
            }
            case "EVDO": {
                return 12672;
            }
            case "WCDMA": {
                return 36360;
            }
            case "LTE_CA": {
                return 524288;
            }
        }
        return 1;
    }

    private static final int $$robo$$android_telephony_RadioAccessFamily$rafTypeFromString(String rafList) {
        rafList = rafList.toUpperCase();
        String[] rafs = rafList.split("\\|");
        int result = 0;
        for (String raf : rafs) {
            int rafType = RadioAccessFamily.singleRafTypeFromString(raf.trim());
            if (rafType == 1) {
                return rafType;
            }
            result |= rafType;
        }
        return result;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<RadioAccessFamily>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_RadioAccessFamily_1$__constructor__() {
            }

            private final RadioAccessFamily $$robo$$android_telephony_RadioAccessFamily_1$createFromParcel(Parcel in) {
                int phoneId = in.readInt();
                int radioAccessFamily = in.readInt();
                return new RadioAccessFamily(phoneId, radioAccessFamily);
            }

            private final RadioAccessFamily[] $$robo$$android_telephony_RadioAccessFamily_1$newArray(int size) {
                return new RadioAccessFamily[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_RadioAccessFamily_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_RadioAccessFamily_1$__constructor__(), 0, this);
            }

            @Override
            public RadioAccessFamily createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_RadioAccessFamily_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public RadioAccessFamily[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_RadioAccessFamily_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_telephony_RadioAccessFamily$__constructor__(n, n2);
    }

    public RadioAccessFamily(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_RadioAccessFamily$__constructor__(int int ), 0, this, n, n2);
    }

    public int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$android_telephony_RadioAccessFamily$getPhoneId(), 0, this);
    }

    public int getRadioAccessFamily() {
        return (int)InvokeDynamicSupport.bootstrap("getRadioAccessFamily", $$robo$$android_telephony_RadioAccessFamily$getRadioAccessFamily(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_RadioAccessFamily$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_RadioAccessFamily$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_RadioAccessFamily$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public static int getRafFromNetworkType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRafFromNetworkType", $$robo$$android_telephony_RadioAccessFamily$getRafFromNetworkType(int ), 0, (int)n);
    }

    private static int getAdjustedRaf(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAdjustedRaf", $$robo$$android_telephony_RadioAccessFamily$getAdjustedRaf(int ), 0, (int)n);
    }

    public static int getHighestRafCapability(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getHighestRafCapability", $$robo$$android_telephony_RadioAccessFamily$getHighestRafCapability(int ), 0, (int)n);
    }

    public static int getNetworkTypeFromRaf(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNetworkTypeFromRaf", $$robo$$android_telephony_RadioAccessFamily$getNetworkTypeFromRaf(int ), 0, (int)n);
    }

    public static int singleRafTypeFromString(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("singleRafTypeFromString", $$robo$$android_telephony_RadioAccessFamily$singleRafTypeFromString(java.lang.String ), 0, (String)string2);
    }

    public static int rafTypeFromString(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("rafTypeFromString", $$robo$$android_telephony_RadioAccessFamily$rafTypeFromString(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(RadioAccessFamily.class);
    }

    public /* synthetic */ RadioAccessFamily() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadioAccessFamily)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

