/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.AccessNetworkUtils;
import android.telephony.NetworkRegistrationState;
import android.telephony.Rlog;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ServiceState
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "PHONE";
    static boolean DBG = false;
    static boolean VDBG = false;
    public static int STATE_IN_SERVICE = 0;
    public static int STATE_OUT_OF_SERVICE = 1;
    public static int STATE_EMERGENCY_ONLY = 2;
    public static int STATE_POWER_OFF = 3;
    public static int DUPLEX_MODE_UNKNOWN = 0;
    public static int DUPLEX_MODE_FDD = 1;
    public static int DUPLEX_MODE_TDD = 2;
    public static int RIL_RADIO_TECHNOLOGY_UNKNOWN = 0;
    public static int RIL_RADIO_TECHNOLOGY_GPRS = 1;
    public static int RIL_RADIO_TECHNOLOGY_EDGE = 2;
    public static int RIL_RADIO_TECHNOLOGY_UMTS = 3;
    public static int RIL_RADIO_TECHNOLOGY_IS95A = 4;
    public static int RIL_RADIO_TECHNOLOGY_IS95B = 5;
    public static int RIL_RADIO_TECHNOLOGY_1xRTT = 6;
    public static int RIL_RADIO_TECHNOLOGY_EVDO_0 = 7;
    public static int RIL_RADIO_TECHNOLOGY_EVDO_A = 8;
    public static int RIL_RADIO_TECHNOLOGY_HSDPA = 9;
    public static int RIL_RADIO_TECHNOLOGY_HSUPA = 10;
    public static int RIL_RADIO_TECHNOLOGY_HSPA = 11;
    public static int RIL_RADIO_TECHNOLOGY_EVDO_B = 12;
    public static int RIL_RADIO_TECHNOLOGY_EHRPD = 13;
    public static int RIL_RADIO_TECHNOLOGY_LTE = 14;
    public static int RIL_RADIO_TECHNOLOGY_HSPAP = 15;
    public static int RIL_RADIO_TECHNOLOGY_GSM = 16;
    public static int RIL_RADIO_TECHNOLOGY_TD_SCDMA = 17;
    public static int RIL_RADIO_TECHNOLOGY_IWLAN = 18;
    public static int RIL_RADIO_TECHNOLOGY_LTE_CA = 19;
    private static int NEXT_RIL_RADIO_TECHNOLOGY = 20;
    public static int RIL_RADIO_CDMA_TECHNOLOGY_BITMASK = 6392;
    private int mVoiceRegState;
    private int mDataRegState;
    public static int ROAMING_TYPE_NOT_ROAMING = 0;
    public static int ROAMING_TYPE_UNKNOWN = 1;
    public static int ROAMING_TYPE_DOMESTIC = 2;
    public static int ROAMING_TYPE_INTERNATIONAL = 3;
    public static int UNKNOWN_ID = -1;
    private int mVoiceRoamingType;
    private int mDataRoamingType;
    private String mVoiceOperatorAlphaLong;
    private String mVoiceOperatorAlphaShort;
    private String mVoiceOperatorNumeric;
    private String mDataOperatorAlphaLong;
    private String mDataOperatorAlphaShort;
    private String mDataOperatorNumeric;
    private boolean mIsManualNetworkSelection;
    private boolean mIsEmergencyOnly;
    private int mRilVoiceRadioTechnology;
    private int mRilDataRadioTechnology;
    private boolean mCssIndicator;
    private int mNetworkId;
    private int mSystemId;
    private int mCdmaRoamingIndicator;
    private int mCdmaDefaultRoamingIndicator;
    private int mCdmaEriIconIndex;
    private int mCdmaEriIconMode;
    private boolean mIsDataRoamingFromRegistration;
    private boolean mIsUsingCarrierAggregation;
    private int mChannelNumber;
    private int[] mCellBandwidths;
    private int mLteEarfcnRsrpBoost;
    private List<NetworkRegistrationState> mNetworkRegistrationStates;
    public static Parcelable.Creator<ServiceState> CREATOR;

    private static final String $$robo$$android_telephony_ServiceState$getRoamingLogString(int roamingType) {
        switch (roamingType) {
            case 0: {
                return "home";
            }
            case 1: {
                return "roaming";
            }
            case 2: {
                return "Domestic Roaming";
            }
            case 3: {
                return "International Roaming";
            }
        }
        return "UNKNOWN";
    }

    private static final ServiceState $$robo$$android_telephony_ServiceState$newFromBundle(Bundle m) {
        ServiceState ret = new ServiceState();
        ret.setFromNotifierBundle(m);
        return ret;
    }

    private void $$robo$$android_telephony_ServiceState$__constructor__() {
        this.mVoiceRegState = 1;
        this.mDataRegState = 1;
        this.mCellBandwidths = new int[0];
        this.mLteEarfcnRsrpBoost = 0;
        this.mNetworkRegistrationStates = new ArrayList<NetworkRegistrationState>();
    }

    private void $$robo$$android_telephony_ServiceState$__constructor__(ServiceState s) {
        this.mVoiceRegState = 1;
        this.mDataRegState = 1;
        this.mCellBandwidths = new int[0];
        this.mLteEarfcnRsrpBoost = 0;
        this.mNetworkRegistrationStates = new ArrayList<NetworkRegistrationState>();
        this.copyFrom(s);
    }

    private final void $$robo$$android_telephony_ServiceState$copyFrom(ServiceState s) {
        this.mVoiceRegState = s.mVoiceRegState;
        this.mDataRegState = s.mDataRegState;
        this.mVoiceRoamingType = s.mVoiceRoamingType;
        this.mDataRoamingType = s.mDataRoamingType;
        this.mVoiceOperatorAlphaLong = s.mVoiceOperatorAlphaLong;
        this.mVoiceOperatorAlphaShort = s.mVoiceOperatorAlphaShort;
        this.mVoiceOperatorNumeric = s.mVoiceOperatorNumeric;
        this.mDataOperatorAlphaLong = s.mDataOperatorAlphaLong;
        this.mDataOperatorAlphaShort = s.mDataOperatorAlphaShort;
        this.mDataOperatorNumeric = s.mDataOperatorNumeric;
        this.mIsManualNetworkSelection = s.mIsManualNetworkSelection;
        this.mRilVoiceRadioTechnology = s.mRilVoiceRadioTechnology;
        this.mRilDataRadioTechnology = s.mRilDataRadioTechnology;
        this.mCssIndicator = s.mCssIndicator;
        this.mNetworkId = s.mNetworkId;
        this.mSystemId = s.mSystemId;
        this.mCdmaRoamingIndicator = s.mCdmaRoamingIndicator;
        this.mCdmaDefaultRoamingIndicator = s.mCdmaDefaultRoamingIndicator;
        this.mCdmaEriIconIndex = s.mCdmaEriIconIndex;
        this.mCdmaEriIconMode = s.mCdmaEriIconMode;
        this.mIsEmergencyOnly = s.mIsEmergencyOnly;
        this.mIsDataRoamingFromRegistration = s.mIsDataRoamingFromRegistration;
        this.mIsUsingCarrierAggregation = s.mIsUsingCarrierAggregation;
        this.mChannelNumber = s.mChannelNumber;
        this.mCellBandwidths = Arrays.copyOf(s.mCellBandwidths, s.mCellBandwidths.length);
        this.mLteEarfcnRsrpBoost = s.mLteEarfcnRsrpBoost;
        this.mNetworkRegistrationStates = new ArrayList<NetworkRegistrationState>(s.mNetworkRegistrationStates);
    }

    private void $$robo$$android_telephony_ServiceState$__constructor__(Parcel in) {
        this.mVoiceRegState = 1;
        this.mDataRegState = 1;
        this.mCellBandwidths = new int[0];
        this.mLteEarfcnRsrpBoost = 0;
        this.mNetworkRegistrationStates = new ArrayList<NetworkRegistrationState>();
        this.mVoiceRegState = in.readInt();
        this.mDataRegState = in.readInt();
        this.mVoiceRoamingType = in.readInt();
        this.mDataRoamingType = in.readInt();
        this.mVoiceOperatorAlphaLong = in.readString();
        this.mVoiceOperatorAlphaShort = in.readString();
        this.mVoiceOperatorNumeric = in.readString();
        this.mDataOperatorAlphaLong = in.readString();
        this.mDataOperatorAlphaShort = in.readString();
        this.mDataOperatorNumeric = in.readString();
        this.mIsManualNetworkSelection = in.readInt() != 0;
        this.mRilVoiceRadioTechnology = in.readInt();
        this.mRilDataRadioTechnology = in.readInt();
        this.mCssIndicator = in.readInt() != 0;
        this.mNetworkId = in.readInt();
        this.mSystemId = in.readInt();
        this.mCdmaRoamingIndicator = in.readInt();
        this.mCdmaDefaultRoamingIndicator = in.readInt();
        this.mCdmaEriIconIndex = in.readInt();
        this.mCdmaEriIconMode = in.readInt();
        this.mIsEmergencyOnly = in.readInt() != 0;
        this.mIsDataRoamingFromRegistration = in.readInt() != 0;
        this.mIsUsingCarrierAggregation = in.readInt() != 0;
        this.mLteEarfcnRsrpBoost = in.readInt();
        this.mNetworkRegistrationStates = new ArrayList<NetworkRegistrationState>();
        in.readList(this.mNetworkRegistrationStates, NetworkRegistrationState.class.getClassLoader());
        this.mChannelNumber = in.readInt();
        this.mCellBandwidths = in.createIntArray();
    }

    private final void $$robo$$android_telephony_ServiceState$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mVoiceRegState);
        out.writeInt(this.mDataRegState);
        out.writeInt(this.mVoiceRoamingType);
        out.writeInt(this.mDataRoamingType);
        out.writeString(this.mVoiceOperatorAlphaLong);
        out.writeString(this.mVoiceOperatorAlphaShort);
        out.writeString(this.mVoiceOperatorNumeric);
        out.writeString(this.mDataOperatorAlphaLong);
        out.writeString(this.mDataOperatorAlphaShort);
        out.writeString(this.mDataOperatorNumeric);
        out.writeInt(this.mIsManualNetworkSelection ? 1 : 0);
        out.writeInt(this.mRilVoiceRadioTechnology);
        out.writeInt(this.mRilDataRadioTechnology);
        out.writeInt(this.mCssIndicator ? 1 : 0);
        out.writeInt(this.mNetworkId);
        out.writeInt(this.mSystemId);
        out.writeInt(this.mCdmaRoamingIndicator);
        out.writeInt(this.mCdmaDefaultRoamingIndicator);
        out.writeInt(this.mCdmaEriIconIndex);
        out.writeInt(this.mCdmaEriIconMode);
        out.writeInt(this.mIsEmergencyOnly ? 1 : 0);
        out.writeInt(this.mIsDataRoamingFromRegistration ? 1 : 0);
        out.writeInt(this.mIsUsingCarrierAggregation ? 1 : 0);
        out.writeInt(this.mLteEarfcnRsrpBoost);
        out.writeList(this.mNetworkRegistrationStates);
        out.writeInt(this.mChannelNumber);
        out.writeIntArray(this.mCellBandwidths);
    }

    private final int $$robo$$android_telephony_ServiceState$describeContents() {
        return 0;
    }

    private final int $$robo$$android_telephony_ServiceState$getState() {
        return this.getVoiceRegState();
    }

    private final int $$robo$$android_telephony_ServiceState$getVoiceRegState() {
        return this.mVoiceRegState;
    }

    private final int $$robo$$android_telephony_ServiceState$getDataRegState() {
        return this.mDataRegState;
    }

    private final int $$robo$$android_telephony_ServiceState$getDuplexMode() {
        if (!ServiceState.isLte(this.mRilDataRadioTechnology)) {
            return 0;
        }
        int band = AccessNetworkUtils.getOperatingBandForEarfcn(this.mChannelNumber);
        return AccessNetworkUtils.getDuplexModeForEutranBand(band);
    }

    private final int $$robo$$android_telephony_ServiceState$getChannelNumber() {
        return this.mChannelNumber;
    }

    private final int[] $$robo$$android_telephony_ServiceState$getCellBandwidths() {
        return this.mCellBandwidths == null ? new int[]{} : this.mCellBandwidths;
    }

    private final boolean $$robo$$android_telephony_ServiceState$getRoaming() {
        return this.getVoiceRoaming() || this.getDataRoaming();
    }

    private final boolean $$robo$$android_telephony_ServiceState$getVoiceRoaming() {
        return this.mVoiceRoamingType != 0;
    }

    private final int $$robo$$android_telephony_ServiceState$getVoiceRoamingType() {
        return this.mVoiceRoamingType;
    }

    private final boolean $$robo$$android_telephony_ServiceState$getDataRoaming() {
        return this.mDataRoamingType != 0;
    }

    private final void $$robo$$android_telephony_ServiceState$setDataRoamingFromRegistration(boolean dataRoaming) {
        this.mIsDataRoamingFromRegistration = dataRoaming;
    }

    private final boolean $$robo$$android_telephony_ServiceState$getDataRoamingFromRegistration() {
        return this.mIsDataRoamingFromRegistration;
    }

    private final int $$robo$$android_telephony_ServiceState$getDataRoamingType() {
        return this.mDataRoamingType;
    }

    private final boolean $$robo$$android_telephony_ServiceState$isEmergencyOnly() {
        return this.mIsEmergencyOnly;
    }

    private final int $$robo$$android_telephony_ServiceState$getCdmaRoamingIndicator() {
        return this.mCdmaRoamingIndicator;
    }

    private final int $$robo$$android_telephony_ServiceState$getCdmaDefaultRoamingIndicator() {
        return this.mCdmaDefaultRoamingIndicator;
    }

    private final int $$robo$$android_telephony_ServiceState$getCdmaEriIconIndex() {
        return this.mCdmaEriIconIndex;
    }

    private final int $$robo$$android_telephony_ServiceState$getCdmaEriIconMode() {
        return this.mCdmaEriIconMode;
    }

    private final String $$robo$$android_telephony_ServiceState$getOperatorAlphaLong() {
        return this.mVoiceOperatorAlphaLong;
    }

    private final String $$robo$$android_telephony_ServiceState$getVoiceOperatorAlphaLong() {
        return this.mVoiceOperatorAlphaLong;
    }

    private final String $$robo$$android_telephony_ServiceState$getDataOperatorAlphaLong() {
        return this.mDataOperatorAlphaLong;
    }

    private final String $$robo$$android_telephony_ServiceState$getOperatorAlphaShort() {
        return this.mVoiceOperatorAlphaShort;
    }

    private final String $$robo$$android_telephony_ServiceState$getVoiceOperatorAlphaShort() {
        return this.mVoiceOperatorAlphaShort;
    }

    private final String $$robo$$android_telephony_ServiceState$getDataOperatorAlphaShort() {
        return this.mDataOperatorAlphaShort;
    }

    private final String $$robo$$android_telephony_ServiceState$getOperatorAlpha() {
        if (TextUtils.isEmpty(this.mVoiceOperatorAlphaLong)) {
            return this.mVoiceOperatorAlphaShort;
        }
        return this.mVoiceOperatorAlphaLong;
    }

    private final String $$robo$$android_telephony_ServiceState$getOperatorNumeric() {
        return this.mVoiceOperatorNumeric;
    }

    private final String $$robo$$android_telephony_ServiceState$getVoiceOperatorNumeric() {
        return this.mVoiceOperatorNumeric;
    }

    private final String $$robo$$android_telephony_ServiceState$getDataOperatorNumeric() {
        return this.mDataOperatorNumeric;
    }

    private final boolean $$robo$$android_telephony_ServiceState$getIsManualSelection() {
        return this.mIsManualNetworkSelection;
    }

    private final int $$robo$$android_telephony_ServiceState$hashCode() {
        return this.mVoiceRegState * 31 + this.mDataRegState * 37 + this.mVoiceRoamingType + this.mDataRoamingType + this.mChannelNumber + Arrays.hashCode(this.mCellBandwidths) + (this.mIsManualNetworkSelection ? 1 : 0) + (null == this.mVoiceOperatorAlphaLong ? 0 : this.mVoiceOperatorAlphaLong.hashCode()) + (null == this.mVoiceOperatorAlphaShort ? 0 : this.mVoiceOperatorAlphaShort.hashCode()) + (null == this.mVoiceOperatorNumeric ? 0 : this.mVoiceOperatorNumeric.hashCode()) + (null == this.mDataOperatorAlphaLong ? 0 : this.mDataOperatorAlphaLong.hashCode()) + (null == this.mDataOperatorAlphaShort ? 0 : this.mDataOperatorAlphaShort.hashCode()) + (null == this.mDataOperatorNumeric ? 0 : this.mDataOperatorNumeric.hashCode()) + this.mCdmaRoamingIndicator + this.mCdmaDefaultRoamingIndicator + (this.mIsEmergencyOnly ? 1 : 0) + (this.mIsDataRoamingFromRegistration ? 1 : 0);
    }

    private final boolean $$robo$$android_telephony_ServiceState$equals(Object o) {
        ServiceState s;
        try {
            s = (ServiceState)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mVoiceRegState == s.mVoiceRegState && this.mDataRegState == s.mDataRegState && this.mIsManualNetworkSelection == s.mIsManualNetworkSelection && this.mVoiceRoamingType == s.mVoiceRoamingType && this.mDataRoamingType == s.mDataRoamingType && this.mChannelNumber == s.mChannelNumber && Arrays.equals(this.mCellBandwidths, s.mCellBandwidths) && ServiceState.equalsHandlesNulls(this.mVoiceOperatorAlphaLong, s.mVoiceOperatorAlphaLong) && ServiceState.equalsHandlesNulls(this.mVoiceOperatorAlphaShort, s.mVoiceOperatorAlphaShort) && ServiceState.equalsHandlesNulls(this.mVoiceOperatorNumeric, s.mVoiceOperatorNumeric) && ServiceState.equalsHandlesNulls(this.mDataOperatorAlphaLong, s.mDataOperatorAlphaLong) && ServiceState.equalsHandlesNulls(this.mDataOperatorAlphaShort, s.mDataOperatorAlphaShort) && ServiceState.equalsHandlesNulls(this.mDataOperatorNumeric, s.mDataOperatorNumeric) && ServiceState.equalsHandlesNulls(this.mRilVoiceRadioTechnology, s.mRilVoiceRadioTechnology) && ServiceState.equalsHandlesNulls(this.mRilDataRadioTechnology, s.mRilDataRadioTechnology) && ServiceState.equalsHandlesNulls(this.mCssIndicator, s.mCssIndicator) && ServiceState.equalsHandlesNulls(this.mNetworkId, s.mNetworkId) && ServiceState.equalsHandlesNulls(this.mSystemId, s.mSystemId) && ServiceState.equalsHandlesNulls(this.mCdmaRoamingIndicator, s.mCdmaRoamingIndicator) && ServiceState.equalsHandlesNulls(this.mCdmaDefaultRoamingIndicator, s.mCdmaDefaultRoamingIndicator) && this.mIsEmergencyOnly == s.mIsEmergencyOnly && this.mIsDataRoamingFromRegistration == s.mIsDataRoamingFromRegistration && this.mIsUsingCarrierAggregation == s.mIsUsingCarrierAggregation && this.mNetworkRegistrationStates.containsAll(s.mNetworkRegistrationStates);
    }

    private static final String $$robo$$android_telephony_ServiceState$rilRadioTechnologyToString(int rt) {
        String rtString;
        switch (rt) {
            case 0: {
                rtString = "Unknown";
                break;
            }
            case 1: {
                rtString = "GPRS";
                break;
            }
            case 2: {
                rtString = "EDGE";
                break;
            }
            case 3: {
                rtString = "UMTS";
                break;
            }
            case 4: {
                rtString = "CDMA-IS95A";
                break;
            }
            case 5: {
                rtString = "CDMA-IS95B";
                break;
            }
            case 6: {
                rtString = "1xRTT";
                break;
            }
            case 7: {
                rtString = "EvDo-rev.0";
                break;
            }
            case 8: {
                rtString = "EvDo-rev.A";
                break;
            }
            case 9: {
                rtString = "HSDPA";
                break;
            }
            case 10: {
                rtString = "HSUPA";
                break;
            }
            case 11: {
                rtString = "HSPA";
                break;
            }
            case 12: {
                rtString = "EvDo-rev.B";
                break;
            }
            case 13: {
                rtString = "eHRPD";
                break;
            }
            case 14: {
                rtString = "LTE";
                break;
            }
            case 15: {
                rtString = "HSPAP";
                break;
            }
            case 16: {
                rtString = "GSM";
                break;
            }
            case 18: {
                rtString = "IWLAN";
                break;
            }
            case 17: {
                rtString = "TD-SCDMA";
                break;
            }
            case 19: {
                rtString = "LTE_CA";
                break;
            }
            default: {
                rtString = "Unexpected";
                Rlog.w("PHONE", "Unexpected radioTechnology=" + rt);
            }
        }
        return rtString;
    }

    private static final String $$robo$$android_telephony_ServiceState$rilServiceStateToString(int serviceState) {
        switch (serviceState) {
            case 0: {
                return "IN_SERVICE";
            }
            case 1: {
                return "OUT_OF_SERVICE";
            }
            case 2: {
                return "EMERGENCY_ONLY";
            }
            case 3: {
                return "POWER_OFF";
            }
        }
        return "UNKNOWN";
    }

    private final String $$robo$$android_telephony_ServiceState$toString() {
        return "{mVoiceRegState=" + this.mVoiceRegState + ("(" + ServiceState.rilServiceStateToString(this.mVoiceRegState) + ")") + ", mDataRegState=" + this.mDataRegState + ("(" + ServiceState.rilServiceStateToString(this.mDataRegState) + ")") + ", mChannelNumber=" + this.mChannelNumber + ", duplexMode()=" + this.getDuplexMode() + ", mCellBandwidths=" + Arrays.toString(this.mCellBandwidths) + ", mVoiceRoamingType=" + ServiceState.getRoamingLogString(this.mVoiceRoamingType) + ", mDataRoamingType=" + ServiceState.getRoamingLogString(this.mDataRoamingType) + ", mVoiceOperatorAlphaLong=" + this.mVoiceOperatorAlphaLong + ", mVoiceOperatorAlphaShort=" + this.mVoiceOperatorAlphaShort + ", mDataOperatorAlphaLong=" + this.mDataOperatorAlphaLong + ", mDataOperatorAlphaShort=" + this.mDataOperatorAlphaShort + ", isManualNetworkSelection=" + this.mIsManualNetworkSelection + (this.mIsManualNetworkSelection ? "(manual)" : "(automatic)") + ", mRilVoiceRadioTechnology=" + this.mRilVoiceRadioTechnology + ("(" + ServiceState.rilRadioTechnologyToString(this.mRilVoiceRadioTechnology) + ")") + ", mRilDataRadioTechnology=" + this.mRilDataRadioTechnology + ("(" + ServiceState.rilRadioTechnologyToString(this.mRilDataRadioTechnology) + ")") + ", mCssIndicator=" + (this.mCssIndicator ? "supported" : "unsupported") + ", mNetworkId=" + this.mNetworkId + ", mSystemId=" + this.mSystemId + ", mCdmaRoamingIndicator=" + this.mCdmaRoamingIndicator + ", mCdmaDefaultRoamingIndicator=" + this.mCdmaDefaultRoamingIndicator + ", mIsEmergencyOnly=" + this.mIsEmergencyOnly + ", mIsDataRoamingFromRegistration=" + this.mIsDataRoamingFromRegistration + ", mIsUsingCarrierAggregation=" + this.mIsUsingCarrierAggregation + ", mLteEarfcnRsrpBoost=" + this.mLteEarfcnRsrpBoost + ", mNetworkRegistrationStates=" + this.mNetworkRegistrationStates + "}";
    }

    private final void $$robo$$android_telephony_ServiceState$setNullState(int state) {
        this.mVoiceRegState = state;
        this.mDataRegState = state;
        this.mVoiceRoamingType = 0;
        this.mDataRoamingType = 0;
        this.mChannelNumber = -1;
        this.mCellBandwidths = new int[0];
        this.mVoiceOperatorAlphaLong = null;
        this.mVoiceOperatorAlphaShort = null;
        this.mVoiceOperatorNumeric = null;
        this.mDataOperatorAlphaLong = null;
        this.mDataOperatorAlphaShort = null;
        this.mDataOperatorNumeric = null;
        this.mIsManualNetworkSelection = false;
        this.mRilVoiceRadioTechnology = 0;
        this.mRilDataRadioTechnology = 0;
        this.mCssIndicator = false;
        this.mNetworkId = -1;
        this.mSystemId = -1;
        this.mCdmaRoamingIndicator = -1;
        this.mCdmaDefaultRoamingIndicator = -1;
        this.mCdmaEriIconIndex = -1;
        this.mCdmaEriIconMode = -1;
        this.mIsEmergencyOnly = false;
        this.mIsDataRoamingFromRegistration = false;
        this.mIsUsingCarrierAggregation = false;
        this.mLteEarfcnRsrpBoost = 0;
        this.mNetworkRegistrationStates = new ArrayList<NetworkRegistrationState>();
    }

    private final void $$robo$$android_telephony_ServiceState$setStateOutOfService() {
        this.setNullState(1);
    }

    private final void $$robo$$android_telephony_ServiceState$setStateOff() {
        this.setNullState(3);
    }

    private final void $$robo$$android_telephony_ServiceState$setState(int state) {
        this.setVoiceRegState(state);
    }

    private final void $$robo$$android_telephony_ServiceState$setVoiceRegState(int state) {
        this.mVoiceRegState = state;
    }

    private final void $$robo$$android_telephony_ServiceState$setDataRegState(int state) {
        this.mDataRegState = state;
    }

    private final void $$robo$$android_telephony_ServiceState$setCellBandwidths(int[] bandwidths) {
        this.mCellBandwidths = bandwidths;
    }

    private final void $$robo$$android_telephony_ServiceState$setChannelNumber(int channelNumber) {
        this.mChannelNumber = channelNumber;
    }

    private final void $$robo$$android_telephony_ServiceState$setRoaming(boolean roaming) {
        this.mDataRoamingType = this.mVoiceRoamingType = roaming ? 1 : 0;
    }

    private final void $$robo$$android_telephony_ServiceState$setVoiceRoaming(boolean roaming) {
        this.mVoiceRoamingType = roaming ? 1 : 0;
    }

    private final void $$robo$$android_telephony_ServiceState$setVoiceRoamingType(int type) {
        this.mVoiceRoamingType = type;
    }

    private final void $$robo$$android_telephony_ServiceState$setDataRoaming(boolean dataRoaming) {
        this.mDataRoamingType = dataRoaming ? 1 : 0;
    }

    private final void $$robo$$android_telephony_ServiceState$setDataRoamingType(int type) {
        this.mDataRoamingType = type;
    }

    private final void $$robo$$android_telephony_ServiceState$setEmergencyOnly(boolean emergencyOnly) {
        this.mIsEmergencyOnly = emergencyOnly;
    }

    private final void $$robo$$android_telephony_ServiceState$setCdmaRoamingIndicator(int roaming) {
        this.mCdmaRoamingIndicator = roaming;
    }

    private final void $$robo$$android_telephony_ServiceState$setCdmaDefaultRoamingIndicator(int roaming) {
        this.mCdmaDefaultRoamingIndicator = roaming;
    }

    private final void $$robo$$android_telephony_ServiceState$setCdmaEriIconIndex(int index) {
        this.mCdmaEriIconIndex = index;
    }

    private final void $$robo$$android_telephony_ServiceState$setCdmaEriIconMode(int mode) {
        this.mCdmaEriIconMode = mode;
    }

    private final void $$robo$$android_telephony_ServiceState$setOperatorName(String longName, String shortName, String numeric) {
        this.mVoiceOperatorAlphaLong = longName;
        this.mVoiceOperatorAlphaShort = shortName;
        this.mVoiceOperatorNumeric = numeric;
        this.mDataOperatorAlphaLong = longName;
        this.mDataOperatorAlphaShort = shortName;
        this.mDataOperatorNumeric = numeric;
    }

    private final void $$robo$$android_telephony_ServiceState$setVoiceOperatorName(String longName, String shortName, String numeric) {
        this.mVoiceOperatorAlphaLong = longName;
        this.mVoiceOperatorAlphaShort = shortName;
        this.mVoiceOperatorNumeric = numeric;
    }

    private final void $$robo$$android_telephony_ServiceState$setDataOperatorName(String longName, String shortName, String numeric) {
        this.mDataOperatorAlphaLong = longName;
        this.mDataOperatorAlphaShort = shortName;
        this.mDataOperatorNumeric = numeric;
    }

    private final void $$robo$$android_telephony_ServiceState$setOperatorAlphaLong(String longName) {
        this.mVoiceOperatorAlphaLong = longName;
        this.mDataOperatorAlphaLong = longName;
    }

    private final void $$robo$$android_telephony_ServiceState$setVoiceOperatorAlphaLong(String longName) {
        this.mVoiceOperatorAlphaLong = longName;
    }

    private final void $$robo$$android_telephony_ServiceState$setDataOperatorAlphaLong(String longName) {
        this.mDataOperatorAlphaLong = longName;
    }

    private final void $$robo$$android_telephony_ServiceState$setIsManualSelection(boolean isManual) {
        this.mIsManualNetworkSelection = isManual;
    }

    private static final boolean $$robo$$android_telephony_ServiceState$equalsHandlesNulls(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private final void $$robo$$android_telephony_ServiceState$setFromNotifierBundle(Bundle m) {
        this.mVoiceRegState = m.getInt("voiceRegState");
        this.mDataRegState = m.getInt("dataRegState");
        this.mVoiceRoamingType = m.getInt("voiceRoamingType");
        this.mDataRoamingType = m.getInt("dataRoamingType");
        this.mVoiceOperatorAlphaLong = m.getString("operator-alpha-long");
        this.mVoiceOperatorAlphaShort = m.getString("operator-alpha-short");
        this.mVoiceOperatorNumeric = m.getString("operator-numeric");
        this.mDataOperatorAlphaLong = m.getString("data-operator-alpha-long");
        this.mDataOperatorAlphaShort = m.getString("data-operator-alpha-short");
        this.mDataOperatorNumeric = m.getString("data-operator-numeric");
        this.mIsManualNetworkSelection = m.getBoolean("manual");
        this.mRilVoiceRadioTechnology = m.getInt("radioTechnology");
        this.mRilDataRadioTechnology = m.getInt("dataRadioTechnology");
        this.mCssIndicator = m.getBoolean("cssIndicator");
        this.mNetworkId = m.getInt("networkId");
        this.mSystemId = m.getInt("systemId");
        this.mCdmaRoamingIndicator = m.getInt("cdmaRoamingIndicator");
        this.mCdmaDefaultRoamingIndicator = m.getInt("cdmaDefaultRoamingIndicator");
        this.mIsEmergencyOnly = m.getBoolean("emergencyOnly");
        this.mIsDataRoamingFromRegistration = m.getBoolean("isDataRoamingFromRegistration");
        this.mIsUsingCarrierAggregation = m.getBoolean("isUsingCarrierAggregation");
        this.mLteEarfcnRsrpBoost = m.getInt("LteEarfcnRsrpBoost");
        this.mChannelNumber = m.getInt("ChannelNumber");
        this.mCellBandwidths = m.getIntArray("CellBandwidths");
    }

    private final void $$robo$$android_telephony_ServiceState$fillInNotifierBundle(Bundle m) {
        m.putInt("voiceRegState", this.mVoiceRegState);
        m.putInt("dataRegState", this.mDataRegState);
        m.putInt("voiceRoamingType", this.mVoiceRoamingType);
        m.putInt("dataRoamingType", this.mDataRoamingType);
        m.putString("operator-alpha-long", this.mVoiceOperatorAlphaLong);
        m.putString("operator-alpha-short", this.mVoiceOperatorAlphaShort);
        m.putString("operator-numeric", this.mVoiceOperatorNumeric);
        m.putString("data-operator-alpha-long", this.mDataOperatorAlphaLong);
        m.putString("data-operator-alpha-short", this.mDataOperatorAlphaShort);
        m.putString("data-operator-numeric", this.mDataOperatorNumeric);
        m.putBoolean("manual", this.mIsManualNetworkSelection);
        m.putInt("radioTechnology", this.mRilVoiceRadioTechnology);
        m.putInt("dataRadioTechnology", this.mRilDataRadioTechnology);
        m.putBoolean("cssIndicator", this.mCssIndicator);
        m.putInt("networkId", this.mNetworkId);
        m.putInt("systemId", this.mSystemId);
        m.putInt("cdmaRoamingIndicator", this.mCdmaRoamingIndicator);
        m.putInt("cdmaDefaultRoamingIndicator", this.mCdmaDefaultRoamingIndicator);
        m.putBoolean("emergencyOnly", this.mIsEmergencyOnly);
        m.putBoolean("isDataRoamingFromRegistration", this.mIsDataRoamingFromRegistration);
        m.putBoolean("isUsingCarrierAggregation", this.mIsUsingCarrierAggregation);
        m.putInt("LteEarfcnRsrpBoost", this.mLteEarfcnRsrpBoost);
        m.putInt("ChannelNumber", this.mChannelNumber);
        m.putIntArray("CellBandwidths", this.mCellBandwidths);
    }

    private final void $$robo$$android_telephony_ServiceState$setRilVoiceRadioTechnology(int rt) {
        if (rt == 19) {
            rt = 14;
        }
        this.mRilVoiceRadioTechnology = rt;
    }

    private final void $$robo$$android_telephony_ServiceState$setRilDataRadioTechnology(int rt) {
        if (rt == 19) {
            rt = 14;
            this.mIsUsingCarrierAggregation = true;
        } else {
            this.mIsUsingCarrierAggregation = false;
        }
        this.mRilDataRadioTechnology = rt;
    }

    private final boolean $$robo$$android_telephony_ServiceState$isUsingCarrierAggregation() {
        return this.mIsUsingCarrierAggregation;
    }

    private final void $$robo$$android_telephony_ServiceState$setIsUsingCarrierAggregation(boolean ca) {
        this.mIsUsingCarrierAggregation = ca;
    }

    private final int $$robo$$android_telephony_ServiceState$getLteEarfcnRsrpBoost() {
        return this.mLteEarfcnRsrpBoost;
    }

    private final void $$robo$$android_telephony_ServiceState$setLteEarfcnRsrpBoost(int LteEarfcnRsrpBoost) {
        this.mLteEarfcnRsrpBoost = LteEarfcnRsrpBoost;
    }

    private final void $$robo$$android_telephony_ServiceState$setCssIndicator(int css) {
        this.mCssIndicator = css != 0;
    }

    private final void $$robo$$android_telephony_ServiceState$setCdmaSystemAndNetworkId(int systemId, int networkId) {
        this.mSystemId = systemId;
        this.mNetworkId = networkId;
    }

    private final int $$robo$$android_telephony_ServiceState$getRilVoiceRadioTechnology() {
        return this.mRilVoiceRadioTechnology;
    }

    private final int $$robo$$android_telephony_ServiceState$getRilDataRadioTechnology() {
        return this.mRilDataRadioTechnology;
    }

    private final int $$robo$$android_telephony_ServiceState$getRadioTechnology() {
        Rlog.e("PHONE", "ServiceState.getRadioTechnology() DEPRECATED will be removed *******");
        return this.getRilDataRadioTechnology();
    }

    private static final int $$robo$$android_telephony_ServiceState$rilRadioTechnologyToNetworkType(int rt) {
        switch (rt) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 4: 
            case 5: {
                return 4;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 14;
            }
            case 14: {
                return 13;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
        }
        return 0;
    }

    private static final int $$robo$$android_telephony_ServiceState$rilRadioTechnologyToAccessNetworkType(int rt) {
        switch (rt) {
            case 1: 
            case 2: 
            case 16: {
                return 1;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                return 4;
            }
            case 14: 
            case 19: {
                return 3;
            }
            case 18: {
                return 5;
            }
        }
        return 0;
    }

    private static final int $$robo$$android_telephony_ServiceState$networkTypeToRilRadioTechnology(int networkType) {
        switch (networkType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 8;
            }
            case 12: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 13: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
        }
        return 0;
    }

    private final int $$robo$$android_telephony_ServiceState$getDataNetworkType() {
        return ServiceState.rilRadioTechnologyToNetworkType(this.mRilDataRadioTechnology);
    }

    private final int $$robo$$android_telephony_ServiceState$getVoiceNetworkType() {
        return ServiceState.rilRadioTechnologyToNetworkType(this.mRilVoiceRadioTechnology);
    }

    private final int $$robo$$android_telephony_ServiceState$getCssIndicator() {
        return this.mCssIndicator ? 1 : 0;
    }

    private final int $$robo$$android_telephony_ServiceState$getCdmaNetworkId() {
        return this.mNetworkId;
    }

    private final int $$robo$$android_telephony_ServiceState$getCdmaSystemId() {
        return this.mSystemId;
    }

    private static final boolean $$robo$$android_telephony_ServiceState$isGsm(int radioTechnology) {
        return radioTechnology == 1 || radioTechnology == 2 || radioTechnology == 3 || radioTechnology == 9 || radioTechnology == 10 || radioTechnology == 11 || radioTechnology == 14 || radioTechnology == 15 || radioTechnology == 16 || radioTechnology == 17 || radioTechnology == 18 || radioTechnology == 19;
    }

    private static final boolean $$robo$$android_telephony_ServiceState$isCdma(int radioTechnology) {
        return radioTechnology == 4 || radioTechnology == 5 || radioTechnology == 6 || radioTechnology == 7 || radioTechnology == 8 || radioTechnology == 12 || radioTechnology == 13;
    }

    private static final boolean $$robo$$android_telephony_ServiceState$isLte(int radioTechnology) {
        return radioTechnology == 14 || radioTechnology == 19;
    }

    private static final boolean $$robo$$android_telephony_ServiceState$bearerBitmapHasCdma(int radioTechnologyBitmap) {
        return (0x18F8 & radioTechnologyBitmap) != 0;
    }

    private static final boolean $$robo$$android_telephony_ServiceState$bitmaskHasTech(int bearerBitmask, int radioTech) {
        if (bearerBitmask == 0) {
            return true;
        }
        if (radioTech >= 1) {
            return (bearerBitmask & 1 << radioTech - 1) != 0;
        }
        return false;
    }

    private static final int $$robo$$android_telephony_ServiceState$getBitmaskForTech(int radioTech) {
        if (radioTech >= 1) {
            return 1 << radioTech - 1;
        }
        return 0;
    }

    private static final int $$robo$$android_telephony_ServiceState$getBitmaskFromString(String bearerList) {
        String[] bearers = bearerList.split("\\|");
        int bearerBitmask = 0;
        for (String bearer : bearers) {
            int bearerInt = 0;
            try {
                bearerInt = Integer.parseInt(bearer.trim());
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
            if (bearerInt == 0) {
                return 0;
            }
            bearerBitmask |= ServiceState.getBitmaskForTech(bearerInt);
        }
        return bearerBitmask;
    }

    private static final int $$robo$$android_telephony_ServiceState$convertNetworkTypeBitmaskToBearerBitmask(int networkTypeBitmask) {
        if (networkTypeBitmask == 0) {
            return 0;
        }
        int bearerBitmask = 0;
        for (int bearerInt = 0; bearerInt < 20; ++bearerInt) {
            if (!ServiceState.bitmaskHasTech(networkTypeBitmask, ServiceState.rilRadioTechnologyToNetworkType(bearerInt))) continue;
            bearerBitmask |= ServiceState.getBitmaskForTech(bearerInt);
        }
        return bearerBitmask;
    }

    private static final int $$robo$$android_telephony_ServiceState$convertBearerBitmaskToNetworkTypeBitmask(int bearerBitmask) {
        if (bearerBitmask == 0) {
            return 0;
        }
        int networkTypeBitmask = 0;
        for (int bearerInt = 0; bearerInt < 20; ++bearerInt) {
            if (!ServiceState.bitmaskHasTech(bearerBitmask, bearerInt)) continue;
            networkTypeBitmask |= ServiceState.getBitmaskForTech(ServiceState.rilRadioTechnologyToNetworkType(bearerInt));
        }
        return networkTypeBitmask;
    }

    private static final ServiceState $$robo$$android_telephony_ServiceState$mergeServiceStates(ServiceState baseSs, ServiceState voiceSs) {
        if (voiceSs.mVoiceRegState != 0) {
            return baseSs;
        }
        ServiceState newSs = new ServiceState(baseSs);
        newSs.mVoiceRegState = voiceSs.mVoiceRegState;
        newSs.mIsEmergencyOnly = false;
        return newSs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<NetworkRegistrationState> $$robo$$android_telephony_ServiceState$getNetworkRegistrationStates() {
        List<NetworkRegistrationState> list = this.mNetworkRegistrationStates;
        synchronized (list) {
            return new ArrayList<NetworkRegistrationState>(this.mNetworkRegistrationStates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<NetworkRegistrationState> $$robo$$android_telephony_ServiceState$getNetworkRegistrationStates(int transportType) {
        ArrayList<NetworkRegistrationState> list = new ArrayList<NetworkRegistrationState>();
        List<NetworkRegistrationState> list2 = this.mNetworkRegistrationStates;
        synchronized (list2) {
            for (NetworkRegistrationState networkRegistrationState : this.mNetworkRegistrationStates) {
                if (networkRegistrationState.getTransportType() != transportType) continue;
                list.add(networkRegistrationState);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkRegistrationState $$robo$$android_telephony_ServiceState$getNetworkRegistrationStates(int transportType, int domain) {
        List<NetworkRegistrationState> list = this.mNetworkRegistrationStates;
        synchronized (list) {
            for (NetworkRegistrationState networkRegistrationState : this.mNetworkRegistrationStates) {
                if (networkRegistrationState.getTransportType() != transportType || networkRegistrationState.getDomain() != domain) continue;
                return networkRegistrationState;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ServiceState$addNetworkRegistrationState(NetworkRegistrationState regState) {
        if (regState == null) {
            return;
        }
        List<NetworkRegistrationState> list = this.mNetworkRegistrationStates;
        synchronized (list) {
            for (int i = 0; i < this.mNetworkRegistrationStates.size(); ++i) {
                NetworkRegistrationState curRegState = this.mNetworkRegistrationStates.get(i);
                if (curRegState.getTransportType() != regState.getTransportType() || curRegState.getDomain() != regState.getDomain()) continue;
                this.mNetworkRegistrationStates.remove(i);
                break;
            }
            this.mNetworkRegistrationStates.add(regState);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ServiceState>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_ServiceState_1$__constructor__() {
            }

            private final ServiceState $$robo$$android_telephony_ServiceState_1$createFromParcel(Parcel in) {
                return new ServiceState(in);
            }

            private final ServiceState[] $$robo$$android_telephony_ServiceState_1$newArray(int size) {
                return new ServiceState[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_ServiceState_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ServiceState_1$__constructor__(), 0, this);
            }

            @Override
            public ServiceState createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_ServiceState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ServiceState[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_ServiceState_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static String getRoamingLogString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRoamingLogString", $$robo$$android_telephony_ServiceState$getRoamingLogString(int ), 0, (int)n);
    }

    public static ServiceState newFromBundle(Bundle bundle) {
        return InvokeDynamicSupport.bootstrapStatic("newFromBundle", $$robo$$android_telephony_ServiceState$newFromBundle(android.os.Bundle ), 0, (Bundle)bundle);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_ServiceState$__constructor__();
    }

    public ServiceState() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ServiceState$__constructor__(), 0, this);
    }

    private void __constructor__(ServiceState serviceState) {
        this.$$robo$$android_telephony_ServiceState$__constructor__(serviceState);
    }

    public ServiceState(ServiceState serviceState) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ServiceState$__constructor__(android.telephony.ServiceState ), 0, this, serviceState);
    }

    protected void copyFrom(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_telephony_ServiceState$copyFrom(android.telephony.ServiceState ), 0, this, serviceState);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_ServiceState$__constructor__(parcel);
    }

    public ServiceState(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ServiceState$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_ServiceState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_ServiceState$describeContents(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telephony_ServiceState$getState(), 0, this);
    }

    public int getVoiceRegState() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceRegState", $$robo$$android_telephony_ServiceState$getVoiceRegState(), 0, this);
    }

    public int getDataRegState() {
        return (int)InvokeDynamicSupport.bootstrap("getDataRegState", $$robo$$android_telephony_ServiceState$getDataRegState(), 0, this);
    }

    public int getDuplexMode() {
        return (int)InvokeDynamicSupport.bootstrap("getDuplexMode", $$robo$$android_telephony_ServiceState$getDuplexMode(), 0, this);
    }

    public int getChannelNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getChannelNumber", $$robo$$android_telephony_ServiceState$getChannelNumber(), 0, this);
    }

    public int[] getCellBandwidths() {
        return InvokeDynamicSupport.bootstrap("getCellBandwidths", $$robo$$android_telephony_ServiceState$getCellBandwidths(), 0, this);
    }

    public boolean getRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("getRoaming", $$robo$$android_telephony_ServiceState$getRoaming(), 0, this);
    }

    public boolean getVoiceRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("getVoiceRoaming", $$robo$$android_telephony_ServiceState$getVoiceRoaming(), 0, this);
    }

    public int getVoiceRoamingType() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceRoamingType", $$robo$$android_telephony_ServiceState$getVoiceRoamingType(), 0, this);
    }

    public boolean getDataRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataRoaming", $$robo$$android_telephony_ServiceState$getDataRoaming(), 0, this);
    }

    public void setDataRoamingFromRegistration(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataRoamingFromRegistration", $$robo$$android_telephony_ServiceState$setDataRoamingFromRegistration(boolean ), 0, this, bl);
    }

    public boolean getDataRoamingFromRegistration() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataRoamingFromRegistration", $$robo$$android_telephony_ServiceState$getDataRoamingFromRegistration(), 0, this);
    }

    public int getDataRoamingType() {
        return (int)InvokeDynamicSupport.bootstrap("getDataRoamingType", $$robo$$android_telephony_ServiceState$getDataRoamingType(), 0, this);
    }

    public boolean isEmergencyOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergencyOnly", $$robo$$android_telephony_ServiceState$isEmergencyOnly(), 0, this);
    }

    public int getCdmaRoamingIndicator() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaRoamingIndicator", $$robo$$android_telephony_ServiceState$getCdmaRoamingIndicator(), 0, this);
    }

    public int getCdmaDefaultRoamingIndicator() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaDefaultRoamingIndicator", $$robo$$android_telephony_ServiceState$getCdmaDefaultRoamingIndicator(), 0, this);
    }

    public int getCdmaEriIconIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$android_telephony_ServiceState$getCdmaEriIconIndex(), 0, this);
    }

    public int getCdmaEriIconMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$android_telephony_ServiceState$getCdmaEriIconMode(), 0, this);
    }

    public String getOperatorAlphaLong() {
        return InvokeDynamicSupport.bootstrap("getOperatorAlphaLong", $$robo$$android_telephony_ServiceState$getOperatorAlphaLong(), 0, this);
    }

    public String getVoiceOperatorAlphaLong() {
        return InvokeDynamicSupport.bootstrap("getVoiceOperatorAlphaLong", $$robo$$android_telephony_ServiceState$getVoiceOperatorAlphaLong(), 0, this);
    }

    public String getDataOperatorAlphaLong() {
        return InvokeDynamicSupport.bootstrap("getDataOperatorAlphaLong", $$robo$$android_telephony_ServiceState$getDataOperatorAlphaLong(), 0, this);
    }

    public String getOperatorAlphaShort() {
        return InvokeDynamicSupport.bootstrap("getOperatorAlphaShort", $$robo$$android_telephony_ServiceState$getOperatorAlphaShort(), 0, this);
    }

    public String getVoiceOperatorAlphaShort() {
        return InvokeDynamicSupport.bootstrap("getVoiceOperatorAlphaShort", $$robo$$android_telephony_ServiceState$getVoiceOperatorAlphaShort(), 0, this);
    }

    public String getDataOperatorAlphaShort() {
        return InvokeDynamicSupport.bootstrap("getDataOperatorAlphaShort", $$robo$$android_telephony_ServiceState$getDataOperatorAlphaShort(), 0, this);
    }

    public String getOperatorAlpha() {
        return InvokeDynamicSupport.bootstrap("getOperatorAlpha", $$robo$$android_telephony_ServiceState$getOperatorAlpha(), 0, this);
    }

    public String getOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getOperatorNumeric", $$robo$$android_telephony_ServiceState$getOperatorNumeric(), 0, this);
    }

    public String getVoiceOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getVoiceOperatorNumeric", $$robo$$android_telephony_ServiceState$getVoiceOperatorNumeric(), 0, this);
    }

    public String getDataOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getDataOperatorNumeric", $$robo$$android_telephony_ServiceState$getDataOperatorNumeric(), 0, this);
    }

    public boolean getIsManualSelection() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIsManualSelection", $$robo$$android_telephony_ServiceState$getIsManualSelection(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_ServiceState$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_ServiceState$equals(java.lang.Object ), 0, this, object);
    }

    public static String rilRadioTechnologyToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("rilRadioTechnologyToString", $$robo$$android_telephony_ServiceState$rilRadioTechnologyToString(int ), 0, (int)n);
    }

    public static String rilServiceStateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("rilServiceStateToString", $$robo$$android_telephony_ServiceState$rilServiceStateToString(int ), 0, (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_ServiceState$toString(), 0, this);
    }

    private void setNullState(int n) {
        InvokeDynamicSupport.bootstrap("setNullState", $$robo$$android_telephony_ServiceState$setNullState(int ), 0, this, n);
    }

    public void setStateOutOfService() {
        InvokeDynamicSupport.bootstrap("setStateOutOfService", $$robo$$android_telephony_ServiceState$setStateOutOfService(), 0, this);
    }

    public void setStateOff() {
        InvokeDynamicSupport.bootstrap("setStateOff", $$robo$$android_telephony_ServiceState$setStateOff(), 0, this);
    }

    public void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telephony_ServiceState$setState(int ), 0, this, n);
    }

    public void setVoiceRegState(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceRegState", $$robo$$android_telephony_ServiceState$setVoiceRegState(int ), 0, this, n);
    }

    public void setDataRegState(int n) {
        InvokeDynamicSupport.bootstrap("setDataRegState", $$robo$$android_telephony_ServiceState$setDataRegState(int ), 0, this, n);
    }

    public void setCellBandwidths(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setCellBandwidths", $$robo$$android_telephony_ServiceState$setCellBandwidths(int[] ), 0, this, nArray);
    }

    public void setChannelNumber(int n) {
        InvokeDynamicSupport.bootstrap("setChannelNumber", $$robo$$android_telephony_ServiceState$setChannelNumber(int ), 0, this, n);
    }

    public void setRoaming(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRoaming", $$robo$$android_telephony_ServiceState$setRoaming(boolean ), 0, this, bl);
    }

    public void setVoiceRoaming(boolean bl) {
        InvokeDynamicSupport.bootstrap("setVoiceRoaming", $$robo$$android_telephony_ServiceState$setVoiceRoaming(boolean ), 0, this, bl);
    }

    public void setVoiceRoamingType(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceRoamingType", $$robo$$android_telephony_ServiceState$setVoiceRoamingType(int ), 0, this, n);
    }

    public void setDataRoaming(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataRoaming", $$robo$$android_telephony_ServiceState$setDataRoaming(boolean ), 0, this, bl);
    }

    public void setDataRoamingType(int n) {
        InvokeDynamicSupport.bootstrap("setDataRoamingType", $$robo$$android_telephony_ServiceState$setDataRoamingType(int ), 0, this, n);
    }

    public void setEmergencyOnly(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEmergencyOnly", $$robo$$android_telephony_ServiceState$setEmergencyOnly(boolean ), 0, this, bl);
    }

    public void setCdmaRoamingIndicator(int n) {
        InvokeDynamicSupport.bootstrap("setCdmaRoamingIndicator", $$robo$$android_telephony_ServiceState$setCdmaRoamingIndicator(int ), 0, this, n);
    }

    public void setCdmaDefaultRoamingIndicator(int n) {
        InvokeDynamicSupport.bootstrap("setCdmaDefaultRoamingIndicator", $$robo$$android_telephony_ServiceState$setCdmaDefaultRoamingIndicator(int ), 0, this, n);
    }

    public void setCdmaEriIconIndex(int n) {
        InvokeDynamicSupport.bootstrap("setCdmaEriIconIndex", $$robo$$android_telephony_ServiceState$setCdmaEriIconIndex(int ), 0, this, n);
    }

    public void setCdmaEriIconMode(int n) {
        InvokeDynamicSupport.bootstrap("setCdmaEriIconMode", $$robo$$android_telephony_ServiceState$setCdmaEriIconMode(int ), 0, this, n);
    }

    public void setOperatorName(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("setOperatorName", $$robo$$android_telephony_ServiceState$setOperatorName(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public void setVoiceOperatorName(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("setVoiceOperatorName", $$robo$$android_telephony_ServiceState$setVoiceOperatorName(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public void setDataOperatorName(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("setDataOperatorName", $$robo$$android_telephony_ServiceState$setDataOperatorName(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public void setOperatorAlphaLong(String string2) {
        InvokeDynamicSupport.bootstrap("setOperatorAlphaLong", $$robo$$android_telephony_ServiceState$setOperatorAlphaLong(java.lang.String ), 0, this, string2);
    }

    public void setVoiceOperatorAlphaLong(String string2) {
        InvokeDynamicSupport.bootstrap("setVoiceOperatorAlphaLong", $$robo$$android_telephony_ServiceState$setVoiceOperatorAlphaLong(java.lang.String ), 0, this, string2);
    }

    public void setDataOperatorAlphaLong(String string2) {
        InvokeDynamicSupport.bootstrap("setDataOperatorAlphaLong", $$robo$$android_telephony_ServiceState$setDataOperatorAlphaLong(java.lang.String ), 0, this, string2);
    }

    public void setIsManualSelection(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsManualSelection", $$robo$$android_telephony_ServiceState$setIsManualSelection(boolean ), 0, this, bl);
    }

    private static boolean equalsHandlesNulls(Object object, Object object2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("equalsHandlesNulls", $$robo$$android_telephony_ServiceState$equalsHandlesNulls(java.lang.Object java.lang.Object ), 0, (Object)object, (Object)object2);
    }

    private void setFromNotifierBundle(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setFromNotifierBundle", $$robo$$android_telephony_ServiceState$setFromNotifierBundle(android.os.Bundle ), 0, this, bundle);
    }

    public void fillInNotifierBundle(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("fillInNotifierBundle", $$robo$$android_telephony_ServiceState$fillInNotifierBundle(android.os.Bundle ), 0, this, bundle);
    }

    public void setRilVoiceRadioTechnology(int n) {
        InvokeDynamicSupport.bootstrap("setRilVoiceRadioTechnology", $$robo$$android_telephony_ServiceState$setRilVoiceRadioTechnology(int ), 0, this, n);
    }

    public void setRilDataRadioTechnology(int n) {
        InvokeDynamicSupport.bootstrap("setRilDataRadioTechnology", $$robo$$android_telephony_ServiceState$setRilDataRadioTechnology(int ), 0, this, n);
    }

    public boolean isUsingCarrierAggregation() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsingCarrierAggregation", $$robo$$android_telephony_ServiceState$isUsingCarrierAggregation(), 0, this);
    }

    public void setIsUsingCarrierAggregation(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsUsingCarrierAggregation", $$robo$$android_telephony_ServiceState$setIsUsingCarrierAggregation(boolean ), 0, this, bl);
    }

    public int getLteEarfcnRsrpBoost() {
        return (int)InvokeDynamicSupport.bootstrap("getLteEarfcnRsrpBoost", $$robo$$android_telephony_ServiceState$getLteEarfcnRsrpBoost(), 0, this);
    }

    public void setLteEarfcnRsrpBoost(int n) {
        InvokeDynamicSupport.bootstrap("setLteEarfcnRsrpBoost", $$robo$$android_telephony_ServiceState$setLteEarfcnRsrpBoost(int ), 0, this, n);
    }

    public void setCssIndicator(int n) {
        InvokeDynamicSupport.bootstrap("setCssIndicator", $$robo$$android_telephony_ServiceState$setCssIndicator(int ), 0, this, n);
    }

    public void setCdmaSystemAndNetworkId(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setCdmaSystemAndNetworkId", $$robo$$android_telephony_ServiceState$setCdmaSystemAndNetworkId(int int ), 0, this, n, n2);
    }

    public int getRilVoiceRadioTechnology() {
        return (int)InvokeDynamicSupport.bootstrap("getRilVoiceRadioTechnology", $$robo$$android_telephony_ServiceState$getRilVoiceRadioTechnology(), 0, this);
    }

    public int getRilDataRadioTechnology() {
        return (int)InvokeDynamicSupport.bootstrap("getRilDataRadioTechnology", $$robo$$android_telephony_ServiceState$getRilDataRadioTechnology(), 0, this);
    }

    public int getRadioTechnology() {
        return (int)InvokeDynamicSupport.bootstrap("getRadioTechnology", $$robo$$android_telephony_ServiceState$getRadioTechnology(), 0, this);
    }

    public static int rilRadioTechnologyToNetworkType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("rilRadioTechnologyToNetworkType", $$robo$$android_telephony_ServiceState$rilRadioTechnologyToNetworkType(int ), 0, (int)n);
    }

    public static int rilRadioTechnologyToAccessNetworkType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("rilRadioTechnologyToAccessNetworkType", $$robo$$android_telephony_ServiceState$rilRadioTechnologyToAccessNetworkType(int ), 0, (int)n);
    }

    public static int networkTypeToRilRadioTechnology(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("networkTypeToRilRadioTechnology", $$robo$$android_telephony_ServiceState$networkTypeToRilRadioTechnology(int ), 0, (int)n);
    }

    public int getDataNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getDataNetworkType", $$robo$$android_telephony_ServiceState$getDataNetworkType(), 0, this);
    }

    public int getVoiceNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceNetworkType", $$robo$$android_telephony_ServiceState$getVoiceNetworkType(), 0, this);
    }

    public int getCssIndicator() {
        return (int)InvokeDynamicSupport.bootstrap("getCssIndicator", $$robo$$android_telephony_ServiceState$getCssIndicator(), 0, this);
    }

    public int getCdmaNetworkId() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaNetworkId", $$robo$$android_telephony_ServiceState$getCdmaNetworkId(), 0, this);
    }

    public int getCdmaSystemId() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaSystemId", $$robo$$android_telephony_ServiceState$getCdmaSystemId(), 0, this);
    }

    public static boolean isGsm(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isGsm", $$robo$$android_telephony_ServiceState$isGsm(int ), 0, (int)n);
    }

    public static boolean isCdma(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCdma", $$robo$$android_telephony_ServiceState$isCdma(int ), 0, (int)n);
    }

    public static boolean isLte(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isLte", $$robo$$android_telephony_ServiceState$isLte(int ), 0, (int)n);
    }

    public static boolean bearerBitmapHasCdma(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("bearerBitmapHasCdma", $$robo$$android_telephony_ServiceState$bearerBitmapHasCdma(int ), 0, (int)n);
    }

    public static boolean bitmaskHasTech(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("bitmaskHasTech", $$robo$$android_telephony_ServiceState$bitmaskHasTech(int int ), 0, (int)n, (int)n2);
    }

    public static int getBitmaskForTech(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBitmaskForTech", $$robo$$android_telephony_ServiceState$getBitmaskForTech(int ), 0, (int)n);
    }

    public static int getBitmaskFromString(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBitmaskFromString", $$robo$$android_telephony_ServiceState$getBitmaskFromString(java.lang.String ), 0, (String)string2);
    }

    public static int convertNetworkTypeBitmaskToBearerBitmask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertNetworkTypeBitmaskToBearerBitmask", $$robo$$android_telephony_ServiceState$convertNetworkTypeBitmaskToBearerBitmask(int ), 0, (int)n);
    }

    public static int convertBearerBitmaskToNetworkTypeBitmask(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("convertBearerBitmaskToNetworkTypeBitmask", $$robo$$android_telephony_ServiceState$convertBearerBitmaskToNetworkTypeBitmask(int ), 0, (int)n);
    }

    public static ServiceState mergeServiceStates(ServiceState serviceState, ServiceState serviceState2) {
        return InvokeDynamicSupport.bootstrapStatic("mergeServiceStates", $$robo$$android_telephony_ServiceState$mergeServiceStates(android.telephony.ServiceState android.telephony.ServiceState ), 0, (ServiceState)serviceState, (ServiceState)serviceState2);
    }

    public List<NetworkRegistrationState> getNetworkRegistrationStates() {
        return InvokeDynamicSupport.bootstrap("getNetworkRegistrationStates", $$robo$$android_telephony_ServiceState$getNetworkRegistrationStates(), 0, this);
    }

    public List<NetworkRegistrationState> getNetworkRegistrationStates(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkRegistrationStates", $$robo$$android_telephony_ServiceState$getNetworkRegistrationStates(int ), 0, this, n);
    }

    public NetworkRegistrationState getNetworkRegistrationStates(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getNetworkRegistrationStates", $$robo$$android_telephony_ServiceState$getNetworkRegistrationStates(int int ), 0, this, n, n2);
    }

    public void addNetworkRegistrationState(NetworkRegistrationState networkRegistrationState) {
        InvokeDynamicSupport.bootstrap("addNetworkRegistrationState", $$robo$$android_telephony_ServiceState$addNetworkRegistrationState(android.telephony.NetworkRegistrationState ), 0, this, networkRegistrationState);
    }

    static {
        RobolectricInternals.classInitializing(ServiceState.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceState)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RilRadioTechnology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DuplexMode {
    }
}

