/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SignalStrength
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SignalStrength";
    private static boolean DBG = false;
    public static int SIGNAL_STRENGTH_NONE_OR_UNKNOWN = 0;
    public static int SIGNAL_STRENGTH_POOR = 1;
    public static int SIGNAL_STRENGTH_MODERATE = 2;
    public static int SIGNAL_STRENGTH_GOOD = 3;
    public static int SIGNAL_STRENGTH_GREAT = 4;
    public static int NUM_SIGNAL_STRENGTH_BINS = 5;
    public static String[] SIGNAL_STRENGTH_NAMES;
    public static int INVALID = Integer.MAX_VALUE;
    private static int LTE_RSRP_THRESHOLDS_NUM = 4;
    private static int MAX_LTE_RSRP = -44;
    private static int MIN_LTE_RSRP = -140;
    private static int WCDMA_RSCP_THRESHOLDS_NUM = 4;
    private static int MAX_WCDMA_RSCP = -24;
    private static int MIN_WCDMA_RSCP = -120;
    private static String MEASUMENT_TYPE_RSCP = "rscp";
    private int mGsmSignalStrength;
    private int mGsmBitErrorRate;
    private int mCdmaDbm;
    private int mCdmaEcio;
    private int mEvdoDbm;
    private int mEvdoEcio;
    private int mEvdoSnr;
    private int mLteSignalStrength;
    private int mLteRsrp;
    private int mLteRsrq;
    private int mLteRssnr;
    private int mLteCqi;
    private int mTdScdmaRscp;
    private int mWcdmaSignalStrength;
    private int mWcdmaRscpAsu;
    private int mWcdmaRscp;
    private int mLteRsrpBoost;
    private boolean mIsGsm;
    private boolean mUseOnlyRsrpForLteLevel;
    private int[] mLteRsrpThresholds;
    private String mWcdmaDefaultSignalMeasurement;
    private int[] mWcdmaRscpThresholds;
    public static Parcelable.Creator<SignalStrength> CREATOR;

    private static final SignalStrength $$robo$$android_telephony_SignalStrength$newFromBundle(Bundle m) {
        SignalStrength ret = new SignalStrength();
        ret.setFromNotifierBundle(m);
        return ret;
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__() {
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(boolean gsmFlag) {
        this.mLteRsrpThresholds = new int[4];
        this.mWcdmaRscpThresholds = new int[4];
        this.mGsmSignalStrength = 99;
        this.mGsmBitErrorRate = -1;
        this.mCdmaDbm = -1;
        this.mCdmaEcio = -1;
        this.mEvdoDbm = -1;
        this.mEvdoEcio = -1;
        this.mEvdoSnr = -1;
        this.mLteSignalStrength = 99;
        this.mLteRsrp = Integer.MAX_VALUE;
        this.mLteRsrq = Integer.MAX_VALUE;
        this.mLteRssnr = Integer.MAX_VALUE;
        this.mLteCqi = Integer.MAX_VALUE;
        this.mTdScdmaRscp = Integer.MAX_VALUE;
        this.mWcdmaSignalStrength = 99;
        this.mWcdmaRscp = Integer.MAX_VALUE;
        this.mWcdmaRscpAsu = 255;
        this.mLteRsrpBoost = 0;
        this.mIsGsm = gsmFlag;
        this.mUseOnlyRsrpForLteLevel = false;
        this.mWcdmaDefaultSignalMeasurement = "";
        this.setLteRsrpThresholds(this.getDefaultLteRsrpThresholds());
        this.setWcdmaRscpThresholds(this.getDefaultWcdmaRscpThresholds());
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int tdScdmaRscp, int wcdmaSignalStrength, int wcdmaRscpAsu, int lteRsrpBoost, boolean gsmFlag, boolean lteLevelBaseOnRsrp, String wcdmaDefaultMeasurement) {
        this.mLteRsrpThresholds = new int[4];
        this.mWcdmaRscpThresholds = new int[4];
        this.mGsmSignalStrength = gsmSignalStrength;
        this.mGsmBitErrorRate = gsmBitErrorRate;
        this.mCdmaDbm = cdmaDbm;
        this.mCdmaEcio = cdmaEcio;
        this.mEvdoDbm = evdoDbm;
        this.mEvdoEcio = evdoEcio;
        this.mEvdoSnr = evdoSnr;
        this.mLteSignalStrength = lteSignalStrength;
        this.mLteRsrp = lteRsrp;
        this.mLteRsrq = lteRsrq;
        this.mLteRssnr = lteRssnr;
        this.mLteCqi = lteCqi;
        this.mTdScdmaRscp = Integer.MAX_VALUE;
        this.mWcdmaSignalStrength = wcdmaSignalStrength;
        this.mWcdmaRscpAsu = wcdmaRscpAsu;
        this.mWcdmaRscp = wcdmaRscpAsu - 120;
        this.mLteRsrpBoost = lteRsrpBoost;
        this.mIsGsm = gsmFlag;
        this.mUseOnlyRsrpForLteLevel = lteLevelBaseOnRsrp;
        this.mWcdmaDefaultSignalMeasurement = wcdmaDefaultMeasurement;
        this.setLteRsrpThresholds(this.getDefaultLteRsrpThresholds());
        this.setWcdmaRscpThresholds(this.getDefaultWcdmaRscpThresholds());
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int tdScdmaRscp) {
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(int gsmSignalStrength, int gsmBitErrorRate, int cdmaDbm, int cdmaEcio, int evdoDbm, int evdoEcio, int evdoSnr, int lteSignalStrength, int lteRsrp, int lteRsrq, int lteRssnr, int lteCqi, int tdScdmaRscp, int wcdmaSignalStrength, int wcdmaRscp) {
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(SignalStrength s) {
        this.mLteRsrpThresholds = new int[4];
        this.mWcdmaRscpThresholds = new int[4];
        this.copyFrom(s);
    }

    private final void $$robo$$android_telephony_SignalStrength$copyFrom(SignalStrength s) {
        this.mGsmSignalStrength = s.mGsmSignalStrength;
        this.mGsmBitErrorRate = s.mGsmBitErrorRate;
        this.mCdmaDbm = s.mCdmaDbm;
        this.mCdmaEcio = s.mCdmaEcio;
        this.mEvdoDbm = s.mEvdoDbm;
        this.mEvdoEcio = s.mEvdoEcio;
        this.mEvdoSnr = s.mEvdoSnr;
        this.mLteSignalStrength = s.mLteSignalStrength;
        this.mLteRsrp = s.mLteRsrp;
        this.mLteRsrq = s.mLteRsrq;
        this.mLteRssnr = s.mLteRssnr;
        this.mLteCqi = s.mLteCqi;
        this.mTdScdmaRscp = s.mTdScdmaRscp;
        this.mWcdmaSignalStrength = s.mWcdmaSignalStrength;
        this.mWcdmaRscpAsu = s.mWcdmaRscpAsu;
        this.mWcdmaRscp = s.mWcdmaRscp;
        this.mLteRsrpBoost = s.mLteRsrpBoost;
        this.mIsGsm = s.mIsGsm;
        this.mUseOnlyRsrpForLteLevel = s.mUseOnlyRsrpForLteLevel;
        this.mWcdmaDefaultSignalMeasurement = s.mWcdmaDefaultSignalMeasurement;
        this.setLteRsrpThresholds(s.mLteRsrpThresholds);
        this.setWcdmaRscpThresholds(s.mWcdmaRscpThresholds);
    }

    private void $$robo$$android_telephony_SignalStrength$__constructor__(Parcel in) {
        this.mLteRsrpThresholds = new int[4];
        this.mWcdmaRscpThresholds = new int[4];
        this.mGsmSignalStrength = in.readInt();
        this.mGsmBitErrorRate = in.readInt();
        this.mCdmaDbm = in.readInt();
        this.mCdmaEcio = in.readInt();
        this.mEvdoDbm = in.readInt();
        this.mEvdoEcio = in.readInt();
        this.mEvdoSnr = in.readInt();
        this.mLteSignalStrength = in.readInt();
        this.mLteRsrp = in.readInt();
        this.mLteRsrq = in.readInt();
        this.mLteRssnr = in.readInt();
        this.mLteCqi = in.readInt();
        this.mTdScdmaRscp = in.readInt();
        this.mWcdmaSignalStrength = in.readInt();
        this.mWcdmaRscpAsu = in.readInt();
        this.mWcdmaRscp = in.readInt();
        this.mLteRsrpBoost = in.readInt();
        this.mIsGsm = in.readBoolean();
        this.mUseOnlyRsrpForLteLevel = in.readBoolean();
        this.mWcdmaDefaultSignalMeasurement = in.readString();
        in.readIntArray(this.mLteRsrpThresholds);
        in.readIntArray(this.mWcdmaRscpThresholds);
    }

    private final void $$robo$$android_telephony_SignalStrength$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mGsmSignalStrength);
        out.writeInt(this.mGsmBitErrorRate);
        out.writeInt(this.mCdmaDbm);
        out.writeInt(this.mCdmaEcio);
        out.writeInt(this.mEvdoDbm);
        out.writeInt(this.mEvdoEcio);
        out.writeInt(this.mEvdoSnr);
        out.writeInt(this.mLteSignalStrength);
        out.writeInt(this.mLteRsrp);
        out.writeInt(this.mLteRsrq);
        out.writeInt(this.mLteRssnr);
        out.writeInt(this.mLteCqi);
        out.writeInt(this.mTdScdmaRscp);
        out.writeInt(this.mWcdmaSignalStrength);
        out.writeInt(this.mWcdmaRscpAsu);
        out.writeInt(this.mWcdmaRscp);
        out.writeInt(this.mLteRsrpBoost);
        out.writeBoolean(this.mIsGsm);
        out.writeBoolean(this.mUseOnlyRsrpForLteLevel);
        out.writeString(this.mWcdmaDefaultSignalMeasurement);
        out.writeIntArray(this.mLteRsrpThresholds);
        out.writeIntArray(this.mWcdmaRscpThresholds);
    }

    private final int $$robo$$android_telephony_SignalStrength$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telephony_SignalStrength$validateInput() {
        this.mGsmSignalStrength = this.mGsmSignalStrength >= 0 ? this.mGsmSignalStrength : 99;
        this.mWcdmaSignalStrength = this.mWcdmaSignalStrength >= 0 ? this.mWcdmaSignalStrength : 99;
        this.mLteSignalStrength = this.mLteSignalStrength >= 0 ? this.mLteSignalStrength : 99;
        this.mWcdmaRscpAsu = this.mWcdmaRscpAsu - 120 >= -120 && this.mWcdmaRscpAsu - 120 <= -24 ? this.mWcdmaRscpAsu : 255;
        this.mWcdmaRscp = this.mWcdmaRscp >= -120 && this.mWcdmaRscp <= -24 ? this.mWcdmaRscp : Integer.MAX_VALUE;
        this.mCdmaDbm = this.mCdmaDbm > 0 ? -this.mCdmaDbm : -120;
        this.mCdmaEcio = this.mCdmaEcio >= 0 ? -this.mCdmaEcio : -160;
        this.mEvdoDbm = this.mEvdoDbm > 0 ? -this.mEvdoDbm : -120;
        this.mEvdoEcio = this.mEvdoEcio >= 0 ? -this.mEvdoEcio : -160;
        this.mEvdoSnr = this.mEvdoSnr >= 0 && this.mEvdoSnr <= 8 ? this.mEvdoSnr : -1;
        this.mLteRsrp = -this.mLteRsrp >= -140 && -this.mLteRsrp <= -44 ? -this.mLteRsrp : Integer.MAX_VALUE;
        this.mLteRsrq = this.mLteRsrq >= 3 && this.mLteRsrq <= 20 ? -this.mLteRsrq : Integer.MAX_VALUE;
        this.mLteRssnr = this.mLteRssnr >= -200 && this.mLteRssnr <= 300 ? this.mLteRssnr : Integer.MAX_VALUE;
        this.mTdScdmaRscp = this.mTdScdmaRscp >= 0 && this.mTdScdmaRscp <= 96 ? this.mTdScdmaRscp - 120 : Integer.MAX_VALUE;
    }

    private final void $$robo$$android_telephony_SignalStrength$fixType() {
        this.mIsGsm = this.getCdmaRelatedSignalStrength() == 0;
    }

    private final void $$robo$$android_telephony_SignalStrength$setGsm(boolean gsmFlag) {
        this.mIsGsm = gsmFlag;
    }

    private final void $$robo$$android_telephony_SignalStrength$setUseOnlyRsrpForLteLevel(boolean useOnlyRsrpForLteLevel) {
        this.mUseOnlyRsrpForLteLevel = useOnlyRsrpForLteLevel;
    }

    private final void $$robo$$android_telephony_SignalStrength$setWcdmaDefaultSignalMeasurement(String defaultMeasurement) {
        this.mWcdmaDefaultSignalMeasurement = defaultMeasurement;
    }

    private final void $$robo$$android_telephony_SignalStrength$setLteRsrpBoost(int lteRsrpBoost) {
        this.mLteRsrpBoost = lteRsrpBoost;
    }

    private final void $$robo$$android_telephony_SignalStrength$setLteRsrpThresholds(int[] lteRsrpThresholds) {
        if (lteRsrpThresholds == null || lteRsrpThresholds.length != 4) {
            Log.wtf("SignalStrength", "setLteRsrpThresholds - lteRsrpThresholds is invalid.");
            return;
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)lteRsrpThresholds, (int)0, (Object)this.mLteRsrpThresholds, (int)0, (int)4);
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmSignalStrength() {
        return this.mGsmSignalStrength;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmBitErrorRate() {
        return this.mGsmBitErrorRate;
    }

    private final void $$robo$$android_telephony_SignalStrength$setWcdmaRscpThresholds(int[] wcdmaRscpThresholds) {
        if (wcdmaRscpThresholds == null || wcdmaRscpThresholds.length != 4) {
            Log.wtf("SignalStrength", "setWcdmaRscpThresholds - wcdmaRscpThresholds is invalid.");
            return;
        }
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)wcdmaRscpThresholds, (int)0, (Object)this.mWcdmaRscpThresholds, (int)0, (int)4);
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaDbm() {
        return this.mCdmaDbm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaEcio() {
        return this.mCdmaEcio;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoDbm() {
        return this.mEvdoDbm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoEcio() {
        return this.mEvdoEcio;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoSnr() {
        return this.mEvdoSnr;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteSignalStrength() {
        return this.mLteSignalStrength;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteRsrp() {
        return this.mLteRsrp;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteRsrq() {
        return this.mLteRsrq;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteRssnr() {
        return this.mLteRssnr;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteCqi() {
        return this.mLteCqi;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteRsrpBoost() {
        return this.mLteRsrpBoost;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLevel() {
        int level = this.mIsGsm ? this.getGsmRelatedSignalStrength() : this.getCdmaRelatedSignalStrength();
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getAsuLevel() {
        int asuLevel = 0;
        if (this.mIsGsm) {
            asuLevel = this.mLteRsrp != Integer.MAX_VALUE ? this.getLteAsuLevel() : (this.mTdScdmaRscp != Integer.MAX_VALUE ? this.getTdScdmaAsuLevel() : (this.mWcdmaRscp != Integer.MAX_VALUE ? this.getWcdmaAsuLevel() : this.getGsmAsuLevel()));
        } else {
            int cdmaAsuLevel = this.getCdmaAsuLevel();
            int evdoAsuLevel = this.getEvdoAsuLevel();
            asuLevel = evdoAsuLevel == 0 ? cdmaAsuLevel : (cdmaAsuLevel == 0 ? evdoAsuLevel : (cdmaAsuLevel < evdoAsuLevel ? cdmaAsuLevel : evdoAsuLevel));
        }
        return asuLevel;
    }

    private final int $$robo$$android_telephony_SignalStrength$getDbm() {
        int dBm = Integer.MAX_VALUE;
        if (this.isGsm()) {
            dBm = this.getLteDbm();
            if (dBm == Integer.MAX_VALUE) {
                dBm = this.getTdScdmaLevel() == 0 ? (this.getWcdmaDbm() == Integer.MAX_VALUE ? this.getGsmDbm() : this.getWcdmaDbm()) : this.getTdScdmaDbm();
            }
        } else {
            int cdmaDbm = this.getCdmaDbm();
            int evdoDbm = this.getEvdoDbm();
            return evdoDbm == -120 ? cdmaDbm : (cdmaDbm == -120 ? evdoDbm : (cdmaDbm < evdoDbm ? cdmaDbm : evdoDbm));
        }
        return dBm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmDbm() {
        int gsmSignalStrength = this.getGsmSignalStrength();
        int asu = gsmSignalStrength == 99 ? -1 : gsmSignalStrength;
        int dBm = asu != -1 ? -113 + 2 * asu : -1;
        return dBm;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmLevel() {
        int asu = this.getGsmSignalStrength();
        int level = asu <= 2 || asu == 99 ? 0 : (asu >= 12 ? 4 : (asu >= 8 ? 3 : (asu >= 5 ? 2 : 1)));
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmAsuLevel() {
        int level = this.getGsmSignalStrength();
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int levelDbm = cdmaDbm >= -75 ? 4 : (cdmaDbm >= -85 ? 3 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 0)));
        int levelEcio = cdmaEcio >= -90 ? 4 : (cdmaEcio >= -110 ? 3 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 0)));
        int level = levelDbm < levelEcio ? levelDbm : levelEcio;
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaAsuLevel() {
        int cdmaDbm = this.getCdmaDbm();
        int cdmaEcio = this.getCdmaEcio();
        int cdmaAsuLevel = cdmaDbm >= -75 ? 16 : (cdmaDbm >= -82 ? 8 : (cdmaDbm >= -90 ? 4 : (cdmaDbm >= -95 ? 2 : (cdmaDbm >= -100 ? 1 : 99))));
        int ecioAsuLevel = cdmaEcio >= -90 ? 16 : (cdmaEcio >= -100 ? 8 : (cdmaEcio >= -115 ? 4 : (cdmaEcio >= -130 ? 2 : (cdmaEcio >= -150 ? 1 : 99))));
        int level = cdmaAsuLevel < ecioAsuLevel ? cdmaAsuLevel : ecioAsuLevel;
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 4 : (evdoDbm >= -75 ? 3 : (evdoDbm >= -90 ? 2 : (evdoDbm >= -105 ? 1 : 0)));
        int levelEvdoSnr = evdoSnr >= 7 ? 4 : (evdoSnr >= 5 ? 3 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 0)));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getEvdoAsuLevel() {
        int evdoDbm = this.getEvdoDbm();
        int evdoSnr = this.getEvdoSnr();
        int levelEvdoDbm = evdoDbm >= -65 ? 16 : (evdoDbm >= -75 ? 8 : (evdoDbm >= -85 ? 4 : (evdoDbm >= -95 ? 2 : (evdoDbm >= -105 ? 1 : 99))));
        int levelEvdoSnr = evdoSnr >= 7 ? 16 : (evdoSnr >= 6 ? 8 : (evdoSnr >= 5 ? 4 : (evdoSnr >= 3 ? 2 : (evdoSnr >= 1 ? 1 : 99))));
        int level = levelEvdoDbm < levelEvdoSnr ? levelEvdoDbm : levelEvdoSnr;
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteDbm() {
        return this.mLteRsrp;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteLevel() {
        int rssiIconLevel = 0;
        int rsrpIconLevel = -1;
        int snrIconLevel = -1;
        if (this.mLteRsrp > -44 || this.mLteRsrp < -140) {
            if (this.mLteRsrp != Integer.MAX_VALUE) {
                Log.wtf("SignalStrength", "getLteLevel - invalid lte rsrp: mLteRsrp=" + this.mLteRsrp);
            }
        } else {
            rsrpIconLevel = this.mLteRsrp >= this.mLteRsrpThresholds[3] - this.mLteRsrpBoost ? 4 : (this.mLteRsrp >= this.mLteRsrpThresholds[2] - this.mLteRsrpBoost ? 3 : (this.mLteRsrp >= this.mLteRsrpThresholds[1] - this.mLteRsrpBoost ? 2 : (this.mLteRsrp >= this.mLteRsrpThresholds[0] - this.mLteRsrpBoost ? 1 : 0)));
        }
        if (this.useOnlyRsrpForLteLevel()) {
            SignalStrength.log("getLTELevel - rsrp = " + rsrpIconLevel);
            if (rsrpIconLevel != -1) {
                return rsrpIconLevel;
            }
        }
        if (this.mLteRssnr > 300) {
            snrIconLevel = -1;
        } else if (this.mLteRssnr >= 130) {
            snrIconLevel = 4;
        } else if (this.mLteRssnr >= 45) {
            snrIconLevel = 3;
        } else if (this.mLteRssnr >= 10) {
            snrIconLevel = 2;
        } else if (this.mLteRssnr >= -30) {
            snrIconLevel = 1;
        } else if (this.mLteRssnr >= -200) {
            snrIconLevel = 0;
        }
        if (snrIconLevel != -1 && rsrpIconLevel != -1) {
            return rsrpIconLevel < snrIconLevel ? rsrpIconLevel : snrIconLevel;
        }
        if (snrIconLevel != -1) {
            return snrIconLevel;
        }
        if (rsrpIconLevel != -1) {
            return rsrpIconLevel;
        }
        if (this.mLteSignalStrength > 63) {
            rssiIconLevel = 0;
        } else if (this.mLteSignalStrength >= 12) {
            rssiIconLevel = 4;
        } else if (this.mLteSignalStrength >= 8) {
            rssiIconLevel = 3;
        } else if (this.mLteSignalStrength >= 5) {
            rssiIconLevel = 2;
        } else if (this.mLteSignalStrength >= 0) {
            rssiIconLevel = 1;
        }
        return rssiIconLevel;
    }

    private final int $$robo$$android_telephony_SignalStrength$getLteAsuLevel() {
        int lteAsuLevel = 99;
        int lteDbm = this.getLteDbm();
        lteAsuLevel = lteDbm == Integer.MAX_VALUE ? 255 : lteDbm + 140;
        return lteAsuLevel;
    }

    private final boolean $$robo$$android_telephony_SignalStrength$isGsm() {
        return this.mIsGsm;
    }

    private final boolean $$robo$$android_telephony_SignalStrength$useOnlyRsrpForLteLevel() {
        return this.mUseOnlyRsrpForLteLevel;
    }

    private final int $$robo$$android_telephony_SignalStrength$getTdScdmaDbm() {
        return this.mTdScdmaRscp;
    }

    private final int $$robo$$android_telephony_SignalStrength$getTdScdmaLevel() {
        int tdScdmaDbm = this.getTdScdmaDbm();
        int level = tdScdmaDbm > -25 || tdScdmaDbm == Integer.MAX_VALUE ? 0 : (tdScdmaDbm >= -49 ? 4 : (tdScdmaDbm >= -73 ? 3 : (tdScdmaDbm >= -97 ? 2 : (tdScdmaDbm >= -110 ? 1 : 0))));
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getTdScdmaAsuLevel() {
        int tdScdmaDbm = this.getTdScdmaDbm();
        int tdScdmaAsuLevel = tdScdmaDbm == Integer.MAX_VALUE ? 255 : tdScdmaDbm + 120;
        return tdScdmaAsuLevel;
    }

    private final int $$robo$$android_telephony_SignalStrength$getWcdmaRscp() {
        return this.mWcdmaRscp;
    }

    private final int $$robo$$android_telephony_SignalStrength$getWcdmaAsuLevel() {
        int wcdmaDbm = this.getWcdmaDbm();
        int wcdmaAsuLevel = 255;
        wcdmaAsuLevel = wcdmaDbm == Integer.MAX_VALUE ? 255 : wcdmaDbm + 120;
        return wcdmaAsuLevel;
    }

    private final int $$robo$$android_telephony_SignalStrength$getWcdmaDbm() {
        return this.mWcdmaRscp;
    }

    private final int $$robo$$android_telephony_SignalStrength$getWcdmaLevel() {
        int level = 0;
        if (this.mWcdmaDefaultSignalMeasurement == null) {
            Log.wtf("SignalStrength", "getWcdmaLevel - WCDMA default signal measurement is invalid.");
            return level;
        }
        switch (this.mWcdmaDefaultSignalMeasurement) {
            case "rscp": {
                if (this.mWcdmaRscp < -120 || this.mWcdmaRscp > -24) {
                    if (this.mWcdmaRscp == Integer.MAX_VALUE) break;
                    Log.wtf("SignalStrength", "getWcdmaLevel - invalid WCDMA RSCP: mWcdmaRscp=" + this.mWcdmaRscp);
                    break;
                }
                if (this.mWcdmaRscp >= this.mWcdmaRscpThresholds[3]) {
                    level = 4;
                    break;
                }
                if (this.mWcdmaRscp >= this.mWcdmaRscpThresholds[2]) {
                    level = 3;
                    break;
                }
                if (this.mWcdmaRscp >= this.mWcdmaRscpThresholds[1]) {
                    level = 2;
                    break;
                }
                if (this.mWcdmaRscp < this.mWcdmaRscpThresholds[0]) break;
                level = 1;
                break;
            }
            default: {
                if (this.mWcdmaSignalStrength < 0 || this.mWcdmaSignalStrength > 31) {
                    if (this.mWcdmaSignalStrength == 99) break;
                    Log.wtf("SignalStrength", "getWcdmaLevel - invalid WCDMA RSSI: mWcdmaSignalStrength=" + this.mWcdmaSignalStrength);
                    break;
                }
                if (this.mWcdmaSignalStrength >= 18) {
                    level = 4;
                    break;
                }
                if (this.mWcdmaSignalStrength >= 13) {
                    level = 3;
                    break;
                }
                if (this.mWcdmaSignalStrength >= 8) {
                    level = 2;
                    break;
                }
                if (this.mWcdmaSignalStrength < 3) break;
                level = 1;
            }
        }
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$hashCode() {
        int primeNum = 31;
        return this.mGsmSignalStrength * primeNum + this.mGsmBitErrorRate * primeNum + this.mCdmaDbm * primeNum + this.mCdmaEcio * primeNum + this.mEvdoDbm * primeNum + this.mEvdoEcio * primeNum + this.mEvdoSnr * primeNum + this.mLteSignalStrength * primeNum + this.mLteRsrp * primeNum + this.mLteRsrq * primeNum + this.mLteRssnr * primeNum + this.mLteCqi * primeNum + this.mLteRsrpBoost * primeNum + this.mTdScdmaRscp * primeNum + this.mWcdmaSignalStrength * primeNum + this.mWcdmaRscpAsu * primeNum + this.mWcdmaRscp * primeNum + (this.mIsGsm ? 1 : 0) + (this.mUseOnlyRsrpForLteLevel ? 1 : 0) + Objects.hashCode(this.mWcdmaDefaultSignalMeasurement) + Arrays.hashCode(this.mLteRsrpThresholds) + Arrays.hashCode(this.mWcdmaRscpThresholds);
    }

    private final boolean $$robo$$android_telephony_SignalStrength$equals(Object o) {
        SignalStrength s;
        try {
            s = (SignalStrength)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mGsmSignalStrength == s.mGsmSignalStrength && this.mGsmBitErrorRate == s.mGsmBitErrorRate && this.mCdmaDbm == s.mCdmaDbm && this.mCdmaEcio == s.mCdmaEcio && this.mEvdoDbm == s.mEvdoDbm && this.mEvdoEcio == s.mEvdoEcio && this.mEvdoSnr == s.mEvdoSnr && this.mLteSignalStrength == s.mLteSignalStrength && this.mLteRsrp == s.mLteRsrp && this.mLteRsrq == s.mLteRsrq && this.mLteRssnr == s.mLteRssnr && this.mLteCqi == s.mLteCqi && this.mLteRsrpBoost == s.mLteRsrpBoost && this.mTdScdmaRscp == s.mTdScdmaRscp && this.mWcdmaSignalStrength == s.mWcdmaSignalStrength && this.mWcdmaRscpAsu == s.mWcdmaRscpAsu && this.mWcdmaRscp == s.mWcdmaRscp && this.mIsGsm == s.mIsGsm && this.mUseOnlyRsrpForLteLevel == s.mUseOnlyRsrpForLteLevel && Objects.equals(this.mWcdmaDefaultSignalMeasurement, s.mWcdmaDefaultSignalMeasurement) && Arrays.equals(this.mLteRsrpThresholds, s.mLteRsrpThresholds) && Arrays.equals(this.mWcdmaRscpThresholds, s.mWcdmaRscpThresholds);
    }

    private final String $$robo$$android_telephony_SignalStrength$toString() {
        return "SignalStrength: " + this.mGsmSignalStrength + " " + this.mGsmBitErrorRate + " " + this.mCdmaDbm + " " + this.mCdmaEcio + " " + this.mEvdoDbm + " " + this.mEvdoEcio + " " + this.mEvdoSnr + " " + this.mLteSignalStrength + " " + this.mLteRsrp + " " + this.mLteRsrq + " " + this.mLteRssnr + " " + this.mLteCqi + " " + this.mLteRsrpBoost + " " + this.mTdScdmaRscp + " " + this.mWcdmaSignalStrength + " " + this.mWcdmaRscpAsu + " " + this.mWcdmaRscp + " " + (this.mIsGsm ? "gsm|lte" : "cdma") + " " + (this.mUseOnlyRsrpForLteLevel ? "use_only_rsrp_for_lte_level" : "use_rsrp_and_rssnr_for_lte_level") + " " + this.mWcdmaDefaultSignalMeasurement + " " + Arrays.toString(this.mLteRsrpThresholds) + " " + Arrays.toString(this.mWcdmaRscpThresholds);
    }

    private final int $$robo$$android_telephony_SignalStrength$getGsmRelatedSignalStrength() {
        int level = this.getLteLevel();
        if (level == 0 && (level = this.getTdScdmaLevel()) == 0 && (level = this.getWcdmaLevel()) == 0) {
            level = this.getGsmLevel();
        }
        return level;
    }

    private final int $$robo$$android_telephony_SignalStrength$getCdmaRelatedSignalStrength() {
        int cdmaLevel = this.getCdmaLevel();
        int evdoLevel = this.getEvdoLevel();
        int level = evdoLevel == 0 ? cdmaLevel : (cdmaLevel == 0 ? evdoLevel : (cdmaLevel < evdoLevel ? cdmaLevel : evdoLevel));
        return level;
    }

    private final void $$robo$$android_telephony_SignalStrength$setFromNotifierBundle(Bundle m) {
        this.mGsmSignalStrength = m.getInt("GsmSignalStrength");
        this.mGsmBitErrorRate = m.getInt("GsmBitErrorRate");
        this.mCdmaDbm = m.getInt("CdmaDbm");
        this.mCdmaEcio = m.getInt("CdmaEcio");
        this.mEvdoDbm = m.getInt("EvdoDbm");
        this.mEvdoEcio = m.getInt("EvdoEcio");
        this.mEvdoSnr = m.getInt("EvdoSnr");
        this.mLteSignalStrength = m.getInt("LteSignalStrength");
        this.mLteRsrp = m.getInt("LteRsrp");
        this.mLteRsrq = m.getInt("LteRsrq");
        this.mLteRssnr = m.getInt("LteRssnr");
        this.mLteCqi = m.getInt("LteCqi");
        this.mLteRsrpBoost = m.getInt("LteRsrpBoost");
        this.mTdScdmaRscp = m.getInt("TdScdma");
        this.mWcdmaSignalStrength = m.getInt("WcdmaSignalStrength");
        this.mWcdmaRscpAsu = m.getInt("WcdmaRscpAsu");
        this.mWcdmaRscp = m.getInt("WcdmaRscp");
        this.mIsGsm = m.getBoolean("IsGsm");
        this.mUseOnlyRsrpForLteLevel = m.getBoolean("UseOnlyRsrpForLteLevel");
        this.mWcdmaDefaultSignalMeasurement = m.getString("WcdmaDefaultSignalMeasurement");
        ArrayList<Integer> lteRsrpThresholds = m.getIntegerArrayList("lteRsrpThresholds");
        for (int i = 0; i < lteRsrpThresholds.size(); ++i) {
            this.mLteRsrpThresholds[i] = lteRsrpThresholds.get(i);
        }
        ArrayList<Integer> wcdmaRscpThresholds = m.getIntegerArrayList("wcdmaRscpThresholds");
        for (int i = 0; i < wcdmaRscpThresholds.size(); ++i) {
            this.mWcdmaRscpThresholds[i] = wcdmaRscpThresholds.get(i);
        }
    }

    private final void $$robo$$android_telephony_SignalStrength$fillInNotifierBundle(Bundle m) {
        m.putInt("GsmSignalStrength", this.mGsmSignalStrength);
        m.putInt("GsmBitErrorRate", this.mGsmBitErrorRate);
        m.putInt("CdmaDbm", this.mCdmaDbm);
        m.putInt("CdmaEcio", this.mCdmaEcio);
        m.putInt("EvdoDbm", this.mEvdoDbm);
        m.putInt("EvdoEcio", this.mEvdoEcio);
        m.putInt("EvdoSnr", this.mEvdoSnr);
        m.putInt("LteSignalStrength", this.mLteSignalStrength);
        m.putInt("LteRsrp", this.mLteRsrp);
        m.putInt("LteRsrq", this.mLteRsrq);
        m.putInt("LteRssnr", this.mLteRssnr);
        m.putInt("LteCqi", this.mLteCqi);
        m.putInt("LteRsrpBoost", this.mLteRsrpBoost);
        m.putInt("TdScdma", this.mTdScdmaRscp);
        m.putInt("WcdmaSignalStrength", this.mWcdmaSignalStrength);
        m.putInt("WcdmaRscpAsu", this.mWcdmaRscpAsu);
        m.putInt("WcdmaRscp", this.mWcdmaRscp);
        m.putBoolean("IsGsm", this.mIsGsm);
        m.putBoolean("UseOnlyRsrpForLteLevel", this.mUseOnlyRsrpForLteLevel);
        m.putString("WcdmaDefaultSignalMeasurement", this.mWcdmaDefaultSignalMeasurement);
        ArrayList<Integer> lteRsrpThresholds = new ArrayList<Integer>();
        for (int value : this.mLteRsrpThresholds) {
            lteRsrpThresholds.add(value);
        }
        m.putIntegerArrayList("lteRsrpThresholds", lteRsrpThresholds);
        ArrayList<Integer> wcdmaRscpThresholds = new ArrayList<Integer>();
        for (int value : this.mWcdmaRscpThresholds) {
            wcdmaRscpThresholds.add(value);
        }
        m.putIntegerArrayList("wcdmaRscpThresholds", wcdmaRscpThresholds);
    }

    private final int[] $$robo$$android_telephony_SignalStrength$getDefaultLteRsrpThresholds() {
        return CarrierConfigManager.getDefaultConfig().getIntArray("lte_rsrp_thresholds_int_array");
    }

    private final int[] $$robo$$android_telephony_SignalStrength$getDefaultWcdmaRscpThresholds() {
        return CarrierConfigManager.getDefaultConfig().getIntArray("wcdma_rscp_thresholds_int_array");
    }

    private static final void $$robo$$android_telephony_SignalStrength$log(String s) {
        Rlog.w("SignalStrength", s);
    }

    static void __staticInitializer__() {
        SIGNAL_STRENGTH_NAMES = new String[]{"none", "poor", "moderate", "good", "great"};
        CREATOR = new Parcelable.Creator(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_SignalStrength_1$__constructor__() {
            }

            private final SignalStrength $$robo$$android_telephony_SignalStrength_1$createFromParcel(Parcel in) {
                return new SignalStrength(in);
            }

            private final SignalStrength[] $$robo$$android_telephony_SignalStrength_1$newArray(int size) {
                return new SignalStrength[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_SignalStrength_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength_1$__constructor__(), 0, this);
            }

            public SignalStrength createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_SignalStrength_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public SignalStrength[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_SignalStrength_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static SignalStrength newFromBundle(Bundle bundle) {
        return InvokeDynamicSupport.bootstrapStatic("newFromBundle", $$robo$$android_telephony_SignalStrength$newFromBundle(android.os.Bundle ), 0, (Bundle)bundle);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_SignalStrength$__constructor__();
    }

    public SignalStrength() {
        this(true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(), 0, this);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(bl);
    }

    public SignalStrength(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(boolean ), 0, this, bl);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, boolean bl, boolean bl2, String string2) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, bl, bl2, string2);
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, boolean bl, boolean bl2, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(int int int int int int int int int int int int int int int int boolean boolean java.lang.String ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, bl, bl2, string2);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        this(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, 99, Integer.MAX_VALUE, 0, true, false, "");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(int int int int int int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13);
    }

    private void __constructor__(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15);
    }

    public SignalStrength(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        this(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, 0, true, false, "");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(int int int int int int int int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15);
    }

    private void __constructor__(SignalStrength signalStrength) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(signalStrength);
    }

    public SignalStrength(SignalStrength signalStrength) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(android.telephony.SignalStrength ), 0, this, signalStrength);
    }

    protected void copyFrom(SignalStrength signalStrength) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_telephony_SignalStrength$copyFrom(android.telephony.SignalStrength ), 0, this, signalStrength);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_SignalStrength$__constructor__(parcel);
    }

    public SignalStrength(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SignalStrength$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_SignalStrength$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_SignalStrength$describeContents(), 0, this);
    }

    public void validateInput() {
        InvokeDynamicSupport.bootstrap("validateInput", $$robo$$android_telephony_SignalStrength$validateInput(), 0, this);
    }

    public void fixType() {
        InvokeDynamicSupport.bootstrap("fixType", $$robo$$android_telephony_SignalStrength$fixType(), 0, this);
    }

    public void setGsm(boolean bl) {
        InvokeDynamicSupport.bootstrap("setGsm", $$robo$$android_telephony_SignalStrength$setGsm(boolean ), 0, this, bl);
    }

    public void setUseOnlyRsrpForLteLevel(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUseOnlyRsrpForLteLevel", $$robo$$android_telephony_SignalStrength$setUseOnlyRsrpForLteLevel(boolean ), 0, this, bl);
    }

    public void setWcdmaDefaultSignalMeasurement(String string2) {
        InvokeDynamicSupport.bootstrap("setWcdmaDefaultSignalMeasurement", $$robo$$android_telephony_SignalStrength$setWcdmaDefaultSignalMeasurement(java.lang.String ), 0, this, string2);
    }

    public void setLteRsrpBoost(int n) {
        InvokeDynamicSupport.bootstrap("setLteRsrpBoost", $$robo$$android_telephony_SignalStrength$setLteRsrpBoost(int ), 0, this, n);
    }

    public void setLteRsrpThresholds(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setLteRsrpThresholds", $$robo$$android_telephony_SignalStrength$setLteRsrpThresholds(int[] ), 0, this, nArray);
    }

    public int getGsmSignalStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmSignalStrength", $$robo$$android_telephony_SignalStrength$getGsmSignalStrength(), 0, this);
    }

    public int getGsmBitErrorRate() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmBitErrorRate", $$robo$$android_telephony_SignalStrength$getGsmBitErrorRate(), 0, this);
    }

    public void setWcdmaRscpThresholds(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setWcdmaRscpThresholds", $$robo$$android_telephony_SignalStrength$setWcdmaRscpThresholds(int[] ), 0, this, nArray);
    }

    public int getCdmaDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaDbm", $$robo$$android_telephony_SignalStrength$getCdmaDbm(), 0, this);
    }

    public int getCdmaEcio() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEcio", $$robo$$android_telephony_SignalStrength$getCdmaEcio(), 0, this);
    }

    public int getEvdoDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoDbm", $$robo$$android_telephony_SignalStrength$getEvdoDbm(), 0, this);
    }

    public int getEvdoEcio() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoEcio", $$robo$$android_telephony_SignalStrength$getEvdoEcio(), 0, this);
    }

    public int getEvdoSnr() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoSnr", $$robo$$android_telephony_SignalStrength$getEvdoSnr(), 0, this);
    }

    public int getLteSignalStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getLteSignalStrength", $$robo$$android_telephony_SignalStrength$getLteSignalStrength(), 0, this);
    }

    public int getLteRsrp() {
        return (int)InvokeDynamicSupport.bootstrap("getLteRsrp", $$robo$$android_telephony_SignalStrength$getLteRsrp(), 0, this);
    }

    public int getLteRsrq() {
        return (int)InvokeDynamicSupport.bootstrap("getLteRsrq", $$robo$$android_telephony_SignalStrength$getLteRsrq(), 0, this);
    }

    public int getLteRssnr() {
        return (int)InvokeDynamicSupport.bootstrap("getLteRssnr", $$robo$$android_telephony_SignalStrength$getLteRssnr(), 0, this);
    }

    public int getLteCqi() {
        return (int)InvokeDynamicSupport.bootstrap("getLteCqi", $$robo$$android_telephony_SignalStrength$getLteCqi(), 0, this);
    }

    public int getLteRsrpBoost() {
        return (int)InvokeDynamicSupport.bootstrap("getLteRsrpBoost", $$robo$$android_telephony_SignalStrength$getLteRsrpBoost(), 0, this);
    }

    public int getLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getLevel", $$robo$$android_telephony_SignalStrength$getLevel(), 0, this);
    }

    public int getAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getAsuLevel", $$robo$$android_telephony_SignalStrength$getAsuLevel(), 0, this);
    }

    public int getDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getDbm", $$robo$$android_telephony_SignalStrength$getDbm(), 0, this);
    }

    public int getGsmDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmDbm", $$robo$$android_telephony_SignalStrength$getGsmDbm(), 0, this);
    }

    public int getGsmLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmLevel", $$robo$$android_telephony_SignalStrength$getGsmLevel(), 0, this);
    }

    public int getGsmAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmAsuLevel", $$robo$$android_telephony_SignalStrength$getGsmAsuLevel(), 0, this);
    }

    public int getCdmaLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaLevel", $$robo$$android_telephony_SignalStrength$getCdmaLevel(), 0, this);
    }

    public int getCdmaAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaAsuLevel", $$robo$$android_telephony_SignalStrength$getCdmaAsuLevel(), 0, this);
    }

    public int getEvdoLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoLevel", $$robo$$android_telephony_SignalStrength$getEvdoLevel(), 0, this);
    }

    public int getEvdoAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getEvdoAsuLevel", $$robo$$android_telephony_SignalStrength$getEvdoAsuLevel(), 0, this);
    }

    public int getLteDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getLteDbm", $$robo$$android_telephony_SignalStrength$getLteDbm(), 0, this);
    }

    public int getLteLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getLteLevel", $$robo$$android_telephony_SignalStrength$getLteLevel(), 0, this);
    }

    public int getLteAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getLteAsuLevel", $$robo$$android_telephony_SignalStrength$getLteAsuLevel(), 0, this);
    }

    public boolean isGsm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGsm", $$robo$$android_telephony_SignalStrength$isGsm(), 0, this);
    }

    public boolean useOnlyRsrpForLteLevel() {
        return (boolean)InvokeDynamicSupport.bootstrap("useOnlyRsrpForLteLevel", $$robo$$android_telephony_SignalStrength$useOnlyRsrpForLteLevel(), 0, this);
    }

    public int getTdScdmaDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getTdScdmaDbm", $$robo$$android_telephony_SignalStrength$getTdScdmaDbm(), 0, this);
    }

    public int getTdScdmaLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getTdScdmaLevel", $$robo$$android_telephony_SignalStrength$getTdScdmaLevel(), 0, this);
    }

    public int getTdScdmaAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getTdScdmaAsuLevel", $$robo$$android_telephony_SignalStrength$getTdScdmaAsuLevel(), 0, this);
    }

    public int getWcdmaRscp() {
        return (int)InvokeDynamicSupport.bootstrap("getWcdmaRscp", $$robo$$android_telephony_SignalStrength$getWcdmaRscp(), 0, this);
    }

    public int getWcdmaAsuLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getWcdmaAsuLevel", $$robo$$android_telephony_SignalStrength$getWcdmaAsuLevel(), 0, this);
    }

    public int getWcdmaDbm() {
        return (int)InvokeDynamicSupport.bootstrap("getWcdmaDbm", $$robo$$android_telephony_SignalStrength$getWcdmaDbm(), 0, this);
    }

    public int getWcdmaLevel() {
        return (int)InvokeDynamicSupport.bootstrap("getWcdmaLevel", $$robo$$android_telephony_SignalStrength$getWcdmaLevel(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_SignalStrength$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_SignalStrength$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_SignalStrength$toString(), 0, this);
    }

    private int getGsmRelatedSignalStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getGsmRelatedSignalStrength", $$robo$$android_telephony_SignalStrength$getGsmRelatedSignalStrength(), 0, this);
    }

    private int getCdmaRelatedSignalStrength() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaRelatedSignalStrength", $$robo$$android_telephony_SignalStrength$getCdmaRelatedSignalStrength(), 0, this);
    }

    private void setFromNotifierBundle(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setFromNotifierBundle", $$robo$$android_telephony_SignalStrength$setFromNotifierBundle(android.os.Bundle ), 0, this, bundle);
    }

    public void fillInNotifierBundle(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("fillInNotifierBundle", $$robo$$android_telephony_SignalStrength$fillInNotifierBundle(android.os.Bundle ), 0, this, bundle);
    }

    private int[] getDefaultLteRsrpThresholds() {
        return InvokeDynamicSupport.bootstrap("getDefaultLteRsrpThresholds", $$robo$$android_telephony_SignalStrength$getDefaultLteRsrpThresholds(), 0, this);
    }

    private int[] getDefaultWcdmaRscpThresholds() {
        return InvokeDynamicSupport.bootstrap("getDefaultWcdmaRscpThresholds", $$robo$$android_telephony_SignalStrength$getDefaultWcdmaRscpThresholds(), 0, this);
    }

    private static void log(String string2) {
        InvokeDynamicSupport.bootstrapStatic("log", $$robo$$android_telephony_SignalStrength$log(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(SignalStrength.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SignalStrength)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

